/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.blocks.RightCurlyOption;

public class RightCurlyCheck
extends AbstractOptionCheck<RightCurlyOption> {
    private boolean shouldStartLine = true;
    public static final String MSG_KEY_LINE_BREAK_BEFORE = "line.break.before";
    public static final String MSG_KEY_LINE_ALONE = "line.alone";
    public static final String MSG_KEY_LINE_SAME = "line.same";
    public static final String MSG_KEY_LINE_NEW = "line.new";

    public RightCurlyCheck() {
        super(RightCurlyOption.SAME, RightCurlyOption.class);
    }

    public void setShouldStartLine(boolean flag) {
        this.shouldStartLine = flag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{95, 96, 97, 83, 92};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{95, 96, 97, 83, 92, 14, 9, 8, 91, 84, 85, 12, 11};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST rcurly;
        DetailAST nextToken;
        DetailAST lcurly;
        boolean shouldCheckLastRcurly = false;
        switch (ast.getType()) {
            case 95: {
                lcurly = ast.getFirstChild();
                nextToken = lcurly.getNextSibling();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 96: {
                nextToken = ast.getNextSibling();
                lcurly = ast.getLastChild();
                rcurly = lcurly.getLastChild();
                if (nextToken != null) break;
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(ast);
                break;
            }
            case 83: {
                nextToken = ast.findFirstToken(92);
                if (nextToken != null) {
                    lcurly = nextToken.getPreviousSibling();
                    rcurly = lcurly.getLastChild();
                    break;
                }
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(ast);
                lcurly = ast.getLastChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 92: {
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(ast);
                lcurly = ast.getFirstChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 97: {
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(ast);
                lcurly = ast.getFirstChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 14: {
                DetailAST child = ast.getLastChild();
                lcurly = child.getFirstChild();
                rcurly = child.getLastChild();
                nextToken = ast;
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                lcurly = ast.findFirstToken(7);
                rcurly = lcurly.getLastChild();
                nextToken = ast;
                break;
            }
            case 9: 
            case 84: 
            case 85: 
            case 91: {
                lcurly = ast.findFirstToken(7);
                if (lcurly == null) {
                    return;
                }
                rcurly = lcurly.getLastChild();
                nextToken = ast;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected token type (" + TokenTypes.getTokenName(ast.getType()) + ")");
            }
        }
        if (rcurly == null || rcurly.getType() != 73) {
            return;
        }
        if (this.getAbstractOption() == RightCurlyOption.SAME && !this.hasLineBreakBefore(rcurly)) {
            this.log(rcurly, MSG_KEY_LINE_BREAK_BEFORE, new Object[0]);
        }
        if (shouldCheckLastRcurly) {
            if (rcurly.getLineNo() == nextToken.getLineNo()) {
                this.log(rcurly, MSG_KEY_LINE_ALONE, "}");
            }
        } else if (this.getAbstractOption() == RightCurlyOption.SAME && rcurly.getLineNo() != nextToken.getLineNo()) {
            this.log(rcurly, MSG_KEY_LINE_SAME, "}");
        } else if (this.getAbstractOption() == RightCurlyOption.ALONE && rcurly.getLineNo() == nextToken.getLineNo() && !this.isEmptyBody(lcurly)) {
            this.log(rcurly, MSG_KEY_LINE_ALONE, "}");
        }
        if (!this.shouldStartLine) {
            return;
        }
        boolean startsLine = Utils.whitespaceBefore(rcurly.getColumnNo(), this.getLines()[rcurly.getLineNo() - 1]);
        if (!startsLine && lcurly.getLineNo() != rcurly.getLineNo()) {
            this.log(rcurly, MSG_KEY_LINE_NEW, "}");
        }
    }

    private boolean isEmptyBody(DetailAST lcurly) {
        boolean result = false;
        if (lcurly.getParent().getType() == 6) {
            if (lcurly.getNextSibling().getType() == 73) {
                result = true;
            }
        } else if (lcurly.getFirstChild().getType() == 73) {
            result = true;
        }
        return result;
    }

    private DetailAST getNextToken(DetailAST ast) {
        DetailAST next = null;
        for (DetailAST parent = ast; parent != null && next == null; parent = parent.getParent()) {
            next = parent.getNextSibling();
        }
        return CheckUtils.getFirstNode(next);
    }

    private boolean hasLineBreakBefore(DetailAST rightCurly) {
        DetailAST previousToken;
        return rightCurly == null || (previousToken = rightCurly.getPreviousSibling()) == null || rightCurly.getLineNo() != previousToken.getLineNo();
    }
}

