// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_SUGGESTION_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_SUGGESTION_H_

#include <string>

#include "base/strings/string16.h"
#include "ui/gfx/image/image.h"

namespace autofill {

struct Suggestion {
  enum MatchMode {
    PREFIX_MATCH,    // for prefix matched suggestions;
    SUBSTRING_MATCH  // for substring matched suggestions;
  };

  Suggestion();

  // Copy constructor for STL containers.
  Suggestion(const Suggestion& other);

  explicit Suggestion(const base::string16& value);

  // Constructor for unit tests. It will convert the strings from UTF-8 to
  // UTF-16.
  Suggestion(const std::string& value,
             const std::string& label,
             const std::string& icon,
             int frontend_id);

  ~Suggestion();

  // GUID generated by the backend layer. This identifies the exact autofill
  // profile that generated this suggestion.
  std::string backend_id;

  // ID for the frontend to use in identifying the particular result. Positive
  // values are sent over IPC to identify the item selected. Negative values
  // (see popup_item_ids.h) have special built-in meanings. Default initialized
  // to 0.
  int frontend_id;

  base::string16 value;
  base::string16 label;
  // Used only for passwords to show the password value.
  // Also used to display an extra line of information if two line
  // display is enabled.
  base::string16 additional_label;
  // Contains an image to display for the suggestion.
  gfx::Image custom_icon;
  // If |custom_icon| is empty, the name of the fallback built-in icon.
  base::string16 icon;
  MatchMode match;
  bool is_value_secondary;  // |value| should be displayed as secondary text.
};

}  // namespace autofill

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_SUGGESTION_H_
