// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/css/properties/longhands/webkit_text_orientation.h"

#include "third_party/blink/renderer/core/style/computed_style.h"

namespace blink {
namespace CSSLonghand {

const CSSValue* WebkitTextOrientation::CSSValueFromComputedStyleInternal(
    const ComputedStyle& style,
    const SVGComputedStyle&,
    const LayoutObject*,
    Node* styled_node,
    bool allow_visited_style) const {
  if (style.GetTextOrientation() == ETextOrientation::kMixed)
    return CSSIdentifierValue::Create(CSSValueVerticalRight);
  return CSSIdentifierValue::Create(style.GetTextOrientation());
}

void WebkitTextOrientation::ApplyValue(StyleResolverState& state,
                                       const CSSValue& value) const {
  state.SetTextOrientation(
      ToCSSIdentifierValue(value).ConvertTo<ETextOrientation>());
}

}  // namespace CSSLonghand
}  // namespace blink
