// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/feature_engagement_tracker/internal/once_condition_validator.h"

#include "components/feature_engagement_tracker/internal/configuration.h"
#include "components/feature_engagement_tracker/internal/model.h"

namespace feature_engagement_tracker {

OnceConditionValidator::OnceConditionValidator() = default;

OnceConditionValidator::~OnceConditionValidator() = default;

ConditionValidator::Result OnceConditionValidator::MeetsConditions(
    const base::Feature& feature,
    const FeatureConfig& config,
    const Model& model,
    const AvailabilityModel& availability_model,
    uint32_t current_day) const {
  ConditionValidator::Result result(true);
  result.event_model_ready_ok = model.IsReady();

  result.currently_showing_ok = currently_showing_feature_.empty();

  result.config_ok = config.valid;

  result.session_rate_ok =
      shown_features_.find(feature.name) == shown_features_.end();

  return result;
}

void OnceConditionValidator::NotifyIsShowing(const base::Feature& feature) {
  DCHECK(currently_showing_feature_.empty());
  DCHECK(shown_features_.find(feature.name) == shown_features_.end());
  shown_features_.insert(feature.name);
  currently_showing_feature_ = feature.name;
}

void OnceConditionValidator::NotifyDismissed(const base::Feature& feature) {
  DCHECK(feature.name == currently_showing_feature_);
  currently_showing_feature_.clear();
}

}  // namespace feature_engagement_tracker
