/****************************************************************************
**
** Copyright (C) 2014 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.1

Rectangle {
    id: root
    color: "transparent"
    radius: 5
    property alias value: grip.value
    property color fillColor: "#14aaff"
    property real gripSize: 40
    property real gripTolerance: 3.0
    property real increment: 0.1
    property bool enabled: true

    Rectangle {
        id: slider
        anchors {
            left: parent.left
            right: parent.right
            verticalCenter: parent.verticalCenter
        }
        height: 10
        color: "transparent"

        BorderImage {
           id: sliderbarimage
           source: "qrc:/images/Slider_bar.png"
           anchors { fill: parent; margins: 1 }
           border.right: 5
           border.left: 5
        }
        Rectangle {
            height: parent.height -2
            anchors.left: parent.left
            anchors.right: grip.horizontalCenter
            color: root.fillColor
            radius: 3
            border.width: 1
            border.color: Qt.darker(color, 1.3)
            opacity: 0.8
        }
        Rectangle {
            id: grip
            property real value: 0.5
            x: (value * parent.width) - width/2
            anchors.verticalCenter: parent.verticalCenter
            width: root.gripTolerance * root.gripSize
            height: width
            radius: width/2
            color: "transparent"

            Image {
                id: sliderhandleimage
                source: "qrc:/images/Slider_handle.png"
                anchors.centerIn: parent
            }

            MouseArea {
                id: mouseArea
                enabled: root.enabled
                anchors.fill:  parent
                drag {
                    target: grip
                    axis: Drag.XAxis
                    minimumX: -parent.width/2
                    maximumX: root.width - parent.width/2
                }
                onPositionChanged:  {
                    if (drag.active)
                        updatePosition()
                }
                onReleased: {
                    updatePosition()
                }
                function updatePosition() {
                    value = (grip.x + grip.width/2) / slider.width
                }
            }
        }

    }
}
