/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtCanvas3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL3$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPLv3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or later as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file. Please review the following information to
** ensure the GNU General Public License version 2.0 requirements will be
** met: http://www.gnu.org/licenses/gpl-2.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "renderbuffer3d_p.h"

QT_BEGIN_NAMESPACE
QT_CANVAS3D_BEGIN_NAMESPACE

/*!
 * \qmltype Canvas3DRenderBuffer
 * \since QtCanvas3D 1.0
 * \inqmlmodule QtCanvas3D
 * \inherits Canvas3DAbstractObject
 * \brief Contains an OpenGL renderbuffer.
 *
 * An uncreatable QML type that contains an OpenGL renderbuffer. You can get it by calling
 * the \l{Context3D::createRenderbuffer()}{Context3D.createRenderbuffer()} method.
 */

CanvasRenderBuffer::CanvasRenderBuffer(CanvasGlCommandQueue *queue,
                                       bool initSecondaryId, QObject *parent) :
    CanvasAbstractObject(queue, parent),
    m_renderbufferId(queue->createResourceId()),
    m_secondaryId(0)
{
    queueCommand(CanvasGlCommandQueue::glGenRenderbuffers, m_renderbufferId);
    if (initSecondaryId) {
        m_secondaryId = queue->createResourceId();
        queueCommand(CanvasGlCommandQueue::glGenRenderbuffers, m_secondaryId);
    }
}


CanvasRenderBuffer::~CanvasRenderBuffer()
{
    del();
}

bool CanvasRenderBuffer::isAlive()
{
    return bool(m_renderbufferId);
}

void CanvasRenderBuffer::del()
{
    if (m_renderbufferId) {
        queueCommand(CanvasGlCommandQueue::glDeleteRenderbuffers, m_renderbufferId);
        if (m_secondaryId) {
            queueCommand(CanvasGlCommandQueue::glDeleteRenderbuffers, m_secondaryId);
            m_secondaryId = 0;
        }
        m_renderbufferId = 0;
    }
}

GLint CanvasRenderBuffer::id()
{
    return m_renderbufferId;
}

GLint CanvasRenderBuffer::secondaryId()
{
    return m_secondaryId;
}

QT_CANVAS3D_END_NAMESPACE
QT_END_NAMESPACE
