#include "applicationui.h"

#include <bb/cascades/Application>
#include <bb/cascades/QmlDocument>
#include <bb/cascades/AbstractPane>

using namespace bb::cascades;

ApplicationUI::ApplicationUI(Application *app) :
        QObject(app)
{
    // By default the QmlDocument object is owned by the Application instance
    // and will have the lifespan of the application
    QmlDocument *qml = QmlDocument::create("asset:///main.qml");

    // Create root object for the UI
    AbstractPane *root = qml->createRootObject<AbstractPane>();

    // Set created root object as the application scene
    app->setScene(root);
}

