/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLLinkElement.h"

#include "HTMLLinkElement.h"
#include "HTMLNames.h"
#include "JSStyleSheet.h"
#include "KURL.h"
#include "StyleSheet.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLLinkElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLLinkElementTableValues[12] =
{
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementDisabled), (intptr_t)setJSHTMLLinkElementDisabled THUNK_GENERATOR(0) },
    { "charset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementCharset), (intptr_t)setJSHTMLLinkElementCharset THUNK_GENERATOR(0) },
    { "href", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementHref), (intptr_t)setJSHTMLLinkElementHref THUNK_GENERATOR(0) },
    { "hreflang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementHreflang), (intptr_t)setJSHTMLLinkElementHreflang THUNK_GENERATOR(0) },
    { "media", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementMedia), (intptr_t)setJSHTMLLinkElementMedia THUNK_GENERATOR(0) },
    { "rel", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementRel), (intptr_t)setJSHTMLLinkElementRel THUNK_GENERATOR(0) },
    { "rev", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementRev), (intptr_t)setJSHTMLLinkElementRev THUNK_GENERATOR(0) },
    { "target", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementTarget), (intptr_t)setJSHTMLLinkElementTarget THUNK_GENERATOR(0) },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementType), (intptr_t)setJSHTMLLinkElementType THUNK_GENERATOR(0) },
    { "sheet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementSheet), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLinkElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLLinkElementTable = { 33, 31, JSHTMLLinkElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLLinkElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLLinkElementConstructorTable = { 1, 0, JSHTMLLinkElementConstructorTableValues, 0 };
class JSHTMLLinkElementConstructor : public DOMConstructorObject {
public:
    JSHTMLLinkElementConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLLinkElementConstructor::s_info = { "HTMLLinkElementConstructor", &DOMConstructorObject::s_info, &JSHTMLLinkElementConstructorTable, 0 };

JSHTMLLinkElementConstructor::JSHTMLLinkElementConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLLinkElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLLinkElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLinkElementConstructor, JSDOMWrapper>(exec, &JSHTMLLinkElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLLinkElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLLinkElementConstructor, JSDOMWrapper>(exec, &JSHTMLLinkElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLLinkElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLLinkElementPrototypeTable = { 1, 0, JSHTMLLinkElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLLinkElementPrototype::s_info = { "HTMLLinkElementPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSHTMLLinkElementPrototypeTable, 0 };

JSObject* JSHTMLLinkElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLLinkElement>(exec, globalObject);
}

const ClassInfo JSHTMLLinkElement::s_info = { "HTMLLinkElement", &JSHTMLElement::s_info, &JSHTMLLinkElementTable, 0 };

JSHTMLLinkElement::JSHTMLLinkElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLLinkElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLLinkElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLLinkElementPrototype(exec->globalData(), globalObject, JSHTMLLinkElementPrototype::createStructure(exec->globalData(), JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLLinkElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLinkElement, Base>(exec, &JSHTMLLinkElementTable, this, propertyName, slot);
}

bool JSHTMLLinkElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLLinkElement, Base>(exec, &JSHTMLLinkElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLLinkElementDisabled(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->disabled());
    return result;
}


JSValue jsHTMLLinkElementCharset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::charsetAttr));
    return result;
}


JSValue jsHTMLLinkElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return result;
}


JSValue jsHTMLLinkElementHreflang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::hreflangAttr));
    return result;
}


JSValue jsHTMLLinkElementMedia(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::mediaAttr));
    return result;
}


JSValue jsHTMLLinkElementRel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::relAttr));
    return result;
}


JSValue jsHTMLLinkElementRev(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::revAttr));
    return result;
}


JSValue jsHTMLLinkElementTarget(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}


JSValue jsHTMLLinkElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLLinkElementSheet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->sheet()));
    return result;
}


JSValue jsHTMLLinkElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLinkElement* domObject = static_cast<JSHTMLLinkElement*>(asObject(slotBase));
    return JSHTMLLinkElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLLinkElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLLinkElement, Base>(exec, propertyName, value, &JSHTMLLinkElementTable, this, slot);
}

void setJSHTMLLinkElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setDisabled(value.toBoolean(exec));
}


void setJSHTMLLinkElementCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::charsetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLinkElementHref(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::hrefAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLinkElementHreflang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::hreflangAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLinkElementMedia(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::mediaAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLinkElementRel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::relAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLinkElementRev(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::revAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLinkElementTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::targetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLinkElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLinkElement* castedThis = static_cast<JSHTMLLinkElement*>(thisObject);
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLLinkElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLLinkElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
