/****************************************************************************
**
** Definition of QObjectList
**
** Created : 940807
**
** Copyright (C) 1992-2008 Trolltech ASA.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
** Alternatively you may (at your option) use any later version
** of the GNU General Public License if such license has been
** publicly approved by Trolltech ASA (or its successors, if any)
** and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/.
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** This file may be used under the terms of the Q Public License as
** defined by Trolltech ASA and appearing in the file LICENSE.QPL
** included in the packaging of this file.  Licensees holding valid Qt
** Commercial licenses may use this file in accordance with the Qt
** Commercial License Agreement provided with the Software.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#ifndef QOBJECTLIST_H
#define QOBJECTLIST_H

#ifndef QT_H
#include "qobject.h"
#include "qptrlist.h"
#endif // QT_H


#if defined(Q_TEMPLATEDLL)
//Q_TEMPLATE_EXTERN template class Q_EXPORT QPtrList<QObject>;
//Q_TEMPLATE_EXTERN template class Q_EXPORT QPtrListIterator<QObject>;
#endif


class Q_EXPORT QObjectList : public QPtrList<QObject>
{
public:
    QObjectList() : QPtrList<QObject>() {}
    QObjectList( const QObjectList &list ) : QPtrList<QObject>(list) {}
   ~QObjectList() { clear(); }
    QObjectList &operator=(const QObjectList &list)
	{ return (QObjectList&)QPtrList<QObject>::operator=(list); }
};

class Q_EXPORT QObjectListIterator : public QPtrListIterator<QObject>
{
public:
    QObjectListIterator( const QObjectList &l )
	: QPtrListIterator<QObject>( l ) { }
    QObjectListIterator &operator=( const QObjectListIterator &i )
	{ return (QObjectListIterator&)
		 QPtrListIterator<QObject>::operator=( i ); }
};

#if (QT_VERSION-0 >= 0x040000)
#if defined(Q_CC_GNU)
#warning "remove the QObjectListIt class"
#warning "remove the typedef too, maybe"
#endif
typedef QObjectListIterator QObjectListIt;
#else
class Q_EXPORT QObjectListIt : public QPtrListIterator<QObject>
{
public:
    QObjectListIt( const QObjectList &l ) : QPtrListIterator<QObject>(l) {}
    QObjectListIt &operator=(const QObjectListIt &i)
	{ return (QObjectListIt&)QPtrListIterator<QObject>::operator=(i); }
};
#endif

#endif // QOBJECTLIST_H
