/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_RETURN = 258,
     TOK_RETURNS = 259,
     TOK_THREAD_LOCAL = 260,
     TOK_MY = 261,
     TOK_DO = 262,
     TOK_TRY = 263,
     TOK_THROW = 264,
     TOK_CATCH = 265,
     TOK_WHERE = 266,
     TOK_WHILE = 267,
     TOK_IF = 268,
     TOK_FOR = 269,
     TOK_SUB = 270,
     TOK_THREAD_EXIT = 271,
     TOK_BREAK = 272,
     TOK_CONTINUE = 273,
     TOK_CONTEXT_ROW = 274,
     TOK_FIND = 275,
     TOK_FOREACH = 276,
     TOK_IN = 277,
     TOK_DELETE = 278,
     TOK_REMOVE = 279,
     TOK_PRIVATE = 280,
     TOK_PRIVATEINTERNAL = 281,
     TOK_PRIVATEHIERARCHY = 282,
     TOK_PUBLIC = 283,
     TOK_SYNCHRONIZED = 284,
     TOK_DEPRECATED = 285,
     TOK_CONTEXT = 286,
     TOK_SORT_BY = 287,
     TOK_SORT_DESCENDING_BY = 288,
     TOK_SUB_CONTEXT = 289,
     TOK_CONST = 290,
     TOK_SUMMARIZE = 291,
     TOK_BY = 292,
     TOK_OUR = 293,
     TOK_RETHROW = 294,
     TOK_SWITCH = 295,
     TOK_CASE = 296,
     TOK_DEFAULT = 297,
     TOK_INHERITS = 298,
     TOK_ELSE = 299,
     TOK_STATIC = 300,
     TOK_NAMESPACE = 301,
     TOK_MODULE = 302,
     TOK_FINAL = 303,
     TOK_ABSTRACT = 304,
     TOK_HASHDECL = 305,
     TOK_TRANSIENT = 306,
     TOK_NULL = 307,
     TOK_NOTHING = 308,
     TOK_TRUE = 309,
     TOK_FALSE = 310,
     TOK_UNREFERENCE = 311,
     P_INCREMENT = 312,
     P_DECREMENT = 313,
     PLUS_EQUALS = 314,
     MINUS_EQUALS = 315,
     AND_EQUALS = 316,
     OR_EQUALS = 317,
     MODULA_EQUALS = 318,
     MULTIPLY_EQUALS = 319,
     DIVIDE_EQUALS = 320,
     XOR_EQUALS = 321,
     SHIFT_LEFT_EQUALS = 322,
     SHIFT_RIGHT_EQUALS = 323,
     TOK_UNSHIFT = 324,
     TOK_PUSH = 325,
     TOK_POP = 326,
     TOK_SHIFT = 327,
     TOK_CHOMP = 328,
     TOK_TRIM = 329,
     LOGICAL_AND = 330,
     LOGICAL_OR = 331,
     BROKEN_LOGICAL_OR = 332,
     BROKEN_BINARY_OR = 333,
     BROKEN_BINARY_XOR = 334,
     LOGICAL_EQ = 335,
     LOGICAL_NE = 336,
     LOGICAL_LE = 337,
     LOGICAL_GE = 338,
     LOGICAL_CMP = 339,
     ABSOLUTE_EQ = 340,
     ABSOLUTE_NE = 341,
     REGEX_MATCH = 342,
     REGEX_NMATCH = 343,
     TOK_EXISTS = 344,
     TOK_INSTANCEOF = 345,
     SHIFT_RIGHT = 346,
     SHIFT_LEFT = 347,
     TOK_ELEMENTS = 348,
     TOK_KEYS = 349,
     TOK_NEW = 350,
     TOK_BACKGROUND = 351,
     TOK_ON_EXIT = 352,
     TOK_ON_SUCCESS = 353,
     TOK_ON_ERROR = 354,
     TOK_MAP = 355,
     TOK_FOLDR = 356,
     TOK_FOLDL = 357,
     TOK_SELECT = 358,
     TOK_SPLICE = 359,
     TOK_EXTRACT = 360,
     IMPLICIT_ELEMENT = 361,
     NULL_COALESCING = 362,
     VALUE_COALESCING = 363,
     WEAK_ASSIGNMENT = 364,
     RANGE = 365,
     INTEGER = 366,
     QFLOAT = 367,
     NUMBER = 368,
     IDENTIFIER = 369,
     HASHDECL_IDENTIFIER_OPENCURLY = 370,
     ANGLE_IDENTIFIER = 371,
     VAR_REF = 372,
     BACKQUOTE = 373,
     SELF_REF = 374,
     KW_IDENTIFIER_OPENPAREN = 375,
     SCOPED_REF = 376,
     SCOPED_VREF = 377,
     CONTEXT_REF = 378,
     COMPLEX_CONTEXT_REF = 379,
     QORE_CAST = 380,
     QORE_OR_NOTHING_CAST = 381,
     CLASS_STRING = 382,
     DATETIME = 383,
     QUOTED_WORD = 384,
     BINARY = 385,
     REGEX_SUBST = 386,
     REGEX_TRANS = 387,
     CLASS_SCOPED_REF = 388,
     BASE_CLASS_CALL = 389,
     REGEX = 390,
     REGEX_EXTRACT = 391,
     IMPLICIT_ARG_REF = 392,
     DOT_KW_IDENTIFIER = 393,
     TRY_MODULE_ERROR = 394,
     IFX = 395,
     NEG = 396,
     UPLUS = 397
   };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_THREAD_LOCAL 260
#define TOK_MY 261
#define TOK_DO 262
#define TOK_TRY 263
#define TOK_THROW 264
#define TOK_CATCH 265
#define TOK_WHERE 266
#define TOK_WHILE 267
#define TOK_IF 268
#define TOK_FOR 269
#define TOK_SUB 270
#define TOK_THREAD_EXIT 271
#define TOK_BREAK 272
#define TOK_CONTINUE 273
#define TOK_CONTEXT_ROW 274
#define TOK_FIND 275
#define TOK_FOREACH 276
#define TOK_IN 277
#define TOK_DELETE 278
#define TOK_REMOVE 279
#define TOK_PRIVATE 280
#define TOK_PRIVATEINTERNAL 281
#define TOK_PRIVATEHIERARCHY 282
#define TOK_PUBLIC 283
#define TOK_SYNCHRONIZED 284
#define TOK_DEPRECATED 285
#define TOK_CONTEXT 286
#define TOK_SORT_BY 287
#define TOK_SORT_DESCENDING_BY 288
#define TOK_SUB_CONTEXT 289
#define TOK_CONST 290
#define TOK_SUMMARIZE 291
#define TOK_BY 292
#define TOK_OUR 293
#define TOK_RETHROW 294
#define TOK_SWITCH 295
#define TOK_CASE 296
#define TOK_DEFAULT 297
#define TOK_INHERITS 298
#define TOK_ELSE 299
#define TOK_STATIC 300
#define TOK_NAMESPACE 301
#define TOK_MODULE 302
#define TOK_FINAL 303
#define TOK_ABSTRACT 304
#define TOK_HASHDECL 305
#define TOK_TRANSIENT 306
#define TOK_NULL 307
#define TOK_NOTHING 308
#define TOK_TRUE 309
#define TOK_FALSE 310
#define TOK_UNREFERENCE 311
#define P_INCREMENT 312
#define P_DECREMENT 313
#define PLUS_EQUALS 314
#define MINUS_EQUALS 315
#define AND_EQUALS 316
#define OR_EQUALS 317
#define MODULA_EQUALS 318
#define MULTIPLY_EQUALS 319
#define DIVIDE_EQUALS 320
#define XOR_EQUALS 321
#define SHIFT_LEFT_EQUALS 322
#define SHIFT_RIGHT_EQUALS 323
#define TOK_UNSHIFT 324
#define TOK_PUSH 325
#define TOK_POP 326
#define TOK_SHIFT 327
#define TOK_CHOMP 328
#define TOK_TRIM 329
#define LOGICAL_AND 330
#define LOGICAL_OR 331
#define BROKEN_LOGICAL_OR 332
#define BROKEN_BINARY_OR 333
#define BROKEN_BINARY_XOR 334
#define LOGICAL_EQ 335
#define LOGICAL_NE 336
#define LOGICAL_LE 337
#define LOGICAL_GE 338
#define LOGICAL_CMP 339
#define ABSOLUTE_EQ 340
#define ABSOLUTE_NE 341
#define REGEX_MATCH 342
#define REGEX_NMATCH 343
#define TOK_EXISTS 344
#define TOK_INSTANCEOF 345
#define SHIFT_RIGHT 346
#define SHIFT_LEFT 347
#define TOK_ELEMENTS 348
#define TOK_KEYS 349
#define TOK_NEW 350
#define TOK_BACKGROUND 351
#define TOK_ON_EXIT 352
#define TOK_ON_SUCCESS 353
#define TOK_ON_ERROR 354
#define TOK_MAP 355
#define TOK_FOLDR 356
#define TOK_FOLDL 357
#define TOK_SELECT 358
#define TOK_SPLICE 359
#define TOK_EXTRACT 360
#define IMPLICIT_ELEMENT 361
#define NULL_COALESCING 362
#define VALUE_COALESCING 363
#define WEAK_ASSIGNMENT 364
#define RANGE 365
#define INTEGER 366
#define QFLOAT 367
#define NUMBER 368
#define IDENTIFIER 369
#define HASHDECL_IDENTIFIER_OPENCURLY 370
#define ANGLE_IDENTIFIER 371
#define VAR_REF 372
#define BACKQUOTE 373
#define SELF_REF 374
#define KW_IDENTIFIER_OPENPAREN 375
#define SCOPED_REF 376
#define SCOPED_VREF 377
#define CONTEXT_REF 378
#define COMPLEX_CONTEXT_REF 379
#define QORE_CAST 380
#define QORE_OR_NOTHING_CAST 381
#define CLASS_STRING 382
#define DATETIME 383
#define QUOTED_WORD 384
#define BINARY 385
#define REGEX_SUBST 386
#define REGEX_TRANS 387
#define CLASS_SCOPED_REF 388
#define BASE_CLASS_CALL 389
#define REGEX 390
#define REGEX_EXTRACT 391
#define IMPLICIT_ARG_REF 392
#define DOT_KW_IDENTIFIER 393
#define TRY_MODULE_ERROR 394
#define IFX 395
#define NEG 396
#define UPLUS 397




/* Copy the first part of user declarations.  */
#line 1 "parser.ypp"
 /* -*- mode: c++; indent-tabs-mode: nil -*-

    parser.ypp

    Qore Programming Language

    Copyright (C) 2003 - 2023 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    Note that the Qore library is released under a choice of three open-source
    licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
    information.
*/

#include "qore/Qore.h"
#include "qore/intern/BreakStatement.h"
#include "qore/intern/ContinueStatement.h"
#include "qore/intern/ReturnStatement.h"
#include "qore/intern/RethrowStatement.h"
#include "qore/intern/ThreadExitStatement.h"
#include "qore/intern/ExpressionStatement.h"
#include "qore/intern/DoWhileStatement.h"
#include "qore/intern/SummarizeStatement.h"
#include "qore/intern/ContextStatement.h"
#include "qore/intern/IfStatement.h"
#include "qore/intern/WhileStatement.h"
#include "qore/intern/ForStatement.h"
#include "qore/intern/ForEachStatement.h"
#include "qore/intern/TryStatement.h"
#include "qore/intern/ThrowStatement.h"
#include "qore/intern/StatementBlock.h"
#include "qore/intern/ParserSupport.h"
#include "qore/intern/SwitchStatement.h"
#include "qore/intern/CaseNodeWithOperator.h"
#include "qore/intern/CaseNodeRegex.h"
#include "qore/intern/OnBlockExitStatement.h"
#include "qore/intern/ConstantList.h"
#include "qore/intern/GlobalVariableList.h"
#include "qore/intern/QoreNamespaceIntern.h"
#include "qore/intern/QoreParseHashNode.h"
#include "qore/intern/QoreParseListNode.h"
#include "qore/intern/ModuleInfo.h"

#include "parser.hpp"

#include "qore/intern/QoreClassIntern.h"
#include "qore/intern/QoreParseClass.h"
#include "qore/intern/qore_program_private.h"
#include "qore/intern/typed_hash_decl_private.h"
#include "qore/intern/qore_list_private.h"

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <memory>
#include <sstream>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                         \
    do {                                                        \
        if (N) {                                                \
            (Current).first_line = YYRHSLOC(Rhs, 1).first_line; \
            (Current).first_col  = YYRHSLOC(Rhs, 1).first_col;  \
            (Current).last_line  = YYRHSLOC(Rhs, N).last_line;  \
            (Current).last_col   = YYRHSLOC(Rhs, N).last_col;   \
        } else {                                                \
            (Current).first_line = (Current).last_line =        \
                YYRHSLOC(Rhs, 0).last_line;                     \
            (Current).first_col = (Current).last_col =          \
                YYRHSLOC(Rhs, 0).last_col;                      \
        }                                                       \
    } while (0)

// to fix the start location of an expression
static void fix_start_location(int val, QoreParserLocation& loc, QoreParserLocation& exp_loc) {
    if (!val) {
        loc.first_col = exp_loc.first_col;
        loc.first_line = exp_loc.first_line;
        loc.last_col = exp_loc.last_col;
        loc.last_line = exp_loc.last_line;
    }
}

static void fix_start_location(void* val, QoreParserLocation& loc, QoreParserLocation& exp_loc) {
    fix_start_location(val ? 1 : 0, loc, exp_loc);
}

class HashElement {
public:
    QoreValue key;
    QoreValue value;
    const QoreProgramLocation* loc;

    DLLLOCAL HashElement(QoreValue k, QoreValue v, int sl, int el) : key(k), value(v), loc(qore_program_private::get(*getProgram())->getLocation(sl, el)) {
        //traceout("HashElement::HashElement()");
    }

    DLLLOCAL ~HashElement() {
        key.discard(nullptr);
        value.discard(nullptr);
    }

    DLLLOCAL void addDelete(QoreParseHashNode* h) {
        h->add(key, value, loc);
        key.clear();
        value.clear();
        delete this;
    }
};

// for constant definitions
class ConstNode {
public:
    const QoreProgramLocation* loc;
    NamedScope name;
    QoreValue value;
    bool pub;

    DLLLOCAL ConstNode(const QoreProgramLocation* loc, char* n, QoreValue v, bool p = false) : loc(loc), name(n), value(v), pub(p) {
        // see if constant definitions are allowed
        if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
            parse_error(*loc, "illegal constant definition \"%s\" (conflicts with parse option PO_NO_CONSTANT_DEFS)", n);
    }
    DLLLOCAL QoreValue takeValue() {
        QoreValue rv = value;
        value.clear();
        return rv;
    }
    DLLLOCAL const char* getName() const {
        return name.getIdentifier();
    }
    DLLLOCAL bool isPublic() const {
        return pub;
    }
};

class ObjClassDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    QoreClass* oc;

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, NamedScope *n, QoreClass* o) : loc(loc), name(n), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, char* n, QoreClass* o) : loc(loc), name(new NamedScope(n)), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ~ObjClassDef() {
        delete name;
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a class may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your class");
    }
};

class HashDeclDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    TypedHashDecl* hashdecl;

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, NamedScope *n, typed_hash_decl_private* hp) :
            loc(loc), name(n), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, char* n, typed_hash_decl_private* hp) :
            loc(loc), name(new NamedScope(n)), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL ~HashDeclDef() {
        delete name;
        if (hashdecl)
            typed_hash_decl_private::get(*hashdecl)->deref();
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a hashdecl may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your hashdecl");
    }

    DLLLOCAL TypedHashDecl* takeHashDecl() {
        TypedHashDecl* rv = hashdecl;
        hashdecl = nullptr;
        return rv;
    }
};

class ParseUserFunctionBase {
public:
    const QoreProgramLocation* loc;
    UserFunctionVariant* variant;

    DLLLOCAL ParseUserFunctionBase(const QoreProgramLocation* loc, UserFunctionVariant* v) : loc(loc), variant(v) {
    }

    DLLLOCAL ~ParseUserFunctionBase() {
        if (variant)
            variant->deref();
    }

    DLLLOCAL void setPublic() {
        variant->setModulePublic();
    }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
    char* name;

    DLLLOCAL ParseUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL ~ParseUserFunction() {
        if (name)
            free(name);
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
            const char* nsn = ns.name.c_str();
            parse_error(*loc, "function '%s%s%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
        }

        delete this;
    }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
    NamedScope name;

    DLLLOCAL ParseScopedUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
            parse_error(*loc, "function '%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", name.ostr);

        delete this;
    }
};

struct GVarDecl {
    const QoreProgramLocation* loc;
    bool pub;

    DLLLOCAL GVarDecl(const QoreProgramLocation* loc, bool p) : loc(loc), pub(p) {
    }

    DLLLOCAL virtual ~GVarDecl() {
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

    DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
    char* name;
    const QoreTypeInfo* typeInfo;
    QoreParseTypeInfo* parseTypeInfo;
    qore_var_t type;

    DLLLOCAL GVarSingleDecl(const QoreProgramLocation* loc, char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti,
            bool p, bool bare, qore_var_t type = VT_GLOBAL) : GVarDecl(loc, p), name(n), typeInfo(ti), parseTypeInfo(pti),
            type(type) {
        //printd(5, "GVarSingleDecl::GVarSingleDecl() '%s' %d-%d\n", n, loc.start_line, loc.end_line);
        if (bare) {
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "%s variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set",
                    type == VT_GLOBAL ? "global" : "thread_local", n);
        } else {
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to %s variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set",
                    type == VT_GLOBAL ? "global" : "thread_local", n);
        }
        if (qore_program_private::get(*getProgram())->expression_mode) {
            parse_error(*loc, "%s variable declaration '%s' not allowed in expressions' is set",
                type == VT_GLOBAL ? "global" : "thread_local", n);
        }
    }

    DLLLOCAL virtual ~GVarSingleDecl() {
        if (name)
            free(name);

        delete parseTypeInfo;
    }

    DLLLOCAL char* takeName() {
        char* rv = name;
        name = 0;
        return rv;
    }

    DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        ns.parseAddGlobalVarDecl(loc, takeName(), typeInfo, takeParseTypeInfo(), pub, type);
        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        GlobalVarRefNode* gv = typeInfo
            ? new GlobalVarRefNode(loc, takeName(), typeInfo, type)
            : new GlobalVarRefNode(loc, takeName(), takeParseTypeInfo(), type);
        if (pub)
            gv->setPublic();

        delete this;
        return gv;
    }
};

struct GVarListDecl : public GVarDecl {
    QoreParseListNode* l;
    qore_var_t type;

    DLLLOCAL GVarListDecl(const QoreProgramLocation* loc, QoreParseListNode* list, bool p,
            qore_var_t type = VT_GLOBAL)
            : GVarDecl(loc, p), l(list), type(type) {
        bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                if (!bareok)
                    parse_error(*loc, "variable '%s' in %s variable declaration list declared without '$' " \
                        "prefix, but parse option 'allow-bare-refs' is not set", b->str,
                        type == VT_GLOBAL ? "global" : "thread_local");
            } else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (vrn->explicitScope()) {
                    if (vrn->getType() == VT_LOCAL)
                        parse_error(*loc, "illegal use of 'my %s' in %s variable declaration list", vrn->getName(),
                            type == VT_GLOBAL ? "global" : "thread_local");
                    else if (vrn->getType() == VT_GLOBAL)
                        parse_error(*loc, "illegal use of 'our %s' in %s variable declaration list", vrn->getName(),
                            type == VT_GLOBAL ? "global" : "thread_local");
                }
            } else
                parse_error(*loc, "element %d in list following '%s' is not a variable reference (%s)", i,
                    type == VT_GLOBAL ? "our" : "thread_local", n.getTypeName());
        }
    }

    DLLLOCAL virtual ~GVarListDecl() {
        if (l) {
            l->deref(nullptr);
        }
    }

    DLLLOCAL QoreParseListNode* takeList() {
        QoreParseListNode* rv = l;
        l = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                ns.parseAddGlobalVarDecl(loc, b->takeString(), 0, 0, pub, type);
            } else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
                    if (vrdn) {
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), vrdn->getTypeInfo(),
                            vrdn->takeParseTypeInfo(), pub, type);
                    } else {
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), 0, 0, pub, type);
                    }
                }
            }
        }

        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        l->setVariableList();
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue& n = vl[i];
            qore_type_t t = n.getType();
            VarRefNode* vrn = nullptr;
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                GlobalVarRefNode* v = new GlobalVarRefNode(loc, b->takeString(), (const QoreTypeInfo*)nullptr, type);
                b->deref();
                n = vrn = v;
            } else if (t == NT_VARREF) {
                vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    vrn->makeGlobal(type);
                    vrn->setExplicitScope();
                    //printd(5, "GVarListDecl::makeVar() '%s' t: %d set global with explicit scope\n",
                    //  vrn ? vrn->getName() : "n/a", type);
                }
            }

            if (vrn && pub)
                vrn->setPublic();
        }

        QoreParseListNode* rv = takeList();
        delete this;
        return rv;
    }
};

static int check_method(const QoreProgramLocation* loc, const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error(*loc, "%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error(*loc, "base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PUBLIC     (1 << 0)
#define OFM_PRIVATE    (1 << 1)
#define OFM_INTERNAL   (1 << 2)
#define OFM_SYNCED     (1 << 3)
#define OFM_STATIC     (1 << 4)
#define OFM_DEPRECATED (1 << 5)
#define OFM_FINAL      (1 << 6)
#define OFM_ABSTRACT   (1 << 7)

static inline MethodVariantBase* new_method_variant(const QoreProgramLocation* loc, const char* name, int mod, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
    //printd(5, "new_method_variant() '%s' b: %p\n", name, b);

    int64 flags = QCF_NO_FLAGS;

    if (get_pop_argv_ref())
        flags |= QCF_USES_EXTRA_ARGS;

    ClassAccess access = Public;
    if (mod & OFM_PRIVATE) {
        if (mod & OFM_INTERNAL)
            parse_error(*loc, "%s() methods cannot be both private:hierarchy and private:internal", name);
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Private;
    }
    else if (mod & OFM_INTERNAL) {
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Internal;
    }

    if (mod & OFM_DEPRECATED)
        flags |= QCF_DEPRECATED;

    if (!strcmp(name, "constructor")) {
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        return new UserConstructorVariant(access, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
    }
    if (bcal) {
        parse_error(*loc, "only constructors may have base class constructor arguments");
        delete bcal;
        bcal = 0;
    }
    if (!strcmp(name, "destructor")) {
        if (params) {
            parse_error(*loc, "parameters cannot be defined for destructors");
            params.discard(nullptr);
        }
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        if (access > Public)
            parse_error(*loc, "destructors cannot be private");
        return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
    }
    if (!strcmp(name, "copy")) {
        if (mod & OFM_FINAL) {
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        }
        if (mod & OFM_ABSTRACT) {
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        }
        return new UserCopyVariant(access, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
    }

    if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
        if (mod & OFM_FINAL) {
            parse_error(*loc, "%s() methods cannot be declared final; they are not inherited anyway", name);
        }
    }

    if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
        parse_error(*loc, "method '%s()' is declared both final and abstract", name);

    return new UserMethodVariant(access, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
    const QoreProgramLocation* loc;
    MethodVariantBase* m;
    NamedScope name;
    bool static_flag;

    DLLLOCAL MethodDef(const QoreProgramLocation* loc, int mod, char* n, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : loc(loc), m(0), name(n), static_flag(mod & OFM_STATIC) {
        if (check_method(loc, name.getIdentifier(), bcal, returnTypeInfo)) {
            params.discard(nullptr);
            delete bcal;
            delete b;
            delete returnTypeInfo;
            return;
        }

        m = new_method_variant(loc, name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
    }

    DLLLOCAL ~MethodDef() {
        delete m;
    }

    DLLLOCAL void parseAddToClassAndDel() {
        if (m) {
            // if there are any errors, the function below will delete memory
            // the following method takes ownership of "m" unconditionally
            qore_root_ns_private::parseAddMethodToClass(loc, name, m, static_flag);
            m = 0;
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        // the following method takes ownership of "m" unconditionally
        ns.parseAddMethodToClass(loc, name, m, static_flag);
        m = 0;
    }
};

static QoreValue parse_hash_map(const QoreProgramLocation* loc, QoreParseHashNode* exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> exph(exp, nullptr);
    ReferenceHolder<> lh(l, nullptr);

    // check hash expression
    size_t len = exp->size();

    if (len == 0) {
        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
                "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
        return new QoreHashNode(autoTypeInfo);
    }

    if (len != 1) {
        parse_error(*loc, "invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
        return QoreValue();
    }

    if (l->size() == 1) {
        QoreValue iter = l->shift();
        return new QoreHashMapOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter);
    }

    QoreValue iter = l->shift();
    QoreValue select = l->shift();
    return new QoreHashMapSelectOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter, select);
}

static AbstractQoreNode* parse_map(const QoreProgramLocation* loc, QoreValue exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> lh(l, 0);

    if (l->size() == 1) {
        QoreValue arg = l->shift();
        return new QoreMapOperatorNode(loc, exp, arg);
    }

    QoreValue iterator_exp = l->shift();
    QoreValue select_exp = l->shift();
    return new QoreMapSelectOperatorNode(loc, exp, iterator_exp, select_exp);
}

#define NSN_NONE     0
#define NSN_OCD      1
#define NSN_HASHDECL 2
#define NSN_CONST    3
#define NSN_NS       4
#define NSN_FUNC     5
#define NSN_SFUNC    6
#define NSN_VAR      7
#define NSN_METH     8

struct NSNode {
    int type;
    union {
        ObjClassDef* ocd;
        HashDeclDef* hashdecl;
        ConstNode* cn;
        QoreNamespace* ns;
        ParseUserFunction* func;
        ParseScopedUserFunction* sfunc;
        GVarDecl* gv;
        MethodDef* meth;
    } n;

    DLLLOCAL NSNode(ObjClassDef* o) { type = NSN_OCD; n.ocd = o; }
    DLLLOCAL NSNode(HashDeclDef* h) { type = NSN_HASHDECL; n.hashdecl = h; }
    DLLLOCAL NSNode(ConstNode* c) { type = NSN_CONST; n.cn = c; }
    DLLLOCAL NSNode(QoreNamespace* s) { type = NSN_NS; n.ns = s; }
    DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
        n.func = f;
    }
    DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
        n.sfunc = f;
    }

    DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
        n.gv = gv;
    }

    DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
        n.meth = m;
    }

    DLLLOCAL void deref() {
        switch (type) {
            case NSN_OCD:
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                delete n.hashdecl;
                break;
            case NSN_CONST:
                delete n.cn;
                break;
            case NSN_NS:
                delete n.ns;
                break;
            case NSN_FUNC:
                delete n.func;
                break;
            case NSN_SFUNC:
                delete n.sfunc;
                break;
            case NSN_VAR:
                delete n.gv;
                break;
            case NSN_METH:
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        switch (type) {
            case NSN_OCD:
                //printd(5, "ocd: %s %d-%d c: %d-%d\n", n.ocd->oc->getName(), n.ocd->loc.start_line, n.ocd->loc.end_line, qore_class_private::get(*n.ocd->oc)->loc.start_line, qore_class_private::get(*n.ocd->oc)->loc.end_line);
                ns.parseAddPendingClass(n.ocd->loc, *(n.ocd->name), n.ocd->oc);
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                ns.parseAddPendingHashDecl(n.hashdecl->loc, *(n.hashdecl->name), n.hashdecl->takeHashDecl());
                delete n.hashdecl;
                break;
            case NSN_CONST:
                ns.parseAddConstant(n.cn->loc, n.cn->name, n.cn->value, n.cn->pub);
                delete n.cn;
                break;
            case NSN_NS:
                ns.parseAddNamespace(n.ns);
                break;
            case NSN_FUNC:
                n.func->add(ns);
                break;
            case NSN_SFUNC:
                n.sfunc->add(ns);
                break;
            case NSN_VAR:
                n.gv->add(ns);
                break;
            case NSN_METH:
                n.meth->add(ns);
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
    DLLLOCAL void deref() {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->deref();

        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->add(ns);
    }
};

static QoreParseListNode* splice_expressions(QoreValue a1, QoreValue a2, const QoreProgramLocation* loc1, const QoreProgramLocation* loc2) {
    //tracein("splice_expressions()");
    if (a1.getType() == NT_PARSE_LIST) {
        QoreParseListNode* l = a1.get<QoreParseListNode>();
        if (!l->isFinalized()) {
            //printd(5, "LIST x\n");
            l->add(a2, loc2);
            return l;
        }
    }
    QoreParseListNode* l = new QoreParseListNode(qore_program_private::get(*getProgram())->getLocation(*loc1, loc2->start_line, loc2->end_line));
    l->add(a1, loc1);
    l->add(a2, loc2);
    return l;
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;
typedef std::pair<char*, HashDeclMemberInfo*> hashmem_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2
#define MI_HashMem 3

struct MemberInfo {
protected:
    DLLLOCAL MemberInfo(const QoreProgramLocation* loc) : loc(loc) {
    }

public:
    const QoreProgramLocation* loc;
    char* name;
    unsigned char type;
    union {
        QoreMemberInfo* memberInfo;
        QoreVarInfo* varInfo;
        HashDeclMemberInfo* hashMemberInfo;
        QoreSimpleValue exp;
    } u;

    DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : loc(mi->loc), name(n), type(MI_Member) {
        u.memberInfo = mi;
        if (!(mi && mi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*mi->loc, "member '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL MemberInfo(const QoreProgramLocation* loc, char* n, QoreValue exp) : loc(loc), name(n), type(MI_Constant) {
        u.exp = exp;
    }

    DLLLOCAL MemberInfo(char* n, HashDeclMemberInfo* mi) : loc(mi->loc), name(n), type(MI_HashMem) {
        u.hashMemberInfo = mi;
    }

    DLLLOCAL ~MemberInfo() {
        if (name)
            free(name);
        switch (type) {
            case MI_Member:
                delete u.memberInfo;
                break;
            case MI_Var:
                delete u.varInfo;
                break;
            case MI_HashMem:
                delete u.hashMemberInfo;
                break;
            case MI_Constant:
                u.exp.discard(nullptr);
                break;
        }
    }

    DLLLOCAL member_pair_t getPair() {
        assert(type == MI_Member);
        member_pair_t m = std::make_pair(name, u.memberInfo);
        name = nullptr;
        u.memberInfo = nullptr;
        return m;
    }

    DLLLOCAL var_pair_t getVarPair() {
        assert(type == MI_Var);
        var_pair_t m = std::make_pair(name, u.varInfo);
        name = nullptr;
        u.varInfo = nullptr;
        return m;
    }

    DLLLOCAL hashmem_pair_t getHashMemPair() {
        assert(type == MI_HashMem);
        hashmem_pair_t m = std::make_pair(name, u.hashMemberInfo);
        name = nullptr;
        u.hashMemberInfo = nullptr;
        return m;
    }

    DLLLOCAL QoreValue takeExp() {
        assert(type == MI_Constant);
        QoreValue rv = u.exp;
        u.exp.clear();
        return rv;
    }

    DLLLOCAL void setTransient() {
        assert(type == MI_Member);
        u.memberInfo->setTransient();
    }
};

struct ClassVarInfo : public MemberInfo {
    DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) : MemberInfo(vi->loc) {
        name = n;
        type = MI_Var;
        u.varInfo = vi;
        if (!(vi && vi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*vi->loc, "class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL char* takeName() {
        char* n = name;
        name = nullptr;
        return n;
    }
};

class MemberList {
protected:
    // for new class members
    QoreMemberMap mmap;
    // for new class constants
    ConstantList cmap;
    // for new class static variables
    QoreVarMap vmap;

    DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
    }

public:
    DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
        if (!member)
            return;

        if (member->type == MI_Member)
            mmap.addNoCheck(member->getPair());
        else if (member->type == MI_Constant)
            cmap.parseAdd(member->loc, member->name, member->takeExp());
        else
            vmap.addNoCheck(member->getVarPair());

        delete member;
    }

    DLLLOCAL ~MemberList() {
    }

    // takes over ownership of name and typeInfo
    DLLLOCAL int add(MemberInfo* member) {
        if (!member)
            return -1;

        if (member->type == MI_Member) {
            if (mmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate member declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            mmap.addNoCheck(member->getPair());
            delete member;
        } else if (member->type == MI_Constant) {
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate constant declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "constant declaration collides with static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new constant to list
            cmap.parseAdd(member->loc, member->name, member->takeExp());
            delete member;
        } else {
            assert(member->type == MI_Var);
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "duplicate static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "static class variable declaration collides with constant declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            vmap.addNoCheck(member->getVarPair());
            delete member;
        }

        return 0;
    }

    DLLLOCAL void merge(QoreClass* qc, ClassAccess access) {
        mmap.moveAllTo(qc, access);
        vmap.moveAllTo(qc, access);

        // merge constants
        qore_class_private::get(*qc)->parseAssimilateConstants(cmap, access);
    }
};

class EmptyMemberList : public MemberList {
public:
   DLLLOCAL EmptyMemberList() {
   }
};

struct ParserTypeStruct {
protected:
    DLLLOCAL ParserTypeStruct() {
    }

public:
    const QoreTypeInfo* typeInfo = nullptr;
    QoreParseTypeInfo* parseTypeInfo = nullptr;

    DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : parseTypeInfo(n_parseTypeInfo) {
    }

    DLLLOCAL ParserTypeStruct(char* id, bool or_nothing) : typeInfo(or_nothing ? getBuiltinUserOrNothingTypeInfo(id) : getBuiltinUserTypeInfo(id)) {
        //printd(0, "ParserTypeStruct::ParserTypeStruct('%s', %d) t: %p %s\n", id, or_nothing, typeInfo, QoreTypeInfo::getName(typeInfo));
        if (typeInfo) {
            free(id);
            return;
        }

        parseTypeInfo = new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL ~ParserTypeStruct() {
        delete parseTypeInfo;
    }

    DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
        return typeInfo;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static const QoreTypeInfo* getTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getTypeInfo() : nullptr;
    }

    DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static QoreParseTypeInfo* getParseTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getParseTypeInfo() : nullptr;
    }

    DLLLOCAL const char* getClassName() {
        assert(parseTypeInfo);
        return parseTypeInfo->cscope->ostr;
    }

    DLLLOCAL static ParserTypeStruct* getType(const QoreProgramLocation* loc, char* id, bool or_nothing) {
        return new ParserTypeStruct(getParseType(loc, id, or_nothing));
    }

    DLLLOCAL static void getSubTypes(const QoreProgramLocation* loc, const char* str, parse_type_vec_t& subtypes, bool raise_error = true) {
        QoreString buf;
        bool or_nothing = false;
        bool comma = false;

        const char* p = str;
        while (true) {
            if (*p == '\0') {
                if (buf.empty()) {
                    if (comma && raise_error)
                        parse_error(*loc, "empty subtype specification in type");
                }
                else
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                break;
            }
            switch (*p) {
                case '<': {
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    const char* e = strrchr(str, '>');
                    if (!e || e < p) {
                        if (raise_error)
                            parse_error(*loc, "unbalanced angle brackets in subtype specification in '%s'", str);
                        return;
                    }
                    buf.concat(p, e - p + 1);
                    //printd(5, "ST: '%s' (str: '%s') p: %p '%s'\n", buf.c_str(), str, p, p);
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                    buf.reset();
                    or_nothing = false;
                    //printd(5, "ST: p: %p -> %p\n", p, e);
                    p = e;
                    break;
                }
                case ',':
                    buf.trim();
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing, raise_error));
                    buf.reset();
                    or_nothing = false;
                    comma = true;
                break;
                case '*': {
                    if (buf.empty())
                        or_nothing = true;
                    else
                        buf.concat('*');
                    if (comma)
                        comma = false;
                    break;
                }
                case ' ':
                case '\t':
                    if (!buf.empty())
                        buf.concat(*p);
                    break;
                default:
                    buf.concat(*p);
                    if (comma)
                        comma = false;
                break;
            }
            ++p;
        }
    }

    DLLLOCAL static QoreParseTypeInfo* getParseType(const QoreProgramLocation* loc, char* id, bool or_nothing, bool raise_error = true) {
        //printd(0, "gPT() '%s'\n", id);
        char* p0 = strchr(id, '<');
        if (p0) {
            char* p1 = strrchr(id, '>');
            if (p1 > (p0 + 1)) {
                // terminate main type string
                *p0 = '\0';
                // terminate type args
                *p1 = '\0';

                parse_type_vec_t subtypes;
                getSubTypes(loc, p0 + 1, subtypes, raise_error);
                return new QoreParseTypeInfo(id, or_nothing, std::move(subtypes));
            }
        }
        return new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL static const QoreTypeInfo* getRuntimeType(const char* str) {
        assert(str);
        assert(str[0]);
        char* p;
        bool or_nothing;
        if (str[0] == '*') {
            or_nothing = true;
            p = strdup(str + 1);
        } else {
            or_nothing = false;
            p = strdup(str);
        }
        std::unique_ptr<QoreParseTypeInfo> pt(ParserTypeStruct::getParseType(&loc_builtin, p, or_nothing, false));
        return QoreParseTypeInfo::resolveRuntime(pt.get());
    }
};

const QoreTypeInfo* qore_get_type_from_string_intern(const char* str) {
    // issue #3318: does not use ProgramRuntimeParseAccessHelper as it is normally not needed, if this is
    // necessary, then the call to this function must be wrapped using this class
    return ParserTypeStruct::getRuntimeType(str);
}

static AbstractQoreNode* process_dot(int sline, int eline, QoreValue l, QoreValue r) {
    qore_type_t rtype = r.getType();
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    switch (rtype) {
        case NT_BAREWORD: {
            BarewordNode* b = r.get<BarewordNode>();
            if (!b->isFinalized()) {
                AbstractQoreNode* rv = new QoreHashObjectDereferenceOperatorNode(loc, l, b->makeQoreStringNode());
                b->deref();
                return rv;
            }
            break;
        }

        case NT_FUNCTION_CALL: {
            FunctionCallNode* f = r.get<FunctionCallNode>();
            assert(!f->getFunction());
            if (!f->isFinalized()) {
                MethodCallNode* m = new MethodCallNode(loc, f->takeName(), f->takeParseArgs());
                f->deref();

                return new QoreDotEvalOperatorNode(loc, l, m);
            }
            break;
        }
    }

    return new QoreHashObjectDereferenceOperatorNode(loc, l, r);
}

static int check_strong_encapsulation(const QoreProgramLocation* loc, const char* type, const char* name) {
    if (parse_check_parse_option(PO_STRONG_ENCAPSULATION)) {
        parse_error(*loc, "illegal out of line %s definition \"%s\" (conflicts with parse option PO_STRONG_ENCAPSULATION)", type, name);
        return -1;
    }
    return 0;
}

static int check_case(const QoreProgramLocation* loc, const char* op, QoreValue exp) {
    // ignore if NULL (= NOTHING)
    if (exp.hasEffect()) {
        if (op)
            parse_error(*loc, "case expression with '%s' needs run-time evaluation", op);
        else
            parse_error(*loc, "case expression needs run-time evaluation", op);
        return -1;
    }
    return 0;
}

static void check_funcmod(const QoreProgramLocation* loc, int mod) {
    if (mod & (OFM_PRIVATE|OFM_INTERNAL))
        parse_error(*loc, "illegal 'private' modifier in function declaration");
    if (mod & OFM_STATIC)
        parse_error(*loc, "illegal 'static' modifier in function declaration");
    if (mod & OFM_FINAL)
        parse_error(*loc, "illegal 'final' modifier in function declaration");
    if (mod & OFM_ABSTRACT)
        parse_error(*loc, "illegal 'abstract' modifier in function declaration");
}

static void check_classmod(const QoreProgramLocation* loc, int mod, QoreClass& qc) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in class declaration");
}

static void check_hashdeclmod(const QoreProgramLocation* loc, int mod, typed_hash_decl_private& hashdecl) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in hashdecl");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in hashdecl");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in hashdecl");
   if (mod & OFM_PUBLIC)
      hashdecl.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in hashdecl");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in hashdecl");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in hashdecl");
}

static void check_nsmod(const QoreProgramLocation* loc, int mod, qore_ns_private& ns) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // if pn is a function node it's effect actually cannot be evaluated
    // at this moment because the function flags have not yet been set
    // and so has_effect() always returns 'true'
    return pn ? pn->has_effect() : true;
}

bool node_has_effect_as_root(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffectAsRoot();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // the same comment as in the above function node_has_effect() applies also here
    return pn ? pn->has_effect_as_root() : true;
}

bool value_has_effect_as_root(const QoreValue& n) {
    return node_has_effect_as_root(n.getInternalNode());
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }

   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }

   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }

   DLLLOCAL const QoreProgramLocation* getLoc() const {
      return m->getUserVariantBase()->getUserSignature()->getParseLocation();
   }
};

static QoreValue is_rewritable_op(QoreValue n) {
    qore_type_t nt = n.getType();
    if (nt == NT_OPERATOR) {
        QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n.getInternalNode());
        if (op)
            return op->getRight();
    }

    return QoreValue();
}

static QoreValue check_rewrite_list(QoreParseListNode* l) {
    if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
        return l;

    // rewrite expression if it's a list without parentheses and
    // the first expression has one of the following operators:
    // =, +=, -=
    if (l->isFinalized())
        return l;

    QoreValue e0 = l->get(0);

    QoreValue r = is_rewritable_op(e0);
    if (!r.isNothing()) {
        QoreValue last = e0;
        QoreValue top = e0;
        while (true) {
            QoreValue nr = is_rewritable_op(r);
            if (nr.isNothing()) {
                break;
            }
            last = r;
            r = nr;
        }
        assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last.getInternalNode()));
        // take first element from list (the tree) and make it the new expression
        QoreBinaryLValueOperatorNode* op = last.get<QoreBinaryLValueOperatorNode>();
        l->swap(0, op->swapRight(l));
        return top;
    }

    return l;
}

// cannot be static
void ignore_return_value(QoreSimpleValue& n) {
    qore_type_t t = n.getType();
    if (t == NT_OPERATOR) {
        n.get<QoreOperatorNode>()->ignoreReturnValue();
    }
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static QoreOperatorNode* process_assignment(int sline, int eline, QoreValue $1, QoreValue $3) {
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    return ($1.getType() == NT_PARSE_LIST)
        ? static_cast<QoreOperatorNode*>(new QoreListAssignmentOperatorNode(loc, $1, $3))
        : static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
}

static QoreOperatorNode* process_weak_assignment(const QoreProgramLocation* loc, QoreValue $1, QoreValue $3) {
   if ($1.getType() == NT_LIST) {
       parse_error(*loc, "the ':=' operator is not valid with list assignments");
       return static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
   }
   return static_cast<QoreOperatorNode*>(new QoreWeakAssignmentOperatorNode(loc, $1, $3));
}

static AbstractQoreNode* processCall(int sline, int eline, QoreValue $1, QoreValue $3, const QoreProgramLocation* argloc) {
    AbstractQoreNode* $$;
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);

    //printd(5, "1: %s, 3: %s\n", $1.getTypeName(), $3.getTypeName());
    qore_type_t t = $1.getType();
    if (t == NT_BAREWORD) {
        BarewordNode* b = $1.get<BarewordNode>();
        // take string from node and delete node
        char* str = b->takeString();
        b->deref();
        printd(5, "parsing call %s() args: %s\n", str, $3.getTypeName());
        $$ = new FunctionCallNode(loc, str, make_args(argloc, $3));
    } else if (t == NT_CONSTANT) {
        ScopedRefNode* c = $1.get<ScopedRefNode>();
        // take NamedScope from node and delete node
        NamedScope *ns = c->takeName();
        c->deref();
        assert(ns->size() > 1);
        printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
        $$ = new StaticMethodCallNode(loc, ns, make_args(argloc, $3));
    } else if (t == NT_SELF_VARREF) {
        SelfVarrefNode* v = $1.get<SelfVarrefNode>();
        // take string from node and delete node
        char* str = v->takeString();
        v->deref();
        //printd(5, "parsing in-object method call %s()\n", str);
        $$ = new SelfFunctionCallNode(loc, str, make_args(argloc, $3));
    } else {
        QoreHashObjectDereferenceOperatorNode* hodon;

        if (t == NT_OPERATOR) {
            hodon = dynamic_cast<QoreHashObjectDereferenceOperatorNode*>($1.getInternalNode());
            if (hodon) {
                QoreValue r = hodon->getRight();
                if (r.getType() != NT_STRING)
                    hodon = nullptr;
            }
        } else
            hodon = nullptr;

        if (hodon) {
            // create an object method call node
            // take the string
            QoreStringNode* str = hodon->swapRight(QoreValue()).get<QoreStringNode>();
            assert(str->getEncoding() == QCS_DEFAULT);
            char* cstr = str->giveBuffer();
            assert(cstr);
            str->deref();

            MethodCallNode* mc = new MethodCallNode(loc, cstr, make_args(argloc, $3));

            // destroy the original operator and create a new operator object
            assert(hodon->is_unique());
            QoreValue l = hodon->swapLeft(QoreValue());
            hodon->deref(nullptr);

            $$ = new QoreDotEvalOperatorNode(loc, l, mc);
        } else {
            $$ = nullptr;
            if ($1.getType() == NT_VARREF) {
                VarRefNode* r = $1.get<VarRefNode>();
                qore_var_t vartype = r->getType();

                if (vartype != VT_UNRESOLVED) {
                    $$ = r->makeNewCall($3);
                    //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
                    if (!$$) {
                        parseException(*loc, "INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
                    }
                }
            }
            if (!$$) {
                $$ = new CallReferenceCallNode(loc, $1, make_args(argloc, $3));
                printd(5, "made new CallReferenceCallNode: %p exp: %s\n", $$, $1.getTypeName());
            }
        }
    }
    return $$;
}

static void check_operator(const QoreProgramLocation* loc, const QoreOperatorNode* n, const char* parent, const char* child) {
    if (parse_check_parse_option(PO_BROKEN_LOGIC_PRECEDENCE)) {
        if (!n->getInParentheses()) {
            qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_BROKEN_LOGIC_PRECEDENCE, "BROKEN-LOGIC-PRECEDENCE", "%s gets under %s in the parse tree as an impact of broken-logic-precedence flag being set - please consider using parenthesis to enforce the desired operator precedence", child, parent);
        }
    }
}

static void check_operator_log_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreLogicalOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "logical OR");
    }
}

static void check_operator_bin_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary OR");
    }
}

static void check_operator_bin_xor(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryXorOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary XOR");
    }
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 1539 "parser.ypp"
{
    QoreSimpleValue qv;
    bool b;
    int i4;
    int64 integer;
    double decimal;
    QoreStringNode* String;
    char* string;
    BinaryNode* binary;
    AbstractQoreNode* node;
    QoreParseHashNode* hash;
    QoreParseListNode* parse_list;
    AbstractStatement* statement;
    struct MemberInfo* memberinfo;
    struct ClassVarInfo* classvarinfo;
    StatementBlock *sblock;
    ContextModList* cmods;
    ContextMod *cmod;
    class HashElement* hashelement;
    QoreFunction* userfunc;
    struct MethodNode* methodnode;
    class MemberList* memberlist;
    QoreClass* qoreclass;
    typed_hash_decl_private* hashdeclpriv;
    class ConstNode* constnode;
    QoreNamespace *ns;
    struct NSNodeList* nsnlist;
    struct NSNode* nsn;
    class ObjClassDef* classdef;
    class HashDeclDef* hashdecldef;
    DateTimeNode* datetime;
    QoreRegexSubst* RegexSubst;
    QoreTransliteration* Trans;
    SwitchStatement* switchstmt;
    CaseNode* casenode;
    BCList* sclist;
    class BCNode* sclnode;
    BCAList* bcalist;
    BCANode* bcanode;
    NamedScope *nscope;
    QoreRegex* Regex;
    QoreImplicitArgumentNode* implicit_arg;
    RetTypeInfo* returnTypeInfo;
    struct ParserTypeStruct* parsertype;
    class ParseUserFunction* parsefunc;
    class ParseScopedUserFunction* sparsefunc;
    struct GVarDecl* gv;
    QoreNumberNode* num;
    TryModuleError* trymod;
    struct MethodDef* methoddef;
}
/* Line 193 of yacc.c.  */
#line 1960 "parser.cpp"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */
#line 1591 "parser.ypp"


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE* loc, yyscan_t scanner, const char* str) {
    //printd(5, "yyerror() location: %d:%d - %d:%d \"%s\"\n", loc->first_line, loc->first_col, loc->last_line, loc->last_col, str);
    const QoreProgramLocation* qloc = qore_program_private::get(*getProgram())->getLocation(loc->first_line, loc->last_line);
    parse_error(*qloc, "%s", str);
}



/* Line 216 of yacc.c.  */
#line 1998 "parser.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  216
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   14082

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  168
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  68
/* YYNRULES -- Number of rules.  */
#define YYNRULES  448
/* YYNRULES -- Number of states.  */
#define YYNSTATES  959

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   397

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   159,     2,     2,     2,   152,   147,     2,
     163,   166,   153,   150,   141,   151,   162,   154,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   144,   165,
     148,   142,   149,   143,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   161,   158,   167,   146,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   160,   145,   164,   157,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   155,   156
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    27,    31,    33,    38,    40,    42,    45,
      50,    51,    53,    58,    62,    67,    71,    76,    81,    87,
      92,    96,   101,   105,   110,   115,   121,   127,   131,   136,
     138,   141,   143,   145,   147,   149,   151,   153,   156,   158,
     160,   166,   173,   179,   186,   190,   193,   195,   197,   199,
     201,   204,   207,   208,   210,   212,   215,   221,   223,   226,
     230,   234,   237,   240,   243,   247,   259,   267,   273,   281,
     287,   295,   305,   313,   316,   319,   322,   325,   327,   330,
     331,   334,   339,   344,   349,   351,   354,   362,   364,   367,
     373,   378,   384,   389,   395,   400,   406,   411,   417,   422,
     428,   433,   439,   444,   449,   453,   458,   462,   466,   469,
     477,   478,   480,   482,   489,   496,   503,   510,   515,   520,
     526,   532,   535,   536,   538,   542,   544,   546,   549,   552,
     555,   558,   561,   564,   567,   570,   572,   575,   579,   585,
     592,   594,   596,   598,   600,   602,   605,   608,   611,   614,
     617,   619,   621,   623,   626,   629,   632,   633,   635,   639,
     644,   648,   652,   657,   661,   665,   670,   674,   678,   683,
     687,   692,   696,   703,   709,   717,   721,   727,   734,   738,
     744,   751,   754,   759,   761,   763,   766,   768,   771,   774,
     776,   778,   782,   786,   788,   790,   793,   796,   799,   802,
     804,   812,   820,   828,   836,   845,   854,   863,   872,   880,
     888,   891,   892,   894,   898,   903,   908,   909,   911,   913,
     916,   918,   920,   922,   924,   926,   928,   930,   932,   934,
     937,   938,   945,   952,   960,   968,   976,   984,   993,  1002,
    1006,  1009,  1013,  1016,  1018,  1022,  1025,  1029,  1033,  1037,
    1040,  1042,  1044,  1048,  1050,  1053,  1056,  1059,  1063,  1066,
    1070,  1075,  1077,  1079,  1081,  1083,  1085,  1094,  1097,  1100,
    1103,  1106,  1109,  1112,  1115,  1118,  1121,  1124,  1127,  1130,
    1133,  1136,  1139,  1142,  1145,  1150,  1154,  1156,  1159,  1162,
    1165,  1168,  1171,  1177,  1183,  1189,  1192,  1194,  1198,  1201,
    1208,  1215,  1223,  1231,  1233,  1235,  1238,  1241,  1246,  1251,
    1253,  1255,  1257,  1259,  1262,  1266,  1270,  1274,  1278,  1282,
    1286,  1290,  1294,  1298,  1302,  1306,  1310,  1314,  1318,  1322,
    1328,  1331,  1334,  1339,  1343,  1347,  1351,  1355,  1359,  1363,
    1367,  1371,  1375,  1379,  1383,  1387,  1391,  1395,  1399,  1403,
    1407,  1411,  1415,  1419,  1423,  1427,  1431,  1435,  1439,  1443,
    1447,  1451,  1455,  1461,  1467,  1472,  1477,  1482,  1486,  1490,
    1493,  1495,  1497,  1501,  1505,  1509,  1513,  1517,  1521,  1525,
    1529,  1533,  1537,  1541,  1545,  1549,  1553,  1557,  1563,  1566,
    1569,  1574,  1578,  1582,  1586,  1590,  1594,  1598,  1602,  1606,
    1610,  1614,  1618,  1622,  1626,  1630,  1634,  1638,  1642,  1646,
    1650,  1654,  1658,  1662,  1666,  1670,  1674,  1678,  1682,  1686,
    1690,  1696,  1702,  1707,  1712,  1717,  1721,  1725,  1728,  1730,
    1733,  1735,  1737,  1739,  1741,  1743,  1745,  1747,  1749
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     169,     0,    -1,   170,    -1,   169,   170,    -1,   223,    -1,
     224,    -1,   194,    -1,   193,    -1,   179,    -1,   178,    -1,
     215,    -1,   184,    -1,   160,   164,    -1,   160,   182,   164,
      -1,   175,    -1,    47,   160,   171,   164,    -1,   139,    -1,
     172,    -1,   171,   172,    -1,   114,   142,   232,   165,    -1,
      -1,    28,    -1,   173,    38,   201,   121,    -1,   173,    38,
     121,    -1,   173,    38,   201,   114,    -1,   173,    38,   114,
      -1,   173,    38,   202,   122,    -1,   173,    38,   202,   117,
      -1,   173,    38,   163,   225,   166,    -1,   173,     5,   201,
     121,    -1,   173,     5,   121,    -1,   173,     5,   201,   114,
      -1,   173,     5,   114,    -1,   173,     5,   202,   122,    -1,
     173,     5,   202,   117,    -1,   173,     5,   163,   225,   166,
      -1,   219,    46,   160,   176,   164,    -1,   219,    46,   165,
      -1,   219,    46,   160,   164,    -1,   177,    -1,   176,   177,
      -1,   179,    -1,   178,    -1,   194,    -1,   193,    -1,   223,
      -1,   224,    -1,   174,   165,    -1,   175,    -1,   215,    -1,
      35,   114,   142,   232,   165,    -1,    28,    35,   114,   142,
     232,   165,    -1,    35,   121,   142,   232,   165,    -1,    28,
      35,   121,   142,   232,   165,    -1,   160,   182,   164,    -1,
     160,   164,    -1,   184,    -1,   180,    -1,   184,    -1,   180,
      -1,   182,   180,    -1,   182,   184,    -1,    -1,   114,    -1,
     165,    -1,   233,   165,    -1,   121,   163,   192,   166,   165,
      -1,   191,    -1,    39,   165,    -1,    39,   232,   165,    -1,
       9,   232,   165,    -1,    97,   181,    -1,    98,   181,    -1,
      99,   181,    -1,    34,   185,   181,    -1,    36,   183,   163,
     232,   166,    37,   163,   232,   166,   185,   181,    -1,    31,
     183,   163,   232,   166,   185,   181,    -1,    13,   163,   232,
     166,   181,    -1,    13,   163,   232,   166,   181,    44,   181,
      -1,    12,   163,   232,   166,   181,    -1,     7,   181,    12,
     163,   232,   166,   165,    -1,    14,   163,   192,   165,   192,
     165,   192,   166,   181,    -1,    21,   232,    22,   163,   232,
     166,   181,    -1,   187,   165,    -1,    16,   165,    -1,    17,
     165,    -1,    18,   165,    -1,   188,    -1,     1,   165,    -1,
      -1,   185,   186,    -1,    11,   163,   232,   166,    -1,    32,
     163,   232,   166,    -1,    33,   163,   232,   166,    -1,     3,
      -1,     3,   232,    -1,    40,   163,   232,   166,   160,   189,
     164,    -1,   190,    -1,   189,   190,    -1,    41,    83,   232,
     144,   182,    -1,    41,    83,   232,   144,    -1,    41,    82,
     232,   144,   182,    -1,    41,    82,   232,   144,    -1,    41,
      80,   232,   144,   182,    -1,    41,    80,   232,   144,    -1,
      41,   148,   232,   144,   182,    -1,    41,   148,   232,   144,
      -1,    41,   149,   232,   144,   182,    -1,    41,   149,   232,
     144,    -1,    41,    87,   135,   144,   182,    -1,    41,    87,
     135,   144,    -1,    41,    88,   135,   144,   182,    -1,    41,
      88,   135,   144,    -1,    41,   135,   144,   182,    -1,    41,
     135,   144,    -1,    41,   232,   144,   182,    -1,    41,   232,
     144,    -1,    42,   144,   182,    -1,    42,   144,    -1,     8,
     181,    10,   163,   192,   166,   181,    -1,    -1,   232,    -1,
       1,    -1,   219,    50,   114,   160,   198,   164,    -1,   219,
      50,   121,   160,   198,   164,    -1,   219,   127,   195,   160,
     200,   164,    -1,   219,   133,   195,   160,   200,   164,    -1,
     219,   127,   195,   165,    -1,   219,   133,   195,   165,    -1,
     219,   127,   195,   160,   164,    -1,   219,   133,   195,   160,
     164,    -1,    43,   196,    -1,    -1,   197,    -1,   196,   141,
     197,    -1,   114,    -1,   121,    -1,    28,   114,    -1,    28,
     121,    -1,    25,   114,    -1,    25,   121,    -1,    27,   114,
      -1,    27,   121,    -1,    26,   114,    -1,    26,   121,    -1,
     199,    -1,   198,   199,    -1,   201,   114,   165,    -1,   201,
     114,   142,   232,   165,    -1,   201,   114,   163,   192,   166,
     165,    -1,   214,    -1,   203,    -1,   204,    -1,   205,    -1,
     178,    -1,   200,   214,    -1,   200,   203,    -1,   200,   204,
      -1,   200,   205,    -1,   200,   178,    -1,   114,    -1,   121,
      -1,   116,    -1,   153,   114,    -1,   153,   121,    -1,   153,
     116,    -1,    -1,   201,    -1,    26,   211,   165,    -1,    26,
     160,   212,   164,    -1,    26,   160,   164,    -1,    25,   211,
     165,    -1,    25,   160,   212,   164,    -1,    25,   160,   164,
      -1,    27,   211,   165,    -1,    27,   160,   212,   164,    -1,
      27,   160,   164,    -1,    28,   211,   165,    -1,    28,   160,
     212,   164,    -1,    28,   160,   164,    -1,    45,   201,   114,
     165,    -1,    45,   114,   165,    -1,    45,   201,   114,   142,
     232,   165,    -1,    45,   114,   142,   232,   165,    -1,    45,
     201,   114,   163,   192,   166,   165,    -1,   202,   119,   165,
      -1,   202,   119,   142,   232,   165,    -1,   202,   119,   163,
     192,   166,   165,    -1,   201,   114,   165,    -1,   201,   114,
     142,   232,   165,    -1,   201,   114,   163,   192,   166,   165,
      -1,   114,   165,    -1,   114,   142,   232,   165,    -1,   206,
      -1,   178,    -1,    51,   207,    -1,   119,    -1,   119,   121,
      -1,    51,   209,    -1,   209,    -1,   210,    -1,   211,   141,
     209,    -1,   211,   141,   210,    -1,   207,    -1,   208,    -1,
     212,   207,    -1,   212,   208,    -1,   114,   163,    -1,    94,
     163,    -1,   120,    -1,   219,   213,   192,   166,   216,   222,
     180,    -1,   219,   201,   213,   192,   166,   216,   180,    -1,
     219,   213,   192,   166,   216,   222,   165,    -1,   219,   201,
     213,   192,   166,   216,   165,    -1,   220,   121,   163,   192,
     166,   216,   222,   180,    -1,   220,   201,   121,   163,   192,
     166,   216,   180,    -1,   220,   121,   163,   192,   166,   216,
     222,   165,    -1,   220,   201,   121,   163,   192,   166,   216,
     165,    -1,   121,   163,   192,   166,   216,   222,   180,    -1,
     201,   121,   163,   192,   166,   216,   180,    -1,   144,   217,
      -1,    -1,   218,    -1,   217,   141,   218,    -1,   114,   163,
     192,   166,    -1,   121,   163,   192,   166,    -1,    -1,   220,
      -1,   221,    -1,   220,   221,    -1,    25,    -1,    27,    -1,
      26,    -1,    45,    -1,    29,    -1,    30,    -1,    28,    -1,
      48,    -1,    49,    -1,     4,   202,    -1,    -1,    15,   213,
     192,   166,   222,   180,    -1,   201,    15,   213,   192,   166,
     180,    -1,   220,    15,   213,   192,   166,   222,   180,    -1,
     220,   201,    15,   213,   192,   166,   180,    -1,    15,   121,
     163,   192,   166,   222,   180,    -1,   201,    15,   121,   163,
     192,   166,   180,    -1,   220,    15,   121,   163,   192,   166,
     222,   180,    -1,   220,   201,    15,   121,   163,   192,   166,
     180,    -1,   232,   141,   232,    -1,   232,   141,    -1,   233,
     141,   232,    -1,   233,   141,    -1,   228,    -1,   227,   141,
     228,    -1,   227,   141,    -1,   232,   144,   232,    -1,   160,
     227,   164,    -1,   115,   227,   164,    -1,   115,   164,    -1,
     235,    -1,   130,    -1,   163,   227,   166,    -1,   121,    -1,
     202,   117,    -1,   202,   122,    -1,   201,   114,    -1,     6,
     201,   114,    -1,     6,   114,    -1,     6,   202,   117,    -1,
       6,   163,   225,   166,    -1,   174,    -1,   114,    -1,   123,
      -1,    19,    -1,   124,    -1,    20,   232,    22,   232,    11,
     163,   232,   166,    -1,    89,   232,    -1,    93,   232,    -1,
      94,   232,    -1,    69,   232,    -1,    72,   232,    -1,    70,
     232,    -1,    71,   232,    -1,    73,   232,    -1,    74,   232,
      -1,   104,   232,    -1,   105,   232,    -1,   100,   232,    -1,
     101,   232,    -1,   102,   232,    -1,   103,   232,    -1,    57,
     232,    -1,    58,   232,    -1,   134,   163,   192,   166,    -1,
     120,   192,   166,    -1,   119,    -1,   151,   232,    -1,   150,
     232,    -1,   157,   232,    -1,   159,   232,    -1,   158,   232,
      -1,    95,   114,   163,   192,   166,    -1,    95,   121,   163,
     192,   166,    -1,    95,   116,   163,   192,   166,    -1,    96,
     232,    -1,   118,    -1,   163,   232,   166,    -1,   163,   166,
      -1,    15,   163,   192,   166,   222,   180,    -1,   201,    15,
     163,   192,   166,   180,    -1,   220,    15,   163,   192,   166,
     222,   180,    -1,   220,   201,    15,   163,   192,   166,   180,
      -1,   137,    -1,   106,    -1,    23,   232,    -1,    24,   232,
      -1,   125,   163,   232,   166,    -1,   126,   163,   232,   166,
      -1,   231,    -1,   225,    -1,   229,    -1,   230,    -1,   160,
     164,    -1,   232,    59,   232,    -1,   232,    60,   232,    -1,
     232,    61,   232,    -1,   232,    62,   232,    -1,   232,    63,
     232,    -1,   232,    64,   232,    -1,   232,    65,   232,    -1,
     232,    66,   232,    -1,   232,    67,   232,    -1,   232,    68,
     232,    -1,   232,   142,   232,    -1,   232,   109,   232,    -1,
     232,    90,   201,    -1,   232,   107,   232,    -1,   232,   108,
     232,    -1,   232,   143,   232,   144,   232,    -1,   232,    57,
      -1,   232,    58,    -1,   232,   163,   192,   166,    -1,   232,
      75,   232,    -1,   232,    76,   232,    -1,   232,    77,   232,
      -1,   232,    78,   232,    -1,   232,    79,   232,    -1,   232,
     145,   232,    -1,   232,   147,   232,    -1,   232,   146,   232,
      -1,   232,    87,   135,    -1,   232,    88,   135,    -1,   232,
      87,   131,    -1,   232,    87,   132,    -1,   232,    87,   136,
      -1,   232,   149,   232,    -1,   232,   148,   232,    -1,   232,
      84,   232,    -1,   232,    80,   232,    -1,   232,    85,   232,
      -1,   232,    86,   232,    -1,   232,    81,   232,    -1,   232,
      82,   232,    -1,   232,    83,   232,    -1,   232,    92,   232,
      -1,   232,    91,   232,    -1,   232,   150,   232,    -1,   232,
     151,   232,    -1,   232,   152,   232,    -1,   232,   154,   232,
      -1,   232,   153,   232,    -1,   232,   161,   232,   110,   167,
      -1,   232,   161,   110,   232,   167,    -1,   232,   161,   110,
     167,    -1,   232,   161,   232,   167,    -1,   232,   160,   232,
     164,    -1,   232,   110,   232,    -1,   232,   162,   232,    -1,
     232,   138,    -1,   231,    -1,   226,    -1,   233,    59,   232,
      -1,   233,    60,   232,    -1,   233,    61,   232,    -1,   233,
      62,   232,    -1,   233,    63,   232,    -1,   233,    64,   232,
      -1,   233,    65,   232,    -1,   233,    66,   232,    -1,   233,
      67,   232,    -1,   233,    68,   232,    -1,   233,   142,   232,
      -1,   233,   109,   232,    -1,   233,    90,   201,    -1,   233,
     107,   232,    -1,   233,   108,   232,    -1,   233,   143,   232,
     144,   232,    -1,   233,    57,    -1,   233,    58,    -1,   233,
     163,   192,   166,    -1,   233,    75,   232,    -1,   233,    76,
     232,    -1,   233,    77,   232,    -1,   233,    78,   232,    -1,
     233,    79,   232,    -1,   233,   145,   232,    -1,   233,   147,
     232,    -1,   233,   146,   232,    -1,   233,    87,   135,    -1,
     233,    88,   135,    -1,   233,    87,   131,    -1,   233,    87,
     132,    -1,   233,    87,   136,    -1,   233,   149,   232,    -1,
     233,   148,   232,    -1,   233,    84,   232,    -1,   233,    80,
     232,    -1,   233,    85,   232,    -1,   233,    86,   232,    -1,
     233,    81,   232,    -1,   233,    82,   232,    -1,   233,    83,
     232,    -1,   233,    92,   232,    -1,   233,    91,   232,    -1,
     233,   150,   232,    -1,   233,   151,   232,    -1,   233,   152,
     232,    -1,   233,   154,   232,    -1,   233,   153,   232,    -1,
     233,   161,   232,   110,   167,    -1,   233,   161,   110,   232,
     167,    -1,   233,   161,   110,   167,    -1,   233,   161,   232,
     167,    -1,   233,   160,   232,   164,    -1,   233,   110,   232,
      -1,   233,   162,   232,    -1,   233,   138,    -1,   129,    -1,
     129,   234,    -1,   112,    -1,   111,    -1,   234,    -1,   128,
      -1,   113,    -1,    53,    -1,    52,    -1,    54,    -1,    55,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1855,  1855,  1856,  1860,  1863,  1868,  1876,  1880,  1886,
    1890,  1895,  1903,  1904,  1908,  1915,  1925,  1950,  1952,  1957,
    1971,  1972,  1978,  1987,  1994,  2001,  2006,  2015,  2022,  2027,
    2036,  2043,  2050,  2055,  2064,  2071,  2079,  2088,  2095,  2105,
    2110,  2118,  2123,  2126,  2134,  2137,  2140,  2145,  2148,  2156,
    2162,  2165,  2171,  2174,  2180,  2183,  2188,  2191,  2196,  2198,
    2200,  2202,  2208,  2209,  2213,  2214,  2244,  2251,  2253,  2256,
    2259,  2262,  2265,  2268,  2271,  2274,  2277,  2280,  2283,  2286,
    2289,  2292,  2295,  2298,  2299,  2307,  2310,  2313,  2314,  2319,
    2320,  2331,  2333,  2335,  2340,  2342,  2346,  2355,  2359,  2367,
    2373,  2379,  2385,  2391,  2397,  2403,  2409,  2415,  2421,  2427,
    2432,  2437,  2442,  2447,  2452,  2457,  2463,  2469,  2474,  2482,
    2530,  2531,  2532,  2536,  2542,  2551,  2558,  2567,  2576,  2587,
    2596,  2610,  2613,  2619,  2622,  2629,  2633,  2637,  2641,  2645,
    2649,  2653,  2657,  2661,  2665,  2672,  2680,  2696,  2701,  2706,
    2733,  2737,  2743,  2749,  2755,  2761,  2765,  2770,  2775,  2780,
    2789,  2792,  2795,  2799,  2802,  2805,  2813,  2814,  2820,  2821,
    2822,  2826,  2827,  2828,  2829,  2830,  2831,  2835,  2836,  2837,
    2841,  2846,  2850,  2856,  2860,  2883,  2891,  2899,  2924,  2931,
    2938,  2962,  2968,  2974,  2977,  2987,  2994,  3000,  3009,  3016,
    3019,  3022,  3026,  3033,  3036,  3039,  3043,  3050,  3053,  3056,
    3062,  3074,  3090,  3098,  3113,  3124,  3137,  3143,  3152,  3156,
    3166,  3169,  3175,  3178,  3185,  3189,  3197,  3198,  3203,  3204,
    3214,  3215,  3216,  3217,  3218,  3219,  3220,  3221,  3222,  3226,
    3243,  3249,  3255,  3265,  3277,  3295,  3301,  3311,  3323,  3341,
    3346,  3366,  3371,  3385,  3390,  3394,  3399,  3404,  3414,  3423,
    3432,  3434,  3436,  3438,  3443,  3458,  3470,  3477,  3486,  3497,
    3514,  3549,  3552,  3560,  3565,  3570,  3575,  3580,  3585,  3590,
    3594,  3608,  3612,  3626,  3630,  3634,  3638,  3661,  3687,  3715,
    3731,  3747,  3763,  3767,  3771,  3779,  3785,  3792,  3799,  3804,
    3808,  3812,  3843,  3850,  3857,  3864,  3878,  3884,  3901,  3907,
    3912,  3920,  3929,  3942,  3946,  3950,  3954,  3958,  3962,  3969,
    3970,  3971,  3972,  3973,  3974,  3975,  3976,  3977,  3978,  3979,
    3980,  3981,  3982,  3983,  3984,  3987,  3995,  4002,  4003,  4004,
    4005,  4006,  4007,  4008,  4013,  4014,  4015,  4016,  4021,  4022,
    4028,  4029,  4030,  4031,  4032,  4033,  4034,  4035,  4036,  4037,
    4038,  4039,  4040,  4041,  4042,  4043,  4044,  4045,  4046,  4047,
    4048,  4049,  4050,  4051,  4052,  4056,  4070,  4071,  4072,  4073,
    4077,  4078,  4079,  4080,  4081,  4082,  4083,  4084,  4085,  4086,
    4087,  4088,  4089,  4092,  4100,  4107,  4108,  4109,  4110,  4111,
    4112,  4113,  4118,  4119,  4120,  4121,  4126,  4127,  4133,  4134,
    4135,  4136,  4137,  4138,  4139,  4140,  4141,  4142,  4143,  4144,
    4145,  4146,  4147,  4148,  4149,  4150,  4151,  4152,  4153,  4154,
    4155,  4156,  4157,  4162,  4177,  4178,  4179,  4180,  4184,  4187,
    4195,  4196,  4197,  4198,  4199,  4200,  4201,  4202,  4203
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"",
  "\"thread_local\"", "\"my\"", "\"do\"", "\"try\"", "\"throw\"",
  "\"catch\"", "\"where\"", "\"while\"", "\"if\"", "\"for\"", "\"sub\"",
  "\"thread_exit\"", "\"break\"", "\"continue\"", "\"%%\"", "\"find\"",
  "\"foreach\"", "\"in\"", "\"delete\"", "\"remove\"", "\"private\"",
  "\"private:internal\"", "\"private:hierarchy\"", "\"public\"",
  "\"synchronized\"", "\"deprecated\"", "\"context\"", "\"sortBy\"",
  "\"sortDescendingBy\"", "\"subcontext\"", "\"const\"", "\"summarize\"",
  "\"by\"", "\"our\"", "\"rethrow\"", "\"switch\"", "\"case\"",
  "\"default\"", "\"inherits\"", "\"else\"", "\"static\"", "\"namespace\"",
  "\"module\"", "\"final\"", "\"abstract\"", "\"hashdecl\"",
  "\"transient\"", "\"NULL\"", "\"NOTHING\"", "\"True\"", "\"False\"",
  "\"unreference\"", "\"++ operator\"", "\"-- operator\"",
  "\"+= operator\"", "\"-= operator\"", "\"&= operator\"",
  "\"|= operator\"", "\"%= operator\"", "\"*= operator\"",
  "\"/= operator\"", "\"^= operator\"", "\"<<= operator\"",
  "\">>= operator\"", "\"unshift\"", "\"push\"", "\"pop\"", "\"shift\"",
  "\"chomp\"", "\"trim\"", "\"&& operator\"", "\"|| operator\"",
  "\"|| operator (compat)\"", "\"| operator (compat)\"",
  "\"^ operator (compat)\"", "\"== operator\"", "\"!= operator\"",
  "\"<= operator\"", "\">= operator\"", "\"<=> operator\"",
  "\"=== operator\"", "\"!== operator\"", "\"=~ operator\"",
  "\"!~ operator\"", "\"exists\"", "\"instanceof\"", "\">> operator\"",
  "\"<< operator\"", "\"elements\"", "\"keys\"", "\"new\"",
  "\"background\"", "\"on_exit\"", "\"on_success\"", "\"on_error\"",
  "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"", "\"splice\"",
  "\"extract\"", "\"$# operator\"", "\"?? operator\"", "\"?* operator\"",
  "\":= operator\"", "\".. operator\"", "\"integer value\"",
  "\"floating-point value\"", "\"arbitrary-precision number\"",
  "\"identifier\"", "\"typed hash identifier\"",
  "\"complex type identifier\"", "\"variable reference\"",
  "\"backquote expression\"", "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"cast (or nothing) operator\"",
  "\"simple class declaration\"", "\"date/time value\"",
  "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "hashdecl_def",
  "class_def", "inheritance_list", "superclass_list", "superclass",
  "hashdecl_attrs", "hashdecl_member", "class_attributes", "uncqtypedef",
  "qtypedef", "internal_member_list", "private_member_list",
  "public_member_list", "classvardecl", "member2", "transient_member2",
  "member", "transient_member", "member_list", "member_list2",
  "ident_openparen", "inline_methoddef", "outofline_methoddef",
  "base_constructor_list", "base_constructors", "base_constructor",
  "nsc_modifiers", "method_modifiers", "method_modifier", "return_value",
  "sub_def", "scoped_sub_def", "list", "list_n", "hash", "hash_element",
  "alt_hash", "immediate_typed_hash", "exp_c", "exp", "exp_n", "string",
  "scalar", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    44,    61,    63,    58,   124,    94,    38,    60,    62,
      43,    45,    37,    42,    47,   396,   397,   126,    92,    33,
     123,    91,    46,    40,   125,    59,    41,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   168,   169,   169,   170,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   171,   171,   172,
     173,   173,   174,   174,   174,   174,   174,   174,   174,   174,
     174,   174,   174,   174,   174,   174,   175,   175,   175,   176,
     176,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     178,   178,   179,   179,   180,   180,   181,   181,   182,   182,
     182,   182,   183,   183,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   185,
     185,   186,   186,   186,   187,   187,   188,   189,   189,   190,
     190,   190,   190,   190,   190,   190,   190,   190,   190,   190,
     190,   190,   190,   190,   190,   190,   190,   190,   190,   191,
     192,   192,   192,   193,   193,   194,   194,   194,   194,   194,
     194,   195,   195,   196,   196,   197,   197,   197,   197,   197,
     197,   197,   197,   197,   197,   198,   198,   199,   199,   199,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     201,   201,   201,   201,   201,   201,   202,   202,   203,   203,
     203,   204,   204,   204,   204,   204,   204,   205,   205,   205,
     206,   206,   206,   206,   206,   207,   207,   207,   207,   207,
     207,   207,   207,   207,   207,   208,   209,   209,   210,   211,
     211,   211,   211,   212,   212,   212,   212,   213,   213,   213,
     214,   214,   214,   214,   215,   215,   215,   215,   215,   215,
     216,   216,   217,   217,   218,   218,   219,   219,   220,   220,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   222,
     222,   223,   223,   223,   223,   224,   224,   224,   224,   225,
     225,   226,   226,   227,   227,   227,   228,   229,   230,   230,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   234,   234,
     235,   235,   235,   235,   235,   235,   235,   235,   235
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     4,     1,     1,     2,     4,
       0,     1,     4,     3,     4,     3,     4,     4,     5,     4,
       3,     4,     3,     4,     4,     5,     5,     3,     4,     1,
       2,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       5,     6,     5,     6,     3,     2,     1,     1,     1,     1,
       2,     2,     0,     1,     1,     2,     5,     1,     2,     3,
       3,     2,     2,     2,     3,    11,     7,     5,     7,     5,
       7,     9,     7,     2,     2,     2,     2,     1,     2,     0,
       2,     4,     4,     4,     1,     2,     7,     1,     2,     5,
       4,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     4,     3,     4,     3,     3,     2,     7,
       0,     1,     1,     6,     6,     6,     6,     4,     4,     5,
       5,     2,     0,     1,     3,     1,     1,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     2,     3,     5,     6,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     2,
       1,     1,     1,     2,     2,     2,     0,     1,     3,     4,
       3,     3,     4,     3,     3,     4,     3,     3,     4,     3,
       4,     3,     6,     5,     7,     3,     5,     6,     3,     5,
       6,     2,     4,     1,     1,     2,     1,     2,     2,     1,
       1,     3,     3,     1,     1,     2,     2,     2,     2,     1,
       7,     7,     7,     7,     8,     8,     8,     8,     7,     7,
       2,     0,     1,     3,     4,     4,     0,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     6,     6,     7,     7,     7,     7,     8,     8,     3,
       2,     3,     2,     1,     3,     2,     3,     3,     3,     2,
       1,     1,     3,     1,     2,     2,     2,     3,     2,     3,
       4,     1,     1,     1,     1,     1,     8,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     4,     3,     1,     2,     2,     2,
       2,     2,     5,     5,     5,     2,     1,     3,     2,     6,
       6,     7,     7,     1,     1,     2,     2,     4,     4,     1,
       1,     1,     1,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       2,     2,     4,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     5,     4,     4,     4,     3,     3,     2,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     5,     2,     2,
       4,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       5,     5,     4,     4,     4,     3,     3,     2,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,    20,   166,     0,     0,    20,     0,     0,     0,
       0,     0,     0,     0,   274,    20,    20,    20,    20,   230,
     232,   231,   236,   234,   235,    62,    89,     0,    62,    20,
       0,   233,     0,   237,   238,   446,   445,   447,   448,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
       0,    20,     0,     0,     0,    20,    20,    20,    20,    20,
      20,   314,   441,   440,   444,   272,   162,   306,   296,     0,
     263,   273,   275,     0,     0,   443,   438,   261,     0,   313,
      16,    20,    20,     0,    20,    20,    20,     0,    20,    64,
       0,     2,     0,   271,    14,     9,     8,    11,     0,    87,
      67,     7,     6,   167,     0,    10,     0,   227,   228,     4,
       5,   381,   380,     0,   442,   260,    88,     0,   236,    20,
     263,    20,   167,     0,   320,   321,   322,   319,    95,   268,
     161,    20,   167,     0,   263,     0,    57,     0,    56,     0,
       0,    20,    20,     0,     0,     0,   209,     0,     0,     0,
      84,    85,    86,     0,     0,   315,   316,     0,    63,     0,
       0,     0,     0,     0,    68,     0,    20,     0,   292,   293,
     280,   282,   283,   281,   284,   285,   277,   278,   279,     0,
       0,     0,   305,    71,    72,    73,   288,   289,   290,   291,
     286,   287,   122,     0,   121,     0,    20,    20,   439,     0,
     298,   297,   163,   165,   164,   299,   301,   300,    12,    59,
       0,    58,   308,     0,   253,     0,     1,     3,   166,   166,
      83,     0,   266,     0,   264,   265,     0,     0,   132,   132,
       0,   236,   160,   161,     0,   229,   398,   399,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
       0,     0,     0,    20,    20,    20,    20,    20,    20,   437,
     252,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,     0,    65,   259,     0,
       0,   323,     0,     0,     0,     0,   340,   341,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
       0,     0,     0,    20,    20,    20,    20,    20,    20,   379,
     250,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,     0,   320,     0,   267,
     269,     0,    55,     0,     0,     0,    70,     0,     0,     0,
     208,   207,     0,     0,     0,    20,     0,     0,     0,    20,
       0,     0,     0,    74,    90,    20,    20,    20,    69,     0,
       0,     0,    17,     0,     0,     0,   295,     0,     0,     0,
       0,    13,    60,    61,   255,   262,    20,   307,    32,    30,
      20,   167,     0,    25,    23,    20,   167,     0,     0,     0,
       0,     0,   226,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   401,   402,   403,   404,   405,
     417,   420,   421,   422,   416,   418,   419,   411,   412,   409,
     413,   410,   394,   424,   423,   395,   396,   393,   435,   251,
     392,     0,   406,   408,   407,   415,   414,   425,   426,   427,
     429,   428,     0,    20,     0,   436,     0,   258,   257,     0,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     343,   344,   345,   346,   347,   359,   362,   363,   364,   358,
     360,   361,   353,   354,   351,   355,   352,   336,   366,   365,
     337,   338,   335,   377,   249,   334,     0,   348,   350,   349,
     357,   356,   367,   368,   369,   371,   370,     0,    20,     0,
     378,     0,   270,     0,    54,    20,     0,     0,     0,     0,
       0,   240,   240,     0,    20,    20,    20,     0,    20,    20,
      20,     0,     0,     0,     0,    20,    15,    18,     0,     0,
       0,   221,   317,   318,   294,   254,   256,   320,    31,    29,
      34,    33,   320,    24,    22,    27,    26,     0,     0,     0,
       0,     0,   161,    38,     0,    48,   226,    39,    42,    41,
      44,    43,     0,    49,   227,    45,    46,     0,     0,     0,
       0,     0,     0,   135,   136,   131,   133,   226,   127,   226,
     128,     0,     0,     0,     0,     0,     0,     0,     0,    20,
     434,   432,     0,    20,   433,   400,    20,   376,   374,     0,
      20,   375,   342,     0,     0,     0,    79,    77,     0,   240,
     166,     0,     0,     0,     0,     0,     0,    89,     0,     0,
       0,    50,    52,     0,     0,     0,   302,   304,   303,     0,
      66,   240,    35,    28,     0,     0,     0,   221,     0,    47,
      36,    40,     0,     0,     0,     0,   145,     0,     0,   139,
     140,   143,   144,   141,   142,   137,   138,     0,   230,   232,
     231,   236,     0,   129,   154,   226,   151,   152,   153,   150,
       0,   227,   130,   226,     0,   240,   240,   221,     0,     0,
       0,     0,   397,   431,   430,   339,   373,   372,     0,     0,
       0,     0,     0,   167,   239,   309,   241,    20,     0,    51,
      53,     0,    91,    92,    93,     0,    20,     0,     0,    97,
      19,     0,     0,   220,   222,     0,     0,   310,   242,     0,
       0,     0,   123,   146,     0,   124,   134,     0,   196,   166,
     199,   200,     0,   166,     0,   166,     0,     0,   166,     0,
     125,   159,   156,   157,   158,   155,   160,     0,     0,   126,
     240,     0,     0,   240,     0,     0,     0,   221,    80,   119,
      78,     0,   245,     0,    82,    76,    20,    20,    20,    20,
       0,     0,     0,    20,    20,     0,     0,    96,    98,     0,
       0,     0,   218,   246,   219,   221,    20,     0,   147,   198,
     197,     0,     0,   166,   160,   173,   194,   167,     0,   193,
     203,   204,   166,     0,   171,   170,   166,   168,   176,   166,
     174,   179,   166,   177,     0,     0,     0,   311,   243,     0,
       0,   312,   244,     0,     0,   276,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   223,
       0,     0,   160,     0,   195,    20,   191,     0,     0,   172,
     205,   206,   201,   202,   169,   175,   178,     0,   221,   247,
     216,   214,   248,   217,   215,    81,    89,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   224,   225,   148,     0,
      20,   181,     0,     0,    20,     0,   188,    20,     0,   185,
     221,   240,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,    20,     0,   180,   192,     0,     0,     0,     0,
       0,     0,    75,   183,     0,     0,   189,     0,   186,     0,
     213,   211,   212,   210,   182,     0,   190,   187,   184
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    90,    91,   381,   382,    92,    93,    94,   586,   587,
     826,    96,   136,   137,   210,   159,   138,   160,   374,    98,
      99,   738,   739,   100,   193,   101,   102,   417,   605,   606,
     675,   676,   695,   122,   104,   696,   697,   698,   829,   830,
     831,   760,   761,   762,   832,   149,   699,   105,   661,   743,
     744,   106,   123,   108,   641,   109,   110,   124,   111,   213,
     214,   125,   126,   127,   194,   113,   114,   115
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -699
static const yytype_int16 yypact[] =
{
    1540,   -84,  6865,    22,  5822,  5822,  8039,   -63,    -9,    20,
     366,   -52,    94,   154,  -699,  8039,  8039,  8039,  8039,  -699,
    -699,  -699,    55,  -699,  -699,   106,  -699,   258,   106,  7014,
     181,  -699,   200,  -699,  -699,  -699,  -699,  -699,  -699,  8039,
    8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,
     291,  8039,  5822,  5822,  5822,  8039,  8039,  8039,  8039,  8039,
    8039,  -699,  -699,  -699,  -699,    49,  -699,  -699,  -699,  1376,
     -12,  -699,  -699,   198,   207,  -699,   254,  -699,   234,  -699,
    -699,  8039,  8039,   490,  8039,  8039,  8039,  5162,  6716,  -699,
    1215,  -699,    99,  -699,  -699,  -699,  -699,  -699,   246,  -699,
    -699,  -699,  -699,    35,    79,  -699,   102,   702,  -699,  -699,
    -699,  -699,  -699, 10570,  -699,  -699,  -699,   260,   103,  7309,
      36,  7455,    46,   995,  -699,  -699,  -699,  -699, 13275,   116,
    -699,  8039,   311,   321,    10,  5327,  -699,   455,  -699,   458,
   10679,  8039,  8039,  5983,   313,   315,  -699,   335,  1376,  1376,
    -699,  -699,  -699,  8262,  8369,    30,    30,   312,  -699,   350,
    1701,   381,   394,   376,  -699, 10788,  8039,   436,   561,   561,
   13275, 13275,    30,    30,    30,    30,   939,    30,    30,   402,
     425,   433,    30,  -699,  -699,  -699, 13275, 13275, 13275, 13275,
   13275, 13275,  -699,   420, 13275,  1376,  8039,  8039,  -699,  1376,
      30,    30,  -699,  -699,  -699,    30,    30,    30,  -699,  -699,
    5492,  -699,  -699,   -67,  -699,  8920,  -699,  -699,   563,   735,
    -699,   389,  -699,   449,  -699,  -699,   130,   334,   583,   583,
     397,  -699,  -699,   472,    -5,  -699,  -699,  -699,  8039,  8039,
    8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,
    8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,
     627,   503,   279,  8039,  8039,  8039,  8039,  8039,  8039,  -699,
    7163,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,
    8039,  8039,  8039,  8039,  7747,  8039,  1376,  -699,  -699,   -79,
   12312,  -699,   -38,   484,   492,   641,  -699,  -699,  8039,  8039,
    8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,
    8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,
     676,   539,   279,  8039,  8039,  8039,  8039,  8039,  8039,  -699,
    7163,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,  8039,
    8039,  8039,  8039,  8039,  7893,  8039,  1376,   510, 13275,  -699,
    -699,  1376,  -699,  5657,   523,   529,  -699,  9030,  9140,   528,
    -699,  -699,  1376,   546,   567,  8039,   531,   593,   596,  8039,
     576,   577,   578,  -699,  -699,  8039,  8039,  8039,  -699,  9250,
     600,   -46,  -699,  1376,  1376,  1376,  -699,   587,  9360,  9470,
     591,  -699,  -699,  -699,  7163,  -699,  8039,  -699,   352,   597,
    8039,   386,   240,   352,   597,  8039,   442,   423,   602,  1376,
    1376,  1376,   361,  -699,   606,   611,   326,   293,   460,   609,
    1376,  1376,  1376,   540,   612, 13382, 13382, 13382, 13382, 13382,
   13382, 13382, 13382, 13382, 13382, 13748, 13712, 13748, 13919, 13919,
     939,   939,   939,   939,   939,   939,   939,  -699,  -699,  -699,
    -699,  -699,  -699,    65,    65, 13614, 13614, 13382, 13578, 13382,
   13382, 12419, 13834, 13870, 13919,   939,   939,   722,   722,   447,
      30,    30, 12096,  6132,  8476,  -699,   594,  -699,  -699,   613,
   13382, 13382, 13382, 13382, 13382, 13382, 13382, 13382, 13382, 13382,
   13748, 13712, 13748, 13919, 13919,   939,   939,   939,   939,   939,
     939,   939,  -699,  -699,  -699,  -699,  -699,  -699,    65,    65,
   13614, 13614, 13382, 13578, 13382, 13382, 12526, 13834, 13870, 13919,
     939,   939,   722,   722,   447,    30,    30, 12204,  6278,  8587,
    -699,   620,  -699,   623,  -699,  8039,  1376,  5822,  5822,  5983,
     624,   773,   773,  8155,  8039,  8039,  8039,  9580,  8039,  8039,
    8039, 10897, 11006,  9690,   631,  8039,  -699,  -699,   626,   632,
     633,   215,  -699,  -699,  -699,  -699, 13382,   634,  -699,  -699,
    -699,  -699,   643,  -699,  -699,  -699,  -699,  1376,   649,   654,
     655,    88,   656,  -699,   659,  -699,   416,  -699,  -699,  -699,
    -699,  -699,    57,  -699,  1031,  -699,  -699,   279,   279,   468,
     469,   515,   532,  -699,  -699,   685,  -699,   320,  -699,   467,
    -699,  1376,   663,   665,   666,   671,  1376,  1376,  1376,  8039,
    -699,  -699,  8698,  6424,  -699,  -699,  8039,  -699,  -699,  8809,
    6570,  -699,  -699,   673,  9800,   677,  -699,   802,   693,   773,
     279,   690,   690,   691,  9910, 11115, 11224,  -699, 10020, 10130,
   10240,  -699,  -699,   822,   190, 11333,  -699,  -699,  -699,   537,
    -699,   773,  -699,  -699,   699,   690,   690,   725,  1376,  -699,
    -699,  -699,   264,   414,    58,   406,  -699,   752,   689,  -699,
    -699,  -699,  -699,  -699,  -699,  -699,  -699,   326,   -30,    12,
      14,     1,   765,  -699,  -699,   549,  -699,  -699,  -699,  -699,
     719,   960,  -699,   614,   714,   773,   773,   725,  1376,   726,
     728,   729, 13480,  -699,  -699, 13480,  -699,  -699,   731,  5822,
    5822,  1376,   690,  -699,  -699,  -699,  -699,  8039,  5822,  -699,
    -699,  1701,  -699,  -699,  -699,   736,  7601,   747,    -7,  -699,
    -699,   737,   738,   764,  -699,   690,   690,  -699,  -699,   690,
     740,   437,  -699,  -699,   -21,  -699,  -699,   788,   792,   385,
    -699,  -699,   -50,   536,   -40,   640,   119,   795,   653,   153,
    -699,  -699,  -699,  -699,  -699,  -699,   315,   288,  1376,  -699,
     773,   690,   690,   773,   748,   690,   690,   725,  -699,  -699,
    -699,   750,  -699, 10350,  -699,  -699,  8039,  8039,  8039,  8039,
     782,   783,   775,  8039,  8039, 12633,  1862,  -699,  -699,  1376,
    1376,   537,  -699,  -699,  -699,   725,  8039,  1376,  -699,  -699,
    -699,   885,   452,   336,     4,  -699,  -699,   818,   823,  -699,
    -699,  -699,   817,    15,  -699,  -699,   842,  -699,  -699,  1255,
    -699,  -699,  1409,  -699,  1376,   770,   690,  -699,  -699,   507,
     690,  -699,  -699,   513,  5822,  -699, 10460, 12740, 12847, 12954,
     799,   800,  2027, 13061, 13168,  2192,  2357,   779,   791,  -699,
   11442,   794,    56,   848,  -699,  8039,  -699,   259,   274,  -699,
    -699,  -699,  -699,  -699,  -699,  -699,  -699,   801,   725,  -699,
    -699,  -699,  -699,  -699,  -699,  -699,  -699,  2522,  2687,  2852,
    3017,  3182,  3347,  3512,  3677,  3842,  -699,  -699,  -699,   803,
    8039,  -699,   307, 11551,  8039,  1376,  -699,  8039,  1376,  -699,
     725,   773,  1701,  4007,  4172,  4337,  4502,  4667,  4832,  4997,
    -699, 11660,  8039,  1376,  -699,  -699, 11769,   805, 11878,   816,
     522,   555,  -699,  -699, 11987,   826,  -699,   804,  -699,   819,
    -699,  -699,  -699,  -699,  -699,   828,  -699,  -699,  -699
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -699,  -699,   875,  -699,   585,  -699,  -410,  -400,  -699,   426,
       6,  -389,   269,    17,  -116,   955,    75,  -638,  -699,  -699,
    -699,  -699,   273,  -699,   286,  -386,  -382,   784,  -699,   329,
     419,  -219,   417,     5,   196,  -597,  -548,  -514,  -699,    25,
    -209,  -698,   194,   -25,  -244,  -210,  -481,  -381,  -600,  -699,
     222,  -515,     7,  -106,  -494,  -380,  -379,  -113,  -699,   172,
     642,  -699,  -699,    24,    -2,  -699,   958,  -699
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -227
static const yytype_int16 yytable[] =
{
     128,   235,   584,  -161,   140,   103,    95,   107,   132,   731,
     423,   410,   585,   153,   154,   155,   156,   235,   347,   353,
     421,   757,   139,   589,   112,  -161,   590,   165,   112,   112,
     591,   593,   595,   596,   736,   737,   767,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   642,   182,
     221,  -161,   757,   186,   187,   188,   189,   190,   191,   819,
     -21,   293,   394,   757,  -160,   757,   757,   749,   380,   183,
     184,   185,   672,   751,   394,    97,   112,   112,   112,   200,
     201,   116,   205,   206,   207,   477,   215,   296,   297,   758,
     157,   833,   700,   -21,   700,   103,    95,   107,   772,   395,
     141,   833,  -161,   394,   218,  -161,   772,   783,   -21,  -161,
    -161,   112,   234,   150,   112,   834,   424,   290,   556,   290,
     758,   816,   296,   297,  -161,   837,   478,  -161,   295,   348,
     759,   758,  -161,   758,   758,   882,   129,   219,    66,   357,
     358,   -21,   817,   130,   818,   722,   875,   773,   226,   222,
    -161,   195,   227,  -161,   142,   773,   223,   807,  -161,   112,
     222,   768,   211,  -160,   379,    97,  -160,   745,   329,   876,
    -160,  -160,   763,   351,   765,    83,   584,   373,   223,   424,
     700,   774,   144,   143,   112,   131,   585,   853,   700,   774,
     343,   344,   345,   346,   388,   389,   224,   589,   910,   133,
     590,   225,   145,   329,   591,   593,   595,   596,   146,   147,
     211,   781,   782,   617,   775,   338,   339,   340,   341,   342,
     158,   911,   775,   401,   406,   343,   344,   345,   346,   228,
    -160,   736,   737,  -160,   112,   229,   425,   426,   427,   428,
     429,   430,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,   444,   445,   446,   922,   151,
     833,   453,   454,   455,   456,   457,   458,   452,   459,   460,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   474,   475,   840,   393,   846,   567,   921,   849,
     412,   289,   572,   292,   833,   413,   480,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,   498,   499,   500,   501,   843,   152,
     940,   508,   509,   510,   511,   512,   513,   507,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,   529,   530,   166,   688,   689,   690,   691,    23,
      24,   599,   600,   601,   602,   692,   209,   570,   144,   659,
     167,   196,   571,   543,   821,    31,   -20,   547,    33,    34,
     197,   692,   161,   551,   552,   553,   581,   112,   145,   162,
     660,   822,   144,    76,   146,   408,    19,    20,    21,    22,
      23,    24,   290,   232,   566,    66,    27,   199,   348,   -20,
     130,   914,   145,   348,   209,   179,    31,   180,   146,    33,
      34,   220,   181,   821,   402,   407,   917,   592,   588,   594,
     692,   -20,   915,   148,   916,   349,   367,   941,   393,   359,
     822,   581,    83,   368,   363,   364,   823,   918,   350,   919,
     603,    19,    20,    21,    22,    23,    24,   604,   414,   932,
     824,    27,    66,   607,   -20,   415,   753,   130,   608,   753,
     144,    31,   410,   421,    33,    34,  -160,   354,   355,  -160,
     933,   622,   934,  -160,  -160,   232,   360,    66,   361,   392,
     145,   387,   582,   144,   693,   390,   146,   147,   235,    83,
     778,   144,   688,   689,   690,   691,    23,    24,   362,   824,
     568,    66,   692,   145,   296,   297,   130,   569,   144,   146,
     408,   145,    31,   369,    83,    33,    34,   146,   419,   836,
     232,   839,    66,   375,   842,   583,   629,   130,   145,   148,
     232,   144,    66,   634,   146,   419,   376,   582,    83,   377,
     575,   617,   644,   645,   646,   576,   648,   649,   650,   825,
     380,   145,   409,   655,   636,   637,   573,   146,   615,    83,
     420,   112,   112,   574,   821,   383,   872,   844,    66,    83,
     752,   692,   476,   130,   688,   689,   690,   691,    23,    24,
     670,   822,   679,   681,   692,   329,   386,   823,   384,   680,
     682,   592,   588,   594,    31,   235,   385,    33,    34,   674,
     341,   342,   677,   677,   202,    83,   203,   343,   344,   345,
     346,   204,   411,   694,   701,   694,   701,   712,  -227,  -227,
     609,   513,   392,   881,   715,   610,   416,   881,   513,   683,
     881,   702,   531,   881,   144,   422,   684,   533,   451,   688,
     689,   690,   691,    23,    24,   723,   685,   409,   540,   692,
     824,   741,    66,   686,   145,   420,   479,   130,   742,    31,
     146,   615,    33,    34,   764,   766,   769,   135,   821,   558,
     559,   560,   890,   135,   506,   692,   532,   398,   893,    66,
     677,   821,   135,   677,   399,   822,   535,   950,   692,    83,
     866,   823,   536,   539,   544,   578,   579,   580,   822,   329,
     835,   771,   701,   616,   823,   777,   612,   613,   614,   771,
     701,  -161,   541,   770,  -161,   135,    83,   230,  -161,  -161,
     952,   343,   344,   345,   346,   793,   400,    19,    20,    21,
     231,    23,    24,   542,   805,   545,   789,   790,   546,   548,
     549,   550,   555,   112,   112,   794,   902,    31,   795,   905,
      33,    34,   112,   561,   824,   112,    66,   564,   447,   448,
     625,   130,   449,   450,   827,   577,   597,   824,   827,    66,
     827,   598,   611,   827,   130,   618,   616,   640,   779,   296,
     297,   923,   924,   925,   926,   927,   632,   928,   929,   633,
     639,   654,   656,    83,   856,   857,   858,   859,   657,   658,
     662,   863,   864,   232,   838,    66,    83,   502,   503,   663,
     130,   504,   505,   144,   870,   665,   232,   841,    66,   668,
     666,   667,   635,   233,   669,   638,   687,   873,   827,   705,
     112,   706,   707,   776,   708,    66,   724,   827,   660,   146,
     130,   827,    83,   719,   827,   821,   720,   827,   874,   403,
     135,    66,   692,   755,   727,    83,   404,   880,   721,   735,
     329,   880,   822,   664,   880,   746,   754,   880,   823,   659,
     821,   895,    83,   913,   340,   341,   342,   692,   112,   161,
     780,   211,   343,   344,   345,   346,   112,   822,    83,   112,
     112,   806,   785,   823,   786,   787,   788,   704,   405,   796,
     809,   810,   709,   710,   711,   811,   815,   758,   931,   367,
     725,   726,   936,   820,   850,   938,   854,   860,   861,   862,
     767,   112,   112,   112,   112,   112,   112,   112,   112,   112,
     944,   824,   877,    66,   747,   748,   888,   211,   130,   942,
     211,   393,   878,   900,   901,   906,   112,   112,   112,   112,
     112,   112,   112,   112,   750,   828,   824,   907,    66,   828,
     909,   828,   912,   130,   828,   217,   557,   920,   930,   956,
      83,   947,   211,   211,   211,   211,   211,   393,   211,   211,
     393,   879,   949,   163,   957,    19,    20,    21,   231,    23,
      24,   792,   955,   958,   784,    83,   296,   297,   393,   393,
     393,   393,   393,   393,   393,    31,   884,   791,    33,    34,
     294,   808,   671,   418,   812,   813,   756,   678,   814,   828,
      19,    20,    21,   231,    23,    24,   703,   883,   828,   322,
     323,   324,   828,   869,   198,   828,   565,     0,   828,     0,
      31,     0,     0,    33,    34,     0,   673,     0,     0,     0,
     847,   848,     0,     0,   851,   852,    19,    20,    21,   231,
      23,    24,     0,     0,   845,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   209,    31,   329,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,   338,
     339,   340,   341,   342,     0,   867,   868,     0,     0,   343,
     344,   345,   346,   871,     0,     0,     0,     0,     0,   232,
       0,    66,     0,     0,     0,   889,   130,     0,   891,   892,
       0,     0,   894,     0,     0,     0,     0,     0,     0,     0,
     887,   209,     0,     0,   209,   392,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   232,     0,    66,    83,     0,
       0,     0,   233,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,   209,   209,   209,
     209,   392,   209,   209,   392,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    83,     0,     0,     0,     0,     0,
       0,     0,   392,   392,   392,   392,   392,   392,   392,     0,
       0,   937,     0,     0,   939,     0,     0,     0,     0,   951,
     953,     0,     0,     0,     0,   216,     1,     0,     2,   945,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,    22,    23,    24,    25,     0,     0,    26,
      27,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,  -226,    32,    33,    34,  -226,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,    41,    42,    43,    44,    45,    46,
     692,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     822,     0,     0,     0,    47,     0,   823,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -166,    67,    68,    69,    70,  -166,    71,    72,
      73,    74,  -226,    75,    76,    77,     0,     0,  -226,    78,
       0,     0,    79,     0,    80,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,   824,
       0,    66,    84,    85,    86,    87,   130,   192,    88,     0,
      89,   -20,     3,     0,     0,     0,     0,     0,     0,     0,
       0,   117,     0,     0,     0,    14,    15,     0,     0,    17,
      18,    19,    20,    21,   118,    23,    24,     0,    83,     0,
       0,     0,     0,     0,   -20,     0,     0,     0,     0,   885,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
      37,    38,     0,    39,    40,     0,     0,   821,     0,     0,
       0,     0,     0,     0,   692,    41,    42,    43,    44,    45,
      46,     0,     0,     0,   822,     0,     0,     0,     0,     0,
     823,     0,     0,     0,     0,    47,     0,     0,     0,    48,
      49,    50,    51,     0,     0,     0,    55,    56,    57,    58,
      59,    60,    61,     0,     0,     0,     0,    62,    63,    64,
      65,   119,    66,  -166,    67,    68,    69,   120,  -166,    71,
      72,    73,    74,     0,    75,    76,    77,     0,     0,     0,
      78,     0,     0,    79,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,    66,    81,    82,     0,    83,
     130,     0,     0,    84,    85,    86,   121,     0,     0,    88,
       0,     1,  -120,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    83,    17,    18,    19,    20,    21,    22,    23,
      24,    25,     0,   886,    26,    27,    28,     0,   -20,    29,
      30,     0,     0,     0,     0,    31,  -226,    32,    33,    34,
    -226,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -166,    67,    68,
      69,    70,  -166,    71,    72,    73,    74,  -226,    75,    76,
      77,     0,     0,  -226,    78,     0,     0,    79,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
      87,     0,     1,    88,     2,    89,   -20,     3,     4,     5,
       6,     0,   370,     7,     8,     9,   117,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   118,
      23,    24,    25,   371,   372,    26,     0,    28,     0,   -20,
      29,    30,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,     0,    66,  -166,    67,
      68,    69,   134,  -166,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     0,    83,     0,     0,     0,    84,    85,
      86,   135,     0,     1,    88,     2,    89,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -118,  -118,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -118,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -114,  -114,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -114,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -116,  -116,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -116,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -117,  -117,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -117,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -104,  -104,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -104,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -102,  -102,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -102,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -100,  -100,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -100,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -110,  -110,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -110,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -112,  -112,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -112,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -113,  -113,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -113,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -106,  -106,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -106,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -108,  -108,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -108,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -115,  -115,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -115,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -103,  -103,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -103,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -101,  -101,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -101,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,   -99,   -99,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,   -99,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -109,  -109,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -109,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -111,  -111,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -111,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -105,  -105,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,  -105,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -107,  -107,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -107,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,     0,     0,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,   208,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,   352,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,     0,     0,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,     0,    88,   391,    89,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -166,    67,    68,    69,   134,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,   534,    89,     1,     0,     2,     0,   -20,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   117,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     118,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,     0,     0,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,     0,    66,  -166,
      67,    68,    69,   134,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     0,    83,     0,     0,     0,    84,
      85,    86,   135,     0,   192,    88,     0,    89,   -20,     3,
       0,     0,     0,     0,     0,     0,     0,     0,   117,     0,
       0,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,     0,     0,     0,
       0,   -20,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,   119,    66,
    -166,    67,    68,    69,   120,  -166,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     3,     0,
      84,    85,    86,   121,     0,     0,    88,   117,  -120,     0,
       0,    14,    15,     0,     0,    17,    18,    19,    20,    21,
     118,    23,    24,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,     0,
       0,     0,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,   119,    66,  -166,
      67,    68,    69,   120,  -166,    71,    72,    73,    74,     0,
      75,    76,    77,     0,     0,     0,    78,     0,     0,    79,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,     3,    83,     0,     0,     0,    84,
      85,    86,   121,   117,     0,    88,     0,    14,    15,   621,
       0,    17,    18,    19,    20,    21,   118,    23,    24,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,    37,    38,     0,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,    48,    49,    50,    51,     0,     0,     0,    55,    56,
      57,    58,    59,    60,    61,     0,     0,     0,     0,    62,
      63,    64,    65,   119,    66,  -166,    67,    68,    69,   120,
    -166,    71,    72,    73,    74,     0,    75,    76,    77,     0,
       0,     0,    78,     0,     0,    79,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    81,    82,
       3,    83,     0,     0,     0,    84,    85,    86,   121,   117,
       0,    88,     0,    14,    15,   628,     0,    17,    18,    19,
      20,    21,   118,    23,    24,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,    37,    38,
       0,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,    48,    49,    50,
      51,     0,     0,     0,    55,    56,    57,    58,    59,    60,
      61,     0,     0,     0,     0,    62,    63,    64,    65,   119,
      66,  -166,    67,    68,    69,   120,  -166,    71,    72,    73,
      74,     0,    75,    76,    77,     0,     0,     0,    78,     0,
       0,    79,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    81,    82,     3,    83,     0,     0,
       0,    84,    85,    86,   121,   117,     0,    88,     0,    14,
      15,   714,     0,    17,    18,    19,    20,    21,   118,    23,
      24,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,   119,    66,  -166,    67,    68,
      69,   120,  -166,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     3,    83,     0,     0,     0,    84,    85,    86,
     121,   117,     0,    88,     0,    14,    15,   717,     0,    17,
      18,    19,    20,    21,   118,    23,    24,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
      37,    38,     0,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,    48,
      49,    50,    51,     0,     0,     0,    55,    56,    57,    58,
      59,    60,    61,     0,     0,     0,     0,    62,    63,    64,
      65,   119,    66,  -166,    67,    68,    69,   120,  -166,    71,
      72,    73,    74,     0,    75,    76,    77,     0,     0,     0,
      78,     0,     0,    79,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,    82,     0,    83,
       0,     3,     0,    84,    85,    86,   121,     0,     0,    88,
     117,     0,   212,     0,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   118,    23,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
     119,    66,  -166,    67,    68,    69,   120,  -166,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       3,     0,    84,    85,    86,   121,     0,     0,    88,   117,
     -94,     0,     0,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   118,    23,    24,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,    37,    38,
       0,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,    48,    49,    50,
      51,     0,     0,     0,    55,    56,    57,    58,    59,    60,
      61,     0,     0,     0,     0,    62,    63,    64,    65,   119,
      66,  -166,    67,    68,    69,   120,  -166,    71,    72,    73,
      74,     0,    75,    76,    77,     0,     0,     0,    78,     0,
       0,    79,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    81,    82,     0,    83,   -20,     3,
       0,    84,    85,    86,   121,     0,     0,    88,   117,   164,
       0,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,     0,     0,     0,
       0,   -20,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,   119,    66,
    -166,    67,    68,    69,   120,  -166,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     3,    83,     0,     0,     0,
      84,    85,    86,   121,   117,     0,    88,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   118,    23,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,   119,    66,  -166,    67,    68,    69,
     120,  -166,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     3,    83,     0,     0,     0,    84,    85,    86,   121,
     117,     0,    88,   288,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   118,    23,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
     119,    66,  -166,    67,    68,    69,   120,  -166,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     3,    83,     0,
       0,     0,    84,    85,    86,   121,   117,     0,    88,   291,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   118,
      23,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,   797,     0,   798,   799,     0,     0,     0,   800,   801,
      47,     0,     0,     0,    48,    49,    50,    51,     0,     0,
       0,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,   119,    66,  -166,    67,
      68,    69,   120,  -166,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,   802,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   803,
     804,    81,    82,     3,    83,     0,     0,     0,    84,    85,
      86,   121,   117,     0,    88,     0,    14,    15,     0,     0,
      17,    18,    19,    20,    21,   118,    23,    24,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,     0,     0,     0,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,   473,    62,    63,
      64,    65,   119,    66,  -166,    67,    68,    69,   120,  -166,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     3,
      83,     0,     0,     0,    84,    85,    86,   121,   117,     0,
      88,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,   528,    62,    63,    64,    65,   119,    66,
    -166,    67,    68,    69,   120,  -166,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     3,    83,     0,     0,     0,
      84,    85,    86,   121,   117,     0,    88,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   118,    23,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,   119,    66,  -166,    67,    68,    69,
     120,  -166,    71,    72,    73,    74,   643,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     0,     0,    84,    85,    86,   121,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,     0,     0,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,     0,   322,   323,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,   328,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,     0,     0,     0,     0,     0,
       0,     0,     0,   329,     0,     0,   330,   331,   332,     0,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,     0,     0,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,     0,   322,   323,   324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   325,
     326,   327,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   366,     0,     0,     0,     0,     0,     0,     0,     0,
     329,     0,     0,   330,   331,   332,     0,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,     0,   322,
     323,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325,   326,   327,   328,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   329,     0,     0,
     330,   331,   332,     0,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,     0,     0,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,     0,   322,   323,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   325,   326,   327,   623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,     0,     0,   330,   331,   332,
       0,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,     0,     0,     0,   343,   344,   345,   346,
       0,     0,     0,   624,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,     0,     0,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,     0,   322,   323,   324,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   325,   326,   327,   630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   329,     0,     0,   330,   331,
     332,     0,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,     0,     0,     0,     0,     0,   343,   344,   345,
     346,     0,     0,     0,   631,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,     0,     0,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,     0,   322,   323,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   328,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,     0,     0,   330,
     331,   332,     0,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,     0,     0,     0,   343,   344,
     345,   346,     0,     0,     0,   713,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,     0,   322,
     323,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325,   326,   327,   328,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   329,     0,     0,
     330,   331,   332,     0,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,     0,     0,     0,   343,
     344,   345,   346,     0,     0,     0,   716,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,   396,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   397,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   537,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   538,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   554,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   562,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   563,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   647,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   653,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   718,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   728,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   732,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   733,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   734,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   855,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,   896,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
       0,     0,     0,     0,     0,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,     0,
     262,   263,   264,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   265,   266,   267,
     268,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   269,     0,
       0,   270,   271,   272,     0,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,     0,     0,     0,     0,     0,
     283,   284,   285,   286,     0,   287,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,     0,   322,
     323,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325,   326,   327,   328,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   329,     0,     0,
     330,   331,   332,     0,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,     0,     0,     0,   343,
     344,   345,   346,     0,   356,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,     0,     0,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,     0,   322,   323,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   328,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,     0,     0,   330,
     331,   332,     0,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,     0,     0,     0,   343,   344,
     345,   346,     0,   378,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,     0,     0,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,     0,   322,   323,   324,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   325,   326,   327,   328,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   329,     0,     0,   330,   331,
     332,     0,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,     0,     0,     0,     0,     0,   343,   344,   345,
     346,     0,   651,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,     0,     0,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,     0,   322,   323,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   325,   326,   327,   328,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,     0,     0,   330,   331,   332,
       0,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,     0,     0,     0,   343,   344,   345,   346,
       0,   652,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,     0,     0,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,     0,   322,   323,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,   328,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   329,     0,     0,   330,   331,   332,     0,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
       0,     0,     0,     0,     0,   343,   344,   345,   346,     0,
     729,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,     0,   322,   323,   324,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   325,   326,   327,   328,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   329,     0,     0,   330,   331,   332,     0,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,     0,     0,     0,   343,   344,   345,   346,     0,   730,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,     0,     0,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,     0,   322,   323,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   328,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,     0,     0,   330,   331,   332,     0,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,     0,     0,
       0,     0,     0,   343,   344,   345,   346,     0,   740,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,     0,     0,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,     0,   322,   323,   324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   325,
     326,   327,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     329,     0,     0,   330,   331,   332,     0,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,     0,     0,     0,
       0,     0,   343,   344,   345,   346,     0,   908,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
       0,     0,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
       0,   322,   323,   324,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   325,   326,
     327,   328,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
       0,     0,   330,   331,   332,     0,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,     0,     0,
       0,   343,   344,   345,   346,     0,   935,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,   943,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,     0,   322,
     323,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325,   326,   327,   328,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   329,     0,     0,
     330,   331,   332,     0,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,     0,     0,     0,   343,
     344,   345,   346,     0,   946,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,     0,     0,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,     0,   322,   323,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   328,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,     0,     0,   330,
     331,   332,     0,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,     0,     0,     0,   343,   344,
     345,   346,     0,   948,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,     0,     0,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,     0,   322,   323,   324,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   325,   326,   327,   328,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   329,     0,     0,   330,   331,
     332,     0,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,     0,     0,     0,     0,     0,   343,   344,   345,
     346,     0,   954,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,     0,     0,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,     0,   322,   323,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   325,   326,   327,   328,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,     0,     0,   330,   331,   332,
       0,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     620,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,     0,   322,   323,   324,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   325,   326,   327,   328,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   329,     0,     0,   330,   331,   332,     0,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   627,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,     0,     0,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,     0,   322,   323,   324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   325,
     326,   327,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     329,     0,     0,   330,   331,   332,   396,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,     0,     0,     0,
       0,     0,   343,   344,   345,   346,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,     0,   322,
     323,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325,   326,   327,   328,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   329,     0,     0,
     330,   331,   332,   619,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,     0,     0,     0,   343,
     344,   345,   346,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,     0,     0,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,     0,   322,   323,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   325,   326,   327,   328,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,     0,     0,   330,   331,   332,
     626,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,     0,     0,     0,   343,   344,   345,   346,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,     0,     0,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,     0,   322,   323,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   328,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,     0,     0,   330,   331,   332,   865,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,     0,     0,
       0,     0,     0,   343,   344,   345,   346,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,   331,   332,   897,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,     0,     0,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,     0,   322,   323,   324,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   325,   326,   327,   328,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   329,     0,     0,   330,   331,
     332,   898,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,     0,     0,     0,     0,     0,   343,   344,   345,
     346,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,     0,   322,   323,   324,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   325,   326,   327,   328,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   329,     0,     0,   330,   331,   332,   899,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,     0,     0,     0,   343,   344,   345,   346,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
       0,     0,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
       0,   322,   323,   324,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   325,   326,
     327,   328,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
       0,     0,   330,   331,   332,   903,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,     0,     0,
       0,   343,   344,   345,   346,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,     0,     0,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,     0,   322,   323,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   328,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,     0,     0,   330,
     331,   332,   904,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,     0,     0,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,     0,   322,   323,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,   328,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   329,     0,     0,   330,   331,   332,     0,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
       0,     0,     0,     0,     0,   343,   344,   345,   346,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,     0,     0,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,     0,   322,   323,   324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   325,
     326,   327,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     329,     0,     0,     0,   331,   332,     0,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   296,   297,     0,
       0,     0,   343,   344,   345,   346,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,     0,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,     0,     0,   332,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   296,   297,     0,     0,     0,
     343,   344,   345,   346,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,     0,   322,   323,
     324,   296,   297,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,     0,  -227,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,     0,   322,   323,   324,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,     0,     0,     0,
       0,   325,   326,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,     0,     0,     0,   343,   344,
     345,   346,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   329,     0,     0,     0,     0,     0,     0,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   296,
     297,     0,     0,     0,   343,   344,   345,   346,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   308,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,     0,   322,   323,   324,   296,   297,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,     0,   322,   323,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     329,     0,     0,     0,     0,     0,     0,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,     0,     0,     0,
       0,     0,   343,   344,   345,   346,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,     0,     0,     0,
       0,   296,   297,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,     0,     0,     0,   343,   344,
     345,   346,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,     0,   322,   323,   324,   296,   297,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,     0,
     322,   323,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   329,     0,     0,     0,   296,   297,     0,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,     0,     0,     0,   343,   344,   345,   346,     0,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   329,   322,
     323,   324,     0,     0,     0,     0,     0,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,     0,     0,     0,
     343,   344,   345,   346,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   329,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   336,   337,   338,
     339,   340,   341,   342,     0,     0,     0,     0,     0,   343,
     344,   345,   346
};

static const yytype_int16 yycheck[] =
{
       2,   107,   412,    15,     6,     0,     0,     0,     3,   647,
      15,   221,   412,    15,    16,    17,    18,   123,   131,   135,
     230,    51,     5,   412,     0,    15,   412,    29,     4,     5,
     412,   412,   412,   412,    41,    42,    35,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,   542,    51,
      15,    15,    51,    55,    56,    57,    58,    59,    60,   757,
       5,    15,   141,    51,    15,    51,    51,   667,   114,    52,
      53,    54,    15,    15,   141,     0,    52,    53,    54,    81,
      82,   165,    84,    85,    86,   164,    88,    57,    58,   119,
      35,   141,   607,    38,   609,    90,    90,    90,   695,   166,
     163,   141,   114,   141,     5,   117,   703,   707,     5,   121,
     122,    87,   107,   165,    90,   165,   121,   119,   164,   121,
     119,   142,    57,    58,   114,   165,   164,   117,   123,   131,
     160,   119,   122,   119,   119,   833,   114,    38,   116,   141,
     142,    38,   163,   121,   165,   639,   142,   695,    46,   114,
     114,   163,    50,   117,   163,   703,   121,   164,   122,   135,
     114,   160,    87,   114,   166,    90,   117,   661,   138,   165,
     121,   122,   160,   163,   160,   153,   586,   160,   121,   121,
     695,   695,    94,   163,   160,   163,   586,   787,   703,   703,
     160,   161,   162,   163,   196,   197,   117,   586,   142,     3,
     586,   122,   114,   138,   586,   586,   586,   586,   120,   121,
     135,   705,   706,   423,   695,   150,   151,   152,   153,   154,
     114,   165,   703,   218,   219,   160,   161,   162,   163,   127,
     114,    41,    42,   117,   210,   133,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   896,   165,
     141,   263,   264,   265,   266,   267,   268,   262,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   165,   210,   780,   400,   888,   783,
     160,   119,   405,   121,   141,   165,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   165,   165,
     920,   323,   324,   325,   326,   327,   328,   322,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   163,    25,    26,    27,    28,    29,
      30,    25,    26,    27,    28,    35,    87,   117,    94,   144,
     160,   163,   122,   365,    28,    45,     5,   369,    48,    49,
     163,    35,   114,   375,   376,   377,    15,   353,   114,   121,
     165,    45,    94,   129,   120,   121,    25,    26,    27,    28,
      29,    30,   394,   114,   396,   116,    35,   163,   400,    38,
     121,   142,   114,   405,   135,   114,    45,   116,   120,    48,
      49,   165,   121,    28,   218,   219,   142,   412,   412,   412,
      35,     5,   163,   163,   165,   114,   114,   921,   353,   143,
      45,    15,   153,   121,   148,   149,    51,   163,   117,   165,
     114,    25,    26,    27,    28,    29,    30,   121,   114,   142,
     114,    35,   116,   160,    38,   121,   675,   121,   165,   678,
      94,    45,   672,   673,    48,    49,   114,    12,    10,   117,
     163,   473,   165,   121,   122,   114,   163,   116,   163,   210,
     114,   195,   121,    94,   164,   199,   120,   121,   594,   153,
     700,    94,    25,    26,    27,    28,    29,    30,   163,   114,
     114,   116,    35,   114,    57,    58,   121,   121,    94,   120,
     121,   114,    45,   163,   153,    48,    49,   120,   121,   763,
     114,   765,   116,   142,   768,   164,   528,   121,   114,   163,
     114,    94,   116,   535,   120,   121,   142,   121,   153,   163,
     117,   751,   544,   545,   546,   122,   548,   549,   550,   164,
     114,   114,   163,   555,   537,   538,   114,   120,   121,   153,
     163,   537,   538,   121,    28,   163,   114,   777,   116,   153,
     164,    35,   286,   121,    25,    26,    27,    28,    29,    30,
     164,    45,   114,   114,    35,   138,   166,    51,   163,   121,
     121,   586,   586,   586,    45,   701,   163,    48,    49,   594,
     153,   154,   597,   598,   114,   153,   116,   160,   161,   162,
     163,   121,   163,   607,   607,   609,   609,   619,    57,    58,
     160,   623,   353,   832,   626,   165,    43,   836,   630,   114,
     839,   164,   346,   842,    94,   163,   121,   351,   135,    25,
      26,    27,    28,    29,    30,   640,   114,   163,   362,    35,
     114,   114,   116,   121,   114,   163,    15,   121,   121,    45,
     120,   121,    48,    49,   689,   690,   691,   160,    28,   383,
     384,   385,   165,   160,   135,    35,   166,   114,   165,   116,
     675,    28,   160,   678,   121,    45,   163,   165,    35,   153,
     806,    51,   163,   165,   163,   409,   410,   411,    45,   138,
     164,   695,   695,   163,    51,   700,   420,   421,   422,   703,
     703,   114,   166,   164,   117,   160,   153,    15,   121,   122,
     165,   160,   161,   162,   163,   727,   163,    25,    26,    27,
      28,    29,    30,   166,   736,   142,   719,   720,   142,   163,
     163,   163,   142,   719,   720,   728,   862,    45,   731,   865,
      48,    49,   728,   166,   114,   731,   116,   166,   131,   132,
     166,   121,   135,   136,   759,   163,   160,   114,   763,   116,
     765,   160,   163,   768,   121,   163,   163,     4,   164,    57,
      58,   897,   898,   899,   900,   901,   166,   903,   904,   166,
     166,   160,   166,   153,   796,   797,   798,   799,   166,   166,
     166,   803,   804,   114,   164,   116,   153,   131,   132,   166,
     121,   135,   136,    94,   816,   166,   114,   164,   116,   163,
     166,   166,   536,   121,   165,   539,   141,   822,   823,   166,
     806,   166,   166,   114,   163,   116,   640,   832,   165,   120,
     121,   836,   153,   166,   839,    28,    44,   842,   823,   114,
     160,   116,    35,   164,   163,   153,   121,   832,   165,    37,
     138,   836,    45,   577,   839,   166,   114,   842,    51,   144,
      28,   854,   153,   875,   152,   153,   154,    35,   854,   114,
     166,   806,   160,   161,   162,   163,   862,    45,   153,   865,
     866,   144,   166,    51,   166,   166,   165,   611,   163,   163,
     163,   163,   616,   617,   618,   141,   166,   119,   910,   114,
     641,   642,   914,   121,   166,   917,   166,   135,   135,   144,
      35,   897,   898,   899,   900,   901,   902,   903,   904,   905,
     932,   114,   114,   116,   665,   666,   166,   862,   121,   922,
     865,   866,   119,   144,   144,   166,   922,   923,   924,   925,
     926,   927,   928,   929,   668,   759,   114,   166,   116,   763,
     166,   765,   114,   121,   768,    90,   381,   166,   165,   165,
     153,   166,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   164,   166,    28,   165,    25,    26,    27,    28,    29,
      30,   722,   166,   165,   708,   153,    57,    58,   923,   924,
     925,   926,   927,   928,   929,    45,   164,   721,    48,    49,
      15,   738,   586,   229,   745,   746,   687,   598,   749,   823,
      25,    26,    27,    28,    29,    30,   609,   833,   832,    90,
      91,    92,   836,   811,    76,   839,   394,    -1,   842,    -1,
      45,    -1,    -1,    48,    49,    -1,    15,    -1,    -1,    -1,
     781,   782,    -1,    -1,   785,   786,    25,    26,    27,    28,
      29,    30,    -1,    -1,   778,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   806,    45,   138,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,   152,   153,   154,    -1,   809,   810,    -1,    -1,   160,
     161,   162,   163,   817,    -1,    -1,    -1,    -1,    -1,   114,
      -1,   116,    -1,    -1,    -1,   846,   121,    -1,   849,   850,
      -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     844,   862,    -1,    -1,   865,   866,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   114,    -1,   116,   153,    -1,
      -1,    -1,   121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   897,   898,   899,   900,
     901,   902,   903,   904,   905,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   153,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   923,   924,   925,   926,   927,   928,   929,    -1,
      -1,   915,    -1,    -1,   918,    -1,    -1,    -1,    -1,   940,
     941,    -1,    -1,    -1,    -1,     0,     1,    -1,     3,   933,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      35,    36,    -1,    38,    39,    40,    -1,    -1,    -1,    -1,
      45,    46,    47,    48,    49,    50,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    28,    69,    70,    71,    72,    73,    74,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    -1,    89,    -1,    51,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,    -1,    -1,   133,   134,
      -1,    -1,   137,    -1,   139,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,   114,
      -1,   116,   157,   158,   159,   160,   121,     1,   163,    -1,
     165,     5,     6,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    15,    -1,    -1,    -1,    19,    20,    -1,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,   153,    -1,
      -1,    -1,    -1,    -1,    38,    -1,    -1,    -1,    -1,   164,
      -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,
      54,    55,    -1,    57,    58,    -1,    -1,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    35,    69,    70,    71,    72,    73,
      74,    -1,    -1,    -1,    45,    -1,    -1,    -1,    -1,    -1,
      51,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   114,    -1,   116,   150,   151,    -1,   153,
     121,    -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,
      -1,     1,   166,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,   153,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,   164,    34,    35,    36,    -1,    38,    39,
      40,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
      50,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,   133,   134,    -1,    -1,   137,    -1,   139,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,     1,   163,     3,   165,     5,     6,     7,     8,
       9,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    -1,    38,
      39,    40,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,    -1,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,
     159,   160,    -1,     1,   163,     3,   165,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,    -1,   163,   164,   165,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    -1,    -1,
     163,   164,   165,     1,    -1,     3,    -1,     5,     6,     7,
       8,     9,    -1,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,
      38,    39,    40,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    -1,     1,   163,    -1,   165,     5,     6,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    15,    -1,
      -1,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    38,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150,   151,    -1,   153,    -1,     6,    -1,
     157,   158,   159,   160,    -1,    -1,   163,    15,   165,    -1,
      -1,    19,    20,    -1,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,   151,     6,   153,    -1,    -1,    -1,   157,
     158,   159,   160,    15,    -1,   163,    -1,    19,    20,   167,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,
      52,    53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,
       6,   153,    -1,    -1,    -1,   157,   158,   159,   160,    15,
      -1,   163,    -1,    19,    20,   167,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,
      -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,    55,
      -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    69,    70,    71,    72,    73,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   150,   151,     6,   153,    -1,    -1,
      -1,   157,   158,   159,   160,    15,    -1,   163,    -1,    19,
      20,   167,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,     6,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    15,    -1,   163,    -1,    19,    20,   167,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,
      54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,
      -1,     6,    -1,   157,   158,   159,   160,    -1,    -1,   163,
      15,    -1,   166,    -1,    19,    20,    -1,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    -1,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
       6,    -1,   157,   158,   159,   160,    -1,    -1,   163,    15,
     165,    -1,    -1,    19,    20,    -1,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,
      -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,    55,
      -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    69,    70,    71,    72,    73,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   150,   151,    -1,   153,     5,     6,
      -1,   157,   158,   159,   160,    -1,    -1,   163,    15,   165,
      -1,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    38,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150,   151,     6,   153,    -1,    -1,    -1,
     157,   158,   159,   160,    15,    -1,   163,    -1,    19,    20,
      -1,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,     6,   153,    -1,    -1,    -1,   157,   158,   159,   160,
      15,    -1,   163,   164,    19,    20,    -1,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    -1,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,     6,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    15,    -1,   163,   164,
      19,    20,    -1,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    82,    83,    -1,    -1,    -1,    87,    88,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,   135,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,
     149,   150,   151,     6,   153,    -1,    -1,    -1,   157,   158,
     159,   160,    15,    -1,   163,    -1,    19,    20,    -1,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,     6,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    15,    -1,
     163,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150,   151,     6,   153,    -1,    -1,    -1,
     157,   158,   159,   160,    15,    -1,   163,    -1,    19,    20,
      -1,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,    11,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,   160,
      -1,    -1,   163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,
      -1,    -1,    -1,   167,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,
     163,    -1,    -1,    -1,   167,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    -1,    -1,    -1,   167,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    -1,    -1,    -1,   167,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,   166,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,   165,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    -1,   165,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    -1,   165,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,
     163,    -1,   165,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,
      -1,   165,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,
     165,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,   165,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    -1,   165,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    -1,   165,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,   162,   163,    -1,   165,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,   165,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    -1,   165,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    -1,   165,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,
     163,    -1,   165,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,
     164,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,   164,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,
     163,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,   162,   163,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,    -1,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    57,    58,    -1,
      -1,    -1,   160,   161,   162,   163,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,    -1,    -1,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    57,    58,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,   110,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,
      -1,   107,   108,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    57,
      58,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    57,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,    -1,    -1,    -1,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,
      -1,    57,    58,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,    -1,    57,    58,    -1,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    80,
      81,    82,    83,    84,    85,    86,    87,    88,   138,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     6,     7,     8,     9,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    34,    35,    36,    39,
      40,    45,    47,    48,    49,    52,    53,    54,    55,    57,
      58,    69,    70,    71,    72,    73,    74,    89,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   111,   112,   113,   114,   116,   118,   119,   120,
     121,   123,   124,   125,   126,   128,   129,   130,   134,   137,
     139,   150,   151,   153,   157,   158,   159,   160,   163,   165,
     169,   170,   173,   174,   175,   178,   179,   184,   187,   188,
     191,   193,   194,   201,   202,   215,   219,   220,   221,   223,
     224,   226,   231,   233,   234,   235,   165,    15,    28,   115,
     121,   160,   201,   220,   225,   229,   230,   231,   232,   114,
     121,   163,   201,   202,   121,   160,   180,   181,   184,   181,
     232,   163,   163,   163,    94,   114,   120,   121,   163,   213,
     165,   165,   165,   232,   232,   232,   232,    35,   114,   183,
     185,   114,   121,   183,   165,   232,   163,   160,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   114,
     116,   121,   232,   181,   181,   181,   232,   232,   232,   232,
     232,   232,     1,   192,   232,   163,   163,   163,   234,   163,
     232,   232,   114,   116,   121,   232,   232,   232,   164,   180,
     182,   184,   166,   227,   228,   232,     0,   170,     5,    38,
     165,    15,   114,   121,   117,   122,    46,    50,   127,   133,
      15,    28,   114,   121,   201,   221,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    90,    91,    92,   107,   108,   109,   110,   138,
     141,   142,   143,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   160,   161,   162,   163,   165,   164,   227,
     232,   164,   227,    15,    15,   201,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    90,    91,    92,   107,   108,   109,   110,   138,
     141,   142,   143,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   160,   161,   162,   163,   225,   232,   114,
     117,   163,   164,   182,    12,    10,   165,   232,   232,   192,
     163,   163,   163,   192,   192,    22,    22,   114,   121,   163,
      11,    32,    33,   181,   186,   142,   142,   163,   165,   232,
     114,   171,   172,   163,   163,   163,   166,   192,   232,   232,
     192,   164,   180,   184,   141,   166,   144,   166,   114,   121,
     163,   201,   202,   114,   121,   163,   201,   202,   121,   163,
     213,   163,   160,   165,   114,   121,    43,   195,   195,   121,
     163,   213,   163,    15,   121,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   131,   132,   135,
     136,   135,   201,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   110,   232,   232,   192,   164,   164,    15,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   131,   132,   135,   136,   135,   201,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   110,   232,
     232,   192,   166,   192,   164,   163,   163,   166,   166,   165,
     192,   166,   166,   232,   163,   142,   142,   232,   163,   163,
     163,   232,   232,   232,   166,   142,   164,   172,   192,   192,
     192,   166,   166,   166,   166,   228,   232,   225,   114,   121,
     117,   122,   225,   114,   121,   117,   122,   163,   192,   192,
     192,    15,   121,   164,   174,   175,   176,   177,   178,   179,
     193,   194,   201,   215,   220,   223,   224,   160,   160,    25,
      26,    27,    28,   114,   121,   196,   197,   160,   165,   160,
     165,   163,   192,   192,   192,   121,   163,   213,   163,   144,
     164,   167,   232,   110,   167,   166,   144,   164,   167,   232,
     110,   167,   166,   166,   232,   192,   181,   181,   192,   166,
       4,   222,   222,    11,   232,   232,   232,   166,   232,   232,
     232,   165,   165,   166,   160,   232,   166,   166,   166,   144,
     165,   216,   166,   166,   192,   166,   166,   166,   163,   165,
     164,   177,    15,    15,   201,   198,   199,   201,   198,   114,
     121,   114,   121,   114,   121,   114,   121,   141,    25,    26,
      27,    28,    35,   164,   178,   200,   203,   204,   205,   214,
     219,   220,   164,   200,   192,   166,   166,   166,   163,   192,
     192,   192,   232,   167,   167,   232,   167,   167,   166,   166,
      44,   165,   222,   201,   202,   180,   180,   163,   166,   165,
     165,   185,   166,   166,   166,    37,    41,    42,   189,   190,
     165,   114,   121,   217,   218,   222,   166,   180,   180,   216,
     192,    15,   164,   199,   114,   164,   197,    51,   119,   160,
     209,   210,   211,   160,   211,   160,   211,    35,   160,   211,
     164,   178,   203,   204,   205,   214,   114,   201,   213,   164,
     166,   222,   222,   216,   192,   166,   166,   166,   165,   181,
     181,   192,   180,   232,   181,   181,   163,    80,    82,    83,
      87,    88,   135,   148,   149,   232,   144,   164,   190,   163,
     163,   141,   180,   180,   180,   166,   142,   163,   165,   209,
     121,    28,    45,    51,   114,   164,   178,   201,   202,   206,
     207,   208,   212,   141,   165,   164,   212,   165,   164,   212,
     165,   164,   212,   165,   213,   192,   222,   180,   180,   222,
     166,   180,   180,   216,   166,   166,   232,   232,   232,   232,
     135,   135,   144,   232,   232,   144,   182,   192,   192,   218,
     232,   192,   114,   201,   207,   142,   165,   114,   119,   164,
     207,   208,   209,   210,   164,   164,   164,   192,   166,   180,
     165,   180,   180,   165,   180,   181,   166,   144,   144,   144,
     144,   144,   182,   144,   144,   182,   166,   166,   165,   166,
     142,   165,   114,   232,   142,   163,   165,   142,   163,   165,
     166,   216,   185,   182,   182,   182,   182,   182,   182,   182,
     165,   232,   142,   163,   165,   165,   232,   192,   232,   192,
     216,   222,   181,   165,   232,   192,   165,   166,   165,   166,
     165,   180,   165,   180,   165,   166,   165,   165,   165
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, yyscanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
  YYUSE (yyscanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule, yyscanner)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
    yyscan_t yyscanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       , yyscanner);
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule, yyscanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp, yyscanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
    yyscan_t yyscanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 114: /* "\"identifier\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6446 "parser.cpp"
	break;
      case 115: /* "\"typed hash identifier\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6451 "parser.cpp"
	break;
      case 116: /* "\"complex type identifier\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6456 "parser.cpp"
	break;
      case 117: /* "\"variable reference\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6461 "parser.cpp"
	break;
      case 118: /* "\"backquote expression\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6466 "parser.cpp"
	break;
      case 119: /* "\"in-object member reference\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6471 "parser.cpp"
	break;
      case 120: /* "\"identifier or keyword used as function or method identifier\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6476 "parser.cpp"
	break;
      case 121: /* "\"namespace or class-scoped reference\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6481 "parser.cpp"
	break;
      case 122: /* "\"namespace-scoped global variable reference\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6486 "parser.cpp"
	break;
      case 123: /* "\"context reference\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6491 "parser.cpp"
	break;
      case 124: /* "\"named context reference\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6496 "parser.cpp"
	break;
      case 125: /* "\"cast operator\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6501 "parser.cpp"
	break;
      case 126: /* "\"cast (or nothing) operator\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6506 "parser.cpp"
	break;
      case 127: /* "\"simple class declaration\"" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6511 "parser.cpp"
	break;
      case 128: /* "\"date/time value\"" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->datetime)) (yyvaluep->datetime)->deref(); };
#line 6516 "parser.cpp"
	break;
      case 129: /* "\"quoted string\"" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6521 "parser.cpp"
	break;
      case 130: /* "\"binary constant value\"" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->binary)) (yyvaluep->binary)->deref(); };
#line 6526 "parser.cpp"
	break;
      case 131: /* "\"regular expression substitution expression\"" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->RegexSubst); };
#line 6531 "parser.cpp"
	break;
      case 132: /* "\"transliteration expression\"" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->Trans); };
#line 6536 "parser.cpp"
	break;
      case 133: /* "\"scoped class declaration\"" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->nscope); };
#line 6541 "parser.cpp"
	break;
      case 134: /* "\"call to base class method\"" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->nscope); };
#line 6546 "parser.cpp"
	break;
      case 135: /* "\"regular expression\"" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->Regex); };
#line 6551 "parser.cpp"
	break;
      case 136: /* "\"regular expression extraction expression\"" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->Regex); };
#line 6556 "parser.cpp"
	break;
      case 137: /* "\"implicit argument reference\"" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->implicit_arg)) (yyvaluep->implicit_arg)->deref(); };
#line 6561 "parser.cpp"
	break;
      case 138: /* "\"keyword used as hash key or object member reference\"" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6566 "parser.cpp"
	break;
      case 139: /* "\"%try-module error token\"" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->trymod); };
#line 6571 "parser.cpp"
	break;
      case 174: /* "gvardecl" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->gv); };
#line 6576 "parser.cpp"
	break;
      case 175: /* "top_namespace_decl" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->ns); };
#line 6581 "parser.cpp"
	break;
      case 176: /* "namespace_decls" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->nsnlist)) (yyvaluep->nsnlist)->deref(); };
#line 6586 "parser.cpp"
	break;
      case 177: /* "namespace_decl" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->nsn)) (yyvaluep->nsn)->deref(); };
#line 6591 "parser.cpp"
	break;
      case 178: /* "unscoped_const_decl" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->constnode); };
#line 6596 "parser.cpp"
	break;
      case 179: /* "scoped_const_decl" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->constnode); };
#line 6601 "parser.cpp"
	break;
      case 180: /* "block" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6606 "parser.cpp"
	break;
      case 181: /* "statement_or_block" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6611 "parser.cpp"
	break;
      case 182: /* "statements" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6616 "parser.cpp"
	break;
      case 183: /* "optname" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6621 "parser.cpp"
	break;
      case 184: /* "statement" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6626 "parser.cpp"
	break;
      case 185: /* "context_mods" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->cmods); };
#line 6631 "parser.cpp"
	break;
      case 186: /* "context_mod" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->cmod); };
#line 6636 "parser.cpp"
	break;
      case 187: /* "return_statement" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6641 "parser.cpp"
	break;
      case 188: /* "switch_statement" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6646 "parser.cpp"
	break;
      case 189: /* "case_block" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->switchstmt); };
#line 6651 "parser.cpp"
	break;
      case 190: /* "case_code" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->casenode); };
#line 6656 "parser.cpp"
	break;
      case 191: /* "try_statement" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6661 "parser.cpp"
	break;
      case 192: /* "myexp" */
#line 1852 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6666 "parser.cpp"
	break;
      case 193: /* "hashdecl_def" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->hashdecldef); };
#line 6671 "parser.cpp"
	break;
      case 194: /* "class_def" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->classdef); };
#line 6676 "parser.cpp"
	break;
      case 195: /* "inheritance_list" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->sclist); };
#line 6681 "parser.cpp"
	break;
      case 196: /* "superclass_list" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->sclist); };
#line 6686 "parser.cpp"
	break;
      case 197: /* "superclass" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->sclnode); };
#line 6691 "parser.cpp"
	break;
      case 198: /* "hashdecl_attrs" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->hashdeclpriv)) (yyvaluep->hashdeclpriv)->deref(); };
#line 6696 "parser.cpp"
	break;
      case 199: /* "hashdecl_member" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6701 "parser.cpp"
	break;
      case 200: /* "class_attributes" */
#line 1848 "parser.ypp"
	{ qore_class_private::get(*(yyvaluep->qoreclass))->deref(true, true); };
#line 6706 "parser.cpp"
	break;
      case 201: /* "uncqtypedef" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->parsertype); };
#line 6711 "parser.cpp"
	break;
      case 202: /* "qtypedef" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->parsertype); };
#line 6716 "parser.cpp"
	break;
      case 203: /* "internal_member_list" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6721 "parser.cpp"
	break;
      case 204: /* "private_member_list" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6726 "parser.cpp"
	break;
      case 205: /* "public_member_list" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6731 "parser.cpp"
	break;
      case 206: /* "classvardecl" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->classvarinfo); };
#line 6736 "parser.cpp"
	break;
      case 207: /* "member2" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6741 "parser.cpp"
	break;
      case 208: /* "transient_member2" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6746 "parser.cpp"
	break;
      case 209: /* "member" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6751 "parser.cpp"
	break;
      case 210: /* "transient_member" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6756 "parser.cpp"
	break;
      case 211: /* "member_list" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6761 "parser.cpp"
	break;
      case 212: /* "member_list2" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6766 "parser.cpp"
	break;
      case 213: /* "ident_openparen" */
#line 1849 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6771 "parser.cpp"
	break;
      case 214: /* "inline_methoddef" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->methodnode); };
#line 6776 "parser.cpp"
	break;
      case 215: /* "outofline_methoddef" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->methoddef); };
#line 6781 "parser.cpp"
	break;
      case 216: /* "base_constructor_list" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->bcalist); };
#line 6786 "parser.cpp"
	break;
      case 217: /* "base_constructors" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->bcalist); };
#line 6791 "parser.cpp"
	break;
      case 218: /* "base_constructor" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->bcanode); };
#line 6796 "parser.cpp"
	break;
      case 222: /* "return_value" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->returnTypeInfo); };
#line 6801 "parser.cpp"
	break;
      case 223: /* "sub_def" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->parsefunc); };
#line 6806 "parser.cpp"
	break;
      case 224: /* "scoped_sub_def" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->sparsefunc); };
#line 6811 "parser.cpp"
	break;
      case 225: /* "list" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->parse_list)) (yyvaluep->parse_list)->deref(); };
#line 6816 "parser.cpp"
	break;
      case 226: /* "list_n" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->parse_list)) (yyvaluep->parse_list)->deref(); };
#line 6821 "parser.cpp"
	break;
      case 227: /* "hash" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->hash); };
#line 6826 "parser.cpp"
	break;
      case 228: /* "hash_element" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->hashelement); };
#line 6831 "parser.cpp"
	break;
      case 229: /* "alt_hash" */
#line 1847 "parser.ypp"
	{ delete (yyvaluep->hash); };
#line 6836 "parser.cpp"
	break;
      case 230: /* "immediate_typed_hash" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6841 "parser.cpp"
	break;
      case 231: /* "exp_c" */
#line 1852 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6846 "parser.cpp"
	break;
      case 232: /* "exp" */
#line 1852 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6851 "parser.cpp"
	break;
      case 233: /* "exp_n" */
#line 1852 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6856 "parser.cpp"
	break;
      case 234: /* "string" */
#line 1850 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6861 "parser.cpp"
	break;
      case 235: /* "scalar" */
#line 1852 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6866 "parser.cpp"
	break;

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (yyscan_t yyscanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (yyscan_t yyscanner)
#else
int
yyparse (yyscanner)
    yyscan_t yyscanner;
#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 1860 "parser.ypp"
    {
           (yyvsp[(1) - (1)].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 5:
#line 1863 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].sparsefunc)->loc, "function", (yyvsp[(1) - (1)].sparsefunc)->name.ostr);
           (yyvsp[(1) - (1)].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 6:
#line 1868 "parser.ypp"
    {
           qore_root_ns_private::parseAddClass((yyvsp[(1) - (1)].classdef)->loc, *((yyvsp[(1) - (1)].classdef)->name), (yyvsp[(1) - (1)].classdef)->oc);

           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error(*(yyvsp[(1) - (1)].classdef)->loc, "illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
           delete (yyvsp[(1) - (1)].classdef);
        }
    break;

  case 7:
#line 1876 "parser.ypp"
    {
           qore_root_ns_private::parseAddHashDecl((yyvsp[(1) - (1)].hashdecldef)->loc, *((yyvsp[(1) - (1)].hashdecldef)->name), (yyvsp[(1) - (1)].hashdecldef)->takeHashDecl());
           delete (yyvsp[(1) - (1)].hashdecldef);
        }
    break;

  case 8:
#line 1880 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].constnode)->loc, "constant", (yyvsp[(1) - (1)].constnode)->name.ostr);
           qore_root_ns_private::parseAddConstant((yyvsp[(1) - (1)].constnode)->loc, *getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 9:
#line 1886 "parser.ypp"
    {
           qore_root_ns_private::parseAddConstant((yyvsp[(1) - (1)].constnode)->loc, *getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 10:
#line 1890 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].methoddef)->loc, "method", (yyvsp[(1) - (1)].methoddef)->name.ostr);
           (yyvsp[(1) - (1)].methoddef)->parseAddToClassAndDel();
        }
    break;

  case 11:
#line 1895 "parser.ypp"
    {
           if ((yyvsp[(1) - (1)].statement)) {
              if ((yyvsp[(1) - (1)].statement)->isParseDeclaration())
                 delete (yyvsp[(1) - (1)].statement);
              else
                 qore_program_private::addStatement(*(getProgram()), (yyvsp[(1) - (1)].statement));
           }
        }
    break;

  case 13:
#line 1904 "parser.ypp"
    {
            (yyvsp[(2) - (3)].sblock)->finalizeBlock((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            qore_program_private::addStatement(*(getProgram()), (yyvsp[(2) - (3)].sblock));
        }
    break;

  case 14:
#line 1908 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            qore_root_ns_private::parseAddNamespace((yyvsp[(1) - (1)].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
        }
    break;

  case 15:
#line 1915 "parser.ypp"
    {
            QoreModuleDefContext* qmd = get_module_def_context();
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");
            else {
                QoreUserModuleDefContextHelper* uqmd = static_cast<QoreUserModuleDefContextHelper*>(qmd);
                uqmd->close();
            }
            // registered internally
        }
    break;

  case 16:
#line 1925 "parser.ypp"
    {
            bool has_dollar = (yyvsp[(1) - (1)].trymod)->var[0] == '$';
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            if (!has_dollar) {
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS)) {
                    parse_error(*loc, "%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (1)].trymod)->var);
                }
            } else {
                (yyvsp[(1) - (1)].trymod)->fixName();
                if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].trymod)->var);
            }

            if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
                parse_error(*loc, "'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
            } else {
                VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode(loc, (yyvsp[(1) - (1)].trymod)->takeName());
                QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(loc, left, (yyvsp[(1) - (1)].trymod)->takeExceptionHash());
                qore_program_private::addStatement(*(getProgram()), new ExpressionStatement(loc, exp));
            }
            delete (yyvsp[(1) - (1)].trymod);
        }
    break;

  case 17:
#line 1950 "parser.ypp"
    {
        }
    break;

  case 18:
#line 1952 "parser.ypp"
    {
        }
    break;

  case 19:
#line 1957 "parser.ypp"
    {
            QoreModuleDefContext* qmd = get_module_def_context();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].qv).getTypeName());
            else
                qmd->set(loc, (yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].qv));

            free((yyvsp[(1) - (4)].string));
            (yyvsp[(3) - (4)].qv).discard(nullptr);
        }
    break;

  case 20:
#line 1971 "parser.ypp"
    { (yyval.b) = false; }
    break;

  case 21:
#line 1972 "parser.ypp"
    {
           (yyval.b) = true;
        }
    break;

  case 22:
#line 1978 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 23:
#line 1987 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[(3) - (3)].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 24:
#line 1994 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 25:
#line 2001 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 26:
#line 2006 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 27:
#line 2015 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 28:
#line 2022 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].b), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].b) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[(4) - (5)].parse_list), (yyvsp[(1) - (5)].b));
        }
    break;

  case 29:
#line 2027 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 30:
#line 2036 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[(3) - (3)].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true, VT_THREAD_LOCAL);
        }
    break;

  case 31:
#line 2043 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 32:
#line 2050 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true, VT_THREAD_LOCAL);
        }
    break;

  case 33:
#line 2055 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 34:
#line 2064 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 35:
#line 2071 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].b), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].b) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[(4) - (5)].parse_list), (yyvsp[(1) - (5)].b), VT_THREAD_LOCAL);
        }
    break;

  case 36:
#line 2079 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].i4), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[(1) - (5)].i4), *p);
            (yyvsp[(4) - (5)].nsnlist)->add(*p);
            delete (yyvsp[(4) - (5)].nsnlist);
            (yyval.ns) = p->ns;
        }
    break;

  case 37:
#line 2088 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].i4), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].i4) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[(1) - (3)].i4), *p);
            (yyval.ns) = p->ns;
        }
    break;

  case 38:
#line 2095 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].i4), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[(1) - (4)].i4), *p);
            (yyval.ns) = p->ns;
        }
    break;

  case 39:
#line 2105 "parser.ypp"
    {
           (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[(1) - (1)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(1) - (1)].nsn));
        }
    break;

  case 40:
#line 2110 "parser.ypp"
    {
           (yyval.nsnlist) = (yyvsp[(1) - (2)].nsnlist);
           if ((yyvsp[(2) - (2)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(2) - (2)].nsn));
        }
    break;

  case 41:
#line 2118 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].constnode)->loc, "constant", (yyvsp[(1) - (1)].constnode)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 42:
#line 2123 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 43:
#line 2126 "parser.ypp"
    {
            (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].classdef));
            // see if class definitions are allowed
            if (parse_check_parse_option(PO_NO_CLASS_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
                parse_error(*loc, "illegal class definition \"%s\" (conflicts with parse option PO_NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
            }
        }
    break;

  case 44:
#line 2134 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].hashdecldef));
        }
    break;

  case 45:
#line 2137 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].parsefunc));
        }
    break;

  case 46:
#line 2140 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].sparsefunc)->loc, "function", (yyvsp[(1) - (1)].sparsefunc)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].sparsefunc));
        }
    break;

  case 47:
#line 2145 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (2)].gv));
        }
    break;

  case 48:
#line 2148 "parser.ypp"
    {
            (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
            }
        }
    break;

  case 49:
#line 2156 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].methoddef));
        }
    break;

  case 50:
#line 2162 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].qv));
        }
    break;

  case 51:
#line 2165 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line), (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].qv), true);
        }
    break;

  case 52:
#line 2171 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].qv));
        }
    break;

  case 53:
#line 2174 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line), (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].qv), true);
        }
    break;

  case 54:
#line 2181 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(2) - (3)].sblock); }
    break;

  case 55:
#line 2184 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line); }
    break;

  case 56:
#line 2189 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 57:
#line 2192 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(1) - (1)].sblock); }
    break;

  case 58:
#line 2197 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 59:
#line 2199 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].sblock)); }
    break;

  case 60:
#line 2201 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].sblock)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 61:
#line 2203 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].statement)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 62:
#line 2208 "parser.ypp"
    { (yyval.string) = 0; }
    break;

  case 63:
#line 2209 "parser.ypp"
    { (yyval.string) = (yyvsp[(1) - (1)].string); }
    break;

  case 64:
#line 2213 "parser.ypp"
    { (yyval.statement) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 65:
#line 2214 "parser.ypp"
    {
            qore_program_private* pgm = qore_program_private::get(*getProgram());
            // if the expression has no effect and it's not a variable declaration
            qore_type_t t = (yyvsp[(1) - (2)].qv).getType();
            bool ok = false;
            if (t == NT_PARSE_LIST) {
                QoreParseListNode* l = (yyvsp[(1) - (2)].qv).get<QoreParseListNode>();
                // rewrite expression if it's a list without parentheses under certain conditions
                (yyvsp[(1) - (2)].qv).set(check_rewrite_list(l));

                if (l->isVariableList())
                    ok = true;
            }

            const QoreProgramLocation* loc = pgm->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);

            if (!ok) {
                if (!value_has_effect_as_root((yyvsp[(1) - (2)].qv)) && (t != NT_VARREF || !(yyvsp[(1) - (2)].qv).get<VarRefNode>()->parseIsDecl())) {
                    if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                        parse_error(*loc, "expression has no effect as top-level statement (%s)", (yyvsp[(1) - (2)].qv).getTypeName());
                    }
                } else if (!(yyvsp[(1) - (2)].qv).hasEffect() && (t != NT_VARREF || !(yyvsp[(1) - (2)].qv).get<VarRefNode>()->parseIsDecl())) {
                    parse_error(*loc, "statement has no effect (%s)", (yyvsp[(1) - (2)].qv).getTypeName());
                }
            }

            ignore_return_value((yyvsp[(1) - (2)].qv));
            (yyval.statement) = new ExpressionStatement(loc, (yyvsp[(1) - (2)].qv));
        }
    break;

  case 66:
#line 2244 "parser.ypp"
    {
            NamedScope *ns = new NamedScope((yyvsp[(1) - (5)].string));
            assert(ns->size() > 1);
            printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.statement) = new ExpressionStatement(loc, new StaticMethodCallNode(loc, ns, make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (5)]).first_line, (yylsp[(3) - (5)]).last_line), (yyvsp[(3) - (5)].qv))));
        }
    break;

  case 67:
#line 2252 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 68:
#line 2253 "parser.ypp"
    {
           (yyval.statement) = new RethrowStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 69:
#line 2256 "parser.ypp"
    {
           (yyval.statement) = new RethrowStatement((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line, (yyvsp[(2) - (3)].qv));
        }
    break;

  case 70:
#line 2259 "parser.ypp"
    {
           (yyval.statement) = new ThrowStatement((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line, (yyvsp[(2) - (3)].qv));
        }
    break;

  case 71:
#line 2262 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Unconditional);
        }
    break;

  case 72:
#line 2265 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Success);
        }
    break;

  case 73:
#line 2268 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Error);
        }
    break;

  case 74:
#line 2271 "parser.ypp"
    {
           (yyval.statement) = new ContextStatement((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, 0, 0, (yyvsp[(2) - (3)].cmods), (yyvsp[(3) - (3)].sblock));
        }
    break;

  case 75:
#line 2274 "parser.ypp"
    {
           (yyval.statement) = new SummarizeStatement((yylsp[(1) - (11)]).first_line, (yylsp[(11) - (11)]).last_line, (yyvsp[(2) - (11)].string), (yyvsp[(4) - (11)].qv), (yyvsp[(10) - (11)].cmods), (yyvsp[(11) - (11)].sblock), (yyvsp[(8) - (11)].qv));
        }
    break;

  case 76:
#line 2277 "parser.ypp"
    {
           (yyval.statement) = new ContextStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].string), (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].cmods), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 77:
#line 2280 "parser.ypp"
    {
           (yyval.statement) = new IfStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 78:
#line 2283 "parser.ypp"
    {
           (yyval.statement) = new IfStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].sblock), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 79:
#line 2286 "parser.ypp"
    {
           (yyval.statement) = new WhileStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 80:
#line 2289 "parser.ypp"
    {
           (yyval.statement) = new DoWhileStatement((yylsp[(1) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), (yyvsp[(2) - (7)].sblock));
        }
    break;

  case 81:
#line 2292 "parser.ypp"
    {
           (yyval.statement) = new ForStatement((yylsp[(1) - (9)]).first_line, (yylsp[(9) - (9)]).last_line, (yyvsp[(3) - (9)].qv), (yyvsp[(5) - (9)].qv), (yyvsp[(7) - (9)].qv), (yyvsp[(9) - (9)].sblock));
        }
    break;

  case 82:
#line 2295 "parser.ypp"
    {
           (yyval.statement) = new ForEachStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].qv), (yyvsp[(5) - (7)].qv), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 83:
#line 2298 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (2)].statement); }
    break;

  case 84:
#line 2299 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
            // see if thread exit is allowed
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL)) {
                parse_error(*loc, "illegal use of \"thread_exit\" (conflicts with parse option PO_NO_THREAD_CONTROL)");
            }
            (yyval.statement) = new ThreadExitStatement(loc);
        }
    break;

  case 85:
#line 2307 "parser.ypp"
    {
            (yyval.statement) = new BreakStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 86:
#line 2310 "parser.ypp"
    {
            (yyval.statement) = new ContinueStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 87:
#line 2313 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 88:
#line 2314 "parser.ypp"
    { (yyval.statement) = 0; }
    break;

  case 89:
#line 2319 "parser.ypp"
    { (yyval.cmods) = 0; }
    break;

  case 90:
#line 2320 "parser.ypp"
    {
           if (!(yyvsp[(1) - (2)].cmods))
              (yyval.cmods) = new ContextModList((yyvsp[(2) - (2)].cmod));
           else {
              (yyvsp[(1) - (2)].cmods)->addContextMod((yyvsp[(2) - (2)].cmod));
              (yyval.cmods) = (yyvsp[(1) - (2)].cmods);
           }
        }
    break;

  case 91:
#line 2332 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[(3) - (4)].qv)); }
    break;

  case 92:
#line 2334 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[(3) - (4)].qv)); }
    break;

  case 93:
#line 2336 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[(3) - (4)].qv)); }
    break;

  case 94:
#line 2340 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 95:
#line 2342 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].qv)); }
    break;

  case 96:
#line 2347 "parser.ypp"
    {
           (yyvsp[(6) - (7)].switchstmt)->setSwitch((yyvsp[(3) - (7)].qv));
           (yyval.statement) = (yyvsp[(6) - (7)].switchstmt);
           (yyval.statement)->finalizeBlock((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
        }
    break;

  case 97:
#line 2356 "parser.ypp"
    {
           (yyval.switchstmt) = new SwitchStatement((yyvsp[(1) - (1)].casenode));
        }
    break;

  case 98:
#line 2360 "parser.ypp"
    {
           (yyvsp[(1) - (2)].switchstmt)->addCase((yyvsp[(2) - (2)].casenode));
           (yyval.switchstmt) = (yyvsp[(1) - (2)].switchstmt);
        }
    break;

  case 99:
#line 2368 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, ">=", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
    break;

  case 100:
#line 2374 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, ">=", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
    break;

  case 101:
#line 2380 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, "<=", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
    break;

  case 102:
#line 2386 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, "<=", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
    break;

  case 103:
#line 2392 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, "==", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalEqualsOperatorNode::softEqual);
        }
    break;

  case 104:
#line 2398 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, "==", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalEqualsOperatorNode::softEqual);
        }
    break;

  case 105:
#line 2404 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, "<", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalLessThanOperatorNode::doLessThan);
        }
    break;

  case 106:
#line 2410 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, "<", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalLessThanOperatorNode::doLessThan);
        }
    break;

  case 107:
#line 2416 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, ">", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
    break;

  case 108:
#line 2422 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, ">", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
    break;

  case 109:
#line 2428 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 110:
#line 2433 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(3) - (4)].Regex), nullptr);
        }
    break;

  case 111:
#line 2438 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 112:
#line 2443 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[(3) - (4)].Regex), nullptr);
        }
    break;

  case 113:
#line 2448 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(2) - (4)].Regex), (yyvsp[(4) - (4)].sblock));
        }
    break;

  case 114:
#line 2453 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(2) - (3)].Regex), nullptr);
        }
    break;

  case 115:
#line 2458 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, 0, (yyvsp[(2) - (4)].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[(2) - (4)].qv), (yyvsp[(4) - (4)].sblock));
        }
    break;

  case 116:
#line 2464 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            check_case(loc, 0, (yyvsp[(2) - (3)].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[(2) - (3)].qv), nullptr);
        }
    break;

  case 117:
#line 2470 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), (yyvsp[(3) - (3)].sblock), true);
        }
    break;

  case 118:
#line 2475 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), nullptr, true);
        }
    break;

  case 119:
#line 2482 "parser.ypp"
    {
            char* param = 0;
            const QoreTypeInfo* typeInfo = nullptr;
            QoreParseTypeInfo* parseTypeInfo = nullptr;
            const QoreProgramLocation* loc =
                qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            bool missing_type_decl = true;
            if ((yyvsp[(5) - (7)].qv).getType() == NT_VARREF) {
                VarRefNode* varRefNode = (yyvsp[(5) - (7)].qv).get<VarRefNode>();
                param = varRefNode->takeName();
                if (varRefNode->isDecl()) {
                    VarRefDeclNode* varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    parseTypeInfo = varRefDeclNode->takeParseTypeInfo();
                    if (!parseTypeInfo)
                        typeInfo = varRefDeclNode->getTypeInfo();
                    missing_type_decl = false;
                }
            } else if ((yyvsp[(5) - (7)].qv).getType() == NT_BAREWORD) {
                param = (yyvsp[(5) - (7)].qv).get<BarewordNode>()->takeString();
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "local variable '%s' in catch parameter list declared without '$' prefix, but " \
                        "parse option 'allow-bare-refs' is not set", param);
            } else if ((yyvsp[(5) - (7)].qv)) {
                parse_error(*loc, "only one parameter accepted in catch block for exception hash");
                missing_type_decl = false;
            }
            if ((yyvsp[(5) - (7)].qv) && missing_type_decl) {
                int64 po = parse_get_parse_options();
                if (po & (PO_STRICT_TYPES|PO_REQUIRE_TYPES)) {
                    SimpleRefHolder<QoreStringNode> desc(new QoreStringNodeMaker("the catch block is missing a " \
                        "type declaration; the exception argument should be declared as 'hash<ExceptionInfo>' or " \
                        "with a compatible type"));
                    // issue #2943: raise an error for mixing string and non-scalar values with %strict-types
                    if (po & PO_STRICT_TYPES) {
                        desc->concat("; this is an error when %strict-types is in effect");
                        qore_program_private::makeParseException(getProgram(), *loc, "PARSE-TYPE-ERROR", desc.release());
                    } else {
                        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_CATCH,
                            "INVALID-CATCH", desc.release());
                    }
                }
            }
            (yyvsp[(5) - (7)].qv).discard(nullptr);
            const QoreProgramLocation* vloc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(5) - (7)].qv) ? (yylsp[(5) - (7)]).first_line : 0, (yyvsp[(5) - (7)].qv) ? (yylsp[(5) - (7)]).last_line : 0);
            (yyval.statement) = new TryStatement(loc, (yyvsp[(2) - (7)].sblock), (yyvsp[(7) - (7)].sblock), param, typeInfo, parseTypeInfo, vloc);
        }
    break;

  case 120:
#line 2530 "parser.ypp"
    { (yyval.qv).set(nullptr); }
    break;

  case 121:
#line 2531 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 122:
#line 2532 "parser.ypp"
    { (yyval.qv).set(nullptr); }
    break;

  case 123:
#line 2536 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            check_hashdeclmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].hashdeclpriv));
        }
    break;

  case 124:
#line 2542 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            check_hashdeclmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].hashdeclpriv));
        }
    break;

  case 125:
#line 2551 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            check_classmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
            qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (6)].string), (yyvsp[(5) - (6)].qoreclass));
        }
    break;

  case 126:
#line 2558 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[(2) - (6)].nscope)->ostr);
            check_classmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (6)].nscope), (yyvsp[(5) - (6)].qoreclass));
            qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
        }
    break;

  case 127:
#line 2567 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].i4), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (4)].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (4)].string), qc);
        }
    break;

  case 128:
#line 2576 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].i4), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[(2) - (4)].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (4)].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (4)].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
        }
    break;

  case 129:
#line 2587 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].i4), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (5)].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (5)].string), qc);
        }
    break;

  case 130:
#line 2596 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].i4), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[(2) - (5)].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (5)].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (5)].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
        }
    break;

  case 131:
#line 2610 "parser.ypp"
    {
           (yyval.sclist) = (yyvsp[(2) - (2)].sclist);
        }
    break;

  case 132:
#line 2613 "parser.ypp"
    { // NOTHING
           (yyval.sclist) = 0;
        }
    break;

  case 133:
#line 2619 "parser.ypp"
    {
           (yyval.sclist) = new BCList((yyvsp[(1) - (1)].sclnode));
        }
    break;

  case 134:
#line 2622 "parser.ypp"
    {
           (yyvsp[(1) - (3)].sclist)->push_back((yyvsp[(3) - (3)].sclnode));
           (yyval.sclist) = (yyvsp[(1) - (3)].sclist);
        }
    break;

  case 135:
#line 2629 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(1) - (1)].string), Public);
        }
    break;

  case 136:
#line 2633 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(1) - (1)].string)), Public);
        }
    break;

  case 137:
#line 2637 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Public);
        }
    break;

  case 138:
#line 2641 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Public);
        }
    break;

  case 139:
#line 2645 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Private);
        }
    break;

  case 140:
#line 2649 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Private);
        }
    break;

  case 141:
#line 2653 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Private);
        }
    break;

  case 142:
#line 2657 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Private);
        }
    break;

  case 143:
#line 2661 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Internal);
        }
    break;

  case 144:
#line 2665 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Internal);
        }
    break;

  case 145:
#line 2672 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.hashdeclpriv) = new typed_hash_decl_private(loc);
            if ((yyvsp[(1) - (1)].memberinfo)) {
                (yyval.hashdeclpriv)->parseAdd((yyvsp[(1) - (1)].memberinfo)->getHashMemPair());
                delete (yyvsp[(1) - (1)].memberinfo);
            }
        }
    break;

  case 146:
#line 2680 "parser.ypp"
    {
            if ((yyvsp[(2) - (2)].memberinfo)) {
                if ((yyvsp[(1) - (2)].hashdeclpriv)->hasMember((yyvsp[(2) - (2)].memberinfo)->name)) {
                    parse_error(*(yyvsp[(2) - (2)].memberinfo)->loc, "duplicate hashdecl member declaration '%s'", (yyvsp[(2) - (2)].memberinfo)->name);
                } else {
                    // add new member to list
                    (yyvsp[(1) - (2)].hashdeclpriv)->parseAdd((yyvsp[(2) - (2)].memberinfo)->getHashMemPair());
                }
                delete (yyvsp[(2) - (2)].memberinfo);
            }

            (yyval.hashdeclpriv) = (yyvsp[(1) - (2)].hashdeclpriv);
        }
    break;

  case 147:
#line 2696 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
            delete (yyvsp[(1) - (3)].parsertype);
        }
    break;

  case 148:
#line 2701 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].qv)));
            delete (yyvsp[(1) - (5)].parsertype);
        }
    break;

  case 149:
#line 2706 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype));

            if (!(yyvsp[(1) - (6)].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* aloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line);
                if (pti->subtypes.size()) {
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(aloc, (yyvsp[(4) - (6)].qv)));
                }
                else {
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(aloc, (yyvsp[(4) - (6)].qv)));
                }
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new HashDeclMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[(1) - (6)].parsertype);
        }
    break;

  case 150:
#line 2733 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreParseClass((yyvsp[(1) - (1)].methodnode)->getLoc());
           (yyvsp[(1) - (1)].methodnode)->addAndDelete((yyval.qoreclass));
        }
    break;

  case 151:
#line 2737 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Internal);
            delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 152:
#line 2743 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Private);
            delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 153:
#line 2749 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Public);
            delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 154:
#line 2755 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[(1) - (1)].constnode)->getName(), (yyvsp[(1) - (1)].constnode)->takeValue(), Public);
            delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 155:
#line 2761 "parser.ypp"
    {
            (yyvsp[(2) - (2)].methodnode)->addAndDelete((yyvsp[(1) - (2)].qoreclass));
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
        }
    break;

  case 156:
#line 2765 "parser.ypp"
    {
            (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Internal);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 157:
#line 2770 "parser.ypp"
    {
            (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Private);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 158:
#line 2775 "parser.ypp"
    {
            (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Public);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 159:
#line 2780 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[(2) - (2)].constnode)->getName(), (yyvsp[(2) - (2)].constnode)->takeValue(), Public);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].constnode);
        }
    break;

  case 160:
#line 2789 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[(1) - (1)].string), false);
        }
    break;

  case 161:
#line 2792 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[(1) - (1)].string), false));
        }
    break;

  case 162:
#line 2795 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[(1) - (1)].string), false);
        }
    break;

  case 163:
#line 2799 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[(2) - (2)].string), true);
        }
    break;

  case 164:
#line 2802 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[(2) - (2)].string), true));
        }
    break;

  case 165:
#line 2805 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[(2) - (2)].string), true);
        }
    break;

  case 166:
#line 2813 "parser.ypp"
    { (yyval.parsertype) = 0; }
    break;

  case 167:
#line 2814 "parser.ypp"
    {
           (yyval.parsertype) = (yyvsp[(1) - (1)].parsertype);
        }
    break;

  case 168:
#line 2820 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 169:
#line 2821 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 170:
#line 2822 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 171:
#line 2826 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 172:
#line 2827 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 173:
#line 2828 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 174:
#line 2829 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 175:
#line 2830 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 176:
#line 2831 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 177:
#line 2835 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 178:
#line 2836 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 179:
#line 2837 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 180:
#line 2841 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (4)].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (4)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (4)].parsertype))));
            delete (yyvsp[(2) - (4)].parsertype);
        }
    break;

  case 181:
#line 2846 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (3)].string), new QoreVarInfo(loc));
        }
    break;

  case 182:
#line 2850 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (6)].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (6)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (6)].parsertype)), (yyvsp[(5) - (6)].qv)));
            //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
            delete (yyvsp[(2) - (6)].parsertype);
        }
    break;

  case 183:
#line 2856 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (5)].string), new QoreVarInfo(loc, nullptr, nullptr, (yyvsp[(4) - (5)].qv)));
        }
    break;

  case 184:
#line 2860 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype));

            if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[(5) - (7)].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[(5) - (7)].qv)));
            }

            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (7)].string), new QoreVarInfo(loc, t, pti, new_call));

            delete (yyvsp[(2) - (7)].parsertype);
        }
    break;

  case 185:
#line 2883 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].parsertype), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].parsertype) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
            delete (yyvsp[(1) - (3)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (3)].string));
        }
    break;

  case 186:
#line 2891 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].parsertype), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].parsertype) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].qv)));
            delete (yyvsp[(1) - (5)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (5)].string));
        }
    break;

  case 187:
#line 2899 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].parsertype), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = (yyvsp[(1) - (6)].parsertype) ? ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)) : nullptr;

            if (!(yyvsp[(1) - (6)].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line);
                if (pti && pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[(1) - (6)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (6)].string));
        }
    break;

  case 188:
#line 2924 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
            delete (yyvsp[(1) - (3)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (3)].string));
        }
    break;

  case 189:
#line 2931 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].qv)));
            delete (yyvsp[(1) - (5)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (5)].string));
        }
    break;

  case 190:
#line 2938 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype));

            if (!(yyvsp[(1) - (6)].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[(1) - (6)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (6)].string));
        }
    break;

  case 191:
#line 2962 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(loc));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (2)].string));
        }
    break;

  case 192:
#line 2968 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (4)].string), new QoreMemberInfo(loc, nullptr, nullptr, (yyvsp[(3) - (4)].qv)));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (4)].string));
        }
    break;

  case 193:
#line 2974 "parser.ypp"
    {
            (yyval.memberinfo) = (yyvsp[(1) - (1)].classvarinfo);
        }
    break;

  case 194:
#line 2977 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            if ((yyvsp[(1) - (1)].constnode)->pub)
                parse_error(*loc, "cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[(1) - (1)].constnode)->name.ostr);
            (yyval.memberinfo) = new MemberInfo(loc, (yyvsp[(1) - (1)].constnode)->name.takeName(), (yyvsp[(1) - (1)].constnode)->value);
            delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 195:
#line 2987 "parser.ypp"
    {
            (yyval.memberinfo) = (yyvsp[(2) - (2)].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
    break;

  case 196:
#line 2994 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (1)].string), new QoreMemberInfo(loc));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 197:
#line 3000 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(loc, nullptr, new QoreParseTypeInfo((yyvsp[(2) - (2)].string))));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (2)].string));
        }
    break;

  case 198:
#line 3009 "parser.ypp"
    {
            (yyval.memberinfo) = (yyvsp[(2) - (2)].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
    break;

  case 199:
#line 3016 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 200:
#line 3019 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 201:
#line 3022 "parser.ypp"
    {
           (yyvsp[(1) - (3)].memberlist)->add((yyvsp[(3) - (3)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (3)].memberlist);
        }
    break;

  case 202:
#line 3026 "parser.ypp"
    {
           (yyvsp[(1) - (3)].memberlist)->add((yyvsp[(3) - (3)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (3)].memberlist);
        }
    break;

  case 203:
#line 3033 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 204:
#line 3036 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 205:
#line 3039 "parser.ypp"
    {
           (yyvsp[(1) - (2)].memberlist)->add((yyvsp[(2) - (2)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (2)].memberlist);
        }
    break;

  case 206:
#line 3043 "parser.ypp"
    {
           (yyvsp[(1) - (2)].memberlist)->add((yyvsp[(2) - (2)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (2)].memberlist);
        }
    break;

  case 207:
#line 3050 "parser.ypp"
    {
           (yyval.string) = (yyvsp[(1) - (2)].string);
        }
    break;

  case 208:
#line 3053 "parser.ypp"
    {
           (yyval.string) = strdup("keys");
        }
    break;

  case 209:
#line 3056 "parser.ypp"
    {
           (yyval.string) = (yyvsp[(1) - (1)].string);
        }
    break;

  case 210:
#line 3062 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(7) - (7)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            check_method(loc, (yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), new_method_variant(loc, (yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 211:
#line 3074 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(7) - (7)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            check_method(loc, (yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), new_method_variant(loc, (yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 212:
#line 3090 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
            if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            check_method(loc, (yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), new_method_variant(loc, (yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 213:
#line 3098 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
            if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            check_method(loc, (yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), new_method_variant(loc, (yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].bcalist), rt, 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 214:
#line 3113 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(8) - (8)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].qv), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(8) - (8)].sblock));
        }
    break;

  case 215:
#line 3124 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(8) - (8)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
            delete (yyvsp[(2) - (8)].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].qv), (yyvsp[(7) - (8)].bcalist), rt, (yyvsp[(8) - (8)].sblock));
        }
    break;

  case 216:
#line 3137 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(7) - (8)]).last_line);
            if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].qv), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), 0);
        }
    break;

  case 217:
#line 3143 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(7) - (8)]).last_line);
            if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
            delete (yyvsp[(2) - (8)].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].qv), (yyvsp[(7) - (8)].bcalist), rt, 0);
        }
    break;

  case 218:
#line 3152 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[(1) - (7)].string), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 219:
#line 3156 "parser.ypp"
    {
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (7)].parsertype)));
            delete (yyvsp[(1) - (7)].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[(2) - (7)].string), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 220:
#line 3166 "parser.ypp"
    {
           (yyval.bcalist) = (yyvsp[(2) - (2)].bcalist);
        }
    break;

  case 221:
#line 3169 "parser.ypp"
    { // nothing
           (yyval.bcalist) = 0;
        }
    break;

  case 222:
#line 3175 "parser.ypp"
    {
           (yyval.bcalist) = new BCAList((yyvsp[(1) - (1)].bcanode));
        }
    break;

  case 223:
#line 3178 "parser.ypp"
    {
           (yyvsp[(1) - (3)].bcalist)->push_back((yyvsp[(3) - (3)].bcanode));
           (yyval.bcalist) = (yyvsp[(1) - (3)].bcalist);
        }
    break;

  case 224:
#line 3185 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.bcanode) = new BCANode((yyvsp[(1) - (4)].string), make_args(loc, (yyvsp[(3) - (4)].qv)), loc);
        }
    break;

  case 225:
#line 3189 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[(1) - (4)].string)), make_args(loc, (yyvsp[(3) - (4)].qv)), loc);
        }
    break;

  case 226:
#line 3197 "parser.ypp"
    { (yyval.i4) = 0; }
    break;

  case 227:
#line 3198 "parser.ypp"
    {
           (yyval.i4) = (yyvsp[(1) - (1)].i4);
        }
    break;

  case 228:
#line 3203 "parser.ypp"
    { (yyval.i4) = (yyvsp[(1) - (1)].i4); }
    break;

  case 229:
#line 3204 "parser.ypp"
    {
            if (((yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4)) == (yyvsp[(1) - (2)].i4)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                parse_error(*loc, "modifier given twice");
            }
            (yyval.i4) = (yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4);
        }
    break;

  case 230:
#line 3214 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 231:
#line 3215 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 232:
#line 3216 "parser.ypp"
    { (yyval.i4) = OFM_INTERNAL; }
    break;

  case 233:
#line 3217 "parser.ypp"
    { (yyval.i4) = OFM_STATIC; }
    break;

  case 234:
#line 3218 "parser.ypp"
    { (yyval.i4) = OFM_SYNCED; }
    break;

  case 235:
#line 3219 "parser.ypp"
    { (yyval.i4) = OFM_DEPRECATED; }
    break;

  case 236:
#line 3220 "parser.ypp"
    { (yyval.i4) = OFM_PUBLIC; }
    break;

  case 237:
#line 3221 "parser.ypp"
    { (yyval.i4) = OFM_FINAL; }
    break;

  case 238:
#line 3222 "parser.ypp"
    { (yyval.i4) = OFM_ABSTRACT; }
    break;

  case 239:
#line 3226 "parser.ypp"
    {
            // see if the deprecated "returns" keyword can be used
            if (!parse_check_parse_option(PO_ALLOW_RETURNS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                parse_error(*loc, "illegal use of the deprecated \"returns\" keyword (enable by setting parse option PO_ALLOW_RETURNS)");
            }

            if (!(yyvsp[(2) - (2)].parsertype)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                parse_error(*loc, "missing type declaration after 'returns'");
                (yyval.returnTypeInfo) = 0;
            } else {
                (yyval.returnTypeInfo) = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (2)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (2)].parsertype)));
                delete (yyvsp[(2) - (2)].parsertype);
            }
        }
    break;

  case 240:
#line 3243 "parser.ypp"
    {
            (yyval.returnTypeInfo) = 0;
        }
    break;

  case 241:
#line 3249 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(2) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].qv), (yyvsp[(5) - (6)].returnTypeInfo), false, flags));
        }
    break;

  case 242:
#line 3255 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype)));
            delete (yyvsp[(1) - (6)].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(3) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].qv), rt, false, flags));
        }
    break;

  case 243:
#line 3265 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
    break;

  case 244:
#line 3277 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(4) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), rt, (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
    break;

  case 245:
#line 3295 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(2) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].returnTypeInfo), false, flags));
        }
    break;

  case 246:
#line 3301 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (7)].parsertype)));
            delete (yyvsp[(1) - (7)].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), rt, false, flags));
        }
    break;

  case 247:
#line 3311 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (8)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(3) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].qv), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
    break;

  case 248:
#line 3323 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (8)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
            delete (yyvsp[(2) - (8)].parsertype);

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(4) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(6) - (8)]).first_line, (yylsp[(6) - (8)]).last_line, (yyvsp[(6) - (8)].qv), rt, (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
    break;

  case 249:
#line 3341 "parser.ypp"
    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv), loc1, loc3);
        }
    break;

  case 250:
#line 3346 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
            QoreParseListNode* l;
            if ((yyvsp[(1) - (2)].qv).getType() == NT_PARSE_LIST) {
                l = (yyvsp[(1) - (2)].qv).get<QoreParseListNode>();
                if (l->isFinalized()) {
                    QoreParseListNode* nl = new QoreParseListNode(loc);
                    nl->add(l, loc);
                    l = nl;
                }
            }
            else {
                l = new QoreParseListNode(loc);
                l->add((yyvsp[(1) - (2)].qv), loc);
            }
            (yyval.parse_list) = l;
        }
    break;

  case 251:
#line 3366 "parser.ypp"
    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv), loc1, loc3);
        }
    break;

  case 252:
#line 3371 "parser.ypp"
    {
            QoreParseListNode* l;
            if ((yyvsp[(1) - (2)].qv).getType() == NT_PARSE_LIST)
                l = (yyvsp[(1) - (2)].qv).get<QoreParseListNode>();
            else {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
                l = new QoreParseListNode(loc);
                l->add((yyvsp[(1) - (2)].qv), loc);
            }
            (yyval.parse_list) = l;
        }
    break;

  case 253:
#line 3385 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.hash) = new QoreParseHashNode(loc);
            (yyvsp[(1) - (1)].hashelement)->addDelete((yyval.hash));
        }
    break;

  case 254:
#line 3390 "parser.ypp"
    {
            (yyvsp[(3) - (3)].hashelement)->addDelete((yyvsp[(1) - (3)].hash));
            (yyval.hash) = (yyvsp[(1) - (3)].hash);
        }
    break;

  case 255:
#line 3395 "parser.ypp"
    { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[(1) - (2)].hash); }
    break;

  case 256:
#line 3400 "parser.ypp"
    { (yyval.hashelement) = new HashElement((yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv), (yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line); }
    break;

  case 257:
#line 3404 "parser.ypp"
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[(2) - (3)].hash)->setCurly();
            (yyvsp[(2) - (3)].hash)->finalizeBlock((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);

            (yyval.hash) = (yyvsp[(2) - (3)].hash);
        }
    break;

  case 258:
#line 3414 "parser.ypp"
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[(2) - (3)].hash)->setCurly();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[(1) - (3)].string));
            free((yyvsp[(1) - (3)].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), (yyvsp[(2) - (3)].hash));
        }
    break;

  case 259:
#line 3423 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[(1) - (2)].string));
            free((yyvsp[(1) - (2)].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), new QoreParseHashNode(loc, true));
        }
    break;

  case 260:
#line 3433 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 261:
#line 3435 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].binary)); }
    break;

  case 262:
#line 3437 "parser.ypp"
    { (yyval.qv).set((yyvsp[(2) - (3)].hash)); }
    break;

  case 263:
#line 3439 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ScopedRefNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 264:
#line 3443 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (2)].parsertype), (yyloc), (yylsp[(2) - (2)]));
            if (!(yyvsp[(1) - (2)].parsertype) && !strcmp((yyvsp[(2) - (2)].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (2)].parsertype) ? (yylsp[(1) - (2)]).first_line : (yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if ((yyvsp[(1) - (2)].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[(2) - (2)].string), get_var_type()));

            delete (yyvsp[(1) - (2)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 265:
#line 3458 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (2)].parsertype), (yyloc), (yylsp[(2) - (2)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (2)].parsertype) ? (yylsp[(1) - (2)]).first_line : (yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if ((yyvsp[(1) - (2)].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[(2) - (2)].string), get_var_type()));

            delete (yyvsp[(1) - (2)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 266:
#line 3470 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype))));
            delete (yyvsp[(1) - (2)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 267:
#line 3477 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            VarRefDeclNode* v = new VarRefDeclNode(loc, (yyvsp[(3) - (3)].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (3)].parsertype)));
            v->setExplicitScope();
            (yyval.qv).set(v);
            delete (yyvsp[(2) - (3)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(3) - (3)].string));
        }
    break;

  case 268:
#line 3486 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            // see if types are required
            if (parse_check_parse_option(PO_REQUIRE_TYPES))
                parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(2) - (2)].string));
            VarRefNode* v = new VarRefNode(loc, (yyvsp[(2) - (2)].string), VT_LOCAL);
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 269:
#line 3497 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            VarRefNode* v;
            if ((yyvsp[(2) - (3)].parsertype)) {
                v = new VarRefDeclNode(loc, (yyvsp[(3) - (3)].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (3)].parsertype)));
                delete (yyvsp[(2) - (3)].parsertype);
            } else {
                // see if types are required
                if (parse_check_parse_option(PO_REQUIRE_TYPES))
                    parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(3) - (3)].string));
                v = new VarRefNode(loc, (yyvsp[(3) - (3)].string), VT_LOCAL);
            }
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(3) - (3)].string));
        }
    break;

  case 270:
#line 3514 "parser.ypp"
    {
            (yyvsp[(3) - (4)].parse_list)->setVariableList();
            QoreParseListNode::nvec_t& vl = (yyvsp[(3) - (4)].parse_list)->getValues();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            for (unsigned i = 0; i < vl.size(); ++i) {
                QoreValue& n = vl[i];
                qore_type_t t = n.getType();
                if (t == NT_BAREWORD) {
                    BarewordNode* b = n.get<BarewordNode>();
                    if (parse_check_parse_option(PO_REQUIRE_TYPES))
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
                    if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                        parse_error(*loc, "local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
                    VarRefNode* v = new VarRefNode(loc, b->takeString(), VT_LOCAL);
                    v->setExplicitScope();
                    b->deref();
                    n = v;
                } else if (t == NT_VARREF) {
                    VarRefNode* v = n.get<VarRefNode>();
                    // see if types are required
                    if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
                    if (v->explicitScope()) {
                        if (v->getType() == VT_LOCAL)
                            parse_error(*loc, "illegal use of 'my %s' in local variable declaration list", v->getName());
                        else if (v->getType() == VT_GLOBAL)
                            parse_error(*loc, "illegal use of 'our %s' in local variable declaration list", v->getName());
                    } else
                        v->makeLocal();
                    v->setExplicitScope();
                } else
                    parse_error(*loc, "element %d in list following 'my' is not a variable reference (%s)", i, n.getTypeName());
            }
            (yyval.qv).set((yyvsp[(3) - (4)].parse_list));
        }
    break;

  case 271:
#line 3549 "parser.ypp"
    {
            (yyval.qv).set((yyvsp[(1) - (1)].gv)->makeVar());
        }
    break;

  case 272:
#line 3553 "parser.ypp"
    {
            if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[(1) - (1)].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new BarewordNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 273:
#line 3561 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ContextrefNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 274:
#line 3566 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ContextRowNode(loc));
        }
    break;

  case 275:
#line 3571 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ComplexContextrefNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 276:
#line 3576 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            (yyval.qv).set(new FindNode(loc, (yyvsp[(2) - (8)].qv), (yyvsp[(4) - (8)].qv), (yyvsp[(7) - (8)].qv)));
        }
    break;

  case 277:
#line 3581 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreExistsOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 278:
#line 3586 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreElementsOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 279:
#line 3590 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreKeysOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 280:
#line 3594 "parser.ypp"
    {  // unshift list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreUnshiftOperatorNode(loc, lv, l->shift()));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 281:
#line 3608 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreShiftOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 282:
#line 3612 "parser.ypp"
    {  // push lvalue-list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QorePushOperatorNode(loc, lv, l->shift()));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 283:
#line 3626 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QorePopOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 284:
#line 3630 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreChompOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 285:
#line 3634 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreTrimOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 286:
#line 3638 "parser.ypp"
    {  // splice lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else {
                QoreValue lv = l->shift();
                QoreValue offset = l->shift();
                QoreValue length = l->shift();
                (yyval.qv).set(new QoreSpliceOperatorNode(loc, lv, offset, length, l->shift()));
                discard(l, 0);
            }
        }
    break;

  case 287:
#line 3661 "parser.ypp"
    {  // extract lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                QoreValue offset = l->shift();
                QoreValue length = l->shift();
                (yyval.qv).set(new QoreExtractOperatorNode(loc, lv, offset, length, l->shift()));
                discard(l, 0);
            }
        }
    break;

  case 288:
#line 3687 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            int len = l ? (int)l->size() : 0;
            if (!l || len < 2 || len > 3) {
                parse_error(*loc, "invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else {
                // get first expression from list
                QoreValue exp = l->shift();
                qore_type_t t = exp.getType();
                (yyval.qv).set(nullptr);
                bool is_curly = false;
                if (t == NT_PARSE_HASH) {
                    QoreParseHashNode* phn = exp.get<QoreParseHashNode>();
                    if (phn->isCurly()) {
                        is_curly = true;
                        (yyval.qv).set(parse_hash_map(loc, phn, l));
                    }
                }

                if (!(yyval.qv) && !is_curly) {
                    (yyval.qv).set(parse_map(loc, exp, l));
                }
            }
        }
    break;

  case 289:
#line 3715 "parser.ypp"
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldrOperatorNode(loc, code_exp, arg));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 290:
#line 3731 "parser.ypp"
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldlOperatorNode(loc, code_exp, arg));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 291:
#line 3747 "parser.ypp"
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue arg = l->shift();
                QoreValue select_exp = l->shift();
                (yyval.qv).set(new QoreSelectOperatorNode(loc, arg, select_exp));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 292:
#line 3763 "parser.ypp"
    {  // pre-increment
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QorePreIncrementOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 293:
#line 3767 "parser.ypp"
    {  // pre-decrement
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QorePreDecrementOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 294:
#line 3771 "parser.ypp"
    {
            printd(5, "parsing in-object base class method call %s()\n", (yyvsp[(1) - (4)].nscope)->ostr);
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            if (!strcmp((yyvsp[(1) - (4)].nscope)->getIdentifier(), "copy"))
                parse_error(*loc, "illegal call to base class copy method '%s'", (yyvsp[(1) - (4)].nscope)->ostr);

            (yyval.qv).set(new SelfFunctionCallNode(loc, (yyvsp[(1) - (4)].nscope), make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(3) - (4)].qv))));
        }
    break;

  case 295:
#line 3779 "parser.ypp"
    {
            printd(5, "parsing call %s()\n", (yyvsp[(1) - (3)].string));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.qv).set(new FunctionCallNode(loc, (yyvsp[(1) - (3)].string), make_args(argsloc, (yyvsp[(2) - (3)].qv))));
        }
    break;

  case 296:
#line 3786 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new SelfVarrefNode(loc, (yyvsp[(1) - (1)].string)));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 297:
#line 3792 "parser.ypp"
    {
            // FIXME: need to expand constant expression checking to determine
            //        if the expression can throw an exception at run-time
            // first check for constant expressions
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreUnaryMinusOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 298:
#line 3800 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreUnaryPlusOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 299:
#line 3804 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreBinaryNotOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 300:
#line 3808 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreLogicalNotOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 301:
#line 3812 "parser.ypp"
    {
            qore_type_t t = (yyvsp[(2) - (2)].qv).getType();
            //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2.getTypeName());

            if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
                (yyval.qv).set((yyvsp[(2) - (2)].qv).get<FunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_SELF_CALL) {
                (yyval.qv).set((yyvsp[(2) - (2)].qv).get<SelfFunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_STATIC_METHOD_CALL) {
                (yyval.qv).set((yyvsp[(2) - (2)].qv).get<StaticMethodCallNode>()->makeReferenceNodeAndDeref());
            }
            else {
                bool make_ref = true;

                if (t == NT_OPERATOR) {
                    QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[(2) - (2)].qv).getInternalNode());
                    if (deon) {
                        (yyval.qv).set(deon->makeCallReference());
                        make_ref = false;
                    }
                }

                if (make_ref) {
                    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                    //printd(5, "type=%s\n", $2.getTypeName());
                    (yyval.qv).set(new ParseReferenceNode(loc, (yyvsp[(2) - (2)].qv)));
                }
            }
        }
    break;

  case 302:
#line 3843 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[(2) - (5)].string)), make_args(argsloc, (yyvsp[(4) - (5)].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 303:
#line 3850 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[(2) - (5)].string)), make_args(argsloc, (yyvsp[(4) - (5)].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 304:
#line 3857 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.qv).set(new ParseNewComplexTypeNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(2) - (5)].string), false), make_args(argsloc, (yyvsp[(4) - (5)].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 305:
#line 3864 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreBackgroundOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
            // check to see if the expression is legal
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
                parse_error(*loc, "illegal use of 'background' operator (conflicts with parse option PO_NO_THREAD_CONTROL)");
            else if (!value_has_effect_as_root((yyvsp[(2) - (2)].qv))) {
                if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                    parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[(2) - (2)].qv).getTypeName());
                }
            } else if (!(yyvsp[(2) - (2)].qv).hasEffect()) {
                parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[(2) - (2)].qv).getTypeName());
            }
        }
    break;

  case 306:
#line 3878 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new BackquoteNode(loc, (yyvsp[(1) - (1)].string)));
            if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
                parse_error(*loc, "illegal use of backquote operator (conflicts with parse option PO_NO_EXTERNAL_PROCESS)");
        }
    break;

  case 307:
#line 3884 "parser.ypp"
    {
            (yyval.qv).set((yyvsp[(2) - (3)].qv));
            switch ((yyvsp[(2) - (3)].qv).getType()) {
                case NT_PARSE_LIST:
                    (yyvsp[(2) - (3)].qv).get<QoreParseListNode>()->setFinalized();
                    break;
                case NT_FUNCTION_CALL:
                    (yyvsp[(2) - (3)].qv).get<FunctionCallNode>()->setFinalized();
                    break;
                case NT_BAREWORD:
                    (yyvsp[(2) - (3)].qv).get<BarewordNode>()->setFinalized();
                    break;
                case NT_OPERATOR:
                    (yyvsp[(2) - (3)].qv).get<QoreOperatorNode>()->setInParentheses();
                    break;
            }
        }
    break;

  case 308:
#line 3901 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreParseListNode* l = new QoreParseListNode(loc);
            l->setFinalized();
            (yyval.qv).set(l);
        }
    break;

  case 309:
#line 3907 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].qv), (yyvsp[(5) - (6)].returnTypeInfo), false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
    break;

  case 310:
#line 3912 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype)));
            delete (yyvsp[(1) - (6)].parsertype);

            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].qv), rt, false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
    break;

  case 311:
#line 3920 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags)));
        }
    break;

  case 312:
#line 3929 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), rt, (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags)));
        }
    break;

  case 313:
#line 3942 "parser.ypp"
    {
            (yyval.qv).set((yyvsp[(1) - (1)].implicit_arg));
            inc_numeric_argv_ref();
        }
    break;

  case 314:
#line 3946 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new QoreImplicitElementNode(loc));
        }
    break;

  case 315:
#line 3950 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreDeleteOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 316:
#line 3954 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreRemoveOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 317:
#line 3958 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(1) - (4)].string), false), (yyvsp[(3) - (4)].qv)));
        }
    break;

  case 318:
#line 3962 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(1) - (4)].string), true), (yyvsp[(3) - (4)].qv)));
        }
    break;

  case 319:
#line 3969 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 320:
#line 3970 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].parse_list)); }
    break;

  case 321:
#line 3971 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].hash)); }
    break;

  case 322:
#line 3972 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].node)); }
    break;

  case 323:
#line 3973 "parser.ypp"
    { (yyval.qv).set(new QoreParseHashNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), true)); }
    break;

  case 324:
#line 3974 "parser.ypp"
    { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 325:
#line 3975 "parser.ypp"
    { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 326:
#line 3976 "parser.ypp"
    { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 327:
#line 3977 "parser.ypp"
    { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 328:
#line 3978 "parser.ypp"
    { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 329:
#line 3979 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 330:
#line 3980 "parser.ypp"
    { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 331:
#line 3981 "parser.ypp"
    { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 332:
#line 3982 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 333:
#line 3983 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 334:
#line 3984 "parser.ypp"
    {
        (yyval.qv).set(process_assignment((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 335:
#line 3987 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 336:
#line 3995 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        (yyval.qv).set((yyvsp[(3) - (3)].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getParseTypeInfo()));
        delete (yyvsp[(3) - (3)].parsertype);
    }
    break;

  case 337:
#line 4002 "parser.ypp"
    { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 338:
#line 4003 "parser.ypp"
    { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 339:
#line 4004 "parser.ypp"
    { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].qv))); }
    break;

  case 340:
#line 4005 "parser.ypp"
    { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 341:
#line 4006 "parser.ypp"
    { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 342:
#line 4007 "parser.ypp"
    { (yyval.qv).set(processCall((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line, (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line))); }
    break;

  case 343:
#line 4008 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_log_or(loc, (yyvsp[(1) - (3)].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 344:
#line 4013 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 345:
#line 4014 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 346:
#line 4015 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 347:
#line 4016 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 348:
#line 4021 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 349:
#line 4022 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 350:
#line 4028 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 351:
#line 4029 "parser.ypp"
    { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 352:
#line 4030 "parser.ypp"
    { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 353:
#line 4031 "parser.ypp"
    { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].RegexSubst))); }
    break;

  case 354:
#line 4032 "parser.ypp"
    { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Trans))); }
    break;

  case 355:
#line 4033 "parser.ypp"
    { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 356:
#line 4034 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 357:
#line 4035 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 358:
#line 4036 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 359:
#line 4037 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 360:
#line 4038 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 361:
#line 4039 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 362:
#line 4040 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 363:
#line 4041 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 364:
#line 4042 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 365:
#line 4043 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 366:
#line 4044 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 367:
#line 4045 "parser.ypp"
    { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 368:
#line 4046 "parser.ypp"
    { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 369:
#line 4047 "parser.ypp"
    { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 370:
#line 4048 "parser.ypp"
    { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 371:
#line 4049 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 372:
#line 4050 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), QoreValue())); }
    break;

  case 373:
#line 4051 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), QoreValue(), (yyvsp[(4) - (5)].qv))); }
    break;

  case 374:
#line 4052 "parser.ypp"
    {
        parse_error(*qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].qv), QoreValue(), QoreValue()));
    }
    break;

  case 375:
#line 4056 "parser.ypp"
    {
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[(3) - (4)].qv).getType() == NT_OPERATOR) {
            QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[(3) - (4)].qv).getInternalNode());
            if (ron) {
                std::unique_ptr<QoreRangeOperatorNode> holder(ron);
                (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
            }
        }
        if (!(yyval.qv)) {
            (yyval.qv).set(new QoreSquareBracketsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv)));
        }
    }
    break;

  case 376:
#line 4070 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv))); }
    break;

  case 377:
#line 4071 "parser.ypp"
    { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 378:
#line 4072 "parser.ypp"
    { (yyval.qv).set(process_dot((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 379:
#line 4073 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv), (yyvsp[(2) - (2)].String))); }
    break;

  case 380:
#line 4077 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 381:
#line 4078 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].parse_list)); }
    break;

  case 382:
#line 4079 "parser.ypp"
    { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 383:
#line 4080 "parser.ypp"
    { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 384:
#line 4081 "parser.ypp"
    { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 385:
#line 4082 "parser.ypp"
    { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 386:
#line 4083 "parser.ypp"
    { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 387:
#line 4084 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 388:
#line 4085 "parser.ypp"
    { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 389:
#line 4086 "parser.ypp"
    { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 390:
#line 4087 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 391:
#line 4088 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 392:
#line 4089 "parser.ypp"
    {
        (yyval.qv).set(process_assignment((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 393:
#line 4092 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 394:
#line 4100 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        (yyval.qv).set((yyvsp[(3) - (3)].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getParseTypeInfo()));
        delete (yyvsp[(3) - (3)].parsertype);
    }
    break;

  case 395:
#line 4107 "parser.ypp"
    { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 396:
#line 4108 "parser.ypp"
    { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 397:
#line 4109 "parser.ypp"
    { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].qv))); }
    break;

  case 398:
#line 4110 "parser.ypp"
    { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 399:
#line 4111 "parser.ypp"
    { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 400:
#line 4112 "parser.ypp"
    { (yyval.qv).set(processCall((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line, (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line))); }
    break;

  case 401:
#line 4113 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_log_or(loc, (yyvsp[(1) - (3)].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 402:
#line 4118 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 403:
#line 4119 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 404:
#line 4120 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 405:
#line 4121 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 406:
#line 4126 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 407:
#line 4127 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 408:
#line 4133 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 409:
#line 4134 "parser.ypp"
    { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 410:
#line 4135 "parser.ypp"
    { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 411:
#line 4136 "parser.ypp"
    { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].RegexSubst))); }
    break;

  case 412:
#line 4137 "parser.ypp"
    { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Trans))); }
    break;

  case 413:
#line 4138 "parser.ypp"
    { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 414:
#line 4139 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 415:
#line 4140 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 416:
#line 4141 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 417:
#line 4142 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 418:
#line 4143 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 419:
#line 4144 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 420:
#line 4145 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 421:
#line 4146 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 422:
#line 4147 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 423:
#line 4148 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 424:
#line 4149 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 425:
#line 4150 "parser.ypp"
    { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 426:
#line 4151 "parser.ypp"
    { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 427:
#line 4152 "parser.ypp"
    { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 428:
#line 4153 "parser.ypp"
    { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 429:
#line 4154 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 430:
#line 4155 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), QoreValue())); }
    break;

  case 431:
#line 4156 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), QoreValue(), (yyvsp[(4) - (5)].qv))); }
    break;

  case 432:
#line 4157 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
        parse_error(*loc, "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[(1) - (4)].qv), QoreValue(), QoreValue()));
    }
    break;

  case 433:
#line 4162 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[(3) - (4)].qv).getType() == NT_OPERATOR) {
            QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[(3) - (4)].qv).getInternalNode());
            if (ron) {
                std::unique_ptr<QoreRangeOperatorNode> holder(ron);
                (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[(1) - (4)].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
            }
        }
        if (!(yyval.qv)) {
            (yyval.qv).set(new QoreSquareBracketsOperatorNode(loc, (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv)));
        }
    }
    break;

  case 434:
#line 4177 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv))); }
    break;

  case 435:
#line 4178 "parser.ypp"
    { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 436:
#line 4179 "parser.ypp"
    { (yyval.qv).set(process_dot((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 437:
#line 4180 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv), (yyvsp[(2) - (2)].String))); }
    break;

  case 438:
#line 4184 "parser.ypp"
    {
           (yyval.String) = (yyvsp[(1) - (1)].String);
        }
    break;

  case 439:
#line 4187 "parser.ypp"
    {
            (yyval.String) = (yyvsp[(1) - (2)].String);
            (yyval.String)->concat((yyvsp[(2) - (2)].String));
            (yyvsp[(2) - (2)].String)->deref();
        }
    break;

  case 440:
#line 4195 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].decimal)); }
    break;

  case 441:
#line 4196 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].integer)); }
    break;

  case 442:
#line 4197 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].String)); }
    break;

  case 443:
#line 4198 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].datetime)); }
    break;

  case 444:
#line 4199 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].num)); }
    break;

  case 445:
#line 4200 "parser.ypp"
    { (yyval.qv).set(nullptr); }
    break;

  case 446:
#line 4201 "parser.ypp"
    { (yyval.qv).set(&Null); }
    break;

  case 447:
#line 4202 "parser.ypp"
    { (yyval.qv).set(true); }
    break;

  case 448:
#line 4203 "parser.ypp"
    { (yyval.qv).set(false); }
    break;


/* Line 1267 of yacc.c.  */
#line 11057 "parser.cpp"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (&yylloc, yyscanner, yymsg);
	  }
	else
	  {
	    yyerror (&yylloc, yyscanner, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc, yyscanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, &yylloc, yyscanner);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 4206 "parser.ypp"


