var index =
[
    [ "Introduction", "qore_intro.html", [
      [ "Introduction to Qore", "qore_intro.html#qore_introduction", null ]
    ] ],
    [ "Language Overview", "desc_overview.html", null ],
    [ "Environment Variables", "environment_variables.html", null ],
    [ "Conditional Parsing and Parse Defines", "conditional_parsing.html", null ],
    [ "Module Description", "qore_modules.html", [
      [ "Module Overview", "qore_modules.html#mod_overview", null ],
      [ "Binary Modules", "qore_modules.html#binary_modules", null ],
      [ "User Modules", "qore_modules.html#user_modules", [
        [ "User Module Declarations", "qore_modules.html#user_module_declarations", null ],
        [ "The \"public\" Keyword", "qore_modules.html#mod_public", null ],
        [ "Module Example", "qore_modules.html#User", null ],
        [ "Program Scope in Object-Oriented Programs Using User Modules Providing Their Own Threads", "qore_modules.html#user_module_program_scope", null ]
      ] ]
    ] ],
    [ "Include Files", "include_files.html", null ],
    [ "Identifiers", "identifiers.html", null ],
    [ "Comments", "comments.html", null ],
    [ "Variables", "variables.html", [
      [ "Special Variables", "variables.html#special_variables", null ],
      [ "Variable Declarations and Lexical Scope", "variables.html#variable_declarations", [
        [ "Variable Implicit Construction", "variables.html#variable_implicit_construction", null ]
      ] ],
      [ "Local Variables", "variables.html#local_variables", [
        [ "The \"my\" Keyword", "variables.html#my", null ]
      ] ],
      [ "Global Variables", "variables.html#global_variables", [
        [ "The \"our\" Keyword", "variables.html#our", null ]
      ] ],
      [ "Thread-Local Global Variables", "variables.html#thread_local_variables", [
        [ "The \"thread_local\" Keyword", "variables.html#thread_local", null ]
      ] ]
    ] ],
    [ "Basic Data Types", "basic_data_types.html", [
      [ "Boolean", "basic_data_types.html#boolean", [
        [ "True", "basic_data_types.html#True", null ],
        [ "False", "basic_data_types.html#False", null ]
      ] ],
      [ "String", "basic_data_types.html#string", null ],
      [ "Integer", "basic_data_types.html#integer", null ],
      [ "Float", "basic_data_types.html#float", null ],
      [ "Number", "basic_data_types.html#number", null ],
      [ "Date", "basic_data_types.html#date", [
        [ "Absolute Date/Time Values", "basic_data_types.html#absolute_dates", null ],
        [ "Relative Date/Time Values (Durations)", "basic_data_types.html#relative_dates", [
          [ "Single Relative Time Format", "basic_data_types.html#single_reldates", null ],
          [ "Short Relative Time Format", "basic_data_types.html#short_reldates", null ],
          [ "Long Relative Time Format", "basic_data_types.html#long_reldates", null ],
          [ "Relative Date/Time Comparisons", "basic_data_types.html#reldate_comparisons", null ]
        ] ]
      ] ],
      [ "Binary", "basic_data_types.html#binary", null ],
      [ "NULL", "basic_data_types.html#null", [
        [ "NULL", "basic_data_types.html#NULL", null ]
      ] ],
      [ "NOTHING", "basic_data_types.html#nothing", [
        [ "NOTHING", "basic_data_types.html#NOTHING", null ]
      ] ],
      [ "Data Conversions", "basic_data_types.html#conversions", null ]
    ] ],
    [ "Container Data Types", "container_data_types.html", [
      [ "List", "container_data_types.html#list", null ],
      [ "Hash", "container_data_types.html#hash", null ],
      [ "Object", "container_data_types.html#object", [
        [ "Object Overview", "container_data_types.html#object_overview", null ],
        [ "Object References", "container_data_types.html#object_references", null ],
        [ "Object Scope and Garbage Collection", "container_data_types.html#object_scope_and_gc", [
          [ "Garbage Collection and Resource Management", "container_data_types.html#garbage_collection", null ],
          [ "Object Scope", "container_data_types.html#object_scope", null ]
        ] ],
        [ "Copying Objects", "container_data_types.html#copying_objects", null ]
      ] ]
    ] ],
    [ "Code Data Types", "code_data_types.html", [
      [ "Closure Type", "code_data_types.html#closure_type", null ],
      [ "Call Reference Type", "code_data_types.html#callref_type", null ]
    ] ],
    [ "Data Type Declarations and Restrictions", "data_type_declarations.html", [
      [ "int", "data_type_declarations.html#int_type", null ],
      [ "float", "data_type_declarations.html#float_type", null ],
      [ "number", "data_type_declarations.html#number_type", null ],
      [ "bool", "data_type_declarations.html#bool_type", null ],
      [ "string", "data_type_declarations.html#string_type", null ],
      [ "date", "data_type_declarations.html#date_type", null ],
      [ "binary", "data_type_declarations.html#binary_type", null ],
      [ "hash", "data_type_declarations.html#hash_type", [
        [ "Type-Safe Hash Type", "data_type_declarations.html#hash_hashdecl_type", null ],
        [ "Hash With Declared Value Type", "data_type_declarations.html#hash_complex_type", null ]
      ] ],
      [ "list", "data_type_declarations.html#list_type", [
        [ "List With Declared Value Type", "data_type_declarations.html#list_complex_type", null ]
      ] ],
      [ "object", "data_type_declarations.html#object_type", [
        [ "Class-Specific Type Declaration", "data_type_declarations.html#object_complex_type", null ]
      ] ],
      [ "<classname>", "data_type_declarations.html#classname_type", null ],
      [ "null", "data_type_declarations.html#null_type", null ],
      [ "nothing", "data_type_declarations.html#nothing_type", null ],
      [ "timeout", "data_type_declarations.html#timeout_type", null ],
      [ "base64binary", "data_type_declarations.html#base64binary_type", null ],
      [ "hexbinary", "data_type_declarations.html#hexbinary_type", null ],
      [ "softbinary", "data_type_declarations.html#softbinary_type", null ],
      [ "softint", "data_type_declarations.html#softint_type", null ],
      [ "softfloat", "data_type_declarations.html#softfloat_type", null ],
      [ "softnumber", "data_type_declarations.html#softnumber_type", null ],
      [ "softbool", "data_type_declarations.html#softbool_type", null ],
      [ "softstring", "data_type_declarations.html#softstring_type", null ],
      [ "softdate", "data_type_declarations.html#softdate_type", null ],
      [ "softlist", "data_type_declarations.html#softlist_type", [
        [ "Softlist With Declared Value Type", "data_type_declarations.html#softlist_complex_type", null ]
      ] ],
      [ "data", "data_type_declarations.html#data_type", null ],
      [ "code", "data_type_declarations.html#code_type", null ],
      [ "reference", "data_type_declarations.html#reference_type", [
        [ "Reference With Declared LValue Type", "data_type_declarations.html#reference_complex_type", null ]
      ] ],
      [ "*int", "data_type_declarations.html#int_or_nothing_type", null ],
      [ "*float", "data_type_declarations.html#float_or_nothing_type", null ],
      [ "*number", "data_type_declarations.html#number_or_nothing_type", null ],
      [ "*bool", "data_type_declarations.html#bool_or_nothing_type", null ],
      [ "*string", "data_type_declarations.html#string_or_nothing_type", null ],
      [ "*date", "data_type_declarations.html#date_or_nothing_type", null ],
      [ "*binary", "data_type_declarations.html#binary_or_nothing_type", null ],
      [ "*hash", "data_type_declarations.html#hash_or_nothing_type", [
        [ "*hash<...>", "data_type_declarations.html#hash_hashdecl_or_nothing_type", null ],
        [ "*hash<string, ...>", "data_type_declarations.html#hash_complex_or_nothing_type", null ]
      ] ],
      [ "*list", "data_type_declarations.html#list_or_nothing_type", [
        [ "*list<...>", "data_type_declarations.html#list_complex_or_nothing_type", null ]
      ] ],
      [ "*object", "data_type_declarations.html#object_or_nothing_type", null ],
      [ "*<classname>", "data_type_declarations.html#classname_type_or_nothing", null ],
      [ "*null", "data_type_declarations.html#null_or_nothing_type", null ],
      [ "*date", "data_type_declarations.html#data_or_nothing_type", null ],
      [ "*code", "data_type_declarations.html#code_or_nothing_type", null ],
      [ "*timeout", "data_type_declarations.html#timeout_or_nothing_type", null ],
      [ "*reference", "data_type_declarations.html#reference_or_nothing_type", [
        [ "*reference<...>", "data_type_declarations.html#reference_complex_or_nothing_type", null ]
      ] ],
      [ "*softint", "data_type_declarations.html#softint_or_nothing_type", null ],
      [ "*softfloat", "data_type_declarations.html#softfloat_or_nothing_type", null ],
      [ "*softnumber", "data_type_declarations.html#softnumber_or_nothing_type", null ],
      [ "*softbool", "data_type_declarations.html#softbool_or_nothing_type", null ],
      [ "*softstring", "data_type_declarations.html#softstring_or_nothing_type", null ],
      [ "*softdate", "data_type_declarations.html#softdate_or_nothing_type", null ],
      [ "*softlist", "data_type_declarations.html#softlist_or_nothing_type", [
        [ "*softlist<...>", "data_type_declarations.html#softlist_complex_or_nothing_type", null ]
      ] ],
      [ "any", "data_type_declarations.html#any_type", null ],
      [ "auto", "data_type_declarations.html#auto_type", null ]
    ] ],
    [ "References", "lvalue_references.html", [
      [ "Overview of References", "lvalue_references.html#references_overview", null ],
      [ "Reference Type Restrictions", "lvalue_references.html#reference_types", null ]
    ] ],
    [ "Overloading", "overloading.html", [
      [ "Overloading Introduction", "overloading.html#overloading_intro", null ],
      [ "Overloaded Class Methods", "overloading.html#overloaded_methods", null ]
    ] ],
    [ "Time Zone Handling", "time_zones.html", [
      [ "UNIX Time Zone Handling", "time_zones.html#unix_time_zones", null ],
      [ "Windows Time Zone Handling", "time_zones.html#windows_time_zones", null ],
      [ "More Time Zone Information and Examples", "time_zones.html#time_zone_examples", null ]
    ] ],
    [ "Strings and Character Encoding", "character_encoding.html", [
      [ "Overview", "character_encoding.html#character_encoding_overview", null ],
      [ "Character Encodings Known to Qore", "character_encoding.html#known_encodings", [
        [ "UTF-16 Support in Qore", "character_encoding.html#utf16_in_qore", null ]
      ] ],
      [ "Default Character Encoding", "character_encoding.html#default_encoding", null ],
      [ "Character Encoding Usage Examples", "character_encoding.html#encoding_examples", null ]
    ] ],
    [ "Expressions", "expressions.html", [
      [ "Static Method Calls", "expressions.html#static_method_calls", null ],
      [ "Find Expressions", "expressions.html#find", null ],
      [ "Call References", "expressions.html#call_reference", null ],
      [ "Closures", "expressions.html#closure", null ],
      [ "Implicit Argument References", "expressions.html#implicit_arguments", null ],
      [ "Implicit Index", "expressions.html#implicit_index", null ]
    ] ],
    [ "Operators", "operators.html", [
      [ "Operator Atomicity", "operators.html#op_atomicity", null ],
      [ "Operator Arguments", "operators.html#op_args", null ],
      [ "Lazy Evalution of Functional Operators", "operators.html#op_functional", null ],
      [ "Operator Details", "operators.html#op_details", [
        [ "Backquote Operator (``)", "operators.html#backquote_operator", null ],
        [ "Hash Element or Object Member Expression Dereference Operator ({})", "operators.html#hash_element_operator", null ],
        [ "Hash Element or Object Member Literal Dereference Operator (.)", "operators.html#dot_operator", null ],
        [ "List, String, and Binary Dereference Operator ([])", "operators.html#list_element_operator", null ],
        [ "Pre-Increment Operator (++)", "operators.html#pre_increment_operator", null ],
        [ "Integer Post-Increment Operator (++)", "operators.html#post_increment_operator", null ],
        [ "Integer Pre-Decrement Operator (--)", "operators.html#pre_decrement_operator", null ],
        [ "Integer Post-Decrement Operator (--)", "operators.html#post_decrement_operator", null ],
        [ "New Value Operator (new)", "operators.html#new", null ],
        [ "Background Operator (background)", "operators.html#background", null ],
        [ "Delete Operator (delete)", "operators.html#delete", null ],
        [ "Remove Operator (remove)", "operators.html#remove", null ],
        [ "Cast Operator (cast<>())", "operators.html#cast", null ],
        [ "Logical Not Operator (!)", "operators.html#logical_negation_operator", null ],
        [ "Binary Not Operator (~)", "operators.html#binary_not_operator", null ],
        [ "Unary Minus Operator (-)", "operators.html#unary_minus_operator", null ],
        [ "Unary Plus Operator (+)", "operators.html#unary_plus_operator", null ],
        [ "Shift Operator (shift)", "operators.html#shift", null ],
        [ "Pop Operator (pop)", "operators.html#pop", null ],
        [ "Chomp Operator (chomp)", "operators.html#chomp", null ],
        [ "Trim Operator (trim)", "operators.html#trim", null ],
        [ "Map Operator (map)", "operators.html#map", null ],
        [ "Hash Map Operator (map)", "operators.html#hmap", null ],
        [ "Fold Left Operator (foldl)", "operators.html#foldl", null ],
        [ "Fold Right Operator (foldr)", "operators.html#foldr", null ],
        [ "Select From List Operator (select)", "operators.html#select", null ],
        [ "Elements Operator (elements)", "operators.html#elements", null ],
        [ "Keys Operator (keys)", "operators.html#keys", null ],
        [ "Multiply Operator (*)", "operators.html#multiplication_operator", null ],
        [ "Divide Operator (/)", "operators.html#division_operator", null ],
        [ "Modulo Operator (%)", "operators.html#modulo_operator", null ],
        [ "Plus (Addition and Concatenation) Operator (+)", "operators.html#plus_operator", null ],
        [ "Minus Operator (-)", "operators.html#minus_operator", null ],
        [ "Shift Right Operator (>>)", "operators.html#shift_right_operator", null ],
        [ "Shift Left Operator (<<)", "operators.html#shift_left_operator", null ],
        [ "Operator (instanceof)", "operators.html#instanceof", null ],
        [ "Exists Operator (exists)", "operators.html#exists", null ],
        [ "Less Than Operator (<)", "operators.html#logical_less_than_operator", null ],
        [ "Greater Than Operator (>)", "operators.html#logical_greater_than_operator", null ],
        [ "Equals Operator (==)", "operators.html#logical_equality_operator", null ],
        [ "Not Equals Operator (!=)", "operators.html#logical_inequality_operator", null ],
        [ "Less Than Or Equals Operator (<=)", "operators.html#logical_less_than_or_equals_operator", null ],
        [ "Greater Than Or Equals Operator (>=)", "operators.html#logical_greater_than_or_equals_operator", null ],
        [ "Comparison (<=>) Operator", "operators.html#logical_comparison_operator", null ],
        [ "Absolute Equals Operator (===)", "operators.html#logical_absolute_equality_operator", null ],
        [ "Absolute Not Equals Operator (!==)", "operators.html#logical_absolute_inequality_operator", null ],
        [ "Regular Expression Match Operator (=~)", "operators.html#regex_match_operator", null ],
        [ "Regular Expression No Match Operator (!~)", "operators.html#regex_no_match_operator", null ],
        [ "Regular Expression Substitution Operator", "operators.html#regex_subst_operator", null ],
        [ "Regular Expression Pattern Extraction Operator", "operators.html#regex_extract_operator", null ],
        [ "Transliteration Operator", "operators.html#transliteration_operator", null ],
        [ "Bitwise/Binary And Operator (&)", "operators.html#bitwise_and_operator", null ],
        [ "Bitwise/Binary Or Operator (|)", "operators.html#bitwise_or_operator", null ],
        [ "Bitwise/Binary Xor Operator (^)", "operators.html#bitwise_xor_operator", null ],
        [ "Logical And Operator (&&)", "operators.html#logical_and_operator", null ],
        [ "Logical Or Operator (||)", "operators.html#logical_or_operator", null ],
        [ "Conditional Operator (? :)", "operators.html#conditional_operator", null ],
        [ "Null Coalescing Operator (??)", "operators.html#null_coalescing_operator", null ],
        [ "Value Coalescing Operator (?*)", "operators.html#value_coalescing_operator", null ],
        [ "Comma Operator (,)", "operators.html#comma_operator", null ],
        [ "Unshift Operator (unshift)", "operators.html#unshift", null ],
        [ "Push Operator (push)", "operators.html#push", null ],
        [ "Splice Operator (splice)", "operators.html#splice", null ],
        [ "Extract Operator (extract)", "operators.html#extract", null ],
        [ "Assignment Operator (=)", "operators.html#assignment_operator", null ],
        [ "Weak Reference Assignment Operator (:=)", "operators.html#weak_assignment_operator", null ],
        [ "Plus Equals Operator (+=)", "operators.html#plus_equals_operator", null ],
        [ "Minus Equals Operator (-=)", "operators.html#minus_equals_operator", null ],
        [ "And Equals Operator (&=)", "operators.html#and_equals_operator", null ],
        [ "Or Equals Operator (|=)", "operators.html#or_equals_operator", null ],
        [ "Modulo Equals Operator (%=)", "operators.html#modulo_equals_operator", null ],
        [ "Multiply Equals Operator (*=)", "operators.html#multiply_equals_operator", null ],
        [ "Divide Equals Operator (/=)", "operators.html#divide_equals_operator", null ],
        [ "Xor Equals Operator (^=)", "operators.html#xor_equals_operator", null ],
        [ "Shift Left Equals Operator (<<=)", "operators.html#shift_left_equals_operator", null ],
        [ "Shift Right Equals Operator (>>=)", "operators.html#shift_right_equals_operator", null ],
        [ "Range Operator (..)", "operators.html#range_operator", null ]
      ] ]
    ] ],
    [ "Regular Expressions", "qore_regex.html", [
      [ "Qore Regular Expression Introduction", "qore_regex.html#qore_regex_intro", null ],
      [ "Qore Regular Expression Operators", "qore_regex.html#qore_regex_operators", [
        [ "Qore Regular Expression Operator Options", "qore_regex.html#qore_regex_options", null ]
      ] ],
      [ "Qore Regular Expression Functions", "qore_regex.html#qore_regex_functions", null ],
      [ "Qore Regular Expression Escape Codes", "qore_regex.html#qore_regex_escape_patterns", [
        [ "Qore Regular Expression Replacement String Escape Codes", "qore_regex.html#qore_regex_escape_replacement_string", null ]
      ] ],
      [ "Qore Regular Expression Backreferences", "qore_regex.html#qore_regex_backreferences", null ]
    ] ],
    [ "Date/Time Arithmetic", "date_time_arithmetic.html", [
      [ "Adding and Subtracting Years and Months", "date_time_arithmetic.html#date_time_arithmetic_adding_years_months", null ],
      [ "Adding and Subtracting Days", "date_time_arithmetic.html#date_time_arithmetic_days", null ],
      [ "Finding the Difference Between Two Dates", "date_time_arithmetic.html#date_time_arithmetic_difference", null ],
      [ "Timezones and Daylight Savings Time", "date_time_arithmetic.html#date_time_arithmetic_zones", null ],
      [ "Leap Years and the Gregorian Calendar", "date_time_arithmetic.html#date_time_arithmetic_leap_years", null ]
    ] ],
    [ "Statements", "statements.html", [
      [ "if and else Statements", "statements.html#if", null ],
      [ "for Statements", "statements.html#for", null ],
      [ "foreach Statements", "statements.html#foreach", null ],
      [ "switch Statements", "statements.html#switch", null ],
      [ "while Statements", "statements.html#while", null ],
      [ "do while Statements", "statements.html#do", null ],
      [ "continue Statements", "statements.html#continue", null ],
      [ "break Statements", "statements.html#break", null ],
      [ "throw Statements", "statements.html#throw", null ],
      [ "try and catch Statements", "statements.html#try", null ],
      [ "rethrow Statements", "statements.html#rethrow", null ],
      [ "thread_exit Statements", "statements.html#thread_exit", null ],
      [ "context Statements", "statements.html#context", null ],
      [ "summarize Statements", "statements.html#summarize", null ],
      [ "subcontext Statements", "statements.html#subcontext", null ],
      [ "return Statements", "statements.html#return", null ],
      [ "on_exit Statements", "statements.html#on_exit", null ],
      [ "on_success Statements", "statements.html#on_success", null ],
      [ "on_error Statements", "statements.html#on_error", null ]
    ] ],
    [ "Functions", "qore_functions.html", [
      [ "Function Declarations", "qore_functions.html#function_declarations", [
        [ "Function Parameters", "qore_functions.html#function_parameters", null ],
        [ "Function Return Type Declarations", "qore_functions.html#function_return_types", null ],
        [ "Simple Example Functions", "qore_functions.html#function_examples", null ],
        [ "\"Synchronized\" Functions", "qore_functions.html#synchronized_functions", null ],
        [ "\"Deprecated\" Functions", "qore_functions.html#deprecated-functions", null ]
      ] ]
    ] ],
    [ "Code Flags", "code_flags.html", [
      [ "NOOP", "code_flags.html#NOOP", null ],
      [ "RUNTIME_NOOP", "code_flags.html#RUNTIME_NOOP", null ],
      [ "CONSTANT", "code_flags.html#CONSTANT", null ],
      [ "RET_VALUE_ONLY", "code_flags.html#RET_VALUE_ONLY", null ],
      [ "DEPRECATED", "code_flags.html#DEPRECATED", null ]
    ] ],
    [ "Namespaces", "qore_namespaces.html", null ],
    [ "Constants", "constants.html", null ],
    [ "Classes", "qore_classes.html", [
      [ "Class Overview", "qore_classes.html#class_overview", null ],
      [ "Class Methods", "qore_classes.html#class_methods", null ],
      [ "Class Members", "qore_classes.html#class_members", [
        [ "Public Member Declarations", "qore_classes.html#public_members", null ],
        [ "Private Members", "qore_classes.html#private_members", null ],
        [ "Transient Members", "qore_classes.html#transient", null ],
        [ "Class Member References", "qore_classes.html#referencing_members", null ],
        [ "memberGate() Method", "qore_classes.html#memberGate_methods", null ],
        [ "memberNotification() Methods", "qore_classes.html#memberNotification_methods", null ],
        [ "Member Initialization", "qore_classes.html#member_initialization", null ]
      ] ],
      [ "Object Method Calls", "qore_classes.html#object_method_calls", null ],
      [ "Class Inheritance", "qore_classes.html#inheritance", [
        [ "Private Inheritance", "qore_classes.html#private_inheritance", null ],
        [ "Public Inheritance", "qore_classes.html#public_inheritance", null ]
      ] ]
    ] ],
    [ "Hashdecl: Type-Safe Hash Declarations", "hashdecl.html", [
      [ "Type-Safe Hashes Overview", "hashdecl.html#hashdecl_overview", null ],
      [ "hashdecl Declaration Syntax", "hashdecl.html#hashdecl_syntax", null ],
      [ "Type-Safe Hash Creation", "hashdecl.html#hashdecl_creation", null ],
      [ "Type-Safe Hash Type Compatibility", "hashdecl.html#hashdecl_type_compatibility", null ],
      [ "Comparison of Type-Safe Hashes and Objects", "hashdecl.html#hashdecl_object_comparison", null ]
    ] ],
    [ "Threading", "threading.html", [
      [ "Creating and Terminating Threads", "threading.html#creating_and_terminating_threads", null ],
      [ "Threading and Variables", "threading.html#threading_and_variables", null ],
      [ "Thread Management and Inter-Thread Communication", "threading.html#thread_synchronization", null ],
      [ "Thread Resources", "threading.html#thread_resources", null ],
      [ "Deadlocks", "threading.html#deadlocks", null ]
    ] ],
    [ "Exception Handling", "exception_handling.html", null ],
    [ "Signal Handling", "signal_handling.html", null ],
    [ "I/O Event Handling", "event_handling.html", [
      [ "EVENT_PACKET_READ", "event_handling.html#EVENT_PACKET_READ", null ],
      [ "EVENT_PACKET_SENT", "event_handling.html#EVENT_PACKET_SENT", null ],
      [ "EVENT_HTTP_CONTENT_LENGTH", "event_handling.html#EVENT_HTTP_CONTENT_LENGTH", null ],
      [ "EVENT_HTTP_CHUNKED_START", "event_handling.html#EVENT_HTTP_CHUNKED_START", null ],
      [ "EVENT_HTTP_CHUNKED_END", "event_handling.html#EVENT_HTTP_CHUNKED_END", null ],
      [ "EVENT_HTTP_REDIRECT", "event_handling.html#EVENT_HTTP_REDIRECT", null ],
      [ "EVENT_CHANNEL_CLOSED", "event_handling.html#EVENT_CHANNEL_CLOSED", null ],
      [ "EVENT_DELETED", "event_handling.html#EVENT_DELETED", null ],
      [ "EVENT_FTP_SEND_MESSAGE", "event_handling.html#EVENT_FTP_SEND_MESSAGE", null ],
      [ "EVENT_FTP_MESSAGE_RECEIVED", "event_handling.html#EVENT_FTP_MESSAGE_RECEIVED", null ],
      [ "EVENT_HOSTNAME_LOOKUP", "event_handling.html#EVENT_HOSTNAME_LOOKUP", null ],
      [ "EVENT_HOSTNAME_RESOLVED", "event_handling.html#EVENT_HOSTNAME_RESOLVED", null ],
      [ "EVENT_HTTP_SEND_MESSAGE", "event_handling.html#EVENT_HTTP_SEND_MESSAGE", null ],
      [ "EVENT_HTTP_MESSAGE_RECEIVED", "event_handling.html#EVENT_HTTP_MESSAGE_RECEIVED", null ],
      [ "EVENT_HTTP_FOOTERS_RECEIVED", "event_handling.html#EVENT_HTTP_FOOTERS_RECEIVED", null ],
      [ "EVENT_HTTP_CHUNKED_DATA_RECEIVED", "event_handling.html#EVENT_HTTP_CHUNKED_DATA_RECEIVED", null ],
      [ "EVENT_HTTP_CHUNK_SIZE", "event_handling.html#EVENT_HTTP_CHUNK_SIZE", null ],
      [ "EVENT_CONNECTING", "event_handling.html#EVENT_CONNECTING", null ],
      [ "EVENT_CONNECTED", "event_handling.html#EVENT_CONNECTED", null ],
      [ "EVENT_START_SSL", "event_handling.html#EVENT_START_SSL", null ],
      [ "EVENT_SSL_ESTABLISHED", "event_handling.html#EVENT_SSL_ESTABLISHED", null ],
      [ "EVENT_OPEN_FILE", "event_handling.html#EVENT_OPEN_FILE", null ],
      [ "EVENT_FILE_OPENED", "event_handling.html#EVENT_FILE_OPENED", null ],
      [ "EVENT_DATA_READ", "event_handling.html#EVENT_DATA_READ", null ],
      [ "EVENT_DATA_WRITTEN", "event_handling.html#EVENT_DATA_WRITTEN", null ],
      [ "EVENT_HTTP_CHUNKED_DATA_READ", "event_handling.html#EVENT_HTTP_CHUNKED_DATA_READ", null ],
      [ "EVENT_HTTP_CHUNKED_DATA_SENT", "event_handling.html#EVENT_HTTP_CHUNKED_DATA_SENT", null ],
      [ "EVENT_HTTP_CHUNKED_FOOTERS_SENT", "event_handling.html#EVENT_HTTP_CHUNKED_FOOTERS_SENT", null ],
      [ "EVENT_SOCKET_DATA_READ", "event_handling.html#EVENT_SOCKET_DATA_READ", null ],
      [ "EVENT_SOCKET_DATA_SENT", "event_handling.html#EVENT_SOCKET_DATA_SENT", null ],
      [ "EVENT_HTTP_HEADERS_READ", "event_handling.html#EVENT_HTTP_HEADERS_READ", null ]
    ] ],
    [ "qore Executable Command-Line Processing", "command_line_processing.html", null ],
    [ "Parse Directives", "parse_directives.html", [
      [ "%allow-bare-refs", "parse_directives.html#allow-bare-refs", null ],
      [ "%allow-debugger", "parse_directives.html#allow-debugger", null ],
      [ "%allow-injection", "parse_directives.html#allow-injection", null ],
      [ "%allow-returns", "parse_directives.html#allow-returns", null ],
      [ "%allow-weak-references", "parse_directives.html#allow-weak-references", null ],
      [ "%append-include-path", "parse_directives.html#append-include-path", null ],
      [ "%append-module-path", "parse_directives.html#append-module-path", null ],
      [ "%assume-global", "parse_directives.html#assume-global", null ],
      [ "%assume-local", "parse_directives.html#assume-local", null ],
      [ "%broken-cast", "parse_directives.html#broken-cast", null ],
      [ "%broken-int-assignments", "parse_directives.html#broken-int-assignments", null ],
      [ "%broken-list-parsing", "parse_directives.html#broken-list-parsing", null ],
      [ "%broken-logic-precedence", "parse_directives.html#broken-logic-precedence", null ],
      [ "%broken-loop-statement", "parse_directives.html#broken-loop-statement", null ],
      [ "%broken-operators", "parse_directives.html#broken-operators", null ],
      [ "%broken-range", "parse_directives.html#broken-range", null ],
      [ "%broken-references", "parse_directives.html#broken-references", null ],
      [ "%broken-sprintf", "parse_directives.html#broken-sprintf", null ],
      [ "%correct-cast", "parse_directives.html#correct-cast", null ],
      [ "%correct-int-assignments", "parse_directives.html#correct-int-assignments", null ],
      [ "%correct-list-parsing", "parse_directives.html#correct-list-parsing", null ],
      [ "%correct-logic-precedence", "parse_directives.html#correct-logic-precedence", null ],
      [ "%correct-loop-statement", "parse_directives.html#correct-loop-statement", null ],
      [ "%correct-operators", "parse_directives.html#correct-operators", null ],
      [ "%correct-range", "parse_directives.html#correct-range", null ],
      [ "%correct-references", "parse_directives.html#correct-references", null ],
      [ "%correct-sprintf", "parse_directives.html#correct-sprintf", null ],
      [ "%define", "parse_directives.html#define", null ],
      [ "%disable-all-warnings", "parse_directives.html#disable-all-warnings", null ],
      [ "%disable-warning", "parse_directives.html#disable-warning", null ],
      [ "%else", "parse_directives.html#else", null ],
      [ "%enable-all-warnings", "parse_directives.html#enable-all-warnings", null ],
      [ "%enable-warning", "parse_directives.html#enable-warning", null ],
      [ "%endif", "parse_directives.html#endif", null ],
      [ "%endtry", "parse_directives.html#endtry", null ],
      [ "%exec-class", "parse_directives.html#exec-class", null ],
      [ "%ifdef", "parse_directives.html#ifdef", null ],
      [ "%ifndef", "parse_directives.html#ifndef", null ],
      [ "%include", "parse_directives.html#include", null ],
      [ "%lockdown", "parse_directives.html#lockdown", null ],
      [ "%lock-options", "parse_directives.html#lock-options", null ],
      [ "%lock-warnings", "parse_directives.html#lock-warnings", null ],
      [ "%loose-args", "parse_directives.html#loose-args", null ],
      [ "%loose-types", "parse_directives.html#loose-types", null ],
      [ "%new-style", "parse_directives.html#new-style", null ],
      [ "%old-style", "parse_directives.html#old-style", null ],
      [ "%no-debugging", "parse_directives.html#no-debugging", null ],
      [ "%no-child-restrictions", "parse_directives.html#no-child-restrictions", null ],
      [ "%no-class-defs", "parse_directives.html#no-class-defs", null ],
      [ "%no-constant-defs", "parse_directives.html#no-constant-defs", null ],
      [ "%no-database", "parse_directives.html#no-database", null ],
      [ "%no-external-access", "parse_directives.html#no-external-access", null ],
      [ "%no-external-info", "parse_directives.html#no-external-info", null ],
      [ "%no-external-process", "parse_directives.html#no-external-process", null ],
      [ "%no-filesystem", "parse_directives.html#no-filesystem", null ],
      [ "%no-global-vars", "parse_directives.html#no-global-vars", null ],
      [ "%no-gui", "parse_directives.html#no-gui", null ],
      [ "%no-io", "parse_directives.html#no-io", null ],
      [ "%no-locale-control", "parse_directives.html#no-locale-control", null ],
      [ "%no-modules", "parse_directives.html#no-modules", null ],
      [ "%no-namespace-defs", "parse_directives.html#no-namespace-defs", null ],
      [ "%no-network", "parse_directives.html#no-network", null ],
      [ "%no-new", "parse_directives.html#no-new", null ],
      [ "%no-process-control", "parse_directives.html#no-process-control", null ],
      [ "%no-reflection", "parse_directives.html#no-reflection", null ],
      [ "%no-subroutine-defs", "parse_directives.html#no-subroutine-defs", null ],
      [ "%no-terminal-io", "parse_directives.html#no-terminal-io", null ],
      [ "%no-thread-classes", "parse_directives.html#no-thread-classes", null ],
      [ "%no-thread-control", "parse_directives.html#no-thread-control", null ],
      [ "%no-thread-info", "parse_directives.html#no-thread-info", null ],
      [ "%no-threads", "parse_directives.html#no-threads", null ],
      [ "%no-top-level", "parse_directives.html#no-top-level", null ],
      [ "%no-transient", "parse_directives.html#no-transient", null ],
      [ "%no-uncontrolled-apis", "parse_directives.html#no-uncontrolled-apis", null ],
      [ "%perl-bool-eval", "parse_directives.html#perl-bool-eval", null ],
      [ "%push-parse-options", "parse_directives.html#push-parse-options", null ],
      [ "%require-dollar", "parse_directives.html#require-dollar", null ],
      [ "%require-our", "parse_directives.html#require-our", null ],
      [ "%require-prototypes", "parse_directives.html#require-prototypes", null ],
      [ "%require-types", "parse_directives.html#require-types", null ],
      [ "%requires", "parse_directives.html#requires", null ],
      [ "%set-time-zone", "parse_directives.html#set-time-zone", null ],
      [ "%strict-args", "parse_directives.html#strict-args", null ],
      [ "%strict-bool-eval", "parse_directives.html#strict-bool-eval", null ],
      [ "%strict-types", "parse_directives.html#strict-types", null ],
      [ "%strong-encapsulation", "parse_directives.html#strong-encapsulation", null ],
      [ "%try-module", "parse_directives.html#try-module", null ],
      [ "%try-reexport-module", "parse_directives.html#try-reexport-module", null ]
    ] ],
    [ "Warnings", "warnings.html", [
      [ "broken-logic-precedence", "warnings.html#warning-broken-logic-precedence", null ],
      [ "call-with-type-errors", "warnings.html#call-with-type-errors", null ],
      [ "deprecated", "warnings.html#deprecated-warning", null ],
      [ "duplicate-block-vars", "warnings.html#duplicate-block-vars", null ],
      [ "duplicate-global-vars", "warnings.html#duplicate-global-vars", null ],
      [ "duplicate-hash-key", "warnings.html#duplicate-hash-key", null ],
      [ "duplicate-local-vars", "warnings.html#duplicate-local-vars", null ],
      [ "excess-args", "warnings.html#excess-args", null ],
      [ "invalid-catch", "warnings.html#invalid-catch", null ],
      [ "invalid-operation", "warnings.html#invalid-operation", null ],
      [ "module-only", "warnings.html#module-only", null ],
      [ "non-existent-method-call", "warnings.html#non-existent-method-call", null ],
      [ "return-value-ignored", "warnings.html#return-value-ignored", null ],
      [ "undeclared-var", "warnings.html#undeclared-var", null ],
      [ "unknown-warning", "warnings.html#unknown-warning", null ],
      [ "unreachable-code", "warnings.html#unreachable-code", null ],
      [ "unreferenced-variable", "warnings.html#unreferenced-variable", null ],
      [ "warning-mask-unchanged", "warnings.html#warning-mask-unchanged", null ]
    ] ],
    [ "Keywords", "keywords.html", null ],
    [ "Release Notes", "release_notes.html", [
      [ "Qore 1.11.0", "release_notes.html#qore_1_11_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_11_0_new_features", null ]
      ] ],
      [ "Qore 1.10.0", "release_notes.html#qore_1_10_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_10_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_10_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.9.1", "release_notes.html#qore_1_9_1", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_9_1_bug_fixes", null ]
      ] ],
      [ "Qore 1.9.0", "release_notes.html#qore_1_9_0", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_9_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.8.1", "release_notes.html#qore_1_8_1", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_8_1_bug_fixes", null ]
      ] ],
      [ "Qore 1.8.0", "release_notes.html#qore_1_8_0", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_8_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.7.2", "release_notes.html#qore_1_7_2", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_7_2_bug_fixes", null ]
      ] ],
      [ "Qore 1.7.1", "release_notes.html#qore_1_7_1", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_7_1_bug_fixes", null ]
      ] ],
      [ "Qore 1.7.0", "release_notes.html#qore_1_7_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_7_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_7_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.6.0", "release_notes.html#qore_1_6_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_6_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_6_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.5.1", "release_notes.html#qore_1_5_1", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_5_1_bug_fixes", null ]
      ] ],
      [ "Qore 1.5.0", "release_notes.html#qore_1_5_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_5_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_5_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.4.0", "release_notes.html#qore_1_4_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_4_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_4_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.3.0", "release_notes.html#qore_1_3_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_3_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_3_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.2.0", "release_notes.html#qore_1_2_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_2_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_2_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.1.0", "release_notes.html#qore_1_1_0", [
        [ "New Features in Qore", "release_notes.html#qore_1_1_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_1_0_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.13", "release_notes.html#qore_1_0_13", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_13_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.12", "release_notes.html#qore_1_0_12", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_12_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.11", "release_notes.html#qore_1_0_11", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_11_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.10", "release_notes.html#qore_1_0_10", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_10_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.9", "release_notes.html#qore_1_0_9", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_9_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.8", "release_notes.html#qore_1_0_8", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_8_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.7", "release_notes.html#qore_1_0_7", [
        [ "New Features", "release_notes.html#qore_1_0_7_new_feature", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_7_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.6", "release_notes.html#qore_1_0_6", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_6_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.5", "release_notes.html#qore_1_0_5", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_5_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.4", "release_notes.html#qore_1_0_4", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_4_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.3", "release_notes.html#qore_1_0_3", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_3_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.2", "release_notes.html#qore_1_0_2", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_2_bug_fixes", null ]
      ] ],
      [ "Qore 1.0.1", "release_notes.html#qore_1_0_1", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_1_bug_fixes", null ]
      ] ],
      [ "Qore 1.0", "release_notes.html#qore_1_0", [
        [ "Fixes That Can Affect Backwards-Compatibility", "release_notes.html#qore_1_0_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_1_0_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_1_0_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.15", "release_notes.html#qore_0915", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0915_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.14", "release_notes.html#qore_0914", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0914_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.13", "release_notes.html#qore_0913", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0913_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.12", "release_notes.html#qore_0912", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0912_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.11", "release_notes.html#qore_0911", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0911_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.10", "release_notes.html#qore_0910", [
        [ "New Modules in Qore", "release_notes.html#qore_0910_new_modules", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0910_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.9", "release_notes.html#qore_099", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_099_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.8", "release_notes.html#qore_098", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_098_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.7", "release_notes.html#qore_097", [
        [ "Release Notes", "release_notes.html#qore_097_notes", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_097_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.6", "release_notes.html#qore_096", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_096_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.5", "release_notes.html#qore_095", [
        [ "Fixes That Can Affect Backwards-Compatibility", "release_notes.html#qore_095_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_095_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_095_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.4.7", "release_notes.html#qore_0947", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0947_bug_fixesd", null ]
      ] ],
      [ "Qore 0.9.4.6", "release_notes.html#qore_0946", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0946_bug_fixesd", null ]
      ] ],
      [ "Qore 0.9.4.5", "release_notes.html#qore_0945", [
        [ "New Features in Qore", "release_notes.html#qore_0945_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0945_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.4.4", "release_notes.html#qore_0944", [
        [ "New Features in Qore", "release_notes.html#qore_0944_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0944_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.4.3", "release_notes.html#qore_0943", [
        [ "New Features in Qore", "release_notes.html#qore_0943_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0943_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.4.2", "release_notes.html#qore_0942", [
        [ "New Features in Qore", "release_notes.html#qore_0942_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0942_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.4.1", "release_notes.html#qore_0941", [
        [ "New Features in Qore", "release_notes.html#qore_0941_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0941_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.4", "release_notes.html#qore_094", [
        [ "Fixes That Can Affect Backwards-Compatibility", "release_notes.html#qore_094_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_094_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_094_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.3.3", "release_notes.html#qore_0933", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0933_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.3.2", "release_notes.html#qore_0932", [
        [ "New Features in Qore", "release_notes.html#qore_0932_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0932_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.3.1", "release_notes.html#qore_0931", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0931_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.3", "release_notes.html#qore_093", [
        [ "Fixes That Can Affect Backwards-Compatibility", "release_notes.html#qore_093_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_093_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_093_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.2", "release_notes.html#qore_092", [
        [ "New Features in Qore", "release_notes.html#qore_092_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_092_bug_fixes", null ]
      ] ],
      [ "Qore 0.9.1", "release_notes.html#qore_091", [
        [ "New Features in Qore", "release_notes.html#qore_091_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_091_bug_fixes", null ]
      ] ],
      [ "Qore 0.9", "release_notes.html#qore_09", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_09_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_09_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_09_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.9", "release_notes.html#qore_08139", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08139_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.8", "release_notes.html#qore_08138", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08138_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.7", "release_notes.html#qore_08137", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08137_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.6", "release_notes.html#qore_08136", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08136_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.5", "release_notes.html#qore_08135", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08135_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.4", "release_notes.html#qore_08134", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08134_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.3", "release_notes.html#qore_08133", [
        [ "New Features in Qore", "release_notes.html#qore_08133_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_08133_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.2", "release_notes.html#qore_08132", [
        [ "New Features in Qore", "release_notes.html#qore_08132_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_08132_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13.1", "release_notes.html#qore_08131", [
        [ "New Features in Qore", "release_notes.html#qore_08131_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_08131_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.13", "release_notes.html#qore_0813", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_0813_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_0813_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0813_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.12", "release_notes.html#qore_081212", [
        [ "New Features in Qore", "release_notes.html#qore_081212_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_081212_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.11", "release_notes.html#qore_081211", [
        [ "New Features in Qore", "release_notes.html#qore_081211_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_081211_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.10", "release_notes.html#qore_081210", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_081210_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.9", "release_notes.html#qore_08129", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08129_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.8", "release_notes.html#qore_08128", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08128_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.7", "release_notes.html#qore_08127", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08127_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.6", "release_notes.html#qore_08126", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08126_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.5", "release_notes.html#qore_08125", [
        [ "New Features in Qore", "release_notes.html#qore_08125_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_08125_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.4", "release_notes.html#qore_08124", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08124_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.3", "release_notes.html#qore_08123", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08123_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.2", "release_notes.html#qore_08122", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08122_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12.1", "release_notes.html#qore_08121", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_08121_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.12", "release_notes.html#qore_0812", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_0812_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_0812_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0812_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.11", "release_notes.html#qore_0811", [
        [ "New Features in Qore", "release_notes.html#qore_0811_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0811_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.10", "release_notes.html#qore_0810", [
        [ "New Features in Qore", "release_notes.html#qore_0810_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0810_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.9", "release_notes.html#qore_089", [
        [ "New Features in Qore", "release_notes.html#qore_089_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_089_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.8", "release_notes.html#qore_088", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_088_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_088_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_088_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.7", "release_notes.html#qore_087", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_087_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_087_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_087_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.6.2", "release_notes.html#qore_0862", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_0862_compatibility", null ],
        [ "Changes in Qore", "release_notes.html#qore_0862_changes", null ]
      ] ],
      [ "Qore 0.8.6.1", "release_notes.html#qore_0861", [
        [ "Changes in Qore", "release_notes.html#qore_0861_changes", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_0861_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.6", "release_notes.html#qore_086", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_086_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_086_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_086_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.5.1", "release_notes.html#qore_0851", [
        [ "Bug Fixes in Qore", "release_notes.html#qore_0851_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.5", "release_notes.html#qore_085", [
        [ "New Features in Qore", "release_notes.html#qore_085_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_085_bug_fixes", null ]
      ] ],
      [ "Qore 0.8.4", "release_notes.html#qore_084", [
        [ "Changes That Can Affect Backwards-Compatibility", "release_notes.html#qore_084_compatibility", null ],
        [ "New Features in Qore", "release_notes.html#qore_084_new_features", null ],
        [ "Bug Fixes in Qore", "release_notes.html#qore_084_bug_fixes", null ]
      ] ]
    ] ]
];