Date/time arithmetic is relatively straightforward and should normally produce the expected results. However with leap years, months with different lengths, and daylights savings time the situation can be confusing; this section will clarify how Qore does date arithmetic considering these special cases.\hypertarget{date_time_arithmetic_date_time_arithmetic_adding_years_months}{}\doxysection{Adding and Subtracting Years and Months}\label{date_time_arithmetic_date_time_arithmetic_adding_years_months}
Adding or subtracting years and months (ex\+: {\ttfamily date += 2Y + 3M}) will give you the same day on the desired month in the desired year. If the target month has fewer days than the source month, then you will get the last day of the month in that year. For example\+:

\begin{DoxyVerb}prompt% qore -X '2004-02-29Z - 1Y'
2003-02-28 00:00:00 Fri Z (UTC)\end{DoxyVerb}
\hypertarget{date_time_arithmetic_date_time_arithmetic_days}{}\doxysection{Adding and Subtracting Days}\label{date_time_arithmetic_date_time_arithmetic_days}
Adding or subtracting days means adding or subtracting 24h periods; i.\+e. you will get the same time in the result of subtracting days, for example\+:

\begin{DoxyVerb}prompt% qore -X '2004-02-29T10:15:00Z - 10D'
2004-02-19 10:15:00 Thu Z (UTC)\end{DoxyVerb}
\hypertarget{date_time_arithmetic_date_time_arithmetic_difference}{}\doxysection{Finding the Difference Between Two Dates}\label{date_time_arithmetic_date_time_arithmetic_difference}
Subtracting one \mbox{\hyperlink{basic_data_types_absolute_dates}{absolute date}} from another will result in a \mbox{\hyperlink{basic_data_types_relative_dates}{relative date}}, normalized to the hour (that is, microseconds over 999,999 are converted to seconds, seconds over 59 to minutes, and minutes over 59 to hours; days, months, and years will not appear in the result as they do not indicate a fixed period of time but rather can vary in length depending on the absolute date/time starting point. For example\+:

\begin{DoxyVerb}prompt% qore -X '2007-02-29T10:15:03.255Z - 2004-02-29T10:14:02.100Z'
<time: 26304 hours 1 minute 1 second 155 milliseconds>\end{DoxyVerb}


To find the difference in seconds between two dates, convert each date value to an integer and subtract as follows\+:

\begin{DoxyVerb}prompt% qore -X 'int(2004-02-29Z) - int(2004-02-28Z)'
86400\end{DoxyVerb}


Or use the \mbox{\hyperlink{group__date__and__time__functions_ga98ef4a4d08621926630c15c1bbd769df}{get\+\_\+duration\+\_\+seconds()}} function as follows\+:

\begin{DoxyVerb}prompt% qore -X 'get_duration_seconds(2004-02-29Z - 2004-02-28Z)'
86400\end{DoxyVerb}
\hypertarget{date_time_arithmetic_date_time_arithmetic_zones}{}\doxysection{Timezones and Daylight Savings Time}\label{date_time_arithmetic_date_time_arithmetic_zones}
Time zones and daylight savings time information is supplied by the system\textquotesingle{}s zoneinfo database (if any exists; see \mbox{\hyperlink{time_zones}{Time Zone Handling}} for more information).

To find out if the current time zone has daylight savings time, execute the following\+:

\begin{DoxyVerb}prompt% qore -X 'TimeZone::get().hasDST()'
True\end{DoxyVerb}


See the \mbox{\hyperlink{class_qore_1_1_time_zone}{Qore\+::\+Time\+Zone}} class for more information on time zone information.\hypertarget{date_time_arithmetic_date_time_arithmetic_leap_years}{}\doxysection{Leap Years and the Gregorian Calendar}\label{date_time_arithmetic_date_time_arithmetic_leap_years}
Qore is capable of representing and performing calculations on dates before the adoption of the Gregorian calendar (proposed in 1582 and adopted at various times in Europe after this point). However all calculations are made as if the Gregorian calendar were always in effect (Qore implements a \href{http://en.wikipedia.org/wiki/Proleptic_Gregorian_calendar}{\texttt{ proleptic Gregorian calendar}}). 