This section describes command-\/line processing for the {\ttfamily qore} binary; see \mbox{\hyperlink{class_qore_1_1_get_opt}{Qore\+::\+Get\+Opt}} for the class allowing for command-\/line processing in Qore code

Qore will scan the command-\/line for the options in the following table. Arguments after the script name will be passed to the script in the global {\ttfamily ARGV} variable as a list of options. {\ttfamily ARGV\mbox{[}0\mbox{]}} will be the first option and will not be the script name. If no script name is given and the {\ttfamily --exec} option is not used, then Qore code is read from standard input. The {\ttfamily QORE\+\_\+\+ARGV} variable will have the original Qore command-\/line in it, however

Usage\+: {\ttfamily qore \mbox{[}}{\itshape options}{\ttfamily \mbox{]} \mbox{[}}{\itshape script\+\_\+file\+\_\+name}{\ttfamily \mbox{]}}

{\bfseries{Parse Option Command-\/\+Line Parameters}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{3}{|X[-1]}|}
\hline
{\bfseries{Long Param}} &{\bfseries{Short}} &{\bfseries{Description}}  \\\cline{1-3}
{\ttfamily --define=}{\itshape arg} &{\ttfamily -\/D}  &Creates and optionally sets a value for a parse define  \\\cline{1-3}
{\ttfamily --load=}{\itshape arg} &{\ttfamily -\/l}  &Loads a module immediately. The argument can be a module/feature name or an absolute path to the module  \\\cline{1-3}
{\ttfamily --no-\/global-\/vars} &{\ttfamily -\/G}  &Disallows the use of global variables. Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga00fcb14e17ebe9073cc0b768c276cf64}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+GLOBAL\+\_\+\+VARS}} and the \mbox{\hyperlink{parse_directives_no-global-vars}{\%no-\/global-\/vars}} directive  \\\cline{1-3}
{\ttfamily --no-\/subroutine-\/defs} &{\ttfamily -\/S}  &Disallows subroutine (function) definitions. Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga750cc2b2d325184242990c6ab60ea736}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+SUBROUTINE\+\_\+\+DEFS}} and the \mbox{\hyperlink{parse_directives_no-subroutine-defs}{\%no-\/subroutine-\/defs}} directive  \\\cline{1-3}
{\ttfamily --no-\/thread-\/control} &{\ttfamily -\/R}  &Disallows any thread control operations (\mbox{\hyperlink{operators_background}{background operator}} and \mbox{\hyperlink{statements_thread_exit}{thread\+\_\+exit statement}}, for example). Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga16d8c2b85171b6673b60b5f7d0eaf5eb}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CONTROL}} and the \mbox{\hyperlink{parse_directives_no-thread-control}{\%no-\/thread-\/control}} directive  \\\cline{1-3}
{\ttfamily --no-\/thread-\/classes} &n/a &Disallows access to thread classes (for example, the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} class, \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} class, \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} class, etc). Equivalent to parse option \mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}} and the \mbox{\hyperlink{parse_directives_no-thread-classes}{\%no-\/thread-\/classes}} directive  \\\cline{1-3}
{\ttfamily --no-\/threads} &{\ttfamily -\/T}  &Disallows access to both thread control and thread classes (equivalent to the {\ttfamily --no-\/thread-\/control} and {\ttfamily --no-\/thread-\/classes} options documented above). Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga76f3b2a173e5f06aec64ea04fc1ed515}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREADS}} and the \mbox{\hyperlink{parse_directives_no-threads}{\%no-\/threads}} directive  \\\cline{1-3}
{\ttfamily --no-\/top-\/level} &{\ttfamily -\/L}  &Disallows top level code. Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga3a99f2973e97f3986630d8204d7b91fd}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+TOP\+\_\+\+LEVEL\+\_\+\+STATEMENTS}} and the \mbox{\hyperlink{parse_directives_no-top-level}{\%no-\/top-\/level}} directive  \\\cline{1-3}
{\ttfamily --no-\/class-\/defs} &n/a &Disallows class definitions. Equivalent to \mbox{\hyperlink{group__parse__options_ga969ab84c1a550482cbc6d24e878172e9}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+CLASS\+\_\+\+DEFS}} and the \mbox{\hyperlink{parse_directives_no-class-defs}{\%no-\/class-\/defs}} directive  \\\cline{1-3}
{\ttfamily --no-\/namespace-\/defs} &n/a &Disallows new namespace definitions. Equivalent to \mbox{\hyperlink{group__parse__options_gaa5aaa3b96f4662b3c49bed1d1ab8ec88}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+NAMESPACE\+\_\+\+DEFS}} and the \mbox{\hyperlink{parse_directives_no-namespace-defs}{\%no-\/namespace-\/defs}} directive  \\\cline{1-3}
{\ttfamily --no-\/external-\/process} &{\ttfamily -\/E}  &Disallows any access to external processes (with system(), \mbox{\hyperlink{group__misc__functions_gaee11d366f841cd34c9aa6ac8c7c49577}{backquote()}}, exec(), the \mbox{\hyperlink{operators_backquote_operator}{backquote operator}}, etc). Equivalent to parse option \mbox{\hyperlink{group__parse__options_gaab2d8faa88f066837e100152187e6368}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+EXTERNAL\+\_\+\+PROCESS}} and the \mbox{\hyperlink{parse_directives_no-external-process}{\%no-\/external-\/process}} directive  \\\cline{1-3}
{\ttfamily --no-\/process-\/control} &{\ttfamily -\/P}  &Disallows access to functions that would affect the current process (exit(), fork(), etc). Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga10d8e3f76c427b0f974529de572dd0ec}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+PROCESS\+\_\+\+CONTROL}} and the \mbox{\hyperlink{parse_directives_no-process-control}{\%no-\/process-\/control}} directive  \\\cline{1-3}
{\ttfamily --no-\/filesystem} &{\ttfamily -\/F}  &Disallows access to the local filesystem; puts the \mbox{\hyperlink{parse_directives_no-filesystem}{\%no-\/filesystem}} parse option in effect. Equivalent to parse option code \mbox{\hyperlink{group__parse__options_ga5e466ed886222f0b57b0a399b455be71}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+FILESYSTEM}} and the \mbox{\hyperlink{parse_directives_no-filesystem}{\%no-\/filesystem}} parse directive  \\\cline{1-3}
{\ttfamily --no-\/constant-\/defs} &n/a &Disallows constant definitions. Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga50a8caec03edae3600565a456c1f9c7e}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+CONSTANT\+\_\+\+DEFS}} and the \mbox{\hyperlink{parse_directives_no-constant-defs}{\%no-\/constant-\/defs}} directive  \\\cline{1-3}
{\ttfamily --no-\/network} &{\ttfamily -\/Y}  &Disallows access to the network; puts the \mbox{\hyperlink{parse_directives_no-network}{\%no-\/network}} parse option in effect. Equivalent to parse option code \mbox{\hyperlink{group__parse__options_ga20400e83c6271a294a48b15a8f952efa}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+NETWORK}} and the \mbox{\hyperlink{parse_directives_no-network}{\%no-\/network}} parse directive  \\\cline{1-3}
{\ttfamily --no-\/new} &{\ttfamily -\/N}  &Disallows use of the \mbox{\hyperlink{operators_new}{new operator}}. Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga9736251c76726706da64426d899b4033}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+NEW}} and the \mbox{\hyperlink{parse_directives_no-new}{\%no-\/new}} directive  \\\cline{1-3}
{\ttfamily --no-\/database} &{\ttfamily -\/D}  &Disallows use of database functionality. Equivalent to parse option \mbox{\hyperlink{group__parse__options_gac496a9d9bcf9d5c626c8c267c73a83bc}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+DATABASE}} and the \mbox{\hyperlink{parse_directives_no-database}{\%no-\/database}} directive  \\\cline{1-3}
{\ttfamily --no-\/child-\/restrictions} &{\ttfamily -\/I}  &Allows child program objects to have parse option restrictions that are not a strict subset of the parents. Equivalent to parse option \mbox{\hyperlink{group__parse__options_gaa567ec1170360b9ca111402c5179109f}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+CHILD\+\_\+\+PO\+\_\+\+RESTRICTIONS}} and the \mbox{\hyperlink{parse_directives_no-child-restrictions}{\%no-\/child-\/restrictions}} directive  \\\cline{1-3}
{\ttfamily --require-\/our} &{\ttfamily -\/O}  &Requires global variables to be declared with our prior to use (similar to perl\textquotesingle{}s {\ttfamily use strict vars} pragma). Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga77d54a192aeae13bac95700ab5bbb190}{Qore\+::\+PO\+\_\+\+REQUIRE\+\_\+\+OUR}} and the \mbox{\hyperlink{parse_directives_require-our}{\%require-\/our}} directive  \\\cline{1-3}
{\ttfamily --lock-\/options} &{\ttfamily -\/K}  &Prohibits further changes to parse options (equivalent to the \mbox{\hyperlink{parse_directives_lock-options}{\%lock-\/options}} directive)  \\\cline{1-3}
{\ttfamily --lock-\/warnings} &{\ttfamily -\/A}  &Prohibits further changes to the warning mask. Equivalent to parse option \mbox{\hyperlink{group__parse__options_ga1d039ccd02b93ddb1d5c8a7c1470167b}{Qore\+::\+PO\+\_\+\+LOCK\+\_\+\+WARNINGS}} and the \mbox{\hyperlink{parse_directives_lock-warnings}{\%lock-\/warnings}} directive  \\\cline{1-3}
{\ttfamily --enable-\/all-\/warnings} &{\ttfamily -\/W}  &Enables all \mbox{\hyperlink{warnings}{warnings}}. Equivalent to the \mbox{\hyperlink{parse_directives_enable-all-warnings}{\%enable-\/all-\/warnings}} directive  \\\cline{1-3}
{\ttfamily --enable-\/warning=}{\itshape arg} &{\ttfamily -\/w}  &Enables the named \mbox{\hyperlink{warnings}{warning}}. Equivalent to the \mbox{\hyperlink{parse_directives_enable-warning}{\%enable-\/warning}} directive  \\\cline{1-3}
{\ttfamily --list-\/warnings} &{\ttfamily -\/i}  &Lists all valid \mbox{\hyperlink{warnings}{warnings}} in Qore and exits immediately  \\\cline{1-3}
\end{longtabu}


{\bfseries{Miscellaneous Command-\/\+Line Parameters}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{3}{|X[-1]}|}
\hline
{\bfseries{Long Param}} &{\bfseries{Short}} &{\bfseries{Description}}  \\\cline{1-3}
{\ttfamily --disable-\/gc} &{\ttfamily -\/g}  &Disables the garbage collector  \\\cline{1-3}
{\ttfamily --exec=}{\itshape arg} &{\ttfamily -\/e}  &parses and executes the argument text as a Qore program. If this option is specified then any script given on the command-\/line will be ignored  \\\cline{1-3}
{\ttfamily --exec-\/class\mbox{[}=}{\itshape arg}{\ttfamily \mbox{]}} &{\ttfamily -\/x}  &instantiates the class with the same name as the program (with the directory path and extension stripped); also turns on --no-\/top-\/level. If the program is read from {\ttfamily stdin} or from the command line, an argument must be given specifying the class name  \\\cline{1-3}
{\ttfamily --show-\/module-\/errors} &{\ttfamily -\/m}  &Shows any errors loading Qore modules  \\\cline{1-3}
{\ttfamily --charset=}{\itshape arg} &{\ttfamily -\/c}  &Sets the \mbox{\hyperlink{character_encoding_default_encoding}{default character encoding}} for the program  \\\cline{1-3}
{\ttfamily --show-\/charset=}{\itshape arg} &{\ttfamily -\/s}  &Shows a list of all known \mbox{\hyperlink{character_encoding}{character encodings}}  \\\cline{1-3}
{\ttfamily --show-\/aliases} &{\ttfamily -\/a}  &Shows a list of all known \mbox{\hyperlink{character_encoding}{character encoding}} aliases  \\\cline{1-3}
{\ttfamily --help} &{\ttfamily -\/h}  &Shows help text  \\\cline{1-3}
{\ttfamily --version} &{\ttfamily -\/v}  &Shows Qore library version information and exits  \\\cline{1-3}
\end{longtabu}


There are two additional options available with debugging versions of Qore as follows\+:

{\bfseries{Description of Debugging Command-\/\+Line Parameters}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{3}{|X[-1]}|}
\hline
{\bfseries{Long Param}} &{\bfseries{Short}} &{\bfseries{Description}}  \\\cline{1-3}
{\ttfamily --debug=}{\itshape arg} &{\ttfamily -\/d}  &Turns on Qore debugging output (output to {\ttfamily stderr}). Higher arg numbers give more output. This option is only available with DEBUG builds  \\\cline{1-3}
{\ttfamily --trace} &{\ttfamily -\/t}  &Turns on Qore tracing (output to {\ttfamily stderr}). This option is only available with DEBUG builds  \\\cline{1-3}
\end{longtabu}
