\hypertarget{class_qore_1_1zzz8stringzzz9}{}\doxysection{Qore\+::zzz8stringzzz9 Class Reference}
\label{class_qore_1_1zzz8stringzzz9}\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}}


Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_string}{strings}}.  




Inheritance diagram for Qore\+::zzz8stringzzz9\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_aabf1bb32b32060ffc6a68164157d86aa}{compare\+Partial}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} ostr)
\begin{DoxyCompactList}\small\item\em Compares the beginning of the current string with a shorter string passed as an argument, returns -\/1, 0, or 1 if the argument string is less than, equal, or greater than the beginning of the current string; returns also -\/1 if the argument string is equal to the beginning of the current string but the argument string is longer than the current string. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a6966cdf9ca898c2a2a6788149e6deeae}{empty}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a5a6d55ea5951eb254eb8c8a1d895937b}{encoding}} ()
\begin{DoxyCompactList}\small\item\em Returns the name of the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a215bc851affd3a2a57b80cefc484f139}{equal\+Partial}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} ostr)
\begin{DoxyCompactList}\small\item\em Compares the beginning of the current string with a shorter string passed as an argument for equality only, returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string argument matches the beginning of the string, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a87b81daaffa46700be92e0596578b200}{equal\+Partial\+Path}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} ostr)
\begin{DoxyCompactList}\small\item\em Compares the beginning of the current string assumed to be a path with a shorter string passed as an argument for equality only, returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string argument matches the beginning of the string where either both strings are the same size or the current string has a \textquotesingle{}/\textquotesingle{} or \textquotesingle{}?\textquotesingle{} character after the point where the argument string stops, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a53392adad0eab1542d3d8bc9c91da89c}{find}} (softstring \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab5ad54b1fe38b46ee071e55563d9d245}{substr}}, softint pos=0)
\begin{DoxyCompactList}\small\item\em Retrieves the character position of a substring within a string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a07b89a849ef94f060e0fcf2c040fd296}{get\+Decoded}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} code=\mbox{\hyperlink{group___string_concat_decoding_ga9c3dabdb0c33c28a293c10d4c1d97935}{CD\+\_\+\+ALL}})
\begin{DoxyCompactList}\small\item\em returns a string based on the string value, decoded as per the {\itshape code} argument \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a4b2cac04c91fb14fcb5a79469550b820}{get\+Encoded}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} code=\mbox{\hyperlink{group___string_concat_encoding_gabdfd4734aad893296b3c584c3ba1326e}{CE\+\_\+\+XHTML}})
\begin{DoxyCompactList}\small\item\em returns a string based on the string value with encodings as per the {\itshape code} argument \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab5a4673da652f758677d729e40c1e415}{get\+Line}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} offset=0, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} eol, bool \mbox{\hyperlink{group__string__functions_gae8d314e819a299d46d181696600d4293}{trim}}=\mbox{\hyperlink{group__boolean__constants_ga3ba2df91713a6249449347131ea526c3}{True}}, \+\_\+\+\_\+7\+\_\+ reference$<$ \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{size}})
\begin{DoxyCompactList}\small\item\em returns a string for the next line in the string buffer starting at the given offset (or at the beginning if no offset is given) \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ac677323f97c583af45f7f77984462e3d}{get\+Unicode}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} offset=0)
\begin{DoxyCompactList}\small\item\em returns the Unicode code for the given character offset in the string \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ace7f5b6ac2e7b9f4886c9e153edd46d7}{intp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string can be converted to an integer, \mbox{\hyperlink{basic_data_types_False}{False}} if not, this depends on the first (or possibly second) character of the string, if it\textquotesingle{}s 0 -\/ 9 (possibly preceded by {\ttfamily \char`\"{}-\/\char`\"{}}), then the method returns \mbox{\hyperlink{basic_data_types_True}{True}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a766250b7a8d910b7facce5bef7cfe855}{is\+Data\+Ascii}} ()
\begin{DoxyCompactList}\small\item\em returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty or has no characters with the high bit set (ie all characters $<$ 128) \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ae568ad566fc87c944a64d6ce67dd3d16}{is\+Data\+Printable\+Ascii}} ()
\begin{DoxyCompactList}\small\item\em returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty or only contains printable non-\/control ASCII characters (ie all characters $>$ 31 \&\& $<$ 127) \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a555db3550ff785af51a647415e994861}{length}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of characters in the string; may not be equal to the byte length (returned by \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}{Qore\+::zzz8stringzzz9\+::strlen()}} and \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}}) for \mbox{\hyperlink{character_encoding}{multi-\/byte character encodings}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ae2329c573986ede4a54e70e9ccef30e2}{lwr}} ()
\begin{DoxyCompactList}\small\item\em Returns the string in lower case. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a4713c0132472cf5cf6599ad9517cdc5f}{regex}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} regex, \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} options=0)
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the regular expression matches the string passed, otherwise returns \mbox{\hyperlink{basic_data_types_False}{False}}. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ $\ast$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_aeaf99b23a4de2db748a1fe0bbc3811f5}{regex\+Extract}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a4713c0132472cf5cf6599ad9517cdc5f}{regex}}, \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} options=0)
\begin{DoxyCompactList}\small\item\em Returns a list of substrings in a string based on matching patterns defined by a regular expression. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_af2463dc9c06ba8318b7030f040cfa85d}{rfind}} (softstring \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab5ad54b1fe38b46ee071e55563d9d245}{substr}}, softint pos=-\/1)
\begin{DoxyCompactList}\small\item\em Retrieves the character position of a substring within a string, starting the search from the end of the string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{size}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of bytes in the string (not including the terminating null character ({\ttfamily \textquotesingle{}\textbackslash{}0\textquotesingle{}}) \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ac2af75dc65846c076c28fa73aee57455}{sizep}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} since strings can return a non-\/zero size. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_afe181b134b4aff3851e3dcb02b9cf7c4}{split}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sep, bool with\+\_\+separator=\mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}})
\begin{DoxyCompactList}\small\item\em Splits a string into a list of components based on a separator string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a34c43c49f859529054ef495eb395e6bb}{split}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sep, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} quote, bool trim\+\_\+unquoted=\mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}})
\begin{DoxyCompactList}\small\item\em Splits a string into a list of components based on a separator string and a quote character. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ac3b18663a7d3d58cbb200ca54030d1cd}{split\+Regex}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} regex\+\_\+sep, \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} options=0, bool with\+\_\+separator=\mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}})
\begin{DoxyCompactList}\small\item\em Splits a string into a list of components based on a separator regular expression. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ae2e9caa782d4ffec7140e208c2717a1c}{split\+Regex}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} regex\+\_\+sep, bool with\+\_\+separator=\mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}})
\begin{DoxyCompactList}\small\item\em Splits a string into a list of components based on a separator regular expression. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}{strlen}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of bytes in the string (not including the terminating null character ({\ttfamily \textquotesingle{}\textbackslash{}0\textquotesingle{}}) \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a776bb273fbcba12c8ff3f1a6a77d728b}{strp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} by default. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab5ad54b1fe38b46ee071e55563d9d245}{substr}} (softint start)
\begin{DoxyCompactList}\small\item\em Returns a portion of a string starting from an integer offset. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_aaa1c011bda61406af681da3d12bb57c3}{substr}} (softint start, softint len)
\begin{DoxyCompactList}\small\item\em Returns a portion of a string starting from an integer offset, with a length parameter. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a13b13f9681a94272d0e16371d2f22d90}{to\+Base64}} (softint maxlinelen=-\/1)
\begin{DoxyCompactList}\small\item\em Returns the base64-\/encoded representation of the string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a825e0531419ae8abce66288e9d5ea4b1}{to\+Binary}} ()
\begin{DoxyCompactList}\small\item\em Returns a binary value with the string\textquotesingle{}s data. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_af4a4f62237f079383098441132967527}{to\+Hex}} ()
\begin{DoxyCompactList}\small\item\em returns a string of hexadecimal digits corresponding to the contents of the string \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ae5fc7b01d0469fc2a015a0f6f3b0ae26}{to\+Int}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} base=10)
\begin{DoxyCompactList}\small\item\em Converts the string to an integer value with respect to the {\bfseries{base}} \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2c63e2b65aafebf67928b88651d4cd39}{to\+MD5}} ()
\begin{DoxyCompactList}\small\item\em Returns the \href{http://en.wikipedia.org/wiki/MD5}{\texttt{ MD5 message digest}} of the string as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a577cc1e9e6cb2f001c36f35a4cff4b74}{to\+SHA1}} ()
\begin{DoxyCompactList}\small\item\em Returns the \href{http://en.wikipedia.org/wiki/SHA-1}{\texttt{ SHA1}} message digest of the string as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a3341bfb07348577260ece5244f958caf}{to\+SHA224}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/224 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a11a362bbdba504966590d68bc6839350}{to\+SHA256}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/256 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ae572499e8fe84e24455806ba2556e5c5}{to\+SHA384}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/384 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a0a8b0fd0c6dc97af23ad50be3125cb4d}{to\+SHA512}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/512 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a4a3e3f0f6d983caea261935b2d3424f1}{type\+Code}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{group__type__code__constants_ga86a3586f63bf9793e0cdb13f5e1f5db4}{Qore\+::\+NT\+\_\+\+STRING}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a227ef4978fde1a808f14bc7ead59eb2e}{unaccent}} ()
\begin{DoxyCompactList}\small\item\em Returns a string with all accented characters removed. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a0b5c301c6742fccb8645968845b00fc1}{upr}} ()
\begin{DoxyCompactList}\small\item\em Returns the string in upper case. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a6b280ef6ed27ec08d444123d6fecb38b}{val}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the string is empty, \mbox{\hyperlink{basic_data_types_True}{True}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bed0246b3ce9aebf17d5d2ee29d51f3}{width}} ()
\begin{DoxyCompactList}\small\item\em Returns the width of characters in the string; some unicode characters take up multiple spaces on output. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_string}{strings}}. 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_aabf1bb32b32060ffc6a68164157d86aa}\label{class_qore_1_1zzz8stringzzz9_aabf1bb32b32060ffc6a68164157d86aa}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!comparePartial@{comparePartial}}
\index{comparePartial@{comparePartial}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{comparePartial()}{comparePartial()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::compare\+Partial (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{ostr }\end{DoxyParamCaption})}



Compares the beginning of the current string with a shorter string passed as an argument, returns -\/1, 0, or 1 if the argument string is less than, equal, or greater than the beginning of the current string; returns also -\/1 if the argument string is equal to the beginning of the current string but the argument string is longer than the current string. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = str.comparePartial(ostr);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em ostr} & the partial string to compare the current string to\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
-\/1, 0, or 1 if the argument string is less than, equal, or greater than the beginning of the current string; returns also -\/1 if the argument string is equal to the beginning of the current string but the argument string is longer than the current string
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a6966cdf9ca898c2a2a6788149e6deeae}\label{class_qore_1_1zzz8stringzzz9_a6966cdf9ca898c2a2a6788149e6deeae}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!empty@{empty}}
\index{empty@{empty}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{empty()}{empty()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::empty (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

The opposite of \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a6b280ef6ed27ec08d444123d6fecb38b}{Qore\+::zzz8stringzzz9\+::val()}}

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = str.empty();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a5a6d55ea5951eb254eb8c8a1d895937b}\label{class_qore_1_1zzz8stringzzz9_a5a6d55ea5951eb254eb8c8a1d895937b}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!encoding@{encoding}}
\index{encoding@{encoding}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{encoding()}{encoding()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::encoding (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the name of the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}. 

\begin{DoxyReturn}{Returns}
the name of the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string enc = str.encoding();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_gac4a81651e374644e697e3ce61c373694}{Qore\+::get\+\_\+encoding(string)}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a215bc851affd3a2a57b80cefc484f139}\label{class_qore_1_1zzz8stringzzz9_a215bc851affd3a2a57b80cefc484f139}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!equalPartial@{equalPartial}}
\index{equalPartial@{equalPartial}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{equalPartial()}{equalPartial()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::equal\+Partial (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{ostr }\end{DoxyParamCaption})}



Compares the beginning of the current string with a shorter string passed as an argument for equality only, returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string argument matches the beginning of the string, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = str.equalPartial(ostr);}

\end{DoxyCode}

\end{DoxyParagraph}
This pseudo-\/method is slightly faster than \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_aabf1bb32b32060ffc6a68164157d86aa}{compare\+Partial()}} since the length of the substring can be used to determine if the strings can match or not.


\begin{DoxyParams}{Parameters}
{\em ostr} & the partial string to compare the current string to\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the string argument matches the beginning of the string, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a87b81daaffa46700be92e0596578b200}\label{class_qore_1_1zzz8stringzzz9_a87b81daaffa46700be92e0596578b200}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!equalPartialPath@{equalPartialPath}}
\index{equalPartialPath@{equalPartialPath}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{equalPartialPath()}{equalPartialPath()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::equal\+Partial\+Path (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{ostr }\end{DoxyParamCaption})}



Compares the beginning of the current string assumed to be a path with a shorter string passed as an argument for equality only, returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string argument matches the beginning of the string where either both strings are the same size or the current string has a \textquotesingle{}/\textquotesingle{} or \textquotesingle{}?\textquotesingle{} character after the point where the argument string stops, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = str.equalPartialPath(ostr);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em ostr} & the partial string to compare the current string to\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the string argument matches the beginning of the string where either both strings are the same size or the current string has a \textquotesingle{}/\textquotesingle{} or \textquotesingle{}?\textquotesingle{} character after the point where the argument string stops, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a53392adad0eab1542d3d8bc9c91da89c}\label{class_qore_1_1zzz8stringzzz9_a53392adad0eab1542d3d8bc9c91da89c}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!find@{find}}
\index{find@{find}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{find()}{find()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::find (\begin{DoxyParamCaption}\item[{softstring}]{substr,  }\item[{softint}]{pos = {\ttfamily 0} }\end{DoxyParamCaption})}



Retrieves the character position of a substring within a string. 

The {\itshape pos} argument and the return value are in character positions; byte offsets may differ from the character offsets with multi-\/byte \mbox{\hyperlink{character_encoding}{character encodings}}.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em substr} & the substring to find in the string; if the \mbox{\hyperlink{character_encoding}{character encoding}} of this string does not match {\itshape str}, then it will be converted to {\itshape str}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} before processing \\
\hline
{\em pos} & the starting character position for the search\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the character position of a substring within a string, -\/1 is returned if the substring is not found
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = str.find(substr);}
\DoxyCodeLine{\textcolor{keywordflow}{if} (i == -\/1)}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}could not find \%y in \%y\(\backslash\)n"{}}, substr, str);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if the string arguments have different \mbox{\hyperlink{character_encoding}{character encodings}} and an error occurs during encoding conversion \\
\hline
{\em INVALID-\/\+ENCODING} & this exception could be thrown if a character offset calculation fails due to invalid encoding of multi-\/byte character data\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_gadaea9cfa0f698a6fb0650f70cf8d929e}{Qore\+::index(softstring, softstring, softint)}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_af2463dc9c06ba8318b7030f040cfa85d}{Qore\+::zzz8stringzzz9\+::rfind(softstring, softint)}}
\item \mbox{\hyperlink{group__string__functions_ga55663008aa59489b869e558b29c7c22d}{rindex(softstring, softstring, softint)}}
\item \mbox{\hyperlink{group__string__functions_ga1f5360410dc63441327daf2af65b9270}{bindex(softstring, softstring, softint)}}
\item \mbox{\hyperlink{group__string__functions_ga123df73fe420500294a26163371fb175}{brindex(softstring, softstring, softint)}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a07b89a849ef94f060e0fcf2c040fd296}\label{class_qore_1_1zzz8stringzzz9_a07b89a849ef94f060e0fcf2c040fd296}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!getDecoded@{getDecoded}}
\index{getDecoded@{getDecoded}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{getDecoded()}{getDecoded()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::get\+Decoded (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{code = {\ttfamily \mbox{\hyperlink{group___string_concat_decoding_ga9c3dabdb0c33c28a293c10d4c1d97935}{CD\+\_\+\+ALL}}} }\end{DoxyParamCaption})}



returns a string based on the string value, decoded as per the {\itshape code} argument 

\begin{DoxyParagraph}{}

\begin{DoxyCode}{0}
\DoxyCodeLine{string ns = string.getDecoded(CE\_XML);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em code} & a decoding bitfield argument; see \mbox{\hyperlink{group___string_concat_decoding}{String Concatenation Decoding Codes}} for more information\\
\hline
\end{DoxyParams}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a4b2cac04c91fb14fcb5a79469550b820}{Qore\+::zzz8stringzzz9\+::get\+Encoded()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+12 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a4b2cac04c91fb14fcb5a79469550b820}\label{class_qore_1_1zzz8stringzzz9_a4b2cac04c91fb14fcb5a79469550b820}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!getEncoded@{getEncoded}}
\index{getEncoded@{getEncoded}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{getEncoded()}{getEncoded()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::get\+Encoded (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{code = {\ttfamily \mbox{\hyperlink{group___string_concat_encoding_gabdfd4734aad893296b3c584c3ba1326e}{CE\+\_\+\+XHTML}}} }\end{DoxyParamCaption})}



returns a string based on the string value with encodings as per the {\itshape code} argument 

\begin{DoxyParagraph}{}

\begin{DoxyCode}{0}
\DoxyCodeLine{string ns = string.getEncoded(CE\_XML);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em code} & an encoding bitfield argument; see \mbox{\hyperlink{group___string_concat_encoding}{String Concatenation Encoding Codes}} for more information\\
\hline
\end{DoxyParams}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a07b89a849ef94f060e0fcf2c040fd296}{Qore\+::zzz8stringzzz9\+::get\+Decoded()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+12 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ab5a4673da652f758677d729e40c1e415}\label{class_qore_1_1zzz8stringzzz9_ab5a4673da652f758677d729e40c1e415}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!getLine@{getLine}}
\index{getLine@{getLine}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{getLine()}{getLine()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::get\+Line (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{offset = {\ttfamily 0},  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{eol,  }\item[{bool}]{trim = {\ttfamily \mbox{\hyperlink{group__boolean__constants_ga3ba2df91713a6249449347131ea526c3}{True}}},  }\item[{\+\_\+\+\_\+7\+\_\+ reference$<$ \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} $>$}]{size }\end{DoxyParamCaption})}



returns a string for the next line in the string buffer starting at the given offset (or at the beginning if no offset is given) 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string line = string.getLine(pos);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em offset} & the offset in bytes from the beginning of the string; negative numbers give an offset from the end of the string \\
\hline
{\em eol} & the optional end of line character(s) to use to detect lines in the buffer; if this string is not passed, then the end of line character(s) are detected automatically, and can be either {\ttfamily \char`\"{}\textbackslash{}n\char`\"{}}, {\ttfamily \char`\"{}\textbackslash{}r\char`\"{}}, or {\ttfamily \char`\"{}\textbackslash{}r\textbackslash{}n\char`\"{}}; if this string is passed and has a different \mbox{\hyperlink{character_encoding}{character encoding}} from this object\textquotesingle{}s (as determined by the {\ttfamily encoding} parameter), then it will be converted to the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} \\
\hline
{\em trim} & if \mbox{\hyperlink{basic_data_types_True}{True}} the string return values for the lines iterated will be trimmed of the eol bytes \\
\hline
{\em size} & an optional reference to an integer that returns the number of bytes in the line including the end of line characters\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the line found or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no end of line character(s) were found or no data was found after the offset
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ac677323f97c583af45f7f77984462e3d}\label{class_qore_1_1zzz8stringzzz9_ac677323f97c583af45f7f77984462e3d}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!getUnicode@{getUnicode}}
\index{getUnicode@{getUnicode}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{getUnicode()}{getUnicode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::get\+Unicode (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{offset = {\ttfamily 0} }\end{DoxyParamCaption})}



returns the Unicode code for the given character offset in the string 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int uc = str.getUnicode(0);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em offset} & the offset in characters in the string; negative numbers give offsets from the end of the string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the Unicode code for the given character offset in the string
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ace7f5b6ac2e7b9f4886c9e153edd46d7}\label{class_qore_1_1zzz8stringzzz9_ace7f5b6ac2e7b9f4886c9e153edd46d7}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!intp@{intp}}
\index{intp@{intp}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{intp()}{intp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::intp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string can be converted to an integer, \mbox{\hyperlink{basic_data_types_False}{False}} if not, this depends on the first (or possibly second) character of the string, if it\textquotesingle{}s 0 -\/ 9 (possibly preceded by {\ttfamily \char`\"{}-\/\char`\"{}}), then the method returns \mbox{\hyperlink{basic_data_types_True}{True}}. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the string can be converted to an integer, \mbox{\hyperlink{basic_data_types_False}{False}} if not, this depends on the first (or possibly second) character of the string, if it\textquotesingle{}s 0 -\/ 9 (possibly preceded by {\ttfamily \char`\"{}-\/\char`\"{}}), then the method returns \mbox{\hyperlink{basic_data_types_True}{True}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.intp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: can be converted to an integer: \%d\(\backslash\)n"{}}, n, \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}(n));}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a766250b7a8d910b7facce5bef7cfe855}\label{class_qore_1_1zzz8stringzzz9_a766250b7a8d910b7facce5bef7cfe855}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!isDataAscii@{isDataAscii}}
\index{isDataAscii@{isDataAscii}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{isDataAscii()}{isDataAscii()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::is\+Data\+Ascii (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty or has no characters with the high bit set (ie all characters $<$ 128) 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty or has no characters with the high bit set (ie all characters $<$ 128)
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = str.isDataAscii();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ae568ad566fc87c944a64d6ce67dd3d16}\label{class_qore_1_1zzz8stringzzz9_ae568ad566fc87c944a64d6ce67dd3d16}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!isDataPrintableAscii@{isDataPrintableAscii}}
\index{isDataPrintableAscii@{isDataPrintableAscii}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{isDataPrintableAscii()}{isDataPrintableAscii()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::is\+Data\+Printable\+Ascii (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



returns \mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty or only contains printable non-\/control ASCII characters (ie all characters $>$ 31 \&\& $<$ 127) 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the string is empty or only contains printable non-\/control ASCII characters (ie all characters $>$ 31 \&\& $<$ 127)
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = str.isDataPrintableAscii();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a555db3550ff785af51a647415e994861}\label{class_qore_1_1zzz8stringzzz9_a555db3550ff785af51a647415e994861}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!length@{length}}
\index{length@{length}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{length()}{length()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::length (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of characters in the string; may not be equal to the byte length (returned by \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}{Qore\+::zzz8stringzzz9\+::strlen()}} and \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}}) for \mbox{\hyperlink{character_encoding}{multi-\/byte character encodings}}. 

\begin{DoxyReturn}{Returns}
the number of characters in the string; may not be equal to the byte length (returned by \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}{Qore\+::zzz8stringzzz9\+::strlen()}} and \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}}) for \mbox{\hyperlink{character_encoding}{multi-\/byte character encodings}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int len = str.length();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item this operation has {\itshape O(n)} complexity if the string has a multi-\/byte \mbox{\hyperlink{character_encoding}{character encoding}}, otherwise it is {\itshape O(1)}
\item equivalent to \mbox{\hyperlink{group__string__functions_ga5ae69f518a47e6146bf2285a54804455}{Qore\+::length(softstring)}}
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}{Qore\+::zzz8stringzzz9\+::strlen()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bed0246b3ce9aebf17d5d2ee29d51f3}{Qore\+::zzz8stringzzz9\+::width()}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ae2329c573986ede4a54e70e9ccef30e2}\label{class_qore_1_1zzz8stringzzz9_ae2329c573986ede4a54e70e9ccef30e2}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!lwr@{lwr}}
\index{lwr@{lwr}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{lwr()}{lwr()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::lwr (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the string in lower case. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y"{}}, \textcolor{stringliteral}{"{}PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ ÓDY"{}}.lwr());}
\DoxyCodeLine{\textcolor{comment}{\# outputs: "{}příliš žluťoučký kůň úpěl ďábelské ódy"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
This pseudo-\/method operates on a very wide range of non-\/\+ASCII characters using a Unicode lookup table for mapping Latin, Cyrillic, Greek, Armenian, Georgian, etc characters.

\begin{DoxyReturn}{Returns}
the string in lower case
\end{DoxyReturn}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item equivalent to \mbox{\hyperlink{group__string__functions_ga69274a2dc60bef5acb7a8adad8b96b8b}{Qore\+::tolower(string)}}
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a0b5c301c6742fccb8645968845b00fc1}{Qore\+::zzz8stringzzz9\+::upr()}}
\item \mbox{\hyperlink{group__string__functions_ga69274a2dc60bef5acb7a8adad8b96b8b}{tolower()}}
\item \mbox{\hyperlink{group__string__functions_ga55350788372fc736eee9c0102ec82215}{toupper()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 this pseudo-\/method operates on a wide range of characters and is no longer limited to ASCII characters 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a4713c0132472cf5cf6599ad9517cdc5f}\label{class_qore_1_1zzz8stringzzz9_a4713c0132472cf5cf6599ad9517cdc5f}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!regex@{regex}}
\index{regex@{regex}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{regex()}{regex()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::regex (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{regex,  }\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{options = {\ttfamily 0} }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the regular expression matches the string passed, otherwise returns \mbox{\hyperlink{basic_data_types_False}{False}}. 

Strings are converted to UTF-\/8 for pattern-\/matching; if any invalid encodings are encountered, an {\ttfamily ENCODING-\/\+CONVERSION-\/\+ERROR} is raised

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em regex} & the regular expression pattern \\
\hline
{\em options} & regular expression options; see \mbox{\hyperlink{group__regex__constants}{Regular Expression Constants}} for possible values\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the regular expression matches the string passed, otherwise returns \mbox{\hyperlink{basic_data_types_False}{False}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = \textcolor{stringliteral}{"{}hello"{}}.\mbox{\hyperlink{group__string__functions_ga7804f63df9b181e0bacb465eb912feb9}{regex}}(\textcolor{stringliteral}{"{}\string^hel"{}}); \textcolor{comment}{\# returns True}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em REGEX-\/\+COMPILATION-\/\+ERROR} & There was an error compiling the regular expression \\
\hline
{\em REGEX-\/\+OPTION-\/\+ERROR} & the option argument contains invalid option bits \\
\hline
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if an encoding error is encountered when converting the given strings to UTF-\/8\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_ga7804f63df9b181e0bacb465eb912feb9}{Qore\+::regex(string, string, int)}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{qore_regex}{Regular Expressions}} for more information about regular expression support in \mbox{\hyperlink{namespace_qore}{Qore}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_aeaf99b23a4de2db748a1fe0bbc3811f5}\label{class_qore_1_1zzz8stringzzz9_aeaf99b23a4de2db748a1fe0bbc3811f5}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!regexExtract@{regexExtract}}
\index{regexExtract@{regexExtract}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{regexExtract()}{regexExtract()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$$\ast$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}$>$ Qore\+::zzz8stringzzz9\+::regex\+Extract (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{regex,  }\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{options = {\ttfamily 0} }\end{DoxyParamCaption})}



Returns a list of substrings in a string based on matching patterns defined by a regular expression. 

Strings are converted to UTF-\/8 for pattern-\/matching; if any invalid encodings are encountered, an {\ttfamily ENCODING-\/\+CONVERSION-\/\+ERROR} is raised

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em regex} & the regular expression to use for matching, elements should be given in parentheses \\
\hline
{\em options} & regular expression options; see \mbox{\hyperlink{group__regex__constants}{Regular Expression Constants}} for possible values\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a list of substrings in a string based on matching patterns defined by a regular expression or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no match was made
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}ns:element"{}};}
\DoxyCodeLine{*list<*string> rv = str.regexExtract(\textcolor{stringliteral}{"{}(\(\backslash\)\(\backslash\)w+):(\(\backslash\)\(\backslash\)w+)"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em REGEX-\/\+COMPILATION-\/\+ERROR} & There was an error compiling the regular expression \\
\hline
{\em REGEX-\/\+OPTION-\/\+ERROR} & the option argument contains invalid option bits \\
\hline
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if an encoding error is encountered when converting the given strings to UTF-\/8\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent \mbox{\hyperlink{group__string__functions_ga9f8c21f961daa29578dcfd596f5871ff}{Qore\+::regex\+\_\+extract(string, string, int)}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{qore_regex}{Regular Expressions}} for more information about regular expression support in \mbox{\hyperlink{namespace_qore}{Qore}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5

Qore 0.\+8.\+8 this function accepts the \mbox{\hyperlink{group__regex__constants_gaea655c36090c9f1e6bb24cb8de998a04}{Qore\+::\+RE\+\_\+\+Global}} option to extract all occurrences of the pattern(s) in a string 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_af2463dc9c06ba8318b7030f040cfa85d}\label{class_qore_1_1zzz8stringzzz9_af2463dc9c06ba8318b7030f040cfa85d}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!rfind@{rfind}}
\index{rfind@{rfind}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{rfind()}{rfind()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::rfind (\begin{DoxyParamCaption}\item[{softstring}]{substr,  }\item[{softint}]{pos = {\ttfamily -\/1} }\end{DoxyParamCaption})}



Retrieves the character position of a substring within a string, starting the search from the end of the string. 

The {\itshape pos} argument and the return value are in character positions; byte offsets may differ from the character offsets with multi-\/byte \mbox{\hyperlink{character_encoding}{character encodings}}.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em substr} & the substring to find in {\itshape str}; if the \mbox{\hyperlink{character_encoding}{character encoding}} of this string does not match {\itshape str}, then it will be converted to {\itshape str}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} before processing \\
\hline
{\em pos} & the starting character position for the search, -\/1 means start from the end of the string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the character position of a substring within a string, -\/1 is returned if the substring is not found
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = str.rfind(substr);}
\DoxyCodeLine{\textcolor{keywordflow}{if} (i == -\/1)}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}could not find \%y in \%y\(\backslash\)n"{}}, substr, str);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if the string arguments have different \mbox{\hyperlink{character_encoding}{character encodings}} and an error occurs during encoding conversion \\
\hline
{\em INVALID-\/\+ENCODING} & this exception could be thrown if a character offset calculation fails due to invalid encoding of multi-\/byte character data\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_ga55663008aa59489b869e558b29c7c22d}{Qore\+::rindex(softstring, softstring, softint)}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a53392adad0eab1542d3d8bc9c91da89c}{Qore\+::zzz8stringzzz9\+::find(softstring, softint)}}
\item \mbox{\hyperlink{group__string__functions_gadaea9cfa0f698a6fb0650f70cf8d929e}{index(softstring, softstring, softint)}}
\item \mbox{\hyperlink{group__string__functions_ga1f5360410dc63441327daf2af65b9270}{bindex(softstring, softstring, softint)}}
\item \mbox{\hyperlink{group__string__functions_ga123df73fe420500294a26163371fb175}{brindex(softstring, softstring, softint)}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}\label{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!size@{size}}
\index{size@{size}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{size()}{size()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::size (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of bytes in the string (not including the terminating null character ({\ttfamily \textquotesingle{}\textbackslash{}0\textquotesingle{}}) 

\begin{DoxyReturn}{Returns}
the number of bytes in the string (not including the terminating null character ({\ttfamily \textquotesingle{}\textbackslash{}0\textquotesingle{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int len = str.size();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item this operation is always executed in constant time (ie {\itshape O(1)}) because the string\textquotesingle{}s byte length is always stored with the string
\item equivalent to \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}{Qore\+::zzz8stringzzz9\+::strlen()}} and \mbox{\hyperlink{group__string__functions_gafc530772b929b2148ae2733569bada58}{Qore\+::strlen(softstring)}}
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ac2af75dc65846c076c28fa73aee57455}{Qore\+::zzz8stringzzz9\+::sizep()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a555db3550ff785af51a647415e994861}{Qore\+::zzz8stringzzz9\+::length()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bed0246b3ce9aebf17d5d2ee29d51f3}{Qore\+::zzz8stringzzz9\+::width()}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ac2af75dc65846c076c28fa73aee57455}\label{class_qore_1_1zzz8stringzzz9_ac2af75dc65846c076c28fa73aee57455}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!sizep@{sizep}}
\index{sizep@{sizep}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{sizep()}{sizep()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::sizep (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} since strings can return a non-\/zero size. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} since strings can return a non-\/zero size
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_afe181b134b4aff3851e3dcb02b9cf7c4}\label{class_qore_1_1zzz8stringzzz9_afe181b134b4aff3851e3dcb02b9cf7c4}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!split@{split}}
\index{split@{split}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{split()}{split()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}$>$ Qore\+::zzz8stringzzz9\+::split (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sep,  }\item[{bool}]{with\+\_\+separator = {\ttfamily \mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}}} }\end{DoxyParamCaption})}



Splits a string into a list of components based on a separator string. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em sep} & the separator string; if the separator string is not found in the string to split, then a list with only one element containing the entire string argument is returned\textquotesingle{}; if this string has a different \mbox{\hyperlink{character_encoding}{character encoding}} than {\itshape str}, then it will be converted to {\itshape str}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} \\
\hline
{\em with\+\_\+separator} & include the separator string in every element\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a list of each component of a string separated by a separator string, with the separator removed; the separator pattern will not be included in the elements of the list returned unless the {\itshape with\+\_\+separator} argument is \mbox{\hyperlink{basic_data_types_True}{True}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}some:text:here"{}};}
\DoxyCodeLine{list<string> list = str.split(\textcolor{stringliteral}{"{}:"{}}); \textcolor{comment}{\# returns ("{}some"{}, "{}text"{}, "{}here"{})}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if the string arguments have different \mbox{\hyperlink{character_encoding}{character encodings}} and an error occurs during encoding conversion\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_ga3b0ca637686a083710559ab70be0ec19}{Qore\+::split(string, string, bool)}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a34c43c49f859529054ef495eb395e6bb}\label{class_qore_1_1zzz8stringzzz9_a34c43c49f859529054ef495eb395e6bb}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!split@{split}}
\index{split@{split}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{split()}{split()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}$>$ Qore\+::zzz8stringzzz9\+::split (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sep,  }\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{quote,  }\item[{bool}]{trim\+\_\+unquoted = {\ttfamily \mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}}} }\end{DoxyParamCaption})}



Splits a string into a list of components based on a separator string and a quote character. 

The quote character can appear as the first part of a field, in which case it is assumed to designate the entire field. If instances of the quote character are found in the field preceded by a backquote character ({\ttfamily \char`\"{}\textbackslash{}\char`\"{}}), then these quote characters are included as part of the field\textquotesingle{}s text and not treated as quote characters. Also the separator character can appear as a part of a field with this variant. This variant is useful for parsing CSV files, for example.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em sep} & the separator string; if the separator string is not found in the string to split, then a list with only one element containing the entire string argument is returned\textquotesingle{}; if this string has a different \mbox{\hyperlink{character_encoding}{character encoding}} than {\itshape str}, then it will be converted to {\itshape str}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} \\
\hline
{\em quote} & the quote character \\
\hline
{\em trim\+\_\+unquoted} & remove leading and trailing whitespace from unquoted fields\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a list of each component of a string separated by a separator string, with the separator and any enclosing quote characters removed
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# returns ("{}some"{}, "{}, and commas, here is another one! ,"{}, "{}here"{})}}
\DoxyCodeLine{list<string> list = \textcolor{stringliteral}{"{}some,'text with spaces, and commas, here is another one! ,',here"{}}.\mbox{\hyperlink{group__string__functions_ga3b0ca637686a083710559ab70be0ec19}{split}}(\textcolor{stringliteral}{"{},"{}}, \textcolor{stringliteral}{"{}'"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if the string arguments have different \mbox{\hyperlink{character_encoding}{character encodings}} and an error occurs during encoding conversion\\
\hline
{\em SPLIT-\/\+ERROR} & field missing closing quote character; extra text following quoted field\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_gad3db83c0fd5df500b0cc9d2ddb0e7d85}{Qore\+::split(string, string, string, bool)}}
\end{DoxyNote}
\begin{DoxySince}{Since}

\begin{DoxyItemize}
\item Qore 0.\+8.\+5 added this pseudo-\/method
\item Qore 0.\+8.\+6 added the {\ttfamily trim\+\_\+unquoted} parameter 
\end{DoxyItemize}
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ae2e9caa782d4ffec7140e208c2717a1c}\label{class_qore_1_1zzz8stringzzz9_ae2e9caa782d4ffec7140e208c2717a1c}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!splitRegex@{splitRegex}}
\index{splitRegex@{splitRegex}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{splitRegex()}{splitRegex()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}$>$ Qore\+::zzz8stringzzz9\+::split\+Regex (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{regex\+\_\+sep,  }\item[{bool}]{with\+\_\+separator = {\ttfamily \mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}}} }\end{DoxyParamCaption})}



Splits a string into a list of components based on a separator regular expression. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}some\(\backslash\)\(\backslash\):text:here"{}};}
\DoxyCodeLine{list<string> list = str.splitRegex(\textcolor{stringliteral}{"{}(?<!\(\backslash\)\(\backslash\)\(\backslash\)\(\backslash\))\(\backslash\)\(\backslash\):"{}}); \textcolor{comment}{\# returns ("{}some\(\backslash\)\(\backslash\):text"{}, "{}here"{})}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em regex\+\_\+sep} & the separator regular expression; if the separator regular expression is not matched in the string to split, then a list with only one element containing the entire string argument is returned\textquotesingle{}; if this string has a different \mbox{\hyperlink{character_encoding}{character encoding}} than {\itshape str}, then it will be converted to {\itshape str}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} \\
\hline
{\em with\+\_\+separator} & include the separator string in every element\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a list of each component of a string separated by a separator regular expression, with the separator removed; the separator pattern will not be included in the elements of the list returned unless the {\itshape with\+\_\+separator} argument is \mbox{\hyperlink{basic_data_types_True}{True}}; the strings in the return value are always returned in UTF-\/8 encoding
\end{DoxyReturn}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if the string arguments have different \mbox{\hyperlink{character_encoding}{character encodings}} and an error occurs during encoding conversion\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 1.\+0.\+7 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ac3b18663a7d3d58cbb200ca54030d1cd}\label{class_qore_1_1zzz8stringzzz9_ac3b18663a7d3d58cbb200ca54030d1cd}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!splitRegex@{splitRegex}}
\index{splitRegex@{splitRegex}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{splitRegex()}{splitRegex()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}$>$ Qore\+::zzz8stringzzz9\+::split\+Regex (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{regex\+\_\+sep,  }\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{options = {\ttfamily 0},  }\item[{bool}]{with\+\_\+separator = {\ttfamily \mbox{\hyperlink{group__boolean__constants_ga9da2b9a8003cd3788e48305f8a00540f}{False}}} }\end{DoxyParamCaption})}



Splits a string into a list of components based on a separator regular expression. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}some\(\backslash\)\(\backslash\):text:here"{}};}
\DoxyCodeLine{list<string> list = str.splitRegex(\textcolor{stringliteral}{"{}(?<!\(\backslash\)\(\backslash\)\(\backslash\)\(\backslash\))\(\backslash\)\(\backslash\):"{}}); \textcolor{comment}{\# returns ("{}some\(\backslash\)\(\backslash\):text"{}, "{}here"{})}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em regex\+\_\+sep} & the separator regular expression; if the separator regular expression is not matched in the string to split, then a list with only one element containing the entire string argument is returned\textquotesingle{}; if this string has a different \mbox{\hyperlink{character_encoding}{character encoding}} than {\itshape str}, then it will be converted to {\itshape str}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} \\
\hline
{\em options} & regular expression options; see \mbox{\hyperlink{group__regex__constants}{Regular Expression Constants}} for possible values \\
\hline
{\em with\+\_\+separator} & include the separator string in every element\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a list of each component of a string separated by a separator regular expression, with the separator removed; the separator pattern will not be included in the elements of the list returned unless the {\itshape with\+\_\+separator} argument is \mbox{\hyperlink{basic_data_types_True}{True}}; the strings in the return value are always returned in UTF-\/8 encoding
\end{DoxyReturn}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if the string arguments have different \mbox{\hyperlink{character_encoding}{character encodings}} and an error occurs during encoding conversion\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 1.\+0.\+7 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}\label{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!strlen@{strlen}}
\index{strlen@{strlen}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{strlen()}{strlen()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::strlen (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of bytes in the string (not including the terminating null character ({\ttfamily \textquotesingle{}\textbackslash{}0\textquotesingle{}}) 

\begin{DoxyReturn}{Returns}
the number of bytes in the string (not including the terminating null character ({\ttfamily \textquotesingle{}\textbackslash{}0\textquotesingle{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int len = str.strlen();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item this operation is always executed in constant time (ie {\itshape O(1)}) because the string\textquotesingle{}s byte length is always stored with the string
\item equivalent to \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}} and \mbox{\hyperlink{group__string__functions_gafc530772b929b2148ae2733569bada58}{Qore\+::strlen(softstring)}}
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a555db3550ff785af51a647415e994861}{Qore\+::zzz8stringzzz9\+::length()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bed0246b3ce9aebf17d5d2ee29d51f3}{Qore\+::zzz8stringzzz9\+::width()}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a776bb273fbcba12c8ff3f1a6a77d728b}\label{class_qore_1_1zzz8stringzzz9_a776bb273fbcba12c8ff3f1a6a77d728b}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!strp@{strp}}
\index{strp@{strp}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{strp()}{strp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::strp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} by default. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} by default
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.strp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: can be converted to a string: '\%s'\(\backslash\)n"{}}, n, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}(n));}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ab5ad54b1fe38b46ee071e55563d9d245}\label{class_qore_1_1zzz8stringzzz9_ab5ad54b1fe38b46ee071e55563d9d245}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!substr@{substr}}
\index{substr@{substr}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{substr()}{substr()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::substr (\begin{DoxyParamCaption}\item[{softint}]{start }\end{DoxyParamCaption})}



Returns a portion of a string starting from an integer offset. 

Arguments can be negative, giving offsets from the end of the string. All offsets are character positions, not byte positions.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em start} & The starting character for the substring where the first character is at offset 0; if the offset is negative, it designates the number of characters from the end of the string. If the offset is 0, then the entire string is returned.\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the substring of the string starting from an integer character offset; the rest of the string is returned after this offset; an emtpy string is returned if the argument cannot be satisfied
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# get the last 10 characters of a string}}
\DoxyCodeLine{string substr = str.substr(-\/10);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em INVALID-\/\+ENCODING} & this exception could be thrown if a character offset calculation fails due to invalid encoding of multi-\/byte character data\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_gafe621446ada382d5b086a1d2a20934c9}{Qore\+::substr(softstring, softint)}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_aaa1c011bda61406af681da3d12bb57c3}\label{class_qore_1_1zzz8stringzzz9_aaa1c011bda61406af681da3d12bb57c3}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!substr@{substr}}
\index{substr@{substr}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{substr()}{substr()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::substr (\begin{DoxyParamCaption}\item[{softint}]{start,  }\item[{softint}]{len }\end{DoxyParamCaption})}



Returns a portion of a string starting from an integer offset, with a length parameter. 

Arguments can be negative, giving offsets from the end of the string. All offsets are character positions, not byte positions.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em start} & The starting character for the substring where the first character is at offset 0; if the offset is negative, it designates the number of characters from the end of the string \\
\hline
{\em len} & The maximum number of characters to copy; if this value is negative, the rest of the string from {\itshape start} will be copied to the substring, except without -\/ {\itshape len} characters from the end of the string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the substring of the string according to the arguments passed; an emtpy string is returned if the argument cannot be satisfied
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# get a substring 10 characters into the string except omitting the last 2 characters of the string}}
\DoxyCodeLine{string substr = str.substr(10, -\/2);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em INVALID-\/\+ENCODING} & this exception could be thrown if a character offset calculation fails due to invalid encoding of multi-\/byte character data\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_ga7893910a0881f74365a20ec7a46014b6}{Qore\+::substr(softstring, softint, softint)}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a13b13f9681a94272d0e16371d2f22d90}\label{class_qore_1_1zzz8stringzzz9_a13b13f9681a94272d0e16371d2f22d90}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toBase64@{toBase64}}
\index{toBase64@{toBase64}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toBase64()}{toBase64()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+Base64 (\begin{DoxyParamCaption}\item[{softint}]{maxlinelen = {\ttfamily -\/1} }\end{DoxyParamCaption})}



Returns the base64-\/encoded representation of the string. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string base64 = str.toBase64(64);}

\end{DoxyCode}

\end{DoxyParagraph}
Implementation based on \href{http://www.ietf.org/rfc/rfc1421.txt}{\texttt{ RFC-\/1421}} and \href{http://www.ietf.org/rfc/rfc2045.txt}{\texttt{ RFC-\/2045}}


\begin{DoxyParams}{Parameters}
{\em maxlinelen} & the maximum length of a line in the resulting output string in bytes; if this value is $>$ 0 then output lines will be separated by CRLF characters\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the base64-\/encoded string of the data passed
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8
\end{DoxySince}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_ab30735fae927ea3be3e3a710574ff486}{Qore\+::zzz8binaryzzz9\+::to\+Base64()}}
\item \mbox{\hyperlink{group__misc__functions_ga8de429a31ac854f93c8c66e14baaaf66}{make\+\_\+base64\+\_\+string(string, softint)}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a825e0531419ae8abce66288e9d5ea4b1}\label{class_qore_1_1zzz8stringzzz9_a825e0531419ae8abce66288e9d5ea4b1}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toBinary@{toBinary}}
\index{toBinary@{toBinary}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toBinary()}{toBinary()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} Qore\+::zzz8stringzzz9\+::to\+Binary (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a binary value with the string\textquotesingle{}s data. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{binary bin = str.toBinary();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a binary value with the string\textquotesingle{}s data
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{group__type__conversion__functions_gad41f0cd19b4ebe21cf9562d2708ccabd}{Qore\+::binary(softstring)}} \char`\"{}binary(softstring)\char`\"{}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+9.\+3 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_af4a4f62237f079383098441132967527}\label{class_qore_1_1zzz8stringzzz9_af4a4f62237f079383098441132967527}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toHex@{toHex}}
\index{toHex@{toHex}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toHex()}{toHex()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+Hex (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



returns a string of hexadecimal digits corresponding to the contents of the string 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = str.toHex();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a string of hexadecimal digits corresponding to the contents of the string
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8
\end{DoxySince}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_ada0665f689a4787b2697c1ff399b7cac}{Qore\+::zzz8binaryzzz9\+::to\+Hex()}}
\item \mbox{\hyperlink{group__misc__functions_gae7be18717b0ed9010c48166a437c35b4}{make\+\_\+hex\+\_\+string(string)}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ae5fc7b01d0469fc2a015a0f6f3b0ae26}\label{class_qore_1_1zzz8stringzzz9_ae5fc7b01d0469fc2a015a0f6f3b0ae26}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toInt@{toInt}}
\index{toInt@{toInt}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toInt()}{toInt()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::to\+Int (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{base = {\ttfamily 10} }\end{DoxyParamCaption})}



Converts the string to an integer value with respect to the {\bfseries{base}} 

If a character is out of range of the corresponding {\bfseries{base}} only the substring preceeding the character is taken into account.~\newline
 Base 0 means to interpret as a code literal, so that the actual base is 8, 10, or 16.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em base} & the base of the integer in the string; this value must be 0 or 2 -\/ 36 inclusive or an {\ttfamily INVALID-\/\+BASE} exception will be thrown\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the integer value corresponding to the arguments
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{stringliteral}{"{}fe"{}}.toInt(16);   // returns 254}
\DoxyCodeLine{\textcolor{stringliteral}{"{}34"{}}.toInt(5);    // returns 19}
\DoxyCodeLine{\textcolor{stringliteral}{"{}2p"{}}.toInt(25);   // returns 2  (p means 25, which \textcolor{keywordflow}{is} out of range)}
\DoxyCodeLine{\textcolor{stringliteral}{"{}2p"{}}.toInt(26);   // returns 77}
\DoxyCodeLine{\textcolor{stringliteral}{"{}2z"{}}.toInt(36);   // returns 107}
\DoxyCodeLine{\textcolor{stringliteral}{"{}21"{}}.toInt();     // returns 21 (base = 10)}
\DoxyCodeLine{\textcolor{stringliteral}{"{}21"{}}.toInt(0);    // returns 21 (base = 10)}
\DoxyCodeLine{\textcolor{stringliteral}{"{}021"{}}.toInt(0);   // returns 17 (base =  8)}
\DoxyCodeLine{\textcolor{stringliteral}{"{}0x21"{}}.toInt(0);  // returns 33 (base = 16)}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em INVALID-\/\+BASE} & the base is invalid; must be 0 or 2 -\/ 36 inclusive \\
\hline
{\em UNSUPPORTED-\/\+ENCODING} & only ASCII-\/compatible encodings are currently supported\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8valuezzz9_aed0897423af7ddcb1ade7df4c4a61364}{Qore\+::zzz8valuezzz9\+::to\+Int()}} 

\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{Qore\+::int}}(\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} str, \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} base = 10)
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13; in previous versions the \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9_aed0897423af7ddcb1ade7df4c4a61364}{Qore\+::zzz8valuezzz9\+::to\+Int()}} function (without the {\bfseries{base}} argument) applied also to strings 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a2c63e2b65aafebf67928b88651d4cd39}\label{class_qore_1_1zzz8stringzzz9_a2c63e2b65aafebf67928b88651d4cd39}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toMD5@{toMD5}}
\index{toMD5@{toMD5}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toMD5()}{toMD5()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+MD5 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \href{http://en.wikipedia.org/wiki/MD5}{\texttt{ MD5 message digest}} of the string as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}5d41402abc4b2a76b9719d911017c592\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}hello"{}}.toMD5(); \textcolor{comment}{\# returns "{}5d41402abc4b2a76b9719d911017c592"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em MD5-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item equivalent to \mbox{\hyperlink{group__digest__functions_ga78c973088de21a5aae0cd8c68fc3447c}{Qore\+::\+MD5()}}
\item the MD5 algorithm is not collision-\/resistant; it\textquotesingle{}s recommended to use another hash algorithm (like SHA-\/256) if cryptographic security is important
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_gafea2cdf61fc831e245ba21f9d8397a23}{MD5\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a9eff25da172a81558e0bfab828bf9919}{Qore\+::zzz8binaryzzz9\+::to\+MD5()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a577cc1e9e6cb2f001c36f35a4cff4b74}\label{class_qore_1_1zzz8stringzzz9_a577cc1e9e6cb2f001c36f35a4cff4b74}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toSHA1@{toSHA1}}
\index{toSHA1@{toSHA1}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA1()}{toSHA1()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+SHA1 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \href{http://en.wikipedia.org/wiki/SHA-1}{\texttt{ SHA1}} message digest of the string as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}hello"{}}.toSHA1(); \textcolor{comment}{\# returns "{}aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA1-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_gaa4c0459a185dd677765d7ef073bf32cb}{Qore\+::\+SHA1()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga64b4d9ca4dc8396ad3bf5b6e5fd6ac6b}{SHA1\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a3f9afb50f2f621c133f11330432561d6}{Qore\+::zzz8binaryzzz9\+::to\+SHA1()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a3341bfb07348577260ece5244f958caf}\label{class_qore_1_1zzz8stringzzz9_a3341bfb07348577260ece5244f958caf}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toSHA224@{toSHA224}}
\index{toSHA224@{toSHA224}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA224()}{toSHA224()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+SHA224 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/224 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_gac2b845ff7b7e953d0ab2c7c0e33154fe}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA224}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}ea09ae9cc6768c50fcee903ed054556e5bfc8347907f12598aa24193\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}hello"{}}.toSHA224(\textcolor{stringliteral}{"{}hello"{}}); \textcolor{comment}{\# returns "{}ea09ae9cc6768c50fcee903ed054556e5bfc8347907f12598aa24193"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA224-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_ga31657accc4ffcdf966506bb07bc9a5f5}{Qore\+::\+SHA224()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_gad78d030a15fd77e92b6acbebf0f01c3b}{SHA224\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a40a67a7f4d31d72c67f65a71f98e9618}{Qore\+::zzz8binaryzzz9\+::to\+SHA224()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a11a362bbdba504966590d68bc6839350}\label{class_qore_1_1zzz8stringzzz9_a11a362bbdba504966590d68bc6839350}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toSHA256@{toSHA256}}
\index{toSHA256@{toSHA256}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA256()}{toSHA256()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+SHA256 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/256 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_ga8bbafb0df946db4960ec53f1739352c2}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA256}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}hello"{}}.toSHA256(); \textcolor{comment}{\# returns "{}2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA256-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_ga2650a6a57142a6c971c583f85c102bef}{Qore\+::\+SHA256()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga3e79a4b0a0fcbc536472144fbcb60fd7}{SHA256\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a3fad715400f0b1901a24e727b887d169}{Qore\+::zzz8binaryzzz9\+::to\+SHA256()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_ae572499e8fe84e24455806ba2556e5c5}\label{class_qore_1_1zzz8stringzzz9_ae572499e8fe84e24455806ba2556e5c5}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toSHA384@{toSHA384}}
\index{toSHA384@{toSHA384}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA384()}{toSHA384()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+SHA384 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/384 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_gaefa59259c4fcbe89eaf1efa5364e0420}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA384}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}59e1748777448c69de6b800d7a33bbfb9ff1b463e44354c3553bcdb9c666fa90125a3c79f90397bdf5f6a13de828684f\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# returns "{}59e1748777448c69de6b800d7a33bbfb9ff1b463e44354c3553bcdb9c666fa90125a3c79f90397bdf5f6a13de828684f"{}}}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}hello"{}}.toSHA384();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA384-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_gad1ac64eef1215b1da8be27c2cd3554d8}{Qore\+::\+SHA384()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga46725d7321778042e1acc9fc7e4f0842}{SHA384\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a40a67a7f4d31d72c67f65a71f98e9618}{Qore\+::zzz8binaryzzz9\+::to\+SHA224()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a0a8b0fd0c6dc97af23ad50be3125cb4d}\label{class_qore_1_1zzz8stringzzz9_a0a8b0fd0c6dc97af23ad50be3125cb4d}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!toSHA512@{toSHA512}}
\index{toSHA512@{toSHA512}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA512()}{toSHA512()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::to\+SHA512 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/512 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the string as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_ga361d12136d30719ba4861fd892ee022f}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA512}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}9b71d224bd62f3785d96d46ad3ea3d73319bfbc2890caadae2dff72519673ca72323c3d99ba5c11d7c7acc6e14b8c5da0c4663475c2e5c3adef46f73bcdec043\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# returns "{}9b71d224bd62f3785d96d46ad3ea3d73319bfbc2890caadae2dff72519673ca72323c3d99ba5c11d7c7acc6e14b8c5da0c4663475c2e5c3adef46f73bcdec043"{}}}
\DoxyCodeLine{string str = \textcolor{stringliteral}{"{}hello"{}}.toSHA512();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA512-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_ga6f598af6d5f8eecd18e9b8048ca610b3}{Qore\+::\+SHA512()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga14a7dc1fd6565a0ffa61d2dc943ef3e1}{SHA512\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_ab3a42f1beda2facfdbd32f465d9b8fe3}{Qore\+::zzz8binaryzzz9\+::to\+SHA512()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a4a3e3f0f6d983caea261935b2d3424f1}\label{class_qore_1_1zzz8stringzzz9_a4a3e3f0f6d983caea261935b2d3424f1}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!typeCode@{typeCode}}
\index{typeCode@{typeCode}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{typeCode()}{typeCode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::type\+Code (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{group__type__code__constants_ga86a3586f63bf9793e0cdb13f5e1f5db4}{Qore\+::\+NT\+\_\+\+STRING}}. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{group__type__code__constants_ga86a3586f63bf9793e0cdb13f5e1f5db4}{Qore\+::\+NT\+\_\+\+STRING}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{switch (str.typeCode()) \{}
\DoxyCodeLine{    case NT\_STRING:}
\DoxyCodeLine{        \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: is a string\(\backslash\)n"{}}, str);}
\DoxyCodeLine{        \textcolor{keywordflow}{break};}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a227ef4978fde1a808f14bc7ead59eb2e}\label{class_qore_1_1zzz8stringzzz9_a227ef4978fde1a808f14bc7ead59eb2e}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!unaccent@{unaccent}}
\index{unaccent@{unaccent}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{unaccent()}{unaccent()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::unaccent (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a string with all accented characters removed. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string s = \textcolor{stringliteral}{"{}příliš žluťoučký kůň úpěl ďábelské ódy"{}};}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, s.unaccent()); \textcolor{comment}{\# result: "{}prilis zlutoucky kun upel dabelske ody"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
The returned string has the same encoding as the original input.

\begin{DoxyReturn}{Returns}
the string with accents replaced
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a0b5c301c6742fccb8645968845b00fc1}\label{class_qore_1_1zzz8stringzzz9_a0b5c301c6742fccb8645968845b00fc1}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!upr@{upr}}
\index{upr@{upr}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{upr()}{upr()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8stringzzz9\+::upr (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the string in upper case. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y"{}}, \textcolor{stringliteral}{"{}příliš žluťoučký kůň úpěl ďábelské ódy"{}}.upr());}
\DoxyCodeLine{\textcolor{comment}{\# outputs: "{}PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ ÓDY"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
This pseudo-\/method operates on a very wide range of non-\/\+ASCII characters using a Unicode lookup table for mapping Latin, Cyrillic, Greek, Armenian, Georgian, etc characters.

\begin{DoxyReturn}{Returns}
the string in upper case
\end{DoxyReturn}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item equivalent to \mbox{\hyperlink{group__string__functions_ga55350788372fc736eee9c0102ec82215}{Qore\+::toupper(string)}}
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ae2329c573986ede4a54e70e9ccef30e2}{Qore\+::zzz8stringzzz9\+::lwr()}}
\item \mbox{\hyperlink{group__string__functions_ga69274a2dc60bef5acb7a8adad8b96b8b}{tolower()}}
\item \mbox{\hyperlink{group__string__functions_ga55350788372fc736eee9c0102ec82215}{toupper()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 this pseudo-\/method operates on a wide range of characters and is no longer limited to ASCII characters 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a6b280ef6ed27ec08d444123d6fecb38b}\label{class_qore_1_1zzz8stringzzz9_a6b280ef6ed27ec08d444123d6fecb38b}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!val@{val}}
\index{val@{val}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{val()}{val()}}
{\footnotesize\ttfamily bool Qore\+::zzz8stringzzz9\+::val (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the string is empty, \mbox{\hyperlink{basic_data_types_True}{True}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_False}{False}} if the string is empty, \mbox{\hyperlink{basic_data_types_True}{True}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = str.val();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8stringzzz9_a2bed0246b3ce9aebf17d5d2ee29d51f3}\label{class_qore_1_1zzz8stringzzz9_a2bed0246b3ce9aebf17d5d2ee29d51f3}} 
\index{$\langle$string$\rangle$@{$\langle$string$\rangle$}!width@{width}}
\index{width@{width}!Qore::<string>@{$\langle$string$\rangle$}}
\doxysubsubsection{\texorpdfstring{width()}{width()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8stringzzz9\+::width (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the width of characters in the string; some unicode characters take up multiple spaces on output. 

\begin{DoxyReturn}{Returns}
the width of characters in the string; some unicode characters take up multiple spaces on output; for example the string \char`\"{}ステップの例\char`\"{} is made up of 6 double-\/wide characters, so the width is 12, while the length in characters is 6, and the size (string byte length) is 18
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int width = str.width();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item this operation has {\itshape O(n)} complexity if the string has a multi-\/byte \mbox{\hyperlink{character_encoding}{character encoding}}, otherwise it is {\itshape O(1)}
\item equivalent to \mbox{\hyperlink{group__string__functions_ga3fcd81fc200908f483d2dc90f8431930}{Qore\+::char\+\_\+width(softstring)}}
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a555db3550ff785af51a647415e994861}{Qore\+::zzz8stringzzz9\+::length()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2bd72f65b9028cc5606741a547a0fed3}{Qore\+::zzz8stringzzz9\+::strlen()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ab4a8ecb725765ecd184f9d2cbd411c5c}{Qore\+::zzz8stringzzz9\+::size()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+9.\+4 
\end{DoxySince}
