\hypertarget{class_qore_1_1zzz8listzzz9}{}\doxysection{Qore\+::zzz8listzzz9 Class Reference}
\label{class_qore_1_1zzz8listzzz9}\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}}


Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{container_data_types_list}{lists}}.  




Inheritance diagram for Qore\+::zzz8listzzz9\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_aa361b6ecefb8fa38e282becf8001aab1}{complex\+Type}} ()
\begin{DoxyCompactList}\small\item\em returns \mbox{\hyperlink{basic_data_types_True}{True}} if the list has a \mbox{\hyperlink{data_type_declarations_hash_complex_type}{Hash With Declared Value Type}}, \mbox{\hyperlink{basic_data_types_False}{False}} if not \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a323c79bcac8e19a840dce76cd1e7a22b}{contains}} (auto arg)
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the list contains arg, \mbox{\hyperlink{basic_data_types_False}{False}} if it does not. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_afe120e9df2803e259c83c943152c9063}{empty}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the list is empty (size = 0), \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a7d460c5baf4290fac22d521d909e7f12}{first}} ()
\begin{DoxyCompactList}\small\item\em Returns the first entry in the list. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_abstract_iterator}{Abstract\+Iterator}} \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_ac8e243d7957d6136a6c77d32f320bf24}{iterator}} ()
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{class_qore_1_1_list_iterator}{List\+Iterator}} object for the list. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a5cb7d0b52f91aca98030ec1926beb5c5}{join}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} str)
\begin{DoxyCompactList}\small\item\em Creates a string from the list and a separator string given as an argument. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a89cad7498a6102679b4d2a96d3eceef5}{last}} ()
\begin{DoxyCompactList}\small\item\em Returns the last entry in the list. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a66451c32831c9ea7086d2b9fb62df31c}{lsize}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of elements in the list. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_abstract_iterator}{Abstract\+Iterator}} \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a4483a03f84971f0f3e64dace2de2f737}{range\+Iterator}} (auto \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a3991ad1c045e6c3db93e672b6509c05e}{val}})
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{class_qore_1_1_range_iterator}{Range\+Iterator}} object for the list elements. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_aeabf006f28c9c1a7815a324329ab3b2f}{size}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of elements in the list. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a926b4daaed4393124315fb78c27f6c45}{sizep}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} since lists can return a non-\/zero size. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a6eedcfa07a8f8dcbe75eadcb3e5f607b}{type\+Code}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{group__type__code__constants_gada83cf42174092e6f4d28f21f1ce3c2c}{Qore\+::\+NT\+\_\+\+LIST}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a3991ad1c045e6c3db93e672b6509c05e}{val}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the list is empty (size = 0), \mbox{\hyperlink{basic_data_types_True}{True}} if not. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{container_data_types_list}{lists}}. 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_aa361b6ecefb8fa38e282becf8001aab1}\label{class_qore_1_1zzz8listzzz9_aa361b6ecefb8fa38e282becf8001aab1}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!complexType@{complexType}}
\index{complexType@{complexType}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{complexType()}{complexType()}}
{\footnotesize\ttfamily bool Qore\+::zzz8listzzz9\+::complex\+Type (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



returns \mbox{\hyperlink{basic_data_types_True}{True}} if the list has a \mbox{\hyperlink{data_type_declarations_hash_complex_type}{Hash With Declared Value Type}}, \mbox{\hyperlink{basic_data_types_False}{False}} if not 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = n.complexType();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the list has a \mbox{\hyperlink{data_type_declarations_hash_complex_type}{Hash With Declared Value Type}}, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9_abd777c781935cb8faf3381fcc7ef3e88}{Qore\+::zzz8valuezzz9\+::full\+Type()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a323c79bcac8e19a840dce76cd1e7a22b}\label{class_qore_1_1zzz8listzzz9_a323c79bcac8e19a840dce76cd1e7a22b}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!contains@{contains}}
\index{contains@{contains}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{contains()}{contains()}}
{\footnotesize\ttfamily bool Qore\+::zzz8listzzz9\+::contains (\begin{DoxyParamCaption}\item[{auto}]{arg }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the list contains arg, \mbox{\hyperlink{basic_data_types_False}{False}} if it does not. 

This call uses \char`\"{}soft\char`\"{} comparisons (where types may be converted). The computational complexity is {\ttfamily O(n)} (n = the length of the list).

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em arg} & any value to check its presence in the list\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the list contains arg, \mbox{\hyperlink{basic_data_types_False}{False}} if it does not
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{list<int> l = (1, 2, 3);}
\DoxyCodeLine{bool b = l.contains(5); \textcolor{comment}{\# returns False}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_afe120e9df2803e259c83c943152c9063}\label{class_qore_1_1zzz8listzzz9_afe120e9df2803e259c83c943152c9063}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!empty@{empty}}
\index{empty@{empty}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{empty()}{empty()}}
{\footnotesize\ttfamily bool Qore\+::zzz8listzzz9\+::empty (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the list is empty (size = 0), \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

The opposite of \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a3991ad1c045e6c3db93e672b6509c05e}{Qore\+::zzz8listzzz9\+::val()}}

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the list is empty (size = 0), \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = l.empty();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a7d460c5baf4290fac22d521d909e7f12}\label{class_qore_1_1zzz8listzzz9_a7d460c5baf4290fac22d521d909e7f12}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!first@{first}}
\index{first@{first}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{first()}{first()}}
{\footnotesize\ttfamily auto Qore\+::zzz8listzzz9\+::first (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the first entry in the list. 

\begin{DoxyReturn}{Returns}
the first entry in the list
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto e = l.first();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a89cad7498a6102679b4d2a96d3eceef5}{Qore\+::zzz8listzzz9\+::last()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_ac8e243d7957d6136a6c77d32f320bf24}\label{class_qore_1_1zzz8listzzz9_ac8e243d7957d6136a6c77d32f320bf24}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!iterator@{iterator}}
\index{iterator@{iterator}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{iterator()}{iterator()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_abstract_iterator}{Abstract\+Iterator}} Qore\+::zzz8listzzz9\+::iterator (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a \mbox{\hyperlink{class_qore_1_1_list_iterator}{List\+Iterator}} object for the list. 

\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{class_qore_1_1_list_iterator}{List\+Iterator}} object for the list
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{map \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}+ \%y\(\backslash\)n"{}}, \$1), l.iterator();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a5cb7d0b52f91aca98030ec1926beb5c5}\label{class_qore_1_1zzz8listzzz9_a5cb7d0b52f91aca98030ec1926beb5c5}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!join@{join}}
\index{join@{join}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{join()}{join()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8listzzz9\+::join (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{str }\end{DoxyParamCaption})}



Creates a string from the list and a separator string given as an argument. 

Each element in the list will be converted to a string if necessary to be concatenated to the return value string; additionally if any string argument has a different \mbox{\hyperlink{character_encoding}{character encoding}} than {\itshape str}, then it will be converted to {\itshape str}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} before concatentation to the return value string

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em str} & the separator string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a string created from a list and a separator string, each element in the list will be present in the return value separated by the separator string; the string returned with have the same \mbox{\hyperlink{character_encoding}{character encoding}} as {\itshape str} 
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = (\textcolor{stringliteral}{"{}a"{}}, \textcolor{stringliteral}{"{}b"{}}, \textcolor{stringliteral}{"{}c"{}}).\mbox{\hyperlink{group__string__functions_ga2470edb3a13437c060ec85e7653e022a}{join}}(\textcolor{stringliteral}{"{}:"{}}); \textcolor{comment}{\# returns "{}a:b:c"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this exception could be thrown if the string arguments have different \mbox{\hyperlink{character_encoding}{character encodings}} and an error occurs during encoding conversion\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to join(string, list)
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a89cad7498a6102679b4d2a96d3eceef5}\label{class_qore_1_1zzz8listzzz9_a89cad7498a6102679b4d2a96d3eceef5}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!last@{last}}
\index{last@{last}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{last()}{last()}}
{\footnotesize\ttfamily auto Qore\+::zzz8listzzz9\+::last (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the last entry in the list. 

\begin{DoxyReturn}{Returns}
the last entry in the list
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto e = l.last();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a7d460c5baf4290fac22d521d909e7f12}{Qore\+::zzz8listzzz9\+::first()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a66451c32831c9ea7086d2b9fb62df31c}\label{class_qore_1_1zzz8listzzz9_a66451c32831c9ea7086d2b9fb62df31c}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!lsize@{lsize}}
\index{lsize@{lsize}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{lsize()}{lsize()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8listzzz9\+::lsize (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of elements in the list. 

For this type, this method is equivalent to \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_aeabf006f28c9c1a7815a324329ab3b2f}{size()}}

\begin{DoxyReturn}{Returns}
the number of elements in the list
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}iterating \%d element\%s\(\backslash\)n"{}}, val.lsize(), val.lsize() == 1 ? \textcolor{stringliteral}{"{}"{}} : \textcolor{stringliteral}{"{}s"{}});}
\DoxyCodeLine{foreach auto element \textcolor{keywordflow}{in} (val) \{}
\DoxyCodeLine{    do\_something(element);}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a4483a03f84971f0f3e64dace2de2f737}\label{class_qore_1_1zzz8listzzz9_a4483a03f84971f0f3e64dace2de2f737}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!rangeIterator@{rangeIterator}}
\index{rangeIterator@{rangeIterator}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{rangeIterator()}{rangeIterator()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_abstract_iterator}{Abstract\+Iterator}} Qore\+::zzz8listzzz9\+::range\+Iterator (\begin{DoxyParamCaption}\item[{auto}]{val }\end{DoxyParamCaption})}



Returns a \mbox{\hyperlink{class_qore_1_1_range_iterator}{Range\+Iterator}} object for the list elements. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{map \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}+ \%y\(\backslash\)n"{}}, \$1), l.ranegIterator();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em val} & an optional value to be returned instead of the default integer value\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{class_qore_1_1_range_iterator}{Range\+Iterator}} object for the list elements
\end{DoxyReturn}
\begin{DoxySince}{Since}

\begin{DoxyItemize}
\item Qore 0.\+8.\+8
\item Qore 0.\+8.\+11.\+1 this pseudo-\/method takes the optional {\itshape val} argument 
\end{DoxyItemize}
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_aeabf006f28c9c1a7815a324329ab3b2f}\label{class_qore_1_1zzz8listzzz9_aeabf006f28c9c1a7815a324329ab3b2f}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!size@{size}}
\index{size@{size}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{size()}{size()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8listzzz9\+::size (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of elements in the list. 

\begin{DoxyReturn}{Returns}
the number of elements in the list
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int len = l.size();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8listzzz9_a926b4daaed4393124315fb78c27f6c45}{Qore\+::zzz8listzzz9\+::sizep()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a926b4daaed4393124315fb78c27f6c45}\label{class_qore_1_1zzz8listzzz9_a926b4daaed4393124315fb78c27f6c45}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!sizep@{sizep}}
\index{sizep@{sizep}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{sizep()}{sizep()}}
{\footnotesize\ttfamily bool Qore\+::zzz8listzzz9\+::sizep (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} since lists can return a non-\/zero size. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} since lists can return a non-\/zero size
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8listzzz9_aeabf006f28c9c1a7815a324329ab3b2f}{Qore\+::zzz8listzzz9\+::size()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a6eedcfa07a8f8dcbe75eadcb3e5f607b}\label{class_qore_1_1zzz8listzzz9_a6eedcfa07a8f8dcbe75eadcb3e5f607b}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!typeCode@{typeCode}}
\index{typeCode@{typeCode}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{typeCode()}{typeCode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8listzzz9\+::type\+Code (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{group__type__code__constants_gada83cf42174092e6f4d28f21f1ce3c2c}{Qore\+::\+NT\+\_\+\+LIST}}. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{group__type__code__constants_gada83cf42174092e6f4d28f21f1ce3c2c}{Qore\+::\+NT\+\_\+\+LIST}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{switch (l.typeCode()) \{}
\DoxyCodeLine{    case NT\_LIST:}
\DoxyCodeLine{        \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: is a list\(\backslash\)n"{}}, l);}
\DoxyCodeLine{        \textcolor{keywordflow}{break};}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8listzzz9_a3991ad1c045e6c3db93e672b6509c05e}\label{class_qore_1_1zzz8listzzz9_a3991ad1c045e6c3db93e672b6509c05e}} 
\index{$\langle$list$\rangle$@{$\langle$list$\rangle$}!val@{val}}
\index{val@{val}!Qore::<list>@{$\langle$list$\rangle$}}
\doxysubsubsection{\texorpdfstring{val()}{val()}}
{\footnotesize\ttfamily bool Qore\+::zzz8listzzz9\+::val (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the list is empty (size = 0), \mbox{\hyperlink{basic_data_types_True}{True}} if not. 

The opposite of \mbox{\hyperlink{class_qore_1_1zzz8listzzz9_afe120e9df2803e259c83c943152c9063}{Qore\+::zzz8listzzz9\+::empty()}}

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_False}{False}} if the list is empty (size = 0), \mbox{\hyperlink{basic_data_types_True}{True}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = l.val();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{parse_directives_perl-bool-eval}{\%perl-\/bool-\/eval}}
\item \mbox{\hyperlink{parse_directives_strict-bool-eval}{\%strict-\/bool-\/eval}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
