\hypertarget{class_qore_1_1zzz8hashzzz9}{}\doxysection{Qore\+::zzz8hashzzz9 Class Reference}
\label{class_qore_1_1zzz8hashzzz9}\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}}


Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{container_data_types_hash}{hash values}}.  




Inheritance diagram for Qore\+::zzz8hashzzz9\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a5e83d974ab0eb3ea39aedbf5ca7c30a8}{compare\+Keys}} (\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ oh)
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the hash argument passed has the same keys in the same order as the current hash, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a32e0071f511bc645bfacbfd112ee11d4}{complex\+Type}} ()
\begin{DoxyCompactList}\small\item\em returns \mbox{\hyperlink{basic_data_types_True}{True}} if the hash has a complex type (\mbox{\hyperlink{hashdecl}{Hashdecl\+: Type-\/\+Safe Hash Declarations}} or \mbox{\hyperlink{data_type_declarations_hash_complex_type}{Hash With Declared Value Type}}), \mbox{\hyperlink{basic_data_types_False}{False}} if not \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_hash_list_iterator}{Hash\+List\+Iterator}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aab3d2e6e69d212dbe05de43136f14367}{context\+Iterator}} ()
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{class_qore_1_1_hash_list_iterator}{Hash\+List\+Iterator}} object for the hash. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a77253c70cb9379eb688ba076ad478e84}{empty}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the hash has no keys, \mbox{\hyperlink{basic_data_types_False}{False}} if it does. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aee7729c7e0aa26025151884653ea92e4}{first\+Key}} ()
\begin{DoxyCompactList}\small\item\em Returns the first key name in the hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a7197725a855c1fc1dcdfb639739dc794}{first\+Value}} ()
\begin{DoxyCompactList}\small\item\em Returns the value assigned to the first key in the hash if any or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a6538b4de8e019977a9b9b3730b4d21fb}{has\+Key}} (softstring key)
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the key exists in the hash (may or may not be assigned a value), \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a004a9455703ac3e07c15de46f07607db}{has\+Key\+Value}} (softstring key)
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the key exists and is assigned to a value, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_abstract_iterator}{Abstract\+Iterator}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_ad9c31b0d467e2a1496f57e3feff505ee}{iterator}} ()
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{class_qore_1_1_hash_iterator}{Hash\+Iterator}} object for the hash. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_hash_key_iterator}{Hash\+Key\+Iterator}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a4dde09aa84522bbd942d9339c0315ed5}{key\+Iterator}} ()
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{class_qore_1_1_hash_key_iterator}{Hash\+Key\+Iterator}} object for the hash. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_abea95265a8d43bda81e922865978fa1f}{keys}} ()
\begin{DoxyCompactList}\small\item\em Returns a list of key names of the hash. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_ae3f6d1b8abf88d08a32ed2d653f0e5e8}{last\+Key}} ()
\begin{DoxyCompactList}\small\item\em Returns the last key name in the hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a918a125aaaa36d854377b5853e5ef02a}{last\+Value}} ()
\begin{DoxyCompactList}\small\item\em Returns the value assigned to the last key in the hash if any or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_hash_pair_iterator}{Hash\+Pair\+Iterator}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aae2e67b218a51791103c21866df5217b}{pair\+Iterator}} ()
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{class_qore_1_1_hash_pair_iterator}{Hash\+Pair\+Iterator}} object for the hash. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aad47c06b8c27354b9975b394a2a8a464}{size}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of keys in the hash. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_ad69ea20970b8c5e9737247ba581c33aa}{sizep}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} since hashes can return a non-\/zero size. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_af648c06c9cd615790aae13c7278efeee}{type\+Code}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{group__type__code__constants_gaf94c74753aa73379b90ab30d092ffc60}{Qore\+::\+NT\+\_\+\+HASH}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_acc38eb60991abd2c576374b7bdbd2abb}{val}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the hash has no keys, \mbox{\hyperlink{basic_data_types_True}{True}} if it does. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aa0a89864ecb2f16870af201163a6e3a7}{values}} ()
\begin{DoxyCompactList}\small\item\em Returns a list of values of the hash. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{container_data_types_hash}{hash values}}. 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a5e83d974ab0eb3ea39aedbf5ca7c30a8}\label{class_qore_1_1zzz8hashzzz9_a5e83d974ab0eb3ea39aedbf5ca7c30a8}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!compareKeys@{compareKeys}}
\index{compareKeys@{compareKeys}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{compareKeys()}{compareKeys()}}
{\footnotesize\ttfamily bool Qore\+::zzz8hashzzz9\+::compare\+Keys (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$}]{oh }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the hash argument passed has the same keys in the same order as the current hash, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = h.compareKeys(oh);}

\end{DoxyCode}

\end{DoxyParagraph}
Values are not compraed, only the key names and order


\begin{DoxyParams}{Parameters}
{\em oh} & a hash to compare the keys against\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the hash argument passed has the same keys in the same order as the current hash, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a32e0071f511bc645bfacbfd112ee11d4}\label{class_qore_1_1zzz8hashzzz9_a32e0071f511bc645bfacbfd112ee11d4}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!complexType@{complexType}}
\index{complexType@{complexType}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{complexType()}{complexType()}}
{\footnotesize\ttfamily bool Qore\+::zzz8hashzzz9\+::complex\+Type (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



returns \mbox{\hyperlink{basic_data_types_True}{True}} if the hash has a complex type (\mbox{\hyperlink{hashdecl}{Hashdecl\+: Type-\/\+Safe Hash Declarations}} or \mbox{\hyperlink{data_type_declarations_hash_complex_type}{Hash With Declared Value Type}}), \mbox{\hyperlink{basic_data_types_False}{False}} if not 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = n.complexType();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the hash has a complex type (\mbox{\hyperlink{hashdecl}{Hashdecl\+: Type-\/\+Safe Hash Declarations}} or \mbox{\hyperlink{data_type_declarations_hash_complex_type}{Hash With Declared Value Type}}), \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9_abd777c781935cb8faf3381fcc7ef3e88}{Qore\+::zzz8valuezzz9\+::full\+Type()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_aab3d2e6e69d212dbe05de43136f14367}\label{class_qore_1_1zzz8hashzzz9_aab3d2e6e69d212dbe05de43136f14367}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!contextIterator@{contextIterator}}
\index{contextIterator@{contextIterator}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{contextIterator()}{contextIterator()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_hash_list_iterator}{Hash\+List\+Iterator}} Qore\+::zzz8hashzzz9\+::context\+Iterator (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a \mbox{\hyperlink{class_qore_1_1_hash_list_iterator}{Hash\+List\+Iterator}} object for the hash. 

\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{class_qore_1_1_hash_list_iterator}{Hash\+List\+Iterator}} object for the hash
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*hash<auto> q = db.select(\textcolor{stringliteral}{"{}select * from table\_name"{}});}
\DoxyCodeLine{map \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}+ \%s\(\backslash\)n"{}}, \$1), h.contextIterator();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item a hash with non-\/list values will be iterated as if each key value were a single element list
\item this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\item this pseudo-\/method is very useful when iterating query results from \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool_acafe45a0cf883bc51917e7a0bb8e77fd}{Datasource\+Pool\+::select()}} with the \mbox{\hyperlink{operators_map}{map operator}}, for example
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6.\+2 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a77253c70cb9379eb688ba076ad478e84}\label{class_qore_1_1zzz8hashzzz9_a77253c70cb9379eb688ba076ad478e84}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!empty@{empty}}
\index{empty@{empty}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{empty()}{empty()}}
{\footnotesize\ttfamily bool Qore\+::zzz8hashzzz9\+::empty (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the hash has no keys, \mbox{\hyperlink{basic_data_types_False}{False}} if it does. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the hash has no keys, \mbox{\hyperlink{basic_data_types_False}{False}} if it does
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = h.empty();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9}{Qore\+::zzz8valuezzz9}}, so it\textquotesingle{}s safe to use on all data types 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_aee7729c7e0aa26025151884653ea92e4}\label{class_qore_1_1zzz8hashzzz9_aee7729c7e0aa26025151884653ea92e4}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!firstKey@{firstKey}}
\index{firstKey@{firstKey}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{firstKey()}{firstKey()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8hashzzz9\+::first\+Key (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the first key name in the hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. 

\begin{DoxyReturn}{Returns}
the first key name in the hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string n = h.firstKey();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_ae3f6d1b8abf88d08a32ed2d653f0e5e8}{Qore\+::zzz8hashzzz9\+::last\+Key()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a7197725a855c1fc1dcdfb639739dc794}\label{class_qore_1_1zzz8hashzzz9_a7197725a855c1fc1dcdfb639739dc794}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!firstValue@{firstValue}}
\index{firstValue@{firstValue}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{firstValue()}{firstValue()}}
{\footnotesize\ttfamily auto Qore\+::zzz8hashzzz9\+::first\+Value (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the value assigned to the first key in the hash if any or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. 

\begin{DoxyReturn}{Returns}
the value assigned to the first key in the hash if any or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto v = h.firstValue();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a918a125aaaa36d854377b5853e5ef02a}{Qore\+::zzz8hashzzz9\+::last\+Value()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a6538b4de8e019977a9b9b3730b4d21fb}\label{class_qore_1_1zzz8hashzzz9_a6538b4de8e019977a9b9b3730b4d21fb}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!hasKey@{hasKey}}
\index{hasKey@{hasKey}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{hasKey()}{hasKey()}}
{\footnotesize\ttfamily bool Qore\+::zzz8hashzzz9\+::has\+Key (\begin{DoxyParamCaption}\item[{softstring}]{key }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the key exists in the hash (may or may not be assigned a value), \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em key} & the key name to check\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the key exists in the hash (may or may not be assigned a value), \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = h.hasKey(key);}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a004a9455703ac3e07c15de46f07607db}{Qore\+::zzz8hashzzz9\+::has\+Key\+Value(softstring)}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a004a9455703ac3e07c15de46f07607db}\label{class_qore_1_1zzz8hashzzz9_a004a9455703ac3e07c15de46f07607db}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!hasKeyValue@{hasKeyValue}}
\index{hasKeyValue@{hasKeyValue}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{hasKeyValue()}{hasKeyValue()}}
{\footnotesize\ttfamily bool Qore\+::zzz8hashzzz9\+::has\+Key\+Value (\begin{DoxyParamCaption}\item[{softstring}]{key }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the key exists and is assigned to a value, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em key} & the key name to check\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the key exists and is assigned to a value, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = h.hasKeyValue(key);}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a6538b4de8e019977a9b9b3730b4d21fb}{Qore\+::zzz8hashzzz9\+::has\+Key(softstring)}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_ad9c31b0d467e2a1496f57e3feff505ee}\label{class_qore_1_1zzz8hashzzz9_ad9c31b0d467e2a1496f57e3feff505ee}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!iterator@{iterator}}
\index{iterator@{iterator}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{iterator()}{iterator()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_abstract_iterator}{Abstract\+Iterator}} Qore\+::zzz8hashzzz9\+::iterator (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a \mbox{\hyperlink{class_qore_1_1_hash_iterator}{Hash\+Iterator}} object for the hash. 

\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{class_qore_1_1_hash_iterator}{Hash\+Iterator}} object for the hash
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{map \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}value: \%y\(\backslash\)n"{}}, \$1), h.iterator();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9}{Qore\+::zzz8valuezzz9}}, so it\textquotesingle{}s safe to use on all data types
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a4dde09aa84522bbd942d9339c0315ed5}\label{class_qore_1_1zzz8hashzzz9_a4dde09aa84522bbd942d9339c0315ed5}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!keyIterator@{keyIterator}}
\index{keyIterator@{keyIterator}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{keyIterator()}{keyIterator()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_hash_key_iterator}{Hash\+Key\+Iterator}} Qore\+::zzz8hashzzz9\+::key\+Iterator (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a \mbox{\hyperlink{class_qore_1_1_hash_key_iterator}{Hash\+Key\+Iterator}} object for the hash. 

\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{class_qore_1_1_hash_key_iterator}{Hash\+Key\+Iterator}} object for the hash
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{map \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}key: \%s\(\backslash\)n"{}}, \$1), h.keyIterator();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\item this pseudo-\/method is very useful when using a hash as a simulation for a set of strings and quickly iterating the hash with the \mbox{\hyperlink{operators_map}{map operator}}, for example
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6.\+2 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_abea95265a8d43bda81e922865978fa1f}\label{class_qore_1_1zzz8hashzzz9_abea95265a8d43bda81e922865978fa1f}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!keys@{keys}}
\index{keys@{keys}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{keys()}{keys()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}$>$ Qore\+::zzz8hashzzz9\+::keys (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a list of key names of the hash. 

\begin{DoxyReturn}{Returns}
a list of key names of the hash
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{list<string> l = h.keys();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aa0a89864ecb2f16870af201163a6e3a7}{Qore\+::zzz8hashzzz9\+::values()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_ae3f6d1b8abf88d08a32ed2d653f0e5e8}\label{class_qore_1_1zzz8hashzzz9_ae3f6d1b8abf88d08a32ed2d653f0e5e8}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!lastKey@{lastKey}}
\index{lastKey@{lastKey}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{lastKey()}{lastKey()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8hashzzz9\+::last\+Key (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the last key name in the hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. 

\begin{DoxyReturn}{Returns}
the last key name in the hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string n = h.lastKey();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aee7729c7e0aa26025151884653ea92e4}{Qore\+::zzz8hashzzz9\+::first\+Key()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_a918a125aaaa36d854377b5853e5ef02a}\label{class_qore_1_1zzz8hashzzz9_a918a125aaaa36d854377b5853e5ef02a}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!lastValue@{lastValue}}
\index{lastValue@{lastValue}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{lastValue()}{lastValue()}}
{\footnotesize\ttfamily auto Qore\+::zzz8hashzzz9\+::last\+Value (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the value assigned to the last key in the hash if any or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys. 

\begin{DoxyReturn}{Returns}
the value assigned to the last key in the hash if any or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the hash has no keys
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto v = h.lastValue();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a7197725a855c1fc1dcdfb639739dc794}{Qore\+::zzz8hashzzz9\+::first\+Value()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_aae2e67b218a51791103c21866df5217b}\label{class_qore_1_1zzz8hashzzz9_aae2e67b218a51791103c21866df5217b}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!pairIterator@{pairIterator}}
\index{pairIterator@{pairIterator}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{pairIterator()}{pairIterator()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_hash_pair_iterator}{Hash\+Pair\+Iterator}} Qore\+::zzz8hashzzz9\+::pair\+Iterator (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a \mbox{\hyperlink{class_qore_1_1_hash_pair_iterator}{Hash\+Pair\+Iterator}} object for the hash. 

\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{class_qore_1_1_hash_pair_iterator}{Hash\+Pair\+Iterator}} object for the hash
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{map \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%s: \%y\(\backslash\)n"{}}, \$1.key, \$1.value), h.pairIterator());}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6.\+2 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_aad47c06b8c27354b9975b394a2a8a464}\label{class_qore_1_1zzz8hashzzz9_aad47c06b8c27354b9975b394a2a8a464}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!size@{size}}
\index{size@{size}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{size()}{size()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8hashzzz9\+::size (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of keys in the hash. 

The opposite of \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_acc38eb60991abd2c576374b7bdbd2abb}{Qore\+::zzz8hashzzz9\+::val()}}

\begin{DoxyReturn}{Returns}
the number of keys in the hash
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int num = h.size();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9}{Qore\+::zzz8valuezzz9}}, so it\textquotesingle{}s safe to use on all data types
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_ad69ea20970b8c5e9737247ba581c33aa}{Qore\+::zzz8hashzzz9\+::sizep()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_ad69ea20970b8c5e9737247ba581c33aa}\label{class_qore_1_1zzz8hashzzz9_ad69ea20970b8c5e9737247ba581c33aa}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!sizep@{sizep}}
\index{sizep@{sizep}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{sizep()}{sizep()}}
{\footnotesize\ttfamily bool Qore\+::zzz8hashzzz9\+::sizep (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} since hashes can return a non-\/zero size. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} since hashes can return a non-\/zero size
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aad47c06b8c27354b9975b394a2a8a464}{Qore\+::zzz8hashzzz9\+::size()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_af648c06c9cd615790aae13c7278efeee}\label{class_qore_1_1zzz8hashzzz9_af648c06c9cd615790aae13c7278efeee}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!typeCode@{typeCode}}
\index{typeCode@{typeCode}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{typeCode()}{typeCode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8hashzzz9\+::type\+Code (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{group__type__code__constants_gaf94c74753aa73379b90ab30d092ffc60}{Qore\+::\+NT\+\_\+\+HASH}}. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{group__type__code__constants_gaf94c74753aa73379b90ab30d092ffc60}{Qore\+::\+NT\+\_\+\+HASH}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{switch (h.typeCode()) \{}
\DoxyCodeLine{    case NT\_HASH:}
\DoxyCodeLine{        \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: is a hash\(\backslash\)n"{}}, h);}
\DoxyCodeLine{        \textcolor{keywordflow}{break};}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9}{Qore\+::zzz8valuezzz9}}, so it\textquotesingle{}s safe to use on all data types 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_acc38eb60991abd2c576374b7bdbd2abb}\label{class_qore_1_1zzz8hashzzz9_acc38eb60991abd2c576374b7bdbd2abb}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!val@{val}}
\index{val@{val}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{val()}{val()}}
{\footnotesize\ttfamily bool Qore\+::zzz8hashzzz9\+::val (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the hash has no keys, \mbox{\hyperlink{basic_data_types_True}{True}} if it does. 

The opposite of \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_a77253c70cb9379eb688ba076ad478e84}{Qore\+::zzz8hashzzz9\+::empty()}}

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_False}{False}} if the hash has no keys, \mbox{\hyperlink{basic_data_types_True}{True}} if it does
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = h.val();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9}{Qore\+::zzz8valuezzz9}}, so it\textquotesingle{}s safe to use on all data types
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{parse_directives_perl-bool-eval}{\%perl-\/bool-\/eval}}
\item \mbox{\hyperlink{parse_directives_strict-bool-eval}{\%strict-\/bool-\/eval}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8hashzzz9_aa0a89864ecb2f16870af201163a6e3a7}\label{class_qore_1_1zzz8hashzzz9_aa0a89864ecb2f16870af201163a6e3a7}} 
\index{$\langle$hash$\rangle$@{$\langle$hash$\rangle$}!values@{values}}
\index{values@{values}!Qore::<hash>@{$\langle$hash$\rangle$}}
\doxysubsubsection{\texorpdfstring{values()}{values()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$auto$>$ Qore\+::zzz8hashzzz9\+::values (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a list of values of the hash. 

\begin{DoxyReturn}{Returns}
a list of values of the hash
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{list<auto> l = h.values();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item equivalent to \mbox{\hyperlink{group__misc__functions_gaf5d769ebf4e89f22c223f36beacf5000}{hash\+\_\+values()}}
\item this pseudo-\/method is also implemented in \mbox{\hyperlink{class_qore_1_1zzz8nothingzzz9}{Qore\+::zzz8nothingzzz9}}, so it\textquotesingle{}s safe to use where the value could be a hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (ex\+: \mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}})
\item a hash with a declared value type will have a plain untyped list returned; this will be fixed in a future version of Qore
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_abea95265a8d43bda81e922865978fa1f}{Qore\+::zzz8hashzzz9\+::keys()}} 
\end{DoxySeeAlso}
