\hypertarget{class_qore_1_1zzz8numberzzz9}{}\doxysection{Qore\+::zzz8numberzzz9 Class Reference}
\label{class_qore_1_1zzz8numberzzz9}\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}}


Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_number}{arbitrary precision number values}}.  




Inheritance diagram for Qore\+::zzz8numberzzz9\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{group__type__conversion__functions_gaf6000d64e3fe99ce81b9faaf44b2de4e}{number}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a638c34b8465f9a9ce773c25e4a263cd9}{abs}} ()
\begin{DoxyCompactList}\small\item\em Returns the absolute value of the number. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_acdcee3a4130b680892d915f3956f8199}{format}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} fmt)
\begin{DoxyCompactList}\small\item\em Returns a formatted string of the number according to the format argument. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a31013414002c3808718a217d8d488f7b}{format}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a1fe1e3b19d22b16a26298c17f8a142f1}{prec}}=2, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} decimal\+\_\+sep=\char`\"{}.\char`\"{}, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} thousands\+\_\+sep=\char`\"{}\char`\"{})
\begin{DoxyCompactList}\small\item\em Returns a formatted string of the number according to format arguments. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a77d551228c1b9919aff689fa6a5f2d02}{infp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the number is infinity (+ or -\/) \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_ae1c82d60b2445d72d4ece799aae3ce9c}{intp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} because number values can be converted to integers. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a727440c8e6372147f05d7b47400c3d04}{nanp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the number is NaN (not a number) \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a1fe1e3b19d22b16a26298c17f8a142f1}{prec}} ()
\begin{DoxyCompactList}\small\item\em Returns the precision of the current number. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a38775c7c4cfe0f625996416ef764b6c7}{sign}} ()
\begin{DoxyCompactList}\small\item\em Returns -\/1 if the number is negative, 0 if it is zero, or 1 if it is positive. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a641e9e8ebd0a13be0c13be36abe54b61}{strp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} because number values can be converted to strings. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_ae6d52cb434c6eef372ef064852038f8a}{to\+Base}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} base=10)
\begin{DoxyCompactList}\small\item\em Converts the number to a different {\bfseries{base}} (and returns it as a string). \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_afdb59247ad7986908146221d6ebf4806}{to\+String}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} fmt)
\begin{DoxyCompactList}\small\item\em Returns the string representation of the number according to the format argument. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_ae2c7a3126a3d07d4657043b6f548b1a0}{type\+Code}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{group__type__code__constants_ga57b8fff06d2f486b8ec1a1952b6f06aa}{Qore\+::\+NT\+\_\+\+NUMBER}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a51efa04ed2ac66dcd168b25a739a8af6}{val}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the number is non-\/zero, \mbox{\hyperlink{basic_data_types_False}{False}} if zero. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_number}{arbitrary precision number values}}. 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a638c34b8465f9a9ce773c25e4a263cd9}\label{class_qore_1_1zzz8numberzzz9_a638c34b8465f9a9ce773c25e4a263cd9}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!abs@{abs}}
\index{abs@{abs}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{abs()}{abs()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gaf6000d64e3fe99ce81b9faaf44b2de4e}{number}} Qore\+::zzz8numberzzz9\+::abs (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the absolute value of the number. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{n = n.abs();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the absolute value of the number
\end{DoxyReturn}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__math__functions_gaa7733d4d308dbec2beace333f09c3ef7}{abs(number)}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a31013414002c3808718a217d8d488f7b}\label{class_qore_1_1zzz8numberzzz9_a31013414002c3808718a217d8d488f7b}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!format@{format}}
\index{format@{format}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{format()}{format()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8numberzzz9\+::format (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{prec = {\ttfamily 2},  }\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{decimal\+\_\+sep = {\ttfamily \char`\"{}.\char`\"{}},  }\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{thousands\+\_\+sep = {\ttfamily \char`\"{}\char`\"{}} }\end{DoxyParamCaption})}



Returns a formatted string of the number according to format arguments. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em prec} & the number of digits after the decimal point; a negative value means to round that number of digits before the decimal place, whereas the special constant \mbox{\hyperlink{group__number__string__formatting__constants_gab4b7a40f77ac14951ab6f04229a7bb6b}{SNF\+\_\+\+All\+Digits}} means to include all possible digits after the decimal point \\
\hline
{\em decimal\+\_\+sep} & a single character that defines the decimal separator; an empty string means no decimal separator \\
\hline
{\em thousands\+\_\+sep} & a single character that defines the thousands and further separators every three digits before the decimal point; an empty string means no thousands separator\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a string representing the number according to the format arguments as described above
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{float f = -\/48392093894.2349;}
\DoxyCodeLine{string fstr = f.format(3, \textcolor{stringliteral}{"{}."{}}, \textcolor{stringliteral}{"{},"{}}); \textcolor{comment}{\# returns "{}-\/48.392.093.894,235"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a0a1ed20b3cbe9a7d99681b2ee1b4802b}{Qore\+::zzz8floatzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a52e3a4df1cf57a32686d651666a9643a}{Qore\+::zzz8intzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_acdcee3a4130b680892d915f3956f8199}{Qore\+::zzz8numberzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a456f92c6ee27c0c772223745f918bcbc}{Qore\+::zzz8floatzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a4f4b203fef4e2ae785f838c98e5995be}{Qore\+::zzz8intzzz9\+::format(string)}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_acdcee3a4130b680892d915f3956f8199}\label{class_qore_1_1zzz8numberzzz9_acdcee3a4130b680892d915f3956f8199}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!format@{format}}
\index{format@{format}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{format()}{format()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8numberzzz9\+::format (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{fmt }\end{DoxyParamCaption})}



Returns a formatted string of the number according to the format argument. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em fmt} & the format string has the following format\+:~\newline
 {\itshape $<$thousands\+\_\+separator$>$}{\ttfamily \mbox{[}}{\itshape $<$decimal\+\_\+separator$>$\mbox{[}$<$decimals$>$\mbox{]}}{\ttfamily \mbox{]}}~\newline
 where\+:~\newline

\begin{DoxyItemize}
\item {\itshape thousands\+\_\+separator} and {\itshape decimal\+\_\+separator} are single characters defining the thousands and decimal separator characters respectively, and
\item {\itshape decimals} is one or more digits defining how may decimals should appear after the decimal point; a negative number means to round that number of digits before the decimal place
\end{DoxyItemize}\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a string of a formatted number according to a format string; if the format string does not follow the given format, then the number without formatting is returned
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{float f = -\/48392093894.2349;}
\DoxyCodeLine{string fstr = f.format(\textcolor{stringliteral}{"{}.,3"{}}); \textcolor{comment}{\# returns "{}-\/48.392.093.894,235"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a456f92c6ee27c0c772223745f918bcbc}{Qore\+::zzz8floatzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a4f4b203fef4e2ae785f838c98e5995be}{Qore\+::zzz8intzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a31013414002c3808718a217d8d488f7b}{Qore\+::zzz8numberzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a0a1ed20b3cbe9a7d99681b2ee1b4802b}{Qore\+::zzz8floatzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a52e3a4df1cf57a32686d651666a9643a}{Qore\+::zzz8intzzz9\+::format(int, string, string)}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a77d551228c1b9919aff689fa6a5f2d02}\label{class_qore_1_1zzz8numberzzz9_a77d551228c1b9919aff689fa6a5f2d02}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!infp@{infp}}
\index{infp@{infp}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{infp()}{infp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8numberzzz9\+::infp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the number is infinity (+ or -\/) 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the number is infinity (+ or -\/)
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.infp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga996c5d1686fbc245f0bc7a02012e6a33}{print}}(\textcolor{stringliteral}{"{}the operation resulted in infinity\(\backslash\)n"{}});}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_ae1c82d60b2445d72d4ece799aae3ce9c}\label{class_qore_1_1zzz8numberzzz9_ae1c82d60b2445d72d4ece799aae3ce9c}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!intp@{intp}}
\index{intp@{intp}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{intp()}{intp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8numberzzz9\+::intp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} because number values can be converted to integers. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} because number values can be converted to integers
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.intp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: can be converted to an integer: \%d\(\backslash\)n"{}}, n, \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}(n));}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a727440c8e6372147f05d7b47400c3d04}\label{class_qore_1_1zzz8numberzzz9_a727440c8e6372147f05d7b47400c3d04}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!nanp@{nanp}}
\index{nanp@{nanp}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{nanp()}{nanp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8numberzzz9\+::nanp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the number is NaN (not a number) 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the number is NaN (not a number)
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.nanp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga996c5d1686fbc245f0bc7a02012e6a33}{print}}(\textcolor{stringliteral}{"{}the operation resulted in NaN\(\backslash\)n"{}});}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a1fe1e3b19d22b16a26298c17f8a142f1}\label{class_qore_1_1zzz8numberzzz9_a1fe1e3b19d22b16a26298c17f8a142f1}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!prec@{prec}}
\index{prec@{prec}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{prec()}{prec()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8numberzzz9\+::prec (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the precision of the current number. 

\begin{DoxyReturn}{Returns}
the precision of the current number
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}precision: \%d\(\backslash\)n"{}}, n.prec());}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a38775c7c4cfe0f625996416ef764b6c7}\label{class_qore_1_1zzz8numberzzz9_a38775c7c4cfe0f625996416ef764b6c7}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!sign@{sign}}
\index{sign@{sign}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{sign()}{sign()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8numberzzz9\+::sign (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns -\/1 if the number is negative, 0 if it is zero, or 1 if it is positive. 

\begin{DoxyReturn}{Returns}
-\/1 if the number is negative, 0 if it is zero, or 1 if it is positive
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}sign: \%d\(\backslash\)n"{}}, n.sign());}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a641e9e8ebd0a13be0c13be36abe54b61}\label{class_qore_1_1zzz8numberzzz9_a641e9e8ebd0a13be0c13be36abe54b61}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!strp@{strp}}
\index{strp@{strp}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{strp()}{strp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8numberzzz9\+::strp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} because number values can be converted to strings. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} because number values can be converted to strings
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.strp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: can be converted to a string: '\%s'\(\backslash\)n"{}}, n, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}(n));}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_ae6d52cb434c6eef372ef064852038f8a}\label{class_qore_1_1zzz8numberzzz9_ae6d52cb434c6eef372ef064852038f8a}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!toBase@{toBase}}
\index{toBase@{toBase}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{toBase()}{toBase()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8numberzzz9\+::to\+Base (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{base = {\ttfamily 10} }\end{DoxyParamCaption})}



Converts the number to a different {\bfseries{base}} (and returns it as a string). 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em base} & the base to convert the number to; this value must be 2 -\/ 36 inclusive or an {\ttfamily INVALID-\/\+BASE} exception will be thrown\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the converted value as a string
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{(-\/276536798792387623n).toBase(29)); // returns \textcolor{stringliteral}{"{}-\/MJ934KRG1O3R"{}}}
\DoxyCodeLine{  276536798792387623n.toBase(2));   // returns \textcolor{stringliteral}{"{}1111010110011101001100000011011011010110000000110000100111"{}}}
\DoxyCodeLine{  (15.5n).toBase(20));              // returns \textcolor{stringliteral}{"{}F.A"{}}}
\DoxyCodeLine{ (-\/13.8n).toBase(20));              // returns \textcolor{stringliteral}{"{}-\/D.G"{}}}
\DoxyCodeLine{ (21.48n).toBase(15));              // returns \textcolor{stringliteral}{"{}16.73"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em INVALID-\/\+BASE} & the base is invalid; must be 2 -\/ 36 inclusive\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a1a7c8f41ba26bec22c1a0f485d90a48a}{Qore\+::zzz8intzzz9\+::to\+Base(int base)}} 

\mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a138a6d9c7f0c10546c96a875bc29d242}{Qore\+::zzz8floatzzz9\+::to\+Base(int base)}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_afdb59247ad7986908146221d6ebf4806}\label{class_qore_1_1zzz8numberzzz9_afdb59247ad7986908146221d6ebf4806}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!toString@{toString}}
\index{toString@{toString}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{toString()}{toString()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8numberzzz9\+::to\+String (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{fmt }\end{DoxyParamCaption})}



Returns the string representation of the number according to the format argument. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em fmt} & see \mbox{\hyperlink{group__number__formatting__constants}{Number Formatting Constants}} for possible values; note that this argument is interpreted as a bit field; if the format argument is not a valid format value (i.\+e. if none of the formatting bits are set in the argument) then \mbox{\hyperlink{group__number__formatting__constants_ga26210c15de6f9439841b31983989b727}{NF\+\_\+\+Default}} is assumed instead\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the string representation of the number according to the format argument
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_ae2c7a3126a3d07d4657043b6f548b1a0}\label{class_qore_1_1zzz8numberzzz9_ae2c7a3126a3d07d4657043b6f548b1a0}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!typeCode@{typeCode}}
\index{typeCode@{typeCode}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{typeCode()}{typeCode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8numberzzz9\+::type\+Code (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{group__type__code__constants_ga57b8fff06d2f486b8ec1a1952b6f06aa}{Qore\+::\+NT\+\_\+\+NUMBER}}. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{group__type__code__constants_ga57b8fff06d2f486b8ec1a1952b6f06aa}{Qore\+::\+NT\+\_\+\+NUMBER}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{switch (f.typeCode()) \{}
\DoxyCodeLine{    case NT\_NUMBER:}
\DoxyCodeLine{        \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: is a number\(\backslash\)n"{}}, f);}
\DoxyCodeLine{        \textcolor{keywordflow}{break};}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8numberzzz9_a51efa04ed2ac66dcd168b25a739a8af6}\label{class_qore_1_1zzz8numberzzz9_a51efa04ed2ac66dcd168b25a739a8af6}} 
\index{$\langle$number$\rangle$@{$\langle$number$\rangle$}!val@{val}}
\index{val@{val}!Qore::<number>@{$\langle$number$\rangle$}}
\doxysubsubsection{\texorpdfstring{val()}{val()}}
{\footnotesize\ttfamily bool Qore\+::zzz8numberzzz9\+::val (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the number is non-\/zero, \mbox{\hyperlink{basic_data_types_False}{False}} if zero. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the number is non-\/zero, \mbox{\hyperlink{basic_data_types_False}{False}} if zero
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = f.val();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{parse_directives_perl-bool-eval}{\%perl-\/bool-\/eval}}
\item \mbox{\hyperlink{parse_directives_strict-bool-eval}{\%strict-\/bool-\/eval}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
