\hypertarget{class_qore_1_1_thread_1_1_r_w_lock}{}\doxysection{Qore\+::Thread\+::RWLock Class Reference}
\label{class_qore_1_1_thread_1_1_r_w_lock}\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}}


The \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} class implements a read-\/write thread lock.  




Inheritance diagram for Qore\+::Thread\+::RWLock\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a2cca11879044ef7f40cfa707f1bf3c47}{constructor}} ()
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a88a6fefec6f761cf0d72baf2b38cb62b}{copy}} ()
\begin{DoxyCompactList}\small\item\em Creates a new \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object, not based on the original. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a52ba1405c9bf97c3888cc58bd0d5902a}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_acb76cd08c7aa13854b2174e952efee65}{get\+Read\+Waiting}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of threads waiting on the read lock. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ab5f9f093afb74f047051356524e288ff}{get\+Write\+Waiting}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of threads waiting on the write lock. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_aefcf3643bfe193b7d4b63cef41299ade}{lock\+Owner}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding either the read lock or the write lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a5ae6ade327e6c65430025c653c684f3c}{num\+Readers}} ()
\begin{DoxyCompactList}\small\item\em Returns the read lock count. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}{read\+Lock}} ()
\begin{DoxyCompactList}\small\item\em Acquires the read lock; blocks if the write lock is already acquired by another thread. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a10e4f61ecbb32380ac729217cb6b3161}{read\+Lock}} (timeout timeout\+\_\+ms)
\begin{DoxyCompactList}\small\item\em Acquires the read lock with a timeout value; blocks if the write lock is already acquired by another thread. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a362a40fe4d167e29befa94f40e4495e5}{read\+Lock\+Owner}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding the read lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a1a32805ce5cc129d2ed2bf96b01a7d4c}{read\+Unlock}} ()
\begin{DoxyCompactList}\small\item\em Decrements the read lock counter and releases the read lock if the counter is zero. If at least one thread is blocked trying to acquire the write lock and the read counter reaches zero, then one thread waiting on the write lock is woken up. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ae6ae2fb6dadf5d144dbd7694c0ca0bfb}{try\+Read\+Lock}} ()
\begin{DoxyCompactList}\small\item\em Acquires the read lock only if it can be acquired immediately. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a20b09807edecf2ee7591e90e16c4fe6c}{try\+Write\+Lock}} ()
\begin{DoxyCompactList}\small\item\em Acquires the write lock only if it can be acquired immediately. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a0be2f09ba84a3a5fbf3d0073c59f8542}{write\+Lock}} (timeout timeout\+\_\+ms)
\begin{DoxyCompactList}\small\item\em Acquires the write lock with a timeout value; blocks if the read lock is already acquired by another thread. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a15face42a9f0634de3e2f835f8daa35b}{write\+Lock}} ()
\begin{DoxyCompactList}\small\item\em Acquires the write lock; blocks if the read lock is already acquired by another thread. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a5e9c32cc40cd0cb9b00e6d29f265884f}{write\+Lock\+Owner}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding the write lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a577f98df56071f39199c7ace72dc132d}{write\+Unlock}} ()
\begin{DoxyCompactList}\small\item\em Releases the write lock, if any readers are waiting, wakes up all readers, otherwise if any writers are waiting, then wakes one up. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
The \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} class implements a read-\/write thread lock. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Overview}
This class inherits \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_smart_lock}{Abstract\+Smart\+Lock}}, so it can be used by \mbox{\hyperlink{class_qore_1_1_thread_1_1_condition}{Condition}} objects, while using either the read lock or the write lock.~\newline
~\newline
 The \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} class implements a read-\/write lock for efficient thread locking when write actions must be atomic and reads can be made in parallel if no write is in progress. When a thread holds the write lock, no other thread can grab the read or write lock. Multiple threads can hold the read lock at one time.~\newline
~\newline
 As with all Qore threading primitives, this class supports deadlock detection and throws exceptions when threading errors are encountered (for example, trying to free the read lock while holding the write lock, etc).~\newline
~\newline
 This read-\/write lock favors readers, so the read lock can be safely acquired recursively.~\newline
~\newline
 See the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} and the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_write_lock}{Auto\+Write\+Lock}} classes for classes that assist in exception-\/safe \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} locking.~\newline
~\newline
 Additionally, the \mbox{\hyperlink{statements_on_exit}{on\+\_\+exit statement}} can provide exception-\/safe \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} handling at the lexical block level as in the following example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{\{}
\DoxyCodeLine{    rwl.writeLock();}
\DoxyCodeLine{    on\_exit}
\DoxyCodeLine{        rwl.writeUnlock();}
\DoxyCodeLine{}
\DoxyCodeLine{    \textcolor{comment}{\# ... when this block exits the lock will be released, even in the}}
\DoxyCodeLine{    \textcolor{comment}{\#     case of return statements or exceptions}}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyParagraph}{Thread Resource Handling}
The \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} class manages the lock as a \mbox{\hyperlink{threading_thread_resources}{thread resource}}; if the lock is not released when the thread exits (or when \mbox{\hyperlink{group__threading__functions_ga421dca39ccb55b191d5d09fd98c2075a}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions()}} or \mbox{\hyperlink{group__threading__functions_ga4e62409b8a1b414276d033267e7299e4}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions\+\_\+to\+\_\+mark()}} is called), the any read or write locks held are released automatically and a {\ttfamily LOCK-\/\+ERROR} exception is thrown describing the situation.~\newline
~\newline
 Being an builtin class, the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} class does not inherit \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource}{Abstract\+Thread\+Resource}} explicitly as a part of the exported API, and the internal \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource_a0431f7384991eaf6900ee3a952b57f87}{Abstract\+Thread\+Resource\+::cleanup()}} method cannot be overridden or suppressed.
\end{DoxyParagraph}
\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}} parse option. 
\end{DoxyNote}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a2cca11879044ef7f40cfa707f1bf3c47}\label{class_qore_1_1_thread_1_1_r_w_lock_a2cca11879044ef7f40cfa707f1bf3c47}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+RWLock\+::constructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{RWLock rwl();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a88a6fefec6f761cf0d72baf2b38cb62b}\label{class_qore_1_1_thread_1_1_r_w_lock_a88a6fefec6f761cf0d72baf2b38cb62b}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!copy@{copy}}
\index{copy@{copy}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+RWLock\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Creates a new \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object, not based on the original. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{RWLock new\_rwl = rwl.copy();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a52ba1405c9bf97c3888cc58bd0d5902a}\label{class_qore_1_1_thread_1_1_r_w_lock_a52ba1405c9bf97c3888cc58bd0d5902a}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+RWLock\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object. 

Note that it is a programming error to delete this object while other threads are blocked on it; in this case an exception is thrown in the deleting thread, and in each thread blocked on this object when it is deleted.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{delete rwl;}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & Object deleted while other threads blocked on it \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_acb76cd08c7aa13854b2174e952efee65}\label{class_qore_1_1_thread_1_1_r_w_lock_acb76cd08c7aa13854b2174e952efee65}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!getReadWaiting@{getReadWaiting}}
\index{getReadWaiting@{getReadWaiting}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{getReadWaiting()}{getReadWaiting()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+RWLock\+::get\+Read\+Waiting (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of threads waiting on the read lock. 

\begin{DoxyReturn}{Returns}
the number of threads waiting on the read lock
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int num = rwl.getReadWaiting();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_ab5f9f093afb74f047051356524e288ff}\label{class_qore_1_1_thread_1_1_r_w_lock_ab5f9f093afb74f047051356524e288ff}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!getWriteWaiting@{getWriteWaiting}}
\index{getWriteWaiting@{getWriteWaiting}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{getWriteWaiting()}{getWriteWaiting()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+RWLock\+::get\+Write\+Waiting (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of threads waiting on the write lock. 

\begin{DoxyReturn}{Returns}
the number of threads waiting on the write lock
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int num = rwl.getWriteWaiting();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_aefcf3643bfe193b7d4b63cef41299ade}\label{class_qore_1_1_thread_1_1_r_w_lock_aefcf3643bfe193b7d4b63cef41299ade}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!lockOwner@{lockOwner}}
\index{lockOwner@{lockOwner}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{lockOwner()}{lockOwner()}}
{\footnotesize\ttfamily bool Qore\+::\+Thread\+::\+RWLock\+::lock\+Owner (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding either the read lock or the write lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding either the read lock or the write lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (rwl.lockOwner())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}TID \%d has either the read lock or the write lock\(\backslash\)n"{}}, q\_gettid());}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a5ae6ade327e6c65430025c653c684f3c}\label{class_qore_1_1_thread_1_1_r_w_lock_a5ae6ade327e6c65430025c653c684f3c}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!numReaders@{numReaders}}
\index{numReaders@{numReaders}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{numReaders()}{numReaders()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+RWLock\+::num\+Readers (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the read lock count. 

\begin{DoxyReturn}{Returns}
the read lock count
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int num = rwl.numReaders();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}\label{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!readLock@{readLock}}
\index{readLock@{readLock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{readLock()}{readLock()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+RWLock\+::read\+Lock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Acquires the read lock; blocks if the write lock is already acquired by another thread. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{rwl.readLock();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em THREAD-\/\+DEADLOCK} & A deadlock was detected while trying to acquire the lock \\
\hline
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}{RWLock\+::read\+Lock()}} called while already holding the write lock, object deleted in another thread, etc. \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a10e4f61ecbb32380ac729217cb6b3161}\label{class_qore_1_1_thread_1_1_r_w_lock_a10e4f61ecbb32380ac729217cb6b3161}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!readLock@{readLock}}
\index{readLock@{readLock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{readLock()}{readLock()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+RWLock\+::read\+Lock (\begin{DoxyParamCaption}\item[{timeout}]{timeout\+\_\+ms }\end{DoxyParamCaption})}



Acquires the read lock with a timeout value; blocks if the write lock is already acquired by another thread. 

Returns 0 for success, non-\/zero for timeout; exceptions are thrown for other errors


\begin{DoxyParams}{Parameters}
{\em timeout\+\_\+ms} & a \mbox{\hyperlink{data_type_declarations_timeout_type}{timeout}} value to wait to acquire the read lock; integers are interpreted as milliseconds; \mbox{\hyperlink{basic_data_types_relative_dates}{relative date/time values}} are interpreted literally (with a resolution of milliseconds); negative timeouts mean wait indefinitely\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
0 for success, non-\/zero for timeout; exceptions are thrown for other errors
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (rwl.readLock(1500ms))}
\DoxyCodeLine{    throw \textcolor{stringliteral}{"{}TIMEOUT"{}}, \textcolor{stringliteral}{"{}timed out after 1.5s waiting for the read lock"{}};}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em THREAD-\/\+DEADLOCK} & A deadlock was detected while trying to acquire the lock \\
\hline
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}{RWLock\+::read\+Lock()}} called while already holding the write lock, object deleted in another thread, etc. \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a362a40fe4d167e29befa94f40e4495e5}\label{class_qore_1_1_thread_1_1_r_w_lock_a362a40fe4d167e29befa94f40e4495e5}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!readLockOwner@{readLockOwner}}
\index{readLockOwner@{readLockOwner}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{readLockOwner()}{readLockOwner()}}
{\footnotesize\ttfamily bool Qore\+::\+Thread\+::\+RWLock\+::read\+Lock\+Owner (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding the read lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding the read lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (rwl.readLockOwner())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}TID \%d has the read lock\(\backslash\)n"{}}, q\_gettid());}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a1a32805ce5cc129d2ed2bf96b01a7d4c}\label{class_qore_1_1_thread_1_1_r_w_lock_a1a32805ce5cc129d2ed2bf96b01a7d4c}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!readUnlock@{readUnlock}}
\index{readUnlock@{readUnlock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{readUnlock()}{readUnlock()}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+RWLock\+::read\+Unlock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Decrements the read lock counter and releases the read lock if the counter is zero. If at least one thread is blocked trying to acquire the write lock and the read counter reaches zero, then one thread waiting on the write lock is woken up. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{rwl.readUnlock();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a1a32805ce5cc129d2ed2bf96b01a7d4c}{RWLock\+::read\+Unlock()}} called while not holding the read lock, object deleted in another thread, etc \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_ae6ae2fb6dadf5d144dbd7694c0ca0bfb}\label{class_qore_1_1_thread_1_1_r_w_lock_ae6ae2fb6dadf5d144dbd7694c0ca0bfb}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!tryReadLock@{tryReadLock}}
\index{tryReadLock@{tryReadLock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{tryReadLock()}{tryReadLock()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+RWLock\+::try\+Read\+Lock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Acquires the read lock only if it can be acquired immediately. 

\begin{DoxyReturn}{Returns}
0 for success (read lock acquired, read lock count incremented) or -\/1 if the call would block (write lock owned by another thread) or an error occured
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (!rwl.tryReadLock()) \{}
\DoxyCodeLine{    on\_exit rwl.readUnlock();}
\DoxyCodeLine{    do\_something\_in\_read\_lock();}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a20b09807edecf2ee7591e90e16c4fe6c}\label{class_qore_1_1_thread_1_1_r_w_lock_a20b09807edecf2ee7591e90e16c4fe6c}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!tryWriteLock@{tryWriteLock}}
\index{tryWriteLock@{tryWriteLock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{tryWriteLock()}{tryWriteLock()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+RWLock\+::try\+Write\+Lock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Acquires the write lock only if it can be acquired immediately. 

\begin{DoxyReturn}{Returns}
0 for success (write lock acquired) or -\/1 if the call would block (read lock owned by another thread) or an error occured 
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (!rwl.tryWriteLock()) \{}
\DoxyCodeLine{    on\_exit rwl.writeUnlock();}
\DoxyCodeLine{    do\_something\_in\_write\_lock();}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a15face42a9f0634de3e2f835f8daa35b}\label{class_qore_1_1_thread_1_1_r_w_lock_a15face42a9f0634de3e2f835f8daa35b}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!writeLock@{writeLock}}
\index{writeLock@{writeLock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{writeLock()}{writeLock()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+RWLock\+::write\+Lock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Acquires the write lock; blocks if the read lock is already acquired by another thread. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{rwl.writeLock();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em THREAD-\/\+DEADLOCK} & A deadlock was detected while trying to acquire the lock \\
\hline
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a15face42a9f0634de3e2f835f8daa35b}{RWLock\+::write\+Lock()}} called while already holding the read lock, object deleted in another thread, etc. \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a0be2f09ba84a3a5fbf3d0073c59f8542}\label{class_qore_1_1_thread_1_1_r_w_lock_a0be2f09ba84a3a5fbf3d0073c59f8542}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!writeLock@{writeLock}}
\index{writeLock@{writeLock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{writeLock()}{writeLock()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+RWLock\+::write\+Lock (\begin{DoxyParamCaption}\item[{timeout}]{timeout\+\_\+ms }\end{DoxyParamCaption})}



Acquires the write lock with a timeout value; blocks if the read lock is already acquired by another thread. 

Returns 0 for success, non-\/zero for timeout; exceptions are thrown for other errors


\begin{DoxyParams}{Parameters}
{\em timeout\+\_\+ms} & a \mbox{\hyperlink{data_type_declarations_timeout_type}{timeout}} value to wait to acquire the write lock; integers are interpreted as milliseconds; \mbox{\hyperlink{basic_data_types_relative_dates}{relative date/time values}} are interpreted literally (with a resolution of milliseconds); negative timeouts mean wait indefinitely\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
0 for success, non-\/zero for timeout; exceptions are thrown for other errors
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (rwl.writeLock(1500ms))}
\DoxyCodeLine{    throw \textcolor{stringliteral}{"{}TIMEOUT"{}}, \textcolor{stringliteral}{"{}timed out after 1.5s waiting for the write lock"{}};}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em THREAD-\/\+DEADLOCK} & A deadlock was detected while trying to acquire the lock \\
\hline
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a15face42a9f0634de3e2f835f8daa35b}{RWLock\+::write\+Lock()}} called while already holding the read lock, object deleted in another thread, etc. \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a5e9c32cc40cd0cb9b00e6d29f265884f}\label{class_qore_1_1_thread_1_1_r_w_lock_a5e9c32cc40cd0cb9b00e6d29f265884f}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!writeLockOwner@{writeLockOwner}}
\index{writeLockOwner@{writeLockOwner}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{writeLockOwner()}{writeLockOwner()}}
{\footnotesize\ttfamily bool Qore\+::\+Thread\+::\+RWLock\+::write\+Lock\+Owner (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding the write lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is holding the write lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (rwl.writeLockOwner())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}TID \%d has the write lock\(\backslash\)n"{}}, q\_gettid());}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_r_w_lock_a577f98df56071f39199c7ace72dc132d}\label{class_qore_1_1_thread_1_1_r_w_lock_a577f98df56071f39199c7ace72dc132d}} 
\index{Qore::Thread::RWLock@{Qore::Thread::RWLock}!writeUnlock@{writeUnlock}}
\index{writeUnlock@{writeUnlock}!Qore::Thread::RWLock@{Qore::Thread::RWLock}}
\doxysubsubsection{\texorpdfstring{writeUnlock()}{writeUnlock()}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+RWLock\+::write\+Unlock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Releases the write lock, if any readers are waiting, wakes up all readers, otherwise if any writers are waiting, then wakes one up. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{rwl.writeUnlock();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a577f98df56071f39199c7ace72dc132d}{RWLock\+::write\+Unlock()}} called while not holding the write lock, object deleted in another thread, etc \\
\hline
\end{DoxyExceptions}
