\hypertarget{class_qore_1_1_thread_1_1_queue}{}\doxysection{Qore\+::Thread\+::Queue Class Reference}
\label{class_qore_1_1_thread_1_1_queue}\index{Qore::Thread::Queue@{Qore::Thread::Queue}}


Queue objects provide a blocking, thread-\/safe message-\/passing object to Qore programs  


\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a33f098d2f9985e5df703ac29e9d5ad9b}{clear}} ()
\begin{DoxyCompactList}\small\item\em Clears the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} of all data. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a49732032b1eeda812640acbaf35cc884}{clear\+Error}} ()
\begin{DoxyCompactList}\small\item\em clears the error setting from the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}; if error information is set, then after this call, the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} is usable again \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_abc3cb4fbf5cdb4cb11b9452ac1dd3d17}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a5062ef1c26bf7f9b9b60197a7032e0b6}{max}}=-\/1)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object. \end{DoxyCompactList}\item 
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_aefdab23261eaa580dce170b927f452f6}\label{class_qore_1_1_thread_1_1_queue_aefdab23261eaa580dce170b927f452f6}} 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_aefdab23261eaa580dce170b927f452f6}{copy}} ()
\begin{DoxyCompactList}\small\item\em Creates a new \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object with the same elements and maximum size as the original. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a050ac26b0f1ba98ee234b3c22c767a6e}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_adbc347a8bc17d1a9aec0dceec5b06cdb}{empty}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} is empty, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a02af5f1f75807fc2d24d18674b508149}{get}} (timeout timeout\+\_\+ms=0)
\begin{DoxyCompactList}\small\item\em Blocks until at least one entry is available on the queue, then returns the first entry in the queue. If a timeout occurs, an exception is thrown. If the timeout value equal to zero, then the call does not timeout until data is available, while negative timeout values cause the call to timeout immediately if the call would otherwise block. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a792fd992775627ea6ef7070058d42977}{get\+Read\+Waiting}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of threads currently blocked on this queue for reading. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a1a476bc740722129ebcc3f266b789c48}{get\+Waiting}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of threads currently blocked on this queue for reading. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_ac120b1234a06cfae782a58db45807d65}{get\+Write\+Waiting}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of threads currently blocked on this queue for writing. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_af0d54fc00d64f026e80685d11119bbfb}{insert}} (auto arg, timeout timeout\+\_\+ms=0)
\begin{DoxyCompactList}\small\item\em Inserts a value at the beginning of the queue. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a5062ef1c26bf7f9b9b60197a7032e0b6}{max}} ()
\begin{DoxyCompactList}\small\item\em Returns the upper limit of the number of elements in the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a2baeae55a0b5464a15aa055577177a7b}{pop}} (timeout timeout\+\_\+ms=0)
\begin{DoxyCompactList}\small\item\em Blocks until at least one entry is available on the queue, then returns the last entry in the queue. If a timeout occurs, an exception is thrown. If the timeout is less than or equal to zero, then the call does not timeout until data is available. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a74cf772cbcf182878b91c729eed2b626}{push}} (auto arg, timeout timeout\+\_\+ms=0)
\begin{DoxyCompactList}\small\item\em Pushes a value on the end of the queue. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_ab55ff73e8143bf963aa2ce62b93d7c7f}{set\+Error}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} err, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} desc)
\begin{DoxyCompactList}\small\item\em sets an error status on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} and clears the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}; while a \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object has an error status, any write operations to the queue will fail and cause an exception to be raised with the information provided to this method \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a10c59ccd413a8bebbe1810938737d066}{size}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of elements in the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
Queue objects provide a blocking, thread-\/safe message-\/passing object to Qore programs 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}}
\end{DoxyParagraph}
Queue objects can also be used as a stack or as a blocking message channel, if a maximum size is given to \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_abc3cb4fbf5cdb4cb11b9452ac1dd3d17}{Queue\+::constructor()}} when the object is created.~\newline
 In this case when the Queue is full, adding new elements to the Queue will block until the Queue shrinks below the maximum size.~\newline
 All read and write methods to Queue also take timeout values; if a timeout occurs a {\ttfamily QUEUE-\/\+TIMEOUT} exception is thrown.

Queues can be atomically flagged with an error status by calling \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_ab55ff73e8143bf963aa2ce62b93d7c7f}{Queue\+::set\+Error()}}. This method will cause any write operations on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} to fail with the error information provided with this call. Calling \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a49732032b1eeda812640acbaf35cc884}{Queue\+::clear\+Error()}} causes the error status to be removed and allows the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} to be usable again.

\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}} parse option 
\end{DoxyNote}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a33f098d2f9985e5df703ac29e9d5ad9b}\label{class_qore_1_1_thread_1_1_queue_a33f098d2f9985e5df703ac29e9d5ad9b}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!clear@{clear}}
\index{clear@{clear}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{clear()}{clear()}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+Queue\+::clear (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Clears the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} of all data. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{queue.clear(); }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
This method does not throw any exceptions, but exceptions could be thrown by in destructors of objects that go out of scope by being removed from the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a49732032b1eeda812640acbaf35cc884}\label{class_qore_1_1_thread_1_1_queue_a49732032b1eeda812640acbaf35cc884}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!clearError@{clearError}}
\index{clearError@{clearError}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{clearError()}{clearError()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Queue\+::clear\+Error (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



clears the error setting from the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}; if error information is set, then after this call, the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} is usable again 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{queue.clearError()}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_ab55ff73e8143bf963aa2ce62b93d7c7f}{set\+Error()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+12 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_abc3cb4fbf5cdb4cb11b9452ac1dd3d17}\label{class_qore_1_1_thread_1_1_queue_abc3cb4fbf5cdb4cb11b9452ac1dd3d17}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Queue\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{max = {\ttfamily -\/1} }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{Queue queue(); }

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em max} & the maximum size of the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}; -\/1 means no limit; if 0 or a negative number other than -\/1 is passed then a {\ttfamily QUEUE-\/\+SIZE-\/\+ERROR} exception will be thrown\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em QUEUE-\/\+SIZE-\/\+ERROR} & the size cannot be zero or any negative number except for -\/1 or a number that cannot fit in 32 bits (signed)\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a5062ef1c26bf7f9b9b60197a7032e0b6}{Queue\+::max()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+4 this method takes a maximum size parameter and can throw exceptions if the parameter is invalid 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a050ac26b0f1ba98ee234b3c22c767a6e}\label{class_qore_1_1_thread_1_1_queue_a050ac26b0f1ba98ee234b3c22c767a6e}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Queue\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object. 

\begin{DoxyNote}{Note}
It is a programming error to delete this object while other threads are blocked on it; in this case an exception is thrown in the deleting thread, and also in each thread blocked on this object when it is deleted
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em QUEUE-\/\+ERROR} & The queue was deleted while at least one thread was blocked on it \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_adbc347a8bc17d1a9aec0dceec5b06cdb}\label{class_qore_1_1_thread_1_1_queue_adbc347a8bc17d1a9aec0dceec5b06cdb}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!empty@{empty}}
\index{empty@{empty}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{empty()}{empty()}}
{\footnotesize\ttfamily bool Qore\+::\+Thread\+::\+Queue\+::empty (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} is empty, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = queue.empty(); }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} is empty, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a10c59ccd413a8bebbe1810938737d066}{Queue\+::size()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a02af5f1f75807fc2d24d18674b508149}\label{class_qore_1_1_thread_1_1_queue_a02af5f1f75807fc2d24d18674b508149}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!get@{get}}
\index{get@{get}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{get()}{get()}}
{\footnotesize\ttfamily auto Qore\+::\+Thread\+::\+Queue\+::get (\begin{DoxyParamCaption}\item[{timeout}]{timeout\+\_\+ms = {\ttfamily 0} }\end{DoxyParamCaption})}



Blocks until at least one entry is available on the queue, then returns the first entry in the queue. If a timeout occurs, an exception is thrown. If the timeout value equal to zero, then the call does not timeout until data is available, while negative timeout values cause the call to timeout immediately if the call would otherwise block. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto data = queue.get();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em timeout\+\_\+ms} & a timeout value to wait for data to become available on the queue; integers are interpreted as milliseconds; relative date/time values are interpreted literally with a maximum resolution of milliseconds. A negative timeout value causes the call to time out immediately with a {\ttfamily QUEUE-\/\+TIMEOUT} exception if the call would otherwise block. If a positive timeout argument is passed, and no data is available in the timeout period, a {\ttfamily \char`\"{}\+QUEUE-\/\+TIMEOUT\char`\"{}} exception is thrown. If no value or a value that converts to integer 0 is passed as the argument, then the call does not timeout until data is available on the queue.\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the first entry on the queue
\end{DoxyReturn}
\begin{DoxyNote}{Note}
This method throws a {\ttfamily \char`\"{}\+QUEUE-\/\+TIMEOUT\char`\"{}} exception on timeout, in order to enable the case where NOTHING was pushed on the queue to be differentiated from a timeout
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em QUEUE-\/\+TIMEOUT} & The timeout value was exceeded \\
\hline
{\em QUEUE-\/\+ERROR} & The queue was deleted while at least one thread was blocked on it \\
\hline
{\em QUEUE-\/\+TIMEOUT-\/\+ERROR} & the timeout value must be $>$= -\/2147483648 and $<$= 2147483647 or this exception is thrown \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a792fd992775627ea6ef7070058d42977}\label{class_qore_1_1_thread_1_1_queue_a792fd992775627ea6ef7070058d42977}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!getReadWaiting@{getReadWaiting}}
\index{getReadWaiting@{getReadWaiting}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{getReadWaiting()}{getReadWaiting()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+Queue\+::get\+Read\+Waiting (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of threads currently blocked on this queue for reading. 

This is a \char`\"{}synonym\char`\"{} for \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a1a476bc740722129ebcc3f266b789c48}{Queue\+::get\+Waiting()}}

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int waiting = queue.numReadWaiting(); }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the number of threads currently blocked on this queue for reading
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_ac120b1234a06cfae782a58db45807d65}{Queue\+::get\+Write\+Waiting()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+4 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a1a476bc740722129ebcc3f266b789c48}\label{class_qore_1_1_thread_1_1_queue_a1a476bc740722129ebcc3f266b789c48}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!getWaiting@{getWaiting}}
\index{getWaiting@{getWaiting}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{getWaiting()}{getWaiting()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+Queue\+::get\+Waiting (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of threads currently blocked on this queue for reading. 

This is a \char`\"{}synonym\char`\"{} for \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a792fd992775627ea6ef7070058d42977}{Queue\+::get\+Read\+Waiting()}}

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int waiting = queue.numWaiting(); }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the number of threads currently blocked on this queue for reading
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_ac120b1234a06cfae782a58db45807d65}{Queue\+::get\+Write\+Waiting()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_ac120b1234a06cfae782a58db45807d65}\label{class_qore_1_1_thread_1_1_queue_ac120b1234a06cfae782a58db45807d65}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!getWriteWaiting@{getWriteWaiting}}
\index{getWriteWaiting@{getWriteWaiting}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{getWriteWaiting()}{getWriteWaiting()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+Queue\+::get\+Write\+Waiting (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of threads currently blocked on this queue for writing. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int waiting = queue.getWriteWaiting(); }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the number of threads currently blocked on this queue for writing
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a792fd992775627ea6ef7070058d42977}{Queue\+::get\+Read\+Waiting()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+4 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_af0d54fc00d64f026e80685d11119bbfb}\label{class_qore_1_1_thread_1_1_queue_af0d54fc00d64f026e80685d11119bbfb}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!insert@{insert}}
\index{insert@{insert}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{insert()}{insert()}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+Queue\+::insert (\begin{DoxyParamCaption}\item[{auto}]{arg,  }\item[{timeout}]{timeout\+\_\+ms = {\ttfamily 0} }\end{DoxyParamCaption})}



Inserts a value at the beginning of the queue. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{queue.insert(value); }

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em arg} & value to be put on the queue \\
\hline
{\em timeout\+\_\+ms} & a timeout value to wait for a free entry to become available on the queue; integers are interpreted as milliseconds; relative date/time values are interpreted literally with a maximum resolution of milliseconds. A negative timeout value causes the call to time out immediately with a {\ttfamily QUEUE-\/\+TIMEOUT} exception if the call would otherwise block. If a positive timeout argument is passed, and the queue has already reached its maximum size and does not go below the maximum size within the timeout period, a {\ttfamily \char`\"{}\+QUEUE-\/\+TIMEOUT\char`\"{}} exception is thrown. If no value or a value that converts to integer 0 is passed as the argument, then the call does not timeout until a slot becomes available on the queue. \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} slots are only limited if a maximum size is passed to \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_abc3cb4fbf5cdb4cb11b9452ac1dd3d17}{Queue\+::constructor()}}.\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em QUEUE-\/\+TIMEOUT} & The timeout value was exceeded \\
\hline
{\em QUEUE-\/\+ERROR} & The queue was deleted while at least one thread was blocked on it \\
\hline
{\em QUEUE-\/\+TIMEOUT-\/\+ERROR} & the timeout value must be $>$= -\/2147483648 and $<$= 2147483647 or this exception is thrown\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+4 this method takes a timeout parameter 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a5062ef1c26bf7f9b9b60197a7032e0b6}\label{class_qore_1_1_thread_1_1_queue_a5062ef1c26bf7f9b9b60197a7032e0b6}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!max@{max}}
\index{max@{max}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{max()}{max()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+Queue\+::max (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the upper limit of the number of elements in the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int max = queue.max(); }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the upper limit of the number of elements in the Queu
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a10c59ccd413a8bebbe1810938737d066}{Queue\+::size()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a2baeae55a0b5464a15aa055577177a7b}\label{class_qore_1_1_thread_1_1_queue_a2baeae55a0b5464a15aa055577177a7b}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!pop@{pop}}
\index{pop@{pop}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{pop()}{pop()}}
{\footnotesize\ttfamily auto Qore\+::\+Thread\+::\+Queue\+::pop (\begin{DoxyParamCaption}\item[{timeout}]{timeout\+\_\+ms = {\ttfamily 0} }\end{DoxyParamCaption})}



Blocks until at least one entry is available on the queue, then returns the last entry in the queue. If a timeout occurs, an exception is thrown. If the timeout is less than or equal to zero, then the call does not timeout until data is available. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto data = queue.pop(); }

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em timeout\+\_\+ms} & a timeout value to wait for data to become available on the queue; integers are interpreted as milliseconds; relative date/time values are interpreted literally with a maximum resolution of milliseconds. A negative timeout value causes the call to time out immediately with a {\ttfamily QUEUE-\/\+TIMEOUT} exception if the call would otherwise block. If a positive timeout argument is passed, and no data is available in the timeout period, a {\ttfamily \char`\"{}\+QUEUE-\/\+TIMEOUT\char`\"{}} exception is thrown. If no value or a value that converts to integer 0 is passed as the argument, then the call does not timeout until data is available on the queue.\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the last entry on the queue
\end{DoxyReturn}
\begin{DoxyNote}{Note}
This method throws a {\ttfamily \char`\"{}\+QUEUE-\/\+TIMEOUT\char`\"{}} exception on timeout, in order to enable the case where NOTHING was pushed on the queue to be differentiated from a timeout
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em QUEUE-\/\+TIMEOUT} & The timeout value was exceeded \\
\hline
{\em QUEUE-\/\+ERROR} & The queue was deleted while at least one thread was blocked on it \\
\hline
{\em QUEUE-\/\+TIMEOUT-\/\+ERROR} & the timeout value must be $>$= -\/2147483648 and $<$= 2147483647 or this exception is thrown \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a74cf772cbcf182878b91c729eed2b626}\label{class_qore_1_1_thread_1_1_queue_a74cf772cbcf182878b91c729eed2b626}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!push@{push}}
\index{push@{push}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{push()}{push()}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+Queue\+::push (\begin{DoxyParamCaption}\item[{auto}]{arg,  }\item[{timeout}]{timeout\+\_\+ms = {\ttfamily 0} }\end{DoxyParamCaption})}



Pushes a value on the end of the queue. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{queue.push(value); }

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em arg} & value to be put on the queue \\
\hline
{\em timeout\+\_\+ms} & a timeout value to wait for a free entry to become available on the queue; integers are interpreted as milliseconds; relative date/time values are interpreted literally with a maximum resolution of milliseconds. A negative timeout value causes the call to time out immediately with a {\ttfamily QUEUE-\/\+TIMEOUT} exception if the call would otherwise block. If a positive timeout argument is passed, and the queue has already reached its maximum size and does not go below the maximum size within the timeout period, a {\ttfamily \char`\"{}\+QUEUE-\/\+TIMEOUT\char`\"{}} exception is thrown. If no value or a value that converts to integer 0 is passed as the argument, then the call does not timeout until a slot becomes available on the queue. \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} slots are only limited if a maximum size is passed to \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_abc3cb4fbf5cdb4cb11b9452ac1dd3d17}{Queue\+::constructor()}}.\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em QUEUE-\/\+TIMEOUT} & The timeout value was exceeded \\
\hline
{\em QUEUE-\/\+ERROR} & The queue was deleted while at least one thread was blocked on it \\
\hline
{\em QUEUE-\/\+TIMEOUT-\/\+ERROR} & the timeout value must be $>$= -\/2147483648 and $<$= 2147483647 or this exception is thrown\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+4 this method takes a timeout parameter 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_ab55ff73e8143bf963aa2ce62b93d7c7f}\label{class_qore_1_1_thread_1_1_queue_ab55ff73e8143bf963aa2ce62b93d7c7f}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!setError@{setError}}
\index{setError@{setError}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{setError()}{setError()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Queue\+::set\+Error (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{err,  }\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{desc }\end{DoxyParamCaption})}



sets an error status on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} and clears the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}; while a \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object has an error status, any write operations to the queue will fail and cause an exception to be raised with the information provided to this method 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{queue.setError(\textcolor{stringliteral}{"{}INVALID-\/OPERATION"{}}, \textcolor{stringliteral}{"{}the data queue has been closed"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em err} & the exception error code string \\
\hline
{\em desc} & the exception description string\\
\hline
\end{DoxyParams}
Any threads blocked on this \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} will be woken up immediately and have the given exception thrown

\begin{DoxyNote}{Note}
This method does not throw any exceptions, but exceptions could be thrown by in destructors of objects that go out of scope by being removed from the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a49732032b1eeda812640acbaf35cc884}{clear\+Error()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+12 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_queue_a10c59ccd413a8bebbe1810938737d066}\label{class_qore_1_1_thread_1_1_queue_a10c59ccd413a8bebbe1810938737d066}} 
\index{Qore::Thread::Queue@{Qore::Thread::Queue}!size@{size}}
\index{size@{size}!Qore::Thread::Queue@{Qore::Thread::Queue}}
\doxysubsubsection{\texorpdfstring{size()}{size()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+Queue\+::size (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of elements in the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int size = queue.size(); }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the number of elements in the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}}
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue_a5062ef1c26bf7f9b9b60197a7032e0b6}{Queue\+::max()}} 
\end{DoxySeeAlso}
