\hypertarget{class_qore_1_1_thread_1_1_auto_lock}{}\doxysection{Qore\+::Thread\+::Auto\+Lock Class Reference}
\label{class_qore_1_1_thread_1_1_auto_lock}\index{Qore::Thread::AutoLock@{Qore::Thread::AutoLock}}


A helper class for the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} class for exception-\/safe \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} handling.  


\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock_aca26bade37a4031d8e737a2909b71925}{constructor}} (\mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} mutex)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object based on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} argument passed and immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a0bb3432456ccdf0cfb1523429b5b4141}{Mutex\+::lock()}} \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock_a070b15110c43a07ce8285fb8cbc14c66}{copy}} ()
\begin{DoxyCompactList}\small\item\em Throws an exception; objects of this class cannot be copied. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock_a696bbcabef26a7e5996dee393fdd195d}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a23adbdd9cd3ffe17b1cbc700716aec5c}{Mutex\+::unlock()}} on the saved \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object and destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock_a5d121795cc06f8595db354dc9c70f2b0}{lock}} ()
\begin{DoxyCompactList}\small\item\em Attempts to relock the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object being managed. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock_ab016e55812b0814fedce775ea018f8ff}{trylock}} ()
\begin{DoxyCompactList}\small\item\em Attempts to relock the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object being managed; acquires the lock only if it is not already held; returns 0 for success (lock acquired) or -\/1 if the call would block. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock_a58f51c6a591688e031eb1a8981ca2e55}{unlock}} ()
\begin{DoxyCompactList}\small\item\em Unlocks the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object being managed; wakes up one thread if any threads are blocked on this lock. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
A helper class for the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} class for exception-\/safe \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} handling. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}}
\end{DoxyParagraph}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} objects, when used along with a \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object, allow Qore programmers to safely acquire and release a \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} lock, even if exceptions are thrown or \mbox{\hyperlink{statements_return}{return statements}} are executed in the block where the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object is created.

\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} objects are helper objects that acquire a \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} for the lifetime of the object.

For this reason, it is only appropriate to assign an \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object to a local variable, so when the local variable goes out of scope, the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object will be deleted and the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} will be automatically released.

For example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{our Mutex mutex();}
\DoxyCodeLine{}
\DoxyCodeLine{sub check\_error(error) \{}
\DoxyCodeLine{    \textcolor{comment}{\# note that the Mutex is acquired in the AutoLock constructor, and}}
\DoxyCodeLine{    \textcolor{comment}{\# the Mutex will be released as soon as the block is exited below.}}
\DoxyCodeLine{    \textcolor{comment}{\# (with either the throw statement or the return statement)}}
\DoxyCodeLine{    AutoLock al(mutex);}
\DoxyCodeLine{    \textcolor{keywordflow}{if} (error)}
\DoxyCodeLine{        throw \textcolor{stringliteral}{"{}ERROR"{}}, \textcolor{stringliteral}{"{}sorry, an error happened"{}};}
\DoxyCodeLine{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} \textcolor{stringliteral}{"{}OK"{}};}
\DoxyCodeLine{\}}

\end{DoxyCode}


The destructor will call \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a23adbdd9cd3ffe17b1cbc700716aec5c}{Mutex\+::unlock()}} only if the current thread owns the lock, so it is safe to unlock the lock manually (or by calling \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock_a58f51c6a591688e031eb1a8981ca2e55}{Auto\+Lock\+::unlock()}}) while the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object is in scope.

\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}} parse option. 
\end{DoxyNote}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_lock_aca26bade37a4031d8e737a2909b71925}\label{class_qore_1_1_thread_1_1_auto_lock_aca26bade37a4031d8e737a2909b71925}} 
\index{Qore::Thread::AutoLock@{Qore::Thread::AutoLock}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::Thread::AutoLock@{Qore::Thread::AutoLock}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Lock\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}}}]{mutex }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object based on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} argument passed and immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a0bb3432456ccdf0cfb1523429b5b4141}{Mutex\+::lock()}} 

The \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a0bb3432456ccdf0cfb1523429b5b4141}{Mutex\+::lock()}} on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object passed, and saves it; \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a23adbdd9cd3ffe17b1cbc700716aec5c}{Mutex\+::unlock()}} is called in the destructor if the lock is still held by the current thread.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\{}
\DoxyCodeLine{    \textcolor{comment}{\# when the block exits, the lock is automatically released}}
\DoxyCodeLine{    AutoLock al(mutex);}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em mutex} & a \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object to lock immediately and hold for the scope of the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object (unless manually unlocked)\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & lock called twice in the same thread, \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object has already been deleted in another thread, etc \\
\hline
{\em THREAD-\/\+DEADLOCK} & a deadlock was detected while trying to acquire the lock \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_lock_a070b15110c43a07ce8285fb8cbc14c66}\label{class_qore_1_1_thread_1_1_auto_lock_a070b15110c43a07ce8285fb8cbc14c66}} 
\index{Qore::Thread::AutoLock@{Qore::Thread::AutoLock}!copy@{copy}}
\index{copy@{copy}!Qore::Thread::AutoLock@{Qore::Thread::AutoLock}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Lock\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Throws an exception; objects of this class cannot be copied. 


\begin{DoxyExceptions}{Exceptions}
{\em AUTOLOCK-\/\+COPY-\/\+ERROR} & Objects of this class cannot be copied \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_lock_a696bbcabef26a7e5996dee393fdd195d}\label{class_qore_1_1_thread_1_1_auto_lock_a696bbcabef26a7e5996dee393fdd195d}} 
\index{Qore::Thread::AutoLock@{Qore::Thread::AutoLock}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::Thread::AutoLock@{Qore::Thread::AutoLock}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Lock\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a23adbdd9cd3ffe17b1cbc700716aec5c}{Mutex\+::unlock()}} on the saved \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object and destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_lock}{Auto\+Lock}} object. 

\mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex_a23adbdd9cd3ffe17b1cbc700716aec5c}{Mutex\+::unlock()}} is only called if the current thread owns the lock

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{delete al;}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_lock_a5d121795cc06f8595db354dc9c70f2b0}\label{class_qore_1_1_thread_1_1_auto_lock_a5d121795cc06f8595db354dc9c70f2b0}} 
\index{Qore::Thread::AutoLock@{Qore::Thread::AutoLock}!lock@{lock}}
\index{lock@{lock}!Qore::Thread::AutoLock@{Qore::Thread::AutoLock}}
\doxysubsubsection{\texorpdfstring{lock()}{lock()}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+Auto\+Lock\+::lock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Attempts to relock the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object being managed. 

Do not call this method unless the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object being managed has been unlocked since the constructor

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{al.lock();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & lock called twice in the same thread, \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object has already been deleted in another thread, etc \\
\hline
{\em THREAD-\/\+DEADLOCK} & a deadlock was detected while trying to acquire the lock \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_lock_ab016e55812b0814fedce775ea018f8ff}\label{class_qore_1_1_thread_1_1_auto_lock_ab016e55812b0814fedce775ea018f8ff}} 
\index{Qore::Thread::AutoLock@{Qore::Thread::AutoLock}!trylock@{trylock}}
\index{trylock@{trylock}!Qore::Thread::AutoLock@{Qore::Thread::AutoLock}}
\doxysubsubsection{\texorpdfstring{trylock()}{trylock()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+Auto\+Lock\+::trylock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Attempts to relock the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object being managed; acquires the lock only if it is not already held; returns 0 for success (lock acquired) or -\/1 if the call would block. 

\begin{DoxyReturn}{Returns}
0 for success (lock acquired) or -\/1 if the call would block (lock not acquired because it\textquotesingle{}s held by another thread)
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = al.trylock();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & object deleted in another thread, etc \\
\hline
{\em THREAD-\/\+DEADLOCK} & a deadlock was detected while trying to acquire the lock \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_lock_a58f51c6a591688e031eb1a8981ca2e55}\label{class_qore_1_1_thread_1_1_auto_lock_a58f51c6a591688e031eb1a8981ca2e55}} 
\index{Qore::Thread::AutoLock@{Qore::Thread::AutoLock}!unlock@{unlock}}
\index{unlock@{unlock}!Qore::Thread::AutoLock@{Qore::Thread::AutoLock}}
\doxysubsubsection{\texorpdfstring{unlock()}{unlock()}}
{\footnotesize\ttfamily nothing Qore\+::\+Thread\+::\+Auto\+Lock\+::unlock (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Unlocks the \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} object being managed; wakes up one thread if any threads are blocked on this lock. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{al.unlock();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & unlock called by a thread that does not own the lock or the lock is not locked, object deleted in another thread, etc \\
\hline
\end{DoxyExceptions}
