\hypertarget{class_qore_1_1_thread_1_1_auto_gate}{}\doxysection{Qore\+::Thread\+::Auto\+Gate Class Reference}
\label{class_qore_1_1_thread_1_1_auto_gate}\index{Qore::Thread::AutoGate@{Qore::Thread::AutoGate}}


A helper class for the \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} class for exception-\/safe \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} handling.  


\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate_abab67441d7e71ebd9ca18ea55bc77de9}{constructor}} (\mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} gate)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object based on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} argument passed and immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate_a84af8317ea5b6fb634ad03342d1738ee}{Gate\+::enter()}} \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate_a516e31337a00c944e12d6c23e832cbf3}{copy}} ()
\begin{DoxyCompactList}\small\item\em Throws an exception; objects of this class cannot be copied. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate_a561b13b3d0b50ef2815fcf73c69b99f3}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate_aec16df9e3c8a030c12e2c3791263d3e7}{Gate\+::exit()}} and destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
A helper class for the \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} class for exception-\/safe \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} handling. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}}
\end{DoxyParagraph}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} objects, when used along with a \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} object, allow Qore programmers to safely enter and exit a \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} lock, even if exceptions are thrown or return statements are executed in the block where the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object is created.

\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} objects enter the gate lock for the lifetime of the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object. For this reason, it is only appropriate to assign an \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object to a local variable, so when the local variable goes out of scope, the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object will be deleted and the gate automatically exited.

For example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{our Gate gate();}
\DoxyCodeLine{}
\DoxyCodeLine{sub check\_error(error) \{}
\DoxyCodeLine{    \textcolor{comment}{\# note that the Gate is entered in the AutoGate constructor, and}}
\DoxyCodeLine{    \textcolor{comment}{\# the Gate will be exited as soon as the block is exited below.}}
\DoxyCodeLine{    \textcolor{comment}{\# (with either the throw statement or the return statement)}}
\DoxyCodeLine{    AutoGate ag(gate);}
\DoxyCodeLine{    \textcolor{keywordflow}{if} (error)}
\DoxyCodeLine{        throw \textcolor{stringliteral}{"{}ERROR"{}}, \textcolor{stringliteral}{"{}sorry, an error happened"{}};}
\DoxyCodeLine{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} \textcolor{stringliteral}{"{}OK"{}};}
\DoxyCodeLine{\}}

\end{DoxyCode}


\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}} parse option. 
\end{DoxyNote}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_gate_abab67441d7e71ebd9ca18ea55bc77de9}\label{class_qore_1_1_thread_1_1_auto_gate_abab67441d7e71ebd9ca18ea55bc77de9}} 
\index{Qore::Thread::AutoGate@{Qore::Thread::AutoGate}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::Thread::AutoGate@{Qore::Thread::AutoGate}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Gate\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}}}]{gate }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object based on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} argument passed and immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate_a84af8317ea5b6fb634ad03342d1738ee}{Gate\+::enter()}} 


\begin{DoxyParams}{Parameters}
{\em gate} & the \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate}{Gate}} object to enter for the lifetime of the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object \\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{AutoGate ag(gate);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_gate_a516e31337a00c944e12d6c23e832cbf3}\label{class_qore_1_1_thread_1_1_auto_gate_a516e31337a00c944e12d6c23e832cbf3}} 
\index{Qore::Thread::AutoGate@{Qore::Thread::AutoGate}!copy@{copy}}
\index{copy@{copy}!Qore::Thread::AutoGate@{Qore::Thread::AutoGate}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Gate\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Throws an exception; objects of this class cannot be copied. 


\begin{DoxyExceptions}{Exceptions}
{\em AUTOGATE-\/\+COPY-\/\+ERROR} & objects of this class cannot be copied \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_gate_a561b13b3d0b50ef2815fcf73c69b99f3}\label{class_qore_1_1_thread_1_1_auto_gate_a561b13b3d0b50ef2815fcf73c69b99f3}} 
\index{Qore::Thread::AutoGate@{Qore::Thread::AutoGate}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::Thread::AutoGate@{Qore::Thread::AutoGate}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Gate\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_gate_aec16df9e3c8a030c12e2c3791263d3e7}{Gate\+::exit()}} and destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_gate}{Auto\+Gate}} object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{delete ag;}

\end{DoxyCode}
 
\end{DoxyParagraph}
