\hypertarget{class_qore_1_1_stream_base}{}\doxysection{Qore\+::Stream\+Base Class Reference}
\label{class_qore_1_1_stream_base}\index{Qore::StreamBase@{Qore::StreamBase}}


This class defines the API for single thread streams.  




Inheritance diagram for Qore\+::Stream\+Base\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_stream_base_ae1c3dbffc3da7bdc8e16e8ad41302552}{constructor}} ()
\begin{DoxyCompactList}\small\item\em Throws an exception if called directly; this class can only be instantiated by builtin subclasses. \end{DoxyCompactList}\item 
\mbox{\Hypertarget{class_qore_1_1_stream_base_aa128f829e31f09eacdff07b4ae1c5a07}\label{class_qore_1_1_stream_base_aa128f829e31f09eacdff07b4ae1c5a07}} 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_stream_base_aa128f829e31f09eacdff07b4ae1c5a07}{get\+Thread\+Id}} ()
\begin{DoxyCompactList}\small\item\em Get the currently assigned thread id or -\/1 if not assigned to any thread. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{reassign\+Thread}} ()
\begin{DoxyCompactList}\small\item\em Reassigns current thread as thread used for stream manipulation. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{unassign\+Thread}} ()
\begin{DoxyCompactList}\small\item\em Unassigns current thread as thread used for stream manipulation. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
This class defines the API for single thread streams. 

Base class for stream classes which are not designed to be accessed from multiple threads; they have been implemented without locking for fast and efficient use when used from a single thread. For methods that would be unsafe to use in another thread, any use of such methods in threads other than the thread where the constructor was called will cause a {\ttfamily STREAM-\/\+THREAD-\/\+ERROR} to be thrown, unless the stream is handed off to another thread using the \mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{Stream\+Base\+::unassign\+Thread()}} method in the thread that currently owns the stream, and the \mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{Stream\+Base\+::reassign\+Thread()}} method in the new thread.

\begin{DoxySince}{Since}
Qore 0.\+9 
\end{DoxySince}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_stream_base_ae1c3dbffc3da7bdc8e16e8ad41302552}\label{class_qore_1_1_stream_base_ae1c3dbffc3da7bdc8e16e8ad41302552}} 
\index{Qore::StreamBase@{Qore::StreamBase}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::StreamBase@{Qore::StreamBase}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Stream\+Base\+::constructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Throws an exception if called directly; this class can only be instantiated by builtin subclasses. 


\begin{DoxyExceptions}{Exceptions}
{\em STREAMBASE-\/\+CONSTRUCTOR-\/\+ERROR} & this exception is thrown if this class is constructed directly (also if directly inherited by user classes) \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}\label{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}} 
\index{Qore::StreamBase@{Qore::StreamBase}!reassignThread@{reassignThread}}
\index{reassignThread@{reassignThread}!Qore::StreamBase@{Qore::StreamBase}}
\doxysubsubsection{\texorpdfstring{reassignThread()}{reassignThread()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Base\+::reassign\+Thread (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Reassigns current thread as thread used for stream manipulation. 

This method must be called from the new thread after calling the \mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{Stream\+Base\+::unassign\+Thread()}} method in the thread that currently owns the stream


\begin{DoxyExceptions}{Exceptions}
{\em STREAM-\/\+THREAD-\/\+ERROR} & thrown if called when the stream is assigned to another thread\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{Stream\+Base\+::unassign\+Thread()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}\label{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}} 
\index{Qore::StreamBase@{Qore::StreamBase}!unassignThread@{unassignThread}}
\index{unassignThread@{unassignThread}!Qore::StreamBase@{Qore::StreamBase}}
\doxysubsubsection{\texorpdfstring{unassignThread()}{unassignThread()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Base\+::unassign\+Thread (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Unassigns current thread as thread used for stream manipulation. 

This method must be called in the current thread that owns the stream before calling the \mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{Stream\+Base\+::reassign\+Thread()}} method in the new thread


\begin{DoxyExceptions}{Exceptions}
{\em STREAM-\/\+THREAD-\/\+ERROR} & thrown if called when the stream is assigned to another thread\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{Stream\+Base\+::reassign\+Thread()}} 
\end{DoxySeeAlso}
