\hypertarget{class_qore_1_1_s_q_l_1_1_datasource}{}\doxysection{Qore\+::SQL\+::Datasource Class Reference}
\label{class_qore_1_1_s_q_l_1_1_datasource}\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}}


This class provides the Qore interface to databases.  




Inheritance diagram for Qore\+::SQL\+::Datasource\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{begin\+Transaction}} ()
\begin{DoxyCompactList}\small\item\em Manually grabs the transaction lock. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ac9a78046de816a73c17ced8195e6e2eb}{clear\+Event\+Queue}} ()
\begin{DoxyCompactList}\small\item\em Clears the queue object for DBI events on the datasource. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a5048534538ce825624d4be475e09774c}{close}} ()
\begin{DoxyCompactList}\small\item\em Closes the connection to the database; if any actions are in progress on the database, the close call will block until the actions complete. If any errors are encountered, an exception is raised. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ab70fe02e890112a4449f0340ef7cc335}{commit}} ()
\begin{DoxyCompactList}\small\item\em Commits the current transaction and releases the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_transaction_lock}{transaction lock}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a293894c31d423aaadefc6f1a7f188d31}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} driver, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} user, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} pass, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} db, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} encoding, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} host, \+\_\+\+\_\+7\+\_\+ softint port, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ options, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}} queue, auto arg)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object; attempts to load a DBI driver if the driver is not already present in Qore. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ad4729c1b5bbe81448527f1b182a08a34}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} desc, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}} queue, auto arg)
\begin{DoxyCompactList}\small\item\em Creates a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object from a single string giving all parameters that can be parsed by \mbox{\hyperlink{group__old__dbi__functions_ga6c3dab42570887656fc05f5a22eb370a}{parse\+\_\+datasource()}} \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a5f225523817d0a2d01e68c9aaa40a83a}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ opts, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}} queue, auto arg)
\begin{DoxyCompactList}\small\item\em Creates a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object from a hash argument giving parameters for the constructor. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a196d09ba7c9e3cb9e6a228593152b5fd}{copy}} ()
\begin{DoxyCompactList}\small\item\em Creates a new \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object with the same driver as the original and copies of all the connection parameters. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a5661e26369193015c195166e52c6d121}{current\+Thread\+In\+Transaction}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is in a transaction (i.\+e. holds the transaction lock), \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ac9768f90d91a866ee3ef7580cedb3667}{describe}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql,...)
\begin{DoxyCompactList}\small\item\em Executes an SQL select statement on the server and returns a description of the result set as a hash. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a420a865a5ef78ddc110f90529a5b7967}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Closes the datasource if it\textquotesingle{}s open (if any operations are in progress, will block until the operations complete) and destroys the object. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}{exec}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql,...)
\begin{DoxyCompactList}\small\item\em Grabs the transaction lock (if autocommit is disabled) and executes an SQL command on the server and returns either the integer row count (for example, for updates, inserts, and deletes) or the data retrieved (for example, if a stored procedure is executed that returns values). \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a4ec5865609884af9b0498a7f45b1042f}{exec\+Raw}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql)
\begin{DoxyCompactList}\small\item\em Grabs the transaction lock (if autocommit is disabled) and executes an SQL command on the server and returns either the row count (for example, for updates and inserts) or the data retrieved (for example, if a stored procedure is executed that returns values) \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a4b4bbaca92649d27b858fb0996dc86fd}{get\+Auto\+Commit}} ()
\begin{DoxyCompactList}\small\item\em Returns the autocommit status for the object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_add2d683039a2bc2b01df63621b698e6e}{get\+Capabilities}} ()
\begin{DoxyCompactList}\small\item\em Returns an integer bitfield of DBI driver capabilities. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_af3679df85414880b19537ad0ee9d0ad7}{get\+Capability\+List}} ()
\begin{DoxyCompactList}\small\item\em Returns a list of strings giving the capabilities of the current DBI driver. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a0074fed1b53e9b94f811f3b8481b1df4}{get\+Client\+Version}} ()
\begin{DoxyCompactList}\small\item\em Retrieves the driver-\/specific client library version information; this method may not be implemented for all drivers. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a8291b3c3010a8c0d1522afeaa3411a02}{get\+Config\+Hash}} ()
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{group__dbi__functions_datasource_hash}{datasource hash}} describing the configuration of the current object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a7713f26c809821a7942a60e27f924742}{get\+Config\+String}} ()
\begin{DoxyCompactList}\small\item\em Returns a string giving the configuration of the current object in a format that can be parsed by \mbox{\hyperlink{group__old__dbi__functions_ga6c3dab42570887656fc05f5a22eb370a}{parse\+\_\+datasource()}} \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ad25c7a0e752c9ad8a51b92d260a86fe5}{get\+DBCharset}} ()
\begin{DoxyCompactList}\small\item\em Retrieves the database-\/specific charset set encoding for the current connection. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_af898e46c3bc2498ae858d3f98fb23eb3}{get\+DBEncoding}} ()
\begin{DoxyCompactList}\small\item\em Retrieves the database-\/specific charset set encoding for the current connection. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aa0084434a2631b776ce4cfa7075e5f01}{get\+DBName}} ()
\begin{DoxyCompactList}\small\item\em Returns the database name parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aff2f886f27e033dd2bdcc49c22b2cd65}{get\+Driver\+Name}} ()
\begin{DoxyCompactList}\small\item\em Returns the name of the driver used for the object. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a103526f8e3e4e0783523f3af89047190}{get\+Host\+Name}} ()
\begin{DoxyCompactList}\small\item\em Returns the hostname parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a86bf7ff6686300ebcd270b3d09f508c9}{get\+OSCharset}} ()
\begin{DoxyCompactList}\small\item\em Returns the Qore character encoding name for the current connection as a string or {\ttfamily \char`\"{}(unknown)\char`\"{}} if none is set. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aae5a12ff32342c13df0cee4503e2f898}{get\+OSEncoding}} ()
\begin{DoxyCompactList}\small\item\em Returns the Qore character encoding name for the current connection as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a34834d2da5e1e8f13949810e76a6e1cd}{get\+Option}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} opt)
\begin{DoxyCompactList}\small\item\em Returns the current value for the given option. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ac78f3f07aff86117dbe3808b5d2d7757}{get\+Option\+Hash}} ()
\begin{DoxyCompactList}\small\item\em returns the valid options for the driver associated with the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} with descriptions and current values for the current \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ae8ecfbacb0245d1c2e5118352cfe9edb}{get\+Password}} ()
\begin{DoxyCompactList}\small\item\em Returns the password parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ad8c4bde5992da775c95bd8b2a3340e19}{get\+Port}} ()
\begin{DoxyCompactList}\small\item\em Gets the port number that will be used for the next connection to the server. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement}{Abstract\+SQLStatement}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a39ef1a8bff15788d039672359c28772e}{get\+SQLStatement}} ()
\begin{DoxyCompactList}\small\item\em Returns an \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement}{Abstract\+SQLStatement}} object based on the current database connection object. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a35340d8cbadc2eb5b20ab9d8e0fc87eb}{get\+Server\+Version}} ()
\begin{DoxyCompactList}\small\item\em Returns the driver-\/specific server version data for the current connection. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aadc509c6ff4daba5f528163ffd8e05dc}{get\+Transaction\+Lock\+Timeout}} ()
\begin{DoxyCompactList}\small\item\em Retrieves the transaction lock timeout value as an integer in milliseconds. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a0b9c482becfbe8349a75e5a55370f88c}{get\+User\+Name}} ()
\begin{DoxyCompactList}\small\item\em Returns the username parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_af74cb806c9e19c6099c0d2cce84a44ab}{in\+Transaction}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if a transaction is currently in progress, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aa6a07369dd7563f1db552588f41e02e7}{open}} ()
\begin{DoxyCompactList}\small\item\em Opens a connection to the datasouce, using the connection parameters already set; an exception is thrown if any errors occur. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a4c8ae5e2b2d6c1386525eeb019abfb9b}{reset}} ()
\begin{DoxyCompactList}\small\item\em Closes and reopens the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}}. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_acdc71e3819dbc3bf8be24d60e75e7bb2}{rollback}} ()
\begin{DoxyCompactList}\small\item\em Rolls the current transaction back and releases the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_transaction_lock}{transaction lock}}. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{select}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql,...)
\begin{DoxyCompactList}\small\item\em Executes an SQL select statement on the server and returns the result as a hash (column names) of lists (column values per row) \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a11f5fdffd9031ba2d0bf6b8c8b447314}{select\+Row}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql,...)
\begin{DoxyCompactList}\small\item\em Executes an SQL select statement on the server and returns the first row as a hash (the column values) \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}{select\+Rows}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql,...)
\begin{DoxyCompactList}\small\item\em Executes an SQL select statement on the server and returns the result as a list (rows) of hashes (the column values) \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a5c9bf476b32eb9394e90c252504889f0}{set\+Auto\+Commit}} (bool ac=\mbox{\hyperlink{group__boolean__constants_ga3ba2df91713a6249449347131ea526c3}{True}})
\begin{DoxyCompactList}\small\item\em Turns autocommit on or off for this object. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aa7559279ad45047f842fb9f9af7a025b}{set\+DBCharset}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} encoding)
\begin{DoxyCompactList}\small\item\em Sets the database-\/specific character encoding name for the next connection to the server. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a6b6b1e6098b0028a872b045ea3d811b8}{set\+DBEncoding}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} encoding)
\begin{DoxyCompactList}\small\item\em Sets the database-\/specific character encoding name for the next connection to the server. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aaf2c93ad25bf3046a1a6b230f6482665}{set\+DBName}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} db)
\begin{DoxyCompactList}\small\item\em Sets the database name parameter for the time a connection to the server is established. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ad4953ced1fde3271c67b0dc838756ebf}{set\+Event\+Queue}} (\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}} queue, auto arg)
\begin{DoxyCompactList}\small\item\em Sets a queue object for DBI events on the datasource. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a264ea9b1a20197fb4b9c2eaa972af7f3}{set\+Host\+Name}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} host)
\begin{DoxyCompactList}\small\item\em Sets the hostname to use for the next connection to the server. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ad64b2409e602054d6e29257442b8601e}{set\+Option}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} opt, auto val)
\begin{DoxyCompactList}\small\item\em sets an option for the datasource \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a1ecea098e3d8f0d256f088f85d8e4ae4}{set\+Password}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} pass)
\begin{DoxyCompactList}\small\item\em Sets the password parameter for the time a connection to the server is established. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a9c1dee4070b3ac1998bad8294307628b}{set\+Port}} (softint port=0)
\begin{DoxyCompactList}\small\item\em Sets the port number to use for the connection. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aed11f75205cdbf0d16243c7ccc57d21a}{set\+Transaction\+Lock\+Timeout}} (timeout timeout\+\_\+ms=0)
\begin{DoxyCompactList}\small\item\em Sets the transaction lock timeout value in milliseconds; set to 0 for no timeout. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a86c204c7e2b1cceb46ca1f7ffeb007cd}{set\+User\+Name}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} user)
\begin{DoxyCompactList}\small\item\em Sets the username parameter for the time a connection to the server is established. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_afb6307ab9be490fa5d770519bca9447c}{transaction\+Tid}} ()
\begin{DoxyCompactList}\small\item\em Returns the TID of the thread holding the transaction lock or -\/1 if it\textquotesingle{}s not currently held. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aeba8bbff7570f5696e78ecb33a6a6fe0}{vexec}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql, \+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Grabs the transaction lock (if autocommit is disabled) and executes SQL code on the DB connection, taking a list for all bind arguments. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ad3c563a57ad19083a2bce99b17d1a59c}{vselect}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql, \+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Executes a select statement on the server and returns the results in a hash (column names) of lists (column values per row), taking a list for all bind arguments. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a296ec4a2c0cab82bc3514f851e1b8abd}{vselect\+Row}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql, \+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Executes a select statement on the server and returns the first row as a hash (column names and values), taking a list for all bind arguments. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a9145f5c598980a4685943e194a899ed4}{vselect\+Rows}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql, \+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Executes a select statement on the server and returns the results in a list (rows) of hashes (column names and values), taking a list for all bind arguments. \end{DoxyCompactList}\end{DoxyCompactItemize}
\doxysubsection*{Additional Inherited Members}


\doxysubsection{Detailed Description}
This class provides the Qore interface to databases. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gac496a9d9bcf9d5c626c8c267c73a83bc}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+DATABASE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Overview}
This class provides the main direct interface to DBI drivers (along with the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} classes).~\newline
~\newline
 The Datasource class will attempt to load any DBI driver that is not currently loaded in the constructor. For connection pooling support, see the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} class.~\newline
~\newline
 Datasource objects will implicitly call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aa6a07369dd7563f1db552588f41e02e7}{Datasource\+::open()}} if no connection has yet been established and a method is called requiring a connection to the database server. Therefore any method that requires communication with the database server can also throw any exception that the open method can throw.~\newline
~\newline
 Most Qore DBI drivers allow \char`\"{}select\char`\"{} queries to be executed through the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}{Datasource\+::exec()}} method, and allow SQL commands (procedure calls, etc) to be executed through the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}} method, and some DBI drivers do not (depends on the underlying DB API). At any rate, the transaction lock is set when auto-\/commit is disabled and when the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}{Datasource\+::exec()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} methods are executed as documented above. Therefore executing a transaction relevant command through the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}} method while auto-\/commit mode is disabled and a transaction has not yet started will not result in the transaction lock being allocated to the current thread and therefore could cause transaction errors when sharing the Datasource object between multiple threads.~\newline
~\newline
 Only databases with an existing Qore DBI driver can be accessed through the Datasource class.~\newline
~\newline
 All Qore DBI drivers set new connections to use transaction isolation level {\ttfamily \char`\"{}read committed\char`\"{}}.~\newline
~\newline
 The Datasource class provides high-\/level, per-\/connection locking on requests at a level above the DBI drivers to ensure that the communication between clients and servers is properly serialized.~\newline
~\newline
 Datasource objects also have a default character encoding; all requests to the server will be made in this encoding, and all responses will be returned in the given encoding. If no encoding is specifically given to the Datasource object, the Datasource object will use the \mbox{\hyperlink{character_encoding_default_encoding}{Default Character Encoding}}.
\end{DoxyParagraph}
\label{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}%
\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}%
 \begin{DoxyParagraph}{SQL Binding by Value and by Placeholder Overview}
All Datasource methods accepting SQL strings to execute understand a special syntax used in the query string to bind Qore data by value and to specify placeholders for output variables (for example, when executing a stored procedure or database function). Placeholder binding is DBI driver specific, but binding by value is supported with the same syntax in all drivers. Additionally, the {\ttfamily \%d} numeric specifier is supported equally in all Qore DBI drivers.~\newline
~\newline
 {\bfseries{Datasource Format Specifiers}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Format Specification}} &{\bfseries{Description}}  \\\cline{1-2}
{\ttfamily \%d}  &If any value other than \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} or \mbox{\hyperlink{basic_data_types_null}{NULL}} is given, then the value is converted to an integer and this value is substituted in the string at this position; if the value is \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} or \mbox{\hyperlink{basic_data_types_null}{NULL}}, then a literal {\ttfamily \char`\"{}null\char`\"{}} is substituted instead.  \\\cline{1-2}
{\ttfamily \%s}  &The argument is converted to a string and the string is inserted literally without any conversion or escape sequences in the string; this is useful for table or schema prefixes, etc  \\\cline{1-2}
{\ttfamily \%v}  &The argument is bound by value according to the DBI driver\textquotesingle{}s implementation.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\begin{DoxyParagraph}{SQL Binding Details}
To bind Qore data values directly in a binary format in an SQL command, use {\ttfamily \%v} in the command string, and include the value as an argument after the string. Binding by value allows the DBI driver to take care of formatting the data properly for use in the query with the database server. When binding by value, strings do not need to be quoted, date/time values do not need special formatting, binary objects (with BLOB columns, for example) can be used directly in queries, etc.~\newline
~\newline
 Here is an example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{int rows = db.exec(\textcolor{stringliteral}{"{}insert into table (varchar\_col, timestamp\_col, blob\_col, numeric\_col) values (\%v, \%v, \%v, \%d)"{}}, string, \mbox{\hyperlink{group__date__and__time__functions_ga23f067a4f82596346d4fef09782e1945}{now}}(), binary, 100);}

\end{DoxyCode}
 ~\newline
 When using dynamic \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}}, to insert a numeric value or a literal {\ttfamily \char`\"{}null\char`\"{}} in a query, use {\ttfamily \%d} in the command string, and include the value as an argument after the string. If the value is \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} or \mbox{\hyperlink{basic_data_types_null}{NULL}}, a literal {\ttfamily \char`\"{}null\char`\"{}} will be written to the string; otherwise the argument is converted to an arbitrary-\/precision number or integer value if necessary and written to the string. This is useful for working with {\ttfamily DECIMAL} ({\ttfamily NUMERIC}, {\ttfamily NUMBER}) types in a database-\/independent way; for example Postgre\+SQL servers do not do type conversions to {\ttfamily DECIMAL} types when a string, integer, or float is bound by value, therefore to ensure that integral decimal values can be used in a database-\/independent way (with {\ttfamily \char`\"{}null\char`\"{}} substitution when no value is bound), a valid approach is to use the {\ttfamily \%d} code in the command string instead of {\ttfamily \%v}. However please note that {\ttfamily \%v} is normally preferred to keep the server-\/side statement cache a manageable size, in the previous example using the \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int()}}, \mbox{\hyperlink{group__type__conversion__functions_ga113d18216af1bdb70545081b6a9892ef}{float()}}, or \mbox{\hyperlink{group__type__conversion__functions_gaf6000d64e3fe99ce81b9faaf44b2de4e}{number()}} functions to convert string values before binding with {\ttfamily \%v} may be better.~\newline
~\newline
 For binding placeholders for output variables, write a unique name in the string and prefix it with a colon (ex\+: {\ttfamily \char`\"{}\+:code\char`\"{}}). In this case the method will return a hash of the output variables using the placeholder names as keys, but without the colon prefix. By default, a string type will be bound to the position. To bind other variable types to placeholder positions, include the type constant (see \mbox{\hyperlink{group__sql__constants}{SQL Constants}}) as an argument after the command string. For BLOBs, use Binary, for CLOBs, use the string \char`\"{}clob\char`\"{} (constants will be provided in a future release). Not all DBI drivers require placeholder buffer specifications; see the documentation for the DBI driver in question for more information and examples regarding placeholder buffer specifications.
\end{DoxyParagraph}
\label{class_qore_1_1_s_q_l_1_1_datasource_resultset_output_binding}%
\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_resultset_output_binding}%
 \begin{DoxyParagraph}{Result Set Output Binding}
A result set can be returned in two ways depending on the placeholder buffer specification\+:
\begin{DoxyItemize}
\item \mbox{\hyperlink{group__string__type__constants_ga30ed1908e2fdf3b908623541e7b78724}{Hash}}\+: (default for drivers that do not require placeholder buffer specifications)\+: returns the entire result set as data
\item \mbox{\hyperlink{group__sql__constants_ga9d23a1d69fcb188296a231a36c6b6da2}{RESULTSET}}\+: (for drivers that support \mbox{\hyperlink{group__dbi__capabilities_ga91b90789d24991b1eebce9c11491f015}{Qore\+::\+SQL\+::\+DBI\+\_\+\+CAP\+\_\+\+HAS\+\_\+\+RESULTSET\+\_\+\+OUTPUT}})\+: returns an \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} representing the result set. This option allows a large result set to be returned in smaller pieces using the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} API if desired.
\end{DoxyItemize}
\end{DoxyParagraph}
When using \mbox{\hyperlink{group__sql__constants_ga9d23a1d69fcb188296a231a36c6b6da2}{RESULTSET}}, the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object created acquires the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_transaction_lock}{transaction lock}} even when used with a method that normally doesn\textquotesingle{}t indicate that a transaction will be started such as \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{select()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}{select\+Rows()}}, therefore the transaction lock must be released manually in such cases (just as with the normal usage of \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} objects); see the following example for details.

\begin{DoxyParagraph}{Result Set Output Binding Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# example of a result set output variable with Oracle}}
\DoxyCodeLine{SQLStatement stmt = ds.select(\textcolor{stringliteral}{"{}begin open :rs for select * from my\_table; end;"{}}, RESULTSET);}
\DoxyCodeLine{\textcolor{comment}{\# we have to release the transaction when done}}
\DoxyCodeLine{on\_exit ds.rollback();}
\DoxyCodeLine{\textcolor{comment}{\# iterate through the rows of the result set}}
\DoxyCodeLine{map process\_row(\$1), stmt;}

\end{DoxyCode}

\end{DoxyParagraph}
\label{class_qore_1_1_s_q_l_1_1_datasource_transaction_lock}%
\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_transaction_lock}%
 \begin{DoxyParagraph}{Datasource Transaction Locks}
Datasource objects have an internal transaction lock which will be grabbed when the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}{Datasource\+::exec()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aeba8bbff7570f5696e78ecb33a6a6fe0}{Datasource\+::vexec()}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a4ec5865609884af9b0498a7f45b1042f}{Datasource\+::exec\+Raw()}}, or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} methods are executed and autocommit is not enabled. This enables a single datasource to be safely used for transaction management by several threads simultaneously. Note that an exception in a Datasource method that would acquire the lock (such as the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}{Datasource\+::exec()}} method) when it\textquotesingle{}s not already held, will have the effect that the transaction lock is not acquired.~\newline
~\newline
 Any thread attempting to do transaction-\/relevant actions on a Datasource with auto-\/commit disabled while a transaction is in progress by another thread will block until the thread currently executing a transaction executes the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ab70fe02e890112a4449f0340ef7cc335}{Datasource\+::commit()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_acdc71e3819dbc3bf8be24d60e75e7bb2}{Datasource\+::rollback()}} methods (or the Datasource is deleted, reset, or closed, in which case the lock is released and an exception is raised as well).~\newline
~\newline
 There is a timeout associated with the transaction lock; if a thread waits for the transaction lock for more than the timeout period, then an exception will be raised in the waiting thread. The timeout value can be read and changed with the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aadc509c6ff4daba5f528163ffd8e05dc}{Datasource\+::get\+Transaction\+Lock\+Timeout()}} and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aed11f75205cdbf0d16243c7ccc57d21a}{Datasource\+::set\+Transaction\+Lock\+Timeout()}} methods, respectively. The default transaction lock timeout value is 120 seconds.~\newline
~\newline
 Note that the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class also grabs the transaction lock when executing if it is created using a Datasource object in the constructor; for more information see the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class documentation.
\end{DoxyParagraph}
\begin{DoxyParagraph}{Thread Resource Handling}
The \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} class manages the transaction lock as a \mbox{\hyperlink{threading_thread_resources}{thread resource}}; if the transaction is not released with a call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ab70fe02e890112a4449f0340ef7cc335}{Datasource\+::commit()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_acdc71e3819dbc3bf8be24d60e75e7bb2}{Datasource\+::rollback()}} when the thread exits (or when \mbox{\hyperlink{group__threading__functions_ga421dca39ccb55b191d5d09fd98c2075a}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions()}} or \mbox{\hyperlink{group__threading__functions_ga4e62409b8a1b414276d033267e7299e4}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions\+\_\+to\+\_\+mark()}} is called), the transaction is rolled back automatically and a {\ttfamily DATASOURCE-\/\+TRANSACTION-\/\+EXCEPTION} exception is raised describing the situation.~\newline
~\newline
 Being an builtin class, the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} class does not inherit \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource}{Abstract\+Thread\+Resource}} explicitly as a part of the exported API, and the internal \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource_a0431f7384991eaf6900ee3a952b57f87}{Abstract\+Thread\+Resource\+::cleanup()}} method cannot be overridden or suppressed.
\end{DoxyParagraph}
\begin{DoxyParagraph}{Data Serialization}
The \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} class supports \mbox{\hyperlink{class_qore_1_1_serializable}{data serialization}}; deserialization can fail if the database is not supported on or reachable from the target machine.
\end{DoxyParagraph}
When deserializing, any datasource event queue is lost; only the connection information is propagated in the deserialized copy.

\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gac496a9d9bcf9d5c626c8c267c73a83bc}{PO\+\_\+\+NO\+\_\+\+DATABASE}} parse option
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\href{../../modules/SqlUtil/html/index.html}{\texttt{ Sql\+Util}} for a high level database-\/independent API 
\end{DoxySeeAlso}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}\label{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!beginTransaction@{beginTransaction}}
\index{beginTransaction@{beginTransaction}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{beginTransaction()}{beginTransaction()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::begin\+Transaction (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Manually grabs the transaction lock. 

This method should be called when the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object will be shared between more than 1 thread, and a transaction will be started with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}} method or the like.

This method does not make any communication with the server to start a transaction; it only allocates the transaction lock to the current thread in Qore.

It is an error to call this method when autocommit is enabled for the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}}.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.beginTransaction();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em AUTOCOMMIT-\/\+ERROR} & Cannot start a transaction when autocommit is enabled \\
\hline
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_ab879515333fbb878b567d3f9a80e4ba8}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ac9a78046de816a73c17ced8195e6e2eb}\label{class_qore_1_1_s_q_l_1_1_datasource_ac9a78046de816a73c17ced8195e6e2eb}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!clearEventQueue@{clearEventQueue}}
\index{clearEventQueue@{clearEventQueue}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{clearEventQueue()}{clearEventQueue()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::clear\+Event\+Queue (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Clears the queue object for DBI events on the datasource. 

\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a5048534538ce825624d4be475e09774c}\label{class_qore_1_1_s_q_l_1_1_datasource_a5048534538ce825624d4be475e09774c}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!close@{close}}
\index{close@{close}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{close()}{close()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::close (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Closes the connection to the database; if any actions are in progress on the database, the close call will block until the actions complete. If any errors are encountered, an exception is raised. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.close();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ab70fe02e890112a4449f0340ef7cc335}\label{class_qore_1_1_s_q_l_1_1_datasource_ab70fe02e890112a4449f0340ef7cc335}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!commit@{commit}}
\index{commit@{commit}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{commit()}{commit()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::commit (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Commits the current transaction and releases the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_transaction_lock}{transaction lock}}. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.commit();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a885eed5b3f805ec931f6b5c8fc165c8b}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a5f225523817d0a2d01e68c9aaa40a83a}\label{class_qore_1_1_s_q_l_1_1_datasource_a5f225523817d0a2d01e68c9aaa40a83a}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [1/3]}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+Datasource\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$}]{opts,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}}}]{queue,  }\item[{auto}]{arg }\end{DoxyParamCaption})}



Creates a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object from a hash argument giving parameters for the constructor. 


\begin{DoxyParams}{Parameters}
{\em opts} & a hash giving parameters for the new datasource with the following possible keys (the {\ttfamily \char`\"{}type\char`\"{}} key is mandatory, also usable with the output of the \mbox{\hyperlink{group__old__dbi__functions_ga6c3dab42570887656fc05f5a22eb370a}{parse\+\_\+datasource()}} function)\+:
\begin{DoxyItemize}
\item {\ttfamily type\+:} (\mbox{\hyperlink{data_type_declarations_string_or_nothing_type}{$\ast$string}}) The name of the database driver to use; this key is mandatory; if not present, an exception will be raised. See \mbox{\hyperlink{group__sql__constants}{SQL Constants}} for builtin constants for DBI drivers shipped with \mbox{\hyperlink{namespace_qore}{Qore}}, or see the DBI driver documentation to use an add-\/on driver (this string should be the name of the driver to be loaded)
\item {\ttfamily user\+:} (\mbox{\hyperlink{data_type_declarations_string_or_nothing_type}{$\ast$string}}) The user name for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a86c204c7e2b1cceb46ca1f7ffeb007cd}{Datasource\+::set\+User\+Name()}} for a method that allows this parameter to be set after the constructor.
\item {\ttfamily pass\+:} (\mbox{\hyperlink{data_type_declarations_string_or_nothing_type}{$\ast$string}}) The password for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a1ecea098e3d8f0d256f088f85d8e4ae4}{Datasource\+::set\+Password()}} for a method that allows this parameter to be set after the constructor.
\item {\ttfamily db\+:} (\mbox{\hyperlink{data_type_declarations_string_or_nothing_type}{$\ast$string}}) The database name for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aaf2c93ad25bf3046a1a6b230f6482665}{Datasource\+::set\+DBName()}} for a method that allows this parameter to be set after the constructor.
\item {\ttfamily charset\+:} (\mbox{\hyperlink{data_type_declarations_string_or_nothing_type}{$\ast$string}}) The database-\/specific name of the character encoding to use for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aa7559279ad45047f842fb9f9af7a025b}{Datasource\+::set\+DBCharset()}} for a method that allows this parameter to be set after the constructor. If no value is passed for this parameter, then the database character encoding corresponding to the default character encoding for the Qore process will be used instead.
\item {\ttfamily host\+:} (\mbox{\hyperlink{data_type_declarations_string_or_nothing_type}{$\ast$string}}) The host name for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a264ea9b1a20197fb4b9c2eaa972af7f3}{Datasource\+::set\+Host\+Name()}} for a method that allows this parameter to be set after the constructor.
\item {\ttfamily port\+:} (\mbox{\hyperlink{data_type_declarations_softint_type}{softint}}) The port number for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a9c1dee4070b3ac1998bad8294307628b}{Datasource\+::set\+Port()}} for a method that allows this parameter to be set after the constructor. If this key is present and is 0 then an exception will be raised.
\item {\ttfamily options\+:} (\mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}}) Any options for the new connection 
\end{DoxyItemize}\\
\hline
{\em queue} & An optional \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object to receive datasource events; note that the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} passed cannot have any maximum size set or a {\ttfamily QUEUE-\/\+ERROR} will be thrown; passing \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} will clear any event queue \\
\hline
{\em arg} & an optional argument to be included in the {\ttfamily arg} key of datasource events\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{Datasource db((\textcolor{stringliteral}{"{}type"{}}: DSPGSQL, \textcolor{stringliteral}{"{}user"{}}: \textcolor{stringliteral}{"{}username"{}}, \textcolor{stringliteral}{"{}pass"{}}: \textcolor{stringliteral}{"{}password"{}}, \textcolor{stringliteral}{"{}db"{}}: \textcolor{stringliteral}{"{}database"{}}, \textcolor{stringliteral}{"{}charset"{}}: \textcolor{stringliteral}{"{}utf8"{}}, \textcolor{stringliteral}{"{}host"{}}: \textcolor{stringliteral}{"{}localhost"{}}, \textcolor{stringliteral}{"{}port"{}}: 5432);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em DATASOURCE-\/\+UNSUPPORTED-\/\+DATABASE} & DBI driver cannot be loaded \\
\hline
{\em DATASOURCE-\/\+CONSTRUCTOR-\/\+ERROR} & missing or invalid {\ttfamily \char`\"{}driver\char`\"{}} key, other key name not assigned to a string; port value is $<$= 0 \\
\hline
{\em DBI-\/\+OPTION-\/\+ERROR} & unknown or unsupported option passed to driver \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ad4729c1b5bbe81448527f1b182a08a34}\label{class_qore_1_1_s_q_l_1_1_datasource_ad4729c1b5bbe81448527f1b182a08a34}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [2/3]}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+Datasource\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{desc,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}}}]{queue,  }\item[{auto}]{arg }\end{DoxyParamCaption})}



Creates a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object from a single string giving all parameters that can be parsed by \mbox{\hyperlink{group__old__dbi__functions_ga6c3dab42570887656fc05f5a22eb370a}{parse\+\_\+datasource()}} 


\begin{DoxyParams}{Parameters}
{\em desc} & a datasource description string in the format that can be parsed by \mbox{\hyperlink{group__old__dbi__functions_ga6c3dab42570887656fc05f5a22eb370a}{parse\+\_\+datasource()}} \\
\hline
{\em queue} & An optional \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object to receive datasource events; note that the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} passed cannot have any maximum size set or a {\ttfamily QUEUE-\/\+ERROR} will be thrown; passing \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} will clear any event queue \\
\hline
{\em arg} & an optional argument to be included in the {\ttfamily arg} key of datasource events\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{Datasource ds(\textcolor{stringliteral}{"{}pgsql:user/pass@db01(utf8)\%localhost:5432"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em DATASOURCE-\/\+UNSUPPORTED-\/\+DATABASE} & DBI driver cannot be loaded \\
\hline
{\em DATASOURCE-\/\+CONSTRUCTOR-\/\+ERRO} & missing required parameter for connection; port value is $<$= 0 \\
\hline
{\em DBI-\/\+OPTION-\/\+ERROR} & unknown or unsupported option passed to driver\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a293894c31d423aaadefc6f1a7f188d31}\label{class_qore_1_1_s_q_l_1_1_datasource_a293894c31d423aaadefc6f1a7f188d31}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [3/3]}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+Datasource\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{driver,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{user,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{pass,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{db,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{encoding,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{host,  }\item[{\+\_\+\+\_\+7\+\_\+ softint}]{port,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$}]{options,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}}}]{queue,  }\item[{auto}]{arg }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object; attempts to load a DBI driver if the driver is not already present in Qore. 


\begin{DoxyParams}{Parameters}
{\em driver} & The name of the DBI driver for the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}}. See \mbox{\hyperlink{group__sql__constants}{SQL Constants}} for builtin constants for DBI drivers shipped with Qore, or see the DBI driver documentation to use an add-\/on driver (this string should be the name of the driver to be loaded) \\
\hline
{\em user} & The user name for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a86c204c7e2b1cceb46ca1f7ffeb007cd}{Datasource\+::set\+User\+Name()}} for a method that allows this parameter to be set after the constructor. \\
\hline
{\em pass} & The password for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a1ecea098e3d8f0d256f088f85d8e4ae4}{Datasource\+::set\+Password()}} for a method that allows this parameter to be set after the constructor. \\
\hline
{\em db} & The database name for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aaf2c93ad25bf3046a1a6b230f6482665}{Datasource\+::set\+DBName()}} for a method that allows this parameter to be set after the constructor. \\
\hline
{\em encoding} & The database-\/specific name of the \mbox{\hyperlink{character_encoding}{character encoding}} to use for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aa7559279ad45047f842fb9f9af7a025b}{Datasource\+::set\+DBCharset()}} for a method that allows this parameter to be set after the constructor. If no value is passed for this parameter, then the database character encoding corresponding to the \mbox{\hyperlink{character_encoding_default_encoding}{default character encoding}} will be used instead. \\
\hline
{\em host} & The host name for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a264ea9b1a20197fb4b9c2eaa972af7f3}{Datasource\+::set\+Host\+Name()}} for a method that allows this parameter to be set after the constructor. \\
\hline
{\em port} & The port number for the new connection. Also see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a9c1dee4070b3ac1998bad8294307628b}{Datasource\+::set\+Port()}} for a method that allows this parameter to be set after the constructor. \\
\hline
{\em options} & Any options for the database driver for the new connection \\
\hline
{\em queue} & An optional \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object to receive datasource events; note that the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} passed cannot have any maximum size set or a {\ttfamily QUEUE-\/\+ERROR} will be thrown; passing \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} will clear any event queue \\
\hline
{\em arg} & an optional argument to be included in the {\ttfamily arg} key of datasource events\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{Datasource db(DSPGSQL, \textcolor{stringliteral}{"{}user"{}}, \textcolor{stringliteral}{"{}pass"{}}, \textcolor{stringliteral}{"{}database"{}}, \textcolor{stringliteral}{"{}utf8"{}}, \textcolor{stringliteral}{"{}localhost"{}}, 5432);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em DATASOURCE-\/\+UNSUPPORTED-\/\+DATABASE} & DBI driver cannot be loaded \\
\hline
{\em DATASOURCE-\/\+CONSTRUCTOR-\/\+ERROR} & port value is $<$= 0 \\
\hline
{\em DBI-\/\+OPTION-\/\+ERROR} & unknown or unsupported option passed to driver \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a196d09ba7c9e3cb9e6a228593152b5fd}\label{class_qore_1_1_s_q_l_1_1_datasource_a196d09ba7c9e3cb9e6a228593152b5fd}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!copy@{copy}}
\index{copy@{copy}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+Datasource\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Creates a new \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object with the same driver as the original and copies of all the connection parameters. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{Datasource new\_ds = ds.copy();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a5661e26369193015c195166e52c6d121}\label{class_qore_1_1_s_q_l_1_1_datasource_a5661e26369193015c195166e52c6d121}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!currentThreadInTransaction@{currentThreadInTransaction}}
\index{currentThreadInTransaction@{currentThreadInTransaction}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{currentThreadInTransaction()}{currentThreadInTransaction()}}
{\footnotesize\ttfamily bool Qore\+::\+SQL\+::\+Datasource\+::current\+Thread\+In\+Transaction (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is in a transaction (i.\+e. holds the transaction lock), \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is in a transaction (i.\+e. holds the transaction lock), \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = db.currentThreadInTransaction();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_afb6307ab9be490fa5d770519bca9447c}{Datasource\+::transaction\+Tid()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+7 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ac9768f90d91a866ee3ef7580cedb3667}\label{class_qore_1_1_s_q_l_1_1_datasource_ac9768f90d91a866ee3ef7580cedb3667}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!describe@{describe}}
\index{describe@{describe}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{describe()}{describe()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+Datasource\+::describe (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{}]{... }\end{DoxyParamCaption})}



Executes an SQL select statement on the server and returns a description of the result set as a hash. 

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}

This method does not retain the transaction lock if it was not already acquired before this method is called, so to execute select statements that begin a transaction (such as {\ttfamily \char`\"{}select for update\char`\"{}}), execute \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} first to ensure that the transaction lock is dedicated to the calling thread.


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em ...} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a hash describing the result set with the following keys\+:
\begin{DoxyItemize}
\item {\ttfamily name\+:} the name of the column
\item {\ttfamily type\+:} a string giving the type of the column
\item {\ttfamily maxsize\+:} an integer giving the column size
\item {\ttfamily native\+\_\+type\+:} a string giving the native column type
\item {\ttfamily internal\+\_\+id\+:} an integer giving the native column type code
\end{DoxyItemize}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*hash<auto> h = db.describe(\textcolor{stringliteral}{"{}select * from example\_table where id = 1"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a420a865a5ef78ddc110f90529a5b7967}\label{class_qore_1_1_s_q_l_1_1_datasource_a420a865a5ef78ddc110f90529a5b7967}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+Datasource\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Closes the datasource if it\textquotesingle{}s open (if any operations are in progress, will block until the operations complete) and destroys the object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{delete db;}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em DATASOURCE-\/\+TRANSACTION-\/\+EXCEPTION} & The \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} was destroyed while a transaction was still in progress; the transaction will be automatically rolled back \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}\label{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!exec@{exec}}
\index{exec@{exec}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{exec()}{exec()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::exec (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Grabs the transaction lock (if autocommit is disabled) and executes an SQL command on the server and returns either the integer row count (for example, for updates, inserts, and deletes) or the data retrieved (for example, if a stored procedure is executed that returns values). 

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em ...} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
The return value depends on the DBI driver; normally, for commands with placeholders, a hash is returned holding the values acquired from executing the SQL statement. For all other commands, normally an integer row count is returned. However, some DBI drivers also allow select statements to be executed through this interface, which would also return a hash (column names) of lists (values for each column).
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int rows = db.exec(\textcolor{stringliteral}{"{}insert into table (varchar\_col, timestamp\_col, blob\_col, numeric\_col) values (\%v, \%v, \%v, \%d)"{}}, string, \mbox{\hyperlink{group__date__and__time__functions_ga23f067a4f82596346d4fef09782e1945}{now}}(), binary, 100);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a71cd33bd6be7230e8481b3b6a0d33892}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a4ec5865609884af9b0498a7f45b1042f}\label{class_qore_1_1_s_q_l_1_1_datasource_a4ec5865609884af9b0498a7f45b1042f}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!execRaw@{execRaw}}
\index{execRaw@{execRaw}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{execRaw()}{execRaw()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::exec\+Raw (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Grabs the transaction lock (if autocommit is disabled) and executes an SQL command on the server and returns either the row count (for example, for updates and inserts) or the data retrieved (for example, if a stored procedure is executed that returns values) 

This method does not do any variable binding, so it\textquotesingle{}s useful for example for DDL statements etc

\begin{DoxyParagraph}{Warning\+:}
Using this method to execute pure dynamic SQL many times with different SQL strings (as opposed to using the same string and binding by value instead of dynamic SQL) can affect application performance by prohibiting the efficient usage of the DB server\textquotesingle{}s statement cache. See DB server documentation for variable binding and the SQL statement cache for more information.
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server; this string will not be subjected to any transformations for variable binding\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
The return value depends on the DBI driver; normally, for commands with placeholders, a hash is returned holding the values acquired from executing the SQL statement. For all other commands, normally an integer row count is returned. However, some DBI drivers also allow select statements to be executed through this interface, which would also return a hash (column names) of lists (values for each column).
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.execRaw(\textcolor{stringliteral}{"{}create table my\_tab (id number, some\_text varchar2(30))"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a8ebf9c0e5bb529dab200ab95ab36a5d4}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a4b4bbaca92649d27b858fb0996dc86fd}\label{class_qore_1_1_s_q_l_1_1_datasource_a4b4bbaca92649d27b858fb0996dc86fd}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getAutoCommit@{getAutoCommit}}
\index{getAutoCommit@{getAutoCommit}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getAutoCommit()}{getAutoCommit()}}
{\footnotesize\ttfamily bool Qore\+::\+SQL\+::\+Datasource\+::get\+Auto\+Commit (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the autocommit status for the object. 

\begin{DoxyReturn}{Returns}
the autocommit status for the object
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = db.getAutoCommit();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_add2d683039a2bc2b01df63621b698e6e}\label{class_qore_1_1_s_q_l_1_1_datasource_add2d683039a2bc2b01df63621b698e6e}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getCapabilities@{getCapabilities}}
\index{getCapabilities@{getCapabilities}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getCapabilities()}{getCapabilities()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+SQL\+::\+Datasource\+::get\+Capabilities (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns an integer bitfield of DBI driver capabilities. 

\begin{DoxyReturn}{Returns}
an integer bitfield of DBI driver capabilities; see \mbox{\hyperlink{group__dbi__capabilities}{DBI Capability Constants}} for the meaning of each bit
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int caps = db.getCapabilities();}
\DoxyCodeLine{\textcolor{keywordflow}{if} (!(caps \& DBI\_CAP\_TRANSACTION\_MANAGEMENT))}
\DoxyCodeLine{    throw \textcolor{stringliteral}{"{}DATASOURCE-\/ERROR"{}}, \mbox{\hyperlink{group__string__functions_ga7a74be141f814ef286046c367b21091c}{sprintf}}(\textcolor{stringliteral}{"{}DBI driver \%y does not support transaction management"{}}, db.getDriverName());}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_af3679df85414880b19537ad0ee9d0ad7}\label{class_qore_1_1_s_q_l_1_1_datasource_af3679df85414880b19537ad0ee9d0ad7}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getCapabilityList@{getCapabilityList}}
\index{getCapabilityList@{getCapabilityList}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getCapabilityList()}{getCapabilityList()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$auto$>$ Qore\+::\+SQL\+::\+Datasource\+::get\+Capability\+List (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a list of strings giving the capabilities of the current DBI driver. 

\begin{DoxyReturn}{Returns}
a list of strings giving the capabilities of the current DBI driver
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}driver \%y has the following capabilities:\(\backslash\)n"{}}, db.getDriverName());}
\DoxyCodeLine{foreach string cap \textcolor{keywordflow}{in} (db.getCapabilityList())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}-\/ \%s\(\backslash\)n"{}}, cap);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a0074fed1b53e9b94f811f3b8481b1df4}\label{class_qore_1_1_s_q_l_1_1_datasource_a0074fed1b53e9b94f811f3b8481b1df4}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getClientVersion@{getClientVersion}}
\index{getClientVersion@{getClientVersion}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getClientVersion()}{getClientVersion()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::get\+Client\+Version (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves the driver-\/specific client library version information; this method may not be implemented for all drivers. 

\begin{DoxyReturn}{Returns}
the driver-\/specific client library version information; this method may not be implemented for all drivers; see the DBI driver documentation for the return data type and format
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto ver = db.getClientVersion();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_ad188ffb22d7cb8274fa8fa4255a28b8f}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a8291b3c3010a8c0d1522afeaa3411a02}\label{class_qore_1_1_s_q_l_1_1_datasource_a8291b3c3010a8c0d1522afeaa3411a02}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getConfigHash@{getConfigHash}}
\index{getConfigHash@{getConfigHash}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getConfigHash()}{getConfigHash()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+Datasource\+::get\+Config\+Hash (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns a \mbox{\hyperlink{group__dbi__functions_datasource_hash}{datasource hash}} describing the configuration of the current object. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{hash<auto> h = ds.getConfigHash();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{group__dbi__functions_datasource_hash}{datasource hash}} describing the configuration of the current object
\end{DoxyReturn}
This method does not require a connection to the server. The return value may differ for connected and unconnected objects, as the DB driver may set default option values when the datasource is connected.

\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a3929e6477e0d9da8155c0b0bf0d236cf}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a7713f26c809821a7942a60e27f924742}\label{class_qore_1_1_s_q_l_1_1_datasource_a7713f26c809821a7942a60e27f924742}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getConfigString@{getConfigString}}
\index{getConfigString@{getConfigString}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getConfigString()}{getConfigString()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+Config\+String (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns a string giving the configuration of the current object in a format that can be parsed by \mbox{\hyperlink{group__old__dbi__functions_ga6c3dab42570887656fc05f5a22eb370a}{parse\+\_\+datasource()}} 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = ds.getConfigString();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a string giving the configuration of the current object in a format that can be parsed by \mbox{\hyperlink{group__old__dbi__functions_ga6c3dab42570887656fc05f5a22eb370a}{parse\+\_\+datasource()}}
\end{DoxyReturn}
This method does not require a connection to the server. The return value may differ for connected and unconnected objects, as the DB driver may set default option values when the datasource is connected.

\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a79772d8676975c1ab23710bc91d666ae}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ad25c7a0e752c9ad8a51b92d260a86fe5}\label{class_qore_1_1_s_q_l_1_1_datasource_ad25c7a0e752c9ad8a51b92d260a86fe5}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getDBCharset@{getDBCharset}}
\index{getDBCharset@{getDBCharset}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getDBCharset()}{getDBCharset()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+DBCharset (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Retrieves the database-\/specific charset set encoding for the current connection. 

A method synonym for \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_af898e46c3bc2498ae858d3f98fb23eb3}{Datasource\+::get\+DBEncoding()}} kept for backwards-\/compatibility.

\begin{DoxyReturn}{Returns}
the database-\/specific charset set encoding for the current connection
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string enc = db.getDBCharset();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_af898e46c3bc2498ae858d3f98fb23eb3}\label{class_qore_1_1_s_q_l_1_1_datasource_af898e46c3bc2498ae858d3f98fb23eb3}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getDBEncoding@{getDBEncoding}}
\index{getDBEncoding@{getDBEncoding}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getDBEncoding()}{getDBEncoding()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+DBEncoding (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves the database-\/specific charset set encoding for the current connection. 

\begin{DoxyReturn}{Returns}
the database-\/specific charset set encoding for the current connection
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string enc = db.getDBEncoding();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aae5a12ff32342c13df0cee4503e2f898}{Datasource\+::get\+OSEncoding()}}; 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_ae89ba7cab57748a51358e44ac5e231d5}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aa0084434a2631b776ce4cfa7075e5f01}\label{class_qore_1_1_s_q_l_1_1_datasource_aa0084434a2631b776ce4cfa7075e5f01}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getDBName@{getDBName}}
\index{getDBName@{getDBName}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getDBName()}{getDBName()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+DBName (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the database name parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. 

\begin{DoxyReturn}{Returns}
the database name parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string db = db.getDBName();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a1e0d642801b1ce96fea0553ae4def964}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aff2f886f27e033dd2bdcc49c22b2cd65}\label{class_qore_1_1_s_q_l_1_1_datasource_aff2f886f27e033dd2bdcc49c22b2cd65}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getDriverName@{getDriverName}}
\index{getDriverName@{getDriverName}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getDriverName()}{getDriverName()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+Driver\+Name (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the name of the driver used for the object. 

\begin{DoxyReturn}{Returns}
the name of the driver used for the object
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string driver = db.getDriverName();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a26a5370cb70baed85f0d3a51a8f36cf9}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a103526f8e3e4e0783523f3af89047190}\label{class_qore_1_1_s_q_l_1_1_datasource_a103526f8e3e4e0783523f3af89047190}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getHostName@{getHostName}}
\index{getHostName@{getHostName}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getHostName()}{getHostName()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+Host\+Name (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the hostname parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. 

\begin{DoxyReturn}{Returns}
the hostname parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string host = db.getHostName();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a4ffcb9760eea609835734b27e7f97eac}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a34834d2da5e1e8f13949810e76a6e1cd}\label{class_qore_1_1_s_q_l_1_1_datasource_a34834d2da5e1e8f13949810e76a6e1cd}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getOption@{getOption}}
\index{getOption@{getOption}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getOption()}{getOption()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::get\+Option (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{opt }\end{DoxyParamCaption})}



Returns the current value for the given option. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em opt} & the option to get\\
\hline
\end{DoxyParams}
\begin{DoxyNote}{Note}
in order to ensure atomicity when dealing with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} options, the transaction lock is acquired before executing this method if it was not already owned by the calling thread
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em DBI-\/\+OPTION-\/\+ERROR} & unknown or unsupported option passed to driver \\
\hline
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ac78f3f07aff86117dbe3808b5d2d7757}\label{class_qore_1_1_s_q_l_1_1_datasource_ac78f3f07aff86117dbe3808b5d2d7757}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getOptionHash@{getOptionHash}}
\index{getOptionHash@{getOptionHash}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getOptionHash()}{getOptionHash()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+Datasource\+::get\+Option\+Hash (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



returns the valid options for the driver associated with the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} with descriptions and current values for the current \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hash where the keys are valid option names, and the values are hashes with the following keys\+:
\begin{DoxyItemize}
\item {\ttfamily \char`\"{}desc\char`\"{}}\+: a string description of the option
\item {\ttfamily \char`\"{}type\char`\"{}}\+: a string giving the data type restriction for the option
\item {\ttfamily \char`\"{}value\char`\"{}}\+: the current value of the option
\end{DoxyItemize}
\end{DoxyReturn}
\begin{DoxyNote}{Note}
in order to ensure atomicity when dealing with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} options, the transaction lock is acquired before executing this method if it was not already owned by the calling thread
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a86bf7ff6686300ebcd270b3d09f508c9}\label{class_qore_1_1_s_q_l_1_1_datasource_a86bf7ff6686300ebcd270b3d09f508c9}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getOSCharset@{getOSCharset}}
\index{getOSCharset@{getOSCharset}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getOSCharset()}{getOSCharset()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+OSCharset (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the Qore character encoding name for the current connection as a string or {\ttfamily \char`\"{}(unknown)\char`\"{}} if none is set. 

\begin{DoxyReturn}{Returns}
the Qore character encoding name for the current connection as a string or {\ttfamily \char`\"{}(unknown)\char`\"{}} if none is set
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string enc = db.getOSCharset();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_aae5a12ff32342c13df0cee4503e2f898}{Datasource\+::get\+OSEncoding()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aae5a12ff32342c13df0cee4503e2f898}\label{class_qore_1_1_s_q_l_1_1_datasource_aae5a12ff32342c13df0cee4503e2f898}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getOSEncoding@{getOSEncoding}}
\index{getOSEncoding@{getOSEncoding}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getOSEncoding()}{getOSEncoding()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+OSEncoding (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the Qore character encoding name for the current connection as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. 

\begin{DoxyReturn}{Returns}
the Qore character encoding for the current connection as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string enc = db.getOSEncoding();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_ab5d951f88607a8f3580730c894cd4681}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ae8ecfbacb0245d1c2e5118352cfe9edb}\label{class_qore_1_1_s_q_l_1_1_datasource_ae8ecfbacb0245d1c2e5118352cfe9edb}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getPassword@{getPassword}}
\index{getPassword@{getPassword}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getPassword()}{getPassword()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+Password (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the password parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. 

\begin{DoxyReturn}{Returns}
the password parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string \textcolor{keywordflow}{pass} = db.getPassword();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_ac245a7e0615433778ab7a61abf845c54}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ad8c4bde5992da775c95bd8b2a3340e19}\label{class_qore_1_1_s_q_l_1_1_datasource_ad8c4bde5992da775c95bd8b2a3340e19}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getPort@{getPort}}
\index{getPort@{getPort}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getPort()}{getPort()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+SQL\+::\+Datasource\+::get\+Port (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Gets the port number that will be used for the next connection to the server. 

Invalid port numbers will cause an exception to be thrown when the connection is opened

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*int port = db.getPort();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a54d89afe6d44810ed7e141ba35310748}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a35340d8cbadc2eb5b20ab9d8e0fc87eb}\label{class_qore_1_1_s_q_l_1_1_datasource_a35340d8cbadc2eb5b20ab9d8e0fc87eb}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getServerVersion@{getServerVersion}}
\index{getServerVersion@{getServerVersion}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getServerVersion()}{getServerVersion()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::get\+Server\+Version (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the driver-\/specific server version data for the current connection. 

\begin{DoxyReturn}{Returns}
the driver-\/specific server version data for the current connection; see the DBI driver documentation for the return data type and format
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto ver = db.getServerVersion();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_acd2bef573f9d703c9511efd38bc1c2ec}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a39ef1a8bff15788d039672359c28772e}\label{class_qore_1_1_s_q_l_1_1_datasource_a39ef1a8bff15788d039672359c28772e}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getSQLStatement@{getSQLStatement}}
\index{getSQLStatement@{getSQLStatement}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getSQLStatement()}{getSQLStatement()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement}{Abstract\+SQLStatement}} Qore\+::\+SQL\+::\+Datasource\+::get\+SQLStatement (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns an \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement}{Abstract\+SQLStatement}} object based on the current database connection object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{AbstractSQLStatement stmt = ds.getSQLStatement();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & the DBI driver for the given object does not support the prepared statement API\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
\mbox{\hyperlink{namespace_qore}{Qore}} 0.\+9.\+0 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aadc509c6ff4daba5f528163ffd8e05dc}\label{class_qore_1_1_s_q_l_1_1_datasource_aadc509c6ff4daba5f528163ffd8e05dc}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getTransactionLockTimeout@{getTransactionLockTimeout}}
\index{getTransactionLockTimeout@{getTransactionLockTimeout}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getTransactionLockTimeout()}{getTransactionLockTimeout()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+SQL\+::\+Datasource\+::get\+Transaction\+Lock\+Timeout (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Retrieves the transaction lock timeout value as an integer in milliseconds. 

\begin{DoxyReturn}{Returns}
the transaction lock timeout value as an integer in milliseconds
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int to\_ms = db.getTransactionLockTimeout();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a0b9c482becfbe8349a75e5a55370f88c}\label{class_qore_1_1_s_q_l_1_1_datasource_a0b9c482becfbe8349a75e5a55370f88c}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!getUserName@{getUserName}}
\index{getUserName@{getUserName}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{getUserName()}{getUserName()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+Datasource\+::get\+User\+Name (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the username parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set. 

\begin{DoxyReturn}{Returns}
the username parameter as a string or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if none is set
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string user = db.getUserName();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_aea226bb7ae548363ae25a4f1e306b34a}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_af74cb806c9e19c6099c0d2cce84a44ab}\label{class_qore_1_1_s_q_l_1_1_datasource_af74cb806c9e19c6099c0d2cce84a44ab}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!inTransaction@{inTransaction}}
\index{inTransaction@{inTransaction}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{inTransaction()}{inTransaction()}}
{\footnotesize\ttfamily bool Qore\+::\+SQL\+::\+Datasource\+::in\+Transaction (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if a transaction is currently in progress, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if a transaction is currently in progress, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = db.inTransaction();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_ac7fe5b3cf6789100950622138915517e}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aa6a07369dd7563f1db552588f41e02e7}\label{class_qore_1_1_s_q_l_1_1_datasource_aa6a07369dd7563f1db552588f41e02e7}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!open@{open}}
\index{open@{open}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{open()}{open()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::open (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Opens a connection to the datasouce, using the connection parameters already set; an exception is thrown if any errors occur. 

If the connection is already open, then no action is taken.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.open();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for possible exceptions
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a4c8ae5e2b2d6c1386525eeb019abfb9b}{Datasource\+::reset()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a4c8ae5e2b2d6c1386525eeb019abfb9b}\label{class_qore_1_1_s_q_l_1_1_datasource_a4c8ae5e2b2d6c1386525eeb019abfb9b}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!reset@{reset}}
\index{reset@{reset}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{reset()}{reset()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::reset (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Closes and reopens the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}}. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.reset();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_acdc71e3819dbc3bf8be24d60e75e7bb2}\label{class_qore_1_1_s_q_l_1_1_datasource_acdc71e3819dbc3bf8be24d60e75e7bb2}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!rollback@{rollback}}
\index{rollback@{rollback}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{rollback()}{rollback()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::rollback (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Rolls the current transaction back and releases the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_transaction_lock}{transaction lock}}. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.rollback();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_acccf4e46fb29f2d12700cc6feb0c9438}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}\label{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!select@{select}}
\index{select@{select}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{select()}{select()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::select (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes an SQL select statement on the server and returns the result as a hash (column names) of lists (column values per row) 

The return format of this method is suitable for use with \mbox{\hyperlink{statements_context}{context statements}}, for easy iteration and processing of query results. Alternatively, the \mbox{\hyperlink{class_qore_1_1_hash_list_iterator}{Hash\+List\+Iterator}} class can be used to iterate the return value of this method.

Additionally, this format is a more efficient format than that returned by the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}{Datasource\+::select\+Rows()}} method, because the column names are not repeated for each row returned. Therefore, for retrieving anything greater than small amounts of data, it is recommended to use this method instead of \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}{Datasource\+::select\+Rows()}}.

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}

This method does not retain the transaction lock if it was not already acquired before this method is called, so to execute select statements that begin a transaction (such as {\ttfamily \char`\"{}select for update\char`\"{}}), execute \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} first to ensure that the transaction lock is dedicated to the calling thread.


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em ...} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
This method returns a hash (the keys are the column names) of lists (the column data per row) when executed with an SQL select statement, however some DBI drivers allow any SQL to be executed through this method, in which case other data types can be returned (such as an integer for a row count or a hash for output parameters when executing a stored procedure). If no rows are found, a hash of column names assigned to empty lists is returned.
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# bind a string and a date/time value by value in a query}}
\DoxyCodeLine{hash query = db.select(\textcolor{stringliteral}{"{}select * from table where varchar\_column = \%v and timestamp\_column > \%v"{}}, string, 2007-\/10-\/11T15:31:26.289);}
\DoxyCodeLine{\textcolor{keywordflow}{if} (query.firstValue())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}got results\(\backslash\)n"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item See the documentation for the DBI driver being used for additional possible exceptions
\item This method returns all the data available immediately; to process query data piecewise, use the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_ad3c563a57ad19083a2bce99b17d1a59c}{Datasource\+::vselect()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aab3d2e6e69d212dbe05de43136f14367}{Qore\+::zzz8hashzzz9\+::context\+Iterator()}}
\item \mbox{\hyperlink{statements_context}{context Statements}} 
\end{DoxyItemize}
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a594c9f65813ada4668a67aca0a5c0331}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a11f5fdffd9031ba2d0bf6b8c8b447314}\label{class_qore_1_1_s_q_l_1_1_datasource_a11f5fdffd9031ba2d0bf6b8c8b447314}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!selectRow@{selectRow}}
\index{selectRow@{selectRow}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{selectRow()}{selectRow()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+Datasource\+::select\+Row (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes an SQL select statement on the server and returns the first row as a hash (the column values) 

If more than one row is returned, then it is treated as an error and a {\ttfamily DBI-\/\+SELECT-\/\+ROW-\/\+ERROR} is returned (however the DBI driver should raise its own exception here to avoid retrieving more than one row from the server). For a similar method taking a list for all bind arguments, see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a296ec4a2c0cab82bc3514f851e1b8abd}{Datasource\+::vselect\+Row()}}.

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}

This method does not retain the transaction lock if it was not already acquired before this method is called, so to execute select statements that begin a transaction (such as {\ttfamily \char`\"{}select for update\char`\"{}}), execute \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} first to ensure that the transaction lock is dedicated to the calling thread.


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em ...} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
This method returns a hash (the keys are the column names) of row data or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no row is found for the query when executed with an SQL select statement
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*hash<auto> h = db.selectRow(\textcolor{stringliteral}{"{}select * from example\_table where id = 1"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock \\
\hline
{\em DBI-\/\+SELECT-\/\+ROW-\/\+ERROR} & more than 1 row retrieved from the server\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a6d4bd90ff3b28a637b19254a7f09dfba}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}\label{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!selectRows@{selectRows}}
\index{selectRows@{selectRows}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{selectRows()}{selectRows()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::select\+Rows (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes an SQL select statement on the server and returns the result as a list (rows) of hashes (the column values) 

The return format of this method is not as memory efficient as that returned by the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}} method, therefore for larger amounts of data, it is recommended to use \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}}.

The usual return value of this method can be iterated with the \mbox{\hyperlink{class_qore_1_1_list_hash_iterator}{List\+Hash\+Iterator}} class.

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}

This method does not retain the transaction lock if it was not already acquired before this method is called, so to execute select statements that begin a transaction (such as {\ttfamily \char`\"{}select for update\char`\"{}}), execute \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} first to ensure that the transaction lock is dedicated to the calling thread.


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em ...} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
Normally returns a list (rows) of hash (where the keys are the column names of each row) or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no rows are found for the query, however some DBI drivers allow any SQL statement to be executed through this method (not only select statements), in this case other data types can be returned
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*list<auto> list = db.selectRows(\textcolor{stringliteral}{"{}select * from example\_table"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item See the documentation for the DBI driver being used for additional possible exceptions
\item This method returns all the data available immediately; to process query data piecewise, use the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_af4a40e6be75f11ea926378b6815a9654}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a5c9bf476b32eb9394e90c252504889f0}\label{class_qore_1_1_s_q_l_1_1_datasource_a5c9bf476b32eb9394e90c252504889f0}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setAutoCommit@{setAutoCommit}}
\index{setAutoCommit@{setAutoCommit}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setAutoCommit()}{setAutoCommit()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+Auto\+Commit (\begin{DoxyParamCaption}\item[{bool}]{ac = {\ttfamily \mbox{\hyperlink{group__boolean__constants_ga3ba2df91713a6249449347131ea526c3}{True}}} }\end{DoxyParamCaption})}



Turns autocommit on or off for this object. 


\begin{DoxyParams}{Parameters}
{\em ac} & \mbox{\hyperlink{basic_data_types_True}{True}} to turn on autocommit (a commit will be executed after every SQL call to the server), \mbox{\hyperlink{basic_data_types_False}{False}} to turn off autocommit (commits must be manually triggered) \\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setAutoCommit(\textcolor{keyword}{False});}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aa7559279ad45047f842fb9f9af7a025b}\label{class_qore_1_1_s_q_l_1_1_datasource_aa7559279ad45047f842fb9f9af7a025b}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setDBCharset@{setDBCharset}}
\index{setDBCharset@{setDBCharset}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setDBCharset()}{setDBCharset()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+DBCharset (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{encoding }\end{DoxyParamCaption})}



Sets the database-\/specific character encoding name for the next connection to the server. 

This is a method synonym for the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a6b6b1e6098b0028a872b045ea3d811b8}{Datasource\+::set\+DBEncoding()}} method, kept for backwards-\/compatibility.

Invalid character encoding names will cause an exception to be thrown when the connection is opened.


\begin{DoxyParams}{Parameters}
{\em encoding} & the database-\/specific character encoding name for the next connection to the server\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setDBCharset(encoding);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a6b6b1e6098b0028a872b045ea3d811b8}\label{class_qore_1_1_s_q_l_1_1_datasource_a6b6b1e6098b0028a872b045ea3d811b8}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setDBEncoding@{setDBEncoding}}
\index{setDBEncoding@{setDBEncoding}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setDBEncoding()}{setDBEncoding()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+DBEncoding (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{encoding }\end{DoxyParamCaption})}



Sets the database-\/specific character encoding name for the next connection to the server. 

Invalid character encoding names will cause an exception to be thrown when the connection is opened.


\begin{DoxyParams}{Parameters}
{\em encoding} & the database-\/specific character encoding name for the next connection to the server\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setDBEncoding(encoding);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aaf2c93ad25bf3046a1a6b230f6482665}\label{class_qore_1_1_s_q_l_1_1_datasource_aaf2c93ad25bf3046a1a6b230f6482665}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setDBName@{setDBName}}
\index{setDBName@{setDBName}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setDBName()}{setDBName()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+DBName (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{db }\end{DoxyParamCaption})}



Sets the database name parameter for the time a connection to the server is established. 

Invalid database names will cause an exception to be thrown when the connection is opened


\begin{DoxyParams}{Parameters}
{\em db} & the database name parameter for the time a connection to the server is established\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setDBName(db);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ad4953ced1fde3271c67b0dc838756ebf}\label{class_qore_1_1_s_q_l_1_1_datasource_ad4953ced1fde3271c67b0dc838756ebf}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setEventQueue@{setEventQueue}}
\index{setEventQueue@{setEventQueue}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setEventQueue()}{setEventQueue()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+Event\+Queue (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Qore\+::\+Thread\+::\+Queue}}}]{queue,  }\item[{auto}]{arg }\end{DoxyParamCaption})}



Sets a queue object for DBI events on the datasource. 


\begin{DoxyParams}{Parameters}
{\em queue} & the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object to receive datasource events; note that the \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} passed cannot have any maximum size set or a {\ttfamily QUEUE-\/\+ERROR} will be thrown; passing \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} will clear any event queue \\
\hline
{\em arg} & an argument to be included in the {\ttfamily arg} key of datasource events\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em QUEUE-\/\+ERROR} & the Queue passed has a maximum size set\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a264ea9b1a20197fb4b9c2eaa972af7f3}\label{class_qore_1_1_s_q_l_1_1_datasource_a264ea9b1a20197fb4b9c2eaa972af7f3}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setHostName@{setHostName}}
\index{setHostName@{setHostName}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setHostName()}{setHostName()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+Host\+Name (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{host }\end{DoxyParamCaption})}



Sets the hostname to use for the next connection to the server. 

Invalid hostnames will cause an exception to be thrown when the connection is opened.


\begin{DoxyParams}{Parameters}
{\em host} & the hostname to use for the next connection to the server\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setHostName(host);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ad64b2409e602054d6e29257442b8601e}\label{class_qore_1_1_s_q_l_1_1_datasource_ad64b2409e602054d6e29257442b8601e}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setOption@{setOption}}
\index{setOption@{setOption}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setOption()}{setOption()}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+Datasource\+::set\+Option (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{opt,  }\item[{auto}]{val }\end{DoxyParamCaption})}



sets an option for the datasource 


\begin{DoxyParams}{Parameters}
{\em opt} & the option to set \\
\hline
{\em val} & the value to set\\
\hline
\end{DoxyParams}
\begin{DoxyNote}{Note}
in order to ensure atomicity when dealing with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} options, the transaction lock is acquired before executing this method if it was not already owned by the calling thread
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em DBI-\/\+OPTION-\/\+ERROR} & unknown or unsupported option passed to driver \\
\hline
{\em DATASOURCE-\/\+ERROR} & the datasource must be open for this call \\
\hline
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a1ecea098e3d8f0d256f088f85d8e4ae4}\label{class_qore_1_1_s_q_l_1_1_datasource_a1ecea098e3d8f0d256f088f85d8e4ae4}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setPassword@{setPassword}}
\index{setPassword@{setPassword}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setPassword()}{setPassword()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+Password (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{pass }\end{DoxyParamCaption})}



Sets the password parameter for the time a connection to the server is established. 

Invalid passwords will cause an exception to be thrown when the connection is opened


\begin{DoxyParams}{Parameters}
{\em pass} & the password parameter for the time a connection to the server is established\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setPassword(\textcolor{keywordflow}{pass});}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a9c1dee4070b3ac1998bad8294307628b}\label{class_qore_1_1_s_q_l_1_1_datasource_a9c1dee4070b3ac1998bad8294307628b}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setPort@{setPort}}
\index{setPort@{setPort}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setPort()}{setPort()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+Port (\begin{DoxyParamCaption}\item[{softint}]{port = {\ttfamily 0} }\end{DoxyParamCaption})}



Sets the port number to use for the connection. 

Invalid port numbers will cause an exception to be thrown when the connection is opened


\begin{DoxyParams}{Parameters}
{\em port} & the port number to use for the connection\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setPort(port);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aed11f75205cdbf0d16243c7ccc57d21a}\label{class_qore_1_1_s_q_l_1_1_datasource_aed11f75205cdbf0d16243c7ccc57d21a}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setTransactionLockTimeout@{setTransactionLockTimeout}}
\index{setTransactionLockTimeout@{setTransactionLockTimeout}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setTransactionLockTimeout()}{setTransactionLockTimeout()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+Transaction\+Lock\+Timeout (\begin{DoxyParamCaption}\item[{timeout}]{timeout\+\_\+ms = {\ttfamily 0} }\end{DoxyParamCaption})}



Sets the transaction lock timeout value in milliseconds; set to 0 for no timeout. 


\begin{DoxyParams}{Parameters}
{\em timeout\+\_\+ms} & the transaction lock timeout value in milliseconds; set to 0 for no timeout. Like all Qore functions and methods taking timeout values, a \mbox{\hyperlink{basic_data_types_relative_dates}{relative date/time value}} may be passed instead of an integer to make the timeout units clear (ex\+: {\ttfamily 2500ms} for 2.\+5 seconds).\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setTransactionLockTimeout(4s);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a86c204c7e2b1cceb46ca1f7ffeb007cd}\label{class_qore_1_1_s_q_l_1_1_datasource_a86c204c7e2b1cceb46ca1f7ffeb007cd}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!setUserName@{setUserName}}
\index{setUserName@{setUserName}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{setUserName()}{setUserName()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+Datasource\+::set\+User\+Name (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{user }\end{DoxyParamCaption})}



Sets the username parameter for the time a connection to the server is established. 

Invalid usernames will cause an exception to be thrown when the connection is opened


\begin{DoxyParams}{Parameters}
{\em user} & the username parameter for the time a connection to the server is established\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{db.setUserName(user);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_afb6307ab9be490fa5d770519bca9447c}\label{class_qore_1_1_s_q_l_1_1_datasource_afb6307ab9be490fa5d770519bca9447c}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!transactionTid@{transactionTid}}
\index{transactionTid@{transactionTid}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{transactionTid()}{transactionTid()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+SQL\+::\+Datasource\+::transaction\+Tid (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the TID of the thread holding the transaction lock or -\/1 if it\textquotesingle{}s not currently held. 

If the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object is used in a multithreaded context and if the transaction lock is not held by the current thread, then the transaction lock status could change at any time.

\begin{DoxyReturn}{Returns}
the TID of the thread holding the transaction lock or -\/1 if it\textquotesingle{}s not currently held
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int tid = db.transactionTid();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a5661e26369193015c195166e52c6d121}{Datasource\+::current\+Thread\+In\+Transaction()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+7 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_aeba8bbff7570f5696e78ecb33a6a6fe0}\label{class_qore_1_1_s_q_l_1_1_datasource_aeba8bbff7570f5696e78ecb33a6a6fe0}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!vexec@{vexec}}
\index{vexec@{vexec}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{vexec()}{vexec()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::vexec (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{\+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Grabs the transaction lock (if autocommit is disabled) and executes SQL code on the DB connection, taking a list for all bind arguments. 

Same as \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a226b0fa3f5fdc4da16d8dda6703f1fdb}{Datasource\+::exec()}} except takes an explicit list for bind arguments

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em vargs} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
The return value depends on the DBI driver; normally, for commands with placeholders, a hash is returned holding the values acquired from executing the SQL statement. For all other commands, normally an integer row count is returned. However, some DBI drivers also allow select statements to be executed through this interface, which would also return a hash (column names) of lists (values for each column).
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int rows = db.vexec(\textcolor{stringliteral}{"{}insert into example\_table value (\%v, \%v, \%v)"{}}, arg\_list);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a68f3f2fd0d820097db47aac8cc9912fe}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_ad3c563a57ad19083a2bce99b17d1a59c}\label{class_qore_1_1_s_q_l_1_1_datasource_ad3c563a57ad19083a2bce99b17d1a59c}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!vselect@{vselect}}
\index{vselect@{vselect}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{vselect()}{vselect()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::vselect (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{\+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes a select statement on the server and returns the results in a hash (column names) of lists (column values per row), taking a list for all bind arguments. 

The return format of this method is suitable for use with \mbox{\hyperlink{statements_context}{context statements}}, for easy iteration and processing of query results. Alternatively, the \mbox{\hyperlink{class_qore_1_1_hash_list_iterator}{Hash\+List\+Iterator}} class can be used to iterate the return value of this method.

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}

This method does not retain the transaction lock if it was not already acquired before this method is called, so to execute select statements that begin a transaction (such as {\ttfamily \char`\"{}select for update\char`\"{}}), execute \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} first to ensure that the transaction lock is dedicated to the calling thread.


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em vargs} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
Normally returns a hash (the keys are the column names) of list (each hash key\textquotesingle{}s value is a list giving the row data), however some DBI drivers allow any SQL statement to be executed through this method (not only select statements), in this case other data types can be returned. If no rows are found, a hash of column names assigned to empty lists is returned.
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{hash<auto> query = db.vselect(\textcolor{stringliteral}{"{}select * from example\_table where id = \%v and name = \%v"{}}, arg\_list);}
\DoxyCodeLine{\textcolor{keywordflow}{if} (query.firstValue())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}got results\(\backslash\)n"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item See the documentation for the DBI driver being used for additional possible exceptions
\item This method returns all the data available immediately; to process query data piecewise, use the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8hashzzz9_aab3d2e6e69d212dbe05de43136f14367}{Qore\+::zzz8hashzzz9\+::context\+Iterator()}}
\item \mbox{\hyperlink{statements_context}{context Statements}} 
\end{DoxyItemize}
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_ac1dd6bceaddef45dc6db0001dc142180}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a296ec4a2c0cab82bc3514f851e1b8abd}\label{class_qore_1_1_s_q_l_1_1_datasource_a296ec4a2c0cab82bc3514f851e1b8abd}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!vselectRow@{vselectRow}}
\index{vselectRow@{vselectRow}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{vselectRow()}{vselectRow()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+Datasource\+::vselect\+Row (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{\+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes a select statement on the server and returns the first row as a hash (column names and values), taking a list for all bind arguments. 

This method is the same as the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a11f5fdffd9031ba2d0bf6b8c8b447314}{Datasource\+::select\+Row()}} method, except this method takes a single argument after the SQL command giving the list of bind value parameters

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}

This method does not retain the transaction lock if it was not already acquired before this method is called, so to execute select statements that begin a transaction (such as {\ttfamily \char`\"{}select for update\char`\"{}}), execute \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} first to ensure that the transaction lock is dedicated to the calling thread.


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em vargs} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
This method returns a hash (the keys are the column names) of row data or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no row is found for the query when executed with an SQL select statement
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*hash<auto> h = db.vselectRow(\textcolor{stringliteral}{"{}select * from example\_table where id = \%v and type = \%v"{}}, arg\_list);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
see the documentation for the DBI driver being used for additional possible exceptions
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a11f5fdffd9031ba2d0bf6b8c8b447314}{Datasource\+::select\+Row()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_a82bd28bd70590c4519053d058d61e0e6}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_datasource_a9145f5c598980a4685943e194a899ed4}\label{class_qore_1_1_s_q_l_1_1_datasource_a9145f5c598980a4685943e194a899ed4}} 
\index{Qore::SQL::Datasource@{Qore::SQL::Datasource}!vselectRows@{vselectRows}}
\index{vselectRows@{vselectRows}!Qore::SQL::Datasource@{Qore::SQL::Datasource}}
\doxysubsubsection{\texorpdfstring{vselectRows()}{vselectRows()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+Datasource\+::vselect\+Rows (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{\+\_\+\+\_\+7\+\_\+ softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes a select statement on the server and returns the results in a list (rows) of hashes (column names and values), taking a list for all bind arguments. 

Same as the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}{Datasource\+::select\+Rows()}} method, except this method takes a single argument after the SQL command giving the list of bind value parameters.

The usual return value of this method can be iterated with the \mbox{\hyperlink{class_qore_1_1_list_hash_iterator}{List\+Hash\+Iterator}} class.

The return format of this method is not as memory efficient as that returned by the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}} method, therefore for larger amounts of data, it is recommended to use \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a05b1d0d126d815b2d7578e5ce8b9a0de}{Datasource\+::select()}}.

This method also accepts all bind parameters ({\ttfamily \%d}, {\ttfamily \%v}, {\ttfamily \%s}, etc) as documented in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_sql_binding}{Binding by Value and Placeholder}}

This method does not retain the transaction lock if it was not already acquired before this method is called, so to execute select statements that begin a transaction (such as {\ttfamily \char`\"{}select for update\char`\"{}}), execute \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a3be309ce31c8b980aaee71010c3048f0}{Datasource\+::begin\+Transaction()}} first to ensure that the transaction lock is dedicated to the calling thread.


\begin{DoxyParams}{Parameters}
{\em sql} & The SQL command to execute on the server \\
\hline
{\em vargs} & Include any values to be bound (using {\ttfamily \%v} in the command string) or placeholder specifications (using {\ttfamily \+:}{\itshape key\+\_\+name} in the command string) in order after the command string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
Normally returns a list (rows) of hash (where the keys are the column names of each row) or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no rows are found for the query, however some DBI drivers allow any SQL statement to be executed through this method (not only select statements), in this case other data types can be returned
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*list<auto> list = db.vselectRows(\textcolor{stringliteral}{"{}select * from example\_table where id = \%v and type = \%v"{}}, arg\_list);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TRANSACTION-\/\+LOCK-\/\+TIMEOUT} & Timeout trying to acquire the transaction lock\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item See the documentation for the DBI driver being used for additional possible exceptions
\item This method returns all the data available immediately; to process query data piecewise, use the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_a41126ab5a3d9e11ee7dd6d7975dfd65a}{Datasource\+::select\+Rows()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_datasource_afe2104486bab27d21e47760edae79cf3}{Qore\+::\+SQL\+::\+Abstract\+Datasource}}.

