/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_RETURN = 258,
     TOK_RETURNS = 259,
     TOK_MY = 260,
     TOK_DO = 261,
     TOK_TRY = 262,
     TOK_THROW = 263,
     TOK_CATCH = 264,
     TOK_WHERE = 265,
     TOK_WHILE = 266,
     TOK_IF = 267,
     TOK_FOR = 268,
     TOK_SUB = 269,
     TOK_THREAD_EXIT = 270,
     TOK_BREAK = 271,
     TOK_CONTINUE = 272,
     TOK_CONTEXT_ROW = 273,
     TOK_FIND = 274,
     TOK_FOREACH = 275,
     TOK_IN = 276,
     TOK_DELETE = 277,
     TOK_REMOVE = 278,
     TOK_PRIVATE = 279,
     TOK_PRIVATEINTERNAL = 280,
     TOK_PRIVATEHIERARCHY = 281,
     TOK_PUBLIC = 282,
     TOK_SYNCHRONIZED = 283,
     TOK_DEPRECATED = 284,
     TOK_CONTEXT = 285,
     TOK_SORT_BY = 286,
     TOK_SORT_DESCENDING_BY = 287,
     TOK_SUB_CONTEXT = 288,
     TOK_CONST = 289,
     TOK_SUMMARIZE = 290,
     TOK_BY = 291,
     TOK_OUR = 292,
     TOK_RETHROW = 293,
     TOK_SWITCH = 294,
     TOK_CASE = 295,
     TOK_DEFAULT = 296,
     TOK_INHERITS = 297,
     TOK_ELSE = 298,
     TOK_STATIC = 299,
     TOK_NAMESPACE = 300,
     TOK_MODULE = 301,
     TOK_FINAL = 302,
     TOK_ABSTRACT = 303,
     TOK_HASHDECL = 304,
     TOK_UNREFERENCE = 305,
     P_INCREMENT = 306,
     P_DECREMENT = 307,
     PLUS_EQUALS = 308,
     MINUS_EQUALS = 309,
     AND_EQUALS = 310,
     OR_EQUALS = 311,
     MODULA_EQUALS = 312,
     MULTIPLY_EQUALS = 313,
     DIVIDE_EQUALS = 314,
     XOR_EQUALS = 315,
     SHIFT_LEFT_EQUALS = 316,
     SHIFT_RIGHT_EQUALS = 317,
     TOK_UNSHIFT = 318,
     TOK_PUSH = 319,
     TOK_POP = 320,
     TOK_SHIFT = 321,
     TOK_CHOMP = 322,
     TOK_TRIM = 323,
     LOGICAL_AND = 324,
     LOGICAL_OR = 325,
     BROKEN_LOGICAL_OR = 326,
     BROKEN_BINARY_OR = 327,
     BROKEN_BINARY_XOR = 328,
     LOGICAL_EQ = 329,
     LOGICAL_NE = 330,
     LOGICAL_LE = 331,
     LOGICAL_GE = 332,
     LOGICAL_CMP = 333,
     ABSOLUTE_EQ = 334,
     ABSOLUTE_NE = 335,
     REGEX_MATCH = 336,
     REGEX_NMATCH = 337,
     TOK_EXISTS = 338,
     TOK_INSTANCEOF = 339,
     SHIFT_RIGHT = 340,
     SHIFT_LEFT = 341,
     TOK_ELEMENTS = 342,
     TOK_KEYS = 343,
     TOK_NEW = 344,
     TOK_BACKGROUND = 345,
     TOK_ON_EXIT = 346,
     TOK_ON_SUCCESS = 347,
     TOK_ON_ERROR = 348,
     TOK_MAP = 349,
     TOK_FOLDR = 350,
     TOK_FOLDL = 351,
     TOK_SELECT = 352,
     TOK_SPLICE = 353,
     TOK_EXTRACT = 354,
     IMPLICIT_ELEMENT = 355,
     NULL_COALESCING = 356,
     VALUE_COALESCING = 357,
     WEAK_ASSIGNMENT = 358,
     RANGE = 359,
     INTEGER = 360,
     QFLOAT = 361,
     NUMBER = 362,
     IDENTIFIER = 363,
     HASHDECL_IDENTIFIER_OPENCURLY = 364,
     ANGLE_IDENTIFIER = 365,
     VAR_REF = 366,
     BACKQUOTE = 367,
     SELF_REF = 368,
     KW_IDENTIFIER_OPENPAREN = 369,
     SCOPED_REF = 370,
     SCOPED_VREF = 371,
     CONTEXT_REF = 372,
     COMPLEX_CONTEXT_REF = 373,
     QORE_CAST = 374,
     CLASS_STRING = 375,
     DATETIME = 376,
     QUOTED_WORD = 377,
     BINARY = 378,
     REGEX_SUBST = 379,
     REGEX_TRANS = 380,
     CLASS_SCOPED_REF = 381,
     BASE_CLASS_CALL = 382,
     REGEX = 383,
     REGEX_EXTRACT = 384,
     IMPLICIT_ARG_REF = 385,
     DOT_KW_IDENTIFIER = 386,
     TRY_MODULE_ERROR = 387,
     IFX = 388,
     NEG = 389,
     UPLUS = 390
   };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PRIVATEINTERNAL 280
#define TOK_PRIVATEHIERARCHY 281
#define TOK_PUBLIC 282
#define TOK_SYNCHRONIZED 283
#define TOK_DEPRECATED 284
#define TOK_CONTEXT 285
#define TOK_SORT_BY 286
#define TOK_SORT_DESCENDING_BY 287
#define TOK_SUB_CONTEXT 288
#define TOK_CONST 289
#define TOK_SUMMARIZE 290
#define TOK_BY 291
#define TOK_OUR 292
#define TOK_RETHROW 293
#define TOK_SWITCH 294
#define TOK_CASE 295
#define TOK_DEFAULT 296
#define TOK_INHERITS 297
#define TOK_ELSE 298
#define TOK_STATIC 299
#define TOK_NAMESPACE 300
#define TOK_MODULE 301
#define TOK_FINAL 302
#define TOK_ABSTRACT 303
#define TOK_HASHDECL 304
#define TOK_UNREFERENCE 305
#define P_INCREMENT 306
#define P_DECREMENT 307
#define PLUS_EQUALS 308
#define MINUS_EQUALS 309
#define AND_EQUALS 310
#define OR_EQUALS 311
#define MODULA_EQUALS 312
#define MULTIPLY_EQUALS 313
#define DIVIDE_EQUALS 314
#define XOR_EQUALS 315
#define SHIFT_LEFT_EQUALS 316
#define SHIFT_RIGHT_EQUALS 317
#define TOK_UNSHIFT 318
#define TOK_PUSH 319
#define TOK_POP 320
#define TOK_SHIFT 321
#define TOK_CHOMP 322
#define TOK_TRIM 323
#define LOGICAL_AND 324
#define LOGICAL_OR 325
#define BROKEN_LOGICAL_OR 326
#define BROKEN_BINARY_OR 327
#define BROKEN_BINARY_XOR 328
#define LOGICAL_EQ 329
#define LOGICAL_NE 330
#define LOGICAL_LE 331
#define LOGICAL_GE 332
#define LOGICAL_CMP 333
#define ABSOLUTE_EQ 334
#define ABSOLUTE_NE 335
#define REGEX_MATCH 336
#define REGEX_NMATCH 337
#define TOK_EXISTS 338
#define TOK_INSTANCEOF 339
#define SHIFT_RIGHT 340
#define SHIFT_LEFT 341
#define TOK_ELEMENTS 342
#define TOK_KEYS 343
#define TOK_NEW 344
#define TOK_BACKGROUND 345
#define TOK_ON_EXIT 346
#define TOK_ON_SUCCESS 347
#define TOK_ON_ERROR 348
#define TOK_MAP 349
#define TOK_FOLDR 350
#define TOK_FOLDL 351
#define TOK_SELECT 352
#define TOK_SPLICE 353
#define TOK_EXTRACT 354
#define IMPLICIT_ELEMENT 355
#define NULL_COALESCING 356
#define VALUE_COALESCING 357
#define WEAK_ASSIGNMENT 358
#define RANGE 359
#define INTEGER 360
#define QFLOAT 361
#define NUMBER 362
#define IDENTIFIER 363
#define HASHDECL_IDENTIFIER_OPENCURLY 364
#define ANGLE_IDENTIFIER 365
#define VAR_REF 366
#define BACKQUOTE 367
#define SELF_REF 368
#define KW_IDENTIFIER_OPENPAREN 369
#define SCOPED_REF 370
#define SCOPED_VREF 371
#define CONTEXT_REF 372
#define COMPLEX_CONTEXT_REF 373
#define QORE_CAST 374
#define CLASS_STRING 375
#define DATETIME 376
#define QUOTED_WORD 377
#define BINARY 378
#define REGEX_SUBST 379
#define REGEX_TRANS 380
#define CLASS_SCOPED_REF 381
#define BASE_CLASS_CALL 382
#define REGEX 383
#define REGEX_EXTRACT 384
#define IMPLICIT_ARG_REF 385
#define DOT_KW_IDENTIFIER 386
#define TRY_MODULE_ERROR 387
#define IFX 388
#define NEG 389
#define UPLUS 390




/* Copy the first part of user declarations.  */
#line 1 "parser.ypp"
 /* -*- mode: c++; indent-tabs-mode: nil -*-

  parser.ypp

  Qore Programming Language

  Copyright (C) 2003 - 2018 Qore Technologies, s.r.o.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.

  Note that the Qore library is released under a choice of three open-source
  licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
  information.
*/

#include "qore/Qore.h"
#include "qore/intern/BreakStatement.h"
#include "qore/intern/ContinueStatement.h"
#include "qore/intern/ReturnStatement.h"
#include "qore/intern/RethrowStatement.h"
#include "qore/intern/ThreadExitStatement.h"
#include "qore/intern/ExpressionStatement.h"
#include "qore/intern/DoWhileStatement.h"
#include "qore/intern/SummarizeStatement.h"
#include "qore/intern/ContextStatement.h"
#include "qore/intern/IfStatement.h"
#include "qore/intern/WhileStatement.h"
#include "qore/intern/ForStatement.h"
#include "qore/intern/ForEachStatement.h"
#include "qore/intern/TryStatement.h"
#include "qore/intern/ThrowStatement.h"
#include "qore/intern/StatementBlock.h"
#include "qore/intern/ParserSupport.h"
#include "qore/intern/SwitchStatement.h"
#include "qore/intern/CaseNodeWithOperator.h"
#include "qore/intern/CaseNodeRegex.h"
#include "qore/intern/OnBlockExitStatement.h"
#include "qore/intern/ConstantList.h"
#include "qore/intern/GlobalVariableList.h"
#include "qore/intern/QoreNamespaceIntern.h"
#include "qore/intern/QoreParseHashNode.h"
#include "qore/intern/QoreParseListNode.h"
#include "qore/intern/ModuleInfo.h"

#include "parser.hpp"

#include "qore/intern/QoreClassIntern.h"
#include "qore/intern/qore_program_private.h"
#include "qore/intern/typed_hash_decl_private.h"
#include "qore/intern/qore_list_private.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <memory>
#include <utility>
#include <vector>
#include <sstream>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                      \
   do                                                        \
      if (N) {                                               \
         (Current).first_line = YYRHSLOC(Rhs, 1).first_line; \
         (Current).first_col  = YYRHSLOC(Rhs, 1).first_col;  \
         (Current).last_line  = YYRHSLOC(Rhs, N).last_line;  \
         (Current).last_col   = YYRHSLOC(Rhs, N).last_col;   \
      }                                                      \
      else {                                                 \
         (Current).first_line = (Current).last_line =        \
            YYRHSLOC(Rhs, 0).last_line;                      \
         (Current).first_col = (Current).last_col =          \
            YYRHSLOC(Rhs, 0).last_col;                       \
      }                                                      \
   while (0)

class HashElement {
public:
   AbstractQoreNode* key;
   AbstractQoreNode* value;
   QoreProgramLocation loc;

   DLLLOCAL HashElement(AbstractQoreNode* k, AbstractQoreNode* v, int sl, int el) : key(k), value(v), loc(sl, el) {
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL ~HashElement() {
      discard(key, nullptr);
      discard(value, nullptr);
   }

   DLLLOCAL void addDelete(QoreParseHashNode* h) {
      h->add(key, value, loc);
      key = value = nullptr;
      delete this;
   }
};

static AbstractQoreNode* makeErrorTree(AbstractQoreNode* left, AbstractQoreNode* right) {
   discard(left, nullptr);
   discard(right, nullptr);
   return &False;
}

// for constant definitions
class ConstNode {
public:
   QoreProgramLocation loc;
   NamedScope name;
   AbstractQoreNode* value;
   bool pub;

   DLLLOCAL ConstNode(const QoreProgramLocation& loc, char* n, AbstractQoreNode* v, bool p = false) : loc(loc), name(n), value(v), pub(p) {
      // see if constant definitions are allowed
      if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
         parse_error(loc, "illegal constant definition \"%s\" (conflicts with parse option PO_NO_CONSTANT_DEFS)", n);
   }
   DLLLOCAL AbstractQoreNode* takeValue() {
      AbstractQoreNode* rv = value;
      value = nullptr;
      return rv;
   }
   DLLLOCAL const std::string& getName() const {
      return name.getIdentifierStr();
   }
   DLLLOCAL bool isPublic() const {
      return pub;
   }
};

class ObjClassDef {
public:
   QoreProgramLocation loc;
   NamedScope* name;
   QoreClass* oc;

   DLLLOCAL ObjClassDef(const QoreProgramLocation& loc, NamedScope *n, QoreClass* o) : loc(loc), name(n), oc(o) {
      checkName();
   }

   DLLLOCAL ObjClassDef(const QoreProgramLocation& loc, char* n, QoreClass* o) : loc(loc), name(new NamedScope(n)), oc(o) {
      checkName();
   }

   DLLLOCAL ~ObjClassDef() {
      delete name;
   }

   DLLLOCAL void checkName() {
      if (!strcmp(name->getIdentifier(), "auto"))
         parse_error(loc, "a class may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your class");
   }
};

class HashDeclDef {
public:
   QoreProgramLocation loc;
   NamedScope* name;
   TypedHashDecl* hashdecl;

   DLLLOCAL HashDeclDef(const QoreProgramLocation& loc, NamedScope *n, typed_hash_decl_private* hp) :
        loc(loc), name(n), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
      checkName();
   }

   DLLLOCAL HashDeclDef(const QoreProgramLocation& loc, char* n, typed_hash_decl_private* hp) :
        loc(loc), name(new NamedScope(n)), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
      checkName();
   }

   DLLLOCAL ~HashDeclDef() {
      delete name;
      if (hashdecl)
         typed_hash_decl_private::get(*hashdecl)->deref();
   }

   DLLLOCAL void checkName() {
      if (!strcmp(name->getIdentifier(), "auto"))
         parse_error(loc, "a hashdecl may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your hashdecl");
   }

   DLLLOCAL TypedHashDecl* takeHashDecl() {
      TypedHashDecl* rv = hashdecl;
      hashdecl = nullptr;
      return rv;
   }
};

class ParseUserFunctionBase {
public:
   QoreProgramLocation loc;
   UserFunctionVariant* variant;

   DLLLOCAL ParseUserFunctionBase(const QoreProgramLocation& loc, UserFunctionVariant* v) : loc(loc), variant(v) {
   }

   DLLLOCAL ~ParseUserFunctionBase() {
      if (variant)
         variant->deref();
   }

   DLLLOCAL void setPublic() {
      variant->setModulePublic();
   }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
   char* name;

   DLLLOCAL ParseUserFunction(const QoreProgramLocation& loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
   }

   DLLLOCAL ~ParseUserFunction() {
      if (name)
         free(name);
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
         const char* nsn = ns.name.c_str();
         parse_error(loc, "function '%s%s%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
      }

      delete this;
   }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
   NamedScope name;

   DLLLOCAL ParseScopedUserFunction(const QoreProgramLocation& loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
         parse_error(loc, "function '%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", name.ostr);

      delete this;
   }
};

struct GVarDecl {
   QoreProgramLocation loc;
   bool pub;

   DLLLOCAL GVarDecl(const QoreProgramLocation& loc, bool p) : loc(loc), pub(p) {
   }

   DLLLOCAL virtual ~GVarDecl() {
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

   DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
   char* name;
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL GVarSingleDecl(const QoreProgramLocation& loc, char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(loc, p), name(n), typeInfo(ti), parseTypeInfo(pti) {
      //printd(5, "GVarSingleDecl::GVarSingleDecl() '%s' %d-%d\n", n, loc.start_line, loc.end_line);
      if (bare) {
         if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error(loc, "global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
      }
      else {
         if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error(loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
      }
   }

   DLLLOCAL virtual ~GVarSingleDecl() {
      if (name)
         free(name);

      delete parseTypeInfo;
   }

   DLLLOCAL char* takeName() {
      char* rv = name;
      name = 0;
      return rv;
   }

   DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = nullptr;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ns.parseAddGlobalVarDecl(loc, takeName(), typeInfo, takeParseTypeInfo(), pub);
      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      GlobalVarRefNode* gv = typeInfo
         ? new GlobalVarRefNode(loc, takeName(), typeInfo)
         : new GlobalVarRefNode(loc, takeName(), takeParseTypeInfo());
      if (pub)
         gv->setPublic();

      delete this;
      return gv;
   }
};

struct GVarListDecl : public GVarDecl {
   QoreParseListNode* l;

   DLLLOCAL GVarListDecl(const QoreProgramLocation& loc, QoreParseListNode* list, bool p) : GVarDecl(loc, p), l(list) {
      bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

      QoreParseListNode::nvec_t& vl = l->getValues();
      for (unsigned i = 0; i < vl.size(); ++i) {
         AbstractQoreNode* n = vl[i];
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            if (!bareok)
               parse_error(loc, "global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (vrn->explicitScope()) {
               if (vrn->getType() == VT_LOCAL)
                  parse_error(loc, "illegal use of 'my %s' in global variable declaration list", vrn->getName());
               else if (vrn->getType() == VT_GLOBAL)
                  parse_error(loc, "illegal use of 'our %s' in global variable declaration list", vrn->getName());
            }
         }
         else
            parse_error(loc, "element %d in list following 'our' is not a variable reference (%s)", i, get_type_name(n));
      }
   }

   DLLLOCAL virtual ~GVarListDecl() {
      if (l)
         l->deref(0);
   }

   DLLLOCAL QoreParseListNode* takeList() {
      QoreParseListNode* rv = l;
      l = nullptr;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      QoreParseListNode::nvec_t& vl = l->getValues();
      for (unsigned i = 0; i < vl.size(); ++i) {
         AbstractQoreNode* n = vl[i];
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            ns.parseAddGlobalVarDecl(loc, b->takeString(), 0, 0, pub);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
               if (vrdn)
                  ns.parseAddGlobalVarDecl(loc, vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
               else
                  ns.parseAddGlobalVarDecl(loc, vrn->takeName(), 0, 0, pub);
            }
         }
      }

      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      l->setVariableList();
      QoreParseListNode::nvec_t& vl = l->getValues();
      for (unsigned i = 0; i < vl.size(); ++i) {
         AbstractQoreNode*& n = vl[i];
         qore_type_t t = get_node_type(n);
         VarRefNode* vrn = nullptr;
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            GlobalVarRefNode* v = new GlobalVarRefNode(loc, b->takeString());
            b->deref();
            n = vrn = v;
         }
         else if (t == NT_VARREF) {
            vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               vrn->makeGlobal();
               vrn->setExplicitScope();
            }
         }

         if (vrn && pub)
            vrn->setPublic();
      }

      QoreParseListNode* rv = takeList();
      delete this;
      return rv;
   }
};

static int check_method(const QoreProgramLocation& loc, const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error(loc, "%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error(loc, "base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PUBLIC     (1 << 0)
#define OFM_PRIVATE    (1 << 1)
#define OFM_INTERNAL   (1 << 2)
#define OFM_SYNCED     (1 << 3)
#define OFM_STATIC     (1 << 4)
#define OFM_DEPRECATED (1 << 5)
#define OFM_FINAL      (1 << 6)
#define OFM_ABSTRACT   (1 << 7)

static inline MethodVariantBase* new_method_variant(const QoreProgramLocation& loc, const char* name, int mod, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
   //printd(5, "new_method_variant() '%s' b: %p\n", name, b);

   int64 flags = QC_NO_FLAGS;

   if (get_pop_argv_ref())
      flags |= QC_USES_EXTRA_ARGS;

   ClassAccess access = Public;
   if (mod & OFM_PRIVATE) {
      if (mod & OFM_INTERNAL)
         parse_error(loc, "%s() methods cannot be both private:hierarchy and private:internal", name);
      if (mod & OFM_PUBLIC)
         parse_error(loc, "%s() methods cannot be both public and private", name);
      access = Private;
   }
   else if (mod & OFM_INTERNAL) {
      if (mod & OFM_PUBLIC)
         parse_error(loc, "%s() methods cannot be both public and private", name);
      access = Internal;
   }

   if (mod & OFM_DEPRECATED)
      flags |= QC_DEPRECATED;

   if (!strcmp(name, "constructor")) {
      if (mod & OFM_SYNCED)
         parse_error(loc, "%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error(loc, "%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error(loc, "return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      return new UserConstructorVariant(access, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
   }
   if (bcal) {
      parse_error(loc, "only constructors may have base class constructor arguments");
      delete bcal;
      bcal = 0;
   }
   if (!strcmp(name, "destructor")) {
      if (params) {
         parse_error(loc, "parameters cannot be defined for destructors");
         params->deref(nullptr);
      }
      if (mod & OFM_SYNCED)
         parse_error(loc, "%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error(loc, "%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error(loc, "return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      if (access > Public)
          parse_error(loc, "destructors cannot be private");
      return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
   }
   if (!strcmp(name, "copy")) {
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; declare the class final instead", name);
      return new UserCopyVariant(access, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
   }

   if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; they are not inherited anyway", name);
      if (mod & OFM_ABSTRACT)
         parse_error(loc, "%s() methods cannot be declared abstract; they are not inherited anyway", name);
   }

   if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
      parse_error(loc, "method '%s()' is declared both final and abstract", name);

   return new UserMethodVariant(access, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
   QoreProgramLocation loc;
   MethodVariantBase* m;
   NamedScope name;
   bool static_flag;

   DLLLOCAL MethodDef(const QoreProgramLocation& loc, int mod, char* n, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : loc(loc), m(0), name(n), static_flag(mod & OFM_STATIC) {
      if (check_method(loc, name.getIdentifier(), bcal, returnTypeInfo)) {
         if (params)
            params->deref(0);
         delete bcal;
         delete b;
         delete returnTypeInfo;
         return;
      }

      m = new_method_variant(loc, name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
   }

   DLLLOCAL ~MethodDef() {
      delete m;
   }

   DLLLOCAL void parseAddToClassAndDel() {
      if (m) {
         // if there are any errors, the function below will delete memory
         // the following method takes ownership of "m" unconditionally
         qore_root_ns_private::parseAddMethodToClass(loc, name, m, static_flag);
         m = 0;
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      // the following method takes ownership of "m" unconditionally
      ns.parseAddMethodToClass(loc, name, m, static_flag);
      m = 0;
   }
};

static AbstractQoreNode* parse_hash_map(const QoreProgramLocation& loc, QoreParseHashNode* exp, QoreParseListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> exph(exp, 0);
   ReferenceHolder<> lh(l, 0);

   // check hash expression
   size_t len = exp->size();

   if (len == 0) {
       qore_program_private::makeParseWarning(getProgram(), loc, QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
            "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
       return new QoreHashNode;
   }

   if (len != 1) {
      parse_error(loc, "invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
      return &True;
   }

   if (l->size() == 1) {
      AbstractQoreNode* iter = l->shift();
      return new QoreHashMapOperatorNode(loc, exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter);
   }

   AbstractQoreNode* iter = l->shift();
   AbstractQoreNode* select = l->shift();
   return new QoreHashMapSelectOperatorNode(loc, exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter, select);
}

static AbstractQoreNode* parse_map(const QoreProgramLocation& loc, AbstractQoreNode* exp, QoreParseListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> lh(l, 0);

   if (l->size() == 1) {
      AbstractQoreNode* arg = l->shift();
      return new QoreMapOperatorNode(loc, exp, arg);
   }

   AbstractQoreNode* iterator_exp = l->shift();
   AbstractQoreNode* select_exp = l->shift();
   return new QoreMapSelectOperatorNode(loc, exp, iterator_exp, select_exp);
}

#define NSN_NONE     0
#define NSN_OCD      1
#define NSN_HASHDECL 2
#define NSN_CONST    3
#define NSN_NS       4
#define NSN_FUNC     5
#define NSN_SFUNC    6
#define NSN_VAR      7
#define NSN_METH     8

struct NSNode {
   int type;
   union {
      ObjClassDef* ocd;
      HashDeclDef* hashdecl;
      ConstNode* cn;
      QoreNamespace* ns;
      ParseUserFunction* func;
      ParseScopedUserFunction* sfunc;
      GVarDecl* gv;
      MethodDef* meth;
   } n;

   DLLLOCAL NSNode(ObjClassDef* o) { type = NSN_OCD; n.ocd = o; }
   DLLLOCAL NSNode(HashDeclDef* h) { type = NSN_HASHDECL; n.hashdecl = h; }
   DLLLOCAL NSNode(ConstNode* c) { type = NSN_CONST; n.cn = c; }
   DLLLOCAL NSNode(QoreNamespace* s) { type = NSN_NS; n.ns = s; }
   DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
      n.func = f;
   }
   DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
      n.sfunc = f;
   }

   DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
      n.gv = gv;
   }

   DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
      n.meth = m;
   }

   DLLLOCAL void deref() {
      switch (type) {
         case NSN_OCD:
            delete n.ocd;
            break;
         case NSN_HASHDECL:
            delete n.hashdecl;
            break;
         case NSN_CONST:
            delete n.cn;
            break;
         case NSN_NS:
            delete n.ns;
            break;
         case NSN_FUNC:
            delete n.func;
            break;
         case NSN_SFUNC:
            delete n.sfunc;
            break;
         case NSN_VAR:
            delete n.gv;
            break;
         case NSN_METH:
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      switch (type) {
         case NSN_OCD:
            //printd(5, "ocd: %s %d-%d c: %d-%d\n", n.ocd->oc->getName(), n.ocd->loc.start_line, n.ocd->loc.end_line, qore_class_private::get(*n.ocd->oc)->loc.start_line, qore_class_private::get(*n.ocd->oc)->loc.end_line);
            ns.parseAddPendingClass(n.ocd->loc, *(n.ocd->name), n.ocd->oc);
            delete n.ocd;
            break;
         case NSN_HASHDECL:
            ns.parseAddPendingHashDecl(n.hashdecl->loc, *(n.hashdecl->name), n.hashdecl->takeHashDecl());
            delete n.hashdecl;
            break;
         case NSN_CONST:
            ns.parseAddConstant(n.cn->loc, n.cn->name, n.cn->value, n.cn->pub);
            delete n.cn;
            break;
         case NSN_NS:
            ns.parseAddNamespace(n.ns);
            break;
         case NSN_FUNC:
            n.func->add(ns);
            break;
         case NSN_SFUNC:
            n.sfunc->add(ns);
            break;
         case NSN_VAR:
            n.gv->add(ns);
            break;
         case NSN_METH:
            n.meth->add(ns);
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
   DLLLOCAL void deref() {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->deref();

      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->add(ns);
   }
};

static QoreParseListNode* splice_expressions(AbstractQoreNode* a1, AbstractQoreNode* a2, const QoreProgramLocation& loc1, const QoreProgramLocation& loc2) {
   //tracein("splice_expressions()");
   if (a1 && a1->getType() == NT_PARSE_LIST) {
      QoreParseListNode* l = reinterpret_cast<QoreParseListNode*>(a1);
      if (!l->isFinalized()) {
         //printd(5, "LIST x\n");
         l->add(a2, loc2);
         return l;
      }
   }
   QoreParseListNode* l = new QoreParseListNode(QoreProgramLocation(loc1.start_line, loc2.end_line));
   l->add(a1, loc1);
   l->add(a2, loc2);
   return l;
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;
typedef std::pair<char*, HashDeclMemberInfo*> hashmem_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2
#define MI_HashMem 3

struct MemberInfo {
protected:
   DLLLOCAL MemberInfo(const QoreProgramLocation& loc) : loc(loc) {
   }

public:
   QoreProgramLocation loc;
   char* name;
   unsigned char type;
   union {
      QoreMemberInfo* memberInfo;
      QoreVarInfo* varInfo;
      HashDeclMemberInfo* hashMemberInfo;
      AbstractQoreNode* exp;
   } u;

   DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : loc(mi->loc), name(n), type(MI_Member) {
      u.memberInfo = mi;
      if (!(mi && mi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
         parse_error(mi->loc, "member '%s' declared without type information, but parse options require type information for all declarations", name);
   }

   DLLLOCAL MemberInfo(const QoreProgramLocation& loc, char* n, AbstractQoreNode* exp) : loc(loc), name(n), type(MI_Constant) {
      u.exp = exp;
   }

   DLLLOCAL MemberInfo(char* n, HashDeclMemberInfo* mi) : loc(mi->loc), name(n), type(MI_HashMem) {
      u.hashMemberInfo = mi;
   }

   DLLLOCAL ~MemberInfo() {
      if (name)
         free(name);
      switch (type) {
         case MI_Member:
            delete u.memberInfo;
            break;
         case MI_Var:
            delete u.varInfo;
            break;
         case MI_HashMem:
            delete u.hashMemberInfo;
            break;
         case MI_Constant:
            if (u.exp)
               u.exp->deref(0);
            break;
      }
   }

   DLLLOCAL member_pair_t getPair() {
      assert(type == MI_Member);
      member_pair_t m = std::make_pair(name, u.memberInfo);
      name = nullptr;
      u.memberInfo = nullptr;
      return m;
   }

   DLLLOCAL var_pair_t getVarPair() {
      assert(type == MI_Var);
      var_pair_t m = std::make_pair(name, u.varInfo);
      name = nullptr;
      u.varInfo = nullptr;
      return m;
   }

   DLLLOCAL hashmem_pair_t getHashMemPair() {
      assert(type == MI_HashMem);
      hashmem_pair_t m = std::make_pair(name, u.hashMemberInfo);
      name = nullptr;
      u.hashMemberInfo = nullptr;
      return m;
   }

   DLLLOCAL AbstractQoreNode* takeExp() {
      assert(type == MI_Constant);
      AbstractQoreNode* rv = u.exp;
      u.exp = nullptr;
      return rv;
   }
};

struct ClassVarInfo : public MemberInfo {
   DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) : MemberInfo(vi->loc) {
      name = n;
      type = MI_Var;
      u.varInfo = vi;
      if (!(vi && vi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
         parse_error(vi->loc, "class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
   }

   DLLLOCAL char* takeName() {
      char* n = name;
      name = nullptr;
      return n;
   }
};

class MemberList {
protected:
   // for new class members
   QoreMemberMap mmap;
   // for new class constants
   ConstantList cmap;
   // for new class static variables
   QoreVarMap vmap;

   DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
   }

public:
   DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
      if (!member)
         return;

      if (member->type == MI_Member)
         mmap.addNoCheck(member->getPair());
      else if (member->type == MI_Constant)
         cmap.parseAdd(member->loc, member->name, member->takeExp());
      else
         vmap.addNoCheck(member->getVarPair());

      delete member;
   }

   DLLLOCAL ~MemberList() {
   }

   // takes over ownership of name and typeInfo
   DLLLOCAL int add(MemberInfo* member) {
      if (!member)
         return -1;

      if (member->type == MI_Member) {
         if (mmap.inList(member->name)) {
            parse_error(member->loc, "duplicate member declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new member to list
         mmap.addNoCheck(member->getPair());
         delete member;
      }
      else if (member->type == MI_Constant) {
         if (cmap.inList(member->name)) {
            parse_error(member->loc, "duplicate constant declaration '%s'", member->name);
            delete member;
            return -1;
         }
         if (vmap.find(member->name)) {
            parse_error(member->loc, "constant declaration collides with static class variable declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new constant to list
         cmap.parseAdd(member->loc, member->name, member->takeExp());
         delete member;
      }
      else {
         assert(member->type == MI_Var);
         if (vmap.find(member->name)) {
            parse_error(member->loc, "duplicate static class variable declaration '%s'", member->name);
            delete member;
            return -1;
         }
         if (cmap.inList(member->name)) {
            parse_error(member->loc, "static class variable declaration collides with constant declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new member to list
         vmap.addNoCheck(member->getVarPair());
         delete member;
      }

      return 0;
   }

   DLLLOCAL void merge(QoreClass* qc, ClassAccess access) {
      mmap.moveAllTo(qc, access);
      vmap.moveAllTo(qc, access);

      // merge constants
      qore_class_private::get(*qc)->parseAssimilateConstants(cmap, access);
   }
};

class EmptyMemberList : public MemberList {
public:
   DLLLOCAL EmptyMemberList() {
   }
};

struct ParserTypeStruct {
protected:
   DLLLOCAL ParserTypeStruct() {
   }

public:
   const QoreTypeInfo* typeInfo = nullptr;
   QoreParseTypeInfo* parseTypeInfo = nullptr;

   DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : parseTypeInfo(n_parseTypeInfo) {
   }

   DLLLOCAL ParserTypeStruct(char* id, bool or_nothing) : typeInfo(or_nothing ? getBuiltinUserOrNothingTypeInfo(id) : getBuiltinUserTypeInfo(id)) {
      //printd(0, "ParserTypeStruct::ParserTypeStruct('%s', %d) t: %p %s\n", id, or_nothing, typeInfo, QoreTypeInfo::getName(typeInfo));
      if (typeInfo) {
         free(id);
         return;
      }

      parseTypeInfo = new QoreParseTypeInfo(id, or_nothing);
   }

   DLLLOCAL ~ParserTypeStruct() {
      delete parseTypeInfo;
   }

   DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
      return typeInfo;
   }

   // static version of method, checking for null pointer
   DLLLOCAL static const QoreTypeInfo* getTypeInfo(ParserTypeStruct* pts) {
      return pts ? pts->getTypeInfo() : nullptr;
   }

   DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = nullptr;
      return rv;
   }

   // static version of method, checking for null pointer
   DLLLOCAL static QoreParseTypeInfo* getParseTypeInfo(ParserTypeStruct* pts) {
      return pts ? pts->getParseTypeInfo() : nullptr;
   }

   DLLLOCAL const char* getClassName() {
      assert(parseTypeInfo);
      return parseTypeInfo->cscope->ostr;
   }

   DLLLOCAL static ParserTypeStruct* getType(QoreProgramLocation&& loc, char* id, bool or_nothing) {
      return new ParserTypeStruct(getParseType(loc, id, or_nothing));
   }

   DLLLOCAL static void getSubTypes(const QoreProgramLocation& loc, const char* str, parse_type_vec_t& subtypes, bool raise_error = true) {
      QoreString buf;
      bool or_nothing = false;
      bool comma = false;

      const char* p = str;
      while (true) {
         if (*p == '\0') {
            if (buf.empty()) {
               if (comma && raise_error)
                  parse_error(loc, "empty subtype specification in type");
            }
            else
               subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
            break;
         }
         switch (*p) {
            case '<': {
               if (buf.empty()) {
                  if (raise_error)
                     parse_error(loc, "invalid subtype specification in '%s'", str);
                  return;
               }
               const char* e = strrchr(str, '>');
               if (!e || e < p) {
                  if (raise_error)
                     parse_error(loc, "unbalanced angle brackets in subtype specification in '%s'", str);
                  return;
               }
               buf.concat(p, e - p + 1);
               //printd(5, "ST: '%s' (str: '%s') p: %p '%s'\n", buf.c_str(), str, p, p);
               subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
               buf.reset();
               or_nothing = false;
               //printd(5, "ST: p: %p -> %p\n", p, e);
               p = e;
               break;
            }
            case ',':
               buf.trim();
               if (buf.empty()) {
                  if (raise_error)
                     parse_error(loc, "invalid subtype specification in '%s'", str);
                  return;
               }
               subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing, raise_error));
               buf.reset();
               or_nothing = false;
               comma = true;
               break;
            case '*': {
               if (buf.empty())
                  or_nothing = true;
               else
                  buf.concat('*');
               if (comma)
                  comma = false;
               break;
            }
            case ' ':
            case '\t':
               if (!buf.empty())
                  buf.concat(*p);
               break;
            default:
               buf.concat(*p);
               if (comma)
                  comma = false;
               break;
         }
         ++p;
      }
   }

   DLLLOCAL static QoreParseTypeInfo* getParseType(const QoreProgramLocation& loc, char* id, bool or_nothing, bool raise_error = true) {
      //printd(0, "gPT() '%s'\n", id);
      char* p0 = strchr(id, '<');
      if (p0) {
         char* p1 = strrchr(id, '>');
         if (p1 > (p0 + 1)) {
            // terminate main type string
            *p0 = '\0';
            // terminate type args
            *p1 = '\0';

            parse_type_vec_t subtypes;
            getSubTypes(loc, p0 + 1, subtypes, raise_error);
            return new QoreParseTypeInfo(id, or_nothing, std::move(subtypes));
         }
      }
      return new QoreParseTypeInfo(id, or_nothing);
   }

   DLLLOCAL static const QoreTypeInfo* getRuntimeType(const char* str) {
      assert(str);
      assert(str[0]);
      char* p;
      bool or_nothing;
      if (str[0] == '*') {
         or_nothing = true;
         p = strdup(str + 1);
      }
      else {
         or_nothing = false;
         p = strdup(str);
      }
      std::unique_ptr<QoreParseTypeInfo> pt(ParserTypeStruct::getParseType(QoreProgramLocation(), p, or_nothing, false));
      return QoreParseTypeInfo::resolveRuntime(pt.get());
   }
};

const QoreTypeInfo* qore_get_type_from_string(const char* str) {
    ExceptionSink xsink;
    ProgramRuntimeParseAccessHelper pah(&xsink, getProgram());
    if (xsink) {
        xsink.clear();
        return nullptr;
    }

    return ParserTypeStruct::getRuntimeType(str);
}

static AbstractQoreNode* process_dot(int sline, int eline, AbstractQoreNode* l, AbstractQoreNode* r) {
   qore_type_t rtype = r->getType();
   switch (rtype) {
      case NT_BAREWORD: {
         BarewordNode* b = reinterpret_cast<BarewordNode*>(r);
         if (!b->isFinalized()) {
            AbstractQoreNode* rv = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation(sline, eline), l, b->makeQoreStringNode());
            b->deref();
            return rv;
         }
         break;
      }

      case NT_FUNCTION_CALL: {
         FunctionCallNode* f = reinterpret_cast<FunctionCallNode*>(r);
         assert(!f->getFunction());
         if (!f->isFinalized()) {
            MethodCallNode* m = new MethodCallNode(QoreProgramLocation(sline, eline), f->takeName(), f->takeParseArgs());
            f->deref();

            return new QoreDotEvalOperatorNode(QoreProgramLocation(sline, eline), l, m);
         }
         break;
      }
   }

   return new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation(sline, eline), l, r);
}

static int check_strong_encapsulation(const QoreProgramLocation& loc, const char* type, const char* name) {
   if (parse_check_parse_option(PO_STRONG_ENCAPSULATION)) {
      parse_error(loc, "illegal out of line %s definition \"%s\" (conflicts with parse option PO_STRONG_ENCAPSULATION)", type, name);
      return -1;
   }
   return 0;
}

static int check_case(const QoreProgramLocation& loc, const char* op, AbstractQoreNode* exp) {
   // ignore if NULL (= NOTHING)
   if (node_has_effect(exp)) {
      if (op)
         parse_error(loc, "case expression with '%s' needs run-time evaluation", op);
      else
         parse_error(loc, "case expression needs run-time evaluation", op);
      return -1;
   }
   return 0;
}

static void check_funcmod(const QoreProgramLocation& loc, int mod) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in function declaration");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in function declaration");
   if (mod & OFM_FINAL)
      parse_error(loc, "illegal 'final' modifier in function declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in function declaration");
}

static void check_classmod(const QoreProgramLocation& loc, int mod, QoreClass& qc) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error(loc, "illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error(loc, "illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in class declaration");
}

static void check_hashdeclmod(const QoreProgramLocation& loc, int mod, typed_hash_decl_private& hashdecl) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in hashdecl");
   if (mod & OFM_SYNCED)
      parse_error(loc, "illegal 'synchronized' modifier in hashdecl");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in hashdecl");
   if (mod & OFM_PUBLIC)
      hashdecl.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(loc, "illegal 'deprecated' modifier in hashdecl");
   if (mod & OFM_FINAL)
      parse_error(loc, "illegal 'final' modifier in hashdecl");
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in hashdecl");
}

static void check_nsmod(const QoreProgramLocation& loc, int mod, qore_ns_private& ns) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error(loc, "illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(loc, "illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error(loc, "illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
   if (!n || n->is_value())
      return false;

   if (n->getType() == NT_OPERATOR)
      return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

   const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
   return pn ? pn->has_effect() : true;
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }

   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }

   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }

   DLLLOCAL const QoreProgramLocation& getLoc() const {
      return m->getUserVariantBase()->getUserSignature()->getParseLocation();
   }
};

static AbstractQoreNode* is_rewritable_op(AbstractQoreNode* n) {
   qore_type_t nt = get_node_type(n);
   if (nt == NT_OPERATOR) {
      QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n);
      if (op)
         return op->getRight();
   }

   return 0;
}

static AbstractQoreNode* check_rewrite_list(QoreParseListNode* l) {
   if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
      return l;

   // rewrite expression if it's a list without parentheses and
   // the first expression has one of the following operators:
   // =, +=, -=
   if (l->isFinalized())
      return l;

   AbstractQoreNode* e0 = l->get(0);

   AbstractQoreNode* r = is_rewritable_op(e0);
   if (r) {
      AbstractQoreNode* last = e0;
      AbstractQoreNode* top = e0;
      while (true) {
         AbstractQoreNode* nr = is_rewritable_op(r);
         if (!nr)
            break;
         last = r;
         r = nr;
      }
      assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last));
      // take first element from list (the tree) and make it the new expression
      QoreBinaryLValueOperatorNode* op = reinterpret_cast<QoreBinaryLValueOperatorNode*>(last);
      l->swap(0, op->swapRight(l));
      return top;
   }

   return l;
}

void ignore_return_value(AbstractQoreNode* n) {
   qore_type_t t = get_node_type(n);
   if (t == NT_OPERATOR)
      reinterpret_cast<QoreOperatorNode*>(n)->ignoreReturnValue();
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static QoreOperatorNode* process_assignment(int sline, int eline, AbstractQoreNode* $1, AbstractQoreNode* $3) {
   return ($1 && $1->getType() == NT_PARSE_LIST)
      ? static_cast<QoreOperatorNode*>(new QoreListAssignmentOperatorNode(QoreProgramLocation(sline, eline), $1, $3))
      : static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(QoreProgramLocation(sline, eline), $1, $3));
}

static QoreOperatorNode* process_weak_assignment(const QoreProgramLocation& loc, AbstractQoreNode* $1, AbstractQoreNode* $3) {
   if ($1 && $1->getType() == NT_LIST) {
       parse_error(loc, "the ':=' operator is not valid with list assignments");
       return static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
   }
   return static_cast<QoreOperatorNode*>(new QoreWeakAssignmentOperatorNode(loc, $1, $3));
}

static AbstractQoreNode* processCall(int sline, int eline, AbstractQoreNode* $1, AbstractQoreNode* $3, const QoreProgramLocation& argloc) {
    AbstractQoreNode* $$;
   //printd(5, "1=%s (%p), 3=%s (%p)\n", $1->getTypeName(), $1, $3 ? $3->getTypeName() : "n/a", $3);
   qore_type_t t = get_node_type($1);
   if (t == NT_BAREWORD) {
      BarewordNode* b = reinterpret_cast<BarewordNode*>($1);
      // take string from node and delete node
      char* str = b->takeString();
      b->deref();
      printd(5, "parsing call %s() args=%p %s\n", str, $3, $3 ? $3->getTypeName() : "n/a");
      QoreProgramLocation loc(sline, eline);
      $$ = new FunctionCallNode(loc, str, make_args(argloc, $3));
   }
   else if (t == NT_CONSTANT) {
      ScopedRefNode* c = reinterpret_cast<ScopedRefNode*>($1);
      // take NamedScope from node and delete node
      NamedScope *ns = c->takeName();
      c->deref();
      assert(ns->size() > 1);
      printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
      QoreProgramLocation loc(sline, eline);
      $$ = new StaticMethodCallNode(loc, ns, make_args(argloc, $3));
   }
   else if (t == NT_SELF_VARREF) {
      SelfVarrefNode* v = reinterpret_cast<SelfVarrefNode*>($1);
      // take string from node and delete node
      char* str = v->takeString();
      v->deref();
      //printd(5, "parsing in-object method call %s()\n", str);
      QoreProgramLocation loc(sline, eline);
      $$ = new SelfFunctionCallNode(loc, str, make_args(argloc, $3));
   }
   else {
      QoreHashObjectDereferenceOperatorNode* hodon;

      if (t == NT_OPERATOR) {
         hodon = dynamic_cast<QoreHashObjectDereferenceOperatorNode*>($1);
         if (hodon) {
            AbstractQoreNode* r = hodon->getRight();
            if (!r || r->getType() != NT_STRING)
               hodon = 0;
         }
      }
      else
         hodon = 0;

      if (hodon) {
         // create an object method call node
         // take the string
         QoreStringNode* str = reinterpret_cast<QoreStringNode*>(hodon->swapRight(0));
         assert(str->getEncoding() == QCS_DEFAULT);
         char* cstr = str->giveBuffer();
         assert(cstr);
         str->deref();

         QoreProgramLocation loc(sline, eline);
         MethodCallNode* mc = new MethodCallNode(loc, cstr, make_args(argloc, $3));

         // destroy the original operator and create a new operator object
         assert(hodon->is_unique());
         AbstractQoreNode* l = hodon->swapLeft(0);
         hodon->deref(0);

         $$ = new QoreDotEvalOperatorNode(QoreProgramLocation(sline, eline), l, mc);
      }
      else {
         $$ = 0;
         if ($1 && $1->getType() == NT_VARREF) {
            VarRefNode* r = reinterpret_cast<VarRefNode*>($1);
            qore_var_t vartype = r->getType();

            if (vartype != VT_UNRESOLVED) {
               $$ = r->makeNewCall($3);
               //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
               if (!$$)
                  parseException(QoreProgramLocation(sline, eline), "INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
            }
         }
         if (!$$) {
            QoreProgramLocation loc(sline, eline);
            $$ = new CallReferenceCallNode(loc, $1, make_args(argloc, $3));
            printd(5, "made new CallReferenceCallNode: %p exp=%p %s\n", $$, $1, get_type_name($1));
         }
      }
   }
   return $$;
}

static void check_operator(const QoreOperatorNode *n, const char *parent, const char *child) {
    if (parse_check_parse_option(PO_BROKEN_LOGIC_PRECEDENCE)) {
        if (!n->getInParentheses()) {
            qore_program_private::makeParseWarning(getProgram(), QP_WARN_BROKEN_LOGIC_PRECEDENCE, "BROKEN-LOGIC-PRECEDENCE", "%s gets under %s in the parse tree as an impact of broken-logic-precedence flag being set - please consider using parenthesis to enforce the desired operator precedence", child, parent);
        }
    }
}

static void check_operator_log_or(const AbstractQoreNode *n, const char *parent) {
    if (dynamic_cast< const QoreLogicalOrOperatorNode *>(n)) {
        check_operator(static_cast<const QoreOperatorNode*>(n), parent, "logical OR");
    }
}

static void check_operator_bin_or(const AbstractQoreNode *n, const char *parent) {
    if (dynamic_cast< const QoreBinaryOrOperatorNode *>(n)) {
        check_operator(static_cast<const QoreOperatorNode*>(n), parent, "binary OR");
    }
}

static void check_operator_bin_xor(const AbstractQoreNode *n, const char *parent) {
    if (dynamic_cast< const QoreBinaryXorOperatorNode *>(n)) {
        check_operator(static_cast<const QoreOperatorNode*>(n), parent, "binary XOR");
    }
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 1491 "parser.ypp"
{
   bool b;
   int i4;
   int64 integer;
   double decimal;
   QoreStringNode* String;
   char* string;
   BinaryNode* binary;
   AbstractQoreNode* node;
   QoreParseHashNode* hash;
   QoreParseListNode* parse_list;
   AbstractStatement* statement;
   struct MemberInfo* memberinfo;
   struct ClassVarInfo* classvarinfo;
   StatementBlock *sblock;
   ContextModList* cmods;
   ContextMod *cmod;
   class HashElement* hashelement;
   QoreFunction* userfunc;
   struct MethodNode* methodnode;
   class MemberList* memberlist;
   QoreClass* qoreclass;
   typed_hash_decl_private* hashdeclpriv;
   class ConstNode* constnode;
   QoreNamespace *ns;
   struct NSNodeList* nsnlist;
   struct NSNode* nsn;
   class ObjClassDef* classdef;
   class HashDeclDef* hashdecldef;
   DateTimeNode* datetime;
   QoreRegexSubst* RegexSubst;
   QoreTransliteration* Trans;
   SwitchStatement* switchstmt;
   CaseNode* casenode;
   BCList* sclist;
   class BCNode* sclnode;
   BCAList* bcalist;
   BCANode* bcanode;
   NamedScope *nscope;
   QoreRegex* Regex;
   QoreImplicitArgumentNode* implicit_arg;
   RetTypeInfo* returnTypeInfo;
   struct ParserTypeStruct* parsertype;
   class ParseUserFunction* parsefunc;
   class ParseScopedUserFunction* sparsefunc;
   struct GVarDecl* gv;
   QoreNumberNode* num;
   TryModuleError* trymod;
   struct MethodDef* methoddef;
}
/* Line 193 of yacc.c.  */
#line 1901 "parser.cpp"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */
#line 1542 "parser.ypp"


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE* loc, yyscan_t scanner, const char* str) {
   //printd(5, "yyerror() location: %d:%d - %d:%d \"%s\"\n", loc->first_line, loc->first_col, loc->last_line, loc->last_col, str);
   parse_error(QoreProgramLocation(loc->first_line, loc->last_line), "%s", str);
}



/* Line 216 of yacc.c.  */
#line 1938 "parser.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  209
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   13424

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  161
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  66
/* YYNRULES -- Number of rules.  */
#define YYNRULES  429
/* YYNRULES -- Number of states.  */
#define YYNSTATES  929

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   390

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   152,     2,     2,     2,   145,   140,     2,
     156,   159,   146,   143,   134,   144,   155,   147,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   137,   158,
     141,   135,   142,   136,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   154,   151,   160,   139,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   153,   138,   157,   150,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   148,
     149
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    27,    31,    33,    38,    40,    42,    45,
      50,    51,    53,    58,    62,    67,    71,    76,    81,    87,
      93,    97,   102,   104,   107,   109,   111,   113,   115,   117,
     119,   122,   124,   126,   132,   139,   145,   152,   156,   159,
     161,   163,   165,   167,   170,   173,   174,   176,   178,   181,
     187,   189,   192,   196,   199,   202,   205,   209,   221,   229,
     235,   243,   249,   257,   267,   275,   278,   281,   284,   287,
     289,   292,   293,   296,   301,   306,   311,   313,   316,   324,
     326,   329,   335,   340,   346,   351,   357,   362,   368,   373,
     379,   384,   390,   395,   401,   406,   411,   415,   420,   424,
     428,   431,   439,   440,   442,   444,   451,   458,   465,   472,
     477,   482,   488,   494,   497,   498,   500,   504,   506,   508,
     511,   514,   517,   520,   523,   526,   529,   532,   534,   537,
     541,   547,   554,   556,   558,   560,   562,   564,   567,   570,
     573,   576,   579,   581,   583,   585,   588,   591,   594,   595,
     597,   601,   606,   610,   614,   619,   623,   627,   632,   636,
     640,   645,   649,   654,   658,   665,   671,   679,   683,   689,
     696,   700,   706,   713,   716,   721,   723,   725,   727,   730,
     732,   736,   738,   741,   744,   747,   749,   757,   765,   773,
     781,   790,   799,   808,   817,   825,   833,   836,   837,   839,
     843,   848,   853,   854,   856,   858,   861,   863,   865,   867,
     869,   871,   873,   875,   877,   879,   882,   883,   890,   897,
     905,   913,   921,   929,   938,   947,   951,   954,   958,   961,
     963,   967,   970,   974,   978,   982,   985,   987,   989,   993,
     995,   998,  1001,  1004,  1008,  1011,  1015,  1020,  1022,  1024,
    1026,  1028,  1030,  1039,  1042,  1045,  1048,  1051,  1054,  1057,
    1060,  1063,  1066,  1069,  1072,  1075,  1078,  1081,  1084,  1087,
    1090,  1095,  1099,  1101,  1104,  1107,  1110,  1113,  1116,  1122,
    1128,  1134,  1137,  1139,  1143,  1146,  1153,  1160,  1168,  1176,
    1178,  1180,  1183,  1186,  1191,  1193,  1195,  1197,  1199,  1202,
    1206,  1210,  1214,  1218,  1222,  1226,  1230,  1234,  1238,  1242,
    1246,  1250,  1254,  1258,  1262,  1268,  1271,  1274,  1279,  1283,
    1287,  1291,  1295,  1299,  1303,  1307,  1311,  1315,  1319,  1323,
    1327,  1331,  1335,  1339,  1343,  1347,  1351,  1355,  1359,  1363,
    1367,  1371,  1375,  1379,  1383,  1387,  1391,  1395,  1401,  1407,
    1412,  1417,  1422,  1426,  1430,  1433,  1435,  1437,  1441,  1445,
    1449,  1453,  1457,  1461,  1465,  1469,  1473,  1477,  1481,  1485,
    1489,  1493,  1497,  1503,  1506,  1509,  1514,  1518,  1522,  1526,
    1530,  1534,  1538,  1542,  1546,  1550,  1554,  1558,  1562,  1566,
    1570,  1574,  1578,  1582,  1586,  1590,  1594,  1598,  1602,  1606,
    1610,  1614,  1618,  1622,  1626,  1630,  1636,  1642,  1647,  1652,
    1657,  1661,  1665,  1668,  1670,  1673,  1675,  1677,  1679,  1681
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     162,     0,    -1,   163,    -1,   162,   163,    -1,   214,    -1,
     215,    -1,   187,    -1,   186,    -1,   172,    -1,   171,    -1,
     206,    -1,   177,    -1,   153,   157,    -1,   153,   175,   157,
      -1,   168,    -1,    46,   153,   164,   157,    -1,   132,    -1,
     165,    -1,   164,   165,    -1,   108,   135,   223,   158,    -1,
      -1,    27,    -1,   166,    37,   194,   115,    -1,   166,    37,
     115,    -1,   166,    37,   194,   108,    -1,   166,    37,   108,
      -1,   166,    37,   195,   116,    -1,   166,    37,   195,   111,
      -1,   166,    37,   156,   216,   159,    -1,   210,    45,   153,
     169,   157,    -1,   210,    45,   158,    -1,   210,    45,   153,
     157,    -1,   170,    -1,   169,   170,    -1,   172,    -1,   171,
      -1,   187,    -1,   186,    -1,   214,    -1,   215,    -1,   167,
     158,    -1,   168,    -1,   206,    -1,    34,   108,   135,   223,
     158,    -1,    27,    34,   108,   135,   223,   158,    -1,    34,
     115,   135,   223,   158,    -1,    27,    34,   115,   135,   223,
     158,    -1,   153,   175,   157,    -1,   153,   157,    -1,   177,
      -1,   173,    -1,   177,    -1,   173,    -1,   175,   173,    -1,
     175,   177,    -1,    -1,   108,    -1,   158,    -1,   224,   158,
      -1,   115,   156,   185,   159,   158,    -1,   184,    -1,    38,
     158,    -1,     8,   223,   158,    -1,    91,   174,    -1,    92,
     174,    -1,    93,   174,    -1,    33,   178,   174,    -1,    35,
     176,   156,   223,   159,    36,   156,   223,   159,   178,   174,
      -1,    30,   176,   156,   223,   159,   178,   174,    -1,    12,
     156,   223,   159,   174,    -1,    12,   156,   223,   159,   174,
      43,   174,    -1,    11,   156,   223,   159,   174,    -1,     6,
     174,    11,   156,   223,   159,   158,    -1,    13,   156,   185,
     158,   185,   158,   185,   159,   174,    -1,    20,   223,    21,
     156,   223,   159,   174,    -1,   180,   158,    -1,    15,   158,
      -1,    16,   158,    -1,    17,   158,    -1,   181,    -1,     1,
     158,    -1,    -1,   178,   179,    -1,    10,   156,   223,   159,
      -1,    31,   156,   223,   159,    -1,    32,   156,   223,   159,
      -1,     3,    -1,     3,   223,    -1,    39,   156,   223,   159,
     153,   182,   157,    -1,   183,    -1,   182,   183,    -1,    40,
      77,   223,   137,   175,    -1,    40,    77,   223,   137,    -1,
      40,    76,   223,   137,   175,    -1,    40,    76,   223,   137,
      -1,    40,    74,   223,   137,   175,    -1,    40,    74,   223,
     137,    -1,    40,   141,   223,   137,   175,    -1,    40,   141,
     223,   137,    -1,    40,   142,   223,   137,   175,    -1,    40,
     142,   223,   137,    -1,    40,    81,   128,   137,   175,    -1,
      40,    81,   128,   137,    -1,    40,    82,   128,   137,   175,
      -1,    40,    82,   128,   137,    -1,    40,   128,   137,   175,
      -1,    40,   128,   137,    -1,    40,   223,   137,   175,    -1,
      40,   223,   137,    -1,    41,   137,   175,    -1,    41,   137,
      -1,     7,   174,     9,   156,   185,   159,   174,    -1,    -1,
     223,    -1,     1,    -1,   210,    49,   108,   153,   191,   157,
      -1,   210,    49,   115,   153,   191,   157,    -1,   210,   120,
     188,   153,   193,   157,    -1,   210,   126,   188,   153,   193,
     157,    -1,   210,   120,   188,   158,    -1,   210,   126,   188,
     158,    -1,   210,   120,   188,   153,   157,    -1,   210,   126,
     188,   153,   157,    -1,    42,   189,    -1,    -1,   190,    -1,
     189,   134,   190,    -1,   108,    -1,   115,    -1,    27,   108,
      -1,    27,   115,    -1,    24,   108,    -1,    24,   115,    -1,
      26,   108,    -1,    26,   115,    -1,    25,   108,    -1,    25,
     115,    -1,   192,    -1,   191,   192,    -1,   194,   108,   158,
      -1,   194,   108,   135,   223,   158,    -1,   194,   108,   156,
     185,   159,   158,    -1,   205,    -1,   196,    -1,   197,    -1,
     198,    -1,   171,    -1,   193,   205,    -1,   193,   196,    -1,
     193,   197,    -1,   193,   198,    -1,   193,   171,    -1,   108,
      -1,   115,    -1,   110,    -1,   146,   108,    -1,   146,   115,
      -1,   146,   110,    -1,    -1,   194,    -1,    25,   202,   158,
      -1,    25,   153,   203,   157,    -1,    25,   153,   157,    -1,
      24,   202,   158,    -1,    24,   153,   203,   157,    -1,    24,
     153,   157,    -1,    26,   202,   158,    -1,    26,   153,   203,
     157,    -1,    26,   153,   157,    -1,    27,   202,   158,    -1,
      27,   153,   203,   157,    -1,    27,   153,   157,    -1,    44,
     194,   108,   158,    -1,    44,   108,   158,    -1,    44,   194,
     108,   135,   223,   158,    -1,    44,   108,   135,   223,   158,
      -1,    44,   194,   108,   156,   185,   159,   158,    -1,   195,
     113,   158,    -1,   195,   113,   135,   223,   158,    -1,   195,
     113,   156,   185,   159,   158,    -1,   194,   108,   158,    -1,
     194,   108,   135,   223,   158,    -1,   194,   108,   156,   185,
     159,   158,    -1,   108,   158,    -1,   108,   135,   223,   158,
      -1,   199,    -1,   171,    -1,   113,    -1,   113,   115,    -1,
     201,    -1,   202,   134,   201,    -1,   200,    -1,   203,   200,
      -1,   108,   156,    -1,    88,   156,    -1,   114,    -1,   210,
     204,   185,   159,   207,   213,   173,    -1,   210,   194,   204,
     185,   159,   207,   173,    -1,   210,   204,   185,   159,   207,
     213,   158,    -1,   210,   194,   204,   185,   159,   207,   158,
      -1,   211,   115,   156,   185,   159,   207,   213,   173,    -1,
     211,   194,   115,   156,   185,   159,   207,   173,    -1,   211,
     115,   156,   185,   159,   207,   213,   158,    -1,   211,   194,
     115,   156,   185,   159,   207,   158,    -1,   115,   156,   185,
     159,   207,   213,   173,    -1,   194,   115,   156,   185,   159,
     207,   173,    -1,   137,   208,    -1,    -1,   209,    -1,   208,
     134,   209,    -1,   108,   156,   185,   159,    -1,   115,   156,
     185,   159,    -1,    -1,   211,    -1,   212,    -1,   211,   212,
      -1,    24,    -1,    26,    -1,    25,    -1,    44,    -1,    28,
      -1,    29,    -1,    27,    -1,    47,    -1,    48,    -1,     4,
     195,    -1,    -1,    14,   204,   185,   159,   213,   173,    -1,
     194,    14,   204,   185,   159,   173,    -1,   211,    14,   204,
     185,   159,   213,   173,    -1,   211,   194,    14,   204,   185,
     159,   173,    -1,    14,   115,   156,   185,   159,   213,   173,
      -1,   194,    14,   115,   156,   185,   159,   173,    -1,   211,
      14,   115,   156,   185,   159,   213,   173,    -1,   211,   194,
      14,   115,   156,   185,   159,   173,    -1,   223,   134,   223,
      -1,   223,   134,    -1,   224,   134,   223,    -1,   224,   134,
      -1,   219,    -1,   218,   134,   219,    -1,   218,   134,    -1,
     223,   137,   223,    -1,   153,   218,   157,    -1,   109,   218,
     157,    -1,   109,   157,    -1,   226,    -1,   123,    -1,   156,
     218,   159,    -1,   115,    -1,   195,   111,    -1,   195,   116,
      -1,   194,   108,    -1,     5,   194,   108,    -1,     5,   108,
      -1,     5,   195,   111,    -1,     5,   156,   216,   159,    -1,
     167,    -1,   108,    -1,   117,    -1,    18,    -1,   118,    -1,
      19,   223,    21,   223,    10,   156,   223,   159,    -1,    83,
     223,    -1,    87,   223,    -1,    88,   223,    -1,    63,   223,
      -1,    66,   223,    -1,    64,   223,    -1,    65,   223,    -1,
      67,   223,    -1,    68,   223,    -1,    98,   223,    -1,    99,
     223,    -1,    94,   223,    -1,    95,   223,    -1,    96,   223,
      -1,    97,   223,    -1,    51,   223,    -1,    52,   223,    -1,
     127,   156,   185,   159,    -1,   114,   185,   159,    -1,   113,
      -1,   144,   223,    -1,   143,   223,    -1,   150,   223,    -1,
     152,   223,    -1,   151,   223,    -1,    89,   108,   156,   185,
     159,    -1,    89,   115,   156,   185,   159,    -1,    89,   110,
     156,   185,   159,    -1,    90,   223,    -1,   112,    -1,   156,
     223,   159,    -1,   156,   159,    -1,    14,   156,   185,   159,
     213,   173,    -1,   194,    14,   156,   185,   159,   173,    -1,
     211,    14,   156,   185,   159,   213,   173,    -1,   211,   194,
      14,   156,   185,   159,   173,    -1,   130,    -1,   100,    -1,
      22,   223,    -1,    23,   223,    -1,   119,   156,   223,   159,
      -1,   222,    -1,   216,    -1,   220,    -1,   221,    -1,   153,
     157,    -1,   223,    53,   223,    -1,   223,    54,   223,    -1,
     223,    55,   223,    -1,   223,    56,   223,    -1,   223,    57,
     223,    -1,   223,    58,   223,    -1,   223,    59,   223,    -1,
     223,    60,   223,    -1,   223,    61,   223,    -1,   223,    62,
     223,    -1,   223,   135,   223,    -1,   223,   103,   223,    -1,
     223,    84,   194,    -1,   223,   101,   223,    -1,   223,   102,
     223,    -1,   223,   136,   223,   137,   223,    -1,   223,    51,
      -1,   223,    52,    -1,   223,   156,   185,   159,    -1,   223,
      69,   223,    -1,   223,    70,   223,    -1,   223,    71,   223,
      -1,   223,    72,   223,    -1,   223,    73,   223,    -1,   223,
     138,   223,    -1,   223,   140,   223,    -1,   223,   139,   223,
      -1,   223,    81,   128,    -1,   223,    82,   128,    -1,   223,
      81,   124,    -1,   223,    81,   125,    -1,   223,    81,   129,
      -1,   223,   142,   223,    -1,   223,   141,   223,    -1,   223,
      78,   223,    -1,   223,    74,   223,    -1,   223,    79,   223,
      -1,   223,    80,   223,    -1,   223,    75,   223,    -1,   223,
      76,   223,    -1,   223,    77,   223,    -1,   223,    86,   223,
      -1,   223,    85,   223,    -1,   223,   143,   223,    -1,   223,
     144,   223,    -1,   223,   145,   223,    -1,   223,   147,   223,
      -1,   223,   146,   223,    -1,   223,   154,   223,   104,   160,
      -1,   223,   154,   104,   223,   160,    -1,   223,   154,   104,
     160,    -1,   223,   154,   223,   160,    -1,   223,   153,   223,
     157,    -1,   223,   104,   223,    -1,   223,   155,   223,    -1,
     223,   131,    -1,   222,    -1,   217,    -1,   224,    53,   223,
      -1,   224,    54,   223,    -1,   224,    55,   223,    -1,   224,
      56,   223,    -1,   224,    57,   223,    -1,   224,    58,   223,
      -1,   224,    59,   223,    -1,   224,    60,   223,    -1,   224,
      61,   223,    -1,   224,    62,   223,    -1,   224,   135,   223,
      -1,   224,   103,   223,    -1,   224,    84,   194,    -1,   224,
     101,   223,    -1,   224,   102,   223,    -1,   224,   136,   223,
     137,   223,    -1,   224,    51,    -1,   224,    52,    -1,   224,
     156,   185,   159,    -1,   224,    69,   223,    -1,   224,    70,
     223,    -1,   224,    71,   223,    -1,   224,    72,   223,    -1,
     224,    73,   223,    -1,   224,   138,   223,    -1,   224,   140,
     223,    -1,   224,   139,   223,    -1,   224,    81,   128,    -1,
     224,    82,   128,    -1,   224,    81,   124,    -1,   224,    81,
     125,    -1,   224,    81,   129,    -1,   224,   142,   223,    -1,
     224,   141,   223,    -1,   224,    78,   223,    -1,   224,    74,
     223,    -1,   224,    79,   223,    -1,   224,    80,   223,    -1,
     224,    75,   223,    -1,   224,    76,   223,    -1,   224,    77,
     223,    -1,   224,    86,   223,    -1,   224,    85,   223,    -1,
     224,   143,   223,    -1,   224,   144,   223,    -1,   224,   145,
     223,    -1,   224,   147,   223,    -1,   224,   146,   223,    -1,
     224,   154,   223,   104,   160,    -1,   224,   154,   104,   223,
     160,    -1,   224,   154,   104,   160,    -1,   224,   154,   223,
     160,    -1,   224,   153,   223,   157,    -1,   224,   104,   223,
      -1,   224,   155,   223,    -1,   224,   131,    -1,   122,    -1,
     122,   225,    -1,   106,    -1,   105,    -1,   225,    -1,   121,
      -1,   107,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1796,  1796,  1797,  1801,  1804,  1809,  1817,  1821,  1827,
    1831,  1836,  1844,  1845,  1851,  1858,  1868,  1893,  1895,  1900,
    1914,  1915,  1921,  1929,  1935,  1941,  1944,  1952,  1957,  1963,
    1971,  1977,  1986,  1991,  1999,  2004,  2007,  2013,  2016,  2019,
    2024,  2027,  2033,  2039,  2042,  2048,  2051,  2057,  2060,  2065,
    2068,  2073,  2075,  2077,  2079,  2085,  2086,  2090,  2091,  2110,
    2117,  2119,  2122,  2125,  2128,  2131,  2134,  2137,  2140,  2143,
    2146,  2149,  2152,  2155,  2158,  2161,  2162,  2169,  2172,  2175,
    2176,  2181,  2182,  2193,  2195,  2197,  2202,  2204,  2208,  2218,
    2222,  2230,  2236,  2243,  2249,  2256,  2262,  2269,  2275,  2282,
    2288,  2295,  2300,  2306,  2311,  2317,  2322,  2328,  2334,  2341,
    2346,  2354,  2388,  2389,  2390,  2394,  2399,  2407,  2413,  2421,
    2430,  2441,  2450,  2464,  2467,  2473,  2476,  2483,  2486,  2489,
    2492,  2495,  2498,  2501,  2504,  2507,  2510,  2516,  2524,  2541,
    2546,  2551,  2573,  2578,  2584,  2590,  2596,  2603,  2608,  2614,
    2620,  2626,  2635,  2638,  2641,  2644,  2647,  2650,  2657,  2658,
    2664,  2665,  2666,  2670,  2671,  2672,  2673,  2674,  2675,  2679,
    2680,  2681,  2685,  2690,  2694,  2700,  2704,  2724,  2731,  2738,
    2759,  2766,  2773,  2794,  2800,  2806,  2809,  2819,  2825,  2834,
    2837,  2844,  2847,  2854,  2857,  2860,  2866,  2877,  2892,  2899,
    2913,  2924,  2937,  2943,  2952,  2956,  2966,  2969,  2975,  2978,
    2985,  2988,  2995,  2996,  3001,  3002,  3010,  3011,  3012,  3013,
    3014,  3015,  3016,  3017,  3018,  3022,  3033,  3039,  3044,  3053,
    3065,  3083,  3088,  3097,  3109,  3127,  3130,  3150,  3153,  3167,
    3171,  3176,  3181,  3186,  3194,  3203,  3212,  3214,  3216,  3218,
    3220,  3234,  3245,  3252,  3260,  3270,  3287,  3325,  3328,  3335,
    3337,  3339,  3341,  3343,  3345,  3347,  3350,  3363,  3366,  3379,
    3382,  3385,  3388,  3408,  3428,  3452,  3466,  3480,  3494,  3497,
    3500,  3507,  3511,  3517,  3523,  3527,  3530,  3533,  3563,  3568,
    3573,  3579,  3587,  3592,  3611,  3616,  3620,  3627,  3636,  3649,
    3653,  3656,  3659,  3662,  3669,  3670,  3671,  3672,  3673,  3674,
    3675,  3676,  3677,  3678,  3679,  3680,  3681,  3682,  3683,  3684,
    3685,  3694,  3701,  3702,  3703,  3704,  3705,  3706,  3707,  3708,
    3709,  3710,  3711,  3712,  3713,  3714,  3715,  3716,  3717,  3718,
    3719,  3720,  3721,  3722,  3723,  3724,  3725,  3726,  3727,  3728,
    3729,  3730,  3731,  3732,  3733,  3734,  3735,  3736,  3737,  3738,
    3742,  3755,  3756,  3757,  3758,  3762,  3763,  3764,  3765,  3766,
    3767,  3768,  3769,  3770,  3771,  3772,  3773,  3774,  3775,  3784,
    3791,  3792,  3793,  3794,  3795,  3796,  3797,  3798,  3799,  3800,
    3801,  3802,  3803,  3804,  3805,  3806,  3807,  3808,  3809,  3810,
    3811,  3812,  3813,  3814,  3815,  3816,  3817,  3818,  3819,  3820,
    3821,  3822,  3823,  3824,  3825,  3826,  3827,  3828,  3832,  3845,
    3846,  3847,  3848,  3852,  3855,  3863,  3864,  3865,  3866,  3867
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"private:internal\"",
  "\"private:hierarchy\"", "\"public\"", "\"synchronized\"",
  "\"deprecated\"", "\"context\"", "\"sortBy\"", "\"sortDescendingBy\"",
  "\"subcontext\"", "\"const\"", "\"summarize\"", "\"by\"", "\"our\"",
  "\"rethrow\"", "\"switch\"", "\"case\"", "\"default\"", "\"inherits\"",
  "\"else\"", "\"static\"", "\"namespace\"", "\"module\"", "\"final\"",
  "\"abstract\"", "\"hashdecl\"", "\"unreference\"", "\"++ operator\"",
  "\"-- operator\"", "\"+= operator\"", "\"-= operator\"",
  "\"&= operator\"", "\"|= operator\"", "\"%= operator\"",
  "\"*= operator\"", "\"/= operator\"", "\"^= operator\"",
  "\"<<= operator\"", "\">>= operator\"", "\"unshift\"", "\"push\"",
  "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"", "\"&& operator\"",
  "\"|| operator\"", "\"|| operator (compat)\"", "\"| operator (compat)\"",
  "\"^ operator (compat)\"", "\"== operator\"", "\"!= operator\"",
  "\"<= operator\"", "\">= operator\"", "\"<=> operator\"",
  "\"=== operator\"", "\"!== operator\"", "\"=~ operator\"",
  "\"!~ operator\"", "\"exists\"", "\"instanceof\"", "\">> operator\"",
  "\"<< operator\"", "\"elements\"", "\"keys\"", "\"new\"",
  "\"background\"", "\"on_exit\"", "\"on_success\"", "\"on_error\"",
  "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"", "\"splice\"",
  "\"extract\"", "\"$# operator\"", "\"?? operator\"", "\"?* operator\"",
  "\":= operator\"", "\".. operator\"", "\"integer value\"",
  "\"floating-point value\"", "\"arbitrary-precision number\"",
  "\"identifier\"", "\"typed hash identifier\"",
  "\"complex type identifier\"", "\"variable reference\"",
  "\"backquote expression\"", "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"simple class declaration\"",
  "\"date/time value\"", "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "hashdecl_def",
  "class_def", "inheritance_list", "superclass_list", "superclass",
  "hashdecl_attrs", "hashdecl_member", "class_attributes", "uncqtypedef",
  "qtypedef", "internal_member_list", "private_member_list",
  "public_member_list", "classvardecl", "member2", "member", "member_list",
  "member_list2", "ident_openparen", "inline_methoddef",
  "outofline_methoddef", "base_constructor_list", "base_constructors",
  "base_constructor", "nsc_modifiers", "method_modifiers",
  "method_modifier", "return_value", "sub_def", "scoped_sub_def", "list",
  "list_n", "hash", "hash_element", "alt_hash", "immediate_typed_hash",
  "exp_c", "exp", "exp_n", "string", "scalar", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    44,    61,    63,    58,   124,    94,
      38,    60,    62,    43,    45,    37,    42,    47,   389,   390,
     126,    92,    33,   123,    91,    46,    40,   125,    59,    41,
      93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   161,   162,   162,   163,   163,   163,   163,   163,   163,
     163,   163,   163,   163,   163,   163,   163,   164,   164,   165,
     166,   166,   167,   167,   167,   167,   167,   167,   167,   168,
     168,   168,   169,   169,   170,   170,   170,   170,   170,   170,
     170,   170,   170,   171,   171,   172,   172,   173,   173,   174,
     174,   175,   175,   175,   175,   176,   176,   177,   177,   177,
     177,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     177,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     177,   178,   178,   179,   179,   179,   180,   180,   181,   182,
     182,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   184,   185,   185,   185,   186,   186,   187,   187,   187,
     187,   187,   187,   188,   188,   189,   189,   190,   190,   190,
     190,   190,   190,   190,   190,   190,   190,   191,   191,   192,
     192,   192,   193,   193,   193,   193,   193,   193,   193,   193,
     193,   193,   194,   194,   194,   194,   194,   194,   195,   195,
     196,   196,   196,   197,   197,   197,   197,   197,   197,   198,
     198,   198,   199,   199,   199,   199,   199,   200,   200,   200,
     200,   200,   200,   200,   200,   200,   200,   201,   201,   202,
     202,   203,   203,   204,   204,   204,   205,   205,   205,   205,
     206,   206,   206,   206,   206,   206,   207,   207,   208,   208,
     209,   209,   210,   210,   211,   211,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   213,   213,   214,   214,   214,
     214,   215,   215,   215,   215,   216,   216,   217,   217,   218,
     218,   218,   219,   220,   221,   221,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   224,   224,   225,   225,   226,   226,   226,   226,   226
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     4,     1,     1,     2,     4,
       0,     1,     4,     3,     4,     3,     4,     4,     5,     5,
       3,     4,     1,     2,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     5,     6,     5,     6,     3,     2,     1,
       1,     1,     1,     2,     2,     0,     1,     1,     2,     5,
       1,     2,     3,     2,     2,     2,     3,    11,     7,     5,
       7,     5,     7,     9,     7,     2,     2,     2,     2,     1,
       2,     0,     2,     4,     4,     4,     1,     2,     7,     1,
       2,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     5,     4,     4,     3,     4,     3,     3,
       2,     7,     0,     1,     1,     6,     6,     6,     6,     4,
       4,     5,     5,     2,     0,     1,     3,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     3,
       5,     6,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     2,     2,     2,     0,     1,
       3,     4,     3,     3,     4,     3,     3,     4,     3,     3,
       4,     3,     4,     3,     6,     5,     7,     3,     5,     6,
       3,     5,     6,     2,     4,     1,     1,     1,     2,     1,
       3,     1,     2,     2,     2,     1,     7,     7,     7,     7,
       8,     8,     8,     8,     7,     7,     2,     0,     1,     3,
       4,     4,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     0,     6,     6,     7,
       7,     7,     7,     8,     8,     3,     2,     3,     2,     1,
       3,     2,     3,     3,     3,     2,     1,     1,     3,     1,
       2,     2,     2,     3,     2,     3,     4,     1,     1,     1,
       1,     1,     8,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       4,     3,     1,     2,     2,     2,     2,     2,     5,     5,
       5,     2,     1,     3,     2,     6,     6,     7,     7,     1,
       1,     2,     2,     4,     1,     1,     1,     1,     2,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     2,     2,     4,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     5,     5,     4,
       4,     4,     3,     3,     2,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     2,     2,     4,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     5,     4,     4,     4,
       3,     3,     2,     1,     2,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,   158,   158,     0,     0,   158,     0,     0,     0,
       0,     0,     0,     0,   260,   158,   158,   158,   158,   216,
     218,   217,   222,   220,   221,    55,    81,     0,    55,     0,
       0,   219,     0,   223,   224,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,     0,   158,     0,     0,
       0,   158,   158,   158,   158,   158,   158,   300,   426,   425,
     429,   258,   154,   292,   282,     0,   249,   259,   261,     0,
     428,   423,   247,     0,   299,    16,   158,   158,     0,   158,
     158,   158,     0,   158,    57,     0,     2,     0,   257,    14,
       9,     8,    11,     0,    79,    60,     7,     6,   159,     0,
      10,     0,   213,   214,     4,     5,   366,   365,     0,   427,
     246,    80,     0,   222,   158,   249,   158,   159,     0,   305,
     306,   307,   304,    87,   254,   153,   158,   159,     0,   249,
       0,    50,     0,    49,     0,     0,   158,   158,     0,     0,
       0,   195,     0,     0,     0,    76,    77,    78,     0,     0,
     301,   302,     0,    56,     0,     0,     0,     0,     0,    61,
     158,     0,   278,   279,   266,   268,   269,   267,   270,   271,
     263,   264,   265,     0,     0,     0,   291,    63,    64,    65,
     274,   275,   276,   277,   272,   273,   114,     0,   113,     0,
     158,   424,     0,   284,   283,   155,   157,   156,   285,   287,
     286,    12,    52,     0,    51,   294,     0,   239,     0,     1,
       3,   158,    75,     0,   252,     0,   250,   251,     0,     0,
     124,   124,     0,   222,   152,   153,     0,   215,   383,   384,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,     0,     0,     0,   158,   158,   158,   158,   158,
     158,   422,   238,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,     0,    58,
     245,     0,     0,   308,     0,     0,     0,     0,   325,   326,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,     0,     0,     0,   158,   158,   158,   158,   158,
     158,   364,   236,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,     0,   305,
       0,   253,   255,     0,    48,     0,     0,     0,    62,     0,
       0,     0,   194,   193,     0,     0,     0,   158,     0,     0,
       0,   158,     0,     0,     0,    66,    82,   158,   158,   158,
       0,     0,     0,    17,     0,     0,     0,   281,     0,     0,
       0,    13,    53,    54,   241,   248,   158,   293,    25,    23,
     158,   159,     0,     0,     0,     0,     0,   212,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     386,   387,   388,   389,   390,   402,   405,   406,   407,   401,
     403,   404,   396,   397,   394,   398,   395,   379,   409,   408,
     380,   381,   378,   420,   237,   377,     0,   391,   393,   392,
     400,   399,   410,   411,   412,   414,   413,     0,   158,     0,
     421,     0,   244,   243,     0,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   328,   329,   330,   331,   332,
     344,   347,   348,   349,   343,   345,   346,   338,   339,   336,
     340,   337,   321,   351,   350,   322,   323,   320,   362,   235,
     319,     0,   333,   335,   334,   342,   341,   352,   353,   354,
     356,   355,     0,   158,     0,   363,     0,   256,     0,    47,
     158,     0,     0,     0,     0,     0,   226,   226,     0,   158,
     158,   158,     0,   158,   158,   158,     0,     0,     0,     0,
     158,    15,    18,     0,     0,     0,   207,   303,   280,   240,
     242,   305,    24,    22,    27,    26,     0,     0,     0,     0,
       0,   153,    31,     0,    41,   212,    32,    35,    34,    37,
      36,     0,    42,   213,    38,    39,     0,     0,     0,     0,
       0,     0,   127,   128,   123,   125,   212,   119,   212,   120,
       0,     0,     0,     0,     0,     0,     0,     0,   158,   419,
     417,     0,   158,   418,   385,   158,   361,   359,     0,   158,
     360,   327,     0,     0,     0,    71,    69,     0,   226,   158,
       0,     0,     0,     0,     0,     0,    81,     0,     0,     0,
      43,    45,     0,     0,     0,   288,   290,   289,     0,    59,
     226,    28,     0,     0,     0,   207,     0,    40,    29,    33,
       0,     0,     0,     0,   137,     0,     0,   131,   132,   135,
     136,   133,   134,   129,   130,     0,   216,   218,   217,   222,
       0,   121,   146,   212,   143,   144,   145,   142,     0,   213,
     122,   212,     0,   226,   226,   207,     0,     0,     0,     0,
     382,   416,   415,   324,   358,   357,     0,     0,     0,     0,
       0,   159,   225,   295,   227,   158,     0,    44,    46,     0,
      83,    84,    85,     0,   158,     0,     0,    89,    19,     0,
       0,   206,   208,     0,     0,   296,   228,     0,     0,     0,
     115,   138,     0,   116,   126,   187,   158,   189,     0,   158,
       0,   158,     0,     0,   158,     0,   117,   151,   148,   149,
     150,   147,   152,     0,     0,   118,   226,     0,     0,   226,
       0,     0,     0,   207,    72,   111,    70,     0,   231,     0,
      74,    68,   158,   158,   158,   158,     0,     0,     0,   158,
     158,     0,     0,    88,    90,     0,     0,     0,   204,   232,
     205,   207,   158,     0,   139,   188,     0,     0,   152,   165,
     186,   159,     0,   185,   191,   158,     0,   163,   162,   158,
     160,   168,   158,   166,   171,   158,   169,     0,     0,     0,
     297,   229,     0,     0,   298,   230,     0,     0,   262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   209,     0,     0,   152,     0,   158,   183,     0,
       0,   164,   192,   190,   161,   167,   170,     0,   207,   233,
     202,   200,   234,   203,   201,    73,    81,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,   211,   140,     0,
     158,   173,     0,     0,   158,     0,   180,   158,     0,   177,
     207,   226,     0,     0,     0,     0,     0,     0,     0,     0,
     141,     0,   158,     0,   172,   184,     0,     0,     0,     0,
       0,     0,    67,   175,     0,     0,   181,     0,   178,     0,
     199,   197,   198,   196,   174,     0,   182,   179,   176
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    85,    86,   372,   373,    87,    88,    89,   565,   566,
     800,    91,   131,   132,   203,   154,   133,   155,   366,    93,
      94,   716,   717,    95,   187,    96,    97,   402,   584,   585,
     653,   654,   673,   117,    99,   674,   675,   676,   803,   804,
     737,   738,   805,   144,   677,   100,   640,   721,   722,   101,
     118,   103,   620,   104,   105,   119,   106,   206,   207,   120,
     121,   122,   188,   108,   109,   110
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -617
static const yytype_int16 yypact[] =
{
    1622,  -103,  6722,   229,  5722,  5722,  7705,   -56,   -54,   -47,
     437,   -12,   122,   124,  -617,  7705,  7705,  7705,  7705,  -617,
    -617,  -617,   670,  -617,  -617,     3,  -617,    49,     3,   153,
       7,  -617,   159,  -617,  -617,  7705,  7705,  7705,  7705,  7705,
    7705,  7705,  7705,  7705,  7705,  7705,   354,  7705,  5722,  5722,
    5722,  7705,  7705,  7705,  7705,  7705,  7705,  -617,  -617,  -617,
    -617,    94,  -617,  -617,  -617,  1465,    17,  -617,  -617,   191,
    -617,   238,  -617,   213,  -617,  -617,  7705,  7705,   440,  7705,
    7705,  7705,  5090,  6579,  -617,  1269,  -617,   336,  -617,  -617,
    -617,  -617,  -617,   243,  -617,  -617,  -617,  -617,    85,   225,
    -617,    91,   532,  -617,  -617,  -617,  -617,  -617, 10095,  -617,
    -617,  -617,   227,   406,  6865,    45,  7005,    18,   587,  -617,
    -617,  -617,  -617, 12667,   611,  -617,  7705,   345,   344,    43,
    5248,  -617,   452,  -617,   462, 10203,  7705,  7705,  5876,   356,
     357,  -617,   365,  1465,  1465,  -617,  -617,  -617,  7917,  8023,
     629,   629,    76,  -617,   366,  1776,   395,   401,   384,  -617,
    7705,   445,   633,   633, 12667, 12667,   629,   629,   629,   629,
     305,   629,   629,   407,   408,   435,   629,  -617,  -617,  -617,
   12667, 12667, 12667, 12667, 12667, 12667,  -617,   403, 12667,  1465,
    7705,  -617,  1465,   629,   629,  -617,  -617,  -617,   629,   629,
     629,  -617,  -617,  5406,  -617,  -617,   -76,  -617,  8569,  -617,
    -617,   311,  -617,   511,  -617,   442,  -617,  -617,   234,   112,
     578,   578,   530,  -617,  -617,   471,    16,  -617,  -617,  -617,
    7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,
    7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,
    7705,  7705,   565,   501,   542,  7705,  7705,  7705,  7705,  7705,
    7705,  -617,  7285,  7705,  7705,  7705,  7705,  7705,  7705,  7705,
    7705,  7705,  7705,  7705,  7705,  7705,  7425,  7705,  1465,  -617,
    -617,   -42, 11713,  -617,   -16,   483,   485,   637,  -617,  -617,
    7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,
    7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,  7705,
    7705,  7705,   667,   515,   542,  7705,  7705,  7705,  7705,  7705,
    7705,  -617,  7285,  7705,  7705,  7705,  7705,  7705,  7705,  7705,
    7705,  7705,  7705,  7705,  7705,  7705,  7565,  7705,  1465,   500,
   12667,  -617,  -617,  1465,  -617,  5564,   504,   509,  -617,  8678,
    8787,   519,  -617,  -617,  1465,   514,   547,  7705,   535,   579,
     580,  7705,   557,   564,   568,  -617,  -617,  7705,  7705,  7705,
    8896,   596,   -36,  -617,  1465,  1465,  1465,  -617,   576,  9005,
     577,  -617,  -617,  -617,  7285,  -617,  7705,  -617,   383,   560,
    7705,   327,   304,   586,  1465,  1465,  1465,   324,  -617,   594,
     598,   460,   272,   386,   607,  1465,  1465,  1465,   540,   610,
   12773, 12773, 12773, 12773, 12773, 12773, 12773, 12773, 12773, 12773,
   13099, 13063, 13099, 13268, 13268,   305,   305,   305,   305,   305,
     305,   305,  -617,  -617,  -617,  -617,  -617,  -617,   687,   687,
   12966, 12966, 12773, 12918, 12773, 12773, 11819, 13184, 13220, 13268,
     305,   305,   361,   361,   291,   629,   629, 11499,  6019,  8129,
    -617,   593,  -617,  -617,   613, 12773, 12773, 12773, 12773, 12773,
   12773, 12773, 12773, 12773, 12773, 13099, 13063, 13099, 13268, 13268,
     305,   305,   305,   305,   305,   305,   305,  -617,  -617,  -617,
    -617,  -617,  -617,   687,   687, 12966, 12966, 12773, 12918, 12773,
   12773, 11925, 13184, 13220, 13268,   305,   305,   361,   361,   291,
     629,   629, 11606,  6159,  8239,  -617,   595,  -617,   608,  -617,
    7705,  1465,  5722,  5722,  5876,   615,   771,   771,  7811,  7705,
    7705,  7705,  9114,  7705,  7705,  7705, 10311, 10419,  9223,   627,
    7705,  -617,  -617,   635,   638,   641,   -48,  -617,  -617,  -617,
   12773,   652,  -617,  -617,  -617,  -617,  1465,   653,   656,   662,
      93,   625,  -617,   664,  -617,   380,  -617,  -617,  -617,  -617,
    -617,    50,  -617,   824,  -617,  -617,   542,   542,   364,   374,
     457,   469,  -617,  -617,   690,  -617,    69,  -617,   352,  -617,
    1465,   666,   669,   676,   673,  1465,  1465,  1465,  7705,  -617,
    -617,  8349,  6299,  -617,  -617,  7705,  -617,  -617,  8459,  6439,
    -617,  -617,   678,  9332,   696,  -617,   794,   698,   771,   542,
     706,   706,   704,  9441, 10527, 10635,  -617,  9550,  9659,  9768,
    -617,  -617,   825,   211, 10743,  -617,  -617,  -617,   480,  -617,
     771,  -617,   703,   706,   706,   726,  1465,  -617,  -617,  -617,
     104,   522,    62,   308,  -617,   756,   475,  -617,  -617,  -617,
    -617,  -617,  -617,  -617,  -617,   460,   -65,   -33,   -31,    32,
     757,  -617,  -617,   449,  -617,  -617,  -617,  -617,   459,   779,
    -617,   476,   708,   771,   771,   726,  1465,   710,   711,   714,
   12821,  -617,  -617, 12821,  -617,  -617,   716,  5722,  5722,  1465,
     706,  -617,  -617,  -617,  -617,  7705,  5722,  -617,  -617,  1776,
    -617,  -617,  -617,   719,  7145,   739,    30,  -617,  -617,   721,
     723,   746,  -617,   706,   706,  -617,  -617,   706,   722,   584,
    -617,  -617,    -8,  -617,  -617,   780,    29,  -617,   -28,   619,
     -15,   622,    13,   788,   897,    48,  -617,  -617,  -617,  -617,
    -617,  -617,   357,    54,  1465,  -617,   771,   706,   706,   771,
     738,   706,   706,   726,  -617,  -617,  -617,   740,  -617,  9877,
    -617,  -617,  7705,  7705,  7705,  7705,   770,   773,   765,  7705,
    7705, 12031,  1930,  -617,  -617,  1465,  1465,   480,  -617,  -617,
    -617,   726,  7705,  1465,  -617,  -617,   869,   554,    -6,  -617,
    -617,   797,   795,  -617,  -617,   957,   796,  -617,  -617,   958,
    -617,  -617,  1008,  -617,  -617,  1036,  -617,  1465,   751,   706,
    -617,  -617,   396,   706,  -617,  -617,   444,  5722,  -617,  9986,
   12137, 12243, 12349,   783,   784,  2088, 12455, 12561,  2246,  2404,
     766,   767,  -617, 10851,   768,   205,   820,  7705,  -617,    20,
     239,  -617,  -617,  -617,  -617,  -617,  -617,   776,   726,  -617,
    -617,  -617,  -617,  -617,  -617,  -617,  -617,  2562,  2720,  2878,
    3036,  3194,  3352,  3510,  3668,  3826,  -617,  -617,  -617,   772,
    7705,  -617,   275, 10959,  7705,  1465,  -617,  7705,  1465,  -617,
     726,   771,  1776,  3984,  4142,  4300,  4458,  4616,  4774,  4932,
    -617, 11067,  7705,  1465,  -617,  -617, 11175,   777, 11283,   778,
     451,   464,  -617,  -617, 11391,   781,  -617,   785,  -617,   786,
    -617,  -617,  -617,  -617,  -617,   787,  -617,  -617,  -617
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -617,  -617,   844,  -617,   566,  -617,  -395,  -386,  -617,   377,
       1,  -376,   263,    12,  -112,   918,    84,  -616,  -617,  -617,
    -617,  -617,   231,  -617,   655,  -375,  -371,   727,  -617,   284,
     373,    97,   372,     5,     4,  -460,  -396,  -327,  -617,  -104,
     155,  -444,  -458,  -210,  -311,  -370,  -580,  -617,   175,  -501,
       6,   -93,  -480,  -369,  -368,  -106,  -617,   -70,   581,  -617,
    -617,    19,    -2,  -617,   893,  -617
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -213
static const yytype_int16 yytable[] =
{
     123,    90,   563,   395,   135,    98,   102,   128,   127,   227,
     709,   564,   406,   148,   149,   150,   151,   134,   345,   107,
     339,   568,   569,   107,   107,   227,   570,   572,   574,   575,
     408,  -153,   285,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   281,   176,   284,   621,   735,   180,
     181,   182,   183,   184,   185,   111,   796,  -153,   384,  -153,
     177,   178,   179,   670,   650,   727,   743,   107,   107,   107,
     714,   715,   371,   797,   193,   194,   729,   198,   199,   200,
     735,   208,   735,   385,    92,   678,    90,   678,   736,   638,
      98,   102,   384,   666,   667,   668,   669,    23,    24,   213,
     136,   107,   137,   670,   107,   759,   806,   226,  -152,   138,
     639,   153,   282,    31,   282,   462,    33,    34,   384,   806,
     739,   541,   741,   287,   340,  -153,   214,   792,  -153,   847,
     807,   409,  -153,  -153,   349,   350,   218,   798,   700,    62,
     219,   463,   139,   810,   125,   735,   145,   806,   793,   107,
     794,  -153,   848,  -153,  -153,   884,  -153,   156,   370,  -153,
     723,  -153,   140,   160,   157,   215,   204,   365,   141,    92,
     563,   813,   678,   189,   107,    78,   885,   409,   886,   564,
     678,   139,   806,   826,   359,   744,   799,   783,   379,   568,
     569,   360,   139,   214,   570,   572,   574,   575,   596,   343,
     215,   140,  -152,   757,   758,  -152,   816,   141,   142,  -152,
    -152,   220,   140,   748,   204,   392,   391,   221,   141,   393,
     399,   748,   107,   740,   742,   745,   671,   400,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     892,   714,   715,   438,   439,   440,   441,   442,   443,   437,
     444,   445,   446,   447,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   459,   460,   819,   749,   891,   822,
     146,   809,   147,   812,   551,   749,   815,   383,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   483,   484,   485,   486,
     910,   159,   161,   493,   494,   495,   496,   497,   498,   492,
     499,   500,   501,   502,   503,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   514,   515,   216,   124,   560,    62,
     880,   217,   288,   289,   125,   202,   750,   190,    19,    20,
      21,    22,    23,    24,   750,   528,   288,   289,    27,   532,
      71,   -20,   751,   881,   107,   536,   537,   538,    31,   192,
     751,    33,    34,   211,   887,    78,   666,   667,   668,   669,
      23,    24,   282,   143,   550,   126,   670,   397,   340,   314,
     315,   316,   398,   202,   560,   888,    31,   889,   567,    33,
      34,   212,   571,   573,    19,    20,    21,    22,    23,    24,
     902,   911,   288,   289,    27,   554,   224,   -20,    62,   388,
     555,    62,   321,   125,    31,   586,   389,    33,    34,   383,
     587,   903,   224,   904,    62,   552,   321,   333,   334,   561,
     395,   406,   553,   -21,   335,   336,   337,   338,   330,   331,
     332,   333,   334,   341,    78,   342,   601,    78,   335,   336,
     337,   338,   173,   346,   174,   730,   382,   390,   754,   175,
      78,   347,   657,   666,   667,   668,   669,    23,    24,   658,
     227,   562,   659,   670,   578,   579,   580,   581,   224,   660,
      62,  -152,   321,    31,  -152,   561,    33,    34,  -152,  -152,
     666,   667,   668,   669,    23,    24,   332,   333,   334,   680,
     670,   608,   352,   353,   335,   336,   337,   338,   613,   596,
      31,   354,   361,    33,    34,   139,    78,   623,   624,   625,
     367,   627,   628,   629,   615,   616,   368,   648,   634,   588,
     369,   107,   107,   817,   589,   140,   222,   139,   195,   130,
     196,   141,   142,   371,   860,   197,    19,    20,    21,   223,
      23,    24,   377,   374,   375,   661,   567,   752,   582,    62,
     571,   573,   662,   141,   125,   583,    31,   663,   652,    33,
      34,   655,   655,   224,   664,    62,   227,   672,   719,   672,
     125,   376,   679,   143,   679,   720,   690,   130,   396,   139,
     498,   286,   863,   693,   130,    78,   746,   498,   382,   920,
     139,    19,    20,    21,   223,    23,    24,   130,   139,   140,
     401,    78,   922,   702,   701,   141,   393,   407,   139,   436,
     140,    31,   733,   755,    33,    34,   141,   404,   140,   394,
     224,   405,    62,   491,   141,   404,   796,   225,   140,   796,
     224,   464,    62,   670,   141,   594,   670,   125,   655,   517,
     520,   655,   845,   797,    62,   521,   797,   394,  -153,   125,
     839,  -153,   139,   526,   747,  -153,  -153,   524,    78,   679,
     288,   289,   747,   753,  -213,  -213,   405,   679,    78,   432,
     433,   529,   140,   434,   435,   224,   595,    62,   141,   594,
      78,   852,   125,   769,   152,   852,   527,   -21,   852,   765,
     766,   852,   781,   533,   530,   531,   107,   107,   770,  -152,
     534,   771,  -152,   872,   535,   107,   875,   798,   107,    62,
     798,   540,    62,    78,   125,   546,   548,   125,   288,   289,
     802,   801,   556,   802,   801,   802,   801,   576,   802,   801,
     731,   577,   604,   731,   611,   893,   894,   895,   896,   897,
     321,   898,   899,   590,   321,    78,   597,   612,    78,   595,
     829,   830,   831,   832,   618,   619,   808,   836,   837,   811,
     633,   646,   335,   336,   337,   338,   335,   336,   337,   338,
     843,   487,   488,   351,   635,   489,   490,   636,   355,   356,
     637,   107,   846,    19,    20,    21,   223,    23,    24,   802,
     801,   641,   643,   802,   801,   644,   802,   801,   321,   802,
     801,   645,   647,    31,   665,   683,    33,    34,   684,   686,
     330,   331,   332,   333,   334,   685,   639,   698,   651,   865,
     335,   336,   337,   338,   378,   883,   107,   380,    19,    20,
      21,   223,    23,    24,   107,   697,   699,   107,   107,   130,
     705,   713,   724,   638,   732,   156,   204,   756,    31,   761,
     762,    33,    34,   763,   764,   772,   782,   785,   901,   786,
     787,   791,   906,   703,   704,   908,   107,   107,   107,   107,
     107,   107,   107,   107,   107,   795,   359,   823,   833,   827,
     914,   834,   835,   743,   912,   849,   725,   726,   850,   735,
     858,   107,   107,   107,   107,   107,   107,   107,   107,   204,
     870,   871,   204,   383,   796,   876,   877,   879,   882,   210,
     900,   670,   224,   461,    62,   890,   917,   919,   542,   225,
     925,   797,   649,   926,   927,   928,   158,   784,   403,   734,
     656,   204,   204,   204,   204,   204,   383,   204,   204,   383,
     681,   853,   842,   768,   191,   549,     0,     0,     0,     0,
      78,     0,     0,     0,     0,     0,     0,   383,   383,   383,
     383,   383,   383,   383,   796,   796,   788,   789,     0,     0,
     790,   670,   670,   516,     0,     0,     0,     0,   518,     0,
       0,   797,   797,     0,     0,   798,     0,    62,     0,   525,
       0,     0,   125,     0,     0,     0,     0,     0,     0,     0,
     820,   821,     0,     0,   824,   825,     0,     0,     0,   543,
     544,   545,     0,     0,     0,   796,     0,     0,     0,     0,
       0,     0,   670,    78,     0,   202,     0,     0,     0,   557,
     558,   559,   797,     0,   814,     0,     0,     0,     0,     0,
     591,   592,   593,   796,     0,   798,   798,    62,    62,     0,
     670,     0,   125,   125,     0,     0,     0,     0,     0,     0,
     797,     0,   859,     0,     0,   861,   862,     0,     0,   864,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
       0,   202,   382,    78,    78,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   851,   854,   798,     0,    62,     0,
       0,     0,     0,   125,     0,     0,     0,     0,     0,     0,
     202,   202,   202,   202,   202,   382,   202,   202,   382,     0,
       0,     0,     0,     0,   798,     0,    62,     0,     0,     0,
       0,   125,     0,     0,    78,     0,   382,   382,   382,   382,
     382,   382,   382,     0,     0,   855,     0,     0,     0,     0,
       0,     0,     0,   921,   923,     0,   614,     0,     0,   617,
       0,     0,    78,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   856,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   642,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   682,     0,     0,     0,     0,
     687,   688,   689,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   209,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
       0,   728,    26,    27,    28,     0,   -20,    29,    30,     0,
       0,     0,     0,    31,  -212,    32,    33,    34,  -212,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,   760,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,   767,     0,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,     0,    62,
    -158,    63,    64,    65,    66,  -158,    67,    68,    69,  -212,
      70,    71,    72,     0,     0,  -212,    73,     0,     0,    74,
       0,    75,     0,     0,     0,     0,     0,     0,     0,   818,
       0,     0,    76,    77,     0,    78,     0,     0,     0,    79,
      80,    81,    82,     0,     0,    83,     0,    84,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     840,   841,     0,     0,     0,     0,     0,     0,   844,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   186,     0,     0,     0,
       3,     0,   857,     0,     0,     0,     0,     0,     0,   112,
       0,     0,     0,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
     907,     0,     0,   909,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,   915,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,   114,    62,  -158,    63,    64,    65,
     115,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   116,     0,
       0,    83,     0,     1,  -112,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,    22,
      23,    24,    25,     0,     0,    26,    27,    28,     0,   -20,
      29,    30,     0,     0,     0,     0,    31,  -212,    32,    33,
      34,  -212,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,    66,  -158,    67,
      68,    69,  -212,    70,    71,    72,     0,     0,  -212,    73,
       0,     0,    74,     0,    75,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,    82,     0,     1,    83,     2,
      84,     3,     4,     5,     6,     0,   362,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,   363,   364,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     1,    83,     2,    84,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -110,  -110,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,  -110,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -106,  -106,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,  -106,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -108,  -108,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     0,    83,  -108,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,  -109,  -109,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,     0,    62,  -158,    63,    64,    65,   129,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   130,     0,     0,
      83,  -109,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,   -96,   -96,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,   129,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   130,     0,     0,    83,   -96,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -94,   -94,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,   -94,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,   -92,   -92,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,   -92,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -102,  -102,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     0,    83,  -102,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,  -104,  -104,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,     0,    62,  -158,    63,    64,    65,   129,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   130,     0,     0,
      83,  -104,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -105,  -105,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,   129,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   130,     0,     0,    83,  -105,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -98,   -98,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,   -98,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -100,  -100,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,  -100,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -107,  -107,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     0,    83,  -107,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -95,   -95,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,     0,    62,  -158,    63,    64,    65,   129,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   130,     0,     0,
      83,   -95,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,   -93,   -93,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,   129,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   130,     0,     0,    83,   -93,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -91,   -91,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,   -91,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -101,  -101,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,  -101,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -103,  -103,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     0,    83,  -103,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -97,   -97,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,     0,    62,  -158,    63,    64,    65,   129,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   130,     0,     0,
      83,   -97,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,   -99,   -99,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,   129,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   130,     0,     0,    83,   -99,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,   201,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,   344,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     0,    83,   381,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,     0,    62,  -158,    63,    64,    65,   129,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   130,     0,     0,
      83,   519,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,   129,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   130,     0,   186,    83,     0,
      84,     3,     0,     0,     0,     0,     0,     0,     0,     0,
     112,     0,     0,     0,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   113,    23,    24,     0,     0,     0,     0,
       0,     0,     0,   -20,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,     0,     0,     0,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,   114,    62,  -158,    63,    64,
      65,   115,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     3,     0,    79,    80,    81,   116,
       0,     0,    83,   112,  -112,     0,     0,    14,    15,     0,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,   114,    62,
       0,    63,    64,    65,   115,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     3,    78,     0,     0,     0,    79,
      80,    81,   116,   112,     0,    83,     0,    14,    15,   600,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,   114,    62,
       0,    63,    64,    65,   115,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     3,    78,     0,     0,     0,    79,
      80,    81,   116,   112,     0,    83,     0,    14,    15,   607,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,   114,    62,
       0,    63,    64,    65,   115,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     3,    78,     0,     0,     0,    79,
      80,    81,   116,   112,     0,    83,     0,    14,    15,   692,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,   114,    62,
       0,    63,    64,    65,   115,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     3,    78,     0,     0,     0,    79,
      80,    81,   116,   112,     0,    83,     0,    14,    15,   695,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,   114,    62,
       0,    63,    64,    65,   115,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     3,     0,    79,
      80,    81,   116,     0,     0,    83,   112,     0,   205,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   113,
      23,    24,     0,     0,     0,     0,     0,     0,     0,   -20,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,     0,     0,     0,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,   114,    62,     0,    63,    64,    65,   115,     0,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       3,     0,    79,    80,    81,   116,     0,     0,    83,   112,
     -86,     0,     0,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,   114,    62,     0,    63,    64,    65,
     115,     0,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       3,    78,     0,     0,     0,    79,    80,    81,   116,   112,
       0,    83,   280,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,   114,    62,     0,    63,    64,    65,
     115,     0,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       3,    78,     0,     0,     0,    79,    80,    81,   116,   112,
       0,    83,   283,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,   773,
       0,   774,   775,     0,     0,     0,   776,   777,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,   114,    62,     0,    63,    64,    65,
     115,     0,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,   778,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   779,   780,    76,    77,
       3,    78,     0,     0,     0,    79,    80,    81,   116,   112,
       0,    83,     0,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,   114,    62,  -158,    63,    64,    65,
     115,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       3,    78,     0,     0,     0,    79,    80,    81,   116,   112,
       0,    83,     0,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,   458,
      58,    59,    60,    61,   114,    62,     0,    63,    64,    65,
     115,     0,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       3,    78,     0,     0,     0,    79,    80,    81,   116,   112,
       0,    83,     0,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,   513,
      58,    59,    60,    61,   114,    62,     0,    63,    64,    65,
     115,     0,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       3,    78,     0,     0,     0,    79,    80,    81,   116,   112,
       0,    83,     0,    14,    15,     0,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,   114,    62,     0,    63,    64,    65,
     115,   622,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   116,     0,
       0,    83,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   357,     0,
       0,     0,   321,     0,     0,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   358,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   602,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,     0,     0,   603,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   609,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,     0,     0,   610,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,     0,     0,   691,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,     0,     0,   694,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,   386,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,     0,   387,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,   522,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,     0,     0,   523,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,     0,     0,   539,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,     0,     0,   547,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
       0,     0,     0,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,     0,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,   318,   319,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,     0,     0,     0,     0,     0,   335,   336,   337,
     338,     0,     0,   626,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
       0,     0,   632,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,     0,
       0,   696,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,     0,     0,
     706,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,     0,     0,   710,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,     0,   711,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,   712,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,     0,     0,   828,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,     0,     0,   866,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,     0,     0,
       0,     0,     0,     0,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,     0,   254,
     255,   256,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   257,   258,   259,   260,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   261,     0,     0,   262,
     263,   264,     0,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,     0,     0,     0,     0,     0,   275,   276,
     277,   278,     0,   279,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
       0,   348,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,     0,   630,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,   631,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,     0,   707,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,     0,   708,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
       0,   718,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,     0,   878,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,   905,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,     0,   913,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,     0,   916,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
       0,   918,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,     0,   924,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,   599,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,   606,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
     386,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,   598,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,   605,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,   322,   323,   324,   838,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,   867,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
     868,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,   869,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,   873,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,   322,   323,   324,   874,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   288,   289,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   321,   314,   315,   316,   323,   324,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,   317,   318,     0,   320,   335,   336,   337,   338,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,     0,     0,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   288,
     289,     0,     0,     0,   335,   336,   337,   338,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   288,   289,   317,
     318,     0,  -213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   321,
     314,   315,   316,     0,     0,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,   317,   318,     0,
       0,   335,   336,   337,   338,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   288,   289,     0,     0,     0,   335,
     336,   337,   338,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   300,     0,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
     288,   289,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,     0,     0,     0,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,     0,     0,   288,   289,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,     0,   314,   315,
     316,   288,   289,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,     0,   288,
     289,     0,     0,   326,   327,   328,   329,   330,   331,   332,
     333,   334,     0,     0,     0,     0,     0,   335,   336,   337,
     338,     0,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   321,   314,   315,   316,     0,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338
};

static const yytype_int16 yycheck[] =
{
       2,     0,   397,   213,     6,     0,     0,     3,     3,   102,
     626,   397,   222,    15,    16,    17,    18,     5,   130,     0,
     126,   397,   397,     4,     5,   118,   397,   397,   397,   397,
      14,    14,    14,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,   114,    47,   116,   527,   113,    51,
      52,    53,    54,    55,    56,   158,    27,    14,   134,    14,
      48,    49,    50,    34,    14,   645,    34,    48,    49,    50,
      40,    41,   108,    44,    76,    77,    14,    79,    80,    81,
     113,    83,   113,   159,     0,   586,    85,   588,   153,   137,
      85,    85,   134,    24,    25,    26,    27,    28,    29,    14,
     156,    82,   156,    34,    85,   685,   134,   102,    14,   156,
     158,   108,   114,    44,   116,   157,    47,    48,   134,   134,
     153,   157,   153,   118,   126,   108,   108,   135,   111,   135,
     158,   115,   115,   116,   136,   137,    45,   108,   618,   110,
      49,   157,    88,   158,   115,   113,   158,   134,   156,   130,
     158,   108,   158,   108,   111,   135,   111,   108,   160,   116,
     640,   116,   108,   156,   115,   115,    82,   155,   114,    85,
     565,   158,   673,   156,   155,   146,   156,   115,   158,   565,
     681,    88,   134,   763,   108,   153,   157,   157,   190,   565,
     565,   115,    88,   108,   565,   565,   565,   565,   408,   156,
     115,   108,   108,   683,   684,   111,   158,   114,   115,   115,
     116,   120,   108,   673,   130,   211,   211,   126,   114,   115,
     108,   681,   203,   667,   668,   669,   157,   115,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     866,    40,    41,   255,   256,   257,   258,   259,   260,   254,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   756,   673,   858,   759,
     158,   739,   158,   741,   390,   681,   744,   203,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     890,   158,   153,   315,   316,   317,   318,   319,   320,   314,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   111,   108,    14,   110,
     135,   116,    51,    52,   115,    82,   673,   156,    24,    25,
      26,    27,    28,    29,   681,   357,    51,    52,    34,   361,
     122,    37,   673,   158,   345,   367,   368,   369,    44,   156,
     681,    47,    48,    37,   135,   146,    24,    25,    26,    27,
      28,    29,   384,   156,   386,   156,    34,   153,   390,    84,
      85,    86,   158,   130,    14,   156,    44,   158,   397,    47,
      48,   158,   397,   397,    24,    25,    26,    27,    28,    29,
     135,   891,    51,    52,    34,   111,   108,    37,   110,   108,
     116,   110,   131,   115,    44,   153,   115,    47,    48,   345,
     158,   156,   108,   158,   110,   108,   131,   146,   147,   115,
     650,   651,   115,    37,   153,   154,   155,   156,   143,   144,
     145,   146,   147,   108,   146,   111,   458,   146,   153,   154,
     155,   156,   108,    11,   110,   157,   203,   156,   678,   115,
     146,     9,   108,    24,    25,    26,    27,    28,    29,   115,
     573,   157,   108,    34,    24,    25,    26,    27,   108,   115,
     110,   108,   131,    44,   111,   115,    47,    48,   115,   116,
      24,    25,    26,    27,    28,    29,   145,   146,   147,   157,
      34,   513,   156,   156,   153,   154,   155,   156,   520,   729,
      44,   156,   156,    47,    48,    88,   146,   529,   530,   531,
     135,   533,   534,   535,   522,   523,   135,   157,   540,   153,
     156,   522,   523,   753,   158,   108,    14,    88,   108,   153,
     110,   114,   115,   108,   158,   115,    24,    25,    26,    27,
      28,    29,   159,   156,   156,   108,   565,   108,   108,   110,
     565,   565,   115,   114,   115,   115,    44,   108,   573,    47,
      48,   576,   577,   108,   115,   110,   679,   586,   108,   588,
     115,   156,   586,   156,   588,   115,   598,   153,   156,    88,
     602,    14,   158,   605,   153,   146,   157,   609,   345,   158,
      88,    24,    25,    26,    27,    28,    29,   153,    88,   108,
      42,   146,   158,   619,   619,   114,   115,   156,    88,   128,
     108,    44,   157,   157,    47,    48,   114,   115,   108,   156,
     108,   156,   110,   128,   114,   115,    27,   115,   108,    27,
     108,    14,   110,    34,   114,   115,    34,   115,   653,   159,
     156,   656,   108,    44,   110,   156,    44,   156,   108,   115,
     782,   111,    88,   159,   673,   115,   116,   158,   146,   673,
      51,    52,   681,   678,    51,    52,   156,   681,   146,   124,
     125,   156,   108,   128,   129,   108,   156,   110,   114,   115,
     146,   805,   115,   705,    34,   809,   159,    37,   812,   697,
     698,   815,   714,   156,   135,   135,   697,   698,   706,   108,
     156,   709,   111,   835,   156,   706,   838,   108,   709,   110,
     108,   135,   110,   146,   115,   159,   159,   115,    51,    52,
     736,   736,   156,   739,   739,   741,   741,   153,   744,   744,
     653,   153,   159,   656,   159,   867,   868,   869,   870,   871,
     131,   873,   874,   156,   131,   146,   156,   159,   146,   156,
     772,   773,   774,   775,   159,     4,   157,   779,   780,   157,
     153,   156,   153,   154,   155,   156,   153,   154,   155,   156,
     792,   124,   125,   138,   159,   128,   129,   159,   143,   144,
     159,   782,   797,    24,    25,    26,    27,    28,    29,   805,
     805,   159,   159,   809,   809,   159,   812,   812,   131,   815,
     815,   159,   158,    44,   134,   159,    47,    48,   159,   156,
     143,   144,   145,   146,   147,   159,   158,    43,    14,   827,
     153,   154,   155,   156,   189,   847,   827,   192,    24,    25,
      26,    27,    28,    29,   835,   159,   158,   838,   839,   153,
     156,    36,   159,   137,   108,   108,   782,   159,    44,   159,
     159,    47,    48,   159,   158,   156,   137,   156,   880,   156,
     134,   159,   884,   620,   621,   887,   867,   868,   869,   870,
     871,   872,   873,   874,   875,   115,   108,   159,   128,   159,
     902,   128,   137,    34,   892,   108,   643,   644,   113,   113,
     159,   892,   893,   894,   895,   896,   897,   898,   899,   835,
     137,   137,   838,   839,    27,   159,   159,   159,   108,    85,
     158,    34,   108,   278,   110,   159,   159,   159,   372,   115,
     159,    44,   565,   158,   158,   158,    28,   716,   221,   665,
     577,   867,   868,   869,   870,   871,   872,   873,   874,   875,
     588,   806,   787,   700,    71,   384,    -1,    -1,    -1,    -1,
     146,    -1,    -1,    -1,    -1,    -1,    -1,   893,   894,   895,
     896,   897,   898,   899,    27,    27,   723,   724,    -1,    -1,
     727,    34,    34,   338,    -1,    -1,    -1,    -1,   343,    -1,
      -1,    44,    44,    -1,    -1,   108,    -1,   110,    -1,   354,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     757,   758,    -1,    -1,   761,   762,    -1,    -1,    -1,   374,
     375,   376,    -1,    -1,    -1,    27,    -1,    -1,    -1,    -1,
      -1,    -1,    34,   146,    -1,   782,    -1,    -1,    -1,   394,
     395,   396,    44,    -1,   157,    -1,    -1,    -1,    -1,    -1,
     405,   406,   407,    27,    -1,   108,   108,   110,   110,    -1,
      34,    -1,   115,   115,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,   819,    -1,    -1,   822,   823,    -1,    -1,   826,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   835,    -1,
      -1,   838,   839,   146,   146,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   157,   157,   108,    -1,   110,    -1,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,
     867,   868,   869,   870,   871,   872,   873,   874,   875,    -1,
      -1,    -1,    -1,    -1,   108,    -1,   110,    -1,    -1,    -1,
      -1,   115,    -1,    -1,   146,    -1,   893,   894,   895,   896,
     897,   898,   899,    -1,    -1,   157,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   910,   911,    -1,   521,    -1,    -1,   524,
      -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   157,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,    -1,    -1,
     595,   596,   597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,   646,    33,    34,    35,    -1,    37,    38,    39,    -1,
      -1,    -1,    -1,    44,    45,    46,    47,    48,    49,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,   699,    -1,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,    -1,    -1,   130,
      -1,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   754,
      -1,    -1,   143,   144,    -1,   146,    -1,    -1,    -1,   150,
     151,   152,   153,    -1,    -1,   156,    -1,   158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     785,   786,    -1,    -1,    -1,    -1,    -1,    -1,   793,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,
       5,    -1,   817,    -1,    -1,    -1,    -1,    -1,    -1,    14,
      -1,    -1,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
     885,    -1,    -1,   888,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,   903,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,
      -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,    -1,
      -1,   156,    -1,     1,   159,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    34,    35,    -1,    37,
      38,    39,    -1,    -1,    -1,    -1,    44,    45,    46,    47,
      48,    49,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
      -1,    -1,   130,    -1,   132,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   143,   144,    -1,   146,    -1,
      -1,    -1,   150,   151,   152,   153,    -1,     1,   156,     3,
     158,     5,     6,     7,     8,    -1,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
     144,    -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,
      -1,     1,   156,     3,   158,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   143,   144,    -1,   146,    -1,    -1,    -1,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   143,   144,    -1,   146,    -1,    -1,    -1,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
     144,    -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,   108,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,    -1,    -1,
      -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,    -1,
     146,    -1,    -1,    -1,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,    -1,    -1,    -1,   127,
      -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   143,   144,    -1,   146,    -1,
      -1,    -1,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   143,   144,    -1,   146,    -1,    -1,    -1,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   143,   144,    -1,   146,    -1,    -1,    -1,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
     144,    -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,   108,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,    -1,    -1,
      -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,    -1,
     146,    -1,    -1,    -1,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,    -1,    -1,    -1,   127,
      -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   143,   144,    -1,   146,    -1,
      -1,    -1,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   143,   144,    -1,   146,    -1,    -1,    -1,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   143,   144,    -1,   146,    -1,    -1,    -1,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
     144,    -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,   108,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,    -1,    -1,
      -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,    -1,
     146,    -1,    -1,    -1,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,    -1,    -1,    -1,   127,
      -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   143,   144,    -1,   146,    -1,
      -1,    -1,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   143,   144,    -1,   146,    -1,    -1,    -1,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   143,   144,    -1,   146,    -1,    -1,    -1,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
     144,    -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,   108,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,    -1,    -1,
      -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,    -1,
     146,    -1,    -1,    -1,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,    -1,    -1,    -1,   127,
      -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   143,   144,    -1,   146,    -1,
      -1,    -1,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   143,   144,    -1,   146,    -1,    -1,    -1,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   143,   144,    -1,   146,    -1,    -1,    -1,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
     144,    -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,   108,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,    -1,    -1,
      -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,    -1,
     146,    -1,    -1,    -1,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,    -1,    -1,    -1,   127,
      -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   143,   144,    -1,   146,    -1,
      -1,    -1,   150,   151,   152,   153,    -1,     1,   156,    -1,
     158,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      14,    -1,    -1,    -1,    18,    19,    -1,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
     144,    -1,   146,    -1,     5,    -1,   150,   151,   152,   153,
      -1,    -1,   156,    14,   158,    -1,    -1,    18,    19,    -1,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      -1,    -1,    -1,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
      -1,   112,   113,   114,   115,    -1,   117,   118,   119,    -1,
     121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   143,   144,     5,   146,    -1,    -1,    -1,   150,
     151,   152,   153,    14,    -1,   156,    -1,    18,    19,   160,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      -1,    -1,    -1,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
      -1,   112,   113,   114,   115,    -1,   117,   118,   119,    -1,
     121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   143,   144,     5,   146,    -1,    -1,    -1,   150,
     151,   152,   153,    14,    -1,   156,    -1,    18,    19,   160,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      -1,    -1,    -1,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
      -1,   112,   113,   114,   115,    -1,   117,   118,   119,    -1,
     121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   143,   144,     5,   146,    -1,    -1,    -1,   150,
     151,   152,   153,    14,    -1,   156,    -1,    18,    19,   160,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      -1,    -1,    -1,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
      -1,   112,   113,   114,   115,    -1,   117,   118,   119,    -1,
     121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   143,   144,     5,   146,    -1,    -1,    -1,   150,
     151,   152,   153,    14,    -1,   156,    -1,    18,    19,   160,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      -1,    -1,    -1,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
      -1,   112,   113,   114,   115,    -1,   117,   118,   119,    -1,
     121,   122,   123,    -1,    -1,    -1,   127,    -1,    -1,   130,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   143,   144,    -1,   146,    -1,     5,    -1,   150,
     151,   152,   153,    -1,    -1,   156,    14,    -1,   159,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    -1,    -1,    -1,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,   109,   110,    -1,   112,   113,   114,   115,    -1,   117,
     118,   119,    -1,   121,   122,   123,    -1,    -1,    -1,   127,
      -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   143,   144,    -1,   146,    -1,
       5,    -1,   150,   151,   152,   153,    -1,    -1,   156,    14,
     158,    -1,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,    -1,   112,   113,   114,
     115,    -1,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,
       5,   146,    -1,    -1,    -1,   150,   151,   152,   153,    14,
      -1,   156,   157,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,    -1,   112,   113,   114,
     115,    -1,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,
       5,   146,    -1,    -1,    -1,   150,   151,   152,   153,    14,
      -1,   156,   157,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    81,    82,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,    -1,   112,   113,   114,
     115,    -1,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,   128,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   141,   142,   143,   144,
       5,   146,    -1,    -1,    -1,   150,   151,   152,   153,    14,
      -1,   156,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,
       5,   146,    -1,    -1,    -1,   150,   151,   152,   153,    14,
      -1,   156,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,   104,
     105,   106,   107,   108,   109,   110,    -1,   112,   113,   114,
     115,    -1,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,
       5,   146,    -1,    -1,    -1,   150,   151,   152,   153,    14,
      -1,   156,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,   104,
     105,   106,   107,   108,   109,   110,    -1,   112,   113,   114,
     115,    -1,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,
       5,   146,    -1,    -1,    -1,   150,   151,   152,   153,    14,
      -1,   156,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    -1,    -1,    -1,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,    -1,   112,   113,   114,
     115,    10,   117,   118,   119,    -1,   121,   122,   123,    -1,
      -1,    -1,   127,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   144,
      -1,   146,    -1,    -1,    -1,   150,   151,   152,   153,    -1,
      -1,   156,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,    -1,
      -1,    -1,   131,    -1,    -1,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,   153,   154,   155,   156,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    21,    -1,    -1,    -1,   131,    -1,
      -1,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,    -1,    -1,   160,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,    -1,    -1,   160,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,    -1,    -1,   160,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,    -1,    -1,   160,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,    -1,   159,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,
      -1,    -1,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,
      -1,   153,   154,   155,   156,    -1,    -1,   159,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,    -1,    -1,   159,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    -1,
      84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,
     134,   135,   136,    -1,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,
     154,   155,   156,    -1,    -1,   159,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,
     155,   156,    -1,    -1,   159,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    -1,    84,    85,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,
     156,    -1,    -1,   159,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      -1,    -1,   159,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    -1,    84,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
      -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,    -1,
      -1,   159,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,   153,   154,   155,   156,    -1,    -1,
     159,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    -1,    -1,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,    -1,    -1,
      -1,    -1,    -1,   153,   154,   155,   156,    -1,    -1,   159,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,    -1,   159,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,
      -1,    -1,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,
      -1,   153,   154,   155,   156,    -1,    -1,   159,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,    -1,    -1,   159,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    -1,
      84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,
     134,   135,   136,    -1,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,
     154,   155,   156,    -1,    -1,   159,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,
     155,   156,    -1,   158,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      -1,   158,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,   153,   154,   155,   156,    -1,   158,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,   158,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,    -1,   158,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,
     155,   156,    -1,   158,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      -1,   158,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,   153,   154,   155,   156,    -1,   158,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    -1,   158,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,    -1,   158,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,
     155,   156,    -1,   158,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      -1,   158,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,   153,   154,   155,   156,    -1,   158,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,   157,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    -1,
      84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,
     134,   135,   136,    -1,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,
     154,   155,   156,   157,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,
     155,   156,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,   153,   154,   155,   156,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,
     155,   156,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,   153,   154,   155,   156,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    51,    52,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,   131,    84,    85,    86,   135,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,   101,   102,    -1,   104,   153,   154,   155,   156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    -1,    -1,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    51,
      52,    -1,    -1,    -1,   153,   154,   155,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    51,    52,   101,
     102,    -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,   131,
      84,    85,    86,    -1,    -1,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,   101,   102,    -1,
      -1,   153,   154,   155,   156,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,    51,    52,    -1,    -1,    -1,   153,
     154,   155,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    -1,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,    -1,    -1,    51,    52,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,   153,   154,   155,   156,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    -1,    84,    85,
      86,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,    -1,    51,
      52,    -1,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,   155,
     156,    -1,    74,    75,    76,    77,    78,    79,    80,    81,
      82,   131,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,    -1,    -1,
      -1,    -1,    -1,   153,   154,   155,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,
      -1,   153,   154,   155,   156
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    33,    34,    35,    38,
      39,    44,    46,    47,    48,    51,    52,    63,    64,    65,
      66,    67,    68,    83,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   105,   106,
     107,   108,   110,   112,   113,   114,   115,   117,   118,   119,
     121,   122,   123,   127,   130,   132,   143,   144,   146,   150,
     151,   152,   153,   156,   158,   162,   163,   166,   167,   168,
     171,   172,   177,   180,   181,   184,   186,   187,   194,   195,
     206,   210,   211,   212,   214,   215,   217,   222,   224,   225,
     226,   158,    14,    27,   109,   115,   153,   194,   211,   216,
     220,   221,   222,   223,   108,   115,   156,   194,   195,   115,
     153,   173,   174,   177,   174,   223,   156,   156,   156,    88,
     108,   114,   115,   156,   204,   158,   158,   158,   223,   223,
     223,   223,    34,   108,   176,   178,   108,   115,   176,   158,
     156,   153,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   108,   110,   115,   223,   174,   174,   174,
     223,   223,   223,   223,   223,   223,     1,   185,   223,   156,
     156,   225,   156,   223,   223,   108,   110,   115,   223,   223,
     223,   157,   173,   175,   177,   159,   218,   219,   223,     0,
     163,    37,   158,    14,   108,   115,   111,   116,    45,    49,
     120,   126,    14,    27,   108,   115,   194,   212,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    84,    85,    86,   101,   102,   103,
     104,   131,   134,   135,   136,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   153,   154,   155,   156,   158,
     157,   218,   223,   157,   218,    14,    14,   194,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    84,    85,    86,   101,   102,   103,
     104,   131,   134,   135,   136,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   153,   154,   155,   156,   216,
     223,   108,   111,   156,   157,   175,    11,     9,   158,   223,
     223,   185,   156,   156,   156,   185,   185,    21,    21,   108,
     115,   156,    10,    31,    32,   174,   179,   135,   135,   156,
     223,   108,   164,   165,   156,   156,   156,   159,   185,   223,
     185,   157,   173,   177,   134,   159,   137,   159,   108,   115,
     156,   194,   195,   115,   156,   204,   156,   153,   158,   108,
     115,    42,   188,   188,   115,   156,   204,   156,    14,   115,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   124,   125,   128,   129,   128,   194,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   104,   223,
     223,   185,   157,   157,    14,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   124,   125,   128,
     129,   128,   194,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   223,   223,   104,   223,   223,   185,   159,   185,   157,
     156,   156,   159,   159,   158,   185,   159,   159,   223,   156,
     135,   135,   223,   156,   156,   156,   223,   223,   223,   159,
     135,   157,   165,   185,   185,   185,   159,   159,   159,   219,
     223,   216,   108,   115,   111,   116,   156,   185,   185,   185,
      14,   115,   157,   167,   168,   169,   170,   171,   172,   186,
     187,   194,   206,   211,   214,   215,   153,   153,    24,    25,
      26,    27,   108,   115,   189,   190,   153,   158,   153,   158,
     156,   185,   185,   185,   115,   156,   204,   156,   137,   157,
     160,   223,   104,   160,   159,   137,   157,   160,   223,   104,
     160,   159,   159,   223,   185,   174,   174,   185,   159,     4,
     213,   213,    10,   223,   223,   223,   159,   223,   223,   223,
     158,   158,   159,   153,   223,   159,   159,   159,   137,   158,
     207,   159,   185,   159,   159,   159,   156,   158,   157,   170,
      14,    14,   194,   191,   192,   194,   191,   108,   115,   108,
     115,   108,   115,   108,   115,   134,    24,    25,    26,    27,
      34,   157,   171,   193,   196,   197,   198,   205,   210,   211,
     157,   193,   185,   159,   159,   159,   156,   185,   185,   185,
     223,   160,   160,   223,   160,   160,   159,   159,    43,   158,
     213,   194,   195,   173,   173,   156,   159,   158,   158,   178,
     159,   159,   159,    36,    40,    41,   182,   183,   158,   108,
     115,   208,   209,   213,   159,   173,   173,   207,   185,    14,
     157,   192,   108,   157,   190,   113,   153,   201,   202,   153,
     202,   153,   202,    34,   153,   202,   157,   171,   196,   197,
     198,   205,   108,   194,   204,   157,   159,   213,   213,   207,
     185,   159,   159,   159,   158,   174,   174,   185,   173,   223,
     174,   174,   156,    74,    76,    77,    81,    82,   128,   141,
     142,   223,   137,   157,   183,   156,   156,   134,   173,   173,
     173,   159,   135,   156,   158,   115,    27,    44,   108,   157,
     171,   194,   195,   199,   200,   203,   134,   158,   157,   203,
     158,   157,   203,   158,   157,   203,   158,   204,   185,   213,
     173,   173,   213,   159,   173,   173,   207,   159,   159,   223,
     223,   223,   223,   128,   128,   137,   223,   223,   137,   175,
     185,   185,   209,   223,   185,   108,   194,   135,   158,   108,
     113,   157,   200,   201,   157,   157,   157,   185,   159,   173,
     158,   173,   173,   158,   173,   174,   159,   137,   137,   137,
     137,   137,   175,   137,   137,   175,   159,   159,   158,   159,
     135,   158,   108,   223,   135,   156,   158,   135,   156,   158,
     159,   207,   178,   175,   175,   175,   175,   175,   175,   175,
     158,   223,   135,   156,   158,   158,   223,   185,   223,   185,
     207,   213,   174,   158,   223,   185,   158,   159,   158,   159,
     158,   173,   158,   173,   158,   159,   158,   158,   158
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, yyscanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
  YYUSE (yyscanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule, yyscanner)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
    yyscan_t yyscanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       , yyscanner);
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule, yyscanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp, yyscanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
    yyscan_t yyscanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 108: /* "\"identifier\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6226 "parser.cpp"
	break;
      case 109: /* "\"typed hash identifier\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6231 "parser.cpp"
	break;
      case 110: /* "\"complex type identifier\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6236 "parser.cpp"
	break;
      case 111: /* "\"variable reference\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6241 "parser.cpp"
	break;
      case 112: /* "\"backquote expression\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6246 "parser.cpp"
	break;
      case 113: /* "\"in-object member reference\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6251 "parser.cpp"
	break;
      case 114: /* "\"identifier or keyword used as function or method identifier\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6256 "parser.cpp"
	break;
      case 115: /* "\"namespace or class-scoped reference\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6261 "parser.cpp"
	break;
      case 116: /* "\"namespace-scoped global variable reference\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6266 "parser.cpp"
	break;
      case 117: /* "\"context reference\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6271 "parser.cpp"
	break;
      case 118: /* "\"named context reference\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6276 "parser.cpp"
	break;
      case 119: /* "\"cast operator\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6281 "parser.cpp"
	break;
      case 120: /* "\"simple class declaration\"" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6286 "parser.cpp"
	break;
      case 121: /* "\"date/time value\"" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->datetime)) (yyvaluep->datetime)->deref(); };
#line 6291 "parser.cpp"
	break;
      case 122: /* "\"quoted string\"" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6296 "parser.cpp"
	break;
      case 123: /* "\"binary constant value\"" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->binary)) (yyvaluep->binary)->deref(); };
#line 6301 "parser.cpp"
	break;
      case 124: /* "\"regular expression substitution expression\"" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->RegexSubst); };
#line 6306 "parser.cpp"
	break;
      case 125: /* "\"transliteration expression\"" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->Trans); };
#line 6311 "parser.cpp"
	break;
      case 126: /* "\"scoped class declaration\"" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->nscope); };
#line 6316 "parser.cpp"
	break;
      case 127: /* "\"call to base class method\"" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->nscope); };
#line 6321 "parser.cpp"
	break;
      case 128: /* "\"regular expression\"" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->Regex); };
#line 6326 "parser.cpp"
	break;
      case 129: /* "\"regular expression extraction expression\"" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->Regex); };
#line 6331 "parser.cpp"
	break;
      case 130: /* "\"implicit argument reference\"" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->implicit_arg)) (yyvaluep->implicit_arg)->deref(); };
#line 6336 "parser.cpp"
	break;
      case 131: /* "\"keyword used as hash key or object member reference\"" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6341 "parser.cpp"
	break;
      case 132: /* "\"%try-module error token\"" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->trymod); };
#line 6346 "parser.cpp"
	break;
      case 167: /* "gvardecl" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->gv); };
#line 6351 "parser.cpp"
	break;
      case 168: /* "top_namespace_decl" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->ns); };
#line 6356 "parser.cpp"
	break;
      case 169: /* "namespace_decls" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->nsnlist)) (yyvaluep->nsnlist)->deref(); };
#line 6361 "parser.cpp"
	break;
      case 170: /* "namespace_decl" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->nsn)) (yyvaluep->nsn)->deref(); };
#line 6366 "parser.cpp"
	break;
      case 171: /* "unscoped_const_decl" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->constnode); };
#line 6371 "parser.cpp"
	break;
      case 172: /* "scoped_const_decl" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->constnode); };
#line 6376 "parser.cpp"
	break;
      case 173: /* "block" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6381 "parser.cpp"
	break;
      case 174: /* "statement_or_block" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6386 "parser.cpp"
	break;
      case 175: /* "statements" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6391 "parser.cpp"
	break;
      case 176: /* "optname" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6396 "parser.cpp"
	break;
      case 177: /* "statement" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6401 "parser.cpp"
	break;
      case 178: /* "context_mods" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->cmods); };
#line 6406 "parser.cpp"
	break;
      case 179: /* "context_mod" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->cmod); };
#line 6411 "parser.cpp"
	break;
      case 180: /* "return_statement" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6416 "parser.cpp"
	break;
      case 181: /* "switch_statement" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6421 "parser.cpp"
	break;
      case 182: /* "case_block" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->switchstmt); };
#line 6426 "parser.cpp"
	break;
      case 183: /* "case_code" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->casenode); };
#line 6431 "parser.cpp"
	break;
      case 184: /* "try_statement" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6436 "parser.cpp"
	break;
      case 185: /* "myexp" */
#line 1792 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6441 "parser.cpp"
	break;
      case 186: /* "hashdecl_def" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->hashdecldef); };
#line 6446 "parser.cpp"
	break;
      case 187: /* "class_def" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->classdef); };
#line 6451 "parser.cpp"
	break;
      case 188: /* "inheritance_list" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->sclist); };
#line 6456 "parser.cpp"
	break;
      case 189: /* "superclass_list" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->sclist); };
#line 6461 "parser.cpp"
	break;
      case 190: /* "superclass" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->sclnode); };
#line 6466 "parser.cpp"
	break;
      case 191: /* "hashdecl_attrs" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->hashdeclpriv)) (yyvaluep->hashdeclpriv)->deref(); };
#line 6471 "parser.cpp"
	break;
      case 192: /* "hashdecl_member" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6476 "parser.cpp"
	break;
      case 193: /* "class_attributes" */
#line 1789 "parser.ypp"
	{ qore_class_private::get(*(yyvaluep->qoreclass))->deref(); };
#line 6481 "parser.cpp"
	break;
      case 194: /* "uncqtypedef" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->parsertype); };
#line 6486 "parser.cpp"
	break;
      case 195: /* "qtypedef" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->parsertype); };
#line 6491 "parser.cpp"
	break;
      case 196: /* "internal_member_list" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6496 "parser.cpp"
	break;
      case 197: /* "private_member_list" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6501 "parser.cpp"
	break;
      case 198: /* "public_member_list" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6506 "parser.cpp"
	break;
      case 199: /* "classvardecl" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->classvarinfo); };
#line 6511 "parser.cpp"
	break;
      case 200: /* "member2" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6516 "parser.cpp"
	break;
      case 201: /* "member" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6521 "parser.cpp"
	break;
      case 202: /* "member_list" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6526 "parser.cpp"
	break;
      case 203: /* "member_list2" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6531 "parser.cpp"
	break;
      case 204: /* "ident_openparen" */
#line 1790 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6536 "parser.cpp"
	break;
      case 205: /* "inline_methoddef" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->methodnode); };
#line 6541 "parser.cpp"
	break;
      case 206: /* "outofline_methoddef" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->methoddef); };
#line 6546 "parser.cpp"
	break;
      case 207: /* "base_constructor_list" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->bcalist); };
#line 6551 "parser.cpp"
	break;
      case 208: /* "base_constructors" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->bcalist); };
#line 6556 "parser.cpp"
	break;
      case 209: /* "base_constructor" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->bcanode); };
#line 6561 "parser.cpp"
	break;
      case 213: /* "return_value" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->returnTypeInfo); };
#line 6566 "parser.cpp"
	break;
      case 214: /* "sub_def" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->parsefunc); };
#line 6571 "parser.cpp"
	break;
      case 215: /* "scoped_sub_def" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->sparsefunc); };
#line 6576 "parser.cpp"
	break;
      case 216: /* "list" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->parse_list)) (yyvaluep->parse_list)->deref(); };
#line 6581 "parser.cpp"
	break;
      case 217: /* "list_n" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->parse_list)) (yyvaluep->parse_list)->deref(); };
#line 6586 "parser.cpp"
	break;
      case 218: /* "hash" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->hash); };
#line 6591 "parser.cpp"
	break;
      case 219: /* "hash_element" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->hashelement); };
#line 6596 "parser.cpp"
	break;
      case 220: /* "alt_hash" */
#line 1788 "parser.ypp"
	{ delete (yyvaluep->hash); };
#line 6601 "parser.cpp"
	break;
      case 221: /* "immediate_typed_hash" */
#line 1792 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6606 "parser.cpp"
	break;
      case 222: /* "exp_c" */
#line 1792 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6611 "parser.cpp"
	break;
      case 223: /* "exp" */
#line 1792 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6616 "parser.cpp"
	break;
      case 224: /* "exp_n" */
#line 1792 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6621 "parser.cpp"
	break;
      case 225: /* "string" */
#line 1791 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6626 "parser.cpp"
	break;
      case 226: /* "scalar" */
#line 1792 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6631 "parser.cpp"
	break;

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (yyscan_t yyscanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (yyscan_t yyscanner)
#else
int
yyparse (yyscanner)
    yyscan_t yyscanner;
#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 1801 "parser.ypp"
    {
           (yyvsp[(1) - (1)].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 5:
#line 1804 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].sparsefunc)->loc, "function", (yyvsp[(1) - (1)].sparsefunc)->name.ostr);
           (yyvsp[(1) - (1)].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 6:
#line 1809 "parser.ypp"
    {
           qore_root_ns_private::parseAddClass((yyvsp[(1) - (1)].classdef)->loc, *((yyvsp[(1) - (1)].classdef)->name), (yyvsp[(1) - (1)].classdef)->oc);

           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error((yyvsp[(1) - (1)].classdef)->loc, "illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
           delete (yyvsp[(1) - (1)].classdef);
        }
    break;

  case 7:
#line 1817 "parser.ypp"
    {
           qore_root_ns_private::parseAddHashDecl((yyvsp[(1) - (1)].hashdecldef)->loc, *((yyvsp[(1) - (1)].hashdecldef)->name), (yyvsp[(1) - (1)].hashdecldef)->takeHashDecl());
           delete (yyvsp[(1) - (1)].hashdecldef);
        }
    break;

  case 8:
#line 1821 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].constnode)->loc, "constant", (yyvsp[(1) - (1)].constnode)->name.ostr);
           qore_root_ns_private::parseAddConstant((yyvsp[(1) - (1)].constnode)->loc, *getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 9:
#line 1827 "parser.ypp"
    {
           qore_root_ns_private::parseAddConstant((yyvsp[(1) - (1)].constnode)->loc, *getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 10:
#line 1831 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].methoddef)->loc, "method", (yyvsp[(1) - (1)].methoddef)->name.ostr);
           (yyvsp[(1) - (1)].methoddef)->parseAddToClassAndDel();
        }
    break;

  case 11:
#line 1836 "parser.ypp"
    {
           if ((yyvsp[(1) - (1)].statement)) {
              if ((yyvsp[(1) - (1)].statement)->isParseDeclaration())
                 delete (yyvsp[(1) - (1)].statement);
              else
                 qore_program_private::addStatement(*(getProgram()), (yyvsp[(1) - (1)].statement));
           }
        }
    break;

  case 13:
#line 1845 "parser.ypp"
    {
           // set line range
           (yyvsp[(2) - (3)].sblock)->loc.start_line = (yylsp[(1) - (3)]).first_line;
           (yyvsp[(2) - (3)].sblock)->loc.end_line = (yylsp[(2) - (3)]).last_line;
           qore_program_private::addStatement(*(getProgram()), (yyvsp[(2) - (3)].sblock));
        }
    break;

  case 14:
#line 1851 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           qore_root_ns_private::parseAddNamespace((yyvsp[(1) - (1)].ns));
           // see if ns declaration is legal
           if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
              parse_error(loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
        }
    break;

  case 15:
#line 1858 "parser.ypp"
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");
           else {
              QoreUserModuleDefContextHelper* uqmd = static_cast<QoreUserModuleDefContextHelper*>(qmd);
              uqmd->close();
           }
           // registered internally
        }
    break;

  case 16:
#line 1868 "parser.ypp"
    {
           bool has_dollar = (yyvsp[(1) - (1)].trymod)->var[0] == '$';
           if (!has_dollar) {
              if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), "%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (1)].trymod)->var);
           }
           else {
              (yyvsp[(1) - (1)].trymod)->fixName();
              if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), "%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].trymod)->var);
           }

           if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
              parse_error(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), "'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
           }
           else {
              VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].trymod)->takeName());
              QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), left, (yyvsp[(1) - (1)].trymod)->takeExceptionHash());
              qore_program_private::addStatement(*(getProgram()), new ExpressionStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, exp));
           }
           delete (yyvsp[(1) - (1)].trymod);
        }
    break;

  case 17:
#line 1893 "parser.ypp"
    {
        }
    break;

  case 18:
#line 1895 "parser.ypp"
    {
        }
    break;

  case 19:
#line 1900 "parser.ypp"
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), loc, QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[(1) - (4)].string), get_type_name((yyvsp[(3) - (4)].node)));
           else
              qmd->set(loc, (yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].node));

           free((yyvsp[(1) - (4)].string));
           (yyvsp[(3) - (4)].node)->deref(0);
        }
    break;

  case 20:
#line 1914 "parser.ypp"
    { (yyval.b) = false; }
    break;

  case 21:
#line 1915 "parser.ypp"
    {
           (yyval.b) = true;
        }
    break;

  case 22:
#line 1921 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "global variable", (yyvsp[(4) - (4)].string));
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true);
           delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 23:
#line 1929 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "global variable", (yyvsp[(3) - (3)].string));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 24:
#line 1935 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true);
           delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 25:
#line 1941 "parser.ypp"
    {
           (yyval.gv) = new GVarSingleDecl(QoreProgramLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 26:
#line 1944 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "global variable", (yyvsp[(4) - (4)].string));
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false);
           delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 27:
#line 1952 "parser.ypp"
    {
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
           (yyval.gv) = new GVarSingleDecl(QoreProgramLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false);
           delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 28:
#line 1957 "parser.ypp"
    {
           (yyval.gv) = new GVarListDecl(QoreProgramLocation((yyvsp[(1) - (5)].b) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(4) - (5)].parse_list), (yyvsp[(1) - (5)].b));
        }
    break;

  case 29:
#line 1963 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           qore_ns_private* p = new qore_ns_private(loc);
           check_nsmod(loc, (yyvsp[(1) - (5)].i4), *p);
           (yyvsp[(4) - (5)].nsnlist)->add(*p);
           delete (yyvsp[(4) - (5)].nsnlist);
           (yyval.ns) = p->ns;
        }
    break;

  case 30:
#line 1971 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (3)].i4) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
           qore_ns_private* p = new qore_ns_private(loc);
           check_nsmod(loc, (yyvsp[(1) - (3)].i4), *p);
           (yyval.ns) = p->ns;
        }
    break;

  case 31:
#line 1977 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           qore_ns_private* p = new qore_ns_private(loc);
           check_nsmod(loc, (yyvsp[(1) - (4)].i4), *p);
           (yyval.ns) = p->ns;
        }
    break;

  case 32:
#line 1986 "parser.ypp"
    {
           (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[(1) - (1)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(1) - (1)].nsn));
        }
    break;

  case 33:
#line 1991 "parser.ypp"
    {
           (yyval.nsnlist) = (yyvsp[(1) - (2)].nsnlist);
           if ((yyvsp[(2) - (2)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(2) - (2)].nsn));
        }
    break;

  case 34:
#line 1999 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].constnode)->loc, "constant", (yyvsp[(1) - (1)].constnode)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 35:
#line 2004 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 36:
#line 2007 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].classdef));
           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), "illegal class definition \"%s\" (conflicts with parse option PO_NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
        }
    break;

  case 37:
#line 2013 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].hashdecldef));
        }
    break;

  case 38:
#line 2016 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].parsefunc));
        }
    break;

  case 39:
#line 2019 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].sparsefunc)->loc, "function", (yyvsp[(1) - (1)].sparsefunc)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].sparsefunc));
        }
    break;

  case 40:
#line 2024 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (2)].gv));
        }
    break;

  case 41:
#line 2027 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].ns));
           // see if ns declaration is legal
           if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
              parse_error(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
        }
    break;

  case 42:
#line 2033 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].methoddef));
        }
    break;

  case 43:
#line 2039 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].node));
        }
    break;

  case 44:
#line 2042 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line), (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].node), true);
        }
    break;

  case 45:
#line 2048 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].node));
        }
    break;

  case 46:
#line 2051 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line), (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].node), true);
        }
    break;

  case 47:
#line 2058 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(2) - (3)].sblock); }
    break;

  case 48:
#line 2061 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line); }
    break;

  case 49:
#line 2066 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 50:
#line 2069 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(1) - (1)].sblock); }
    break;

  case 51:
#line 2074 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 52:
#line 2076 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].sblock)); }
    break;

  case 53:
#line 2078 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].sblock)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 54:
#line 2080 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].statement)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 55:
#line 2085 "parser.ypp"
    { (yyval.string) = 0; }
    break;

  case 56:
#line 2086 "parser.ypp"
    { (yyval.string) = (yyvsp[(1) - (1)].string); }
    break;

  case 57:
#line 2090 "parser.ypp"
    { (yyval.statement) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 58:
#line 2091 "parser.ypp"
    {
           // if the expression has no effect and it's not a variable declaration
           qore_type_t t = (yyvsp[(1) - (2)].node) ? (yyvsp[(1) - (2)].node)->getType() : 0;
           bool ok = false;
           if (t == NT_PARSE_LIST) {
              QoreParseListNode* l = reinterpret_cast<QoreParseListNode*>((yyvsp[(1) - (2)].node));
              // rewrite expression if it's a list without parentheses under certain conditions
              (yyvsp[(1) - (2)].node) = check_rewrite_list(l);

              if (l->isVariableList())
                 ok = true;
           }

           if (!ok && !node_has_effect((yyvsp[(1) - (2)].node)) && (t != NT_VARREF || !reinterpret_cast<VarRefNode*>((yyvsp[(1) - (2)].node))->parseIsDecl()))
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line), "statement has no effect (%s)", (yyvsp[(1) - (2)].node) ? (yyvsp[(1) - (2)].node)->getTypeName() : "NOTHING");
           ignore_return_value((yyvsp[(1) - (2)].node));
           (yyval.statement) = new ExpressionStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line, (yyvsp[(1) - (2)].node));
        }
    break;

  case 59:
#line 2110 "parser.ypp"
    {
           NamedScope *ns = new NamedScope((yyvsp[(1) - (5)].string));
           assert(ns->size() > 1);
           printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
           (yyval.statement) = new ExpressionStatement((yylsp[(1) - (5)]).first_line, (yylsp[(1) - (5)]).last_line, new StaticMethodCallNode(loc, ns, make_args(QoreProgramLocation((yylsp[(3) - (5)]).first_line, (yylsp[(3) - (5)]).last_line), (yyvsp[(3) - (5)].node))));
        }
    break;

  case 60:
#line 2118 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 61:
#line 2119 "parser.ypp"
    {
           (yyval.statement) = new RethrowStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 62:
#line 2122 "parser.ypp"
    {
           (yyval.statement) = new ThrowStatement((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line, (yyvsp[(2) - (3)].node));
        }
    break;

  case 63:
#line 2125 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Unconditional);
        }
    break;

  case 64:
#line 2128 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Success);
        }
    break;

  case 65:
#line 2131 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Error);
        }
    break;

  case 66:
#line 2134 "parser.ypp"
    {
           (yyval.statement) = new ContextStatement((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, 0, 0, (yyvsp[(2) - (3)].cmods), (yyvsp[(3) - (3)].sblock));
        }
    break;

  case 67:
#line 2137 "parser.ypp"
    {
           (yyval.statement) = new SummarizeStatement((yylsp[(1) - (11)]).first_line, (yylsp[(11) - (11)]).last_line, (yyvsp[(2) - (11)].string), (yyvsp[(4) - (11)].node), (yyvsp[(10) - (11)].cmods), (yyvsp[(11) - (11)].sblock), (yyvsp[(8) - (11)].node));
        }
    break;

  case 68:
#line 2140 "parser.ypp"
    {
           (yyval.statement) = new ContextStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].string), (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].cmods), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 69:
#line 2143 "parser.ypp"
    {
           (yyval.statement) = new IfStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 70:
#line 2146 "parser.ypp"
    {
           (yyval.statement) = new IfStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].sblock), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 71:
#line 2149 "parser.ypp"
    {
           (yyval.statement) = new WhileStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 72:
#line 2152 "parser.ypp"
    {
           (yyval.statement) = new DoWhileStatement((yylsp[(1) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), (yyvsp[(2) - (7)].sblock));
        }
    break;

  case 73:
#line 2155 "parser.ypp"
    {
           (yyval.statement) = new ForStatement((yylsp[(1) - (9)]).first_line, (yylsp[(9) - (9)]).last_line, (yyvsp[(3) - (9)].node), (yyvsp[(5) - (9)].node), (yyvsp[(7) - (9)].node), (yyvsp[(9) - (9)].sblock));
        }
    break;

  case 74:
#line 2158 "parser.ypp"
    {
           (yyval.statement) = new ForEachStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].node), (yyvsp[(5) - (7)].node), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 75:
#line 2161 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (2)].statement); }
    break;

  case 76:
#line 2162 "parser.ypp"
    {
           // see if thread exit is allowed
           if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line), "illegal use of \"thread_exit\" (conflicts with parse option PO_NO_THREAD_CONTROL)");

           (yyval.statement) = new ThreadExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 77:
#line 2169 "parser.ypp"
    {
          (yyval.statement) = new BreakStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 78:
#line 2172 "parser.ypp"
    {
          (yyval.statement) = new ContinueStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 79:
#line 2175 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 80:
#line 2176 "parser.ypp"
    { (yyval.statement) = 0; }
    break;

  case 81:
#line 2181 "parser.ypp"
    { (yyval.cmods) = 0; }
    break;

  case 82:
#line 2182 "parser.ypp"
    {
           if (!(yyvsp[(1) - (2)].cmods))
              (yyval.cmods) = new ContextModList((yyvsp[(2) - (2)].cmod));
           else {
              (yyvsp[(1) - (2)].cmods)->addContextMod((yyvsp[(2) - (2)].cmod));
              (yyval.cmods) = (yyvsp[(1) - (2)].cmods);
           }
        }
    break;

  case 83:
#line 2194 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[(3) - (4)].node)); }
    break;

  case 84:
#line 2196 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[(3) - (4)].node)); }
    break;

  case 85:
#line 2198 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[(3) - (4)].node)); }
    break;

  case 86:
#line 2202 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 87:
#line 2204 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].node)); }
    break;

  case 88:
#line 2209 "parser.ypp"
    {
           (yyvsp[(6) - (7)].switchstmt)->setSwitch((yyvsp[(3) - (7)].node));
           (yyval.statement) = (yyvsp[(6) - (7)].switchstmt);
           (yyval.statement)->loc.start_line = (yylsp[(1) - (7)]).first_line;
           (yyval.statement)->loc.end_line = (yylsp[(7) - (7)]).last_line;
        }
    break;

  case 89:
#line 2219 "parser.ypp"
    {
           (yyval.switchstmt) = new SwitchStatement((yyvsp[(1) - (1)].casenode));
        }
    break;

  case 90:
#line 2223 "parser.ypp"
    {
           (yyvsp[(1) - (2)].switchstmt)->addCase((yyvsp[(2) - (2)].casenode));
           (yyval.switchstmt) = (yyvsp[(1) - (2)].switchstmt);
        }
    break;

  case 91:
#line 2231 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           check_case(loc, ">=", (yyvsp[(3) - (5)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
    break;

  case 92:
#line 2237 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           check_case(loc, ">=", (yyvsp[(3) - (4)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].node), 0, QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
    break;

  case 93:
#line 2244 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           check_case(loc, "<=", (yyvsp[(3) - (5)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
    break;

  case 94:
#line 2250 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           check_case(loc, "<=", (yyvsp[(3) - (4)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].node), 0, QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
    break;

  case 95:
#line 2257 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           check_case(loc, "==", (yyvsp[(3) - (5)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), QoreLogicalEqualsOperatorNode::softEqual);
        }
    break;

  case 96:
#line 2263 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           check_case(loc, "==", (yyvsp[(3) - (4)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].node), 0, QoreLogicalEqualsOperatorNode::softEqual);
        }
    break;

  case 97:
#line 2270 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           check_case(loc, "<", (yyvsp[(3) - (5)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), QoreLogicalLessThanOperatorNode::doLessThan);
        }
    break;

  case 98:
#line 2276 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           check_case(loc, "<", (yyvsp[(3) - (4)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].node), 0, QoreLogicalLessThanOperatorNode::doLessThan);
        }
    break;

  case 99:
#line 2283 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           check_case(loc, ">", (yyvsp[(3) - (5)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
    break;

  case 100:
#line 2289 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           check_case(loc, ">", (yyvsp[(3) - (4)].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].node), 0, QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
    break;

  case 101:
#line 2296 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 102:
#line 2301 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(3) - (4)].Regex), 0);
        }
    break;

  case 103:
#line 2307 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 104:
#line 2312 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[(3) - (4)].Regex), 0);
        }
    break;

  case 105:
#line 2318 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(2) - (4)].Regex), (yyvsp[(4) - (4)].sblock));
        }
    break;

  case 106:
#line 2323 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(2) - (3)].Regex), 0);
        }
    break;

  case 107:
#line 2329 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           check_case(loc, 0, (yyvsp[(2) - (4)].node));
           (yyval.casenode) = new CaseNode(loc, (yyvsp[(2) - (4)].node), (yyvsp[(4) - (4)].sblock));
        }
    break;

  case 108:
#line 2335 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
           check_case(loc, 0, (yyvsp[(2) - (3)].node));
           (yyval.casenode) = new CaseNode(loc, (yyvsp[(2) - (3)].node), 0);
        }
    break;

  case 109:
#line 2342 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
           (yyval.casenode) = new CaseNode(loc, 0, (yyvsp[(3) - (3)].sblock));
        }
    break;

  case 110:
#line 2347 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           (yyval.casenode) = new CaseNode(loc, 0, 0);
        }
    break;

  case 111:
#line 2354 "parser.ypp"
    {
           char* param = 0;
           const QoreTypeInfo* typeInfo = nullptr;
           QoreParseTypeInfo* parseTypeInfo = nullptr;
           if ((yyvsp[(5) - (7)].node)) {
              if ((yyvsp[(5) - (7)].node)->getType() == NT_VARREF) {
                 VarRefNode *varRefNode = static_cast<VarRefNode*>((yyvsp[(5) - (7)].node));
                 param = varRefNode->takeName();
                 if (varRefNode->isDecl()) {
                    VarRefDeclNode* varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    parseTypeInfo = varRefDeclNode->takeParseTypeInfo();
                    if (!parseTypeInfo)
                       typeInfo = varRefDeclNode->getTypeInfo();
                    /*
                    if (varRefDeclNode->getParseTypeInfo() || QoreTypeInfo::parseAccepts(varRefDeclNode->getTypeInfo(), hashTypeInfo) == QTI_NOT_EQUAL) {
                       parse_error(QoreProgramLocation(@1.first_line, @7.last_line), "the type of catch parameter '%s' must be 'hash'", param);
                    }
                    else
                      typeInfo = varRefDeclNode->getTypeInfo();
                    */
                 }
              } else if ((yyvsp[(5) - (7)].node)->getType() == NT_BAREWORD) {
                 param = reinterpret_cast<BarewordNode*>((yyvsp[(5) - (7)].node))->takeString();
                 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(QoreProgramLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line), "local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
              } else
                 parse_error(QoreProgramLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line), "only one parameter accepted in catch block for exception hash");
              (yyvsp[(5) - (7)].node)->deref(0);
           }
           QoreProgramLocation vloc((yyvsp[(5) - (7)].node) ? (yylsp[(5) - (7)]).first_line : 0, (yyvsp[(5) - (7)].node) ? (yylsp[(5) - (7)]).last_line : 0);
           (yyval.statement) = new TryStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].sblock), (yyvsp[(7) - (7)].sblock), param, typeInfo, parseTypeInfo, vloc);
        }
    break;

  case 112:
#line 2388 "parser.ypp"
    { (yyval.node) = 0; }
    break;

  case 113:
#line 2389 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].node); }
    break;

  case 114:
#line 2390 "parser.ypp"
    { (yyval.node) = 0; }
    break;

  case 115:
#line 2394 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
           check_hashdeclmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].hashdeclpriv)));
           (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].hashdeclpriv));
        }
    break;

  case 116:
#line 2399 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
           check_hashdeclmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].hashdeclpriv)));
           (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].hashdeclpriv));
        }
    break;

  case 117:
#line 2407 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
           check_classmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
           qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (6)].string), (yyvsp[(5) - (6)].qoreclass));
        }
    break;

  case 118:
#line 2413 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "class", (yyvsp[(2) - (6)].nscope)->ostr);
           check_classmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (6)].nscope), (yyvsp[(5) - (6)].qoreclass));
           qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
        }
    break;

  case 119:
#line 2421 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[(1) - (4)].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (4)].string), qc);
        }
    break;

  case 120:
#line 2430 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "class", (yyvsp[(2) - (4)].nscope)->ostr);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[(1) - (4)].i4), *qc);
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (4)].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
        }
    break;

  case 121:
#line 2441 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[(1) - (5)].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (5)].string), qc);
        }
    break;

  case 122:
#line 2450 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "class", (yyvsp[(2) - (5)].nscope)->ostr);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[(1) - (5)].i4), *qc);
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (5)].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
        }
    break;

  case 123:
#line 2464 "parser.ypp"
    {
           (yyval.sclist) = (yyvsp[(2) - (2)].sclist);
        }
    break;

  case 124:
#line 2467 "parser.ypp"
    { // NOTHING
           (yyval.sclist) = 0;
        }
    break;

  case 125:
#line 2473 "parser.ypp"
    {
           (yyval.sclist) = new BCList((yyvsp[(1) - (1)].sclnode));
        }
    break;

  case 126:
#line 2476 "parser.ypp"
    {
           (yyvsp[(1) - (3)].sclist)->push_back((yyvsp[(3) - (3)].sclnode));
           (yyval.sclist) = (yyvsp[(1) - (3)].sclist);
        }
    break;

  case 127:
#line 2483 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string), Public);
        }
    break;

  case 128:
#line 2486 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), new NamedScope((yyvsp[(1) - (1)].string)), Public);
        }
    break;

  case 129:
#line 2489 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].string), Public);
        }
    break;

  case 130:
#line 2492 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), new NamedScope((yyvsp[(2) - (2)].string)), Public);
        }
    break;

  case 131:
#line 2495 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].string), Private);
        }
    break;

  case 132:
#line 2498 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), new NamedScope((yyvsp[(2) - (2)].string)), Private);
        }
    break;

  case 133:
#line 2501 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].string), Private);
        }
    break;

  case 134:
#line 2504 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), new NamedScope((yyvsp[(2) - (2)].string)), Private);
        }
    break;

  case 135:
#line 2507 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].string), Internal);
        }
    break;

  case 136:
#line 2510 "parser.ypp"
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), new NamedScope((yyvsp[(2) - (2)].string)), Internal);
        }
    break;

  case 137:
#line 2516 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           (yyval.hashdeclpriv) = new typed_hash_decl_private(loc);
           if ((yyvsp[(1) - (1)].memberinfo)) {
              (yyval.hashdeclpriv)->parseAdd((yyvsp[(1) - (1)].memberinfo)->getHashMemPair());
              delete (yyvsp[(1) - (1)].memberinfo);
           }
        }
    break;

  case 138:
#line 2524 "parser.ypp"
    {
           if ((yyvsp[(2) - (2)].memberinfo)) {
              if ((yyvsp[(1) - (2)].hashdeclpriv)->hasMember((yyvsp[(2) - (2)].memberinfo)->name)) {
                 parse_error((yyvsp[(2) - (2)].memberinfo)->loc, "duplicate hashdecl member declaration '%s'", (yyvsp[(2) - (2)].memberinfo)->name);
              }
              else {
                 // add new member to list
                 (yyvsp[(1) - (2)].hashdeclpriv)->parseAdd((yyvsp[(2) - (2)].memberinfo)->getHashMemPair());
              }
              delete (yyvsp[(2) - (2)].memberinfo);
           }

           (yyval.hashdeclpriv) = (yyvsp[(1) - (2)].hashdeclpriv);
        }
    break;

  case 139:
#line 2541 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
           delete (yyvsp[(1) - (3)].parsertype);
        }
    break;

  case 140:
#line 2546 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].node)));
           delete (yyvsp[(1) - (5)].parsertype);
        }
    break;

  case 141:
#line 2551 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype));

           if (!(yyvsp[(1) - (6)].parsertype))
              parse_error(loc, "cannot call constructor without declaring the class");
           else if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line), (yyvsp[(4) - (6)].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line), (yyvsp[(4) - (6)].node)));

           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new HashDeclMemberInfo(loc, t, pti, new_call));

           delete (yyvsp[(1) - (6)].parsertype);
        }
    break;

  case 142:
#line 2573 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = (yyvsp[(1) - (1)].methodnode)->getLoc();
           (yyvsp[(1) - (1)].methodnode)->addAndDelete((yyval.qoreclass));
        }
    break;

  case 143:
#line 2578 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Internal);
           delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 144:
#line 2584 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Private);
           delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 145:
#line 2590 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Public);
           delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 146:
#line 2596 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreClass;
           QoreProgramLocation loc((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           qore_class_private::get(*(yyval.qoreclass))->loc = loc;
           qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[(1) - (1)].constnode)->getName(), (yyvsp[(1) - (1)].constnode)->takeValue(), Public);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 147:
#line 2603 "parser.ypp"
    {
           qore_class_private::get(*(yyvsp[(1) - (2)].qoreclass))->loc.end_line = (yylsp[(2) - (2)]).last_line;
           (yyvsp[(2) - (2)].methodnode)->addAndDelete((yyvsp[(1) - (2)].qoreclass));
           (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
        }
    break;

  case 148:
#line 2608 "parser.ypp"
    {
           qore_class_private::get(*(yyvsp[(1) - (2)].qoreclass))->loc.end_line = (yylsp[(2) - (2)]).last_line;
           (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Internal);
           (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
           delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 149:
#line 2614 "parser.ypp"
    {
           qore_class_private::get(*(yyvsp[(1) - (2)].qoreclass))->loc.end_line = (yylsp[(2) - (2)]).last_line;
           (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Private);
           (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
           delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 150:
#line 2620 "parser.ypp"
    {
           qore_class_private::get(*(yyvsp[(1) - (2)].qoreclass))->loc.end_line = (yylsp[(2) - (2)]).last_line;
           (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Public);
           (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
           delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 151:
#line 2626 "parser.ypp"
    {
           qore_class_private::get(*(yyvsp[(1) - (2)].qoreclass))->loc.end_line = (yylsp[(2) - (2)]).last_line;
           qore_class_private::parseAddConstant(*((yyval.qoreclass)), QoreProgramLocation((yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].constnode)->getName(), (yyvsp[(2) - (2)].constnode)->takeValue(), Public);
           (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
           delete (yyvsp[(2) - (2)].constnode);
        }
    break;

  case 152:
#line 2635 "parser.ypp"
    {
           (yyval.parsertype) = new ParserTypeStruct((yyvsp[(1) - (1)].string), false);
        }
    break;

  case 153:
#line 2638 "parser.ypp"
    {
           (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[(1) - (1)].string), false));
        }
    break;

  case 154:
#line 2641 "parser.ypp"
    {
           (yyval.parsertype) = ParserTypeStruct::getType(QoreProgramLocation((yylsp[(1) - (1)]). first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string), false);
        }
    break;

  case 155:
#line 2644 "parser.ypp"
    {
           (yyval.parsertype) = new ParserTypeStruct((yyvsp[(2) - (2)].string), true);
        }
    break;

  case 156:
#line 2647 "parser.ypp"
    {
           (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[(2) - (2)].string), true));
        }
    break;

  case 157:
#line 2650 "parser.ypp"
    {
           (yyval.parsertype) = ParserTypeStruct::getType(QoreProgramLocation((yylsp[(1) - (2)]). first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].string), true);
        }
    break;

  case 158:
#line 2657 "parser.ypp"
    { (yyval.parsertype) = 0; }
    break;

  case 159:
#line 2658 "parser.ypp"
    {
           (yyval.parsertype) = (yyvsp[(1) - (1)].parsertype);
        }
    break;

  case 160:
#line 2664 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 161:
#line 2665 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 162:
#line 2666 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 163:
#line 2670 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 164:
#line 2671 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 165:
#line 2672 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 166:
#line 2673 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 167:
#line 2674 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 168:
#line 2675 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 169:
#line 2679 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 170:
#line 2680 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 171:
#line 2681 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 172:
#line 2685 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (4)].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (4)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (4)].parsertype))));
           delete (yyvsp[(2) - (4)].parsertype);
        }
    break;

  case 173:
#line 2690 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (3)].string), new QoreVarInfo(loc));
        }
    break;

  case 174:
#line 2694 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (6)].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (6)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (6)].parsertype)), (yyvsp[(5) - (6)].node)));
           //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
           delete (yyvsp[(2) - (6)].parsertype);
        }
    break;

  case 175:
#line 2700 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (5)].string), new QoreVarInfo(loc, nullptr, nullptr, (yyvsp[(4) - (5)].node)));
        }
    break;

  case 176:
#line 2704 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype));

           if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line), (yyvsp[(5) - (7)].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line), (yyvsp[(5) - (7)].node)));

           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (7)].string), new QoreVarInfo(loc, t, pti, new_call));

           delete (yyvsp[(2) - (7)].parsertype);
        }
    break;

  case 177:
#line 2724 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (3)].parsertype) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
           delete (yyvsp[(1) - (3)].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (3)].string));
        }
    break;

  case 178:
#line 2731 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (5)].parsertype) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].node)));
           delete (yyvsp[(1) - (5)].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (5)].string));
        }
    break;

  case 179:
#line 2738 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = (yyvsp[(1) - (6)].parsertype) ? ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)) : nullptr;

           if (!(yyvsp[(1) - (6)].parsertype))
              parse_error(loc, "cannot call constructor without declaring the class");
           else if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti && pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line), (yyvsp[(4) - (6)].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line), (yyvsp[(4) - (6)].node)));

           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(loc, t, pti, new_call));

           delete (yyvsp[(1) - (6)].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (6)].string));
        }
    break;

  case 180:
#line 2759 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
           delete (yyvsp[(1) - (3)].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (3)].string));
        }
    break;

  case 181:
#line 2766 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].node)));
           delete (yyvsp[(1) - (5)].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (5)].string));
        }
    break;

  case 182:
#line 2773 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype));

           if (!(yyvsp[(1) - (6)].parsertype))
              parse_error(loc, "cannot call constructor without declaring the class");
           else if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line), (yyvsp[(4) - (6)].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line), (yyvsp[(4) - (6)].node)));

           (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(loc, t, pti, new_call));

           delete (yyvsp[(1) - (6)].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (6)].string));
        }
    break;

  case 183:
#line 2794 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(loc));
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (2)].string));
        }
    break;

  case 184:
#line 2800 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (4)].string), new QoreMemberInfo(loc, nullptr, nullptr, (yyvsp[(3) - (4)].node)));
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (4)].string));
        }
    break;

  case 185:
#line 2806 "parser.ypp"
    {
           (yyval.memberinfo) = (yyvsp[(1) - (1)].classvarinfo);
        }
    break;

  case 186:
#line 2809 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           if ((yyvsp[(1) - (1)].constnode)->pub)
              parse_error(loc, "cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[(1) - (1)].constnode)->name.ostr);
           (yyval.memberinfo) = new MemberInfo(loc, (yyvsp[(1) - (1)].constnode)->name.takeName(), (yyvsp[(1) - (1)].constnode)->value);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 187:
#line 2819 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (1)].string), new QoreMemberInfo(loc));
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 188:
#line 2825 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(loc, nullptr, new QoreParseTypeInfo((yyvsp[(2) - (2)].string))));
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (2)].string));
        }
    break;

  case 189:
#line 2834 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 190:
#line 2837 "parser.ypp"
    {
           (yyvsp[(1) - (3)].memberlist)->add((yyvsp[(3) - (3)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (3)].memberlist);
        }
    break;

  case 191:
#line 2844 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 192:
#line 2847 "parser.ypp"
    {
           (yyvsp[(1) - (2)].memberlist)->add((yyvsp[(2) - (2)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (2)].memberlist);
        }
    break;

  case 193:
#line 2854 "parser.ypp"
    {
           (yyval.string) = (yyvsp[(1) - (2)].string);
        }
    break;

  case 194:
#line 2857 "parser.ypp"
    {
           (yyval.string) = strdup("keys");
        }
    break;

  case 195:
#line 2860 "parser.ypp"
    {
           (yyval.string) = (yyvsp[(1) - (1)].string);
        }
    break;

  case 196:
#line 2866 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(7) - (7)].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
           check_method(loc, (yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), new_method_variant(loc, (yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 197:
#line 2877 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(7) - (7)].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
           delete (yyvsp[(2) - (7)].parsertype);

           check_method(loc, (yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), new_method_variant(loc, (yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 198:
#line 2892 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
           if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           check_method(loc, (yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), new_method_variant(loc, (yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 199:
#line 2899 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
           if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
           delete (yyvsp[(2) - (7)].parsertype);

           check_method(loc, (yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), new_method_variant(loc, (yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 200:
#line 2913 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
           if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(8) - (8)].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }

           (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].node), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(8) - (8)].sblock));
        }
    break;

  case 201:
#line 2924 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
           if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(8) - (8)].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
           delete (yyvsp[(2) - (8)].parsertype);

           (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].bcalist), rt, (yyvsp[(8) - (8)].sblock));
        }
    break;

  case 202:
#line 2937 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (8)]).first_line, (yylsp[(7) - (8)]).last_line);
           if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].node), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), 0);
        }
    break;

  case 203:
#line 2943 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (8)]).first_line, (yylsp[(7) - (8)]).last_line);
           if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
           delete (yyvsp[(2) - (8)].parsertype);

           (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].bcalist), rt, 0);
        }
    break;

  case 204:
#line 2952 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[(1) - (7)].string), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 205:
#line 2956 "parser.ypp"
    {
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (7)].parsertype)));
           delete (yyvsp[(1) - (7)].parsertype);

           QoreProgramLocation loc((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[(2) - (7)].string), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 206:
#line 2966 "parser.ypp"
    {
           (yyval.bcalist) = (yyvsp[(2) - (2)].bcalist);
        }
    break;

  case 207:
#line 2969 "parser.ypp"
    { // nothing
           (yyval.bcalist) = 0;
        }
    break;

  case 208:
#line 2975 "parser.ypp"
    {
           (yyval.bcalist) = new BCAList((yyvsp[(1) - (1)].bcanode));
        }
    break;

  case 209:
#line 2978 "parser.ypp"
    {
           (yyvsp[(1) - (3)].bcalist)->push_back((yyvsp[(3) - (3)].bcanode));
           (yyval.bcalist) = (yyvsp[(1) - (3)].bcalist);
        }
    break;

  case 210:
#line 2985 "parser.ypp"
    {
           (yyval.bcanode) = new BCANode((yyvsp[(1) - (4)].string), make_args(QoreProgramLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(3) - (4)].node)), (yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
        }
    break;

  case 211:
#line 2988 "parser.ypp"
    {
           (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[(1) - (4)].string)), make_args(QoreProgramLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(3) - (4)].node)), (yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
        }
    break;

  case 212:
#line 2995 "parser.ypp"
    { (yyval.i4) = 0; }
    break;

  case 213:
#line 2996 "parser.ypp"
    {
           (yyval.i4) = (yyvsp[(1) - (1)].i4);
        }
    break;

  case 214:
#line 3001 "parser.ypp"
    { (yyval.i4) = (yyvsp[(1) - (1)].i4); }
    break;

  case 215:
#line 3002 "parser.ypp"
    {
           if (((yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4)) == (yyvsp[(1) - (2)].i4))
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "modifier given twice");
           (yyval.i4) = (yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4);
        }
    break;

  case 216:
#line 3010 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 217:
#line 3011 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 218:
#line 3012 "parser.ypp"
    { (yyval.i4) = OFM_INTERNAL; }
    break;

  case 219:
#line 3013 "parser.ypp"
    { (yyval.i4) = OFM_STATIC; }
    break;

  case 220:
#line 3014 "parser.ypp"
    { (yyval.i4) = OFM_SYNCED; }
    break;

  case 221:
#line 3015 "parser.ypp"
    { (yyval.i4) = OFM_DEPRECATED; }
    break;

  case 222:
#line 3016 "parser.ypp"
    { (yyval.i4) = OFM_PUBLIC; }
    break;

  case 223:
#line 3017 "parser.ypp"
    { (yyval.i4) = OFM_FINAL; }
    break;

  case 224:
#line 3018 "parser.ypp"
    { (yyval.i4) = OFM_ABSTRACT; }
    break;

  case 225:
#line 3022 "parser.ypp"
    {
           if (!(yyvsp[(2) - (2)].parsertype)) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "missing type declaration after 'returns'");
              (yyval.returnTypeInfo) = 0;
           }
           else {
              (yyval.returnTypeInfo) = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (2)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (2)].parsertype)));
              delete (yyvsp[(2) - (2)].parsertype);
           }
        }
    break;

  case 226:
#line 3033 "parser.ypp"
    {
           (yyval.returnTypeInfo) = 0;
        }
    break;

  case 227:
#line 3039 "parser.ypp"
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.parsefunc) = new ParseUserFunction(QoreProgramLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line), (yyvsp[(2) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].returnTypeInfo), false, flags));
        }
    break;

  case 228:
#line 3044 "parser.ypp"
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype)));
           delete (yyvsp[(1) - (6)].parsertype);

           (yyval.parsefunc) = new ParseUserFunction(QoreProgramLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line), (yyvsp[(3) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].node), rt, false, flags));
        }
    break;

  case 229:
#line 3053 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           check_funcmod(loc, (yyvsp[(1) - (7)].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
        }
    break;

  case 230:
#line 3065 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           check_funcmod(loc, (yyvsp[(1) - (7)].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
           delete (yyvsp[(2) - (7)].parsertype);

           (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(4) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
        }
    break;

  case 231:
#line 3083 "parser.ypp"
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.sparsefunc) = new ParseScopedUserFunction(QoreProgramLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line), (yyvsp[(2) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), false, flags));
        }
    break;

  case 232:
#line 3088 "parser.ypp"
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (7)].parsertype)));
           delete (yyvsp[(1) - (7)].parsertype);

           (yyval.sparsefunc) = new ParseScopedUserFunction(QoreProgramLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line), (yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, false, flags));
        }
    break;

  case 233:
#line 3097 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
           check_funcmod(loc, (yyvsp[(1) - (8)].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(3) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
        }
    break;

  case 234:
#line 3109 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
           check_funcmod(loc, (yyvsp[(1) - (8)].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
           delete (yyvsp[(2) - (8)].parsertype);

           (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(4) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(6) - (8)]).first_line, (yylsp[(6) - (8)]).last_line, (yyvsp[(6) - (8)].node), rt, (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
        }
    break;

  case 235:
#line 3127 "parser.ypp"
    {
           (yyval.parse_list) = splice_expressions((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node), QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line), QoreProgramLocation((yylsp[(3) - (3)]).first_line, (yylsp[(3) - (3)]).last_line));
        }
    break;

  case 236:
#line 3130 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
           QoreParseListNode* l;
           if ((yyvsp[(1) - (2)].node) && (yyvsp[(1) - (2)].node)->getType() == NT_PARSE_LIST) {
              l = reinterpret_cast<QoreParseListNode*>((yyvsp[(1) - (2)].node));
              if (l->isFinalized()) {
                 QoreParseListNode* nl = new QoreParseListNode(loc);
                 nl->add(l, loc);
                 l = nl;
              }
           }
           else {
              l = new QoreParseListNode(loc);
              l->add((yyvsp[(1) - (2)].node), loc);
           }
           (yyval.parse_list) = l;
        }
    break;

  case 237:
#line 3150 "parser.ypp"
    {
       (yyval.parse_list) = splice_expressions((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node), QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line), QoreProgramLocation((yylsp[(3) - (3)]).first_line, (yylsp[(3) - (3)]).last_line));
    }
    break;

  case 238:
#line 3153 "parser.ypp"
    {
       QoreParseListNode* l;
       if ((yyvsp[(1) - (2)].node) && (yyvsp[(1) - (2)].node)->getType() == NT_PARSE_LIST)
          l = reinterpret_cast<QoreParseListNode*>((yyvsp[(1) - (2)].node));
       else {
          QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
          l = new QoreParseListNode(loc);
          l->add((yyvsp[(1) - (2)].node), loc);
       }
       (yyval.parse_list) = l;
    }
    break;

  case 239:
#line 3167 "parser.ypp"
    {
           (yyval.hash) = new QoreParseHashNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line));
           (yyvsp[(1) - (1)].hashelement)->addDelete((yyval.hash));
        }
    break;

  case 240:
#line 3171 "parser.ypp"
    {
           (yyvsp[(3) - (3)].hashelement)->addDelete((yyvsp[(1) - (3)].hash));
           (yyvsp[(1) - (3)].hash)->updateLastLine((yylsp[(3) - (3)]).last_line);
           (yyval.hash) = (yyvsp[(1) - (3)].hash);
        }
    break;

  case 241:
#line 3177 "parser.ypp"
    { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[(1) - (2)].hash); }
    break;

  case 242:
#line 3182 "parser.ypp"
    { (yyval.hashelement) = new HashElement((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node), (yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line); }
    break;

  case 243:
#line 3186 "parser.ypp"
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[(2) - (3)].hash)->setCurly();
            (yyval.hash) = (yyvsp[(2) - (3)].hash);
        }
    break;

  case 244:
#line 3194 "parser.ypp"
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[(2) - (3)].hash)->setCurly();

            QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[(1) - (3)].string));
            free((yyvsp[(1) - (3)].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), (yyvsp[(2) - (3)].hash));
        }
    break;

  case 245:
#line 3203 "parser.ypp"
    {
            QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[(1) - (2)].string));
            free((yyvsp[(1) - (2)].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), new QoreParseHashNode(loc, true));
        }
    break;

  case 246:
#line 3213 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].node); }
    break;

  case 247:
#line 3215 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].binary); }
    break;

  case 248:
#line 3217 "parser.ypp"
    { (yyval.node) = (yyvsp[(2) - (3)].hash); }
    break;

  case 249:
#line 3219 "parser.ypp"
    { (yyval.node) = new ScopedRefNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string)); }
    break;

  case 250:
#line 3220 "parser.ypp"
    {
           if (!(yyvsp[(1) - (2)].parsertype) && !strcmp((yyvsp[(2) - (2)].string), "argv"))
              inc_argv_ref();

           QoreProgramLocation loc((yyvsp[(1) - (2)].parsertype) ? (yylsp[(1) - (2)]).first_line : (yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           if ((yyvsp[(1) - (2)].parsertype))
              (yyval.node) = new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype)));
           else
              (yyval.node) = new VarRefNode(loc, (yyvsp[(2) - (2)].string), get_var_type());

           delete (yyvsp[(1) - (2)].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 251:
#line 3234 "parser.ypp"
    {
           QoreProgramLocation loc((yyvsp[(1) - (2)].parsertype) ? (yylsp[(1) - (2)]).first_line : (yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           if ((yyvsp[(1) - (2)].parsertype))
              (yyval.node) = new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype)));
           else
              (yyval.node) = new VarRefNode(loc, (yyvsp[(2) - (2)].string), get_var_type());

           delete (yyvsp[(1) - (2)].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 252:
#line 3245 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           (yyval.node) = new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype)));
           delete (yyvsp[(1) - (2)].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 253:
#line 3252 "parser.ypp"
    {
           VarRefDeclNode* v = new VarRefDeclNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(3) - (3)].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (3)].parsertype)));
           v->setExplicitScope();
           (yyval.node) = v;
           delete (yyvsp[(2) - (3)].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(3) - (3)].string));
        }
    break;

  case 254:
#line 3260 "parser.ypp"
    {
           // see if types are required
           if (parse_check_parse_option(PO_REQUIRE_TYPES))
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(2) - (2)].string));
           VarRefNode* v = new VarRefNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].string), VT_LOCAL);
           v->setExplicitScope();
           (yyval.node) = v;
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 255:
#line 3270 "parser.ypp"
    {
           VarRefNode* v;
           if ((yyvsp[(2) - (3)].parsertype)) {
              v = new VarRefDeclNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(3) - (3)].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (3)].parsertype)));
              delete (yyvsp[(2) - (3)].parsertype);
           }
           else {
              // see if types are required
              if (parse_check_parse_option(PO_REQUIRE_TYPES))
                 parse_error(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(3) - (3)].string));
              v = new VarRefNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(3) - (3)].string), VT_LOCAL);
           }
           v->setExplicitScope();
           (yyval.node) = v;
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(3) - (3)].string));
        }
    break;

  case 256:
#line 3287 "parser.ypp"
    {
           (yyvsp[(3) - (4)].parse_list)->setVariableList();
           QoreParseListNode::nvec_t& vl = (yyvsp[(3) - (4)].parse_list)->getValues();
           for (unsigned i = 0; i < vl.size(); ++i) {
              AbstractQoreNode*& n = vl[i];
              qore_type_t t = get_node_type(n);
              QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
              if (t == NT_BAREWORD) {
                 BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
                 if (parse_check_parse_option(PO_REQUIRE_TYPES))
                    parse_error(loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
                 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(loc, "local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
                 VarRefNode* v = new VarRefNode(loc, b->takeString(), VT_LOCAL);
                 v->setExplicitScope();
                 b->deref();
                 n = v;
              }
              else if (t == NT_VARREF) {
                 VarRefNode* v = reinterpret_cast<VarRefNode*>(n);
                 // see if types are required
                 if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
                    parse_error(loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
                 if (v->explicitScope()) {
                    if (v->getType() == VT_LOCAL)
                       parse_error(loc, "illegal use of 'my %s' in local variable declaration list", v->getName());
                    else if (v->getType() == VT_GLOBAL)
                       parse_error(loc, "illegal use of 'our %s' in local variable declaration list", v->getName());
                 }
                 else
                    v->makeLocal();
                 v->setExplicitScope();
              }
              else
                 parse_error(loc, "element %d in list following 'my' is not a variable reference (%s)", i, get_type_name(n));
           }
           (yyval.node) = (yyvsp[(3) - (4)].parse_list);
        }
    break;

  case 257:
#line 3325 "parser.ypp"
    {
           (yyval.node) = (yyvsp[(1) - (1)].gv)->makeVar();
        }
    break;

  case 258:
#line 3329 "parser.ypp"
    {
           if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[(1) - (1)].string), "argv"))
              inc_argv_ref();

           (yyval.node) = new BarewordNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string));
        }
    break;

  case 259:
#line 3336 "parser.ypp"
    { (yyval.node) = new ContextrefNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string)); }
    break;

  case 260:
#line 3338 "parser.ypp"
    { (yyval.node) = new ContextRowNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line)); }
    break;

  case 261:
#line 3340 "parser.ypp"
    { (yyval.node) = new ComplexContextrefNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string)); }
    break;

  case 262:
#line 3342 "parser.ypp"
    { (yyval.node) = new FindNode(QoreProgramLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line), (yyvsp[(2) - (8)].node), (yyvsp[(4) - (8)].node), (yyvsp[(7) - (8)].node)); }
    break;

  case 263:
#line 3344 "parser.ypp"
    { (yyval.node) = new QoreExistsOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node)); }
    break;

  case 264:
#line 3346 "parser.ypp"
    { (yyval.node) = new QoreElementsOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node)); }
    break;

  case 265:
#line 3347 "parser.ypp"
    {
           (yyval.node) = new QoreKeysOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 266:
#line 3350 "parser.ypp"
    {  // unshift list, element
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(loc, "invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].node)->getTypeName());
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), nullptr);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QoreUnshiftOperatorNode(loc, lv, l->shift());
              (yyvsp[(2) - (2)].node)->deref(nullptr);
           }
        }
    break;

  case 267:
#line 3363 "parser.ypp"
    {
           (yyval.node) = new QoreShiftOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 268:
#line 3366 "parser.ypp"
    {  // push lvalue-list, element
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(loc, "invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].node)->getTypeName());
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), nullptr);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QorePushOperatorNode(loc, lv, l->shift());
              (yyvsp[(2) - (2)].node)->deref(0);
           }
        }
    break;

  case 269:
#line 3379 "parser.ypp"
    {
           (yyval.node) = new QorePopOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 270:
#line 3382 "parser.ypp"
    {
           (yyval.node) = new QoreChompOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 271:
#line 3385 "parser.ypp"
    {
           (yyval.node) = new QoreTrimOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 272:
#line 3388 "parser.ypp"
    {  // splice lvalue-list, offset, [length, list]
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           if (!l) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[(2) - (2)].node)));
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else if (l->size() < 2) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else if (l->size() > 4) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QoreSpliceOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), lv, l->shift(), l->shift(), l->shift());
              discard(l, 0);
           }
        }
    break;

  case 273:
#line 3408 "parser.ypp"
    {  // extract lvalue-list, offset, [length, list]
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           if (!l) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[(2) - (2)].node)));
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else if (l->size() < 2) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else if (l->size() > 4) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QoreExtractOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), lv, l->shift(), l->shift(), l->shift());
              discard(l, 0);
           }
        }
    break;

  case 274:
#line 3428 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           int len = l ? (int)l->size() : 0;
           if (!l || len < 2 || len > 3) {
              parse_error(loc, "invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else {
              // get first expression from list
              AbstractQoreNode* exp = l->shift();
              qore_type_t t = get_node_type(exp);
              (yyval.node) = 0;
              if (t == NT_PARSE_HASH) {
                 QoreParseHashNode* phn = reinterpret_cast<QoreParseHashNode*>(exp);
                 if (phn->isCurly())
                    (yyval.node) = parse_hash_map(loc, phn, l);
              }

              if (!(yyval.node))
                 (yyval.node) = parse_map(loc, exp, l);
           }
        }
    break;

  case 275:
#line 3452 "parser.ypp"
    {
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else {
              AbstractQoreNode* code_exp = l->shift();
              AbstractQoreNode* arg = l->shift();
              (yyval.node) = new QoreFoldrOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), code_exp, arg);
              (yyvsp[(2) - (2)].node)->deref(0);
           }
        }
    break;

  case 276:
#line 3466 "parser.ypp"
    {
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else {
              AbstractQoreNode* code_exp = l->shift();
              AbstractQoreNode* arg = l->shift();
              (yyval.node) = new QoreFoldlOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), code_exp, arg);
              (yyvsp[(2) - (2)].node)->deref(0);
           }
        }
    break;

  case 277:
#line 3480 "parser.ypp"
    {
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (2)].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
              (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else {
              AbstractQoreNode* arg = l->shift();
              AbstractQoreNode* select_exp = l->shift();
              (yyval.node) = new QoreSelectOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), arg, select_exp);
              (yyvsp[(2) - (2)].node)->deref(0);
           }
        }
    break;

  case 278:
#line 3494 "parser.ypp"
    {  // pre-increment
           (yyval.node) = new QorePreIncrementOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 279:
#line 3497 "parser.ypp"
    {  // pre-decrement
           (yyval.node) = new QorePreDecrementOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 280:
#line 3500 "parser.ypp"
    {
           printd(5, "parsing in-object base class method call %s()\n", (yyvsp[(1) - (4)].nscope)->ostr);
           if (!strcmp((yyvsp[(1) - (4)].nscope)->getIdentifier(), "copy"))
              parse_error(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), "illegal call to base class copy method '%s'", (yyvsp[(1) - (4)].nscope)->ostr);

           (yyval.node) = new SelfFunctionCallNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].nscope), make_args(QoreProgramLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(3) - (4)].node)));
        }
    break;

  case 281:
#line 3507 "parser.ypp"
    {
           printd(5, "parsing call %s()\n", (yyvsp[(1) - (3)].string));
           (yyval.node) = new FunctionCallNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].string), make_args(QoreProgramLocation((yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line), (yyvsp[(2) - (3)].node)));
        }
    break;

  case 282:
#line 3512 "parser.ypp"
    {
           (yyval.node) = new SelfVarrefNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string));
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 283:
#line 3517 "parser.ypp"
    {
           // FIXME: need to expand constant expression checking to determine
           //        if the expression can throw an exception at run-time
           // first check for constant expressions
           (yyval.node) = new QoreUnaryMinusOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 284:
#line 3524 "parser.ypp"
    {
           (yyval.node) = new QoreUnaryPlusOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 285:
#line 3527 "parser.ypp"
    {
           (yyval.node) = new QoreBinaryNotOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 286:
#line 3530 "parser.ypp"
    {
           (yyval.node) = new QoreLogicalNotOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 287:
#line 3533 "parser.ypp"
    {
           qore_type_t t = (yyvsp[(2) - (2)].node) ? (yyvsp[(2) - (2)].node)->getType() : 0;
           //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2->getTypeName());

           if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
              (yyval.node) = reinterpret_cast<FunctionCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
           }
           else if (t == NT_SELF_CALL) {
              (yyval.node) = reinterpret_cast<SelfFunctionCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
           }
           else if (t == NT_STATIC_METHOD_CALL) {
              (yyval.node) = reinterpret_cast<StaticMethodCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
           }
           else {
              bool make_ref = true;

              if (t == NT_OPERATOR) {
                 QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[(2) - (2)].node));
                 if (deon) {
                    (yyval.node) = deon->makeCallReference();
                    make_ref = false;
                 }
              }

              if (make_ref) {
                 //printd(5, "type=%s\n", $2->getTypeName());
                 (yyval.node) = new ParseReferenceNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
              }
           }
        }
    break;

  case 288:
#line 3563 "parser.ypp"
    {
           (yyval.node) = new ScopedObjectCallNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), new NamedScope((yyvsp[(2) - (5)].string)), make_args(QoreProgramLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(4) - (5)].node)));
           if (parse_check_parse_option(PO_NO_NEW))
              parse_error(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 289:
#line 3568 "parser.ypp"
    {
           (yyval.node) = new ScopedObjectCallNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), new NamedScope((yyvsp[(2) - (5)].string)), make_args(QoreProgramLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(4) - (5)].node)));
           if (parse_check_parse_option(PO_NO_NEW))
              parse_error(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 290:
#line 3573 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
           (yyval.node) = new ParseNewComplexTypeNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(2) - (5)].string), false), make_args(QoreProgramLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(4) - (5)].node)));
           if (parse_check_parse_option(PO_NO_NEW))
              parse_error(loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 291:
#line 3579 "parser.ypp"
    {
           (yyval.node) = new QoreBackgroundOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
           // check to see if the expression is legal
           if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
              parse_error(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "illegal use of 'background' operator (conflicts with parse option PO_NO_THREAD_CONTROL)");
           else if (!node_has_effect((yyvsp[(2) - (2)].node)))
              parse_error(QoreProgramLocation((yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), "argument to background operator (%s) has no effect", get_type_name((yyvsp[(2) - (2)].node)));
        }
    break;

  case 292:
#line 3587 "parser.ypp"
    {
           (yyval.node) = new BackquoteNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), (yyvsp[(1) - (1)].string));
           if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
              parse_error(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line), "illegal use of backquote operator (conflicts with parse option PO_NO_EXTERNAL_PROCESS)");
        }
    break;

  case 293:
#line 3592 "parser.ypp"
    {
           (yyval.node) = (yyvsp[(2) - (3)].node);
           if ((yyvsp[(2) - (3)].node)) {
              switch ((yyvsp[(2) - (3)].node)->getType()) {
                 case NT_PARSE_LIST:
                    reinterpret_cast<QoreParseListNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
                 case NT_FUNCTION_CALL:
                    reinterpret_cast<FunctionCallNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
                 case NT_BAREWORD:
                    reinterpret_cast<BarewordNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
                 case NT_OPERATOR:
                    dynamic_cast<QoreOperatorNode*>((yyvsp[(2) - (3)].node))->setInParentheses();
                    break;
              }
           }
        }
    break;

  case 294:
#line 3611 "parser.ypp"
    {
           QoreParseListNode* l = new QoreParseListNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line));
           l->setFinalized();
           (yyval.node) = l;
        }
    break;

  case 295:
#line 3616 "parser.ypp"
    {
           int ar = get_pop_argv_ref();
           (yyval.node) = new QoreClosureParseNode(QoreProgramLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line), new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].returnTypeInfo), false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
        }
    break;

  case 296:
#line 3620 "parser.ypp"
    {
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype)));
           delete (yyvsp[(1) - (6)].parsertype);

           int ar = get_pop_argv_ref();
           (yyval.node) = new QoreClosureParseNode(QoreProgramLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line), new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].node), rt, false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
        }
    break;

  case 297:
#line 3627 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           check_funcmod(loc, (yyvsp[(1) - (7)].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;
           (yyval.node) = new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags));
        }
    break;

  case 298:
#line 3636 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
           check_funcmod(loc, (yyvsp[(1) - (7)].i4));

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
           delete (yyvsp[(2) - (7)].parsertype);

           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;
           (yyval.node) = new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags));
        }
    break;

  case 299:
#line 3649 "parser.ypp"
    {
           (yyval.node) = (yyvsp[(1) - (1)].implicit_arg);
           inc_numeric_argv_ref();
        }
    break;

  case 300:
#line 3653 "parser.ypp"
    {
           (yyval.node) = new QoreImplicitElementNode(QoreProgramLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line));
        }
    break;

  case 301:
#line 3656 "parser.ypp"
    {
           (yyval.node) = new QoreDeleteOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 302:
#line 3659 "parser.ypp"
    {
           (yyval.node) = new QoreRemoveOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(2) - (2)].node));
        }
    break;

  case 303:
#line 3662 "parser.ypp"
    {
           QoreProgramLocation loc((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
           (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(1) - (4)].string), false), (yyvsp[(3) - (4)].node));
        }
    break;

  case 305:
#line 3670 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].parse_list); }
    break;

  case 306:
#line 3671 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].hash); }
    break;

  case 307:
#line 3672 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].node); }
    break;

  case 308:
#line 3673 "parser.ypp"
    { (yyval.node) = new QoreParseHashNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), true); }
    break;

  case 309:
#line 3674 "parser.ypp"
    { (yyval.node) = new QorePlusEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 310:
#line 3675 "parser.ypp"
    { (yyval.node) = new QoreMinusEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 311:
#line 3676 "parser.ypp"
    { (yyval.node) = new QoreAndEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 312:
#line 3677 "parser.ypp"
    { (yyval.node) = new QoreOrEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 313:
#line 3678 "parser.ypp"
    { (yyval.node) = new QoreModuloEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 314:
#line 3679 "parser.ypp"
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 315:
#line 3680 "parser.ypp"
    { (yyval.node) = new QoreDivideEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 316:
#line 3681 "parser.ypp"
    { (yyval.node) = new QoreXorEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 317:
#line 3682 "parser.ypp"
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 318:
#line 3683 "parser.ypp"
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 319:
#line 3684 "parser.ypp"
    { (yyval.node) = process_assignment((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 320:
#line 3685 "parser.ypp"
    {
                                           QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);

                                           // see if the use of the weak assignment operator is allowed
                                           if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
                                              parse_error(loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

                                           (yyval.node) = process_weak_assignment(loc, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
                                        }
    break;

  case 321:
#line 3694 "parser.ypp"
    {
        QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        (yyval.node) = (yyvsp[(3) - (3)].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].parsertype)->getParseTypeInfo());
        delete (yyvsp[(3) - (3)].parsertype);
    }
    break;

  case 322:
#line 3701 "parser.ypp"
    { (yyval.node) = new QoreNullCoalescingOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 323:
#line 3702 "parser.ypp"
    { (yyval.node) = new QoreValueCoalescingOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 324:
#line 3703 "parser.ypp"
    { (yyval.node) = new QoreQuestionMarkOperatorNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].node)); }
    break;

  case 325:
#line 3704 "parser.ypp"
    { (yyval.node) = new QorePostIncrementOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].node)); }
    break;

  case 326:
#line 3705 "parser.ypp"
    { (yyval.node) = new QorePostDecrementOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].node)); }
    break;

  case 327:
#line 3706 "parser.ypp"
    { (yyval.node) = processCall((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line, (yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node), QoreProgramLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line)); }
    break;

  case 328:
#line 3707 "parser.ypp"
    { check_operator_log_or((yyvsp[(1) - (3)].node), "logical AND"); (yyval.node) = new QoreLogicalAndOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 329:
#line 3708 "parser.ypp"
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 330:
#line 3709 "parser.ypp"
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 331:
#line 3710 "parser.ypp"
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 332:
#line 3711 "parser.ypp"
    { check_operator_bin_or((yyvsp[(1) - (3)].node), "binary XOR"); (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 333:
#line 3712 "parser.ypp"
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 334:
#line 3713 "parser.ypp"
    { check_operator_bin_or((yyvsp[(1) - (3)].node), "binary AND"); check_operator_bin_xor((yyvsp[(1) - (3)].node), "binary AND"); (yyval.node) = new QoreBinaryAndOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 335:
#line 3714 "parser.ypp"
    { (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 336:
#line 3715 "parser.ypp"
    { (yyval.node) = new QoreRegexMatchOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Regex)); }
    break;

  case 337:
#line 3716 "parser.ypp"
    { (yyval.node) = new QoreRegexNMatchOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Regex)); }
    break;

  case 338:
#line 3717 "parser.ypp"
    { (yyval.node) = new QoreRegexSubstOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].RegexSubst)); }
    break;

  case 339:
#line 3718 "parser.ypp"
    { (yyval.node) = new QoreTransliterationOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Trans)); }
    break;

  case 340:
#line 3719 "parser.ypp"
    { (yyval.node) = new QoreRegexExtractOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Regex)); }
    break;

  case 341:
#line 3720 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 342:
#line 3721 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 343:
#line 3722 "parser.ypp"
    { (yyval.node) = new QoreLogicalComparisonOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 344:
#line 3723 "parser.ypp"
    { (yyval.node) = new QoreLogicalEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 345:
#line 3724 "parser.ypp"
    { (yyval.node) = new QoreLogicalAbsoluteEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 346:
#line 3725 "parser.ypp"
    { (yyval.node) = new QoreLogicalAbsoluteNotEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 347:
#line 3726 "parser.ypp"
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 348:
#line 3727 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 349:
#line 3728 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 350:
#line 3729 "parser.ypp"
    { (yyval.node) = new QoreShiftLeftOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 351:
#line 3730 "parser.ypp"
    { (yyval.node) = new QoreShiftRightOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 352:
#line 3731 "parser.ypp"
    { (yyval.node) = new QorePlusOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 353:
#line 3732 "parser.ypp"
    { (yyval.node) = new QoreMinusOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 354:
#line 3733 "parser.ypp"
    { (yyval.node) = new QoreModuloOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 355:
#line 3734 "parser.ypp"
    { (yyval.node) = new QoreDivisionOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 356:
#line 3735 "parser.ypp"
    { (yyval.node) = new QoreMultiplicationOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 357:
#line 3736 "parser.ypp"
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), nullptr); }
    break;

  case 358:
#line 3737 "parser.ypp"
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].node), nullptr, (yyvsp[(4) - (5)].node)); }
    break;

  case 359:
#line 3738 "parser.ypp"
    {
                                           parse_error(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
                                           (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].node), nullptr, nullptr);
                                        }
    break;

  case 360:
#line 3742 "parser.ypp"
    {
        (yyval.node) = nullptr;
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[(3) - (4)].node) && (yyvsp[(3) - (4)].node)->getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[(3) - (4)].node));
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].node), ron->swapLeft(nullptr), ron->swapRight(nullptr));
           }
        }
        if (!(yyval.node))
           (yyval.node) = new QoreSquareBracketsOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node));
    }
    break;

  case 361:
#line 3755 "parser.ypp"
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node)); }
    break;

  case 362:
#line 3756 "parser.ypp"
    { (yyval.node) = new QoreRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 363:
#line 3757 "parser.ypp"
    { (yyval.node) = process_dot((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 364:
#line 3758 "parser.ypp"
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].node), (yyvsp[(2) - (2)].String)); }
    break;

  case 366:
#line 3763 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].parse_list); }
    break;

  case 367:
#line 3764 "parser.ypp"
    { (yyval.node) = new QorePlusEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 368:
#line 3765 "parser.ypp"
    { (yyval.node) = new QoreMinusEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 369:
#line 3766 "parser.ypp"
    { (yyval.node) = new QoreAndEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 370:
#line 3767 "parser.ypp"
    { (yyval.node) = new QoreOrEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 371:
#line 3768 "parser.ypp"
    { (yyval.node) = new QoreModuloEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 372:
#line 3769 "parser.ypp"
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 373:
#line 3770 "parser.ypp"
    { (yyval.node) = new QoreDivideEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 374:
#line 3771 "parser.ypp"
    { (yyval.node) = new QoreXorEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 375:
#line 3772 "parser.ypp"
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 376:
#line 3773 "parser.ypp"
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 377:
#line 3774 "parser.ypp"
    { (yyval.node) = process_assignment((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 378:
#line 3775 "parser.ypp"
    {
                                             QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);

                                             // see if the use of the weak assignment operator is allowed
                                             if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
                                                parse_error(loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

                                             (yyval.node) = process_weak_assignment(loc, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
                                          }
    break;

  case 379:
#line 3784 "parser.ypp"
    {
        QoreProgramLocation loc((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        (yyval.node) = (yyvsp[(3) - (3)].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].parsertype)->getParseTypeInfo());
        delete (yyvsp[(3) - (3)].parsertype);
    }
    break;

  case 380:
#line 3791 "parser.ypp"
    { (yyval.node) = new QoreNullCoalescingOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 381:
#line 3792 "parser.ypp"
    { (yyval.node) = new QoreValueCoalescingOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 382:
#line 3793 "parser.ypp"
    { (yyval.node) = new QoreQuestionMarkOperatorNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].node)); }
    break;

  case 383:
#line 3794 "parser.ypp"
    { (yyval.node) = new QorePostIncrementOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].node)); }
    break;

  case 384:
#line 3795 "parser.ypp"
    { (yyval.node) = new QorePostDecrementOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].node)); }
    break;

  case 385:
#line 3796 "parser.ypp"
    { (yyval.node) = processCall((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line, (yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node), QoreProgramLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line)); }
    break;

  case 386:
#line 3797 "parser.ypp"
    { check_operator_log_or((yyvsp[(1) - (3)].node), "logical AND"); (yyval.node) = new QoreLogicalAndOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 387:
#line 3798 "parser.ypp"
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 388:
#line 3799 "parser.ypp"
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 389:
#line 3800 "parser.ypp"
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 390:
#line 3801 "parser.ypp"
    { check_operator_bin_or((yyvsp[(1) - (3)].node), "binary XOR"); (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 391:
#line 3802 "parser.ypp"
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 392:
#line 3803 "parser.ypp"
    { check_operator_bin_or((yyvsp[(1) - (3)].node), "binary AND"); check_operator_bin_xor((yyvsp[(1) - (3)].node), "binary AND"); (yyval.node) = new QoreBinaryAndOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 393:
#line 3804 "parser.ypp"
    { (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 394:
#line 3805 "parser.ypp"
    { (yyval.node) = new QoreRegexMatchOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Regex)); }
    break;

  case 395:
#line 3806 "parser.ypp"
    { (yyval.node) = new QoreRegexNMatchOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Regex)); }
    break;

  case 396:
#line 3807 "parser.ypp"
    { (yyval.node) = new QoreRegexSubstOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].RegexSubst)); }
    break;

  case 397:
#line 3808 "parser.ypp"
    { (yyval.node) = new QoreTransliterationOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Trans)); }
    break;

  case 398:
#line 3809 "parser.ypp"
    { (yyval.node) = new QoreRegexExtractOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].Regex)); }
    break;

  case 399:
#line 3810 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 400:
#line 3811 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 401:
#line 3812 "parser.ypp"
    { (yyval.node) = new QoreLogicalComparisonOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 402:
#line 3813 "parser.ypp"
    { (yyval.node) = new QoreLogicalEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 403:
#line 3814 "parser.ypp"
    { (yyval.node) = new QoreLogicalAbsoluteEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 404:
#line 3815 "parser.ypp"
    { (yyval.node) = new QoreLogicalAbsoluteNotEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 405:
#line 3816 "parser.ypp"
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 406:
#line 3817 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 407:
#line 3818 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 408:
#line 3819 "parser.ypp"
    { (yyval.node) = new QoreShiftLeftOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 409:
#line 3820 "parser.ypp"
    { (yyval.node) = new QoreShiftRightOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 410:
#line 3821 "parser.ypp"
    { (yyval.node) = new QorePlusOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 411:
#line 3822 "parser.ypp"
    { (yyval.node) = new QoreMinusOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 412:
#line 3823 "parser.ypp"
    { (yyval.node) = new QoreModuloOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 413:
#line 3824 "parser.ypp"
    { (yyval.node) = new QoreDivisionOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 414:
#line 3825 "parser.ypp"
    { (yyval.node) = new QoreMultiplicationOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 415:
#line 3826 "parser.ypp"
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), nullptr); }
    break;

  case 416:
#line 3827 "parser.ypp"
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].node), nullptr, (yyvsp[(4) - (5)].node)); }
    break;

  case 417:
#line 3828 "parser.ypp"
    {
                                             parse_error(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
                                             (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].node), nullptr, nullptr);
                                          }
    break;

  case 418:
#line 3832 "parser.ypp"
    {
        (yyval.node) = nullptr;
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[(3) - (4)].node) && (yyvsp[(3) - (4)].node)->getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[(3) - (4)].node));
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].node), ron->swapLeft(nullptr), ron->swapRight(nullptr));
           }
        }
        if (!(yyval.node))
           (yyval.node) = new QoreSquareBracketsOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node));
    }
    break;

  case 419:
#line 3845 "parser.ypp"
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node)); }
    break;

  case 420:
#line 3846 "parser.ypp"
    { (yyval.node) = new QoreRangeOperatorNode(QoreProgramLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 421:
#line 3847 "parser.ypp"
    { (yyval.node) = process_dot((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 422:
#line 3848 "parser.ypp"
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].node), (yyvsp[(2) - (2)].String)); }
    break;

  case 423:
#line 3852 "parser.ypp"
    {
           (yyval.String) = (yyvsp[(1) - (1)].String);
        }
    break;

  case 424:
#line 3855 "parser.ypp"
    {
           (yyval.String) = (yyvsp[(1) - (2)].String);
           (yyval.String)->concat((yyvsp[(2) - (2)].String));
           (yyvsp[(2) - (2)].String)->deref();
        }
    break;

  case 425:
#line 3863 "parser.ypp"
    { (yyval.node) = new QoreFloatNode((yyvsp[(1) - (1)].decimal)); }
    break;

  case 426:
#line 3864 "parser.ypp"
    { (yyval.node) = new QoreBigIntNode((yyvsp[(1) - (1)].integer)); }
    break;

  case 427:
#line 3865 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].String); }
    break;

  case 428:
#line 3866 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].datetime); }
    break;

  case 429:
#line 3867 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].num); }
    break;


/* Line 1267 of yacc.c.  */
#line 10456 "parser.cpp"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (&yylloc, yyscanner, yymsg);
	  }
	else
	  {
	    yyerror (&yylloc, yyscanner, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc, yyscanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, &yylloc, yyscanner);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 3870 "parser.ypp"


