/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "../lib/parser.ypp" /* yacc.c:339  */
 /* -*- mode: c++; indent-tabs-mode: nil -*-

  parser.ypp

  Qore Programming Language

  Copyright (C) 2003 - 2018 Qore Technologies, s.r.o.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.

  Note that the Qore library is released under a choice of three open-source
  licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
  information.
*/

#include "qore/Qore.h"
#include "qore/intern/BreakStatement.h"
#include "qore/intern/ContinueStatement.h"
#include "qore/intern/ReturnStatement.h"
#include "qore/intern/RethrowStatement.h"
#include "qore/intern/ThreadExitStatement.h"
#include "qore/intern/ExpressionStatement.h"
#include "qore/intern/DoWhileStatement.h"
#include "qore/intern/SummarizeStatement.h"
#include "qore/intern/ContextStatement.h"
#include "qore/intern/IfStatement.h"
#include "qore/intern/WhileStatement.h"
#include "qore/intern/ForStatement.h"
#include "qore/intern/ForEachStatement.h"
#include "qore/intern/TryStatement.h"
#include "qore/intern/ThrowStatement.h"
#include "qore/intern/StatementBlock.h"
#include "qore/intern/ParserSupport.h"
#include "qore/intern/SwitchStatement.h"
#include "qore/intern/CaseNodeWithOperator.h"
#include "qore/intern/CaseNodeRegex.h"
#include "qore/intern/OnBlockExitStatement.h"
#include "qore/intern/ConstantList.h"
#include "qore/intern/GlobalVariableList.h"
#include "qore/intern/QoreNamespaceIntern.h"
#include "qore/intern/QoreParseHashNode.h"
#include "qore/intern/QoreParseListNode.h"
#include "qore/intern/ModuleInfo.h"

#include "parser.hpp"

#include "qore/intern/QoreClassIntern.h"
#include "qore/intern/qore_program_private.h"
#include "qore/intern/typed_hash_decl_private.h"
#include "qore/intern/qore_list_private.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <memory>
#include <utility>
#include <vector>
#include <sstream>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                      \
   do                                                        \
      if (N) {                                               \
         (Current).first_line = YYRHSLOC(Rhs, 1).first_line; \
         (Current).first_col  = YYRHSLOC(Rhs, 1).first_col;  \
         (Current).last_line  = YYRHSLOC(Rhs, N).last_line;  \
         (Current).last_col   = YYRHSLOC(Rhs, N).last_col;   \
      }                                                      \
      else {                                                 \
         (Current).first_line = (Current).last_line =        \
            YYRHSLOC(Rhs, 0).last_line;                      \
         (Current).first_col = (Current).last_col =          \
            YYRHSLOC(Rhs, 0).last_col;                       \
      }                                                      \
   while (0)

class HashElement {
public:
   AbstractQoreNode* key;
   AbstractQoreNode* value;
   QoreProgramLocation loc;

   DLLLOCAL HashElement(AbstractQoreNode* k, AbstractQoreNode* v, int sl, int el) : key(k), value(v), loc(sl, el) {
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL ~HashElement() {
      discard(key, nullptr);
      discard(value, nullptr);
   }

   DLLLOCAL void addDelete(QoreParseHashNode* h) {
      h->add(key, value, loc);
      key = value = nullptr;
      delete this;
   }
};

static AbstractQoreNode* makeErrorTree(AbstractQoreNode* left, AbstractQoreNode* right) {
   discard(left, nullptr);
   discard(right, nullptr);
   return &False;
}

// for constant definitions
class ConstNode {
public:
   QoreProgramLocation loc;
   NamedScope name;
   AbstractQoreNode* value;
   bool pub;

   DLLLOCAL ConstNode(const QoreProgramLocation& loc, char* n, AbstractQoreNode* v, bool p = false) : loc(loc), name(n), value(v), pub(p) {
      // see if constant definitions are allowed
      if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
         parse_error(loc, "illegal constant definition \"%s\" (conflicts with parse option PO_NO_CONSTANT_DEFS)", n);
   }
   DLLLOCAL AbstractQoreNode* takeValue() {
      AbstractQoreNode* rv = value;
      value = nullptr;
      return rv;
   }
   DLLLOCAL const std::string& getName() const {
      return name.getIdentifierStr();
   }
   DLLLOCAL bool isPublic() const {
      return pub;
   }
};

class ObjClassDef {
public:
   QoreProgramLocation loc;
   NamedScope* name;
   QoreClass* oc;

   DLLLOCAL ObjClassDef(const QoreProgramLocation& loc, NamedScope *n, QoreClass* o) : loc(loc), name(n), oc(o) {
      checkName();
   }

   DLLLOCAL ObjClassDef(const QoreProgramLocation& loc, char* n, QoreClass* o) : loc(loc), name(new NamedScope(n)), oc(o) {
      checkName();
   }

   DLLLOCAL ~ObjClassDef() {
      delete name;
   }

   DLLLOCAL void checkName() {
      if (!strcmp(name->getIdentifier(), "auto"))
         parse_error(loc, "a class may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your class");
   }
};

class HashDeclDef {
public:
   QoreProgramLocation loc;
   NamedScope* name;
   TypedHashDecl* hashdecl;

   DLLLOCAL HashDeclDef(const QoreProgramLocation& loc, NamedScope *n, typed_hash_decl_private* hp) :
        loc(loc), name(n), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
      checkName();
   }

   DLLLOCAL HashDeclDef(const QoreProgramLocation& loc, char* n, typed_hash_decl_private* hp) :
        loc(loc), name(new NamedScope(n)), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
      checkName();
   }

   DLLLOCAL ~HashDeclDef() {
      delete name;
      if (hashdecl)
         typed_hash_decl_private::get(*hashdecl)->deref();
   }

   DLLLOCAL void checkName() {
      if (!strcmp(name->getIdentifier(), "auto"))
         parse_error(loc, "a hashdecl may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your hashdecl");
   }

   DLLLOCAL TypedHashDecl* takeHashDecl() {
      TypedHashDecl* rv = hashdecl;
      hashdecl = nullptr;
      return rv;
   }
};

class ParseUserFunctionBase {
public:
   QoreProgramLocation loc;
   UserFunctionVariant* variant;

   DLLLOCAL ParseUserFunctionBase(const QoreProgramLocation& loc, UserFunctionVariant* v) : loc(loc), variant(v) {
   }

   DLLLOCAL ~ParseUserFunctionBase() {
      if (variant)
         variant->deref();
   }

   DLLLOCAL void setPublic() {
      variant->setModulePublic();
   }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
   char* name;

   DLLLOCAL ParseUserFunction(const QoreProgramLocation& loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
   }

   DLLLOCAL ~ParseUserFunction() {
      if (name)
         free(name);
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
         const char* nsn = ns.name.c_str();
         parse_error(loc, "function '%s%s%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
      }

      delete this;
   }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
   NamedScope name;

   DLLLOCAL ParseScopedUserFunction(const QoreProgramLocation& loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
         parse_error(loc, "function '%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", name.ostr);

      delete this;
   }
};

struct GVarDecl {
   QoreProgramLocation loc;
   bool pub;

   DLLLOCAL GVarDecl(const QoreProgramLocation& loc, bool p) : loc(loc), pub(p) {
   }

   DLLLOCAL virtual ~GVarDecl() {
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

   DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
   char* name;
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL GVarSingleDecl(const QoreProgramLocation& loc, char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(loc, p), name(n), typeInfo(ti), parseTypeInfo(pti) {
      //printd(5, "GVarSingleDecl::GVarSingleDecl() '%s' %d-%d\n", n, loc.start_line, loc.end_line);
      if (bare) {
         if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error(loc, "global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
      }
      else {
         if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error(loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
      }
   }

   DLLLOCAL virtual ~GVarSingleDecl() {
      if (name)
         free(name);

      delete parseTypeInfo;
   }

   DLLLOCAL char* takeName() {
      char* rv = name;
      name = 0;
      return rv;
   }

   DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = nullptr;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ns.parseAddGlobalVarDecl(loc, takeName(), typeInfo, takeParseTypeInfo(), pub);
      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      GlobalVarRefNode* gv = typeInfo
         ? new GlobalVarRefNode(loc, takeName(), typeInfo)
         : new GlobalVarRefNode(loc, takeName(), takeParseTypeInfo());
      if (pub)
         gv->setPublic();

      delete this;
      return gv;
   }
};

struct GVarListDecl : public GVarDecl {
   QoreParseListNode* l;

   DLLLOCAL GVarListDecl(const QoreProgramLocation& loc, QoreParseListNode* list, bool p) : GVarDecl(loc, p), l(list) {
      bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

      QoreParseListNode::nvec_t& vl = l->getValues();
      for (unsigned i = 0; i < vl.size(); ++i) {
         AbstractQoreNode* n = vl[i];
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            if (!bareok)
               parse_error(loc, "global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (vrn->explicitScope()) {
               if (vrn->getType() == VT_LOCAL)
                  parse_error(loc, "illegal use of 'my %s' in global variable declaration list", vrn->getName());
               else if (vrn->getType() == VT_GLOBAL)
                  parse_error(loc, "illegal use of 'our %s' in global variable declaration list", vrn->getName());
            }
         }
         else
            parse_error(loc, "element %d in list following 'our' is not a variable reference (%s)", i, get_type_name(n));
      }
   }

   DLLLOCAL virtual ~GVarListDecl() {
      if (l)
         l->deref(0);
   }

   DLLLOCAL QoreParseListNode* takeList() {
      QoreParseListNode* rv = l;
      l = nullptr;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      QoreParseListNode::nvec_t& vl = l->getValues();
      for (unsigned i = 0; i < vl.size(); ++i) {
         AbstractQoreNode* n = vl[i];
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            ns.parseAddGlobalVarDecl(loc, b->takeString(), 0, 0, pub);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
               if (vrdn)
                  ns.parseAddGlobalVarDecl(loc, vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
               else
                  ns.parseAddGlobalVarDecl(loc, vrn->takeName(), 0, 0, pub);
            }
         }
      }

      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      l->setVariableList();
      QoreParseListNode::nvec_t& vl = l->getValues();
      for (unsigned i = 0; i < vl.size(); ++i) {
         AbstractQoreNode*& n = vl[i];
         qore_type_t t = get_node_type(n);
         VarRefNode* vrn = nullptr;
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            GlobalVarRefNode* v = new GlobalVarRefNode(loc, b->takeString());
            b->deref();
            n = vrn = v;
         }
         else if (t == NT_VARREF) {
            vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               vrn->makeGlobal();
               vrn->setExplicitScope();
            }
         }

         if (vrn && pub)
            vrn->setPublic();
      }

      QoreParseListNode* rv = takeList();
      delete this;
      return rv;
   }
};

static int check_method(const QoreProgramLocation& loc, const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error(loc, "%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error(loc, "base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PUBLIC     (1 << 0)
#define OFM_PRIVATE    (1 << 1)
#define OFM_INTERNAL   (1 << 2)
#define OFM_SYNCED     (1 << 3)
#define OFM_STATIC     (1 << 4)
#define OFM_DEPRECATED (1 << 5)
#define OFM_FINAL      (1 << 6)
#define OFM_ABSTRACT   (1 << 7)

static inline MethodVariantBase* new_method_variant(const QoreProgramLocation& loc, const char* name, int mod, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
   //printd(5, "new_method_variant() '%s' b: %p\n", name, b);

   int64 flags = QC_NO_FLAGS;

   if (get_pop_argv_ref())
      flags |= QC_USES_EXTRA_ARGS;

   ClassAccess access = Public;
   if (mod & OFM_PRIVATE) {
      if (mod & OFM_INTERNAL)
         parse_error(loc, "%s() methods cannot be both private:hierarchy and private:internal", name);
      if (mod & OFM_PUBLIC)
         parse_error(loc, "%s() methods cannot be both public and private", name);
      access = Private;
   }
   else if (mod & OFM_INTERNAL) {
      if (mod & OFM_PUBLIC)
         parse_error(loc, "%s() methods cannot be both public and private", name);
      access = Internal;
   }

   if (mod & OFM_DEPRECATED)
      flags |= QC_DEPRECATED;

   if (!strcmp(name, "constructor")) {
      if (mod & OFM_SYNCED)
         parse_error(loc, "%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error(loc, "%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error(loc, "return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      return new UserConstructorVariant(access, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
   }
   if (bcal) {
      parse_error(loc, "only constructors may have base class constructor arguments");
      delete bcal;
      bcal = 0;
   }
   if (!strcmp(name, "destructor")) {
      if (params) {
         parse_error(loc, "parameters cannot be defined for destructors");
         params->deref(nullptr);
      }
      if (mod & OFM_SYNCED)
         parse_error(loc, "%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error(loc, "%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error(loc, "return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      if (access > Public)
          parse_error(loc, "destructors cannot be private");
      return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
   }
   if (!strcmp(name, "copy")) {
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; declare the class final instead", name);
      return new UserCopyVariant(access, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
   }

   if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
      if (mod & OFM_FINAL)
         parse_error(loc, "%s() methods cannot be declared final; they are not inherited anyway", name);
      if (mod & OFM_ABSTRACT)
         parse_error(loc, "%s() methods cannot be declared abstract; they are not inherited anyway", name);
   }

   if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
      parse_error(loc, "method '%s()' is declared both final and abstract", name);

   return new UserMethodVariant(access, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
   QoreProgramLocation loc;
   MethodVariantBase* m;
   NamedScope name;
   bool static_flag;

   DLLLOCAL MethodDef(const QoreProgramLocation& loc, int mod, char* n, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : loc(loc), m(0), name(n), static_flag(mod & OFM_STATIC) {
      if (check_method(loc, name.getIdentifier(), bcal, returnTypeInfo)) {
         if (params)
            params->deref(0);
         delete bcal;
         delete b;
         delete returnTypeInfo;
         return;
      }

      m = new_method_variant(loc, name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
   }

   DLLLOCAL ~MethodDef() {
      delete m;
   }

   DLLLOCAL void parseAddToClassAndDel() {
      if (m) {
         // if there are any errors, the function below will delete memory
         // the following method takes ownership of "m" unconditionally
         qore_root_ns_private::parseAddMethodToClass(loc, name, m, static_flag);
         m = 0;
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      // the following method takes ownership of "m" unconditionally
      ns.parseAddMethodToClass(loc, name, m, static_flag);
      m = 0;
   }
};

static AbstractQoreNode* parse_hash_map(const QoreProgramLocation& loc, QoreParseHashNode* exp, QoreParseListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> exph(exp, 0);
   ReferenceHolder<> lh(l, 0);

   // check hash expression
   size_t len = exp->size();

   if (len == 0) {
       qore_program_private::makeParseWarning(getProgram(), loc, QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
            "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
       return new QoreHashNode;
   }

   if (len != 1) {
      parse_error(loc, "invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
      return &True;
   }

   if (l->size() == 1) {
      AbstractQoreNode* iter = l->shift();
      return new QoreHashMapOperatorNode(loc, exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter);
   }

   AbstractQoreNode* iter = l->shift();
   AbstractQoreNode* select = l->shift();
   return new QoreHashMapSelectOperatorNode(loc, exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter, select);
}

static AbstractQoreNode* parse_map(const QoreProgramLocation& loc, AbstractQoreNode* exp, QoreParseListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> lh(l, 0);

   if (l->size() == 1) {
      AbstractQoreNode* arg = l->shift();
      return new QoreMapOperatorNode(loc, exp, arg);
   }

   AbstractQoreNode* iterator_exp = l->shift();
   AbstractQoreNode* select_exp = l->shift();
   return new QoreMapSelectOperatorNode(loc, exp, iterator_exp, select_exp);
}

#define NSN_NONE     0
#define NSN_OCD      1
#define NSN_HASHDECL 2
#define NSN_CONST    3
#define NSN_NS       4
#define NSN_FUNC     5
#define NSN_SFUNC    6
#define NSN_VAR      7
#define NSN_METH     8

struct NSNode {
   int type;
   union {
      ObjClassDef* ocd;
      HashDeclDef* hashdecl;
      ConstNode* cn;
      QoreNamespace* ns;
      ParseUserFunction* func;
      ParseScopedUserFunction* sfunc;
      GVarDecl* gv;
      MethodDef* meth;
   } n;

   DLLLOCAL NSNode(ObjClassDef* o) { type = NSN_OCD; n.ocd = o; }
   DLLLOCAL NSNode(HashDeclDef* h) { type = NSN_HASHDECL; n.hashdecl = h; }
   DLLLOCAL NSNode(ConstNode* c) { type = NSN_CONST; n.cn = c; }
   DLLLOCAL NSNode(QoreNamespace* s) { type = NSN_NS; n.ns = s; }
   DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
      n.func = f;
   }
   DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
      n.sfunc = f;
   }

   DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
      n.gv = gv;
   }

   DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
      n.meth = m;
   }

   DLLLOCAL void deref() {
      switch (type) {
         case NSN_OCD:
            delete n.ocd;
            break;
         case NSN_HASHDECL:
            delete n.hashdecl;
            break;
         case NSN_CONST:
            delete n.cn;
            break;
         case NSN_NS:
            delete n.ns;
            break;
         case NSN_FUNC:
            delete n.func;
            break;
         case NSN_SFUNC:
            delete n.sfunc;
            break;
         case NSN_VAR:
            delete n.gv;
            break;
         case NSN_METH:
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      switch (type) {
         case NSN_OCD:
            //printd(5, "ocd: %s %d-%d c: %d-%d\n", n.ocd->oc->getName(), n.ocd->loc.start_line, n.ocd->loc.end_line, qore_class_private::get(*n.ocd->oc)->loc.start_line, qore_class_private::get(*n.ocd->oc)->loc.end_line);
            ns.parseAddPendingClass(n.ocd->loc, *(n.ocd->name), n.ocd->oc);
            delete n.ocd;
            break;
         case NSN_HASHDECL:
            ns.parseAddPendingHashDecl(n.hashdecl->loc, *(n.hashdecl->name), n.hashdecl->takeHashDecl());
            delete n.hashdecl;
            break;
         case NSN_CONST:
            ns.parseAddConstant(n.cn->loc, n.cn->name, n.cn->value, n.cn->pub);
            delete n.cn;
            break;
         case NSN_NS:
            ns.parseAddNamespace(n.ns);
            break;
         case NSN_FUNC:
            n.func->add(ns);
            break;
         case NSN_SFUNC:
            n.sfunc->add(ns);
            break;
         case NSN_VAR:
            n.gv->add(ns);
            break;
         case NSN_METH:
            n.meth->add(ns);
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
   DLLLOCAL void deref() {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->deref();

      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->add(ns);
   }
};

static QoreParseListNode* splice_expressions(AbstractQoreNode* a1, AbstractQoreNode* a2, const QoreProgramLocation& loc1, const QoreProgramLocation& loc2) {
   //tracein("splice_expressions()");
   if (a1 && a1->getType() == NT_PARSE_LIST) {
      QoreParseListNode* l = reinterpret_cast<QoreParseListNode*>(a1);
      if (!l->isFinalized()) {
         //printd(5, "LIST x\n");
         l->add(a2, loc2);
         return l;
      }
   }
   QoreParseListNode* l = new QoreParseListNode(QoreProgramLocation(loc1.start_line, loc2.end_line));
   l->add(a1, loc1);
   l->add(a2, loc2);
   return l;
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;
typedef std::pair<char*, HashDeclMemberInfo*> hashmem_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2
#define MI_HashMem 3

struct MemberInfo {
protected:
   DLLLOCAL MemberInfo(const QoreProgramLocation& loc) : loc(loc) {
   }

public:
   QoreProgramLocation loc;
   char* name;
   unsigned char type;
   union {
      QoreMemberInfo* memberInfo;
      QoreVarInfo* varInfo;
      HashDeclMemberInfo* hashMemberInfo;
      AbstractQoreNode* exp;
   } u;

   DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : loc(mi->loc), name(n), type(MI_Member) {
      u.memberInfo = mi;
      if (!(mi && mi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
         parse_error(mi->loc, "member '%s' declared without type information, but parse options require type information for all declarations", name);
   }

   DLLLOCAL MemberInfo(const QoreProgramLocation& loc, char* n, AbstractQoreNode* exp) : loc(loc), name(n), type(MI_Constant) {
      u.exp = exp;
   }

   DLLLOCAL MemberInfo(char* n, HashDeclMemberInfo* mi) : loc(mi->loc), name(n), type(MI_HashMem) {
      u.hashMemberInfo = mi;
   }

   DLLLOCAL ~MemberInfo() {
      if (name)
         free(name);
      switch (type) {
         case MI_Member:
            delete u.memberInfo;
            break;
         case MI_Var:
            delete u.varInfo;
            break;
         case MI_HashMem:
            delete u.hashMemberInfo;
            break;
         case MI_Constant:
            if (u.exp)
               u.exp->deref(0);
            break;
      }
   }

   DLLLOCAL member_pair_t getPair() {
      assert(type == MI_Member);
      member_pair_t m = std::make_pair(name, u.memberInfo);
      name = nullptr;
      u.memberInfo = nullptr;
      return m;
   }

   DLLLOCAL var_pair_t getVarPair() {
      assert(type == MI_Var);
      var_pair_t m = std::make_pair(name, u.varInfo);
      name = nullptr;
      u.varInfo = nullptr;
      return m;
   }

   DLLLOCAL hashmem_pair_t getHashMemPair() {
      assert(type == MI_HashMem);
      hashmem_pair_t m = std::make_pair(name, u.hashMemberInfo);
      name = nullptr;
      u.hashMemberInfo = nullptr;
      return m;
   }

   DLLLOCAL AbstractQoreNode* takeExp() {
      assert(type == MI_Constant);
      AbstractQoreNode* rv = u.exp;
      u.exp = nullptr;
      return rv;
   }
};

struct ClassVarInfo : public MemberInfo {
   DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) : MemberInfo(vi->loc) {
      name = n;
      type = MI_Var;
      u.varInfo = vi;
      if (!(vi && vi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
         parse_error(vi->loc, "class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
   }

   DLLLOCAL char* takeName() {
      char* n = name;
      name = nullptr;
      return n;
   }
};

class MemberList {
protected:
   // for new class members
   QoreMemberMap mmap;
   // for new class constants
   ConstantList cmap;
   // for new class static variables
   QoreVarMap vmap;

   DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
   }

public:
   DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
      if (!member)
         return;

      if (member->type == MI_Member)
         mmap.addNoCheck(member->getPair());
      else if (member->type == MI_Constant)
         cmap.parseAdd(member->loc, member->name, member->takeExp());
      else
         vmap.addNoCheck(member->getVarPair());

      delete member;
   }

   DLLLOCAL ~MemberList() {
   }

   // takes over ownership of name and typeInfo
   DLLLOCAL int add(MemberInfo* member) {
      if (!member)
         return -1;

      if (member->type == MI_Member) {
         if (mmap.inList(member->name)) {
            parse_error(member->loc, "duplicate member declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new member to list
         mmap.addNoCheck(member->getPair());
         delete member;
      }
      else if (member->type == MI_Constant) {
         if (cmap.inList(member->name)) {
            parse_error(member->loc, "duplicate constant declaration '%s'", member->name);
            delete member;
            return -1;
         }
         if (vmap.find(member->name)) {
            parse_error(member->loc, "constant declaration collides with static class variable declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new constant to list
         cmap.parseAdd(member->loc, member->name, member->takeExp());
         delete member;
      }
      else {
         assert(member->type == MI_Var);
         if (vmap.find(member->name)) {
            parse_error(member->loc, "duplicate static class variable declaration '%s'", member->name);
            delete member;
            return -1;
         }
         if (cmap.inList(member->name)) {
            parse_error(member->loc, "static class variable declaration collides with constant declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new member to list
         vmap.addNoCheck(member->getVarPair());
         delete member;
      }

      return 0;
   }

   DLLLOCAL void merge(QoreClass* qc, ClassAccess access) {
      mmap.moveAllTo(qc, access);
      vmap.moveAllTo(qc, access);

      // merge constants
      qore_class_private::get(*qc)->parseAssimilateConstants(cmap, access);
   }
};

class EmptyMemberList : public MemberList {
public:
   DLLLOCAL EmptyMemberList() {
   }
};

struct ParserTypeStruct {
protected:
   DLLLOCAL ParserTypeStruct() {
   }

public:
   const QoreTypeInfo* typeInfo = nullptr;
   QoreParseTypeInfo* parseTypeInfo = nullptr;

   DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : parseTypeInfo(n_parseTypeInfo) {
   }

   DLLLOCAL ParserTypeStruct(char* id, bool or_nothing) : typeInfo(or_nothing ? getBuiltinUserOrNothingTypeInfo(id) : getBuiltinUserTypeInfo(id)) {
      //printd(0, "ParserTypeStruct::ParserTypeStruct('%s', %d) t: %p %s\n", id, or_nothing, typeInfo, QoreTypeInfo::getName(typeInfo));
      if (typeInfo) {
         free(id);
         return;
      }

      parseTypeInfo = new QoreParseTypeInfo(id, or_nothing);
   }

   DLLLOCAL ~ParserTypeStruct() {
      delete parseTypeInfo;
   }

   DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
      return typeInfo;
   }

   // static version of method, checking for null pointer
   DLLLOCAL static const QoreTypeInfo* getTypeInfo(ParserTypeStruct* pts) {
      return pts ? pts->getTypeInfo() : nullptr;
   }

   DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = nullptr;
      return rv;
   }

   // static version of method, checking for null pointer
   DLLLOCAL static QoreParseTypeInfo* getParseTypeInfo(ParserTypeStruct* pts) {
      return pts ? pts->getParseTypeInfo() : nullptr;
   }

   DLLLOCAL const char* getClassName() {
      assert(parseTypeInfo);
      return parseTypeInfo->cscope->ostr;
   }

   DLLLOCAL static ParserTypeStruct* getType(QoreProgramLocation&& loc, char* id, bool or_nothing) {
      return new ParserTypeStruct(getParseType(loc, id, or_nothing));
   }

   DLLLOCAL static void getSubTypes(const QoreProgramLocation& loc, const char* str, parse_type_vec_t& subtypes, bool raise_error = true) {
      QoreString buf;
      bool or_nothing = false;
      bool comma = false;

      const char* p = str;
      while (true) {
         if (*p == '\0') {
            if (buf.empty()) {
               if (comma && raise_error)
                  parse_error(loc, "empty subtype specification in type");
            }
            else
               subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
            break;
         }
         switch (*p) {
            case '<': {
               if (buf.empty()) {
                  if (raise_error)
                     parse_error(loc, "invalid subtype specification in '%s'", str);
                  return;
               }
               const char* e = strrchr(str, '>');
               if (!e || e < p) {
                  if (raise_error)
                     parse_error(loc, "unbalanced angle brackets in subtype specification in '%s'", str);
                  return;
               }
               buf.concat(p, e - p + 1);
               //printd(5, "ST: '%s' (str: '%s') p: %p '%s'\n", buf.c_str(), str, p, p);
               subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
               buf.reset();
               or_nothing = false;
               //printd(5, "ST: p: %p -> %p\n", p, e);
               p = e;
               break;
            }
            case ',':
               buf.trim();
               if (buf.empty()) {
                  if (raise_error)
                     parse_error(loc, "invalid subtype specification in '%s'", str);
                  return;
               }
               subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing, raise_error));
               buf.reset();
               or_nothing = false;
               comma = true;
               break;
            case '*': {
               if (buf.empty())
                  or_nothing = true;
               else
                  buf.concat('*');
               if (comma)
                  comma = false;
               break;
            }
            case ' ':
            case '\t':
               if (!buf.empty())
                  buf.concat(*p);
               break;
            default:
               buf.concat(*p);
               if (comma)
                  comma = false;
               break;
         }
         ++p;
      }
   }

   DLLLOCAL static QoreParseTypeInfo* getParseType(const QoreProgramLocation& loc, char* id, bool or_nothing, bool raise_error = true) {
      //printd(0, "gPT() '%s'\n", id);
      char* p0 = strchr(id, '<');
      if (p0) {
         char* p1 = strrchr(id, '>');
         if (p1 > (p0 + 1)) {
            // terminate main type string
            *p0 = '\0';
            // terminate type args
            *p1 = '\0';

            parse_type_vec_t subtypes;
            getSubTypes(loc, p0 + 1, subtypes, raise_error);
            return new QoreParseTypeInfo(id, or_nothing, std::move(subtypes));
         }
      }
      return new QoreParseTypeInfo(id, or_nothing);
   }

   DLLLOCAL static const QoreTypeInfo* getRuntimeType(const char* str) {
      assert(str);
      assert(str[0]);
      char* p;
      bool or_nothing;
      if (str[0] == '*') {
         or_nothing = true;
         p = strdup(str + 1);
      }
      else {
         or_nothing = false;
         p = strdup(str);
      }
      std::unique_ptr<QoreParseTypeInfo> pt(ParserTypeStruct::getParseType(QoreProgramLocation(), p, or_nothing, false));
      return QoreParseTypeInfo::resolveRuntime(pt.get());
   }
};

const QoreTypeInfo* qore_get_type_from_string(const char* str) {
    ExceptionSink xsink;
    ProgramRuntimeParseAccessHelper pah(&xsink, getProgram());
    if (xsink) {
        xsink.clear();
        return nullptr;
    }

    return ParserTypeStruct::getRuntimeType(str);
}

static AbstractQoreNode* process_dot(int sline, int eline, AbstractQoreNode* l, AbstractQoreNode* r) {
   qore_type_t rtype = r->getType();
   switch (rtype) {
      case NT_BAREWORD: {
         BarewordNode* b = reinterpret_cast<BarewordNode*>(r);
         if (!b->isFinalized()) {
            AbstractQoreNode* rv = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation(sline, eline), l, b->makeQoreStringNode());
            b->deref();
            return rv;
         }
         break;
      }

      case NT_FUNCTION_CALL: {
         FunctionCallNode* f = reinterpret_cast<FunctionCallNode*>(r);
         assert(!f->getFunction());
         if (!f->isFinalized()) {
            MethodCallNode* m = new MethodCallNode(QoreProgramLocation(sline, eline), f->takeName(), f->takeParseArgs());
            f->deref();

            return new QoreDotEvalOperatorNode(QoreProgramLocation(sline, eline), l, m);
         }
         break;
      }
   }

   return new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation(sline, eline), l, r);
}

static int check_strong_encapsulation(const QoreProgramLocation& loc, const char* type, const char* name) {
   if (parse_check_parse_option(PO_STRONG_ENCAPSULATION)) {
      parse_error(loc, "illegal out of line %s definition \"%s\" (conflicts with parse option PO_STRONG_ENCAPSULATION)", type, name);
      return -1;
   }
   return 0;
}

static int check_case(const QoreProgramLocation& loc, const char* op, AbstractQoreNode* exp) {
   // ignore if NULL (= NOTHING)
   if (node_has_effect(exp)) {
      if (op)
         parse_error(loc, "case expression with '%s' needs run-time evaluation", op);
      else
         parse_error(loc, "case expression needs run-time evaluation", op);
      return -1;
   }
   return 0;
}

static void check_funcmod(const QoreProgramLocation& loc, int mod) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in function declaration");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in function declaration");
   if (mod & OFM_FINAL)
      parse_error(loc, "illegal 'final' modifier in function declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in function declaration");
}

static void check_classmod(const QoreProgramLocation& loc, int mod, QoreClass& qc) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error(loc, "illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error(loc, "illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in class declaration");
}

static void check_hashdeclmod(const QoreProgramLocation& loc, int mod, typed_hash_decl_private& hashdecl) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in hashdecl");
   if (mod & OFM_SYNCED)
      parse_error(loc, "illegal 'synchronized' modifier in hashdecl");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in hashdecl");
   if (mod & OFM_PUBLIC)
      hashdecl.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(loc, "illegal 'deprecated' modifier in hashdecl");
   if (mod & OFM_FINAL)
      parse_error(loc, "illegal 'final' modifier in hashdecl");
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in hashdecl");
}

static void check_nsmod(const QoreProgramLocation& loc, int mod, qore_ns_private& ns) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(loc, "illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error(loc, "illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error(loc, "illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(loc, "illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error(loc, "illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(loc, "illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
   if (!n || n->is_value())
      return false;

   if (n->getType() == NT_OPERATOR)
      return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

   const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
   return pn ? pn->has_effect() : true;
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }

   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }

   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }

   DLLLOCAL const QoreProgramLocation& getLoc() const {
      return m->getUserVariantBase()->getUserSignature()->getParseLocation();
   }
};

static AbstractQoreNode* is_rewritable_op(AbstractQoreNode* n) {
   qore_type_t nt = get_node_type(n);
   if (nt == NT_OPERATOR) {
      QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n);
      if (op)
         return op->getRight();
   }

   return 0;
}

static AbstractQoreNode* check_rewrite_list(QoreParseListNode* l) {
   if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
      return l;

   // rewrite expression if it's a list without parentheses and
   // the first expression has one of the following operators:
   // =, +=, -=
   if (l->isFinalized())
      return l;

   AbstractQoreNode* e0 = l->get(0);

   AbstractQoreNode* r = is_rewritable_op(e0);
   if (r) {
      AbstractQoreNode* last = e0;
      AbstractQoreNode* top = e0;
      while (true) {
         AbstractQoreNode* nr = is_rewritable_op(r);
         if (!nr)
            break;
         last = r;
         r = nr;
      }
      assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last));
      // take first element from list (the tree) and make it the new expression
      QoreBinaryLValueOperatorNode* op = reinterpret_cast<QoreBinaryLValueOperatorNode*>(last);
      l->swap(0, op->swapRight(l));
      return top;
   }

   return l;
}

void ignore_return_value(AbstractQoreNode* n) {
   qore_type_t t = get_node_type(n);
   if (t == NT_OPERATOR)
      reinterpret_cast<QoreOperatorNode*>(n)->ignoreReturnValue();
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static QoreOperatorNode* process_assignment(int sline, int eline, AbstractQoreNode* $1, AbstractQoreNode* $3) {
   return ($1 && $1->getType() == NT_PARSE_LIST)
      ? static_cast<QoreOperatorNode*>(new QoreListAssignmentOperatorNode(QoreProgramLocation(sline, eline), $1, $3))
      : static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(QoreProgramLocation(sline, eline), $1, $3));
}

static QoreOperatorNode* process_weak_assignment(const QoreProgramLocation& loc, AbstractQoreNode* $1, AbstractQoreNode* $3) {
   if ($1 && $1->getType() == NT_LIST) {
       parse_error(loc, "the ':=' operator is not valid with list assignments");
       return static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
   }
   return static_cast<QoreOperatorNode*>(new QoreWeakAssignmentOperatorNode(loc, $1, $3));
}

static AbstractQoreNode* processCall(int sline, int eline, AbstractQoreNode* $1, AbstractQoreNode* $3, const QoreProgramLocation& argloc) {
    AbstractQoreNode* $$;
   //printd(5, "1=%s (%p), 3=%s (%p)\n", $1->getTypeName(), $1, $3 ? $3->getTypeName() : "n/a", $3);
   qore_type_t t = get_node_type($1);
   if (t == NT_BAREWORD) {
      BarewordNode* b = reinterpret_cast<BarewordNode*>($1);
      // take string from node and delete node
      char* str = b->takeString();
      b->deref();
      printd(5, "parsing call %s() args=%p %s\n", str, $3, $3 ? $3->getTypeName() : "n/a");
      QoreProgramLocation loc(sline, eline);
      $$ = new FunctionCallNode(loc, str, make_args(argloc, $3));
   }
   else if (t == NT_CONSTANT) {
      ScopedRefNode* c = reinterpret_cast<ScopedRefNode*>($1);
      // take NamedScope from node and delete node
      NamedScope *ns = c->takeName();
      c->deref();
      assert(ns->size() > 1);
      printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
      QoreProgramLocation loc(sline, eline);
      $$ = new StaticMethodCallNode(loc, ns, make_args(argloc, $3));
   }
   else if (t == NT_SELF_VARREF) {
      SelfVarrefNode* v = reinterpret_cast<SelfVarrefNode*>($1);
      // take string from node and delete node
      char* str = v->takeString();
      v->deref();
      //printd(5, "parsing in-object method call %s()\n", str);
      QoreProgramLocation loc(sline, eline);
      $$ = new SelfFunctionCallNode(loc, str, make_args(argloc, $3));
   }
   else {
      QoreHashObjectDereferenceOperatorNode* hodon;

      if (t == NT_OPERATOR) {
         hodon = dynamic_cast<QoreHashObjectDereferenceOperatorNode*>($1);
         if (hodon) {
            AbstractQoreNode* r = hodon->getRight();
            if (!r || r->getType() != NT_STRING)
               hodon = 0;
         }
      }
      else
         hodon = 0;

      if (hodon) {
         // create an object method call node
         // take the string
         QoreStringNode* str = reinterpret_cast<QoreStringNode*>(hodon->swapRight(0));
         assert(str->getEncoding() == QCS_DEFAULT);
         char* cstr = str->giveBuffer();
         assert(cstr);
         str->deref();

         QoreProgramLocation loc(sline, eline);
         MethodCallNode* mc = new MethodCallNode(loc, cstr, make_args(argloc, $3));

         // destroy the original operator and create a new operator object
         assert(hodon->is_unique());
         AbstractQoreNode* l = hodon->swapLeft(0);
         hodon->deref(0);

         $$ = new QoreDotEvalOperatorNode(QoreProgramLocation(sline, eline), l, mc);
      }
      else {
         $$ = 0;
         if ($1 && $1->getType() == NT_VARREF) {
            VarRefNode* r = reinterpret_cast<VarRefNode*>($1);
            qore_var_t vartype = r->getType();

            if (vartype != VT_UNRESOLVED) {
               $$ = r->makeNewCall($3);
               //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
               if (!$$)
                  parseException(QoreProgramLocation(sline, eline), "INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
            }
         }
         if (!$$) {
            QoreProgramLocation loc(sline, eline);
            $$ = new CallReferenceCallNode(loc, $1, make_args(argloc, $3));
            printd(5, "made new CallReferenceCallNode: %p exp=%p %s\n", $$, $1, get_type_name($1));
         }
      }
   }
   return $$;
}

static void check_operator(const QoreOperatorNode *n, const char *parent, const char *child) {
    if (parse_check_parse_option(PO_BROKEN_LOGIC_PRECEDENCE)) {
        if (!n->getInParentheses()) {
            qore_program_private::makeParseWarning(getProgram(), QP_WARN_BROKEN_LOGIC_PRECEDENCE, "BROKEN-LOGIC-PRECEDENCE", "%s gets under %s in the parse tree as an impact of broken-logic-precedence flag being set - please consider using parenthesis to enforce the desired operator precedence", child, parent);
        }
    }
}

static void check_operator_log_or(const AbstractQoreNode *n, const char *parent) {
    if (dynamic_cast< const QoreLogicalOrOperatorNode *>(n)) {
        check_operator(static_cast<const QoreOperatorNode*>(n), parent, "logical OR");
    }
}

static void check_operator_bin_or(const AbstractQoreNode *n, const char *parent) {
    if (dynamic_cast< const QoreBinaryOrOperatorNode *>(n)) {
        check_operator(static_cast<const QoreOperatorNode*>(n), parent, "binary OR");
    }
}

static void check_operator_bin_xor(const AbstractQoreNode *n, const char *parent) {
    if (dynamic_cast< const QoreBinaryXorOperatorNode *>(n)) {
        check_operator(static_cast<const QoreOperatorNode*>(n), parent, "binary XOR");
    }
}


#line 1550 "../lib/parser.cpp" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY__LIB_PARSER_HPP_INCLUDED
# define YY_YY__LIB_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOK_RETURN = 258,
    TOK_RETURNS = 259,
    TOK_MY = 260,
    TOK_DO = 261,
    TOK_TRY = 262,
    TOK_THROW = 263,
    TOK_CATCH = 264,
    TOK_WHERE = 265,
    TOK_WHILE = 266,
    TOK_IF = 267,
    TOK_FOR = 268,
    TOK_SUB = 269,
    TOK_THREAD_EXIT = 270,
    TOK_BREAK = 271,
    TOK_CONTINUE = 272,
    TOK_CONTEXT_ROW = 273,
    TOK_FIND = 274,
    TOK_FOREACH = 275,
    TOK_IN = 276,
    TOK_DELETE = 277,
    TOK_REMOVE = 278,
    TOK_PRIVATE = 279,
    TOK_PRIVATEINTERNAL = 280,
    TOK_PRIVATEHIERARCHY = 281,
    TOK_PUBLIC = 282,
    TOK_SYNCHRONIZED = 283,
    TOK_DEPRECATED = 284,
    TOK_CONTEXT = 285,
    TOK_SORT_BY = 286,
    TOK_SORT_DESCENDING_BY = 287,
    TOK_SUB_CONTEXT = 288,
    TOK_CONST = 289,
    TOK_SUMMARIZE = 290,
    TOK_BY = 291,
    TOK_OUR = 292,
    TOK_RETHROW = 293,
    TOK_SWITCH = 294,
    TOK_CASE = 295,
    TOK_DEFAULT = 296,
    TOK_INHERITS = 297,
    TOK_ELSE = 298,
    TOK_STATIC = 299,
    TOK_NAMESPACE = 300,
    TOK_MODULE = 301,
    TOK_FINAL = 302,
    TOK_ABSTRACT = 303,
    TOK_HASHDECL = 304,
    TOK_UNREFERENCE = 305,
    P_INCREMENT = 306,
    P_DECREMENT = 307,
    PLUS_EQUALS = 308,
    MINUS_EQUALS = 309,
    AND_EQUALS = 310,
    OR_EQUALS = 311,
    MODULA_EQUALS = 312,
    MULTIPLY_EQUALS = 313,
    DIVIDE_EQUALS = 314,
    XOR_EQUALS = 315,
    SHIFT_LEFT_EQUALS = 316,
    SHIFT_RIGHT_EQUALS = 317,
    TOK_UNSHIFT = 318,
    TOK_PUSH = 319,
    TOK_POP = 320,
    TOK_SHIFT = 321,
    TOK_CHOMP = 322,
    TOK_TRIM = 323,
    LOGICAL_AND = 324,
    LOGICAL_OR = 325,
    BROKEN_LOGICAL_OR = 326,
    BROKEN_BINARY_OR = 327,
    BROKEN_BINARY_XOR = 328,
    LOGICAL_EQ = 329,
    LOGICAL_NE = 330,
    LOGICAL_LE = 331,
    LOGICAL_GE = 332,
    LOGICAL_CMP = 333,
    ABSOLUTE_EQ = 334,
    ABSOLUTE_NE = 335,
    REGEX_MATCH = 336,
    REGEX_NMATCH = 337,
    TOK_EXISTS = 338,
    TOK_INSTANCEOF = 339,
    SHIFT_RIGHT = 340,
    SHIFT_LEFT = 341,
    TOK_ELEMENTS = 342,
    TOK_KEYS = 343,
    TOK_NEW = 344,
    TOK_BACKGROUND = 345,
    TOK_ON_EXIT = 346,
    TOK_ON_SUCCESS = 347,
    TOK_ON_ERROR = 348,
    TOK_MAP = 349,
    TOK_FOLDR = 350,
    TOK_FOLDL = 351,
    TOK_SELECT = 352,
    TOK_SPLICE = 353,
    TOK_EXTRACT = 354,
    IMPLICIT_ELEMENT = 355,
    NULL_COALESCING = 356,
    VALUE_COALESCING = 357,
    WEAK_ASSIGNMENT = 358,
    RANGE = 359,
    INTEGER = 360,
    QFLOAT = 361,
    NUMBER = 362,
    IDENTIFIER = 363,
    ANGLE_IDENTIFIER = 364,
    VAR_REF = 365,
    BACKQUOTE = 366,
    SELF_REF = 367,
    KW_IDENTIFIER_OPENPAREN = 368,
    SCOPED_REF = 369,
    SCOPED_VREF = 370,
    CONTEXT_REF = 371,
    COMPLEX_CONTEXT_REF = 372,
    QORE_CAST = 373,
    CLASS_STRING = 374,
    DATETIME = 375,
    QUOTED_WORD = 376,
    BINARY = 377,
    REGEX_SUBST = 378,
    REGEX_TRANS = 379,
    CLASS_SCOPED_REF = 380,
    BASE_CLASS_CALL = 381,
    REGEX = 382,
    REGEX_EXTRACT = 383,
    IMPLICIT_ARG_REF = 384,
    DOT_KW_IDENTIFIER = 385,
    TRY_MODULE_ERROR = 386,
    IFX = 387,
    NEG = 388,
    UPLUS = 389
  };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PRIVATEINTERNAL 280
#define TOK_PRIVATEHIERARCHY 281
#define TOK_PUBLIC 282
#define TOK_SYNCHRONIZED 283
#define TOK_DEPRECATED 284
#define TOK_CONTEXT 285
#define TOK_SORT_BY 286
#define TOK_SORT_DESCENDING_BY 287
#define TOK_SUB_CONTEXT 288
#define TOK_CONST 289
#define TOK_SUMMARIZE 290
#define TOK_BY 291
#define TOK_OUR 292
#define TOK_RETHROW 293
#define TOK_SWITCH 294
#define TOK_CASE 295
#define TOK_DEFAULT 296
#define TOK_INHERITS 297
#define TOK_ELSE 298
#define TOK_STATIC 299
#define TOK_NAMESPACE 300
#define TOK_MODULE 301
#define TOK_FINAL 302
#define TOK_ABSTRACT 303
#define TOK_HASHDECL 304
#define TOK_UNREFERENCE 305
#define P_INCREMENT 306
#define P_DECREMENT 307
#define PLUS_EQUALS 308
#define MINUS_EQUALS 309
#define AND_EQUALS 310
#define OR_EQUALS 311
#define MODULA_EQUALS 312
#define MULTIPLY_EQUALS 313
#define DIVIDE_EQUALS 314
#define XOR_EQUALS 315
#define SHIFT_LEFT_EQUALS 316
#define SHIFT_RIGHT_EQUALS 317
#define TOK_UNSHIFT 318
#define TOK_PUSH 319
#define TOK_POP 320
#define TOK_SHIFT 321
#define TOK_CHOMP 322
#define TOK_TRIM 323
#define LOGICAL_AND 324
#define LOGICAL_OR 325
#define BROKEN_LOGICAL_OR 326
#define BROKEN_BINARY_OR 327
#define BROKEN_BINARY_XOR 328
#define LOGICAL_EQ 329
#define LOGICAL_NE 330
#define LOGICAL_LE 331
#define LOGICAL_GE 332
#define LOGICAL_CMP 333
#define ABSOLUTE_EQ 334
#define ABSOLUTE_NE 335
#define REGEX_MATCH 336
#define REGEX_NMATCH 337
#define TOK_EXISTS 338
#define TOK_INSTANCEOF 339
#define SHIFT_RIGHT 340
#define SHIFT_LEFT 341
#define TOK_ELEMENTS 342
#define TOK_KEYS 343
#define TOK_NEW 344
#define TOK_BACKGROUND 345
#define TOK_ON_EXIT 346
#define TOK_ON_SUCCESS 347
#define TOK_ON_ERROR 348
#define TOK_MAP 349
#define TOK_FOLDR 350
#define TOK_FOLDL 351
#define TOK_SELECT 352
#define TOK_SPLICE 353
#define TOK_EXTRACT 354
#define IMPLICIT_ELEMENT 355
#define NULL_COALESCING 356
#define VALUE_COALESCING 357
#define WEAK_ASSIGNMENT 358
#define RANGE 359
#define INTEGER 360
#define QFLOAT 361
#define NUMBER 362
#define IDENTIFIER 363
#define ANGLE_IDENTIFIER 364
#define VAR_REF 365
#define BACKQUOTE 366
#define SELF_REF 367
#define KW_IDENTIFIER_OPENPAREN 368
#define SCOPED_REF 369
#define SCOPED_VREF 370
#define CONTEXT_REF 371
#define COMPLEX_CONTEXT_REF 372
#define QORE_CAST 373
#define CLASS_STRING 374
#define DATETIME 375
#define QUOTED_WORD 376
#define BINARY 377
#define REGEX_SUBST 378
#define REGEX_TRANS 379
#define CLASS_SCOPED_REF 380
#define BASE_CLASS_CALL 381
#define REGEX 382
#define REGEX_EXTRACT 383
#define IMPLICIT_ARG_REF 384
#define DOT_KW_IDENTIFIER 385
#define TRY_MODULE_ERROR 386
#define IFX 387
#define NEG 388
#define UPLUS 389

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 1491 "../lib/parser.ypp" /* yacc.c:355  */

   bool b;
   int i4;
   int64 integer;
   double decimal;
   QoreStringNode* String;
   char* string;
   BinaryNode* binary;
   AbstractQoreNode* node;
   QoreParseHashNode* hash;
   QoreParseListNode* parse_list;
   AbstractStatement* statement;
   struct MemberInfo* memberinfo;
   struct ClassVarInfo* classvarinfo;
   StatementBlock *sblock;
   ContextModList* cmods;
   ContextMod *cmod;
   class HashElement* hashelement;
   QoreFunction* userfunc;
   struct MethodNode* methodnode;
   class MemberList* memberlist;
   QoreClass* qoreclass;
   typed_hash_decl_private* hashdeclpriv;
   class ConstNode* constnode;
   QoreNamespace *ns;
   struct NSNodeList* nsnlist;
   struct NSNode* nsn;
   class ObjClassDef* classdef;
   class HashDeclDef* hashdecldef;
   DateTimeNode* datetime;
   QoreRegexSubst* RegexSubst;
   QoreTransliteration* Trans;
   SwitchStatement* switchstmt;
   CaseNode* casenode;
   BCList* sclist;
   class BCNode* sclnode;
   BCAList* bcalist;
   BCANode* bcanode;
   NamedScope *nscope;
   QoreRegex* Regex;
   QoreImplicitArgumentNode* implicit_arg;
   RetTypeInfo* returnTypeInfo;
   struct ParserTypeStruct* parsertype;
   class ParseUserFunction* parsefunc;
   class ParseScopedUserFunction* sparsefunc;
   struct GVarDecl* gv;
   QoreNumberNode* num;
   TryModuleError* trymod;
   struct MethodDef* methoddef;

#line 1909 "../lib/parser.cpp" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (yyscan_t yyscanner);

#endif /* !YY_YY__LIB_PARSER_HPP_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 1542 "../lib/parser.ypp" /* yacc.c:358  */


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE* loc, yyscan_t scanner, const char* str) {
   //printd(5, "yyerror() location: %d:%d - %d:%d \"%s\"\n", loc->first_line, loc->first_col, loc->last_line, loc->last_col, str);
   parse_error(QoreProgramLocation(loc->first_line, loc->last_line), "%s", str);
}


#line 1951 "../lib/parser.cpp" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  207
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   13106

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  160
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  65
/* YYNRULES -- Number of rules.  */
#define YYNRULES  426
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  924

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   389

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   151,     2,     2,     2,   144,   139,     2,
     155,   158,   145,   142,   133,   143,   154,   146,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   136,   157,
     140,   134,   141,   135,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   153,   150,   159,   138,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   152,   137,   156,   149,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   147,   148
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1794,  1794,  1795,  1799,  1802,  1807,  1815,  1819,  1825,
    1829,  1834,  1842,  1843,  1849,  1856,  1866,  1891,  1893,  1898,
    1912,  1913,  1919,  1927,  1933,  1939,  1942,  1950,  1955,  1961,
    1969,  1975,  1984,  1989,  1997,  2002,  2005,  2011,  2014,  2017,
    2022,  2025,  2031,  2037,  2040,  2046,  2049,  2055,  2058,  2063,
    2066,  2071,  2073,  2075,  2077,  2083,  2084,  2088,  2089,  2108,
    2115,  2117,  2120,  2123,  2126,  2129,  2132,  2135,  2138,  2141,
    2144,  2147,  2150,  2153,  2156,  2159,  2160,  2167,  2170,  2173,
    2174,  2179,  2180,  2191,  2193,  2195,  2200,  2202,  2206,  2216,
    2220,  2228,  2234,  2241,  2247,  2254,  2260,  2267,  2273,  2280,
    2286,  2293,  2298,  2304,  2309,  2315,  2320,  2326,  2332,  2339,
    2344,  2352,  2386,  2387,  2388,  2392,  2397,  2405,  2411,  2419,
    2428,  2439,  2448,  2462,  2465,  2471,  2474,  2481,  2484,  2487,
    2490,  2493,  2496,  2499,  2502,  2505,  2508,  2514,  2522,  2539,
    2544,  2549,  2571,  2576,  2582,  2588,  2594,  2601,  2606,  2612,
    2618,  2624,  2633,  2636,  2639,  2642,  2645,  2648,  2655,  2656,
    2662,  2663,  2664,  2668,  2669,  2670,  2671,  2672,  2673,  2677,
    2678,  2679,  2683,  2688,  2692,  2698,  2702,  2722,  2729,  2736,
    2757,  2764,  2771,  2792,  2798,  2804,  2807,  2817,  2823,  2832,
    2835,  2842,  2845,  2852,  2855,  2858,  2864,  2875,  2890,  2897,
    2911,  2922,  2935,  2941,  2950,  2954,  2964,  2967,  2973,  2976,
    2983,  2986,  2993,  2994,  2999,  3000,  3008,  3009,  3010,  3011,
    3012,  3013,  3014,  3015,  3016,  3020,  3031,  3037,  3042,  3051,
    3063,  3081,  3086,  3095,  3107,  3125,  3128,  3148,  3151,  3165,
    3169,  3174,  3179,  3184,  3192,  3194,  3196,  3198,  3200,  3214,
    3225,  3232,  3240,  3250,  3267,  3305,  3308,  3315,  3317,  3319,
    3321,  3323,  3325,  3327,  3330,  3343,  3346,  3359,  3362,  3365,
    3368,  3388,  3408,  3432,  3446,  3460,  3474,  3477,  3480,  3487,
    3491,  3497,  3503,  3507,  3510,  3513,  3543,  3548,  3553,  3559,
    3567,  3572,  3591,  3596,  3600,  3607,  3616,  3629,  3633,  3636,
    3639,  3642,  3649,  3650,  3651,  3652,  3653,  3654,  3655,  3656,
    3657,  3658,  3659,  3660,  3661,  3662,  3663,  3664,  3673,  3680,
    3681,  3682,  3683,  3684,  3685,  3686,  3687,  3688,  3689,  3690,
    3691,  3692,  3693,  3694,  3695,  3696,  3697,  3698,  3699,  3700,
    3701,  3702,  3703,  3704,  3705,  3706,  3707,  3708,  3709,  3710,
    3711,  3712,  3713,  3714,  3715,  3716,  3717,  3721,  3734,  3735,
    3736,  3737,  3741,  3742,  3743,  3744,  3745,  3746,  3747,  3748,
    3749,  3750,  3751,  3752,  3753,  3754,  3763,  3770,  3771,  3772,
    3773,  3774,  3775,  3776,  3777,  3778,  3779,  3780,  3781,  3782,
    3783,  3784,  3785,  3786,  3787,  3788,  3789,  3790,  3791,  3792,
    3793,  3794,  3795,  3796,  3797,  3798,  3799,  3800,  3801,  3802,
    3803,  3804,  3805,  3806,  3807,  3811,  3824,  3825,  3826,  3827,
    3831,  3834,  3842,  3843,  3844,  3845,  3846
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"private:internal\"",
  "\"private:hierarchy\"", "\"public\"", "\"synchronized\"",
  "\"deprecated\"", "\"context\"", "\"sortBy\"", "\"sortDescendingBy\"",
  "\"subcontext\"", "\"const\"", "\"summarize\"", "\"by\"", "\"our\"",
  "\"rethrow\"", "\"switch\"", "\"case\"", "\"default\"", "\"inherits\"",
  "\"else\"", "\"static\"", "\"namespace\"", "\"module\"", "\"final\"",
  "\"abstract\"", "\"hashdecl\"", "\"unreference\"", "\"++ operator\"",
  "\"-- operator\"", "\"+= operator\"", "\"-= operator\"",
  "\"&= operator\"", "\"|= operator\"", "\"%= operator\"",
  "\"*= operator\"", "\"/= operator\"", "\"^= operator\"",
  "\"<<= operator\"", "\">>= operator\"", "\"unshift\"", "\"push\"",
  "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"", "\"&& operator\"",
  "\"|| operator\"", "\"|| operator (compat)\"", "\"| operator (compat)\"",
  "\"^ operator (compat)\"", "\"== operator\"", "\"!= operator\"",
  "\"<= operator\"", "\">= operator\"", "\"<=> operator\"",
  "\"=== operator\"", "\"!== operator\"", "\"=~ operator\"",
  "\"!~ operator\"", "\"exists\"", "\"instanceof\"", "\">> operator\"",
  "\"<< operator\"", "\"elements\"", "\"keys\"", "\"new\"",
  "\"background\"", "\"on_exit\"", "\"on_success\"", "\"on_error\"",
  "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"", "\"splice\"",
  "\"extract\"", "\"$# operator\"", "\"?? operator\"", "\"?* operator\"",
  "\":= operator\"", "\".. operator\"", "\"integer value\"",
  "\"floating-point value\"", "\"arbitrary-precision number\"",
  "\"identifier\"", "\"complex type identifier\"",
  "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"simple class declaration\"",
  "\"date/time value\"", "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "hashdecl_def",
  "class_def", "inheritance_list", "superclass_list", "superclass",
  "hashdecl_attrs", "hashdecl_member", "class_attributes", "uncqtypedef",
  "qtypedef", "internal_member_list", "private_member_list",
  "public_member_list", "classvardecl", "member2", "member", "member_list",
  "member_list2", "ident_openparen", "inline_methoddef",
  "outofline_methoddef", "base_constructor_list", "base_constructors",
  "base_constructor", "nsc_modifiers", "method_modifiers",
  "method_modifier", "return_value", "sub_def", "scoped_sub_def", "list",
  "list_n", "hash", "hash_element", "alt_hash", "exp_c", "exp", "exp_n",
  "string", "scalar", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,    44,    61,    63,    58,   124,    94,    38,
      60,    62,    43,    45,    37,    42,    47,   388,   389,   126,
      92,    33,   123,    91,    46,    40,   125,    59,    41,    93
};
# endif

#define YYPACT_NINF -614

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-614)))

#define YYTABLE_NINF -213

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-213)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    1643,   -98,  6710,   332,  5717,  5717,  7547,   -83,   -70,   -25,
     102,   -39,   -23,    26,  -614,  7547,  7547,  7547,  7547,  -614,
    -614,  -614,    -8,  -614,  -614,    47,  -614,   111,    47,    38,
      95,  -614,   181,  -614,  -614,  7547,  7547,  7547,  7547,  7547,
    7547,  7547,  7547,  7547,  7547,  7547,   314,  7547,  5717,  5717,
    5717,  7547,  7547,  7547,  7547,  7547,  7547,  -614,  -614,  -614,
    -614,    43,  -614,  -614,  -614,  1423,    13,  -614,  -614,   193,
    -614,   228,  -614,   232,  -614,  -614,  7547,  7547,   566,  7547,
    7547,  7547,  5089,  6568,  -614,  1237,  -614,   374,  -614,  -614,
    -614,  -614,  -614,   255,  -614,  -614,  -614,  -614,    17,   267,
    -614,    42,   525,  -614,  -614,  -614,  -614,  -614,  9915,  -614,
    -614,  -614,   271,   412,    34,  6852,    18,   583,  -614,  -614,
    -614, 12463,   278,  -614,  7547,   357,   381,    33,  5246,  -614,
     489,  -614,   494, 10022,  7547,  7547,  5870,   363,   377,  -614,
     385,  1423,  1423,  -614,  -614,  -614,  7757,  7862,   355,   355,
     169,  -614,   386,  1796,   380,   383,   389,  -614,  7547,   413,
     589,   589, 12463, 12463,   355,   355,   355,   355,   979,   355,
     355,   392,   402,   405,   355,  -614,  -614,  -614, 12463, 12463,
   12463, 12463, 12463, 12463,  -614,   416, 12463,  1423,  7547,  -614,
    1423,   355,   355,  -614,  -614,  -614,   355,   355,   355,  -614,
    -614,  5403,  -614,  -614,   -75,  -614,  8403,  -614,  -614,   540,
    -614,   277,  -614,   428,  -614,  -614,   407,   238,   550,   550,
     295,  -614,  -614,   430,    52,  -614,  -614,  -614,  7547,  7547,
    7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,
    7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,
     697,   467,   104,  7547,  7547,  7547,  7547,  7547,  7547,  -614,
    7130,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,
    7547,  7547,  7547,  7547,  7269,  7547,  1423,  -614,  -614,     6,
   11518,   438,   441,   590,  -614,  -614,  7547,  7547,  7547,  7547,
    7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,
    7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,   705,   476,
     104,  7547,  7547,  7547,  7547,  7547,  7547,  -614,  7130,  7547,
    7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,  7547,
    7547,  7547,  7408,  7547,  1423,   463, 12463,  -614,  -614,  1423,
    -614,  5560,   459,   473,  -614,  8511,  8619,   472,  -614,  -614,
    1423,   477,   478,  7547,   483,   526,   534,  7547,   504,   516,
     531,  -614,  -614,  7547,  7547,  7547,  8727,   553,   -37,  -614,
    1423,  1423,  1423,  -614,   532,  8835,   536,  -614,  -614,  -614,
    7130,  -614,  7547,  -614,   568,   646,  7547,   325,   456,   547,
    1423,  1423,  1423,   390,  -614,   551,   557,    83,   466,   498,
     560,  1423,  1423,  1423,   317,   567, 12568, 12568, 12568, 12568,
   12568, 12568, 12568, 12568, 12568, 12568, 12831, 12747, 12831, 12914,
   12914,   979,   979,   979,   979,   979,   979,   979,  -614,  -614,
    -614,  -614,  -614,  -614,   791,   791, 12711, 12711, 12568, 12615,
   12568, 12568, 11623, 12867, 12951, 12914,   979,   979,   824,   824,
     290,   355,   355, 11306,  6012,  7967,  -614,   563,  -614,   570,
   12568, 12568, 12568, 12568, 12568, 12568, 12568, 12568, 12568, 12568,
   12831, 12747, 12831, 12914, 12914,   979,   979,   979,   979,   979,
     979,   979,  -614,  -614,  -614,  -614,  -614,  -614,   791,   791,
   12711, 12711, 12568, 12615, 12568, 12568, 11728, 12867, 12951, 12914,
     979,   979,   824,   824,   290,   355,   355, 11412,  6151,  8076,
    -614,   576,  -614,   581,  -614,  7547,  1423,  5717,  5717,  5870,
     582,   733,   733,  7652,  7547,  7547,  7547,  8943,  7547,  7547,
    7547, 10129, 10236,  9051,   593,  7547,  -614,  -614,   597,   599,
     600,   -19,  -614,  -614,  -614, 12568,   601,  -614,  -614,  -614,
    -614,  1423,   604,   606,   611,    91,   596,  -614,   620,  -614,
     434,  -614,  -614,  -614,  -614,  -614,    56,  -614,   618,  -614,
    -614,   104,   104,   339,   343,   359,   362,  -614,  -614,   645,
    -614,    68,  -614,   310,  -614,  1423,   621,   623,   626,   631,
    1423,  1423,  1423,  7547,  -614,  -614,  8185,  6290,  -614,  -614,
    7547,  -614,  -614,  8294,  6429,  -614,  -614,   632,  9159,   633,
    -614,   747,   635,   733,   104,   641,   641,   640,  9267, 10343,
   10450,  -614,  9375,  9483,  9591,  -614,  -614,   761,   240, 10557,
    -614,  -614,  -614,   397,  -614,   733,  -614,   642,   641,   641,
     665,  1423,  -614,  -614,  -614,   287,   366,    66,   411,  -614,
     690,   508,  -614,  -614,  -614,  -614,  -614,  -614,  -614,  -614,
      83,   -47,   -28,     2,    -6,   694,  -614,  -614,   345,  -614,
    -614,  -614,  -614,   492,   996,  -614,   468,   647,   733,   733,
     665,  1423,   650,   654,   655,   915,  -614,  -614,   915,  -614,
    -614,   657,  5717,  5717,  1423,   641,  -614,  -614,  -614,  -614,
    7547,  5717,  -614,  -614,  1796,  -614,  -614,  -614,   660,  6991,
     680,    15,  -614,  -614,   668,   671,   698,  -614,   641,   641,
    -614,  -614,   641,   677,   376,  -614,  -614,    -5,  -614,  -614,
     722,    55,  -614,   -69,   511,   -22,   543,     3,   729,   662,
      49,  -614,  -614,  -614,  -614,  -614,  -614,   377,    32,  1423,
    -614,   733,   641,   641,   733,   686,   641,   641,   665,  -614,
    -614,  -614,   687,  -614,  9699,  -614,  -614,  7547,  7547,  7547,
    7547,   711,   719,   712,  7547,  7547, 11833,  1949,  -614,  -614,
    1423,  1423,   397,  -614,  -614,  -614,   665,  7547,  1423,  -614,
    -614,   820,   454,    50,  -614,  -614,   748,   743,  -614,  -614,
     666,   745,  -614,  -614,   674,  -614,  -614,   760,  -614,  -614,
     783,  -614,  1423,   700,   641,  -614,  -614,   506,   641,  -614,
    -614,   527,  5717,  -614,  9807, 11938, 12043, 12148,   723,   724,
    2106, 12253, 12358,  2263,  2420,   703,   704,  -614, 10664,   706,
      60,   755,  7547,  -614,    41,   211,  -614,  -614,  -614,  -614,
    -614,  -614,   707,   665,  -614,  -614,  -614,  -614,  -614,  -614,
    -614,  -614,  2577,  2734,  2891,  3048,  3205,  3362,  3519,  3676,
    3833,  -614,  -614,  -614,   709,  7547,  -614,   242, 10771,  7547,
    1423,  -614,  7547,  1423,  -614,   665,   733,  1796,  3990,  4147,
    4304,  4461,  4618,  4775,  4932,  -614, 10878,  7547,  1423,  -614,
    -614, 10985,   713, 11092,   714,   572,   579,  -614,  -614, 11199,
     720,  -614,   710,  -614,   737,  -614,  -614,  -614,  -614,  -614,
     739,  -614,  -614,  -614
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,   158,   158,     0,     0,   158,     0,     0,     0,
       0,     0,     0,     0,   258,   158,   158,   158,   158,   216,
     218,   217,   222,   220,   221,    55,    81,     0,    55,     0,
       0,   219,     0,   223,   224,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,     0,   158,     0,     0,
       0,   158,   158,   158,   158,   158,   158,   298,   423,   422,
     426,   256,   154,   290,   280,     0,   247,   257,   259,     0,
     425,   420,   245,     0,   297,    16,   158,   158,     0,   158,
     158,   158,     0,   158,    57,     0,     2,     0,   255,    14,
       9,     8,    11,     0,    79,    60,     7,     6,   159,     0,
      10,     0,   213,   214,     4,     5,   363,   362,     0,   424,
     244,    80,     0,   222,   247,   158,   159,     0,   303,   304,
     302,    87,   252,   153,   158,   159,     0,   247,     0,    50,
       0,    49,     0,     0,   158,   158,     0,     0,     0,   195,
       0,     0,     0,    76,    77,    78,     0,     0,   299,   300,
       0,    56,     0,     0,     0,     0,     0,    61,   158,     0,
     276,   277,   264,   266,   267,   265,   268,   269,   261,   262,
     263,     0,     0,     0,   289,    63,    64,    65,   272,   273,
     274,   275,   270,   271,   114,     0,   113,     0,   158,   421,
       0,   282,   281,   155,   157,   156,   283,   285,   284,    12,
      52,     0,    51,   292,     0,   239,     0,     1,     3,   158,
      75,     0,   250,     0,   248,   249,     0,     0,   124,   124,
       0,   222,   152,   153,     0,   215,   380,   381,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
       0,     0,     0,   158,   158,   158,   158,   158,   158,   419,
     238,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,     0,    58,   305,     0,
       0,     0,     0,     0,   322,   323,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,     0,     0,
       0,   158,   158,   158,   158,   158,   158,   361,   236,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,     0,   303,     0,   251,   253,     0,
      48,     0,     0,     0,    62,     0,     0,     0,   194,   193,
       0,     0,     0,   158,     0,     0,     0,   158,     0,     0,
       0,    66,    82,   158,   158,   158,     0,     0,     0,    17,
       0,     0,     0,   279,     0,     0,     0,    13,    53,    54,
     241,   246,   158,   291,    25,    23,   158,   159,     0,     0,
       0,     0,     0,   212,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   383,   384,   385,   386,
     387,   399,   402,   403,   404,   398,   400,   401,   393,   394,
     391,   395,   392,   376,   406,   405,   377,   378,   375,   417,
     237,   374,     0,   388,   390,   389,   397,   396,   407,   408,
     409,   411,   410,     0,   158,     0,   418,     0,   243,     0,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     325,   326,   327,   328,   329,   341,   344,   345,   346,   340,
     342,   343,   335,   336,   333,   337,   334,   318,   348,   347,
     319,   320,   317,   359,   235,   316,     0,   330,   332,   331,
     339,   338,   349,   350,   351,   353,   352,     0,   158,     0,
     360,     0,   254,     0,    47,   158,     0,     0,     0,     0,
       0,   226,   226,     0,   158,   158,   158,     0,   158,   158,
     158,     0,     0,     0,     0,   158,    15,    18,     0,     0,
       0,   207,   301,   278,   240,   242,   303,    24,    22,    27,
      26,     0,     0,     0,     0,     0,   153,    31,     0,    41,
     212,    32,    35,    34,    37,    36,     0,    42,   213,    38,
      39,     0,     0,     0,     0,     0,     0,   127,   128,   123,
     125,   212,   119,   212,   120,     0,     0,     0,     0,     0,
       0,     0,     0,   158,   416,   414,     0,   158,   415,   382,
     158,   358,   356,     0,   158,   357,   324,     0,     0,     0,
      71,    69,     0,   226,   158,     0,     0,     0,     0,     0,
       0,    81,     0,     0,     0,    43,    45,     0,     0,     0,
     286,   288,   287,     0,    59,   226,    28,     0,     0,     0,
     207,     0,    40,    29,    33,     0,     0,     0,     0,   137,
       0,     0,   131,   132,   135,   136,   133,   134,   129,   130,
       0,   216,   218,   217,   222,     0,   121,   146,   212,   143,
     144,   145,   142,     0,   213,   122,   212,     0,   226,   226,
     207,     0,     0,     0,     0,   379,   413,   412,   321,   355,
     354,     0,     0,     0,     0,     0,   159,   225,   293,   227,
     158,     0,    44,    46,     0,    83,    84,    85,     0,   158,
       0,     0,    89,    19,     0,     0,   206,   208,     0,     0,
     294,   228,     0,     0,     0,   115,   138,     0,   116,   126,
     187,   158,   189,     0,   158,     0,   158,     0,     0,   158,
       0,   117,   151,   148,   149,   150,   147,   152,     0,     0,
     118,   226,     0,     0,   226,     0,     0,     0,   207,    72,
     111,    70,     0,   231,     0,    74,    68,   158,   158,   158,
     158,     0,     0,     0,   158,   158,     0,     0,    88,    90,
       0,     0,     0,   204,   232,   205,   207,   158,     0,   139,
     188,     0,     0,   152,   165,   186,   159,     0,   185,   191,
     158,     0,   163,   162,   158,   160,   168,   158,   166,   171,
     158,   169,     0,     0,     0,   295,   229,     0,     0,   296,
     230,     0,     0,   260,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     152,     0,   158,   183,     0,     0,   164,   192,   190,   161,
     167,   170,     0,   207,   233,   202,   200,   234,   203,   201,
      73,    81,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,   211,   140,     0,   158,   173,     0,     0,   158,
       0,   180,   158,     0,   177,   207,   226,     0,     0,     0,
       0,     0,     0,     0,     0,   141,     0,   158,     0,   172,
     184,     0,     0,     0,     0,     0,     0,    67,   175,     0,
       0,   181,     0,   178,     0,   199,   197,   198,   196,   174,
       0,   182,   179,   176
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -614,  -614,   785,  -614,   522,  -614,  -387,  -386,  -614,   319,
       1,  -384,   285,    12,  -116,   870,   274,  -613,  -614,  -614,
    -614,  -614,   191,  -614,   822,  -383,  -382,   684,  -614,   244,
     342,  -575,   334,   279,    -1,  -467,  -361,  -336,  -614,  -457,
     114,  -441,  -158,  -190,  -247,  -373,  -577,  -614,   136,  -483,
       5,   -99,  -476,  -371,  -368,   -80,  -614,   804,   542,  -614,
      19,    -2,  -614,   849,  -614
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    85,    86,   368,   369,    87,    88,    89,   560,   561,
     795,    91,   129,   130,   201,   152,   131,   153,   362,    93,
      94,   711,   712,    95,   185,    96,    97,   398,   579,   580,
     648,   649,   668,   116,    99,   669,   670,   671,   798,   799,
     732,   733,   800,   142,   672,   100,   635,   716,   717,   101,
     117,   103,   615,   104,   105,   118,   106,   204,   205,   119,
     120,   186,   108,   109,   110
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     121,    90,   126,   225,   133,   102,   558,   559,   704,   563,
     564,   565,   341,   146,   147,   148,   149,   132,   225,   107,
     567,   391,   569,   107,   107,   570,   150,  -153,   738,   -21,
     402,   211,   281,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   335,   174,   616,  -153,  -153,   178,
     179,   180,   181,   182,   183,   709,   710,  -152,   380,   111,
     175,   176,   177,   722,   801,   730,   404,   107,   107,   107,
     645,   367,   134,   726,   191,   192,   726,   196,   197,   198,
     724,   206,   791,   381,   730,   135,    90,   216,   802,   665,
     102,   217,   661,   662,   663,   664,    23,    24,   673,   792,
     673,   107,   665,   754,   107,   731,   730,   573,   574,   575,
     576,   801,    31,   280,   730,    33,    34,   633,   143,   536,
     137,  -153,   336,  -153,   734,   212,   212,  -153,  -153,   787,
     136,   213,   345,   346,   144,   805,   801,   695,   634,   380,
     138,  -153,  -153,  -153,  -153,   139,   739,   107,  -153,  -153,
     788,  -152,   789,  -152,   736,   151,   366,  -152,  -152,   718,
     808,   218,   458,   793,    62,   361,   405,   219,   187,   123,
     213,   778,   107,   558,   559,   879,   563,   564,   565,   137,
     405,   821,   801,   145,   842,   673,   375,   567,   339,   569,
     137,   577,   570,   673,   875,   157,   880,   578,   881,   138,
      78,   743,   752,   753,   139,   140,   811,   843,   388,   743,
     138,   794,   222,    62,   591,   139,   140,   876,   123,   154,
     107,   735,   737,   740,   666,   155,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,   887,    78,
     158,   434,   435,   436,   437,   438,   439,   141,   440,   441,
     442,   443,   444,   445,   446,   447,   448,   449,   450,   451,
     452,   453,   455,   456,    92,   814,   886,   355,   817,    98,
     709,   710,   125,   356,   460,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   546,   744,   905,   488,
     489,   490,   491,   492,   493,   744,   494,   495,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     509,   510,   745,   159,   661,   662,   663,   664,    23,    24,
     745,   284,   285,   847,   665,   882,   395,   847,   188,    71,
     847,   523,   396,   847,    31,   527,   202,    33,    34,    92,
     107,   531,   532,   533,    98,   137,   883,   200,   884,   661,
     662,   663,   664,    23,    24,   137,   897,   214,   280,   665,
     545,   224,   215,   137,   336,   138,  -152,   190,  -152,    31,
     139,   389,    33,    34,   562,   138,   283,   898,   568,   899,
     139,   389,   202,   138,   555,   137,   284,   285,   139,   400,
     906,   209,   210,   200,    19,    20,    21,    22,    23,    24,
     317,   746,   171,   172,    27,   138,   141,   -20,   173,   746,
     139,   589,   390,   547,    31,   329,   330,    33,    34,   548,
     122,    62,   331,   332,   333,   334,   123,   652,   555,   -21,
     401,   654,   596,   653,   137,   391,   402,   655,    19,    20,
      21,    22,    23,    24,   137,   337,   675,   656,    27,   225,
     658,   -20,   590,   657,   138,   379,   659,    78,    31,   139,
     400,    33,    34,   749,   138,   317,   378,   124,   387,   139,
     589,   338,   661,   662,   663,   664,    23,    24,   222,    62,
     342,   741,   665,   343,   556,   714,   603,   331,   332,   333,
     334,   715,    31,   608,   363,    33,    34,   364,   348,   222,
      62,   367,   618,   619,   620,   123,   622,   623,   624,   610,
     611,   433,   349,   629,   591,    78,   107,   107,   791,   220,
     350,   357,   222,    62,   365,   665,   557,   370,   556,    19,
      20,    21,   221,    23,    24,   792,    78,   371,   812,   393,
     372,   562,   840,    62,   394,   568,   549,   725,   123,    31,
     791,   550,    33,    34,   373,   225,   804,   665,   807,    78,
     137,   810,   667,   392,   667,   403,   674,   792,   674,   487,
     643,   685,   397,   390,   432,   493,   401,   282,   688,    78,
     747,    62,   493,   486,   459,   139,   123,    19,    20,    21,
     221,    23,    24,   697,   515,   379,   222,    62,   581,   793,
      62,   512,   123,   582,   750,   123,   378,    31,   516,   519,
      33,    34,   646,   222,    62,   521,   522,    78,   524,   223,
    -213,  -213,    19,    20,    21,   221,    23,    24,   384,    62,
     583,   793,    62,    78,   385,   584,    78,   123,   128,   528,
     525,   834,    31,   855,   728,    33,    34,   803,   526,   742,
      78,   529,   566,   674,   193,   194,  -152,   742,  -152,   128,
     195,   674,  -152,  -152,   858,    78,   530,   535,    78,   791,
     541,   222,    62,   791,   543,   386,   665,   123,   764,   806,
     665,   791,   551,   571,   760,   761,   792,   776,   665,   572,
     792,   107,   107,   765,   867,   585,   766,   870,   792,   317,
     107,   599,   592,   107,   128,   590,   222,    62,    78,   915,
     797,   128,   223,   797,   606,   797,   917,   614,   797,   607,
     613,   331,   332,   333,   334,   628,   888,   889,   890,   891,
     892,   641,   893,   894,  -153,   630,  -153,   631,   632,   636,
    -153,  -153,   638,    78,   639,   824,   825,   826,   827,   640,
     793,    62,   831,   832,   793,    62,   123,   642,   660,   678,
     123,   679,   793,    62,   680,   838,   681,   791,   123,   634,
     693,   692,   694,   128,   665,   700,   107,   708,   727,   797,
     719,   633,   154,   797,   792,   751,   797,    78,   756,   797,
     791,    78,   757,   758,   759,   767,   777,   665,   809,    78,
     428,   429,   846,   780,   430,   431,   781,   792,   482,   483,
     849,   782,   484,   485,   860,   786,   790,   355,   828,   566,
     878,   107,   284,   285,   818,   822,   829,   647,   830,   107,
     650,   650,   107,   107,   738,   845,   844,   730,   853,   865,
     866,   871,   872,   877,   874,   885,   895,   921,   793,    62,
     208,   912,   914,   896,   123,   284,   285,   901,   920,   644,
     903,   107,   107,   107,   107,   107,   107,   107,   107,   107,
     537,   793,    62,   696,   922,   909,   923,   123,   156,   907,
     698,   699,   779,   399,   729,    78,   107,   107,   107,   107,
     107,   107,   107,   107,   651,   848,   850,   676,   837,   279,
     189,   317,   544,   720,   721,     0,     0,   650,    78,     0,
     650,     0,     0,   326,   327,   328,   329,   330,     0,   851,
       0,     0,     0,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   748,     0,   317,     0,     0,     0,   347,     0,
       0,     0,     0,   351,   352,     0,   284,   285,   328,   329,
     330,     0,     0,     0,     0,     0,   331,   332,   333,   334,
     763,     0,     0,     0,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,     0,   310,
     311,   312,     0,   783,   784,     0,     0,   785,     0,   374,
     796,     0,   376,   796,     0,   796,   313,   314,   796,   316,
      19,    20,    21,   221,    23,    24,     0,     0,     0,     0,
     284,   285,     0,     0,     0,     0,     0,   815,   816,     0,
      31,   819,   820,    33,    34,   317,     0,     0,     0,     0,
     320,   202,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   200,   310,   311,   312,     0,   331,   332,   333,
     334,   841,     0,     0,     0,     0,     0,     0,     0,   796,
       0,     0,     0,   796,     0,     0,   796,     0,     0,   796,
       0,     0,     0,     0,     0,     0,     0,     0,   457,   854,
       0,     0,   856,   857,   202,     0,   859,   202,   379,   317,
       0,     0,     0,     0,     0,   200,     0,     0,   200,   378,
       0,   326,   327,   328,   329,   330,     0,     0,     0,     0,
       0,   331,   332,   333,   334,     0,   202,   202,   202,   202,
     202,   379,   202,   202,   379,     0,     0,   200,   200,   200,
     200,   200,   378,   200,   200,   378,   511,     0,     0,     0,
       0,   513,   379,   379,   379,   379,   379,   379,   379,     0,
       0,     0,   520,   378,   378,   378,   378,   378,   378,   378,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     916,   918,   538,   539,   540,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   552,   553,   554,     0,     0,     0,     0,     0,
       0,     0,     0,   586,   587,   588,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   207,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,    27,    28,     0,   -20,    29,    30,     0,     0,     0,
       0,    31,  -212,    32,    33,    34,  -212,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,   609,     0,
       0,   612,    58,    59,    60,    61,    62,  -158,    63,    64,
      65,    66,  -158,    67,    68,    69,  -212,    70,    71,    72,
       0,     0,  -212,    73,     0,     0,    74,     0,    75,     0,
       0,     0,     0,   637,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,    82,
       0,     0,    83,     0,    84,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   677,     0,     0,
       0,     0,   682,   683,   684,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,     0,     0,     0,     3,     0,
       0,     0,     0,     0,     0,     0,     0,   112,     0,     0,
       0,    14,    15,     0,     0,    17,    18,    19,    20,    21,
     113,    23,    24,     0,     0,     0,     0,     0,     0,     0,
     -20,     0,     0,   723,     0,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   755,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,     0,     0,   762,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,    62,  -158,    63,    64,    65,   114,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,   813,    79,    80,    81,   115,     0,     0,    83,     0,
       0,  -112,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   835,   836,     0,     0,     0,     0,     0,     0,
     839,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   852,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
      22,    23,    24,    25,     0,     0,    26,    27,    28,     0,
     -20,    29,    30,     0,     0,     0,     0,    31,  -212,    32,
      33,    34,  -212,     0,    35,    36,     0,     0,     0,     0,
       0,     0,   902,     0,     0,   904,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
     910,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,    62,  -158,    63,    64,    65,    66,  -158,    67,
      68,    69,  -212,    70,    71,    72,     0,     0,  -212,    73,
       0,     0,    74,     0,    75,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,    82,     0,     1,    83,     2,
      84,     3,     4,     5,     6,     0,   358,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,   359,   360,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,    62,  -158,    63,    64,    65,
     127,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   128,     0,
       1,    83,     2,    84,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   112,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,   113,    23,    24,    25,
       0,     0,    26,     0,    28,     0,   -20,    29,    30,  -110,
    -110,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,    62,  -158,
      63,    64,    65,   127,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   128,     0,     0,    83,  -110,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -106,  -106,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,    62,  -158,    63,    64,    65,
     127,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   128,     0,
       0,    83,  -106,    84,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   112,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     113,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -108,  -108,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,    62,  -158,    63,    64,    65,   127,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   128,     0,     0,    83,  -108,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -109,  -109,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,    62,
    -158,    63,    64,    65,   127,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     0,     0,    79,
      80,    81,   128,     0,     0,    83,  -109,    84,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   112,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,   113,    23,    24,    25,     0,     0,
      26,     0,    28,     0,   -20,    29,    30,   -96,   -96,     0,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,    62,  -158,    63,    64,
      65,   127,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   128,
       0,     0,    83,   -96,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -94,   -94,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,    62,  -158,    63,    64,    65,   127,  -158,
      67,    68,    69,     0,    70,    71,    72,     0,     0,     0,
      73,     0,     0,    74,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,    77,     0,    78,
       0,     0,     0,    79,    80,    81,   128,     0,     0,    83,
     -94,    84,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   112,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   113,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,   -92,   -92,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,     0,    58,    59,    60,    61,
      62,  -158,    63,    64,    65,   127,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   128,     0,     0,    83,   -92,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -102,  -102,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,    62,  -158,    63,
      64,    65,   127,  -158,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     0,    78,     0,     0,     0,    79,    80,    81,
     128,     0,     0,    83,  -102,    84,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   112,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
      20,    21,   113,    23,    24,    25,     0,     0,    26,     0,
      28,     0,   -20,    29,    30,  -104,  -104,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,    62,  -158,    63,    64,    65,   127,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   128,     0,     0,
      83,  -104,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -105,  -105,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,    62,  -158,    63,    64,    65,   127,  -158,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     0,    78,     0,     0,
       0,    79,    80,    81,   128,     0,     0,    83,  -105,    84,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   112,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,   113,    23,    24,    25,
       0,     0,    26,     0,    28,     0,   -20,    29,    30,   -98,
     -98,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,    62,  -158,
      63,    64,    65,   127,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   128,     0,     0,    83,   -98,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -100,  -100,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,    62,  -158,    63,    64,    65,
     127,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   128,     0,
       0,    83,  -100,    84,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   112,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     113,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -107,  -107,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,    62,  -158,    63,    64,    65,   127,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   128,     0,     0,    83,  -107,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -95,   -95,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,    62,
    -158,    63,    64,    65,   127,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     0,     0,    79,
      80,    81,   128,     0,     0,    83,   -95,    84,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   112,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,   113,    23,    24,    25,     0,     0,
      26,     0,    28,     0,   -20,    29,    30,   -93,   -93,     0,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,    62,  -158,    63,    64,
      65,   127,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   128,
       0,     0,    83,   -93,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -91,   -91,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,    62,  -158,    63,    64,    65,   127,  -158,
      67,    68,    69,     0,    70,    71,    72,     0,     0,     0,
      73,     0,     0,    74,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,    77,     0,    78,
       0,     0,     0,    79,    80,    81,   128,     0,     0,    83,
     -91,    84,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   112,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   113,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -101,  -101,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,     0,    58,    59,    60,    61,
      62,  -158,    63,    64,    65,   127,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   128,     0,     0,    83,  -101,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -103,  -103,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,    62,  -158,    63,
      64,    65,   127,  -158,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     0,    78,     0,     0,     0,    79,    80,    81,
     128,     0,     0,    83,  -103,    84,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   112,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
      20,    21,   113,    23,    24,    25,     0,     0,    26,     0,
      28,     0,   -20,    29,    30,   -97,   -97,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,    62,  -158,    63,    64,    65,   127,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   128,     0,     0,
      83,   -97,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,   -99,   -99,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,    62,  -158,    63,    64,    65,   127,  -158,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     0,    78,     0,     0,
       0,    79,    80,    81,   128,     0,     0,    83,   -99,    84,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   112,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,   113,    23,    24,    25,
       0,     0,    26,     0,    28,     0,   -20,    29,    30,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,    62,  -158,
      63,    64,    65,   127,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   128,     0,     0,    83,   199,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,    62,  -158,    63,    64,    65,
     127,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   128,     0,
       0,    83,   340,    84,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   112,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     113,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,     0,     0,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,    62,  -158,    63,    64,    65,   127,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   128,     0,     0,    83,   377,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,    62,
    -158,    63,    64,    65,   127,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     0,     0,    79,
      80,    81,   128,     0,     0,    83,   514,    84,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   112,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,   113,    23,    24,    25,     0,     0,
      26,     0,    28,     0,   -20,    29,    30,     0,     0,     0,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,    62,  -158,    63,    64,
      65,   127,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   128,
       0,   184,    83,     0,    84,     3,     0,     0,     0,     0,
       0,     0,     0,     0,   112,     0,     0,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   113,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,     0,     0,     0,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,    62,
    -158,    63,    64,    65,   114,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     3,     0,    79,
      80,    81,   115,     0,     0,    83,   112,  -112,     0,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   113,
      23,    24,     0,     0,     0,     0,     0,     0,     0,   -20,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,     0,     0,     0,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,    62,     0,    63,    64,    65,   114,     0,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     3,    78,     0,     0,
       0,    79,    80,    81,   115,   112,     0,    83,     0,    14,
      15,   595,     0,    17,    18,    19,    20,    21,   113,    23,
      24,     0,     0,     0,     0,     0,     0,     0,   -20,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,    44,    45,
      46,    47,     0,     0,     0,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,     0,    58,    59,    60,    61,
      62,     0,    63,    64,    65,   114,     0,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     3,    78,     0,     0,     0,
      79,    80,    81,   115,   112,     0,    83,     0,    14,    15,
     602,     0,    17,    18,    19,    20,    21,   113,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,     0,     0,     0,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,    62,
       0,    63,    64,    65,   114,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     3,    78,     0,     0,     0,    79,
      80,    81,   115,   112,     0,    83,     0,    14,    15,   687,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,    62,     0,
      63,    64,    65,   114,     0,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     3,    78,     0,     0,     0,    79,    80,
      81,   115,   112,     0,    83,     0,    14,    15,   690,     0,
      17,    18,    19,    20,    21,   113,    23,    24,     0,     0,
       0,     0,     0,     0,     0,   -20,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,     0,
       0,     0,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,    62,     0,    63,
      64,    65,   114,     0,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     0,    78,     0,     3,     0,    79,    80,    81,
     115,     0,     0,    83,   112,     0,   203,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   113,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,     0,     0,     0,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,    62,
       0,    63,    64,    65,   114,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     3,     0,    79,
      80,    81,   115,     0,     0,    83,   112,   -86,     0,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   113,
      23,    24,     0,     0,     0,     0,     0,     0,     0,   -20,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,     0,     0,     0,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,    62,     0,    63,    64,    65,   114,     0,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     3,    78,     0,     0,
       0,    79,    80,    81,   115,   112,     0,    83,   278,    14,
      15,     0,     0,    17,    18,    19,    20,    21,   113,    23,
      24,     0,     0,     0,     0,     0,     0,     0,   -20,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,     0,   768,     0,   769,   770,     0,
       0,     0,   771,   772,    43,     0,     0,     0,    44,    45,
      46,    47,     0,     0,     0,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,     0,    58,    59,    60,    61,
      62,     0,    63,    64,    65,   114,     0,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,   773,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   774,   775,    76,    77,     3,    78,     0,     0,     0,
      79,    80,    81,   115,   112,     0,    83,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   113,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,     0,     0,     0,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,    62,
    -158,    63,    64,    65,   114,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     3,    78,     0,     0,     0,    79,
      80,    81,   115,   112,     0,    83,     0,    14,    15,     0,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,   454,    58,    59,    60,    61,    62,     0,
      63,    64,    65,   114,     0,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     3,    78,     0,     0,     0,    79,    80,
      81,   115,   112,     0,    83,     0,    14,    15,     0,     0,
      17,    18,    19,    20,    21,   113,    23,    24,     0,     0,
       0,     0,     0,     0,     0,   -20,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,     0,
       0,     0,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,   508,    58,    59,    60,    61,    62,     0,    63,
      64,    65,   114,     0,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     3,    78,     0,     0,     0,    79,    80,    81,
     115,   112,     0,    83,     0,    14,    15,     0,     0,    17,
      18,    19,    20,    21,   113,    23,    24,     0,     0,     0,
       0,     0,     0,     0,   -20,     0,     0,     0,     0,     0,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,     0,     0,
       0,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,    62,     0,    63,    64,
      65,   114,   617,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   115,
       0,     0,    83,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,     0,     0,     0,     0,     0,
       0,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,     0,   310,   311,   312,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   353,     0,
       0,     0,   317,     0,     0,   318,   319,   320,     0,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,     0,
       0,     0,     0,     0,   331,   332,   333,   334,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
       0,     0,     0,     0,     0,     0,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   354,     0,     0,     0,   317,     0,     0,
     318,   319,   320,     0,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,     0,     0,     0,     0,     0,
       0,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,     0,   310,   311,   312,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,     0,     0,   318,   319,   320,     0,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,     0,
       0,     0,     0,     0,   331,   332,   333,   334,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
       0,     0,     0,     0,     0,     0,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,   314,
     315,   597,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,     0,     0,
     318,   319,   320,     0,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,     0,     0,     0,   598,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,     0,
       0,     0,     0,     0,     0,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,     0,
     310,   311,   312,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   313,   314,   315,
     604,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,   318,
     319,   320,     0,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,     0,     0,     0,     0,     0,   331,   332,
     333,   334,     0,     0,     0,   605,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,     0,     0,
       0,     0,     0,     0,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,     0,   310,
     311,   312,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,     0,     0,   318,   319,
     320,     0,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,     0,     0,     0,     0,     0,   331,   332,   333,
     334,     0,     0,     0,   686,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,     0,     0,     0,
       0,     0,     0,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,     0,   310,   311,
     312,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   313,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,     0,     0,   318,   319,   320,
       0,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,     0,     0,     0,     0,     0,   331,   332,   333,   334,
       0,     0,     0,   689,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,   382,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,     0,
       0,   383,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,     0,     0,     0,     0,     0,     0,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,     0,   310,   311,   312,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   313,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,     0,     0,   318,   319,   320,     0,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
       0,     0,     0,   331,   332,   333,   334,     0,     0,   517,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,     0,     0,     0,     0,     0,     0,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,     0,   310,   311,   312,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     313,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
       0,     0,   318,   319,   320,     0,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,     0,     0,     0,     0,
       0,   331,   332,   333,   334,     0,     0,   518,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
       0,     0,     0,     0,     0,     0,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,     0,     0,
     318,   319,   320,     0,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,     0,     0,   534,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,     0,     0,
       0,     0,     0,     0,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,     0,   310,
     311,   312,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,     0,     0,   318,   319,
     320,     0,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,     0,     0,     0,     0,     0,   331,   332,   333,
     334,     0,     0,   542,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,     0,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,     0,
       0,   621,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,     0,     0,     0,     0,     0,     0,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,     0,   310,   311,   312,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   313,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,     0,     0,   318,   319,   320,     0,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
       0,     0,     0,   331,   332,   333,   334,     0,     0,   627,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,     0,     0,     0,     0,     0,     0,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,     0,   310,   311,   312,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     313,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
       0,     0,   318,   319,   320,     0,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,     0,     0,     0,     0,
       0,   331,   332,   333,   334,     0,     0,   691,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
       0,     0,     0,     0,     0,     0,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,     0,     0,
     318,   319,   320,     0,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,     0,     0,   701,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,     0,     0,
       0,     0,     0,     0,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,     0,   310,
     311,   312,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,     0,     0,   318,   319,
     320,     0,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,     0,     0,     0,     0,     0,   331,   332,   333,
     334,     0,     0,   705,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,     0,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,     0,
       0,   706,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,     0,     0,     0,     0,     0,     0,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,     0,   310,   311,   312,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   313,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,     0,     0,   318,   319,   320,     0,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
       0,     0,     0,   331,   332,   333,   334,     0,     0,   707,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,     0,     0,     0,     0,     0,     0,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,     0,   310,   311,   312,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     313,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
       0,     0,   318,   319,   320,     0,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,     0,     0,     0,     0,
       0,   331,   332,   333,   334,     0,     0,   823,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
       0,     0,     0,     0,     0,     0,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,     0,     0,
     318,   319,   320,     0,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,     0,     0,   861,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,     0,     0,
       0,     0,     0,     0,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,     0,   252,
     253,   254,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   255,   256,   257,   258,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   259,     0,     0,   260,   261,
     262,     0,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,     0,     0,     0,     0,     0,   273,   274,   275,
     276,     0,   277,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,     0,     0,     0,     0,     0,
       0,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,     0,   310,   311,   312,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,     0,     0,   318,   319,   320,     0,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,     0,
       0,     0,     0,     0,   331,   332,   333,   334,     0,   344,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,     0,     0,     0,     0,     0,     0,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,     0,   310,   311,   312,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     313,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
       0,     0,   318,   319,   320,     0,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,     0,     0,     0,     0,
       0,   331,   332,   333,   334,     0,   625,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,     0,
       0,     0,     0,     0,     0,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,     0,
     310,   311,   312,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   313,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,   318,
     319,   320,     0,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,     0,     0,     0,     0,     0,   331,   332,
     333,   334,     0,   626,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,     0,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,     0,
     702,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,     0,     0,     0,     0,     0,     0,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,     0,   310,   311,   312,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   313,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,     0,     0,   318,   319,   320,     0,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,     0,     0,     0,
       0,     0,   331,   332,   333,   334,     0,   703,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
       0,     0,     0,     0,     0,     0,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,     0,     0,
     318,   319,   320,     0,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,     0,   713,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,     0,     0,     0,
       0,     0,     0,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,     0,   310,   311,
     312,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   313,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,     0,     0,   318,   319,   320,
       0,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,     0,     0,     0,     0,     0,   331,   332,   333,   334,
       0,   873,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,     0,     0,     0,     0,     0,     0,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,     0,   310,   311,   312,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   313,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,     0,     0,   318,   319,   320,     0,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
       0,     0,     0,   331,   332,   333,   334,     0,   900,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,     0,   310,   311,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,     0,
       0,   318,   319,   320,     0,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,     0,     0,     0,
     331,   332,   333,   334,     0,   908,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,     0,     0,
       0,     0,     0,     0,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,     0,   310,
     311,   312,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,     0,     0,   318,   319,
     320,     0,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,     0,     0,     0,     0,     0,   331,   332,   333,
     334,     0,   911,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,     0,     0,     0,     0,     0,
       0,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,     0,   310,   311,   312,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,     0,     0,   318,   319,   320,     0,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,     0,
       0,     0,     0,     0,   331,   332,   333,   334,     0,   913,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,     0,     0,     0,     0,     0,     0,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,     0,   310,   311,   312,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     313,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
       0,     0,   318,   319,   320,     0,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,     0,     0,     0,     0,
       0,   331,   332,   333,   334,     0,   919,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,     0,
       0,     0,     0,     0,     0,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,     0,
     310,   311,   312,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   313,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,   318,
     319,   320,     0,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,     0,     0,     0,     0,     0,   331,   332,
     333,   334,   594,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,     0,     0,     0,     0,     0,
       0,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,     0,   310,   311,   312,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,     0,     0,   318,   319,   320,     0,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,     0,
       0,     0,     0,     0,   331,   332,   333,   334,   601,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,     0,   310,   311,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,     0,
       0,   318,   319,   320,   382,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,     0,     0,     0,
     331,   332,   333,   334,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,   593,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,     0,   310,   311,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,     0,
       0,   318,   319,   320,   600,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,     0,     0,     0,
     331,   332,   333,   334,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,   833,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,     0,   310,   311,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,     0,
       0,   318,   319,   320,   862,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,     0,     0,     0,
     331,   332,   333,   334,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,   863,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,     0,   310,   311,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,     0,
       0,   318,   319,   320,   864,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,     0,     0,     0,
     331,   332,   333,   334,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,   868,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,     0,   310,   311,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,     0,
       0,   318,   319,   320,   869,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,     0,     0,     0,     0,
     331,   332,   333,   334,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,     0,     0,     0,     0,
       0,     0,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,     0,   310,   311,   312,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,     0,     0,   318,   319,   320,     0,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
       0,     0,     0,     0,     0,   331,   332,   333,   334,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,     0,     0,     0,     0,     0,     0,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,     0,   310,   311,   312,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   284,   285,     0,   313,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   317,   310,
     311,   312,   319,   320,     0,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,     0,   313,   314,     0,  -213,
     331,   332,   333,   334,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,     0,     0,     0,     0,
       0,     0,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   284,   285,     0,     0,     0,   331,   332,   333,
     334,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,     0,   310,   311,   312,   284,   285,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   313,   314,     0,     0,   296,     0,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,   317,     0,     0,     0,     0,     0,     0,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
       0,     0,     0,   331,   332,   333,   334,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,     0,     0,
       0,     0,   284,   285,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,     0,   310,   311,   312,   284,   285,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
       0,   310,   311,   312,     0,     0,     0,     0,     0,     0,
       0,   317,     0,     0,     0,   284,   285,     0,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
       0,     0,     0,   331,   332,   333,   334,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   317,   310,   311,
     312,     0,   284,   285,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,     0,     0,     0,     0,     0,   331,
     332,   333,   334,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,     0,   310,   311,   312,     0,     0,
       0,     0,     0,     0,   317,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   324,   325,   326,   327,   328,   329,
     330,     0,     0,     0,     0,     0,   331,   332,   333,   334,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,     0,     0,     0,     0,     0,     0,     0,     0,
     323,   324,   325,   326,   327,   328,   329,   330,     0,     0,
       0,     0,     0,   331,   332,   333,   334
};

static const yytype_int16 yycheck[] =
{
       2,     0,     3,   102,     6,     0,   393,   393,   621,   393,
     393,   393,   128,    15,    16,    17,    18,     5,   117,     0,
     393,   211,   393,     4,     5,   393,    34,    14,    34,    37,
     220,    14,    14,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,   124,    47,   522,    14,    14,    51,
      52,    53,    54,    55,    56,    40,    41,    14,   133,   157,
      48,    49,    50,   640,   133,   112,    14,    48,    49,    50,
      14,   108,   155,   648,    76,    77,   651,    79,    80,    81,
      14,    83,    27,   158,   112,   155,    85,    45,   157,    34,
      85,    49,    24,    25,    26,    27,    28,    29,   581,    44,
     583,    82,    34,   680,    85,   152,   112,    24,    25,    26,
      27,   133,    44,   115,   112,    47,    48,   136,   157,   156,
      88,   108,   124,   110,   152,   108,   108,   114,   115,   134,
     155,   114,   134,   135,   157,   157,   133,   613,   157,   133,
     108,   108,   108,   110,   110,   113,   152,   128,   115,   115,
     155,   108,   157,   110,   152,   108,   158,   114,   115,   635,
     157,   119,   156,   108,   109,   153,   114,   125,   155,   114,
     114,   156,   153,   560,   560,   134,   560,   560,   560,    88,
     114,   758,   133,   157,   134,   668,   188,   560,   155,   560,
      88,   108,   560,   676,   134,   157,   155,   114,   157,   108,
     145,   668,   678,   679,   113,   114,   157,   157,   209,   676,
     108,   156,   108,   109,   404,   113,   114,   157,   114,   108,
     201,   662,   663,   664,   156,   114,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   861,   145,
     155,   253,   254,   255,   256,   257,   258,   155,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,     0,   751,   853,   108,   754,     0,
      40,    41,     3,   114,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   386,   668,   885,   311,
     312,   313,   314,   315,   316,   676,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   668,   152,    24,    25,    26,    27,    28,    29,
     676,    51,    52,   800,    34,   134,   108,   804,   155,   121,
     807,   353,   114,   810,    44,   357,    82,    47,    48,    85,
     341,   363,   364,   365,    85,    88,   155,    82,   157,    24,
      25,    26,    27,    28,    29,    88,   134,   110,   380,    34,
     382,   102,   115,    88,   386,   108,   108,   155,   110,    44,
     113,   114,    47,    48,   393,   108,   117,   155,   393,   157,
     113,   114,   128,   108,    14,    88,    51,    52,   113,   114,
     886,    37,   157,   128,    24,    25,    26,    27,    28,    29,
     130,   668,   108,   109,    34,   108,   155,    37,   114,   676,
     113,   114,   155,   108,    44,   145,   146,    47,    48,   114,
     108,   109,   152,   153,   154,   155,   114,   108,    14,    37,
     155,   108,   454,   114,    88,   645,   646,   114,    24,    25,
      26,    27,    28,    29,    88,   108,   156,   108,    34,   568,
     108,    37,   155,   114,   108,   201,   114,   145,    44,   113,
     114,    47,    48,   673,   108,   130,   201,   155,   209,   113,
     114,   110,    24,    25,    26,    27,    28,    29,   108,   109,
      11,   156,    34,     9,   114,   108,   508,   152,   153,   154,
     155,   114,    44,   515,   134,    47,    48,   134,   155,   108,
     109,   108,   524,   525,   526,   114,   528,   529,   530,   517,
     518,   252,   155,   535,   724,   145,   517,   518,    27,    14,
     155,   155,   108,   109,   155,    34,   156,   155,   114,    24,
      25,    26,    27,    28,    29,    44,   145,   155,   748,   152,
     155,   560,   108,   109,   157,   560,   110,   156,   114,    44,
      27,   115,    47,    48,   158,   674,   734,    34,   736,   145,
      88,   739,   581,   155,   583,   155,   581,    44,   583,   310,
     156,   593,    42,   155,   127,   597,   155,    14,   600,   145,
     108,   109,   604,   127,    14,   113,   114,    24,    25,    26,
      27,    28,    29,   614,   155,   341,   108,   109,   152,   108,
     109,   158,   114,   157,   156,   114,   341,    44,   155,   157,
      47,    48,    14,   108,   109,   158,   158,   145,   155,   114,
      51,    52,    24,    25,    26,    27,    28,    29,   108,   109,
     152,   108,   109,   145,   114,   157,   145,   114,   152,   155,
     134,   777,    44,   157,   156,    47,    48,   156,   134,   668,
     145,   155,   393,   668,   108,   109,   108,   676,   110,   152,
     114,   676,   114,   115,   157,   145,   155,   134,   145,    27,
     158,   108,   109,    27,   158,   155,    34,   114,   700,   156,
      34,    27,   155,   152,   692,   693,    44,   709,    34,   152,
      44,   692,   693,   701,   830,   155,   704,   833,    44,   130,
     701,   158,   155,   704,   152,   155,   108,   109,   145,   157,
     731,   152,   114,   734,   158,   736,   157,     4,   739,   158,
     158,   152,   153,   154,   155,   152,   862,   863,   864,   865,
     866,   155,   868,   869,   108,   158,   110,   158,   158,   158,
     114,   115,   158,   145,   158,   767,   768,   769,   770,   158,
     108,   109,   774,   775,   108,   109,   114,   157,   133,   158,
     114,   158,   108,   109,   158,   787,   155,    27,   114,   157,
      43,   158,   157,   152,    34,   155,   777,    36,   108,   800,
     158,   136,   108,   804,    44,   158,   807,   145,   158,   810,
      27,   145,   158,   158,   157,   155,   136,    34,   156,   145,
     123,   124,   156,   155,   127,   128,   155,    44,   123,   124,
     156,   133,   127,   128,   822,   158,   114,   108,   127,   560,
     842,   822,    51,    52,   158,   158,   127,   568,   136,   830,
     571,   572,   833,   834,    34,   112,   108,   112,   158,   136,
     136,   158,   158,   108,   158,   158,   157,   157,   108,   109,
      85,   158,   158,   875,   114,    51,    52,   879,   158,   560,
     882,   862,   863,   864,   865,   866,   867,   868,   869,   870,
     368,   108,   109,   614,   157,   897,   157,   114,    28,   887,
     615,   616,   711,   219,   660,   145,   887,   888,   889,   890,
     891,   892,   893,   894,   572,   801,   156,   583,   782,   115,
      71,   130,   380,   638,   639,    -1,    -1,   648,   145,    -1,
     651,    -1,    -1,   142,   143,   144,   145,   146,    -1,   156,
      -1,    -1,    -1,   152,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,   673,    -1,   130,    -1,    -1,    -1,   136,    -1,
      -1,    -1,    -1,   141,   142,    -1,    51,    52,   144,   145,
     146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,
     695,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,   718,   719,    -1,    -1,   722,    -1,   187,
     731,    -1,   190,   734,    -1,   736,   101,   102,   739,   104,
      24,    25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,   752,   753,    -1,
      44,   756,   757,    47,    48,   130,    -1,    -1,    -1,    -1,
     135,   777,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   777,    84,    85,    86,    -1,   152,   153,   154,
     155,   792,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   800,
      -1,    -1,    -1,   804,    -1,    -1,   807,    -1,    -1,   810,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   276,   814,
      -1,    -1,   817,   818,   830,    -1,   821,   833,   834,   130,
      -1,    -1,    -1,    -1,    -1,   830,    -1,    -1,   833,   834,
      -1,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,    -1,   862,   863,   864,   865,
     866,   867,   868,   869,   870,    -1,    -1,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   334,    -1,    -1,    -1,
      -1,   339,   888,   889,   890,   891,   892,   893,   894,    -1,
      -1,    -1,   350,   888,   889,   890,   891,   892,   893,   894,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     905,   906,   370,   371,   372,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   390,   391,   392,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   401,   402,   403,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      33,    34,    35,    -1,    37,    38,    39,    -1,    -1,    -1,
      -1,    44,    45,    46,    47,    48,    49,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      83,    -1,    -1,    -1,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   516,    -1,
      -1,   519,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,   142,
     143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,    -1,   157,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   585,    -1,    -1,
      -1,    -1,   590,   591,   592,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    14,    -1,    -1,
      -1,    18,    19,    -1,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    -1,    -1,   641,    -1,    -1,    -1,    44,    -1,    -1,
      47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   681,    -1,    -1,    83,    -1,    -1,    -1,
      87,    88,    89,    90,    -1,    -1,   694,    94,    95,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,
      -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   142,   143,    -1,   145,    -1,
      -1,   749,   149,   150,   151,   152,    -1,    -1,   155,    -1,
      -1,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   780,   781,    -1,    -1,    -1,    -1,    -1,    -1,
     788,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   812,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    33,    34,    35,    -1,
      37,    38,    39,    -1,    -1,    -1,    -1,    44,    45,    46,
      47,    48,    49,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,   880,    -1,    -1,   883,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     898,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,    -1,    -1,   125,   126,
      -1,    -1,   129,    -1,   131,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   142,   143,    -1,   145,    -1,
      -1,    -1,   149,   150,   151,   152,    -1,     1,   155,     3,
     157,     5,     6,     7,     8,    -1,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,    -1,
      -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,   143,
      -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,    -1,
       1,   155,     3,   157,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,    40,
      41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   142,   143,    -1,   145,    -1,    -1,    -1,   149,   150,
     151,   152,    -1,    -1,   155,   156,   157,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,    -1,
      -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,   143,
      -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,    -1,
      -1,   155,   156,   157,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,
      37,    38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,
      47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,
      -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   142,   143,    -1,   145,    -1,
      -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,   156,
     157,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
     120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,   143,    -1,   145,    -1,    -1,    -1,   149,
     150,   151,   152,    -1,    -1,   155,   156,   157,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      33,    -1,    35,    -1,    37,    38,    39,    40,    41,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      83,    -1,    -1,    -1,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
      -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,
     143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,   156,   157,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,   120,   121,   122,    -1,    -1,    -1,
     126,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   142,   143,    -1,   145,
      -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,
     156,   157,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,
      39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   142,   143,    -1,   145,    -1,    -1,    -1,
     149,   150,   151,   152,    -1,    -1,   155,   156,   157,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,   120,   121,
     122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,   143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,
     152,    -1,    -1,   155,   156,   157,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    33,    -1,
      35,    -1,    37,    38,    39,    40,    41,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,    -1,    -1,
      -1,   126,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,   143,    -1,
     145,    -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,
     155,   156,   157,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   142,   143,    -1,   145,    -1,    -1,
      -1,   149,   150,   151,   152,    -1,    -1,   155,   156,   157,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,    40,
      41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   142,   143,    -1,   145,    -1,    -1,    -1,   149,   150,
     151,   152,    -1,    -1,   155,   156,   157,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,    -1,
      -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,   143,
      -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,    -1,
      -1,   155,   156,   157,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,
      37,    38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,
      47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,
      -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   142,   143,    -1,   145,    -1,
      -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,   156,
     157,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
     120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,   143,    -1,   145,    -1,    -1,    -1,   149,
     150,   151,   152,    -1,    -1,   155,   156,   157,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      33,    -1,    35,    -1,    37,    38,    39,    40,    41,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      83,    -1,    -1,    -1,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
      -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,
     143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,   156,   157,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,   120,   121,   122,    -1,    -1,    -1,
     126,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   142,   143,    -1,   145,
      -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,
     156,   157,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,
      39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   142,   143,    -1,   145,    -1,    -1,    -1,
     149,   150,   151,   152,    -1,    -1,   155,   156,   157,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,   120,   121,
     122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,   143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,
     152,    -1,    -1,   155,   156,   157,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    33,    -1,
      35,    -1,    37,    38,    39,    40,    41,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,    -1,    -1,
      -1,   126,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,   143,    -1,
     145,    -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,
     155,   156,   157,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   142,   143,    -1,   145,    -1,    -1,
      -1,   149,   150,   151,   152,    -1,    -1,   155,   156,   157,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   142,   143,    -1,   145,    -1,    -1,    -1,   149,   150,
     151,   152,    -1,    -1,   155,   156,   157,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,    -1,
      -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,   143,
      -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,    -1,
      -1,   155,   156,   157,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,
      37,    38,    39,    -1,    -1,    -1,    -1,    44,    -1,    -1,
      47,    48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,
      -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   142,   143,    -1,   145,    -1,
      -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,   156,
     157,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
     120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,   143,    -1,   145,    -1,    -1,    -1,   149,
     150,   151,   152,    -1,    -1,   155,   156,   157,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      33,    -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      83,    -1,    -1,    -1,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
      -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,
     143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,     1,   155,    -1,   157,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    14,    -1,    -1,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    -1,    -1,    -1,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
     120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,   143,    -1,   145,    -1,     5,    -1,   149,
     150,   151,   152,    -1,    -1,   155,    14,   157,    -1,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    -1,    -1,    -1,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,   109,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   142,   143,     5,   145,    -1,    -1,
      -1,   149,   150,   151,   152,    14,    -1,   155,    -1,    18,
      19,   159,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,
      89,    90,    -1,    -1,    -1,    94,    95,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,
     109,    -1,   111,   112,   113,   114,    -1,   116,   117,   118,
      -1,   120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   142,   143,     5,   145,    -1,    -1,    -1,
     149,   150,   151,   152,    14,    -1,   155,    -1,    18,    19,
     159,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    -1,    -1,    -1,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,    -1,
     120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,   143,     5,   145,    -1,    -1,    -1,   149,
     150,   151,   152,    14,    -1,   155,    -1,    18,    19,   159,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      -1,    -1,    -1,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,    -1,   116,   117,   118,    -1,   120,
     121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   142,   143,     5,   145,    -1,    -1,    -1,   149,   150,
     151,   152,    14,    -1,   155,    -1,    18,    19,   159,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    -1,
      -1,    -1,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,   108,   109,    -1,   111,
     112,   113,   114,    -1,   116,   117,   118,    -1,   120,   121,
     122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,   143,    -1,   145,    -1,     5,    -1,   149,   150,   151,
     152,    -1,    -1,   155,    14,    -1,   158,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    -1,    -1,    -1,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,    -1,
     120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,   143,    -1,   145,    -1,     5,    -1,   149,
     150,   151,   152,    -1,    -1,   155,    14,   157,    -1,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    87,
      88,    89,    90,    -1,    -1,    -1,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
     108,   109,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,    -1,   120,   121,   122,    -1,    -1,    -1,   126,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   142,   143,     5,   145,    -1,    -1,
      -1,   149,   150,   151,   152,    14,    -1,   155,   156,    18,
      19,    -1,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    81,    82,    83,    -1,    -1,    -1,    87,    88,
      89,    90,    -1,    -1,    -1,    94,    95,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,
     109,    -1,   111,   112,   113,   114,    -1,   116,   117,   118,
      -1,   120,   121,   122,    -1,    -1,    -1,   126,   127,    -1,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,     5,   145,    -1,    -1,    -1,
     149,   150,   151,   152,    14,    -1,   155,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,
      90,    -1,    -1,    -1,    94,    95,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
     120,   121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   142,   143,     5,   145,    -1,    -1,    -1,   149,
     150,   151,   152,    14,    -1,   155,    -1,    18,    19,    -1,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,
      -1,    -1,    -1,    94,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,   104,   105,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,    -1,   116,   117,   118,    -1,   120,
     121,   122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   142,   143,     5,   145,    -1,    -1,    -1,   149,   150,
     151,   152,    14,    -1,   155,    -1,    18,    19,    -1,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    87,    88,    89,    90,    -1,
      -1,    -1,    94,    95,    96,    97,    98,    99,   100,    -1,
      -1,    -1,   104,   105,   106,   107,   108,   109,    -1,   111,
     112,   113,   114,    -1,   116,   117,   118,    -1,   120,   121,
     122,    -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,   143,     5,   145,    -1,    -1,    -1,   149,   150,   151,
     152,    14,    -1,   155,    -1,    18,    19,    -1,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      83,    -1,    -1,    -1,    87,    88,    89,    90,    -1,    -1,
      -1,    94,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,   108,   109,    -1,   111,   112,
     113,   114,    10,   116,   117,   118,    -1,   120,   121,   122,
      -1,    -1,    -1,   126,    -1,    -1,   129,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,
     143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    -1,    84,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,    -1,
      -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
      -1,    -1,    -1,    -1,   152,   153,   154,   155,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    21,    -1,    -1,    -1,   130,    -1,    -1,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    -1,    84,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
      -1,    -1,    -1,    -1,   152,   153,   154,   155,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    -1,    -1,    -1,   159,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    -1,
      84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,
     154,   155,    -1,    -1,    -1,   159,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,
     155,    -1,    -1,    -1,   159,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    -1,    84,    85,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,
      -1,    -1,    -1,   159,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    -1,
      -1,   158,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,   155,    -1,    -1,   158,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,    -1,    -1,   158,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    -1,    -1,   158,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,
     155,    -1,    -1,   158,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    -1,
      -1,   158,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,   155,    -1,    -1,   158,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,    -1,    -1,   158,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    -1,    -1,   158,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,
     155,    -1,    -1,   158,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    -1,
      -1,   158,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,   155,    -1,    -1,   158,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,    -1,    -1,   158,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    -1,    -1,   158,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,
     155,    -1,   157,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    -1,    84,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
      -1,    -1,    -1,    -1,   152,   153,   154,   155,    -1,   157,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,    -1,   157,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    -1,
      84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,
     154,   155,    -1,   157,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    -1,
     157,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     130,    -1,    -1,   133,   134,   135,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,    -1,    -1,    -1,
      -1,    -1,   152,   153,   154,   155,    -1,   157,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    -1,   157,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    -1,    84,    85,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,
      -1,   157,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,   155,    -1,   157,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,   134,   135,    -1,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,
     152,   153,   154,   155,    -1,   157,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    -1,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,
     155,    -1,   157,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    -1,    84,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
      -1,    -1,    -1,    -1,   152,   153,   154,   155,    -1,   157,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,    -1,   157,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    -1,
      84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,
     154,   155,   156,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    -1,    84,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
      -1,    -1,    -1,    -1,   152,   153,   154,   155,   156,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,
     152,   153,   154,   155,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,
     152,   153,   154,   155,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,
     152,   153,   154,   155,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,
     152,   153,   154,   155,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,
     152,   153,   154,   155,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    -1,    84,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,    -1,    -1,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,   101,
     102,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,   130,    84,
      85,    86,   134,   135,    -1,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,   101,   102,    -1,   104,
     152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    51,    52,    -1,    -1,    -1,   152,   153,   154,
     155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,   102,    -1,    -1,    69,    -1,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,
      -1,    -1,    51,    52,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      -1,    84,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,    -1,    51,    52,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,   155,    -1,    74,    75,
      76,    77,    78,    79,    80,    81,    82,   130,    84,    85,
      86,    -1,    51,    52,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,   144,   145,
     146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,    -1,   152,   153,   154,   155
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    33,    34,    35,    38,
      39,    44,    46,    47,    48,    51,    52,    63,    64,    65,
      66,    67,    68,    83,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   105,   106,
     107,   108,   109,   111,   112,   113,   114,   116,   117,   118,
     120,   121,   122,   126,   129,   131,   142,   143,   145,   149,
     150,   151,   152,   155,   157,   161,   162,   165,   166,   167,
     170,   171,   176,   179,   180,   183,   185,   186,   193,   194,
     205,   209,   210,   211,   213,   214,   216,   220,   222,   223,
     224,   157,    14,    27,   114,   152,   193,   210,   215,   219,
     220,   221,   108,   114,   155,   193,   194,   114,   152,   172,
     173,   176,   173,   221,   155,   155,   155,    88,   108,   113,
     114,   155,   203,   157,   157,   157,   221,   221,   221,   221,
      34,   108,   175,   177,   108,   114,   175,   157,   155,   152,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   108,   109,   114,   221,   173,   173,   173,   221,   221,
     221,   221,   221,   221,     1,   184,   221,   155,   155,   223,
     155,   221,   221,   108,   109,   114,   221,   221,   221,   156,
     172,   174,   176,   158,   217,   218,   221,     0,   162,    37,
     157,    14,   108,   114,   110,   115,    45,    49,   119,   125,
      14,    27,   108,   114,   193,   211,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    84,    85,    86,   101,   102,   103,   104,   130,
     133,   134,   135,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   152,   153,   154,   155,   157,   156,   217,
     221,    14,    14,   193,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      84,    85,    86,   101,   102,   103,   104,   130,   133,   134,
     135,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   152,   153,   154,   155,   215,   221,   108,   110,   155,
     156,   174,    11,     9,   157,   221,   221,   184,   155,   155,
     155,   184,   184,    21,    21,   108,   114,   155,    10,    31,
      32,   173,   178,   134,   134,   155,   221,   108,   163,   164,
     155,   155,   155,   158,   184,   221,   184,   156,   172,   176,
     133,   158,   136,   158,   108,   114,   155,   193,   194,   114,
     155,   203,   155,   152,   157,   108,   114,    42,   187,   187,
     114,   155,   203,   155,    14,   114,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   123,   124,
     127,   128,   127,   193,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   104,   221,   221,   184,   156,    14,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   123,   124,   127,   128,   127,   193,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   104,   221,
     221,   184,   158,   184,   156,   155,   155,   158,   158,   157,
     184,   158,   158,   221,   155,   134,   134,   221,   155,   155,
     155,   221,   221,   221,   158,   134,   156,   164,   184,   184,
     184,   158,   158,   158,   218,   221,   215,   108,   114,   110,
     115,   155,   184,   184,   184,    14,   114,   156,   166,   167,
     168,   169,   170,   171,   185,   186,   193,   205,   210,   213,
     214,   152,   152,    24,    25,    26,    27,   108,   114,   188,
     189,   152,   157,   152,   157,   155,   184,   184,   184,   114,
     155,   203,   155,   136,   156,   159,   221,   104,   159,   158,
     136,   156,   159,   221,   104,   159,   158,   158,   221,   184,
     173,   173,   184,   158,     4,   212,   212,    10,   221,   221,
     221,   158,   221,   221,   221,   157,   157,   158,   152,   221,
     158,   158,   158,   136,   157,   206,   158,   184,   158,   158,
     158,   155,   157,   156,   169,    14,    14,   193,   190,   191,
     193,   190,   108,   114,   108,   114,   108,   114,   108,   114,
     133,    24,    25,    26,    27,    34,   156,   170,   192,   195,
     196,   197,   204,   209,   210,   156,   192,   184,   158,   158,
     158,   155,   184,   184,   184,   221,   159,   159,   221,   159,
     159,   158,   158,    43,   157,   212,   193,   194,   172,   172,
     155,   158,   157,   157,   177,   158,   158,   158,    36,    40,
      41,   181,   182,   157,   108,   114,   207,   208,   212,   158,
     172,   172,   206,   184,    14,   156,   191,   108,   156,   189,
     112,   152,   200,   201,   152,   201,   152,   201,    34,   152,
     201,   156,   170,   195,   196,   197,   204,   108,   193,   203,
     156,   158,   212,   212,   206,   184,   158,   158,   158,   157,
     173,   173,   184,   172,   221,   173,   173,   155,    74,    76,
      77,    81,    82,   127,   140,   141,   221,   136,   156,   182,
     155,   155,   133,   172,   172,   172,   158,   134,   155,   157,
     114,    27,    44,   108,   156,   170,   193,   194,   198,   199,
     202,   133,   157,   156,   202,   157,   156,   202,   157,   156,
     202,   157,   203,   184,   212,   172,   172,   212,   158,   172,
     172,   206,   158,   158,   221,   221,   221,   221,   127,   127,
     136,   221,   221,   136,   174,   184,   184,   208,   221,   184,
     108,   193,   134,   157,   108,   112,   156,   199,   200,   156,
     156,   156,   184,   158,   172,   157,   172,   172,   157,   172,
     173,   158,   136,   136,   136,   136,   136,   174,   136,   136,
     174,   158,   158,   157,   158,   134,   157,   108,   221,   134,
     155,   157,   134,   155,   157,   158,   206,   177,   174,   174,
     174,   174,   174,   174,   174,   157,   221,   134,   155,   157,
     157,   221,   184,   221,   184,   206,   212,   173,   157,   221,
     184,   157,   158,   157,   158,   157,   172,   157,   172,   157,
     158,   157,   157,   157
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   160,   161,   161,   162,   162,   162,   162,   162,   162,
     162,   162,   162,   162,   162,   162,   162,   163,   163,   164,
     165,   165,   166,   166,   166,   166,   166,   166,   166,   167,
     167,   167,   168,   168,   169,   169,   169,   169,   169,   169,
     169,   169,   169,   170,   170,   171,   171,   172,   172,   173,
     173,   174,   174,   174,   174,   175,   175,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   177,   177,   178,   178,   178,   179,   179,   180,   181,
     181,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   183,   184,   184,   184,   185,   185,   186,   186,   186,
     186,   186,   186,   187,   187,   188,   188,   189,   189,   189,
     189,   189,   189,   189,   189,   189,   189,   190,   190,   191,
     191,   191,   192,   192,   192,   192,   192,   192,   192,   192,
     192,   192,   193,   193,   193,   193,   193,   193,   194,   194,
     195,   195,   195,   196,   196,   196,   196,   196,   196,   197,
     197,   197,   198,   198,   198,   198,   198,   199,   199,   199,
     199,   199,   199,   199,   199,   199,   199,   200,   200,   201,
     201,   202,   202,   203,   203,   203,   204,   204,   204,   204,
     205,   205,   205,   205,   205,   205,   206,   206,   207,   207,
     208,   208,   209,   209,   210,   210,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   212,   212,   213,   213,   213,
     213,   214,   214,   214,   214,   215,   215,   216,   216,   217,
     217,   217,   218,   219,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     221,   221,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     223,   223,   224,   224,   224,   224,   224
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     4,     1,     1,     2,     4,
       0,     1,     4,     3,     4,     3,     4,     4,     5,     5,
       3,     4,     1,     2,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     5,     6,     5,     6,     3,     2,     1,
       1,     1,     1,     2,     2,     0,     1,     1,     2,     5,
       1,     2,     3,     2,     2,     2,     3,    11,     7,     5,
       7,     5,     7,     9,     7,     2,     2,     2,     2,     1,
       2,     0,     2,     4,     4,     4,     1,     2,     7,     1,
       2,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     5,     4,     4,     3,     4,     3,     3,
       2,     7,     0,     1,     1,     6,     6,     6,     6,     4,
       4,     5,     5,     2,     0,     1,     3,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     3,
       5,     6,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     2,     2,     2,     0,     1,
       3,     4,     3,     3,     4,     3,     3,     4,     3,     3,
       4,     3,     4,     3,     6,     5,     7,     3,     5,     6,
       3,     5,     6,     2,     4,     1,     1,     1,     2,     1,
       3,     1,     2,     2,     2,     1,     7,     7,     7,     7,
       8,     8,     8,     8,     7,     7,     2,     0,     1,     3,
       4,     4,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     0,     6,     6,     7,
       7,     7,     7,     8,     8,     3,     2,     3,     2,     1,
       3,     2,     3,     3,     1,     1,     3,     1,     2,     2,
       2,     3,     2,     3,     4,     1,     1,     1,     1,     1,
       8,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     4,     3,
       1,     2,     2,     2,     2,     2,     5,     5,     5,     2,
       1,     3,     2,     6,     6,     7,     7,     1,     1,     2,
       2,     4,     1,     1,     1,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     5,     2,     2,     4,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     5,     4,     4,     4,     3,
       3,     2,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       2,     2,     4,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     5,     4,     4,     4,     3,     3,     2,
       1,     2,     1,     1,     1,     1,     1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static unsigned
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  unsigned res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       , yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
          case 108: /* "identifier"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5958 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 109: /* "complex type identifier"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5964 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 110: /* "variable reference"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5970 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 111: /* "backquote expression"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5976 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 112: /* "in-object member reference"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5982 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 113: /* "identifier or keyword used as function or method identifier"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5988 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 114: /* "namespace or class-scoped reference"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5994 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 115: /* "namespace-scoped global variable reference"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 6000 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 116: /* "context reference"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 6006 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 117: /* "named context reference"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 6012 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 118: /* "cast operator"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 6018 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 119: /* "simple class declaration"  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 6024 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 120: /* "date/time value"  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); }
#line 6030 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 121: /* "quoted string"  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6036 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 122: /* "binary constant value"  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); }
#line 6042 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 123: /* "regular expression substitution expression"  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).RegexSubst); }
#line 6048 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 124: /* "transliteration expression"  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).Trans); }
#line 6054 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 125: /* "scoped class declaration"  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).nscope); }
#line 6060 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 126: /* "call to base class method"  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).nscope); }
#line 6066 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 127: /* "regular expression"  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).Regex); }
#line 6072 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 128: /* "regular expression extraction expression"  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).Regex); }
#line 6078 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 129: /* "implicit argument reference"  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); }
#line 6084 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 130: /* "keyword used as hash key or object member reference"  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6090 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 131: /* "%try-module error token"  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).trymod); }
#line 6096 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 166: /* gvardecl  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).gv); }
#line 6102 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 167: /* top_namespace_decl  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).ns); }
#line 6108 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 168: /* namespace_decls  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); }
#line 6114 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 169: /* namespace_decl  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); }
#line 6120 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 170: /* unscoped_const_decl  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).constnode); }
#line 6126 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 171: /* scoped_const_decl  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).constnode); }
#line 6132 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 172: /* block  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 6138 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 173: /* statement_or_block  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 6144 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 174: /* statements  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 6150 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 175: /* optname  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 6156 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 176: /* statement  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 6162 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 177: /* context_mods  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).cmods); }
#line 6168 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 178: /* context_mod  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).cmod); }
#line 6174 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 179: /* return_statement  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 6180 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 180: /* switch_statement  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 6186 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 181: /* case_block  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).switchstmt); }
#line 6192 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 182: /* case_code  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).casenode); }
#line 6198 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 183: /* try_statement  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 6204 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 184: /* myexp  */
#line 1790 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 6210 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 185: /* hashdecl_def  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hashdecldef); }
#line 6216 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 186: /* class_def  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).classdef); }
#line 6222 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 187: /* inheritance_list  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclist); }
#line 6228 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 188: /* superclass_list  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclist); }
#line 6234 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 189: /* superclass  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclnode); }
#line 6240 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 190: /* hashdecl_attrs  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).hashdeclpriv)) ((*yyvaluep).hashdeclpriv)->deref(); }
#line 6246 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 191: /* hashdecl_member  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberinfo); }
#line 6252 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 192: /* class_attributes  */
#line 1787 "../lib/parser.ypp" /* yacc.c:1257  */
      { qore_class_private::get(*((*yyvaluep).qoreclass))->deref(); }
#line 6258 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 193: /* uncqtypedef  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsertype); }
#line 6264 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 194: /* qtypedef  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsertype); }
#line 6270 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 195: /* internal_member_list  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 6276 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 196: /* private_member_list  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 6282 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 197: /* public_member_list  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 6288 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 198: /* classvardecl  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).classvarinfo); }
#line 6294 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 199: /* member2  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberinfo); }
#line 6300 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 200: /* member  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberinfo); }
#line 6306 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 201: /* member_list  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 6312 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 202: /* member_list2  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 6318 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 203: /* ident_openparen  */
#line 1788 "../lib/parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 6324 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 204: /* inline_methoddef  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).methodnode); }
#line 6330 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 205: /* outofline_methoddef  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).methoddef); }
#line 6336 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 206: /* base_constructor_list  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcalist); }
#line 6342 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 207: /* base_constructors  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcalist); }
#line 6348 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 208: /* base_constructor  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcanode); }
#line 6354 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 212: /* return_value  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).returnTypeInfo); }
#line 6360 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 213: /* sub_def  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsefunc); }
#line 6366 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 214: /* scoped_sub_def  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sparsefunc); }
#line 6372 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 215: /* list  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 6378 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 216: /* list_n  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 6384 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 217: /* hash  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hash); }
#line 6390 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 218: /* hash_element  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hashelement); }
#line 6396 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 219: /* alt_hash  */
#line 1786 "../lib/parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hash); }
#line 6402 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 220: /* exp_c  */
#line 1790 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 6408 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 221: /* exp  */
#line 1790 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 6414 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 222: /* exp_n  */
#line 1790 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 6420 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 223: /* string  */
#line 1789 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6426 "../lib/parser.cpp" /* yacc.c:1257  */
        break;

    case 224: /* scalar  */
#line 1790 "../lib/parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 6432 "../lib/parser.cpp" /* yacc.c:1257  */
        break;


      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yyls1, yysize * sizeof (*yylsp),
                    &yystacksize);

        yyls = yyls1;
        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 1799 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 6728 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 5:
#line 1802 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyvsp[0].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 6738 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 6:
#line 1807 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddClass((yyvsp[0].classdef)->loc, *((yyvsp[0].classdef)->name), (yyvsp[0].classdef)->oc);

           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error((yyvsp[0].classdef)->loc, "illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
           delete (yyvsp[0].classdef);
        }
#line 6751 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 7:
#line 1815 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddHashDecl((yyvsp[0].hashdecldef)->loc, *((yyvsp[0].hashdecldef)->name), (yyvsp[0].hashdecldef)->takeHashDecl());
           delete (yyvsp[0].hashdecldef);
        }
#line 6760 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 8:
#line 1819 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 6771 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 9:
#line 1825 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 6780 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 10:
#line 1829 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].methoddef)->loc, "method", (yyvsp[0].methoddef)->name.ostr);
           (yyvsp[0].methoddef)->parseAddToClassAndDel();
        }
#line 6790 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 11:
#line 1834 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[0].statement)) {
              if ((yyvsp[0].statement)->isParseDeclaration())
                 delete (yyvsp[0].statement);
              else
                 qore_program_private::addStatement(*(getProgram()), (yyvsp[0].statement));
           }
        }
#line 6803 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 13:
#line 1843 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // set line range
           (yyvsp[-1].sblock)->loc.start_line = (yylsp[-2]).first_line;
           (yyvsp[-1].sblock)->loc.end_line = (yylsp[-1]).last_line;
           qore_program_private::addStatement(*(getProgram()), (yyvsp[-1].sblock));
        }
#line 6814 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 14:
#line 1849 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[0]).first_line, (yylsp[0]).last_line);
           qore_root_ns_private::parseAddNamespace((yyvsp[0].ns));
           // see if ns declaration is legal
           if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
              parse_error(loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
        }
#line 6826 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 15:
#line 1856 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");
           else {
              QoreUserModuleDefContextHelper* uqmd = static_cast<QoreUserModuleDefContextHelper*>(qmd);
              uqmd->close();
           }
           // registered internally
        }
#line 6841 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 16:
#line 1866 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           bool has_dollar = (yyvsp[0].trymod)->var[0] == '$';
           if (!has_dollar) {
              if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].trymod)->var);
           }
           else {
              (yyvsp[0].trymod)->fixName();
              if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[0].trymod)->var);
           }

           if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
              parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
           }
           else {
              VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].trymod)->takeName());
              QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), left, (yyvsp[0].trymod)->takeExceptionHash());
              qore_program_private::addStatement(*(getProgram()), new ExpressionStatement((yylsp[0]).first_line, (yylsp[0]).last_line, exp));
           }
           delete (yyvsp[0].trymod);
        }
#line 6868 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 17:
#line 1891 "../lib/parser.ypp" /* yacc.c:1646  */
    {
        }
#line 6875 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 18:
#line 1893 "../lib/parser.ypp" /* yacc.c:1646  */
    {
        }
#line 6882 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 19:
#line 1898 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[-1]).last_line);
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), loc, QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[-3].string), get_type_name((yyvsp[-1].node)));
           else
              qmd->set(loc, (yyvsp[-3].string), (yyvsp[-1].node));

           free((yyvsp[-3].string));
           (yyvsp[-1].node)->deref(0);
        }
#line 6898 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 20:
#line 1912 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.b) = false; }
#line 6904 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 21:
#line 1913 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.b) = true;
        }
#line 6912 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 22:
#line 1919 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
           delete (yyvsp[-1].parsertype);
        }
#line 6925 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 23:
#line 1927 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 6936 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 24:
#line 1933 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
           delete (yyvsp[-1].parsertype);
        }
#line 6947 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 25:
#line 1939 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarSingleDecl(QoreProgramLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 6955 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 26:
#line 1942 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
           (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
           delete (yyvsp[-1].parsertype);
        }
#line 6968 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 27:
#line 1950 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
           (yyval.gv) = new GVarSingleDecl(QoreProgramLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
           delete (yyvsp[-1].parsertype);
        }
#line 6978 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 28:
#line 1955 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarListDecl(QoreProgramLocation((yyvsp[-4].b) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-1].parse_list), (yyvsp[-4].b));
        }
#line 6986 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 29:
#line 1961 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
           qore_ns_private* p = new qore_ns_private(loc);
           check_nsmod(loc, (yyvsp[-4].i4), *p);
           (yyvsp[-1].nsnlist)->add(*p);
           delete (yyvsp[-1].nsnlist);
           (yyval.ns) = p->ns;
        }
#line 6999 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 30:
#line 1969 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-2].i4) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
           qore_ns_private* p = new qore_ns_private(loc);
           check_nsmod(loc, (yyvsp[-2].i4), *p);
           (yyval.ns) = p->ns;
        }
#line 7010 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 31:
#line 1975 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
           qore_ns_private* p = new qore_ns_private(loc);
           check_nsmod(loc, (yyvsp[-3].i4), *p);
           (yyval.ns) = p->ns;
        }
#line 7021 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 32:
#line 1984 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7031 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 33:
#line 1989 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsnlist) = (yyvsp[-1].nsnlist);
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7041 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 34:
#line 1997 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7051 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 35:
#line 2002 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7059 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 36:
#line 2005 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].classdef));
           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "illegal class definition \"%s\" (conflicts with parse option PO_NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
        }
#line 7070 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 37:
#line 2011 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].hashdecldef));
        }
#line 7078 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 38:
#line 2014 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].parsefunc));
        }
#line 7086 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 39:
#line 2017 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].sparsefunc));
        }
#line 7096 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 40:
#line 2022 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[-1].gv));
        }
#line 7104 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 41:
#line 2025 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].ns));
           // see if ns declaration is legal
           if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
              parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
        }
#line 7115 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 42:
#line 2031 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].methoddef));
        }
#line 7123 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 43:
#line 2037 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].node));
        }
#line 7131 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 44:
#line 2040 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].node), true);
        }
#line 7139 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 45:
#line 2046 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].node));
        }
#line 7147 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 46:
#line 2049 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.constnode) = new ConstNode(QoreProgramLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].node), true);
        }
#line 7155 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 47:
#line 2056 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7161 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 48:
#line 2059 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[-1]).first_line, (yylsp[-1]).last_line); }
#line 7167 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 49:
#line 2064 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 7173 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 50:
#line 2067 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = (yyvsp[0].sblock); }
#line 7179 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 51:
#line 2072 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 7185 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 52:
#line 2074 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock)); }
#line 7191 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 53:
#line 2076 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].sblock)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7197 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 54:
#line 2078 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].statement)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7203 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 55:
#line 2083 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.string) = 0; }
#line 7209 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 56:
#line 2084 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.string) = (yyvsp[0].string); }
#line 7215 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 57:
#line 2088 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 7221 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 58:
#line 2089 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // if the expression has no effect and it's not a variable declaration
           qore_type_t t = (yyvsp[-1].node) ? (yyvsp[-1].node)->getType() : 0;
           bool ok = false;
           if (t == NT_PARSE_LIST) {
              QoreParseListNode* l = reinterpret_cast<QoreParseListNode*>((yyvsp[-1].node));
              // rewrite expression if it's a list without parentheses under certain conditions
              (yyvsp[-1].node) = check_rewrite_list(l);

              if (l->isVariableList())
                 ok = true;
           }

           if (!ok && !node_has_effect((yyvsp[-1].node)) && (t != NT_VARREF || !reinterpret_cast<VarRefNode*>((yyvsp[-1].node))->parseIsDecl()))
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), "statement has no effect (%s)", (yyvsp[-1].node) ? (yyvsp[-1].node)->getTypeName() : "NOTHING");
           ignore_return_value((yyvsp[-1].node));
           (yyval.statement) = new ExpressionStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node));
        }
#line 7244 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 59:
#line 2108 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           NamedScope *ns = new NamedScope((yyvsp[-4].string));
           assert(ns->size() > 1);
           printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[-1]).last_line);
           (yyval.statement) = new ExpressionStatement((yylsp[-4]).first_line, (yylsp[-4]).last_line, new StaticMethodCallNode(loc, ns, make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node))));
        }
#line 7256 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 60:
#line 2116 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 7262 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 61:
#line 2117 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new RethrowStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7270 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 62:
#line 2120 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new ThrowStatement((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node));
        }
#line 7278 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 63:
#line 2123 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Unconditional);
        }
#line 7286 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 64:
#line 2126 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Success);
        }
#line 7294 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 65:
#line 2129 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Error);
        }
#line 7302 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 66:
#line 2132 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new ContextStatement((yylsp[-2]).first_line, (yylsp[0]).last_line, 0, 0, (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 7310 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 67:
#line 2135 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new SummarizeStatement((yylsp[-10]).first_line, (yylsp[0]).last_line, (yyvsp[-9].string), (yyvsp[-7].node), (yyvsp[-1].cmods), (yyvsp[0].sblock), (yyvsp[-3].node));
        }
#line 7318 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 68:
#line 2138 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new ContextStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].string), (yyvsp[-3].node), (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 7326 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 69:
#line 2141 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new IfStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].sblock));
        }
#line 7334 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 70:
#line 2144 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new IfStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-4].node), (yyvsp[-2].sblock), (yyvsp[0].sblock));
        }
#line 7342 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 71:
#line 2147 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new WhileStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].sblock));
        }
#line 7350 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 72:
#line 2150 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new DoWhileStatement((yylsp[-6]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), (yyvsp[-5].sblock));
        }
#line 7358 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 73:
#line 2153 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new ForStatement((yylsp[-8]).first_line, (yylsp[0]).last_line, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].sblock));
        }
#line 7366 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 74:
#line 2156 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.statement) = new ForEachStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].node), (yyvsp[-2].node), (yyvsp[0].sblock));
        }
#line 7374 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 75:
#line 2159 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[-1].statement); }
#line 7380 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 76:
#line 2160 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // see if thread exit is allowed
           if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), "illegal use of \"thread_exit\" (conflicts with parse option PO_NO_THREAD_CONTROL)");

           (yyval.statement) = new ThreadExitStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7392 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 77:
#line 2167 "../lib/parser.ypp" /* yacc.c:1646  */
    {
          (yyval.statement) = new BreakStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7400 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 78:
#line 2170 "../lib/parser.ypp" /* yacc.c:1646  */
    {
          (yyval.statement) = new ContinueStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7408 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 79:
#line 2173 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 7414 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 80:
#line 2174 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = 0; }
#line 7420 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 81:
#line 2179 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.cmods) = 0; }
#line 7426 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 82:
#line 2180 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           if (!(yyvsp[-1].cmods))
              (yyval.cmods) = new ContextModList((yyvsp[0].cmod));
           else {
              (yyvsp[-1].cmods)->addContextMod((yyvsp[0].cmod));
              (yyval.cmods) = (yyvsp[-1].cmods);
           }
        }
#line 7439 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 83:
#line 2192 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[-1].node)); }
#line 7445 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 84:
#line 2194 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[-1].node)); }
#line 7451 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 85:
#line 2196 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[-1].node)); }
#line 7457 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 86:
#line 2200 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new ReturnStatement((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 7463 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 87:
#line 2202 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new ReturnStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].node)); }
#line 7469 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 88:
#line 2207 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[-1].switchstmt)->setSwitch((yyvsp[-4].node));
           (yyval.statement) = (yyvsp[-1].switchstmt);
           (yyval.statement)->loc.start_line = (yylsp[-6]).first_line;
           (yyval.statement)->loc.end_line = (yylsp[0]).last_line;
        }
#line 7480 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 89:
#line 2217 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.switchstmt) = new SwitchStatement((yyvsp[0].casenode));
        }
#line 7488 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 90:
#line 2221 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[-1].switchstmt)->addCase((yyvsp[0].casenode));
           (yyval.switchstmt) = (yyvsp[-1].switchstmt);
        }
#line 7497 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 91:
#line 2229 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_case(loc, ">=", (yyvsp[-2].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].node), (yyvsp[0].sblock), QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 7507 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 92:
#line 2235 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           check_case(loc, ">=", (yyvsp[-1].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].node), 0, QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 7517 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 93:
#line 2242 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_case(loc, "<=", (yyvsp[-2].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].node), (yyvsp[0].sblock), QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 7527 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 94:
#line 2248 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           check_case(loc, "<=", (yyvsp[-1].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].node), 0, QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 7537 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 95:
#line 2255 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_case(loc, "==", (yyvsp[-2].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].node), (yyvsp[0].sblock), QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 7547 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 96:
#line 2261 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           check_case(loc, "==", (yyvsp[-1].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].node), 0, QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 7557 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 97:
#line 2268 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_case(loc, "<", (yyvsp[-2].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].node), (yyvsp[0].sblock), QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 7567 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 98:
#line 2274 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           check_case(loc, "<", (yyvsp[-1].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].node), 0, QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 7577 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 99:
#line 2281 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_case(loc, ">", (yyvsp[-2].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].node), (yyvsp[0].sblock), QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 7587 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 100:
#line 2287 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           check_case(loc, ">", (yyvsp[-1].node));
           (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].node), 0, QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 7597 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 101:
#line 2294 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7606 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 102:
#line 2299 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), 0);
        }
#line 7615 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 103:
#line 2305 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7624 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 104:
#line 2310 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-1].Regex), 0);
        }
#line 7633 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 105:
#line 2316 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7642 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 106:
#line 2321 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), 0);
        }
#line 7651 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 107:
#line 2327 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           check_case(loc, 0, (yyvsp[-2].node));
           (yyval.casenode) = new CaseNode(loc, (yyvsp[-2].node), (yyvsp[0].sblock));
        }
#line 7661 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 108:
#line 2333 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[0]).last_line);
           check_case(loc, 0, (yyvsp[-1].node));
           (yyval.casenode) = new CaseNode(loc, (yyvsp[-1].node), 0);
        }
#line 7671 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 109:
#line 2340 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNode(loc, 0, (yyvsp[0].sblock));
        }
#line 7680 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 110:
#line 2345 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[0]).last_line);
           (yyval.casenode) = new CaseNode(loc, 0, 0);
        }
#line 7689 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 111:
#line 2352 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           char* param = 0;
           const QoreTypeInfo* typeInfo = nullptr;
           QoreParseTypeInfo* parseTypeInfo = nullptr;
           if ((yyvsp[-2].node)) {
              if ((yyvsp[-2].node)->getType() == NT_VARREF) {
                 VarRefNode *varRefNode = static_cast<VarRefNode*>((yyvsp[-2].node));
                 param = varRefNode->takeName();
                 if (varRefNode->isDecl()) {
                    VarRefDeclNode* varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    parseTypeInfo = varRefDeclNode->takeParseTypeInfo();
                    if (!parseTypeInfo)
                       typeInfo = varRefDeclNode->getTypeInfo();
                    /*
                    if (varRefDeclNode->getParseTypeInfo() || QoreTypeInfo::parseAccepts(varRefDeclNode->getTypeInfo(), hashTypeInfo) == QTI_NOT_EQUAL) {
                       parse_error(QoreProgramLocation(@1.first_line, @7.last_line), "the type of catch parameter '%s' must be 'hash'", param);
                    }
                    else
                      typeInfo = varRefDeclNode->getTypeInfo();
                    */
                 }
              } else if ((yyvsp[-2].node)->getType() == NT_BAREWORD) {
                 param = reinterpret_cast<BarewordNode*>((yyvsp[-2].node))->takeString();
                 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(QoreProgramLocation((yylsp[-6]).first_line, (yylsp[0]).last_line), "local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
              } else
                 parse_error(QoreProgramLocation((yylsp[-6]).first_line, (yylsp[0]).last_line), "only one parameter accepted in catch block for exception hash");
              (yyvsp[-2].node)->deref(0);
           }
           QoreProgramLocation vloc((yyvsp[-2].node) ? (yylsp[-2]).first_line : 0, (yyvsp[-2].node) ? (yylsp[-2]).last_line : 0);
           (yyval.statement) = new TryStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].sblock), (yyvsp[0].sblock), param, typeInfo, parseTypeInfo, vloc);
        }
#line 7726 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 112:
#line 2386 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 7732 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 113:
#line 2387 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7738 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 114:
#line 2388 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 7744 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 115:
#line 2392 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
           (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 7754 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 116:
#line 2397 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
           (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 7764 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 117:
#line 2405 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
           check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
           qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].string), (yyvsp[-1].qoreclass));
        }
#line 7775 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 118:
#line 2411 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "class", (yyvsp[-4].nscope)->ostr);
           check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].nscope), (yyvsp[-1].qoreclass));
           qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
        }
#line 7788 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 119:
#line 2419 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[-3].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].string), qc);
        }
#line 7802 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 120:
#line 2428 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "class", (yyvsp[-2].nscope)->ostr);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[-3].i4), *qc);
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
        }
#line 7818 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 121:
#line 2439 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[-4].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].string), qc);
        }
#line 7832 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 122:
#line 2448 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
           // see if strong encapsulation is enabled
           check_strong_encapsulation(loc, "class", (yyvsp[-3].nscope)->ostr);
           // class name is set automatically from name saved in scanner
           QoreClass* qc = new QoreClass;
           qore_class_private::get(*qc)->loc = loc;
           check_classmod(loc, (yyvsp[-4].i4), *qc);
           (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
        }
#line 7848 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 123:
#line 2462 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclist) = (yyvsp[0].sclist);
        }
#line 7856 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 124:
#line 2465 "../lib/parser.ypp" /* yacc.c:1646  */
    { // NOTHING
           (yyval.sclist) = 0;
        }
#line 7864 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 125:
#line 2471 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclist) = new BCList((yyvsp[0].sclnode));
        }
#line 7872 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 126:
#line 2474 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[-2].sclist)->push_back((yyvsp[0].sclnode));
           (yyval.sclist) = (yyvsp[-2].sclist);
        }
#line 7881 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 127:
#line 2481 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), Public);
        }
#line 7889 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 128:
#line 2484 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), new NamedScope((yyvsp[0].string)), Public);
        }
#line 7897 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 129:
#line 2487 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), Public);
        }
#line 7905 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 130:
#line 2490 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), new NamedScope((yyvsp[0].string)), Public);
        }
#line 7913 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 131:
#line 2493 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), Private);
        }
#line 7921 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 132:
#line 2496 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), new NamedScope((yyvsp[0].string)), Private);
        }
#line 7929 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 133:
#line 2499 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), Private);
        }
#line 7937 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 134:
#line 2502 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), new NamedScope((yyvsp[0].string)), Private);
        }
#line 7945 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 135:
#line 2505 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), Internal);
        }
#line 7953 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 136:
#line 2508 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.sclnode) = new BCNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), new NamedScope((yyvsp[0].string)), Internal);
        }
#line 7961 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 137:
#line 2514 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[0]).first_line, (yylsp[0]).last_line);
           (yyval.hashdeclpriv) = new typed_hash_decl_private(loc);
           if ((yyvsp[0].memberinfo)) {
              (yyval.hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
              delete (yyvsp[0].memberinfo);
           }
        }
#line 7974 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 138:
#line 2522 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[0].memberinfo)) {
              if ((yyvsp[-1].hashdeclpriv)->hasMember((yyvsp[0].memberinfo)->name)) {
                 parse_error((yyvsp[0].memberinfo)->loc, "duplicate hashdecl member declaration '%s'", (yyvsp[0].memberinfo)->name);
              }
              else {
                 // add new member to list
                 (yyvsp[-1].hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
              }
              delete (yyvsp[0].memberinfo);
           }

           (yyval.hashdeclpriv) = (yyvsp[-1].hashdeclpriv);
        }
#line 7993 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 139:
#line 2539 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
           delete (yyvsp[-2].parsertype);
        }
#line 8003 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 140:
#line 2544 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].node)));
           delete (yyvsp[-4].parsertype);
        }
#line 8013 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 141:
#line 2549 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

           if (!(yyvsp[-5].parsertype))
              parse_error(loc, "cannot call constructor without declaring the class");
           else if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));

           (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new HashDeclMemberInfo(loc, t, pti, new_call));

           delete (yyvsp[-5].parsertype);
        }
#line 8037 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 142:
#line 2571 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = (yyvsp[0].methodnode)->getLoc();
           (yyvsp[0].methodnode)->addAndDelete((yyval.qoreclass));
        }
#line 8047 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 143:
#line 2576 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
           (yyvsp[0].memberlist)->merge((yyval.qoreclass), Internal);
           delete (yyvsp[0].memberlist);
        }
#line 8058 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 144:
#line 2582 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
           (yyvsp[0].memberlist)->merge((yyval.qoreclass), Private);
           delete (yyvsp[0].memberlist);
        }
#line 8069 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 145:
#line 2588 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
           (yyvsp[0].memberlist)->merge((yyval.qoreclass), Public);
           delete (yyvsp[0].memberlist);
        }
#line 8080 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 146:
#line 2594 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.qoreclass) = new QoreClass;
           QoreProgramLocation loc((yylsp[0]).first_line, (yylsp[0]).last_line);
           qore_class_private::get(*(yyval.qoreclass))->loc = loc;
           qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
           delete (yyvsp[0].constnode);
        }
#line 8092 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 147:
#line 2601 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_class_private::get(*(yyvsp[-1].qoreclass))->loc.end_line = (yylsp[0]).last_line;
           (yyvsp[0].methodnode)->addAndDelete((yyvsp[-1].qoreclass));
           (yyval.qoreclass) = (yyvsp[-1].qoreclass);
        }
#line 8102 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 148:
#line 2606 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_class_private::get(*(yyvsp[-1].qoreclass))->loc.end_line = (yylsp[0]).last_line;
           (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Internal);
           (yyval.qoreclass) = (yyvsp[-1].qoreclass);
           delete (yyvsp[0].memberlist);
        }
#line 8113 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 149:
#line 2612 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_class_private::get(*(yyvsp[-1].qoreclass))->loc.end_line = (yylsp[0]).last_line;
           (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Private);
           (yyval.qoreclass) = (yyvsp[-1].qoreclass);
           delete (yyvsp[0].memberlist);
        }
#line 8124 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 150:
#line 2618 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_class_private::get(*(yyvsp[-1].qoreclass))->loc.end_line = (yylsp[0]).last_line;
           (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Public);
           (yyval.qoreclass) = (yyvsp[-1].qoreclass);
           delete (yyvsp[0].memberlist);
        }
#line 8135 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 151:
#line 2624 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_class_private::get(*(yyvsp[-1].qoreclass))->loc.end_line = (yylsp[0]).last_line;
           qore_class_private::parseAddConstant(*((yyval.qoreclass)), QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
           (yyval.qoreclass) = (yyvsp[-1].qoreclass);
           delete (yyvsp[0].constnode);
        }
#line 8146 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 152:
#line 2633 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), false);
        }
#line 8154 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 153:
#line 2636 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), false));
        }
#line 8162 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 154:
#line 2639 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = ParserTypeStruct::getType(QoreProgramLocation((yylsp[0]). first_line, (yylsp[0]).last_line), (yyvsp[0].string), false);
        }
#line 8170 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 155:
#line 2642 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), true);
        }
#line 8178 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 156:
#line 2645 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), true));
        }
#line 8186 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 157:
#line 2648 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = ParserTypeStruct::getType(QoreProgramLocation((yylsp[-1]). first_line, (yylsp[0]).last_line), (yyvsp[0].string), true);
        }
#line 8194 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 158:
#line 2655 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.parsertype) = 0; }
#line 8200 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 159:
#line 2656 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = (yyvsp[0].parsertype);
        }
#line 8208 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 160:
#line 2662 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8214 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 161:
#line 2663 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8220 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 162:
#line 2664 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8226 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 163:
#line 2668 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8232 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 164:
#line 2669 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8238 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 165:
#line 2670 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8244 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 166:
#line 2671 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8250 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 167:
#line 2672 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8256 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 168:
#line 2673 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8262 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 169:
#line 2677 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8268 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 170:
#line 2678 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8274 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 171:
#line 2679 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8280 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 172:
#line 2683 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[-1]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
           delete (yyvsp[-2].parsertype);
        }
#line 8290 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 173:
#line 2688 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[-1]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc));
        }
#line 8299 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 174:
#line 2692 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-5]).first_line, (yylsp[-1]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].node)));
           //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
           delete (yyvsp[-4].parsertype);
        }
#line 8310 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 175:
#line 2698 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[-1]).last_line);
           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, nullptr, nullptr, (yyvsp[-1].node)));
        }
#line 8319 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 176:
#line 2702 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-6]).first_line, (yylsp[-1]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

           if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));

           (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-4].string), new QoreVarInfo(loc, t, pti, new_call));

           delete (yyvsp[-5].parsertype);
        }
#line 8341 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 177:
#line 2722 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-2].parsertype) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
           delete (yyvsp[-2].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 8353 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 178:
#line 2729 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-4].parsertype) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].node)));
           delete (yyvsp[-4].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-3].string));
        }
#line 8365 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 179:
#line 2736 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = (yyvsp[-5].parsertype) ? ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)) : nullptr;

           if (!(yyvsp[-5].parsertype))
              parse_error(loc, "cannot call constructor without declaring the class");
           else if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti && pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));

           (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

           delete (yyvsp[-5].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-4].string));
        }
#line 8391 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 180:
#line 2757 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
           delete (yyvsp[-2].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 8403 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 181:
#line 2764 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].node)));
           delete (yyvsp[-4].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 8415 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 182:
#line 2771 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-5]).first_line, (yylsp[-1]).last_line);
           const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
           AbstractQoreNode* new_call = nullptr;
           QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

           if (!(yyvsp[-5].parsertype))
              parse_error(loc, "cannot call constructor without declaring the class");
           else if (t)
              parse_error(loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
           else if (pti->subtypes.size())
              new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));
           else
              new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].node)));

           (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

           delete (yyvsp[-5].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-4].string));
        }
#line 8441 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 183:
#line 2792 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc));
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 8452 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 184:
#line 2798 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[-1]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, nullptr, nullptr, (yyvsp[-1].node)));
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 8463 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 185:
#line 2804 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.memberinfo) = (yyvsp[0].classvarinfo);
        }
#line 8471 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 186:
#line 2807 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[0]).first_line, (yylsp[0]).last_line);
           if ((yyvsp[0].constnode)->pub)
              parse_error(loc, "cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[0].constnode)->name.ostr);
           (yyval.memberinfo) = new MemberInfo(loc, (yyvsp[0].constnode)->name.takeName(), (yyvsp[0].constnode)->value);
           delete (yyvsp[0].constnode);
        }
#line 8483 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 187:
#line 2817 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[0]).first_line, (yylsp[0]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[0].string), new QoreMemberInfo(loc));
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 8494 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 188:
#line 2823 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[0]).last_line);
           (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, nullptr, new QoreParseTypeInfo((yyvsp[0].string))));
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 8505 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 189:
#line 2832 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8513 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 190:
#line 2835 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-2].memberlist);
        }
#line 8522 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 191:
#line 2842 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8530 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 192:
#line 2845 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-1].memberlist);
        }
#line 8539 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 193:
#line 2852 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.string) = (yyvsp[-1].string);
        }
#line 8547 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 194:
#line 2855 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.string) = strdup("keys");
        }
#line 8555 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 195:
#line 2858 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.string) = (yyvsp[0].string);
        }
#line 8563 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 196:
#line 2864 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
           if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
           check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8579 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 197:
#line 2875 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
           if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
           delete (yyvsp[-5].parsertype);

           check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8599 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 198:
#line 2890 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
           if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8611 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 199:
#line 2897 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
           if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
           delete (yyvsp[-5].parsertype);

           check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8627 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 200:
#line 2911 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-7]).first_line, (yylsp[0]).last_line);
           if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }

           (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 8643 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 201:
#line 2922 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-7]).first_line, (yylsp[0]).last_line);
           if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error(loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error(loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
           delete (yyvsp[-6].parsertype);

           (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 8661 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 202:
#line 2935 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-7]).first_line, (yylsp[-1]).last_line);
           if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0);
        }
#line 8672 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 203:
#line 2941 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-7]).first_line, (yylsp[-1]).last_line);
           if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
              parse_error(loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
           delete (yyvsp[-6].parsertype);

           (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, 0);
        }
#line 8686 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 204:
#line 2950 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-6]).first_line, (yylsp[0]).last_line);
           (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 8695 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 205:
#line 2954 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
           delete (yyvsp[-6].parsertype);

           QoreProgramLocation loc((yylsp[-6]).first_line, (yylsp[0]).last_line);
           (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 8707 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 206:
#line 2964 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.bcalist) = (yyvsp[0].bcalist);
        }
#line 8715 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 207:
#line 2967 "../lib/parser.ypp" /* yacc.c:1646  */
    { // nothing
           (yyval.bcalist) = 0;
        }
#line 8723 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 208:
#line 2973 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.bcalist) = new BCAList((yyvsp[0].bcanode));
        }
#line 8731 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 209:
#line 2976 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[-2].bcalist)->push_back((yyvsp[0].bcanode));
           (yyval.bcalist) = (yyvsp[-2].bcalist);
        }
#line 8740 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 210:
#line 2983 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.bcanode) = new BCANode((yyvsp[-3].string), make_args(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].node)), (yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 8748 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 211:
#line 2986 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[-3].string)), make_args(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].node)), (yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 8756 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 212:
#line 2993 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = 0; }
#line 8762 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 213:
#line 2994 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.i4) = (yyvsp[0].i4);
        }
#line 8770 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 214:
#line 2999 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = (yyvsp[0].i4); }
#line 8776 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 215:
#line 3000 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           if (((yyvsp[-1].i4) | (yyvsp[0].i4)) == (yyvsp[-1].i4))
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "modifier given twice");
           (yyval.i4) = (yyvsp[-1].i4) | (yyvsp[0].i4);
        }
#line 8786 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 216:
#line 3008 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_PRIVATE; }
#line 8792 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 217:
#line 3009 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_PRIVATE; }
#line 8798 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 218:
#line 3010 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_INTERNAL; }
#line 8804 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 219:
#line 3011 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_STATIC; }
#line 8810 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 220:
#line 3012 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_SYNCED; }
#line 8816 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 221:
#line 3013 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_DEPRECATED; }
#line 8822 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 222:
#line 3014 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_PUBLIC; }
#line 8828 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 223:
#line 3015 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_FINAL; }
#line 8834 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 224:
#line 3016 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_ABSTRACT; }
#line 8840 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 225:
#line 3020 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           if (!(yyvsp[0].parsertype)) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "missing type declaration after 'returns'");
              (yyval.returnTypeInfo) = 0;
           }
           else {
              (yyval.returnTypeInfo) = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[0].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[0].parsertype)));
              delete (yyvsp[0].parsertype);
           }
        }
#line 8855 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 226:
#line 3031 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.returnTypeInfo) = 0;
        }
#line 8863 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 227:
#line 3037 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.parsefunc) = new ParseUserFunction(QoreProgramLocation((yylsp[-5]).first_line, (yylsp[0]).last_line), (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 8873 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 228:
#line 3042 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
           delete (yyvsp[-5].parsertype);

           (yyval.parsefunc) = new ParseUserFunction(QoreProgramLocation((yylsp[-5]).first_line, (yylsp[0]).last_line), (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, flags));
        }
#line 8887 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 229:
#line 3051 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-6]).first_line, (yylsp[0]).last_line);
           check_funcmod(loc, (yyvsp[-6].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[-6].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-6].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
        }
#line 8904 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 230:
#line 3063 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-6]).first_line, (yylsp[0]).last_line);
           check_funcmod(loc, (yyvsp[-6].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[-6].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
           delete (yyvsp[-5].parsertype);

           (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-6].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-6].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
        }
#line 8924 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 231:
#line 3081 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.sparsefunc) = new ParseScopedUserFunction(QoreProgramLocation((yylsp[-6]).first_line, (yylsp[0]).last_line), (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 8934 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 232:
#line 3086 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
           delete (yyvsp[-6].parsertype);

           (yyval.sparsefunc) = new ParseScopedUserFunction(QoreProgramLocation((yylsp[-6]).first_line, (yylsp[0]).last_line), (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, flags));
        }
#line 8948 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 233:
#line 3095 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-7]).first_line, (yylsp[0]).last_line);
           check_funcmod(loc, (yyvsp[-7].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[-7].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-7].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-7].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
        }
#line 8965 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 234:
#line 3107 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-7]).first_line, (yylsp[0]).last_line);
           check_funcmod(loc, (yyvsp[-7].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[-7].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
           delete (yyvsp[-6].parsertype);

           (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-7].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-7].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
        }
#line 8985 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 235:
#line 3125 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parse_list) = splice_expressions((yyvsp[-2].node), (yyvsp[0].node), QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line));
        }
#line 8993 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 236:
#line 3128 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[-1]).last_line);
           QoreParseListNode* l;
           if ((yyvsp[-1].node) && (yyvsp[-1].node)->getType() == NT_PARSE_LIST) {
              l = reinterpret_cast<QoreParseListNode*>((yyvsp[-1].node));
              if (l->isFinalized()) {
                 QoreParseListNode* nl = new QoreParseListNode(loc);
                 nl->add(l, loc);
                 l = nl;
              }
           }
           else {
              l = new QoreParseListNode(loc);
              l->add((yyvsp[-1].node), loc);
           }
           (yyval.parse_list) = l;
        }
#line 9015 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 237:
#line 3148 "../lib/parser.ypp" /* yacc.c:1646  */
    {
       (yyval.parse_list) = splice_expressions((yyvsp[-2].node), (yyvsp[0].node), QoreProgramLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line));
    }
#line 9023 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 238:
#line 3151 "../lib/parser.ypp" /* yacc.c:1646  */
    {
       QoreParseListNode* l;
       if ((yyvsp[-1].node) && (yyvsp[-1].node)->getType() == NT_PARSE_LIST)
          l = reinterpret_cast<QoreParseListNode*>((yyvsp[-1].node));
       else {
          QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[-1]).last_line);
          l = new QoreParseListNode(loc);
          l->add((yyvsp[-1].node), loc);
       }
       (yyval.parse_list) = l;
    }
#line 9039 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 239:
#line 3165 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.hash) = new QoreParseHashNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line));
           (yyvsp[0].hashelement)->addDelete((yyval.hash));
        }
#line 9048 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 240:
#line 3169 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].hashelement)->addDelete((yyvsp[-2].hash));
           (yyvsp[-2].hash)->updateLastLine((yylsp[0]).last_line);
           (yyval.hash) = (yyvsp[-2].hash);
        }
#line 9058 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 241:
#line 3175 "../lib/parser.ypp" /* yacc.c:1646  */
    { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[-1].hash); }
#line 9064 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 242:
#line 3180 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.hashelement) = new HashElement((yyvsp[-2].node), (yyvsp[0].node), (yylsp[-2]).first_line, (yylsp[0]).last_line); }
#line 9070 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 243:
#line 3184 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
           (yyvsp[-1].hash)->setCurly();
           (yyval.hash) = (yyvsp[-1].hash);
        }
#line 9080 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 244:
#line 3193 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 9086 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 245:
#line 3195 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].binary); }
#line 9092 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 246:
#line 3197 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[-1].hash); }
#line 9098 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 247:
#line 3199 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ScopedRefNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].string)); }
#line 9104 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 248:
#line 3200 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
              inc_argv_ref();

           QoreProgramLocation loc((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
           if ((yyvsp[-1].parsertype))
              (yyval.node) = new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
           else
              (yyval.node) = new VarRefNode(loc, (yyvsp[0].string), get_var_type());

           delete (yyvsp[-1].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9123 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 249:
#line 3214 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
           if ((yyvsp[-1].parsertype))
              (yyval.node) = new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
           else
              (yyval.node) = new VarRefNode(loc, (yyvsp[0].string), get_var_type());

           delete (yyvsp[-1].parsertype);
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9139 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 250:
#line 3225 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[0]).last_line);
           (yyval.node) = new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
           delete (yyvsp[-1].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9151 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 251:
#line 3232 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           VarRefDeclNode* v = new VarRefDeclNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
           v->setExplicitScope();
           (yyval.node) = v;
           delete (yyvsp[-1].parsertype);
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9164 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 252:
#line 3240 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // see if types are required
           if (parse_check_parse_option(PO_REQUIRE_TYPES))
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
           VarRefNode* v = new VarRefNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), VT_LOCAL);
           v->setExplicitScope();
           (yyval.node) = v;
           if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9179 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 253:
#line 3250 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           VarRefNode* v;
           if ((yyvsp[-1].parsertype)) {
              v = new VarRefDeclNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
              delete (yyvsp[-1].parsertype);
           }
           else {
              // see if types are required
              if (parse_check_parse_option(PO_REQUIRE_TYPES))
                 parse_error(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
              v = new VarRefNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[0].string), VT_LOCAL);
           }
           v->setExplicitScope();
           (yyval.node) = v;
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9201 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 254:
#line 3267 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[-1].parse_list)->setVariableList();
           QoreParseListNode::nvec_t& vl = (yyvsp[-1].parse_list)->getValues();
           for (unsigned i = 0; i < vl.size(); ++i) {
              AbstractQoreNode*& n = vl[i];
              qore_type_t t = get_node_type(n);
              QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
              if (t == NT_BAREWORD) {
                 BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
                 if (parse_check_parse_option(PO_REQUIRE_TYPES))
                    parse_error(loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
                 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(loc, "local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
                 VarRefNode* v = new VarRefNode(loc, b->takeString(), VT_LOCAL);
                 v->setExplicitScope();
                 b->deref();
                 n = v;
              }
              else if (t == NT_VARREF) {
                 VarRefNode* v = reinterpret_cast<VarRefNode*>(n);
                 // see if types are required
                 if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
                    parse_error(loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
                 if (v->explicitScope()) {
                    if (v->getType() == VT_LOCAL)
                       parse_error(loc, "illegal use of 'my %s' in local variable declaration list", v->getName());
                    else if (v->getType() == VT_GLOBAL)
                       parse_error(loc, "illegal use of 'our %s' in local variable declaration list", v->getName());
                 }
                 else
                    v->makeLocal();
                 v->setExplicitScope();
              }
              else
                 parse_error(loc, "element %d in list following 'my' is not a variable reference (%s)", i, get_type_name(n));
           }
           (yyval.node) = (yyvsp[-1].parse_list);
        }
#line 9244 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 255:
#line 3305 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = (yyvsp[0].gv)->makeVar();
        }
#line 9252 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 256:
#line 3309 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[0].string), "argv"))
              inc_argv_ref();

           (yyval.node) = new BarewordNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].string));
        }
#line 9263 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 257:
#line 3316 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ContextrefNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].string)); }
#line 9269 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 258:
#line 3318 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ContextRowNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line)); }
#line 9275 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 259:
#line 3320 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ComplexContextrefNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].string)); }
#line 9281 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 260:
#line 3322 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new FindNode(QoreProgramLocation((yylsp[-7]).first_line, (yylsp[0]).last_line), (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-1].node)); }
#line 9287 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 261:
#line 3324 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreExistsOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node)); }
#line 9293 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 262:
#line 3326 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreElementsOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node)); }
#line 9299 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 263:
#line 3327 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreKeysOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9307 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 264:
#line 3330 "../lib/parser.ypp" /* yacc.c:1646  */
    {  // unshift list, element
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[0]).last_line);
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(loc, "invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[0].node)->getTypeName());
              (yyval.node) = makeErrorTree((yyvsp[0].node), nullptr);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QoreUnshiftOperatorNode(loc, lv, l->shift());
              (yyvsp[0].node)->deref(nullptr);
           }
        }
#line 9325 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 265:
#line 3343 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreShiftOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9333 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 266:
#line 3346 "../lib/parser.ypp" /* yacc.c:1646  */
    {  // push lvalue-list, element
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[0]).last_line);
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(loc, "invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[0].node)->getTypeName());
              (yyval.node) = makeErrorTree((yyvsp[0].node), nullptr);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QorePushOperatorNode(loc, lv, l->shift());
              (yyvsp[0].node)->deref(0);
           }
        }
#line 9351 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 267:
#line 3359 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QorePopOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9359 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 268:
#line 3362 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreChompOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9367 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 269:
#line 3365 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreTrimOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9375 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 270:
#line 3368 "../lib/parser.ypp" /* yacc.c:1646  */
    {  // splice lvalue-list, offset, [length, list]
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           if (!l) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[0].node)));
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else if (l->size() < 2) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else if (l->size() > 4) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QoreSpliceOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), lv, l->shift(), l->shift(), l->shift());
              discard(l, 0);
           }
        }
#line 9400 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 271:
#line 3388 "../lib/parser.ypp" /* yacc.c:1646  */
    {  // extract lvalue-list, offset, [length, list]
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           if (!l) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[0].node)));
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else if (l->size() < 2) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else if (l->size() > 4) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else {
              AbstractQoreNode* lv = l->shift();
              (yyval.node) = new QoreExtractOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), lv, l->shift(), l->shift(), l->shift());
              discard(l, 0);
           }
        }
#line 9425 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 272:
#line 3408 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-1]).first_line, (yylsp[0]).last_line);
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           int len = l ? (int)l->size() : 0;
           if (!l || len < 2 || len > 3) {
              parse_error(loc, "invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", get_type_name((yyvsp[0].node)));
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else {
              // get first expression from list
              AbstractQoreNode* exp = l->shift();
              qore_type_t t = get_node_type(exp);
              (yyval.node) = 0;
              if (t == NT_PARSE_HASH) {
                 QoreParseHashNode* phn = reinterpret_cast<QoreParseHashNode*>(exp);
                 if (phn->isCurly())
                    (yyval.node) = parse_hash_map(loc, phn, l);
              }

              if (!(yyval.node))
                 (yyval.node) = parse_map(loc, exp, l);
           }
        }
#line 9454 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 273:
#line 3432 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[0].node)));
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else {
              AbstractQoreNode* code_exp = l->shift();
              AbstractQoreNode* arg = l->shift();
              (yyval.node) = new QoreFoldrOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), code_exp, arg);
              (yyvsp[0].node)->deref(0);
           }
        }
#line 9473 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 274:
#line 3446 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[0].node)));
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else {
              AbstractQoreNode* code_exp = l->shift();
              AbstractQoreNode* arg = l->shift();
              (yyval.node) = new QoreFoldlOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), code_exp, arg);
              (yyvsp[0].node)->deref(0);
           }
        }
#line 9492 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 275:
#line 3460 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           pop_ignore_numeric_argv_ref();
           QoreParseListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_PARSE_LIST ? reinterpret_cast<QoreParseListNode*>((yyvsp[0].node)) : nullptr;
           if (!l || l->size() != 2) {
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", get_type_name((yyvsp[0].node)));
              (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else {
              AbstractQoreNode* arg = l->shift();
              AbstractQoreNode* select_exp = l->shift();
              (yyval.node) = new QoreSelectOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), arg, select_exp);
              (yyvsp[0].node)->deref(0);
           }
        }
#line 9511 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 276:
#line 3474 "../lib/parser.ypp" /* yacc.c:1646  */
    {  // pre-increment
           (yyval.node) = new QorePreIncrementOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9519 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 277:
#line 3477 "../lib/parser.ypp" /* yacc.c:1646  */
    {  // pre-decrement
           (yyval.node) = new QorePreDecrementOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9527 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 278:
#line 3480 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           printd(5, "parsing in-object base class method call %s()\n", (yyvsp[-3].nscope)->ostr);
           if (!strcmp((yyvsp[-3].nscope)->getIdentifier(), "copy"))
              parse_error(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), "illegal call to base class copy method '%s'", (yyvsp[-3].nscope)->ostr);

           (yyval.node) = new SelfFunctionCallNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].nscope), make_args(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].node)));
        }
#line 9539 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 279:
#line 3487 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           printd(5, "parsing call %s()\n", (yyvsp[-2].string));
           (yyval.node) = new FunctionCallNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].string), make_args(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].node)));
        }
#line 9548 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 280:
#line 3492 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new SelfVarrefNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].string));
           if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
              parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9558 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 281:
#line 3497 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           // FIXME: need to expand constant expression checking to determine
           //        if the expression can throw an exception at run-time
           // first check for constant expressions
           (yyval.node) = new QoreUnaryMinusOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9569 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 282:
#line 3504 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreUnaryPlusOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9577 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 283:
#line 3507 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreBinaryNotOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9585 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 284:
#line 3510 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreLogicalNotOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9593 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 285:
#line 3513 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           qore_type_t t = (yyvsp[0].node) ? (yyvsp[0].node)->getType() : 0;
           //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2->getTypeName());

           if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
              (yyval.node) = reinterpret_cast<FunctionCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
           }
           else if (t == NT_SELF_CALL) {
              (yyval.node) = reinterpret_cast<SelfFunctionCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
           }
           else if (t == NT_STATIC_METHOD_CALL) {
              (yyval.node) = reinterpret_cast<StaticMethodCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
           }
           else {
              bool make_ref = true;

              if (t == NT_OPERATOR) {
                 QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[0].node));
                 if (deon) {
                    (yyval.node) = deon->makeCallReference();
                    make_ref = false;
                 }
              }

              if (make_ref) {
                 //printd(5, "type=%s\n", $2->getTypeName());
                 (yyval.node) = new ParseReferenceNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
              }
           }
        }
#line 9628 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 286:
#line 3543 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new ScopedObjectCallNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), new NamedScope((yyvsp[-3].string)), make_args(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].node)));
           if (parse_check_parse_option(PO_NO_NEW))
              parse_error(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 9638 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 287:
#line 3548 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new ScopedObjectCallNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), new NamedScope((yyvsp[-3].string)), make_args(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].node)));
           if (parse_check_parse_option(PO_NO_NEW))
              parse_error(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 9648 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 288:
#line 3553 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-4]).first_line, (yylsp[0]).last_line);
           (yyval.node) = new ParseNewComplexTypeNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), make_args(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].node)));
           if (parse_check_parse_option(PO_NO_NEW))
              parse_error(loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 9659 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 289:
#line 3559 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreBackgroundOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
           // check to see if the expression is legal
           if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
              parse_error(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), "illegal use of 'background' operator (conflicts with parse option PO_NO_THREAD_CONTROL)");
           else if (!node_has_effect((yyvsp[0].node)))
              parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "argument to background operator (%s) has no effect", get_type_name((yyvsp[0].node)));
        }
#line 9672 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 290:
#line 3567 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new BackquoteNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), (yyvsp[0].string));
           if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
              parse_error(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line), "illegal use of backquote operator (conflicts with parse option PO_NO_EXTERNAL_PROCESS)");
        }
#line 9682 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 291:
#line 3572 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = (yyvsp[-1].node);
           if ((yyvsp[-1].node)) {
              switch ((yyvsp[-1].node)->getType()) {
                 case NT_PARSE_LIST:
                    reinterpret_cast<QoreParseListNode*>((yyvsp[-1].node))->setFinalized();
                    break;
                 case NT_FUNCTION_CALL:
                    reinterpret_cast<FunctionCallNode*>((yyvsp[-1].node))->setFinalized();
                    break;
                 case NT_BAREWORD:
                    reinterpret_cast<BarewordNode*>((yyvsp[-1].node))->setFinalized();
                    break;
                 case NT_OPERATOR:
                    dynamic_cast<QoreOperatorNode*>((yyvsp[-1].node))->setInParentheses();
                    break;
              }
           }
        }
#line 9706 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 292:
#line 3591 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreParseListNode* l = new QoreParseListNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line));
           l->setFinalized();
           (yyval.node) = l;
        }
#line 9716 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 293:
#line 3596 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           int ar = get_pop_argv_ref();
           (yyval.node) = new QoreClosureParseNode(QoreProgramLocation((yylsp[-5]).first_line, (yylsp[0]).last_line), new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
        }
#line 9725 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 294:
#line 3600 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
           delete (yyvsp[-5].parsertype);

           int ar = get_pop_argv_ref();
           (yyval.node) = new QoreClosureParseNode(QoreProgramLocation((yylsp[-5]).first_line, (yylsp[0]).last_line), new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
        }
#line 9737 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 295:
#line 3607 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-6]).first_line, (yylsp[0]).last_line);
           check_funcmod(loc, (yyvsp[-6].i4));
           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[-6].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;
           (yyval.node) = new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) | OFM_SYNCED, flags));
        }
#line 9751 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 296:
#line 3616 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-6]).first_line, (yylsp[0]).last_line);
           check_funcmod(loc, (yyvsp[-6].i4));

           RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
           delete (yyvsp[-5].parsertype);

           int ar = get_pop_argv_ref();
           int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           if ((yyvsp[-6].i4) & OFM_DEPRECATED)
              flags |= QC_DEPRECATED;
           (yyval.node) = new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-6].i4) | OFM_SYNCED, flags));
        }
#line 9769 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 297:
#line 3629 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = (yyvsp[0].implicit_arg);
           inc_numeric_argv_ref();
        }
#line 9778 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 298:
#line 3633 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreImplicitElementNode(QoreProgramLocation((yylsp[0]).first_line, (yylsp[0]).last_line));
        }
#line 9786 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 299:
#line 3636 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreDeleteOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9794 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 300:
#line 3639 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreRemoveOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[0].node));
        }
#line 9802 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 301:
#line 3642 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           QoreProgramLocation loc((yylsp[-3]).first_line, (yylsp[0]).last_line);
           (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), (yyvsp[-1].node));
        }
#line 9811 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 303:
#line 3650 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].parse_list); }
#line 9817 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 304:
#line 3651 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].hash); }
#line 9823 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 305:
#line 3652 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreParseHashNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), true); }
#line 9829 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 306:
#line 3653 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePlusEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9835 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 307:
#line 3654 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMinusEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9841 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 308:
#line 3655 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreAndEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9847 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 309:
#line 3656 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreOrEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9853 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 310:
#line 3657 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9859 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 311:
#line 3658 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9865 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 312:
#line 3659 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivideEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9871 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 313:
#line 3660 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreXorEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9877 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 314:
#line 3661 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9883 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 315:
#line 3662 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9889 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 316:
#line 3663 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9895 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 317:
#line 3664 "../lib/parser.ypp" /* yacc.c:1646  */
    {
                                           QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[0]).last_line);

                                           // see if the use of the weak assignment operator is allowed
                                           if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
                                              parse_error(loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

                                           (yyval.node) = process_weak_assignment(loc, (yyvsp[-2].node), (yyvsp[0].node));
                                        }
#line 9909 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 318:
#line 3673 "../lib/parser.ypp" /* yacc.c:1646  */
    {
        QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.node) = (yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].node), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].node), (yyvsp[0].parsertype)->getParseTypeInfo());
        delete (yyvsp[0].parsertype);
    }
#line 9921 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 319:
#line 3680 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreNullCoalescingOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9927 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 320:
#line 3681 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreValueCoalescingOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9933 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 321:
#line 3682 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreQuestionMarkOperatorNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9939 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 322:
#line 3683 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostIncrementOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].node)); }
#line 9945 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 323:
#line 3684 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostDecrementOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].node)); }
#line 9951 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 324:
#line 3685 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].node), (yyvsp[-1].node), QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line)); }
#line 9957 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 325:
#line 3686 "../lib/parser.ypp" /* yacc.c:1646  */
    { check_operator_log_or((yyvsp[-2].node), "logical AND"); (yyval.node) = new QoreLogicalAndOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9963 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 326:
#line 3687 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9969 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 327:
#line 3688 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9975 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 328:
#line 3689 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9981 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 329:
#line 3690 "../lib/parser.ypp" /* yacc.c:1646  */
    { check_operator_bin_or((yyvsp[-2].node), "binary XOR"); (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9987 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 330:
#line 3691 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9993 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 331:
#line 3692 "../lib/parser.ypp" /* yacc.c:1646  */
    { check_operator_bin_or((yyvsp[-2].node), "binary AND"); check_operator_bin_xor((yyvsp[-2].node), "binary AND"); (yyval.node) = new QoreBinaryAndOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9999 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 332:
#line 3693 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10005 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 333:
#line 3694 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexMatchOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Regex)); }
#line 10011 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 334:
#line 3695 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexNMatchOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Regex)); }
#line 10017 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 335:
#line 3696 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexSubstOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].RegexSubst)); }
#line 10023 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 336:
#line 3697 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTransliterationOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Trans)); }
#line 10029 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 337:
#line 3698 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexExtractOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Regex)); }
#line 10035 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 338:
#line 3699 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10041 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 339:
#line 3700 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10047 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 340:
#line 3701 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalComparisonOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10053 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 341:
#line 3702 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10059 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 342:
#line 3703 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalAbsoluteEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10065 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 343:
#line 3704 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalAbsoluteNotEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10071 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 344:
#line 3705 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10077 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 345:
#line 3706 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10083 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 346:
#line 3707 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10089 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 347:
#line 3708 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftLeftOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10095 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 348:
#line 3709 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftRightOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10101 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 349:
#line 3710 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePlusOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10107 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 350:
#line 3711 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMinusOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10113 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 351:
#line 3712 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10119 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 352:
#line 3713 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivisionOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10125 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 353:
#line 3714 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMultiplicationOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10131 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 354:
#line 3715 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].node), (yyvsp[-2].node), nullptr); }
#line 10137 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 355:
#line 3716 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].node), nullptr, (yyvsp[-1].node)); }
#line 10143 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 356:
#line 3717 "../lib/parser.ypp" /* yacc.c:1646  */
    {
                                           parse_error(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
                                           (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].node), nullptr, nullptr);
                                        }
#line 10152 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 357:
#line 3721 "../lib/parser.ypp" /* yacc.c:1646  */
    {
        (yyval.node) = nullptr;
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].node) && (yyvsp[-1].node)->getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].node));
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].node), ron->swapLeft(nullptr), ron->swapRight(nullptr));
           }
        }
        if (!(yyval.node))
           (yyval.node) = new QoreSquareBracketsOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].node), (yyvsp[-1].node));
    }
#line 10170 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 358:
#line 3734 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].node), (yyvsp[-1].node)); }
#line 10176 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 359:
#line 3735 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRangeOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10182 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 360:
#line 3736 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10188 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 361:
#line 3737 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].node), (yyvsp[0].String)); }
#line 10194 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 363:
#line 3742 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].parse_list); }
#line 10200 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 364:
#line 3743 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePlusEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10206 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 365:
#line 3744 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMinusEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10212 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 366:
#line 3745 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreAndEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10218 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 367:
#line 3746 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreOrEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10224 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 368:
#line 3747 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10230 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 369:
#line 3748 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10236 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 370:
#line 3749 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivideEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10242 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 371:
#line 3750 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreXorEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10248 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 372:
#line 3751 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10254 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 373:
#line 3752 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10260 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 374:
#line 3753 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10266 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 375:
#line 3754 "../lib/parser.ypp" /* yacc.c:1646  */
    {
                                             QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[0]).last_line);

                                             // see if the use of the weak assignment operator is allowed
                                             if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
                                                parse_error(loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

                                             (yyval.node) = process_weak_assignment(loc, (yyvsp[-2].node), (yyvsp[0].node));
                                          }
#line 10280 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 376:
#line 3763 "../lib/parser.ypp" /* yacc.c:1646  */
    {
        QoreProgramLocation loc((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.node) = (yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].node), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].node), (yyvsp[0].parsertype)->getParseTypeInfo());
        delete (yyvsp[0].parsertype);
    }
#line 10292 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 377:
#line 3770 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreNullCoalescingOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10298 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 378:
#line 3771 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreValueCoalescingOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10304 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 379:
#line 3772 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreQuestionMarkOperatorNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10310 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 380:
#line 3773 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostIncrementOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].node)); }
#line 10316 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 381:
#line 3774 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostDecrementOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].node)); }
#line 10322 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 382:
#line 3775 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].node), (yyvsp[-1].node), QoreProgramLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line)); }
#line 10328 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 383:
#line 3776 "../lib/parser.ypp" /* yacc.c:1646  */
    { check_operator_log_or((yyvsp[-2].node), "logical AND"); (yyval.node) = new QoreLogicalAndOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10334 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 384:
#line 3777 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10340 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 385:
#line 3778 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10346 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 386:
#line 3779 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10352 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 387:
#line 3780 "../lib/parser.ypp" /* yacc.c:1646  */
    { check_operator_bin_or((yyvsp[-2].node), "binary XOR"); (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10358 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 388:
#line 3781 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBinaryOrOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10364 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 389:
#line 3782 "../lib/parser.ypp" /* yacc.c:1646  */
    { check_operator_bin_or((yyvsp[-2].node), "binary AND"); check_operator_bin_xor((yyvsp[-2].node), "binary AND"); (yyval.node) = new QoreBinaryAndOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10370 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 390:
#line 3783 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBinaryXorOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10376 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 391:
#line 3784 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexMatchOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Regex)); }
#line 10382 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 392:
#line 3785 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexNMatchOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Regex)); }
#line 10388 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 393:
#line 3786 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexSubstOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].RegexSubst)); }
#line 10394 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 394:
#line 3787 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTransliterationOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Trans)); }
#line 10400 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 395:
#line 3788 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRegexExtractOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].Regex)); }
#line 10406 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 396:
#line 3789 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10412 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 397:
#line 3790 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10418 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 398:
#line 3791 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalComparisonOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10424 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 399:
#line 3792 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10430 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 400:
#line 3793 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalAbsoluteEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10436 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 401:
#line 3794 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalAbsoluteNotEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10442 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 402:
#line 3795 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10448 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 403:
#line 3796 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10454 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 404:
#line 3797 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10460 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 405:
#line 3798 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftLeftOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10466 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 406:
#line 3799 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftRightOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10472 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 407:
#line 3800 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePlusOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10478 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 408:
#line 3801 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMinusOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10484 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 409:
#line 3802 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10490 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 410:
#line 3803 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivisionOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10496 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 411:
#line 3804 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMultiplicationOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10502 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 412:
#line 3805 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].node), (yyvsp[-2].node), nullptr); }
#line 10508 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 413:
#line 3806 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].node), nullptr, (yyvsp[-1].node)); }
#line 10514 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 414:
#line 3807 "../lib/parser.ypp" /* yacc.c:1646  */
    {
                                             parse_error(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
                                             (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].node), nullptr, nullptr);
                                          }
#line 10523 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 415:
#line 3811 "../lib/parser.ypp" /* yacc.c:1646  */
    {
        (yyval.node) = nullptr;
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].node) && (yyvsp[-1].node)->getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].node));
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.node) = new QoreSquareBracketsRangeOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].node), ron->swapLeft(nullptr), ron->swapRight(nullptr));
           }
        }
        if (!(yyval.node))
           (yyval.node) = new QoreSquareBracketsOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].node), (yyvsp[-1].node));
    }
#line 10541 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 416:
#line 3824 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].node), (yyvsp[-1].node)); }
#line 10547 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 417:
#line 3825 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreRangeOperatorNode(QoreProgramLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10553 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 418:
#line 3826 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 10559 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 419:
#line 3827 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreHashObjectDereferenceOperatorNode(QoreProgramLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].node), (yyvsp[0].String)); }
#line 10565 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 420:
#line 3831 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.String) = (yyvsp[0].String);
        }
#line 10573 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 421:
#line 3834 "../lib/parser.ypp" /* yacc.c:1646  */
    {
           (yyval.String) = (yyvsp[-1].String);
           (yyval.String)->concat((yyvsp[0].String));
           (yyvsp[0].String)->deref();
        }
#line 10583 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 422:
#line 3842 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreFloatNode((yyvsp[0].decimal)); }
#line 10589 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 423:
#line 3843 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBigIntNode((yyvsp[0].integer)); }
#line 10595 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 424:
#line 3844 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].String); }
#line 10601 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 425:
#line 3845 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].datetime); }
#line 10607 "../lib/parser.cpp" /* yacc.c:1646  */
    break;

  case 426:
#line 3846 "../lib/parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].num); }
#line 10613 "../lib/parser.cpp" /* yacc.c:1646  */
    break;


#line 10617 "../lib/parser.cpp" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[1] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 3849 "../lib/parser.ypp" /* yacc.c:1906  */

