# this spec file can be used for multiple RPM-based distributions including Fedora, RHEL, *SUSE, and others

%{?_datarootdir: %global mydatarootdir %_datarootdir}
%{!?_datarootdir: %global mydatarootdir /usr/share}

%global module_dir %{_libdir}/qore-modules
%global user_module_dir %{mydatarootdir}/qore-modules/

%if 0%{?sles_version}
%global dist .sles%{?sles_version}
%else
%if 0%{?suse_version}
# get *suse release major version
%global os_maj %(echo %suse_version|rev|cut -b3-|rev)
# get *suse release minor version without trailing zeros
%global os_min %(echo %suse_version|rev|cut -b-2|rev|sed s/0*$//)
%if %suse_version > 1010
%global dist .opensuse%{os_maj}_%{os_min}
%else
%global dist .suse%{os_maj}_%{os_min}
%endif
%endif
%endif

# see if we can determine the distribution type
%if 0%{!?dist:1}
%if 0%{?rhel}
%global dist .el%{rhel}
%endif
%endif

Summary: Multithreaded Programming Language
Name: qore
Version: 0.8.11.1
Release: 1%{dist}
%if 0%{?suse_version}
License: LGPL-2.0+ or GPL-2.0+ or MIT
%else
License: LGPLv2+ or GPLv2+ or MIT
%endif
Group: Development/Languages
URL: http://qore.org
Source0: http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires: /usr/bin/env
BuildRequires: flex >= 2.5.31
BuildRequires: bison
BuildRequires: openssl-devel
BuildRequires: pcre-devel
BuildRequires: zlib-devel
BuildRequires: gmp-devel
BuildRequires: mpfr-devel
BuildRequires: doxygen
BuildRequires: gcc-c++
%if 0%{?suse_version}
BuildRequires: pkg-config
BuildRequires: fdupes
%if 0%{?sles_version} && %{?sles_version} <= 10
BuildRequires: bzip2
%else
BuildRequires: libbz2-devel
%endif
%else
BuildRequires: pkgconfig
BuildRequires: bzip2-devel
%endif
%if 0%{?sles_version}
BuildArch: %{_target_cpu}
%endif

%description
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

%if 0%{?suse_version}
%debug_package
%endif

%if 0%{?fedora}
%global libname libqore
%else
%if 0%{?rhel}
%global libname libqore
%else
%global libname libqore5
%endif
%endif

%package -n %{libname}
Summary: The libraries for the qore runtime and qore clients
Group: System Environment/Libraries
Provides: qore-module(abi)%{?_isa} = 0.19
Provides: qore-module(abi)%{?_isa} = 0.18
# provided for backwards-compatibility with unversioned capabilities and will be removed when the ABI drops backwards-compatibility
Provides: qore-module-api-0.18
Provides: qore-module-api-0.17
Provides: qore-module-api-0.16
Provides: qore-module-api-0.15
Provides: qore-module-api-0.14
Provides: qore-module-api-0.13
Provides: qore-module-api-0.12
Provides: qore-module-api-0.11
Provides: qore-module-api-0.10
Provides: qore-module-api-0.9
Provides: qore-module-api-0.8
Provides: qore-module-api-0.7
Provides: qore-module-api-0.6
Provides: qore-module-api-0.5
%if %{libname} == "libqore"
Provides: libqore5 = %{version}
Obsoletes: libqore5 < 0.8.11.1
%endif
%if 0%{?sles_version}
BuildArch: %{_target_cpu}
%endif

%description -n %{libname}
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides the qore library required for all clients using qore
functionality.

%files -n %{libname}
%defattr(-,root,root,-)
%{_libdir}/libqore.so.5.13.0
%{_libdir}/libqore.so.5
%{module_dir}
%doc COPYING.LGPL COPYING.GPL COPYING.MIT README README-LICENSE README-MODULES RELEASE-NOTES ChangeLog AUTHORS WHATISQORE

%post -n %{libname}
ldconfig %{_libdir}

%postun -n %{libname}
ldconfig %{_libdir}

%package stdlib
Summary: Standard library modules
Group: System Environment/Libraries
BuildArch: noarch
Requires: libqore = %{version}-%{release}

%description stdlib
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides the Qore language standard library user modules.

%files stdlib
%defattr(-,root,root,-)
%{user_module_dir}
%doc COPYING.LGPL COPYING.GPL COPYING.MIT README-LICENSE

%package doc
Summary: API documentation, programming language reference, and Qore example programs
Group: Documentation
BuildArch: noarch

%description doc
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides the HTML documentation for the Qore programming language
and also for user modules delivered with Qore and also example programs.

%files doc
%defattr(-,root,root,-)
%doc docs/lang docs/modules/* examples/ COPYING.LGPL COPYING.GPL COPYING.MIT README-LICENSE

%package devel
Summary: The header files needed to compile programs using the qore library
Group: Development/Libraries
Requires: %{libname}%{?_isa} = %{version}-%{release}
%if 0%{?sles_version}
BuildArch: %{_target_cpu}
%endif

%description devel
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides header files needed to compile client programs using the
Qore library.

%files devel
%defattr(-,root,root,-)
/usr/bin/qpp
/usr/bin/qdx
%{_libdir}/libqore.so
%{_libdir}/pkgconfig/qore.pc
%dir %{_libdir}/cmake
%{_libdir}/cmake/Qore
%{_prefix}/include/*

%package devel-doc
Summary: C++ API documentation for the qore library
Group: Documentation
BuildArch: noarch

%description devel-doc
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides HTML documentation for the C++ API for the Qore library.

%files devel-doc
%defattr(-,root,root,-)
%doc docs/library/html/*

%prep
%setup -q
# silence the executable warning for examples
find examples -type f -exec chmod -x {} \;

%build
export CXXFLAGS="%{?optflags}"
%configure --disable-debug --disable-dependency-tracking
%{__make} %{?_smp_mflags}

%install
make install prefix=%{_prefix} DESTDIR=$RPM_BUILD_ROOT
rm $RPM_BUILD_ROOT/%{_libdir}/libqore.la
mkdir -p $RPM_BUILD_ROOT/%{module_dir}
%if 0%{?suse_version}
%fdupes -s docs/library/html
%endif

%if 0%{!?sles_version}
%check
make check
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
/usr/bin/qore
%if 0%{?rh_dist}
%if %{?rh_dist} <= 5
/usr/man/man1/qore.1.*
%endif
%else
/usr/share/man/man1/qore.1.*
%else
%if 0%{?mdkversion}
/usr/share/man/man1/qore.1.*
%endif
%endif

%changelog
* Mon Jun 23 2014 David Nichols <david@qore.org> 0.8.11.1
- updated to 0.8.11.1

* Sat May 31 2014 David Nichols <david@qore.org> 0.8.11
- updated to 0.8.11

* Wed Mar 12 2014 David Nichols <david@qore.org> 0.8.10
- updated to 0.8.10

* Fri Oct 04 2013 David Nichols <david@qore.org> 0.8.9
- updated to 0.8.9

* Sun Feb 24 2013 David Nichols <david@qore.org> 0.8.8
- updated to 0.8.8

* Wed Nov 21 2012 David Nichols <david@qore.org> 0.8.7
- updated to 0.8.7

* Fri Nov 9 2012 David Nichols <david@qore.org> 0.8.6.2
- updated to 0.8.6.2

* Sat Oct 27 2012 David Nichols <david@qore.org> 0.8.6.1
- updated to 0.8.6.1

* Sun Sep 2 2012 David Nichols <david@qore.org> 0.8.6
- updated to 0.8.6

* Wed May 23 2012 David Nichols <david@qore.org> 0.8.5
- updated to 0.8.5

* Tue May 22 2012 David Nichols <david@qore.org> 0.8.4
- updated for new doxygen-based documentation, added devel-doc pkg for API docs
- updated package descriptions

* Thu Oct 20 2011 David Nichols <david@qore.org> 0.8.4
- updated to 0.8.4

* Fri Oct 07 2011 Petr Vanek <petr.vanek@qoretechnologies.com> 0.8.3
- pkg-config

* Sun Mar 6 2011 David Nichols <david@qore.org>
- updated to 0.8.3

* Sun Dec 26 2010 David Nichols <david@qore.org>
- updated to 0.8.2

* Tue Jun 15 2010 David Nichols <david@qore.org>
- updated to 0.8.1

* Wed Nov 18 2009 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.8.0

* Fri Nov 6 2009 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.7.7

* Mon Jul 13 2009 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.7.6

* Mon Jun 22 2009 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.7.5

* Wed Mar 4 2009 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.7.4

* Wed Dec 3 2008 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.7.3

* Wed Nov 26 2008 David Nichols <david_nichols@users.sourceforge.net>
- made libqore* the default name for lib package, removed la file

* Sun Nov 23 2008 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.7.2

* Tue Oct 7 2008 David Nichols <david_nichols@users.sourceforge.net>
- released 0.7.0

* Thu Sep 4 2008 David Nichols <david_nichols@users.sourceforge.net>
- removed all modules as they are now independent projects

* Tue Sep 2 2008 David Nichols <david_nichols@users.sourceforge.net>
- fixed dist tag for suse distributions
- updated for new module directory, added qore-module-api-* capability

* Thu Jun 12 2008 David Nichols <david_nichols@users.sourceforge.net>
- added new modules

* Mon Oct 22 2007 David Nichols <david_nichols@users.sourceforge.net>
- updated spec file with corrections from suse open build service

* Tue Jul 17 2007 David Nichols <david_nichols@users.sourceforge.net>
- updated library version to 3.1.0

* Sat Jul 14 2007 David Nichols <david_nichols@users.sourceforge.net>
- copied improvements from opensuse rpm and updated based on rpmlint output
- updated version to 0.7.0

* Thu Jun 14 2007 David Nichols <david_nichols@users.sourceforge.net>
- fixed spec file to support more architectures

* Wed Jun 13 2007 David Nichols <david_nichols@users.sourceforge.net>
- removed tibae module from spec file due to compiler requiremenets (g++-32)
- added pgsql module

* Tue Feb 20 2007 David Nichols <david_nichols@users.sourceforge.net>
- updated to libqore.so.3.0.0

* Sun Feb 11 2007 David Nichols <david_nichols@users.sourceforge.net>
- updated to 0.6.2 and libqore 1.1

* Tue Jan 30 2007 David Nichols <david_nichols@users.sourceforge.net>
- added tuxedo module

* Fri Jan 5 2007 David Nichols <david_nichols@users.sourceforge.net>
- updated libqore so version to 1.0.0

* Sat Nov 18 2006 David Nichols <david_nichols@users.sourceforge.net>
- updated descriptions
- changes to make spec file more release-agnostic (use of the dist tag in release)

* Wed Dec 7 2005 David Nichols <david_nichols@users.sourceforge.net>
- Initial rpm build

