/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "parser.ypp" /* yacc.c:339  */
 /* -*- mode: c++; indent-tabs-mode: nil -*-

   parser.ypp

   Qore Programming Language

   Copyright (C) 2003 - 2014 David Nichols

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.

  Note that the Qore library is released under a choice of three open-source
  licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
  information.
*/

#include <qore/Qore.h>
#include <qore/intern/BreakStatement.h>
#include <qore/intern/ContinueStatement.h>
#include <qore/intern/ReturnStatement.h>
#include <qore/intern/RethrowStatement.h>
#include <qore/intern/ThreadExitStatement.h>
#include <qore/intern/ExpressionStatement.h>
#include <qore/intern/DoWhileStatement.h>
#include <qore/intern/SummarizeStatement.h>
#include <qore/intern/ContextStatement.h>
#include <qore/intern/IfStatement.h>
#include <qore/intern/WhileStatement.h>
#include <qore/intern/ForStatement.h>
#include <qore/intern/ForEachStatement.h>
#include <qore/intern/TryStatement.h>
#include <qore/intern/ThrowStatement.h>
#include <qore/intern/StatementBlock.h>
#include <qore/intern/ParserSupport.h>
#include <qore/intern/SwitchStatement.h>
#include <qore/intern/CaseNodeWithOperator.h>
#include <qore/intern/CaseNodeRegex.h>
#include <qore/intern/OnBlockExitStatement.h>
#include <qore/intern/ConstantList.h>
#include <qore/intern/GlobalVariableList.h>
#include <qore/intern/QoreNamespaceIntern.h>

#include "parser.hpp"

#include <qore/intern/QoreClassIntern.h>
#include <qore/intern/qore_program_private.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <memory>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                                \
          do                                                           \
            if (N) {                                                   \
                (Current).first_line   = YYRHSLOC(Rhs, 1).first_line;  \
                (Current).last_line    = YYRHSLOC(Rhs, N).last_line;   \
            }                                                          \
            else {                                                     \
                (Current).first_line   = (Current).last_line   =       \
                  YYRHSLOC(Rhs, 0).last_line;                          \
            }                                                          \
          while (0)

class HashElement {
public:
   char* key;
   AbstractQoreNode* value;
 
   DLLLOCAL HashElement(AbstractQoreNode* k, AbstractQoreNode* v) {
      //tracein("HashElement::HashElement()");
      if (!k || k->getType() != NT_STRING) {
	 parse_error("hash member name must be a string value!");
	 key = strdup("");
      }
      else
	 key = strdup(reinterpret_cast<QoreStringNode*>(k)->getBuffer());
      k->deref(0);
      value = v;
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL HashElement(int tag, char* constant, AbstractQoreNode* v) {
      //tracein("HashElement::HashElement()");
      key = (char* )malloc(sizeof(char) * strlen(constant) + 2);
      key[0] = tag; // mark as constant
      strcpy(key + 1, constant);
      value = v;
      free(constant);
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL ~HashElement() {
      free(key);
   }
};

static AbstractQoreNode* makeErrorTree(AbstractQoreNode* left, AbstractQoreNode* right) {
   discard(left, 0);
   discard(right, 0);
   return &False;
}

// for constant definitions
class ConstNode {
public:
   NamedScope name;
   AbstractQoreNode* value;
   bool pub;

   DLLLOCAL ConstNode(char* n, AbstractQoreNode* v, bool p = false) : name(n), value(v), pub(p) {
      // see if constant definitions are allowed
      if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
         parse_error("illegal constant definition \"%s\" (conflicts with parse option NO_CONSTANT_DEFS)", n);
   }
   DLLLOCAL AbstractQoreNode* takeValue() {
      AbstractQoreNode* rv = value;
      value = 0;
      return rv;
   }
   DLLLOCAL const std::string &getName() const {
      return name.getIdentifierStr();
   }
   DLLLOCAL bool isPublic() const {
      return pub;
   }
};

class ObjClassDef {
public:
   NamedScope *name;
   QoreClass *oc;

   DLLLOCAL inline ObjClassDef(NamedScope *n, QoreClass *o) : name(n), oc(o) {}
   DLLLOCAL inline ObjClassDef(char* n, QoreClass *o) : name(new NamedScope(n)), oc(o) {}
   DLLLOCAL inline ~ObjClassDef() { delete name; }
};

class ParseUserFunctionBase {
public:
   UserFunctionVariant* variant;

   DLLLOCAL ParseUserFunctionBase(UserFunctionVariant* v) : variant(v) {
   }

   DLLLOCAL ~ParseUserFunctionBase() {
      if (variant)
         variant->deref();
   }

   DLLLOCAL void setPublic() {
      variant->setModulePublic();
   }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
   char* name;

   DLLLOCAL ParseUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL ~ParseUserFunction() {
      if (name)
         free(name);
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
         const char* nsn = ns.name.c_str();
         parse_error("function '%s%s%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
      }

      delete this;
   }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
   NamedScope name;

   DLLLOCAL ParseScopedUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
         parse_error("function '%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", name.ostr);

      delete this;
   }
};

struct GVarDecl {
   bool pub;

   DLLLOCAL GVarDecl(bool p) : pub(p) {
   }

   DLLLOCAL virtual ~GVarDecl() {
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

   DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
   char* name;
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL GVarSingleDecl(char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(p), name(n), typeInfo(ti), parseTypeInfo(pti) {
      if (bare) {
         if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
      }
      else {
         if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
      }
   }

   DLLLOCAL virtual ~GVarSingleDecl() {
      if (name)
         free(name);

      delete parseTypeInfo;
   }

   DLLLOCAL char* takeName() {
      char* rv = name;
      name = 0;
      return rv;
   }

   DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ns.parseAddGlobalVarDecl(takeName(), typeInfo, takeParseTypeInfo(), pub);
      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      GlobalVarRefNode* gv = typeInfo
         ? new GlobalVarRefNode(takeName(), typeInfo)
         : new GlobalVarRefNode(takeName(), takeParseTypeInfo());
      if (pub)
         gv->setPublic();

      delete this;
      return gv;
   }   
};

struct GVarListDecl : public GVarDecl {
   QoreListNode* l;

   DLLLOCAL GVarListDecl(QoreListNode* list, bool p) : GVarDecl(p), l(list) {
      bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            if (!bareok)
               parse_error("global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (vrn->explicitScope()) {
               if (vrn->getType() == VT_LOCAL)
                  parse_error("illegal use of 'my %s' in global variable declaration list", vrn->getName());
               else if (vrn->getType() == VT_GLOBAL)
                  parse_error("illegal use of 'our %s' in global variable declaration list", vrn->getName());
            }
         }
         else
            parse_error("element %d in list following 'our' is not a variable reference (%s)", li.index(), get_type_name(n));
      }
   }

   DLLLOCAL virtual ~GVarListDecl() {
      if (l)
         l->deref(0);
   }

   DLLLOCAL QoreListNode* takeList() {
      QoreListNode* rv = l;
      l = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            ns.parseAddGlobalVarDecl(b->takeString(), 0, 0, pub);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
               if (vrdn)
                  ns.parseAddGlobalVarDecl(vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
               else
                  ns.parseAddGlobalVarDecl(vrn->takeName(), 0, 0, pub);
            }
         }
      }

      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      l->setVariableList();
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         VarRefNode* vrn = 0;
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            GlobalVarRefNode* v = new GlobalVarRefNode(b->takeString());
            b->deref();
            AbstractQoreNode** p = li.getValuePtr();
            *p = vrn = v;
         }
         else if (t == NT_VARREF) {
            vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               vrn->makeGlobal();
               vrn->setExplicitScope();
            }
         }

         if (vrn && pub)
            vrn->setPublic();
      }

      QoreListNode* rv = takeList();
      delete this;
      return rv;
   }
};

static int checkMethod(const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error("%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error("base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PRIVATE    (1 << 0)
#define OFM_SYNCED     (1 << 1)
#define OFM_STATIC     (1 << 2)
#define OFM_DEPRECATED (1 << 3)
#define OFM_PUBLIC     (1 << 4)
#define OFM_FINAL      (1 << 5)
#define OFM_ABSTRACT   (1 << 6)

static inline MethodVariantBase* newMethodVariant(const char* name, int mod, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b, int64 flags = QC_NO_FLAGS) {
   //printd(5, "newMethodVariant() '%s' b: %p\n", name, b);

   if (get_pop_argv_ref())
      flags |= QC_USES_EXTRA_ARGS;

   if (!strcmp(name, "constructor")) {
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      return new UserConstructorVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
   }
   if (bcal) {
      parse_error("only constructors may have base class constructor arguments");
      delete bcal;
      bcal = 0;
   }
   if (!strcmp(name, "destructor")) {
      if (params) {
	 parse_error("parameters cannot be defined for destructors");
	 params->deref(0);
      }
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      if (mod & OFM_PRIVATE)
	 parse_error("destructors cannot be private");
      return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
   }
   if (!strcmp(name, "copy")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (!(mod & OFM_SYNCED))
         return new UserCopyVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
   }

   if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; they are not inherited anyway", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract; they are not inherited anyway", name);
   }

   if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
      parse_error("method '%s()' is declared both final and abstract", name);

   return new UserMethodVariant(mod & OFM_PRIVATE, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
   MethodVariantBase* m;
   NamedScope name;
   bool static_flag;

   DLLLOCAL MethodDef(int mod, char* n, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : m(0), name(n), static_flag(mod & OFM_STATIC) {
      if (checkMethod(name.getIdentifier(), bcal, returnTypeInfo)) {
         if (params)
            params->deref(0);
         delete bcal;
         delete b;
         delete returnTypeInfo;
         return;
      }

      m = newMethodVariant(name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b, mod & OFM_DEPRECATED);
   }

   DLLLOCAL ~MethodDef() {
      delete m;
   }

   DLLLOCAL void parseAddToClassAndDel() {
      if (m) {
         // if there are any errors, the function below will delete memory
         // the following method takes ownership of "m" unconditionally
         qore_root_ns_private::parseAddMethodToClass(name, m, static_flag);
         m = 0;
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      // the following method takes ownership of "m" unconditionally
      ns.parseAddMethodToClass(name, m, static_flag);
      m = 0;
   }
};

#define NSN_NONE  0
#define NSN_OCD   1
#define NSN_CONST 2
#define NSN_NS    3
#define NSN_FUNC  4
#define NSN_SFUNC 5
#define NSN_VAR   6
#define NSN_METH  7

struct NSNode {
   int type;
   union {
      ObjClassDef* ocd;
      ConstNode* cn;
      QoreNamespace* ns;
      ParseUserFunction* func;
      ParseScopedUserFunction* sfunc;
      GVarDecl* gv;
      MethodDef* meth;
   } n;

   DLLLOCAL NSNode(ObjClassDef *o) { type = NSN_OCD; n.ocd = o; }
   DLLLOCAL NSNode(ConstNode  *c) { type = NSN_CONST; n.cn = c; }
   DLLLOCAL NSNode(QoreNamespace  *s) { type = NSN_NS; n.ns = s; }
   DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
      n.func = f;
   }
   DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
      n.sfunc = f;
   }

   DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
      n.gv = gv;
   }

   DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
      n.meth = m;
   }

   DLLLOCAL void deref() {
      switch (type) {
         case NSN_OCD:
            delete n.ocd;
            break;
         case NSN_CONST:
            delete n.cn;
            break;
         case NSN_NS:
            delete n.ns;
            break;
         case NSN_FUNC:
            delete n.func;
            break;
         case NSN_SFUNC:
            delete n.sfunc;
            break;
         case NSN_VAR:
            delete n.gv;
            break;
         case NSN_METH:
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      switch (type) {
         case NSN_OCD:
            ns.parseAddPendingClass(*(n.ocd->name), n.ocd->oc);
            delete n.ocd;
            break;
         case NSN_CONST:
            ns.parseAddConstant(n.cn->name, n.cn->value, n.cn->pub);
            delete n.cn;
            break;
         case NSN_NS:
            ns.parseAddNamespace(n.ns);
            break;
         case NSN_FUNC:
            n.func->add(ns);
            break;
         case NSN_SFUNC:
            n.sfunc->add(ns);
            break;
         case NSN_VAR:
            n.gv->add(ns);
            break;
         case NSN_METH:
            n.meth->add(ns);
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
   DLLLOCAL void deref() {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->deref();

      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->add(ns);
   }
};

static QoreListNode* make_list(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   QoreListNode* l = new QoreListNode;
   l->push(a1);
   l->push(a2);
   return l;
}

static QoreListNode* splice_expressions(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   //tracein("splice_expressions()");
   if (a1 && a1->getType() == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(a1);
      if (!l->isFinalized()) {
	 //printd(5, "LIST x\n");
	 l->push(a2);
	 return l;
      }
   }
   return make_list(a1, a2);
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2

struct MemberInfo {
protected:
   DLLLOCAL MemberInfo() {
   }

public:
   //enum mi_e { Member, Constant, Var };

   char* name;
   unsigned char type;
   union {
      QoreMemberInfo* memberInfo;
      QoreVarInfo* varInfo;
      AbstractQoreNode* exp;
   } u;

   DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : name(n), type(MI_Member)  {
      u.memberInfo = mi; 
      if (!mi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("member '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL MemberInfo(char* n) : name(n), type(MI_Member)  {
      u.memberInfo = 0; 
      if (parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("member '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL MemberInfo(char* n, AbstractQoreNode* exp) : name(n), type(MI_Constant) {
      u.exp = exp;
   }
   DLLLOCAL ~MemberInfo() {
      if (name)
	 free(name);
      switch (type) {
	 case MI_Member:
	    delete u.memberInfo;
	    break;
	 case MI_Var:
	    delete u.varInfo;
	    break;
	 case MI_Constant:
	    if (u.exp)
	       u.exp->deref(0);
	    break;
      }
   }
   DLLLOCAL member_pair_t getPair() {
      assert(type == MI_Member);
      member_pair_t m = std::make_pair(name, u.memberInfo);
      name = 0;
      u.memberInfo = 0;
      return m;
   }
   DLLLOCAL var_pair_t getVarPair() {
      assert(type == MI_Var);
      var_pair_t m = std::make_pair(name, u.varInfo);
      name = 0;
      u.varInfo = 0;
      return m;
   }
   DLLLOCAL AbstractQoreNode* takeExp() {
      assert(type == MI_Constant);
      AbstractQoreNode* rv = u.exp;
      u.exp = 0;
      return rv;
   }
};

struct ClassVarInfo : public MemberInfo {
   DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) {
      name = n;
      type = MI_Var;
      u.varInfo = vi; 
      if (!vi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL char* takeName() {
      char* n = name;
      name = 0;
      return n;
   }
   DLLLOCAL QoreVarInfo* takeVarInfo() {
      assert(u.varInfo);
      QoreVarInfo* rv = u.varInfo;
      u.varInfo = 0;
      return rv;
   }
};

class MemberList {
protected:
   // for new class members
   QoreMemberMap mmap;
   // for new class constants
   ConstantList cmap;
   // for new class static variables
   QoreVarMap vmap;
   
   DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
   }

public:
   DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
      if (!member)
	 return;

      if (member->type == MI_Member)
	 mmap.insert(member->getPair());
      else if (member->type == MI_Constant)
	 cmap.parseAdd(member->name, member->takeExp());
      else
	 vmap.insert(member->getVarPair());

      delete member;
   }

   DLLLOCAL ~MemberList() {
   }

   // takes over ownership of name and typeInfo
   DLLLOCAL int add(MemberInfo* member) {
      if (!member)
	 return -1;

      //std::auto_ptr<MemberInfo> mem(member);

      if (member->type == MI_Member) {
	 if (mmap.find(member->name) != mmap.end()) {
	    parse_error("duplicate member declaration '%s'", member->name);
            delete member;
	    return -1;
	 }

	 // add new member to list
	 mmap.insert(member->getPair());
         delete member;
      }
      else if (member->type == MI_Constant) {
	 if (cmap.inList(member->name)) {
	    parse_error("duplicate constant declaration '%s'", member->name);
            delete member;
	    return -1;
	 }
	 if (vmap.find(member->name)) {
	    parse_error("constant declaration collides with static class variable declaration '%s'", member->name);
            delete member;
	    return -1;
	 }	 

	 // add new constant to list
	 cmap.parseAdd(member->name, member->takeExp());
         delete member;
      }
      else {
	 assert(member->type == MI_Var);
	 if (vmap.find(member->name)) {
	    parse_error("duplicate static class variable declaration '%s'", member->name);
            delete member;
	    return -1;
	 }
	 if (cmap.inList(member->name)) {
	    parse_error("static class variable declaration collides with constant declaration '%s'", member->name);
            delete member;
	    return -1;
	 }

	 // add new member to list
	 vmap.insert(member->getVarPair());
         delete member;
      }

      return 0;
   }

   DLLLOCAL void mergePrivate(QoreClass *qc) {
      {
	 member_map_t::iterator i;
	 // merge private members
	 while ((i = mmap.begin()) != mmap.end()) {
	    qore_class_private::parseAddPrivateMember(*qc, i->first, i->second);
	    mmap.erase(i);
	 }
      }

      {
	 var_map_t::iterator i;
	 // merge private static class variables
	 while ((i = vmap.begin()) != vmap.end()) {
	    qore_class_private::parseAddPrivateStaticVar(qc, i->first, i->second);
	    vmap.erase(i);
	 }
      }

      // merge private constants
      qc->parseAssimilatePrivateConstants(cmap);
   }

   DLLLOCAL void mergePublic(QoreClass *qc) {
      // merge public members
      if (mmap.empty())
	 qc->parseSetEmptyPublicMemberDeclaration();
      else {
	 member_map_t::iterator i;

	 while ((i = mmap.begin()) != mmap.end()) {
	    qore_class_private::parseAddPublicMember(*qc, i->first, i->second);
	    mmap.erase(i);
	 }
      }

      {
	 var_map_t::iterator i;
	 // merge public static class variables
	 while ((i = vmap.begin()) != vmap.end()) {
	    qore_class_private::parseAddPublicStaticVar(qc, i->first, i->second);
	    vmap.erase(i);
	 }
      }

      // merge public constants
      qc->parseAssimilatePublicConstants(cmap);
   }
};

class EmptyPublicMemberList : public MemberList {
public:
   DLLLOCAL EmptyPublicMemberList() {
   }
};

struct ParserTypeStruct {
protected:
   DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : typeInfo(0), parseTypeInfo(n_parseTypeInfo) {
   }

   DLLLOCAL ParserTypeStruct() {
   }

public:
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL ParserTypeStruct(const QoreTypeInfo* n_typeInfo) : typeInfo(n_typeInfo), parseTypeInfo(0) {
   }

   DLLLOCAL ParserTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserTypeInfo(id);
      //printd(0, "ParserTypeStruct::ParserTypeStruct('%s') t: %p %s\n", id, t, t->getName());
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id);
   }

   DLLLOCAL ~ParserTypeStruct() {
      delete parseTypeInfo;
   }

   DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
      if (!this)
	 return 0;

      return typeInfo;
   }

   DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
      if (!this)
	 return 0;

      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL const char* getClassName() {
      assert(this);
      assert(parseTypeInfo);
      return parseTypeInfo->cscope->ostr;
   }
};

struct ParserScopedTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr)) {
   }
};

struct ParserOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserOrNothingTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserOrNothingTypeInfo(id);
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id, true);
   }
};

struct ParserScopedOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedOrNothingTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr, true)) {
   }
};

static AbstractQoreNode* process_dot(AbstractQoreNode* l, AbstractQoreNode* r) {
   qore_type_t rtype = r->getType();
   if (rtype == NT_BAREWORD) {
      BarewordNode* b = reinterpret_cast<BarewordNode*>(r);
      AbstractQoreNode* rv = new QoreTreeNode(l, OP_OBJECT_REF, b->makeQoreStringNode());
      b->deref();
      return rv;
   }

   if (rtype == NT_FUNCTION_CALL) {
      FunctionCallNode* f = reinterpret_cast<FunctionCallNode*>(r);
      assert(!f->getFunction());
      if (!f->isFinalized()) {
         MethodCallNode* m = new MethodCallNode(f->takeName(), f->take_args());
         f->deref();

         return new QoreDotEvalOperatorNode(l, m);
      }
   }

   return new QoreTreeNode(l, OP_OBJECT_REF, r);
}

// returns true if the node needs run-time evaluation, false if not
static bool needsEval(AbstractQoreNode* n) {
   if (!n)
      return false;

   qore_type_t ntype = n->getType();

   // if it's a constant or a function reference
   if (ntype == NT_BAREWORD || ntype == NT_CONSTANT || ntype == NT_FUNCREF)
      return false;

   if (ntype == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(n);
      if (l->needs_eval()) {
	 for (unsigned i = 0; i <l->size(); i++) {
	    if (needsEval(l->retrieve_entry(i)))
	       return true;
	 }
	 // here we set needs_eval to false so the list won't be evaluated again
	 l->clearNeedsEval();
      }
      return false;
   }

   if (ntype == NT_HASH) {
      QoreHashNode* h = reinterpret_cast<QoreHashNode*>(n);
      if (h->needs_eval()) {
	 HashIterator hi(h);
	 while (hi.next())
	    if (needsEval(hi.getValue()))
	       return true;
	 // here we set needs_eval to false so the hash won't be evaluated again
	 h->clearNeedsEval();
      }
      return false;
   }
   
   if (ntype == NT_TREE) {
      QoreTreeNode* tree = reinterpret_cast<QoreTreeNode*>(n);

      if (needsEval(tree->left) || (tree->right && needsEval(tree->right)))
	 return true;
      return tree->getOp()->hasEffect();
   }

   //printd(5, "needsEval() type %s = true\n", n->getTypeName());
   // we don't return needs_eval() here because some node types are not meant to be evaluated directly but are also not values
   return !n->is_value();
}

static int check_case(const char* op, AbstractQoreNode* exp) {
   // ignore if NULL (= NOTHING)
   if (exp && needsEval(exp)) {
      if (op)
	 parse_error("case expression with '%s' needs run-time evaluation", op);
      else
	 parse_error("case expression needs run-time evaluation", op);
      return -1;
   }
   return 0;
}

static void check_funcmod(int mod) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in function declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in function declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in function declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in function declaration");
}

static void check_classmod(int mod, QoreClass& qc) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in class declaration");
}

static void check_nsmod(int mod, qore_ns_private& ns) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
   if (!n || n->is_value())
      return false;

   if (n->getType() == NT_OPERATOR)
      return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

   const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
   return pn ? pn->has_effect() : true;
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL inline MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }
   DLLLOCAL inline ~MethodNode() {
      free(name);
      delete m;
   }
   DLLLOCAL inline void addAndDelete(QoreClass *qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }
};

static AbstractQoreNode* is_rewritable_op(AbstractQoreNode* n) {
   qore_type_t nt = get_node_type(n);
   if (nt == NT_OPERATOR) {
      QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n);
      if (op)
         return op->getRight();
   }

   return 0;
}

static AbstractQoreNode* checkRewriteList(QoreListNode* l) {
   // rewrite expression if it's a list without parentheses and
   // the first expression has one of the following operators:
   // =, +=, -=
   if (l->isFinalized())
      return l;

   AbstractQoreNode* e0 = l->retrieve_entry(0);

   AbstractQoreNode* r = is_rewritable_op(e0);
   if (r) {
      AbstractQoreNode* last = e0;
      AbstractQoreNode* top = e0;
      while (true) {
         AbstractQoreNode* nr = is_rewritable_op(r);
         if (!nr)
            break;
         last = r;
         r = nr;
      }
      assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last));
      // take first element from list (the tree) and make it the new expression
      QoreBinaryLValueOperatorNode* op = reinterpret_cast<QoreBinaryLValueOperatorNode*>(last);
      l->swap(0, op->swapRight(l));
      return top;
   }

   return l;
}

void ignore_return_value(AbstractQoreNode* n) {
   qore_type_t t = get_node_type(n);
   if (t == NT_TREE)
      reinterpret_cast<QoreTreeNode*>(n)->ignoreReturnValue();
   else if (t == NT_OPERATOR)
      reinterpret_cast<QoreOperatorNode*>(n)->ignoreReturnValue();
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}


#line 1249 "parser.cpp" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_HPP_INCLUDED
# define YY_YY_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOK_RETURN = 258,
    TOK_RETURNS = 259,
    TOK_MY = 260,
    TOK_DO = 261,
    TOK_TRY = 262,
    TOK_THROW = 263,
    TOK_CATCH = 264,
    TOK_WHERE = 265,
    TOK_WHILE = 266,
    TOK_IF = 267,
    TOK_FOR = 268,
    TOK_SUB = 269,
    TOK_THREAD_EXIT = 270,
    TOK_BREAK = 271,
    TOK_CONTINUE = 272,
    TOK_CONTEXT_ROW = 273,
    TOK_FIND = 274,
    TOK_FOREACH = 275,
    TOK_IN = 276,
    TOK_DELETE = 277,
    TOK_REMOVE = 278,
    TOK_PRIVATE = 279,
    TOK_PUBLIC = 280,
    TOK_SYNCHRONIZED = 281,
    TOK_DEPRECATED = 282,
    TOK_CONTEXT = 283,
    TOK_SORT_BY = 284,
    TOK_SORT_DESCENDING_BY = 285,
    TOK_SUB_CONTEXT = 286,
    TOK_CONST = 287,
    TOK_SUMMARIZE = 288,
    TOK_BY = 289,
    TOK_OUR = 290,
    TOK_RETHROW = 291,
    TOK_SWITCH = 292,
    TOK_CASE = 293,
    TOK_DEFAULT = 294,
    TOK_INHERITS = 295,
    TOK_ELSE = 296,
    TOK_STATIC = 297,
    TOK_NAMESPACE = 298,
    TOK_MODULE = 299,
    TOK_FINAL = 300,
    TOK_ABSTRACT = 301,
    TOK_UNREFERENCE = 302,
    P_INCREMENT = 303,
    P_DECREMENT = 304,
    PLUS_EQUALS = 305,
    MINUS_EQUALS = 306,
    AND_EQUALS = 307,
    OR_EQUALS = 308,
    MODULA_EQUALS = 309,
    MULTIPLY_EQUALS = 310,
    DIVIDE_EQUALS = 311,
    XOR_EQUALS = 312,
    SHIFT_LEFT_EQUALS = 313,
    SHIFT_RIGHT_EQUALS = 314,
    TOK_UNSHIFT = 315,
    TOK_PUSH = 316,
    TOK_POP = 317,
    TOK_SHIFT = 318,
    TOK_CHOMP = 319,
    TOK_TRIM = 320,
    LOGICAL_AND = 321,
    LOGICAL_OR = 322,
    LOGICAL_EQ = 323,
    LOGICAL_NE = 324,
    LOGICAL_LE = 325,
    LOGICAL_GE = 326,
    LOGICAL_CMP = 327,
    ABSOLUTE_EQ = 328,
    ABSOLUTE_NE = 329,
    REGEX_MATCH = 330,
    REGEX_NMATCH = 331,
    TOK_EXISTS = 332,
    TOK_INSTANCEOF = 333,
    SHIFT_RIGHT = 334,
    SHIFT_LEFT = 335,
    TOK_ELEMENTS = 336,
    TOK_KEYS = 337,
    TOK_NEW = 338,
    TOK_BACKGROUND = 339,
    TOK_ON_EXIT = 340,
    TOK_ON_SUCCESS = 341,
    TOK_ON_ERROR = 342,
    TOK_MAP = 343,
    TOK_FOLDR = 344,
    TOK_FOLDL = 345,
    TOK_SELECT = 346,
    TOK_SPLICE = 347,
    TOK_EXTRACT = 348,
    IMPLICIT_ELEMENT = 349,
    INTEGER = 350,
    QFLOAT = 351,
    NUMBER = 352,
    IDENTIFIER = 353,
    VAR_REF = 354,
    BACKQUOTE = 355,
    SELF_REF = 356,
    KW_IDENTIFIER_OPENPAREN = 357,
    SCOPED_REF = 358,
    SCOPED_VREF = 359,
    CONTEXT_REF = 360,
    COMPLEX_CONTEXT_REF = 361,
    QORE_CAST = 362,
    CLASS_STRING = 363,
    DATETIME = 364,
    QUOTED_WORD = 365,
    BINARY = 366,
    REGEX_SUBST = 367,
    REGEX_TRANS = 368,
    CLASS_SCOPED_REF = 369,
    BASE_CLASS_CALL = 370,
    REGEX = 371,
    REGEX_EXTRACT = 372,
    IMPLICIT_ARG_REF = 373,
    DOT_KW_IDENTIFIER = 374,
    TRY_MODULE_ERROR = 375,
    IFX = 376,
    NEG = 377
  };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PUBLIC 280
#define TOK_SYNCHRONIZED 281
#define TOK_DEPRECATED 282
#define TOK_CONTEXT 283
#define TOK_SORT_BY 284
#define TOK_SORT_DESCENDING_BY 285
#define TOK_SUB_CONTEXT 286
#define TOK_CONST 287
#define TOK_SUMMARIZE 288
#define TOK_BY 289
#define TOK_OUR 290
#define TOK_RETHROW 291
#define TOK_SWITCH 292
#define TOK_CASE 293
#define TOK_DEFAULT 294
#define TOK_INHERITS 295
#define TOK_ELSE 296
#define TOK_STATIC 297
#define TOK_NAMESPACE 298
#define TOK_MODULE 299
#define TOK_FINAL 300
#define TOK_ABSTRACT 301
#define TOK_UNREFERENCE 302
#define P_INCREMENT 303
#define P_DECREMENT 304
#define PLUS_EQUALS 305
#define MINUS_EQUALS 306
#define AND_EQUALS 307
#define OR_EQUALS 308
#define MODULA_EQUALS 309
#define MULTIPLY_EQUALS 310
#define DIVIDE_EQUALS 311
#define XOR_EQUALS 312
#define SHIFT_LEFT_EQUALS 313
#define SHIFT_RIGHT_EQUALS 314
#define TOK_UNSHIFT 315
#define TOK_PUSH 316
#define TOK_POP 317
#define TOK_SHIFT 318
#define TOK_CHOMP 319
#define TOK_TRIM 320
#define LOGICAL_AND 321
#define LOGICAL_OR 322
#define LOGICAL_EQ 323
#define LOGICAL_NE 324
#define LOGICAL_LE 325
#define LOGICAL_GE 326
#define LOGICAL_CMP 327
#define ABSOLUTE_EQ 328
#define ABSOLUTE_NE 329
#define REGEX_MATCH 330
#define REGEX_NMATCH 331
#define TOK_EXISTS 332
#define TOK_INSTANCEOF 333
#define SHIFT_RIGHT 334
#define SHIFT_LEFT 335
#define TOK_ELEMENTS 336
#define TOK_KEYS 337
#define TOK_NEW 338
#define TOK_BACKGROUND 339
#define TOK_ON_EXIT 340
#define TOK_ON_SUCCESS 341
#define TOK_ON_ERROR 342
#define TOK_MAP 343
#define TOK_FOLDR 344
#define TOK_FOLDL 345
#define TOK_SELECT 346
#define TOK_SPLICE 347
#define TOK_EXTRACT 348
#define IMPLICIT_ELEMENT 349
#define INTEGER 350
#define QFLOAT 351
#define NUMBER 352
#define IDENTIFIER 353
#define VAR_REF 354
#define BACKQUOTE 355
#define SELF_REF 356
#define KW_IDENTIFIER_OPENPAREN 357
#define SCOPED_REF 358
#define SCOPED_VREF 359
#define CONTEXT_REF 360
#define COMPLEX_CONTEXT_REF 361
#define QORE_CAST 362
#define CLASS_STRING 363
#define DATETIME 364
#define QUOTED_WORD 365
#define BINARY 366
#define REGEX_SUBST 367
#define REGEX_TRANS 368
#define CLASS_SCOPED_REF 369
#define BASE_CLASS_CALL 370
#define REGEX 371
#define REGEX_EXTRACT 372
#define IMPLICIT_ARG_REF 373
#define DOT_KW_IDENTIFIER 374
#define TRY_MODULE_ERROR 375
#define IFX 376
#define NEG 377

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 1190 "parser.ypp" /* yacc.c:355  */

   bool b;
   int i4;
   int64 integer;
   double decimal;
   QoreStringNode* String;
   char* string;
   BinaryNode* binary;
   AbstractQoreNode* node;
   QoreHashNode* hash;
   QoreListNode* list;
   AbstractStatement *statement;
   struct MemberInfo* memberinfo;
   struct ClassVarInfo* classvarinfo;
   StatementBlock *sblock;
   ContextModList* cmods;
   ContextMod *cmod;
   class HashElement *hashelement;
   QoreFunction *userfunc;	
   struct MethodNode* methodnode;
   class MemberList* memberlist;
   QoreClass *qoreclass;
   class ConstNode* constnode;
   QoreNamespace *ns;
   struct NSNodeList* nsnlist;
   struct NSNode* nsn;
   class ObjClassDef *classdef;
   DateTimeNode* datetime;
   RegexSubstNode* RegexSubst;
   RegexTransNode* RegexTrans;
   SwitchStatement *switchstmt;
   CaseNode* casenode;
   BCList* sclist;
   class BCNode* sclnode;
   BCAList* bcalist;
   BCANode* bcanode;
   NamedScope *nscope;
   QoreRegexNode* Regex;
   QoreImplicitArgumentNode* implicit_arg;
   RetTypeInfo* returnTypeInfo;
   struct ParserTypeStruct *parsertype;
   class ParseUserFunction* parsefunc;
   class ParseScopedUserFunction* sparsefunc;
   struct GVarDecl* gv;
   QoreNumberNode* num;
   TryModuleError* trymod;
   struct MethodDef* methoddef;

#line 1582 "parser.cpp" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (yyscan_t yyscanner);

#endif /* !YY_YY_PARSER_HPP_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 1239 "parser.ypp" /* yacc.c:358  */


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE *loc, yyscan_t scanner, const char* str) {
   //printd(5, "yyerror() location: %d-%d: \"%s\"\n", loc->first_line, loc->last_line, str);
   parse_error("%s", str);
}


#line 1624 "parser.cpp" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  195
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   8719

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  148
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  57
/* YYNRULES -- Number of rules.  */
#define YYNRULES  325
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  735

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   377

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   139,     2,     2,     2,   133,   126,     2,
     143,   146,   134,   131,   122,   132,   142,   135,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   125,   145,
     129,   123,   130,   124,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   141,   138,   147,   128,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   140,   127,   144,   137,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   136
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1468,  1468,  1469,  1473,  1476,  1479,  1487,  1491,  1495,
    1498,  1506,  1512,  1518,  1525,  1550,  1552,  1557,  1570,  1571,
    1577,  1582,  1585,  1590,  1593,  1598,  1603,  1609,  1616,  1621,
    1629,  1634,  1642,  1645,  1648,  1654,  1657,  1660,  1663,  1669,
    1674,  1677,  1683,  1686,  1692,  1695,  1700,  1703,  1708,  1710,
    1712,  1714,  1720,  1721,  1725,  1744,  1750,  1752,  1755,  1758,
    1761,  1764,  1767,  1770,  1773,  1776,  1779,  1782,  1785,  1788,
    1791,  1794,  1795,  1802,  1805,  1808,  1809,  1814,  1815,  1826,
    1828,  1830,  1835,  1837,  1841,  1851,  1855,  1863,  1868,  1874,
    1879,  1885,  1890,  1896,  1901,  1907,  1912,  1918,  1922,  1927,
    1931,  1936,  1940,  1945,  1950,  1956,  1960,  1967,  1985,  1986,
    1987,  1991,  1996,  2001,  2008,  2015,  2022,  2032,  2035,  2041,
    2044,  2051,  2054,  2057,  2060,  2063,  2066,  2072,  2076,  2081,
    2086,  2091,  2095,  2100,  2105,  2126,  2129,  2132,  2135,  2142,
    2143,  2149,  2152,  2158,  2161,  2164,  2170,  2174,  2177,  2182,
    2185,  2200,  2207,  2214,  2232,  2239,  2246,  2264,  2270,  2276,
    2279,  2288,  2293,  2301,  2304,  2311,  2314,  2321,  2324,  2327,
    2333,  2343,  2357,  2363,  2376,  2386,  2398,  2403,  2411,  2414,
    2423,  2426,  2432,  2435,  2442,  2445,  2452,  2453,  2458,  2459,
    2467,  2468,  2469,  2470,  2471,  2472,  2473,  2477,  2488,  2493,
    2498,  2507,  2518,  2534,  2539,  2548,  2559,  2576,  2578,  2593,
    2598,  2605,  2610,  2612,  2614,  2618,  2620,  2622,  2624,  2626,
    2628,  2641,  2654,  2658,  2666,  2676,  2693,  2731,  2734,  2741,
    2743,  2745,  2747,  2749,  2752,  2755,  2758,  2761,  2764,  2767,
    2770,  2773,  2776,  2779,  2788,  2790,  2792,  2795,  2798,  2800,
    2812,  2815,  2827,  2830,  2833,  2836,  2856,  2876,  2895,  2909,
    2923,  2937,  2941,  2944,  2947,  2950,  2953,  3032,  3039,  3043,
    3049,  3050,  3051,  3052,  3053,  3054,  3057,  3060,  3064,  3067,
    3069,  3070,  3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,
    3079,  3080,  3081,  3082,  3083,  3084,  3085,  3091,  3092,  3093,
    3123,  3128,  3133,  3141,  3146,  3147,  3148,  3151,  3154,  3167,
    3168,  3172,  3179,  3187,  3199,  3203,  3206,  3209,  3212,  3218,
    3221,  3228,  3229,  3230,  3231,  3232
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"public\"",
  "\"synchronized\"", "\"deprecated\"", "\"context\"", "\"sortBy\"",
  "\"sortDescendingBy\"", "\"subcontext\"", "\"const\"", "\"summarize\"",
  "\"by\"", "\"our\"", "\"rethrow\"", "\"switch\"", "\"case\"",
  "\"default\"", "\"inherits\"", "\"else\"", "\"static\"", "\"namespace\"",
  "\"module\"", "\"final\"", "\"abstract\"", "\"unreference\"",
  "\"++ operator\"", "\"-- operator\"", "\"+= operator\"",
  "\"-= operator\"", "\"&= operator\"", "\"|= operator\"",
  "\"%= operator\"", "\"*= operator\"", "\"/= operator\"",
  "\"^= operator\"", "\"<<= operator\"", "\">>= operator\"", "\"unshift\"",
  "\"push\"", "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"",
  "\"&& operator\"", "\"|| operator\"", "\"== operator\"",
  "\"!= operator\"", "\"<= operator\"", "\">= operator\"",
  "\"<=> operator\"", "\"=== operator\"", "\"!== operator\"",
  "\"=~ operator\"", "\"!~ operator\"", "\"exists\"", "\"instanceof\"",
  "\">> operator\"", "\"<< operator\"", "\"elements\"", "\"keys\"",
  "\"new\"", "\"background\"", "\"on_exit\"", "\"on_success\"",
  "\"on_error\"", "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"",
  "\"splice\"", "\"extract\"", "\"$#\"", "\"integer value\"",
  "\"floating-point value\"", "\"arbitrary-precision number\"",
  "\"identifier\"", "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"simple class declaration\"",
  "\"date/time value\"", "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'&'",
  "'|'", "'^'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'", "';'", "')'",
  "']'", "$accept", "top_level_commands", "top_level_command",
  "module_decls", "module_decl", "ppub", "gvardecl", "top_namespace_decl",
  "namespace_decls", "namespace_decl", "unscoped_const_decl",
  "scoped_const_decl", "block", "statement_or_block", "statements",
  "optname", "statement", "context_mods", "context_mod",
  "return_statement", "switch_statement", "case_block", "case_code",
  "try_statement", "myexp", "class_def", "inheritance_list",
  "superclass_list", "superclass", "class_attributes", "uncqtypedef",
  "qtypedef", "private_member_list", "public_member_list", "classvardecl",
  "member2", "member", "member_list", "member_list2", "ident_openparen",
  "inline_methoddef", "outofline_methoddef", "base_constructor_list",
  "base_constructors", "base_constructor", "nsc_modifiers",
  "method_modifiers", "method_modifier", "return_value", "sub_def",
  "scoped_sub_def", "list", "hash", "hash_element", "exp", "string",
  "scalar", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,    44,    61,    63,    58,    38,   124,    94,    60,
      62,    43,    45,    37,    42,    47,   377,   126,    92,    33,
     123,    91,    46,    40,   125,    59,    41,    93
};
# endif

#define YYPACT_NINF -474

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-474)))

#define YYTABLE_NINF -187

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-187)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    4789,  -116,  5325,   364,  5071,  5071,  5697,   -67,   -59,   -28,
       4,  -101,   -12,    -3,  -474,  5697,  5697,  5697,  5697,  -474,
     162,  -474,  -474,    52,  -474,   157,    52,     7,    53,  -474,
      58,  -474,  -474,  5697,  5697,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,   198,  5697,  5071,  5071,  5071,  5697,
    5697,  5697,  5697,  5697,  5697,  -474,  -474,  -474,  -474,    68,
    -474,  -474,   986,    10,  -474,  -474,    66,  -474,    73,  -474,
     114,  -474,  -474,  5697,   233,  5697,  5697,  5697,  5071,  5199,
    1336,  -474,   224,  -474,  -474,  -474,  -474,  -474,    89,  -474,
    -474,  -474,    77,   339,  -474,    97,    43,  -474,  -474,  -474,
    -474,  7044,  -474,  -474,  -474,   128,   238,    91,    28,   634,
    8346,   199,  -474,  5697,   186,   200,    -4,  4357,  -474,   299,
    -474,   303,  7077,  5697,  5697,  1195,   177,   185,  -474,   187,
     986,   986,  -474,  -474,  -474,  5891,  5987,   218,   218,   360,
    -474,   208,  4930,   248,   254,   230,  -474,  5697,   287,   396,
     396,  8346,  8346,   218,   218,   218,   218,   678,   218,   218,
     243,   252,   218,  -474,  -474,  -474,  8346,  8346,  8346,  8346,
    8346,  8346,  -474,   251,  8346,   986,  5697,  -474,   986,   218,
    -474,  -474,   218,   218,   218,  -474,  4501,  -474,    39,   265,
    -474,   -66,  -474,  6120,   282,  -474,  -474,   391,  -474,   240,
    -474,   266,  -474,  -474,   333,   385,   385,   358,  -474,  -474,
     274,    16,  -474,  -474,  -474,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,   505,   310,   399,  5697,  5697,  -474,
    5575,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,  5697,  5697,   986,  -474,   286,   293,
     423,   304,  8346,  -474,  -474,   986,  -474,  4645,   306,   322,
    -474,  6153,  6252,   321,  -474,  -474,   986,   305,   323,  5697,
     334,   365,   368,  5697,   344,   352,   356,  -474,  -474,  5697,
    5697,  5697,  6285,   383,   -72,  -474,   986,   986,  -474,   370,
    6384,   371,  -474,  -474,  -474,  5697,  5697,   540,  -474,  -474,
    5697,   377,   410,  5697,   442,   450,   367,   986,   986,   986,
     330,  -474,   167,   459,   463,   381,   986,   986,   986,   429,
     398,  8379,  8379,  8379,  8379,  8379,  8379,  8379,  8379,  8379,
    8379,  8500,  8500,   678,   678,   678,   678,   678,   678,   678,
    -474,  -474,  -474,  -474,  -474,  -474,  -474,   797,   797,  8379,
     828,  7863,  8576,  8576,  8576,   678,   678,   993,   993,   635,
     218,   218,  7830,  6020,  -474,   374,   407,  -474,   380,  -474,
    5697,   986,  5071,  5071,  1195,   382,   538,   538,  5795,  5697,
    5697,  5697,  6417,  5697,  5697,  5697,  7175,  7208,  6516,   420,
    5697,  -474,  -474,   416,   422,   -35,  -474,  -474,  8379,  8379,
     462,   465,  -474,   282,  8379,   438,  -474,  -474,  -474,  -474,
     986,   445,   451,   469,   461,   473,  -474,   474,  -474,   458,
    -474,  -474,  -474,  -474,    41,  -474,   719,  -474,  -474,   536,
     542,  -474,  -474,   519,  -474,   136,  -474,   161,  -474,   986,
     496,   498,   506,   508,   986,   986,   986,  5697,  -474,  -474,
    -474,   509,  6549,   518,  -474,   612,   510,   538,   -37,   525,
     525,   528,  6648,  7306,  7339,  -474,  6681,  6780,  6813,  -474,
    -474,   640,    78,  7437,  -474,  -474,   564,  -474,   538,  -474,
     529,   525,   525,   557,   986,  -474,  -474,  -474,   471,   483,
      45,  -474,  -474,  -474,  -474,   167,   -47,    30,   590,  -474,
    -474,   378,  -474,  -474,  -474,   211,   587,  -474,   389,   545,
     538,   538,   557,   986,   558,   559,   562,  8467,   567,  5071,
    5071,   986,   525,  -474,  -474,  -474,  -474,  5697,  5071,  -474,
    -474,  4930,  -474,  -474,  -474,   560,  5453,   584,    40,  -474,
    -474,   570,   572,   595,  -474,   525,   525,  -474,  -474,   525,
     579,   507,  -474,   625,   308,  -474,   -21,   631,   236,   -18,
    -474,  -474,  -474,  -474,  -474,   185,   204,   986,  -474,   538,
     525,   525,   538,   585,   525,   525,   557,  -474,  -474,  -474,
     588,  -474,  6912,  -474,  -474,  5697,  5697,  5697,  5697,   614,
     622,   616,  5697,  5697,  7959,  1477,  -474,  -474,   986,   986,
     564,  -474,  -474,  -474,   557,  -474,   717,   166,   -20,  -474,
     652,   650,  -474,  -474,   250,   651,  -474,  -474,   454,  -474,
     986,   607,   525,  -474,  -474,   523,   525,  -474,  -474,   532,
    5071,  -474,  6945,  7992,  8088,  8121,   630,   637,  1621,  8217,
    8250,  1765,  1909,   613,   620,  -474,    56,   665,  5697,  -474,
      13,   184,  -474,  -474,  -474,  -474,   621,   557,  -474,  -474,
    -474,  -474,  -474,  -474,  -474,  -474,  2053,  2197,  2341,  2485,
    2629,  2773,  2917,  3061,  3205,  -474,  -474,  5697,  -474,   223,
    7470,  5697,   986,  -474,  5697,   986,  -474,   557,   538,  4930,
    3349,  3493,  3637,  3781,  3925,  4069,  4213,  7568,  5697,   986,
    -474,  -474,  7601,   626,  7699,   627,   533,   541,  -474,  -474,
    7732,   628,  -474,   636,  -474,   638,  -474,  -474,  -474,  -474,
    -474,   639,  -474,  -474,  -474
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,   139,   139,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,   230,   139,   139,   139,   139,   190,
     194,   192,   193,    52,    77,     0,    52,     0,     0,   191,
       0,   195,   196,   139,   139,   139,   139,   139,   139,   139,
     139,   139,   139,   139,     0,   139,     0,     0,     0,   139,
     139,   139,   139,   139,   139,   315,   322,   321,   325,   228,
     303,   269,     0,   219,   229,   231,     0,   324,   319,   216,
       0,   314,    14,   139,     0,   139,   139,   139,     0,   139,
       0,     2,     0,   227,    12,     8,     7,    10,     0,    75,
      56,     6,   140,     0,     9,     0,   187,   188,     4,     5,
     217,     0,   323,   215,    76,     0,   194,   219,   140,     0,
      83,   224,   136,   139,   140,     0,   219,     0,    47,     0,
      46,     0,     0,   139,   139,     0,     0,     0,   169,     0,
       0,     0,    72,    73,    74,     0,     0,   316,   317,     0,
      53,     0,     0,     0,     0,     0,    57,   139,     0,   262,
     264,   249,   251,   252,   250,   253,   254,   244,   245,   248,
       0,     0,   302,    59,    60,    61,   257,   258,   259,   260,
     255,   256,   110,     0,   109,     0,   139,   320,     0,   296,
     137,   138,   297,   299,   298,    49,     0,    48,   228,   219,
     309,     0,   209,     0,   215,     1,     3,   139,    71,     0,
     222,     0,   220,   221,     0,   118,   118,     0,   194,   135,
     136,     0,   189,   263,   265,   139,   139,   139,   139,   139,
     139,   139,   139,   139,   139,   139,   139,   139,   139,   139,
     139,   139,   139,   139,     0,     0,     0,   139,   139,   307,
     208,   139,   139,   139,   139,   139,   139,   139,   139,   139,
     139,   139,   139,   139,   139,   139,     0,    54,     0,     0,
       0,   217,     0,   223,   225,     0,    45,     0,     0,     0,
      58,     0,     0,     0,   168,   167,     0,     0,     0,   139,
       0,     0,     0,   139,     0,     0,     0,    62,    78,   139,
     139,   139,     0,     0,     0,    15,     0,     0,   268,     0,
       0,     0,    11,    50,    51,   139,   139,   211,   218,   308,
     139,    23,    21,   139,   140,     0,     0,     0,     0,     0,
     186,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   270,   271,   283,   286,   287,   288,   282,   284,   285,
     277,   278,   275,   279,   276,   246,   247,   290,   289,   207,
     243,     0,   273,   272,   274,   281,   280,   291,   292,   293,
     295,   294,     0,     0,   306,     0,     0,   226,     0,    44,
     139,     0,     0,     0,     0,     0,   198,   198,     0,   139,
     139,   139,     0,   139,   139,   139,     0,     0,     0,     0,
     139,    13,    16,     0,     0,   181,   318,   267,   213,   214,
       0,     0,   210,     0,   212,   217,    22,    20,    25,    24,
       0,     0,     0,     0,     0,   136,    29,     0,    38,   186,
      30,    33,    32,    34,     0,    39,   187,    35,    36,     0,
       0,   121,   122,   117,   119,   186,   113,   186,   114,     0,
       0,     0,     0,     0,     0,     0,     0,   139,   305,   304,
     266,     0,     0,     0,    67,    65,     0,   198,   139,     0,
       0,     0,     0,     0,     0,    77,     0,     0,     0,    40,
      42,     0,     0,     0,   300,   301,     0,    55,   198,    26,
       0,     0,     0,   181,     0,    37,    27,    31,     0,     0,
       0,   125,   126,   123,   124,     0,   190,   194,     0,   115,
     130,   186,   128,   129,   127,     0,   187,   116,   186,     0,
     198,   198,   181,     0,     0,     0,     0,   261,     0,     0,
       0,     0,     0,   140,   197,   310,   199,   139,     0,    41,
      43,     0,    79,    80,    81,     0,   139,     0,     0,    85,
      17,     0,     0,   180,   182,     0,     0,   311,   200,     0,
       0,     0,   120,   161,   139,   163,     0,     0,   139,     0,
     111,   134,   132,   133,   131,   135,     0,     0,   112,   198,
       0,     0,   198,     0,     0,     0,   181,    68,   107,    66,
       0,   203,     0,    70,    64,   139,   139,   139,   139,     0,
       0,     0,   139,   139,     0,     0,    84,    86,     0,     0,
       0,   178,   204,   179,   181,   162,     0,     0,   135,   160,
     140,     0,   159,   165,   139,     0,   141,   145,   139,   143,
       0,     0,     0,   312,   201,     0,     0,   313,   202,     0,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   135,     0,   139,   157,
       0,     0,   142,   166,   164,   144,     0,   181,   205,   176,
     174,   206,   177,   175,    69,    77,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   184,   185,   139,   147,     0,
       0,   139,     0,   154,   139,     0,   151,   181,   198,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   139,     0,
     146,   158,     0,     0,     0,     0,     0,     0,    63,   149,
       0,     0,   155,     0,   152,     0,   173,   171,   172,   170,
     148,     0,   156,   153,   150
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -474,  -474,   691,  -474,   485,  -474,  -311,  -309,  -474,   351,
       1,  -299,   155,    17,  -100,   756,    18,  -473,  -474,  -474,
    -474,  -474,   237,  -474,   617,  -297,   580,  -474,   283,   342,
       3,     2,  -144,  -110,  -474,  -459,   168,   289,   231,  -180,
     -99,  -295,  -435,  -474,   188,  -235,    12,   -89,  -230,  -275,
    -274,  -105,  -474,   493,    -2,   733,   -51
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    80,    81,   294,   295,    82,    83,    84,   429,   430,
     619,    86,   118,   119,   186,   141,   120,   142,   288,    88,
      89,   548,   549,    90,   173,    91,   323,   443,   444,   511,
     108,    93,   512,   513,   622,   623,   565,   566,   624,   131,
     514,    94,   488,   553,   554,    95,   109,    97,   469,    98,
      99,   100,   191,   192,   101,   102,   103
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     110,    85,   541,    92,   122,   115,   114,   212,   261,   427,
    -136,   428,    96,   135,   136,   137,   138,   267,    87,   318,
     212,   432,   121,   433,  -136,   435,   293,   327,   194,   104,
     329,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   258,   162,   132,   437,   438,   166,   167,   168,
     169,   170,   171,  -135,   563,   498,   307,   207,   559,   561,
     174,   209,   567,   163,   164,   165,   112,    19,   208,    21,
      22,   179,   401,   182,   183,   184,   123,   193,   546,   547,
     308,    85,  -135,    92,   124,    29,   126,   582,    31,    32,
     486,   199,    96,   564,  -136,  -136,   187,    74,    87,   211,
    -136,   625,   127,   658,   625,  -136,   128,   129,  -136,  -136,
     487,   262,   260,  -136,  -136,   125,   546,   547,   427,   330,
     428,   271,   272,   174,   626,   659,   200,   629,   174,   174,
     432,   563,   433,   133,   435,   187,   691,  -135,  -135,   265,
     204,   209,   134,  -135,   201,   292,   210,   130,   330,   455,
     140,   639,   146,   175,   437,   438,   692,   470,   693,   287,
     506,   507,    21,    22,   305,   663,  -135,  -135,   508,   663,
     568,  -135,  -135,   174,   300,   200,   174,    74,    29,   687,
     201,    31,    32,    68,   606,   506,   507,    21,    22,  -136,
    -136,   439,   440,   508,   139,  -136,   147,   -19,   148,   315,
     314,   688,   699,    29,   304,   205,    31,    32,   415,   176,
     515,   206,   515,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   698,   185,   198,   357,   358,   532,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   174,   143,   413,   178,   555,   197,
     144,   616,   716,   174,   656,   441,   213,   214,   508,   112,
     442,   130,   185,   -19,   174,   616,   515,   388,   617,  -136,
     509,   392,   508,   515,   263,   304,   126,   396,   397,   398,
     580,   581,   617,   126,   174,   174,   160,  -135,  -135,   264,
      74,   161,   127,   408,   409,   517,   128,   694,   414,   575,
     268,   262,   269,   128,   112,   174,   174,   174,   318,   327,
     274,   431,   126,   434,   174,   174,   174,   695,   275,   696,
     276,   180,   436,   616,   618,   577,   181,   239,   127,   112,
     508,   303,   128,   316,   424,    74,   708,   212,   618,   632,
     617,   283,   635,   112,    19,    20,    21,    22,   253,   254,
     255,   256,    25,  -136,  -136,   -18,   709,   572,   710,  -136,
      74,   289,    29,   291,   572,    31,    32,   290,   462,   174,
     627,   455,   174,   317,    74,   293,   296,   472,   473,   474,
     306,   476,   477,   478,   662,   297,   630,   298,   483,   464,
     465,   573,   506,   507,    21,    22,   618,   310,   573,   319,
     508,   112,   574,   506,   507,    21,    22,   328,   174,   574,
      29,   508,   303,    31,    32,   322,   354,   212,   209,   317,
     431,    29,   434,   425,    31,    32,   326,   376,   202,   500,
     126,   436,    74,   203,  -187,  -187,   510,   174,   510,   380,
     377,   386,   174,   174,   174,   527,   127,   516,   281,   516,
     128,   325,   111,   282,    74,   381,   384,   112,   717,   387,
     534,   533,   424,   320,   426,  -135,  -135,   389,   321,   616,
    -135,  -135,    19,    20,    21,    22,   508,   393,   390,   311,
      25,   391,   174,   -18,   312,   394,   617,   355,    74,   395,
      29,   326,   356,    31,    32,   652,   400,   113,  -136,  -136,
     420,   126,   571,  -136,  -136,   239,   405,   407,   576,   571,
     460,   174,   570,   516,   449,    74,   461,   127,   467,   174,
     516,   128,   453,   578,   313,   592,   253,   254,   255,   256,
     416,   456,   468,   126,   604,   417,   588,   589,   681,   418,
     454,   684,   618,   126,   419,   593,   209,   112,   594,   127,
     482,   425,   484,   128,   129,   126,   621,   620,   485,   127,
     621,   620,   454,   128,   316,   174,   700,   701,   702,   703,
     704,   127,   705,   706,   489,   128,   325,   305,    74,   126,
     306,   491,    74,   642,   643,   644,   645,   492,   665,   445,
     649,   650,   496,   447,   446,   127,   174,   174,   448,   128,
     453,    19,   208,    21,    22,   493,   494,   350,   351,   495,
     657,   352,   353,   187,   535,   536,   621,   620,   174,    29,
     621,   620,    31,    32,   501,    56,    57,    58,   410,   502,
     503,   505,   520,   411,   521,   504,   557,   558,   259,    67,
      68,   523,   522,   530,   487,   531,   690,   674,    19,   208,
      21,    22,   551,   117,   529,   117,   187,   552,   669,   187,
     304,   537,   117,   117,   545,   556,    29,   672,   726,    31,
      32,   117,   486,   213,   214,   707,   728,   591,   143,   712,
     174,   579,   714,   174,   187,   187,   187,   187,   187,   304,
     187,   187,   304,   595,   584,   585,   720,   174,   586,   605,
     611,   612,   587,   608,   613,   609,   718,   610,   304,   304,
     304,   304,   304,   304,   304,   614,   213,   214,   615,   281,
     646,   636,   209,   499,   640,   633,   634,   112,   647,   637,
     638,   648,   273,    19,   208,    21,    22,   277,   278,   567,
     660,   661,   563,   667,   239,   679,   236,   237,   238,   685,
     185,    29,   680,   689,    31,    32,   686,   697,    74,   251,
     252,   196,   723,   725,   731,   253,   254,   255,   256,   402,
     497,   732,   145,   733,   734,   607,   324,   668,   562,   518,
     670,   671,   299,   664,   673,   301,   569,   239,   655,   628,
     412,   177,     0,   185,     0,     0,   185,   303,     0,   248,
     249,   250,   251,   252,     0,     0,     0,   209,   253,   254,
     255,   256,   210,     0,     0,     0,     0,     0,     0,     0,
       0,   185,   185,   185,   185,   185,   303,   185,   185,   303,
       0,     0,     0,     0,     0,   213,   214,     0,     0,     0,
       0,     0,     0,    74,     0,   303,   303,   303,   303,   303,
     303,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   727,   729,   375,     0,     0,   213,   214,     0,     0,
       0,     0,   378,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   385,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,     0,
       0,     0,     0,   403,   404,     0,   239,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   248,   249,
     250,   251,   252,     0,   421,   422,   423,   253,   254,   255,
     256,     0,     0,   450,   451,   452,     0,   239,     0,     0,
       0,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     3,     0,     0,     0,     0,     0,     0,   463,     0,
     105,   466,     0,     0,    14,    15,     0,     0,    17,    18,
      19,   106,    21,    22,     0,     0,     0,     0,     0,     0,
       0,   -18,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,   490,     0,     0,
       0,   213,   214,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,   519,    42,    43,    44,
      45,   524,   525,   526,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,  -139,    60,    61,    62,   107,
    -139,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,   560,   239,     0,     0,     0,     0,     0,    73,     0,
      74,     0,     0,    75,    76,    77,   250,   251,   252,    79,
       0,     0,  -108,   253,   254,   255,   256,     0,     0,     0,
     583,     0,     0,     0,     0,     0,     0,     0,   590,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   631,     0,   172,     0,     0,     0,
       3,     0,     0,     0,     0,     0,     0,     0,     0,   105,
       0,     0,     0,    14,    15,     0,     0,    17,    18,    19,
     106,    21,    22,     0,     0,   653,   654,     0,     0,     0,
     -18,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,   666,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   107,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,   713,
      70,     0,   715,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   721,    73,     0,    74,
       0,     0,    75,    76,    77,     0,   195,     1,    79,     2,
    -108,     3,     4,     5,     6,     0,     0,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,    22,    23,     0,     0,    24,    25,    26,
       0,   -18,    27,    28,     0,     0,     0,     0,    29,  -186,
      30,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,  -139,    60,    61,    62,    63,
    -139,    64,    65,    66,  -186,    67,    68,    69,     0,     0,
    -186,    70,     0,     0,    71,     0,    72,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,     0,
      74,     0,     0,    75,    76,    77,    78,     0,     1,    79,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,  -106,  -106,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,  -106,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,  -102,
    -102,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,  -102,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,  -104,  -104,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,  -104,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,  -105,  -105,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,  -105,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,   -92,   -92,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,   -92,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,   -90,   -90,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   -90,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,   -88,
     -88,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   -88,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,   -98,   -98,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,   -98,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,  -100,  -100,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,  -100,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,  -101,  -101,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,  -101,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,   -94,   -94,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   -94,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,   -96,
     -96,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   -96,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,  -103,  -103,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,  -103,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,   -91,   -91,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,   -91,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,   -89,   -89,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,   -89,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,   -87,   -87,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   -87,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,   -97,
     -97,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   -97,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,   -99,   -99,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,   -99,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,   -93,   -93,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,   -93,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,   -95,   -95,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,   -95,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   266,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,     0,
       0,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   302,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,   379,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,    22,    23,     0,     0,
      24,    25,    26,     0,   -18,    27,    28,     0,     0,     0,
       0,    29,  -186,    30,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,    63,  -139,    64,    65,    66,  -186,    67,    68,
      69,     0,     0,  -186,    70,     0,     0,    71,     0,    72,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,    78,
       0,     1,    79,     2,     0,     3,     4,     5,     6,     0,
     284,     7,     8,     9,   105,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,   106,    21,    22,    23,   285,
     286,    24,     0,    26,     0,   -18,    27,    28,     0,     0,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,  -139,
      60,    61,    62,   116,  -139,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,     0,    74,     0,     0,    75,    76,    77,
     117,     0,     1,    79,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,     0,
       0,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     3,    74,     0,     0,    75,    76,
      77,   117,     0,   105,    79,     0,     0,    14,    15,     0,
       0,    17,    18,    19,   106,    21,    22,     0,     0,     0,
       0,     0,     0,     0,   -18,     0,     0,     0,     0,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,     0,     0,     0,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,   188,     0,    60,
      61,    62,   189,     0,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       3,    73,     0,    74,     0,     0,    75,    76,    77,   105,
       0,     0,    79,    14,    15,   190,     0,    17,    18,    19,
     106,    21,    22,     0,     0,     0,     0,     0,     0,     0,
     -18,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,     0,    60,    61,    62,   107,     0,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     3,    74,
       0,     0,    75,    76,    77,     0,     0,   105,    79,     0,
     -82,    14,    15,     0,     0,    17,    18,    19,   106,    21,
      22,     0,     0,     0,     0,     0,     0,     0,   -18,     0,
       0,     0,     0,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,   596,     0,   597,   598,     0,     0,     0,   599,   600,
      41,     0,     0,     0,    42,    43,    44,    45,     0,     0,
       0,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,     0,    60,    61,    62,   107,     0,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,   601,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       3,     0,   602,   603,     0,    73,     0,    74,     0,   105,
      75,    76,    77,    14,    15,     0,    79,    17,    18,    19,
     106,    21,    22,     0,     0,     0,     0,     0,     0,     0,
     -18,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   107,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     3,     0,     0,     0,     0,    73,     0,    74,
       0,   105,    75,    76,    77,    14,    15,     0,    79,    17,
      18,    19,   106,    21,    22,     0,     0,     0,     0,     0,
       0,     0,   -18,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,     0,     0,     0,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,     0,    60,    61,    62,
     107,     0,    64,    65,    66,   471,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,     0,     0,     0,
      79,     0,     0,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   279,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   280,     0,
     239,     0,     0,   240,   241,   242,     0,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,     0,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,     0,     0,   459,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
       0,   236,   237,   238,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,     0,   309,     0,     0,     0,
       0,     0,   239,     0,     0,   240,   241,   242,     0,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,     0,
       0,     0,     0,   253,   254,   255,   256,     0,     0,   382,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,     0,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,     0,     0,   383,     0,
       0,     0,     0,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,     0,
       0,   399,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,     0,   236,   237,   238,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,     0,     0,
       0,     0,     0,   239,     0,     0,   240,   241,   242,     0,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
       0,     0,     0,     0,   253,   254,   255,   256,     0,     0,
     406,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,   475,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
       0,     0,     0,     0,     0,   239,     0,     0,   240,   241,
     242,     0,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256,
       0,     0,   481,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,     0,   528,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,     0,   538,     0,     0,     0,     0,     0,
     239,     0,     0,   240,   241,   242,     0,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,     0,     0,   542,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
       0,   236,   237,   238,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,     0,   543,     0,     0,     0,
       0,     0,   239,     0,     0,   240,   241,   242,     0,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,     0,
       0,     0,     0,   253,   254,   255,   256,     0,     0,   544,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,     0,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,     0,     0,   641,     0,
       0,     0,     0,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,     0,
       0,   675,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,     0,   236,   237,   238,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,     0,     0,
       0,     0,     0,   239,     0,     0,   240,   241,   242,     0,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
       0,     0,     0,     0,   253,   254,   255,   256,     0,   257,
       0,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,   270,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,     0,
       0,     0,     0,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,     0,
     479,     0,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,   480,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
       0,     0,     0,     0,     0,   239,     0,     0,   240,   241,
     242,     0,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256,
       0,   539,     0,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,   540,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,   550,     0,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,   711,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,   719,     0,     0,     0,     0,     0,     0,
     239,     0,     0,   240,   241,   242,     0,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,     0,   722,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,   724,     0,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,     0,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,     0,   730,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
       0,   236,   237,   238,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,   458,     0,     0,     0,     0,     0,
       0,     0,   239,     0,     0,   240,   241,   242,   457,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,     0,
       0,     0,     0,   253,   254,   255,   256,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,   651,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,     0,     0,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,   676,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,   677,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,     0,     0,     0,     0,     0,     0,     0,
     239,     0,     0,   240,   241,   242,   678,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,   682,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,     0,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,   683,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
       0,     0,     0,     0,     0,   239,     0,     0,   240,   241,
     242,     0,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256,
       0,     0,     0,     0,     0,     0,     0,     0,   239,     0,
       0,     0,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   213,   214,     0,     0,   253,
     254,   255,   256,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,     0,
       0,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,     0,     0,     0,     0,     0,     0,   239,
       0,     0,     0,     0,   213,   214,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256
};

static const yytype_int16 yycheck[] =
{
       2,     0,   475,     0,     6,     3,     3,    96,   113,   320,
      14,   320,     0,    15,    16,    17,    18,   117,     0,   199,
     109,   320,     5,   320,    14,   320,    98,   207,    79,   145,
      14,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    14,    45,   145,   320,   320,    49,    50,    51,
      52,    53,    54,    14,   101,    14,   122,    14,   493,    14,
      62,    98,    32,    46,    47,    48,   103,    24,    25,    26,
      27,    73,   144,    75,    76,    77,   143,    79,    38,    39,
     146,    80,    14,    80,   143,    42,    82,   522,    45,    46,
     125,    14,    80,   140,    98,    99,    78,   134,    80,    96,
     104,   122,    98,   123,   122,    14,   102,   103,    98,    99,
     145,   113,   109,   103,   104,   143,    38,    39,   429,   103,
     429,   123,   124,   125,   145,   145,    98,   145,   130,   131,
     429,   101,   429,   145,   429,   117,   123,    98,    99,   143,
      43,    98,   145,   104,   103,   147,   103,   143,   103,   329,
      98,   586,   145,   143,   429,   429,   143,   387,   145,   142,
      24,    25,    26,    27,   125,   624,    98,    99,    32,   628,
     140,   103,   104,   175,   176,    98,   178,   134,    42,   123,
     103,    45,    46,   110,   144,    24,    25,    26,    27,    98,
      99,    24,    25,    32,    32,   104,   143,    35,   140,   197,
     197,   145,   675,    42,   186,   108,    45,    46,   313,   143,
     445,   114,   447,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   667,    78,   145,   237,   238,   467,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,    98,   307,   143,   488,    35,
     103,    25,   697,   265,    98,    98,    48,    49,    32,   103,
     103,   143,   117,    35,   276,    25,   511,   279,    42,    14,
     144,   283,    32,   518,    98,   267,    82,   289,   290,   291,
     520,   521,    42,    82,   296,   297,    98,    98,    99,    99,
     134,   103,    98,   305,   306,   144,   102,   123,   310,    98,
      11,   313,     9,   102,   103,   317,   318,   319,   498,   499,
     143,   320,    82,   320,   326,   327,   328,   143,   143,   145,
     143,    98,   320,    25,    98,   515,   103,   119,    98,   103,
      32,   186,   102,   103,    14,   134,   123,   436,    98,   579,
      42,   143,   582,   103,    24,    25,    26,    27,   140,   141,
     142,   143,    32,    98,    99,    35,   143,   511,   145,   104,
     134,   123,    42,   143,   518,    45,    46,   123,   380,   381,
     144,   561,   384,   143,   134,    98,   143,   389,   390,   391,
     125,   393,   394,   395,   144,   143,   576,   146,   400,   382,
     383,   511,    24,    25,    26,    27,    98,   125,   518,   143,
      32,   103,   511,    24,    25,    26,    27,   143,   420,   518,
      42,    32,   267,    45,    46,    40,   116,   516,    98,   143,
     429,    42,   429,   103,    45,    46,   143,    14,    99,   436,
      82,   429,   134,   104,    48,    49,   445,   449,   447,   143,
     146,   146,   454,   455,   456,   457,    98,   445,    98,   447,
     102,   103,    98,   103,   134,   143,   145,   103,   698,   146,
     468,   468,    14,   140,   144,    98,    99,   143,   145,    25,
     103,   104,    24,    25,    26,    27,    32,   143,   123,    98,
      32,   123,   494,    35,   103,   143,    42,    98,   134,   143,
      42,   143,   103,    45,    46,   605,   123,   143,    98,    99,
     143,    82,   511,   103,   104,   119,   146,   146,   515,   518,
     146,   523,   144,   511,   143,   134,   146,    98,   146,   531,
     518,   102,   103,   144,   143,   537,   140,   141,   142,   143,
      98,   143,     4,    82,   546,   103,   529,   530,   648,    99,
     143,   651,    98,    82,   104,   538,    98,   103,   541,    98,
     140,   103,   146,   102,   103,    82,   564,   564,   146,    98,
     568,   568,   143,   102,   103,   577,   676,   677,   678,   679,
     680,    98,   682,   683,   146,   102,   103,   125,   134,    82,
     125,   146,   134,   595,   596,   597,   598,   146,   144,   140,
     602,   603,   144,   140,   145,    98,   608,   609,   145,   102,
     103,    24,    25,    26,    27,   146,   143,   112,   113,   145,
     617,   116,   117,   605,   469,   470,   624,   624,   630,    42,
     628,   628,    45,    46,    98,    95,    96,    97,    98,   103,
      98,   122,   146,   103,   146,   103,   491,   492,    14,   109,
     110,   143,   146,    41,   145,   145,   658,   640,    24,    25,
      26,    27,    98,   140,   146,   140,   648,   103,   145,   651,
     652,   143,   140,   140,    34,   146,    42,   145,   145,    45,
      46,   140,   125,    48,    49,   687,   145,   532,    98,   691,
     692,   146,   694,   695,   676,   677,   678,   679,   680,   681,
     682,   683,   684,   143,   146,   146,   708,   709,   146,   125,
     555,   556,   145,   143,   559,   143,   699,   122,   700,   701,
     702,   703,   704,   705,   706,   146,    48,    49,   103,    98,
     116,   146,    98,    14,   146,   580,   581,   103,   116,   584,
     585,   125,   125,    24,    25,    26,    27,   130,   131,    32,
      98,   101,   101,   146,   119,   125,    78,    79,    80,   146,
     605,    42,   125,    98,    45,    46,   146,   146,   134,   134,
     135,    80,   146,   146,   146,   140,   141,   142,   143,   294,
     429,   145,    26,   145,   145,   548,   206,   632,   505,   447,
     635,   636,   175,   625,   639,   178,   507,   119,   610,   568,
     307,    68,    -1,   648,    -1,    -1,   651,   652,    -1,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    98,   140,   141,
     142,   143,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   676,   677,   678,   679,   680,   681,   682,   683,   684,
      -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,   134,    -1,   700,   701,   702,   703,   704,
     705,   706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   716,   717,   256,    -1,    -1,    48,    49,    -1,    -1,
      -1,    -1,   265,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   276,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    -1,
      -1,    -1,    -1,   296,   297,    -1,   119,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,
     133,   134,   135,    -1,   317,   318,   319,   140,   141,   142,
     143,    -1,    -1,   326,   327,   328,    -1,   119,    -1,    -1,
      -1,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,
      -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,
      14,   384,    -1,    -1,    18,    19,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,   420,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,   449,    81,    82,    83,
      84,   454,   455,   456,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,   111,    -1,    -1,
      -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,
      -1,   494,   119,    -1,    -1,    -1,    -1,    -1,   132,    -1,
     134,    -1,    -1,   137,   138,   139,   133,   134,   135,   143,
      -1,    -1,   146,   140,   141,   142,   143,    -1,    -1,    -1,
     523,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   577,    -1,     1,    -1,    -1,    -1,
       5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    14,
      -1,    -1,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    -1,    -1,   608,   609,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,   630,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,   692,
     115,    -1,   695,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   709,   132,    -1,   134,
      -1,    -1,   137,   138,   139,    -1,     0,     1,   143,     3,
     145,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,    43,
      44,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,    -1,    -1,
     114,   115,    -1,    -1,   118,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
     134,    -1,    -1,   137,   138,   139,   140,    -1,     1,   143,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    -1,
      -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    32,    33,    -1,    35,    36,    37,    -1,    -1,    -1,
      -1,    42,    43,    44,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,    -1,    -1,   114,   115,    -1,    -1,   118,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,     1,   143,     3,    -1,     5,     6,     7,     8,    -1,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    35,    36,    37,    -1,    -1,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,
     140,    -1,     1,   143,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    -1,
      -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,     5,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    14,   143,    -1,    -1,    18,    19,    -1,
      -1,    22,    23,    24,    25,    26,    27,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    -1,    -1,    -1,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,   132,    -1,   134,    -1,    -1,   137,   138,   139,    14,
      -1,    -1,   143,    18,    19,   146,    -1,    22,    23,    24,
      25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,     5,   134,
      -1,    -1,   137,   138,   139,    -1,    -1,    14,   143,    -1,
     145,    18,    19,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    -1,    75,    76,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    -1,    -1,
      -1,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,   116,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,   129,   130,    -1,   132,    -1,   134,    -1,    14,
     137,   138,   139,    18,    19,    -1,   143,    22,    23,    24,
      25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    14,   137,   138,   139,    18,    19,    -1,   143,    22,
      23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,   105,   106,   107,    10,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,    -1,    -1,    -1,
     143,    -1,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    21,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,    -1,
     119,    -1,    -1,   122,   123,   124,    -1,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,    -1,    -1,   147,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,    -1,   146,    -1,    -1,    -1,
      -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,
      -1,   146,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    80,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,    -1,
     146,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,   146,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,
     124,    -1,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
      -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,    -1,   146,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,
     119,    -1,    -1,   122,   123,   124,    -1,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    -1,    -1,   146,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,    -1,   146,    -1,    -1,    -1,
      -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,
      -1,   146,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    80,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,   145,
      -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,   145,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,
     145,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,   145,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,
     124,    -1,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
      -1,   145,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,   145,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,   145,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,   145,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,   145,    -1,    -1,    -1,    -1,    -1,    -1,
     119,    -1,    -1,   122,   123,   124,    -1,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    -1,   145,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,   145,    -1,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    -1,   145,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   119,    -1,    -1,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,   140,   141,   142,   143,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     119,    -1,    -1,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,
     124,    -1,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,    -1,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    48,    49,    -1,    -1,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,
      -1,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,    -1,    -1,    48,    49,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    31,    32,    33,    36,    37,    42,
      44,    45,    46,    48,    49,    60,    61,    62,    63,    64,
      65,    77,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
     100,   101,   102,   103,   105,   106,   107,   109,   110,   111,
     115,   118,   120,   132,   134,   137,   138,   139,   140,   143,
     149,   150,   153,   154,   155,   158,   159,   164,   167,   168,
     171,   173,   178,   179,   189,   193,   194,   195,   197,   198,
     199,   202,   203,   204,   145,    14,    25,   103,   178,   194,
     202,    98,   103,   143,   178,   179,   103,   140,   160,   161,
     164,   161,   202,   143,   143,   143,    82,    98,   102,   103,
     143,   187,   145,   145,   145,   202,   202,   202,   202,    32,
      98,   163,   165,    98,   103,   163,   145,   143,   140,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
      98,   103,   202,   161,   161,   161,   202,   202,   202,   202,
     202,   202,     1,   172,   202,   143,   143,   203,   143,   202,
      98,   103,   202,   202,   202,   160,   162,   164,    98,   103,
     146,   200,   201,   202,   204,     0,   150,    35,   145,    14,
      98,   103,    99,   104,    43,   108,   114,    14,    25,    98,
     103,   178,   195,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    78,    79,    80,   119,
     122,   123,   124,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   140,   141,   142,   143,   145,    14,    14,
     178,   199,   202,    98,    99,   143,   144,   162,    11,     9,
     145,   202,   202,   172,   143,   143,   143,   172,   172,    21,
      21,    98,   103,   143,    10,    29,    30,   161,   166,   123,
     123,   143,   202,    98,   151,   152,   143,   143,   146,   172,
     202,   172,   144,   160,   164,   125,   125,   122,   146,   146,
     125,    98,   103,   143,   178,   179,   103,   143,   187,   143,
     140,   145,    40,   174,   174,   103,   143,   187,   143,    14,
     103,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     112,   113,   116,   117,   116,    98,   103,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   172,    14,   146,   172,   144,
     143,   143,   146,   146,   145,   172,   146,   146,   202,   143,
     123,   123,   202,   143,   143,   143,   202,   202,   202,   146,
     123,   144,   152,   172,   172,   146,   146,   146,   202,   202,
      98,   103,   201,   204,   202,   199,    98,   103,    99,   104,
     143,   172,   172,   172,    14,   103,   144,   154,   155,   156,
     157,   158,   159,   173,   178,   189,   194,   197,   198,    24,
      25,    98,   103,   175,   176,   140,   145,   140,   145,   143,
     172,   172,   172,   103,   143,   187,   143,   125,   144,   147,
     146,   146,   202,   172,   161,   161,   172,   146,     4,   196,
     196,    10,   202,   202,   202,   146,   202,   202,   202,   145,
     145,   146,   140,   202,   146,   146,   125,   145,   190,   146,
     172,   146,   146,   146,   143,   145,   144,   157,    14,    14,
     178,    98,   103,    98,   103,   122,    24,    25,    32,   144,
     158,   177,   180,   181,   188,   193,   194,   144,   177,   172,
     146,   146,   146,   143,   172,   172,   172,   202,   146,   146,
      41,   145,   196,   178,   179,   160,   160,   143,   146,   145,
     145,   165,   146,   146,   146,    34,    38,    39,   169,   170,
     145,    98,   103,   191,   192,   196,   146,   160,   160,   190,
     172,    14,   176,   101,   140,   184,   185,    32,   140,   185,
     144,   158,   180,   181,   188,    98,   178,   187,   144,   146,
     196,   196,   190,   172,   146,   146,   146,   145,   161,   161,
     172,   160,   202,   161,   161,   143,    68,    70,    71,    75,
      76,   116,   129,   130,   202,   125,   144,   170,   143,   143,
     122,   160,   160,   160,   146,   103,    25,    42,    98,   158,
     178,   179,   182,   183,   186,   122,   145,   144,   186,   145,
     187,   172,   196,   160,   160,   196,   146,   160,   160,   190,
     146,   146,   202,   202,   202,   202,   116,   116,   125,   202,
     202,   125,   162,   172,   172,   192,    98,   178,   123,   145,
      98,   101,   144,   183,   184,   144,   172,   146,   160,   145,
     160,   160,   145,   160,   161,   146,   125,   125,   125,   125,
     125,   162,   125,   125,   162,   146,   146,   123,   145,    98,
     202,   123,   143,   145,   123,   143,   145,   146,   190,   165,
     162,   162,   162,   162,   162,   162,   162,   202,   123,   143,
     145,   145,   202,   172,   202,   172,   190,   196,   161,   145,
     202,   172,   145,   146,   145,   146,   145,   160,   145,   160,
     145,   146,   145,   145,   145
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   148,   149,   149,   150,   150,   150,   150,   150,   150,
     150,   150,   150,   150,   150,   151,   151,   152,   153,   153,
     154,   154,   154,   154,   154,   154,   154,   155,   155,   155,
     156,   156,   157,   157,   157,   157,   157,   157,   157,   157,
     158,   158,   159,   159,   160,   160,   161,   161,   162,   162,
     162,   162,   163,   163,   164,   164,   164,   164,   164,   164,
     164,   164,   164,   164,   164,   164,   164,   164,   164,   164,
     164,   164,   164,   164,   164,   164,   164,   165,   165,   166,
     166,   166,   167,   167,   168,   169,   169,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   171,   172,   172,
     172,   173,   173,   173,   173,   173,   173,   174,   174,   175,
     175,   176,   176,   176,   176,   176,   176,   177,   177,   177,
     177,   177,   177,   177,   177,   178,   178,   178,   178,   179,
     179,   180,   180,   181,   181,   181,   182,   182,   182,   182,
     182,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   184,   184,   185,   185,   186,   186,   187,   187,   187,
     188,   188,   188,   188,   189,   189,   189,   189,   189,   189,
     190,   190,   191,   191,   192,   192,   193,   193,   194,   194,
     195,   195,   195,   195,   195,   195,   195,   196,   196,   197,
     197,   197,   197,   198,   198,   198,   198,   199,   199,   200,
     200,   200,   201,   201,   201,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   203,
     203,   204,   204,   204,   204,   204
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     4,     1,     1,     2,     4,     0,     1,
       4,     3,     4,     3,     4,     4,     5,     5,     3,     4,
       1,     2,     1,     1,     1,     1,     1,     2,     1,     1,
       5,     6,     5,     6,     3,     2,     1,     1,     1,     1,
       2,     2,     0,     1,     2,     5,     1,     2,     3,     2,
       2,     2,     3,    11,     7,     5,     7,     5,     7,     9,
       7,     2,     2,     2,     2,     1,     2,     0,     2,     4,
       4,     4,     1,     2,     7,     1,     2,     5,     4,     5,
       4,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     4,     3,     4,     3,     3,     2,     7,     0,     1,
       1,     6,     6,     4,     4,     5,     5,     2,     0,     1,
       3,     1,     1,     2,     2,     2,     2,     1,     1,     1,
       1,     2,     2,     2,     2,     1,     1,     2,     2,     0,
       1,     3,     4,     3,     4,     3,     4,     3,     6,     5,
       7,     3,     5,     6,     3,     5,     6,     2,     4,     1,
       1,     1,     2,     1,     3,     1,     2,     2,     2,     1,
       7,     7,     7,     7,     8,     8,     8,     8,     7,     7,
       2,     0,     1,     3,     4,     4,     0,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     6,
       6,     7,     7,     7,     7,     8,     8,     3,     2,     1,
       3,     2,     3,     3,     3,     1,     1,     1,     3,     1,
       2,     2,     2,     3,     2,     3,     4,     1,     1,     1,
       1,     1,     8,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     3,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     5,     2,     2,     2,     2,     4,     4,     3,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     2,     2,
       5,     5,     2,     1,     4,     4,     3,     2,     3,     2,
       6,     6,     7,     7,     1,     1,     2,     2,     4,     1,
       2,     1,     1,     1,     1,     1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static unsigned
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  unsigned res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       , yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
          case 98: /* "identifier"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4656 "parser.cpp" /* yacc.c:1257  */
        break;

    case 99: /* "variable reference"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4662 "parser.cpp" /* yacc.c:1257  */
        break;

    case 100: /* "backquote expression"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4668 "parser.cpp" /* yacc.c:1257  */
        break;

    case 101: /* "in-object member reference"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4674 "parser.cpp" /* yacc.c:1257  */
        break;

    case 102: /* "identifier or keyword used as function or method identifier"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4680 "parser.cpp" /* yacc.c:1257  */
        break;

    case 103: /* "namespace or class-scoped reference"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4686 "parser.cpp" /* yacc.c:1257  */
        break;

    case 104: /* "namespace-scoped global variable reference"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4692 "parser.cpp" /* yacc.c:1257  */
        break;

    case 105: /* "context reference"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4698 "parser.cpp" /* yacc.c:1257  */
        break;

    case 106: /* "named context reference"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4704 "parser.cpp" /* yacc.c:1257  */
        break;

    case 107: /* "cast operator"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4710 "parser.cpp" /* yacc.c:1257  */
        break;

    case 108: /* "simple class declaration"  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4716 "parser.cpp" /* yacc.c:1257  */
        break;

    case 109: /* "date/time value"  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); }
#line 4722 "parser.cpp" /* yacc.c:1257  */
        break;

    case 110: /* "quoted string"  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 4728 "parser.cpp" /* yacc.c:1257  */
        break;

    case 111: /* "binary constant value"  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); }
#line 4734 "parser.cpp" /* yacc.c:1257  */
        break;

    case 112: /* "regular expression substitution expression"  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).RegexSubst); }
#line 4740 "parser.cpp" /* yacc.c:1257  */
        break;

    case 113: /* "transliteration expression"  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).RegexTrans); }
#line 4746 "parser.cpp" /* yacc.c:1257  */
        break;

    case 114: /* "scoped class declaration"  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).nscope); }
#line 4752 "parser.cpp" /* yacc.c:1257  */
        break;

    case 115: /* "call to base class method"  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).nscope); }
#line 4758 "parser.cpp" /* yacc.c:1257  */
        break;

    case 116: /* "regular expression"  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).Regex); }
#line 4764 "parser.cpp" /* yacc.c:1257  */
        break;

    case 117: /* "regular expression extraction expression"  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).Regex); }
#line 4770 "parser.cpp" /* yacc.c:1257  */
        break;

    case 118: /* "implicit argument reference"  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); }
#line 4776 "parser.cpp" /* yacc.c:1257  */
        break;

    case 119: /* "keyword used as hash key or object member reference"  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 4782 "parser.cpp" /* yacc.c:1257  */
        break;

    case 120: /* "%try-module error token"  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).trymod); }
#line 4788 "parser.cpp" /* yacc.c:1257  */
        break;

    case 154: /* gvardecl  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).gv); }
#line 4794 "parser.cpp" /* yacc.c:1257  */
        break;

    case 155: /* top_namespace_decl  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).ns); }
#line 4800 "parser.cpp" /* yacc.c:1257  */
        break;

    case 156: /* namespace_decls  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); }
#line 4806 "parser.cpp" /* yacc.c:1257  */
        break;

    case 157: /* namespace_decl  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); }
#line 4812 "parser.cpp" /* yacc.c:1257  */
        break;

    case 158: /* unscoped_const_decl  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).constnode); }
#line 4818 "parser.cpp" /* yacc.c:1257  */
        break;

    case 159: /* scoped_const_decl  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).constnode); }
#line 4824 "parser.cpp" /* yacc.c:1257  */
        break;

    case 160: /* block  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 4830 "parser.cpp" /* yacc.c:1257  */
        break;

    case 161: /* statement_or_block  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 4836 "parser.cpp" /* yacc.c:1257  */
        break;

    case 162: /* statements  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 4842 "parser.cpp" /* yacc.c:1257  */
        break;

    case 163: /* optname  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4848 "parser.cpp" /* yacc.c:1257  */
        break;

    case 164: /* statement  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 4854 "parser.cpp" /* yacc.c:1257  */
        break;

    case 165: /* context_mods  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).cmods); }
#line 4860 "parser.cpp" /* yacc.c:1257  */
        break;

    case 166: /* context_mod  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).cmod); }
#line 4866 "parser.cpp" /* yacc.c:1257  */
        break;

    case 167: /* return_statement  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 4872 "parser.cpp" /* yacc.c:1257  */
        break;

    case 168: /* switch_statement  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 4878 "parser.cpp" /* yacc.c:1257  */
        break;

    case 169: /* case_block  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).switchstmt); }
#line 4884 "parser.cpp" /* yacc.c:1257  */
        break;

    case 170: /* case_code  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).casenode); }
#line 4890 "parser.cpp" /* yacc.c:1257  */
        break;

    case 171: /* try_statement  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 4896 "parser.cpp" /* yacc.c:1257  */
        break;

    case 172: /* myexp  */
#line 1464 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 4902 "parser.cpp" /* yacc.c:1257  */
        break;

    case 173: /* class_def  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).classdef); }
#line 4908 "parser.cpp" /* yacc.c:1257  */
        break;

    case 174: /* inheritance_list  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclist); }
#line 4914 "parser.cpp" /* yacc.c:1257  */
        break;

    case 175: /* superclass_list  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclist); }
#line 4920 "parser.cpp" /* yacc.c:1257  */
        break;

    case 176: /* superclass  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclnode); }
#line 4926 "parser.cpp" /* yacc.c:1257  */
        break;

    case 177: /* class_attributes  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).qoreclass); }
#line 4932 "parser.cpp" /* yacc.c:1257  */
        break;

    case 178: /* uncqtypedef  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsertype); }
#line 4938 "parser.cpp" /* yacc.c:1257  */
        break;

    case 179: /* qtypedef  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsertype); }
#line 4944 "parser.cpp" /* yacc.c:1257  */
        break;

    case 180: /* private_member_list  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 4950 "parser.cpp" /* yacc.c:1257  */
        break;

    case 181: /* public_member_list  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 4956 "parser.cpp" /* yacc.c:1257  */
        break;

    case 182: /* classvardecl  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).classvarinfo); }
#line 4962 "parser.cpp" /* yacc.c:1257  */
        break;

    case 183: /* member2  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberinfo); }
#line 4968 "parser.cpp" /* yacc.c:1257  */
        break;

    case 184: /* member  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberinfo); }
#line 4974 "parser.cpp" /* yacc.c:1257  */
        break;

    case 185: /* member_list  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 4980 "parser.cpp" /* yacc.c:1257  */
        break;

    case 186: /* member_list2  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 4986 "parser.cpp" /* yacc.c:1257  */
        break;

    case 187: /* ident_openparen  */
#line 1462 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 4992 "parser.cpp" /* yacc.c:1257  */
        break;

    case 188: /* inline_methoddef  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).methodnode); }
#line 4998 "parser.cpp" /* yacc.c:1257  */
        break;

    case 189: /* outofline_methoddef  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).methoddef); }
#line 5004 "parser.cpp" /* yacc.c:1257  */
        break;

    case 190: /* base_constructor_list  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcalist); }
#line 5010 "parser.cpp" /* yacc.c:1257  */
        break;

    case 191: /* base_constructors  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcalist); }
#line 5016 "parser.cpp" /* yacc.c:1257  */
        break;

    case 192: /* base_constructor  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcanode); }
#line 5022 "parser.cpp" /* yacc.c:1257  */
        break;

    case 196: /* return_value  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).returnTypeInfo); }
#line 5028 "parser.cpp" /* yacc.c:1257  */
        break;

    case 197: /* sub_def  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsefunc); }
#line 5034 "parser.cpp" /* yacc.c:1257  */
        break;

    case 198: /* scoped_sub_def  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sparsefunc); }
#line 5040 "parser.cpp" /* yacc.c:1257  */
        break;

    case 199: /* list  */
#line 1464 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).list)) ((*yyvaluep).list)->deref(0); }
#line 5046 "parser.cpp" /* yacc.c:1257  */
        break;

    case 200: /* hash  */
#line 1464 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).hash)) ((*yyvaluep).hash)->deref(0); }
#line 5052 "parser.cpp" /* yacc.c:1257  */
        break;

    case 201: /* hash_element  */
#line 1461 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hashelement); }
#line 5058 "parser.cpp" /* yacc.c:1257  */
        break;

    case 202: /* exp  */
#line 1464 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 5064 "parser.cpp" /* yacc.c:1257  */
        break;

    case 203: /* string  */
#line 1463 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 5070 "parser.cpp" /* yacc.c:1257  */
        break;

    case 204: /* scalar  */
#line 1464 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 5076 "parser.cpp" /* yacc.c:1257  */
        break;


      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yyls1, yysize * sizeof (*yylsp),
                    &yystacksize);

        yyls = yyls1;
        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 1473 "parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 5372 "parser.cpp" /* yacc.c:1646  */
    break;

  case 5:
#line 1476 "parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 5380 "parser.cpp" /* yacc.c:1646  */
    break;

  case 6:
#line 1479 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddClass(*((yyvsp[0].classdef)->name), (yyvsp[0].classdef)->oc);

	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
	   delete (yyvsp[0].classdef);
	}
#line 5393 "parser.cpp" /* yacc.c:1646  */
    break;

  case 7:
#line 1487 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
	   delete (yyvsp[0].constnode);
	}
#line 5402 "parser.cpp" /* yacc.c:1646  */
    break;

  case 8:
#line 1491 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
	   delete (yyvsp[0].constnode);
	}
#line 5411 "parser.cpp" /* yacc.c:1646  */
    break;

  case 9:
#line 1495 "parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].methoddef)->parseAddToClassAndDel();
        }
#line 5419 "parser.cpp" /* yacc.c:1646  */
    break;

  case 10:
#line 1498 "parser.ypp" /* yacc.c:1646  */
    {
	   if ((yyvsp[0].statement)) {
	      if ((yyvsp[0].statement)->isParseDeclaration())
		 delete (yyvsp[0].statement);
	      else
	         qore_program_private::addStatement(*(getProgram()), (yyvsp[0].statement));
	   }
	}
#line 5432 "parser.cpp" /* yacc.c:1646  */
    break;

  case 11:
#line 1506 "parser.ypp" /* yacc.c:1646  */
    {
	   // set line range
	   (yyvsp[-1].sblock)->loc.start_line = (yylsp[-2]).first_line;
	   (yyvsp[-1].sblock)->loc.end_line = (yylsp[-1]).last_line;
	   qore_program_private::addStatement(*(getProgram()), (yyvsp[-1].sblock));
        }
#line 5443 "parser.cpp" /* yacc.c:1646  */
    break;

  case 12:
#line 1512 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddNamespace((yyvsp[0].ns)); 
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
	}
#line 5454 "parser.cpp" /* yacc.c:1646  */
    break;

  case 13:
#line 1518 "parser.ypp" /* yacc.c:1646  */
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");

           // registered internally
        }
#line 5466 "parser.cpp" /* yacc.c:1646  */
    break;

  case 14:
#line 1525 "parser.ypp" /* yacc.c:1646  */
    {
           bool has_dollar = (yyvsp[0].trymod)->var[0] == '$';
           if (!has_dollar) {
              if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].trymod)->var);
           }
           else {
              (yyvsp[0].trymod)->fixName();
              if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[0].trymod)->var);
           }

           if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
              parse_error("'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
              delete (yyvsp[0].trymod);
           }
           else {
              VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].trymod)->takeName());
              QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(left, (yyvsp[0].trymod)->takeExceptionHash());
              qore_program_private::addStatement(*(getProgram()), new ExpressionStatement((yylsp[0]).first_line, (yylsp[0]).last_line, exp));
           }
        }
#line 5493 "parser.cpp" /* yacc.c:1646  */
    break;

  case 15:
#line 1550 "parser.ypp" /* yacc.c:1646  */
    {
        }
#line 5500 "parser.cpp" /* yacc.c:1646  */
    break;

  case 16:
#line 1552 "parser.ypp" /* yacc.c:1646  */
    {
        }
#line 5507 "parser.cpp" /* yacc.c:1646  */
    break;

  case 17:
#line 1557 "parser.ypp" /* yacc.c:1646  */
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[-3].string), get_type_name((yyvsp[-1].node)));
           else
              qmd->set((yyvsp[-3].string), (yyvsp[-1].node));

           free((yyvsp[-3].string));
           (yyvsp[-1].node)->deref(0);
        }
#line 5522 "parser.cpp" /* yacc.c:1646  */
    break;

  case 18:
#line 1570 "parser.ypp" /* yacc.c:1646  */
    { (yyval.b) = false; }
#line 5528 "parser.cpp" /* yacc.c:1646  */
    break;

  case 19:
#line 1571 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.b) = true;
        }
#line 5536 "parser.cpp" /* yacc.c:1646  */
    break;

  case 20:
#line 1577 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), true);
           delete (yyvsp[-1].parsertype);
	}
#line 5546 "parser.cpp" /* yacc.c:1646  */
    break;

  case 21:
#line 1582 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 5554 "parser.cpp" /* yacc.c:1646  */
    break;

  case 22:
#line 1585 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), true);
           delete (yyvsp[-1].parsertype);
	}
#line 5564 "parser.cpp" /* yacc.c:1646  */
    break;

  case 23:
#line 1590 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
	}
#line 5572 "parser.cpp" /* yacc.c:1646  */
    break;

  case 24:
#line 1593 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), false);
           delete (yyvsp[-1].parsertype);
	}
#line 5582 "parser.cpp" /* yacc.c:1646  */
    break;

  case 25:
#line 1598 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), false);
           delete (yyvsp[-1].parsertype);
	}
#line 5592 "parser.cpp" /* yacc.c:1646  */
    break;

  case 26:
#line 1603 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarListDecl((yyvsp[-1].list), (yyvsp[-4].b));
        }
#line 5600 "parser.cpp" /* yacc.c:1646  */
    break;

  case 27:
#line 1609 "parser.ypp" /* yacc.c:1646  */
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[-4].i4), *p);
           (yyvsp[-1].nsnlist)->add(*p);
           delete (yyvsp[-1].nsnlist);
           (yyval.ns) = p->ns;
        }
#line 5612 "parser.cpp" /* yacc.c:1646  */
    break;

  case 28:
#line 1616 "parser.ypp" /* yacc.c:1646  */
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[-2].i4), *p);
           (yyval.ns) = p->ns;
        }
#line 5622 "parser.cpp" /* yacc.c:1646  */
    break;

  case 29:
#line 1621 "parser.ypp" /* yacc.c:1646  */
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[-3].i4), *p);
           (yyval.ns) = p->ns;
        }
#line 5632 "parser.cpp" /* yacc.c:1646  */
    break;

  case 30:
#line 1629 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 5642 "parser.cpp" /* yacc.c:1646  */
    break;

  case 31:
#line 1634 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsnlist) = (yyvsp[-1].nsnlist);
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
	}
#line 5652 "parser.cpp" /* yacc.c:1646  */
    break;

  case 32:
#line 1642 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 5660 "parser.cpp" /* yacc.c:1646  */
    break;

  case 33:
#line 1645 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsn) = new NSNode((yyvsp[0].constnode));
	}
#line 5668 "parser.cpp" /* yacc.c:1646  */
    break;

  case 34:
#line 1648 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsn) = new NSNode((yyvsp[0].classdef));
	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
	}
#line 5679 "parser.cpp" /* yacc.c:1646  */
    break;

  case 35:
#line 1654 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].parsefunc));
        }
#line 5687 "parser.cpp" /* yacc.c:1646  */
    break;

  case 36:
#line 1657 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].sparsefunc));
        }
#line 5695 "parser.cpp" /* yacc.c:1646  */
    break;

  case 37:
#line 1660 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[-1].gv));
        }
#line 5703 "parser.cpp" /* yacc.c:1646  */
    break;

  case 38:
#line 1663 "parser.ypp" /* yacc.c:1646  */
    { 
	   (yyval.nsn) = new NSNode((yyvsp[0].ns)); 
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
	}
#line 5714 "parser.cpp" /* yacc.c:1646  */
    break;

  case 39:
#line 1669 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].methoddef));
        }
#line 5722 "parser.cpp" /* yacc.c:1646  */
    break;

  case 40:
#line 1674 "parser.ypp" /* yacc.c:1646  */
    { 
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node)); 
	}
#line 5730 "parser.cpp" /* yacc.c:1646  */
    break;

  case 41:
#line 1677 "parser.ypp" /* yacc.c:1646  */
    { 
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node), true); 
	}
#line 5738 "parser.cpp" /* yacc.c:1646  */
    break;

  case 42:
#line 1683 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node)); 
	}
#line 5746 "parser.cpp" /* yacc.c:1646  */
    break;

  case 43:
#line 1686 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node), true); 
	}
#line 5754 "parser.cpp" /* yacc.c:1646  */
    break;

  case 44:
#line 1693 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = (yyvsp[-1].sblock); }
#line 5760 "parser.cpp" /* yacc.c:1646  */
    break;

  case 45:
#line 1696 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[-1]).first_line, (yylsp[-1]).last_line); }
#line 5766 "parser.cpp" /* yacc.c:1646  */
    break;

  case 46:
#line 1701 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 5772 "parser.cpp" /* yacc.c:1646  */
    break;

  case 47:
#line 1704 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = (yyvsp[0].sblock); }
#line 5778 "parser.cpp" /* yacc.c:1646  */
    break;

  case 48:
#line 1709 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 5784 "parser.cpp" /* yacc.c:1646  */
    break;

  case 49:
#line 1711 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock)); }
#line 5790 "parser.cpp" /* yacc.c:1646  */
    break;

  case 50:
#line 1713 "parser.ypp" /* yacc.c:1646  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].sblock)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 5796 "parser.cpp" /* yacc.c:1646  */
    break;

  case 51:
#line 1715 "parser.ypp" /* yacc.c:1646  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].statement)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 5802 "parser.cpp" /* yacc.c:1646  */
    break;

  case 52:
#line 1720 "parser.ypp" /* yacc.c:1646  */
    { (yyval.string) = 0; }
#line 5808 "parser.cpp" /* yacc.c:1646  */
    break;

  case 53:
#line 1721 "parser.ypp" /* yacc.c:1646  */
    { (yyval.string) = (yyvsp[0].string); }
#line 5814 "parser.cpp" /* yacc.c:1646  */
    break;

  case 54:
#line 1725 "parser.ypp" /* yacc.c:1646  */
    {
	   // if the expression has no effect and it's not a variable declaration
	   qore_type_t t = (yyvsp[-1].node) ? (yyvsp[-1].node)->getType() : 0;
	   bool ok = false;
	   if (t == NT_LIST) {
	      QoreListNode* l = reinterpret_cast<QoreListNode*>((yyvsp[-1].node));
	      // rewrite expression if it's a list without parentheses under certain conditions
	      (yyvsp[-1].node) = checkRewriteList(l);

	      if (l->isVariableList())
		 ok = true;
	   }

	   if (!ok && !node_has_effect((yyvsp[-1].node)) && (t != NT_VARREF || !reinterpret_cast<VarRefNode*>((yyvsp[-1].node))->parseIsDecl()))
	      parse_error("statement has no effect (%s)", (yyvsp[-1].node) ? (yyvsp[-1].node)->getTypeName() : "NOTHING");
           ignore_return_value((yyvsp[-1].node));
	   (yyval.statement) = new ExpressionStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node));
	}
#line 5837 "parser.cpp" /* yacc.c:1646  */
    break;

  case 55:
#line 1744 "parser.ypp" /* yacc.c:1646  */
    {
	   NamedScope *ns = new NamedScope((yyvsp[-4].string));
	   assert(ns->size() > 1);
	   printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
	   (yyval.statement) = new ExpressionStatement((yylsp[-4]).first_line, (yylsp[-4]).last_line, new StaticMethodCallNode(ns, makeArgs((yyvsp[-2].node))));
	}
#line 5848 "parser.cpp" /* yacc.c:1646  */
    break;

  case 56:
#line 1751 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 5854 "parser.cpp" /* yacc.c:1646  */
    break;

  case 57:
#line 1752 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new RethrowStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
	}
#line 5862 "parser.cpp" /* yacc.c:1646  */
    break;

  case 58:
#line 1755 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ThrowStatement((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node));
	}
#line 5870 "parser.cpp" /* yacc.c:1646  */
    break;

  case 59:
#line 1758 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Unconditional);
	}
#line 5878 "parser.cpp" /* yacc.c:1646  */
    break;

  case 60:
#line 1761 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Success);
	}
#line 5886 "parser.cpp" /* yacc.c:1646  */
    break;

  case 61:
#line 1764 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Error);
	}
#line 5894 "parser.cpp" /* yacc.c:1646  */
    break;

  case 62:
#line 1767 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ContextStatement((yylsp[-2]).first_line, (yylsp[0]).last_line, 0, 0, (yyvsp[-1].cmods), (yyvsp[0].sblock));
	}
#line 5902 "parser.cpp" /* yacc.c:1646  */
    break;

  case 63:
#line 1770 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new SummarizeStatement((yylsp[-10]).first_line, (yylsp[0]).last_line, (yyvsp[-9].string), (yyvsp[-7].node), (yyvsp[-1].cmods), (yyvsp[0].sblock), (yyvsp[-3].node));
	}
#line 5910 "parser.cpp" /* yacc.c:1646  */
    break;

  case 64:
#line 1773 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ContextStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].string), (yyvsp[-3].node), (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 5918 "parser.cpp" /* yacc.c:1646  */
    break;

  case 65:
#line 1776 "parser.ypp" /* yacc.c:1646  */
    {	
	   (yyval.statement) = new IfStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 5926 "parser.cpp" /* yacc.c:1646  */
    break;

  case 66:
#line 1779 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new IfStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-4].node), (yyvsp[-2].sblock), (yyvsp[0].sblock));
	}
#line 5934 "parser.cpp" /* yacc.c:1646  */
    break;

  case 67:
#line 1782 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new WhileStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 5942 "parser.cpp" /* yacc.c:1646  */
    break;

  case 68:
#line 1785 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new DoWhileStatement((yylsp[-6]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), (yyvsp[-5].sblock));
	}
#line 5950 "parser.cpp" /* yacc.c:1646  */
    break;

  case 69:
#line 1788 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ForStatement((yylsp[-8]).first_line, (yylsp[0]).last_line, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 5958 "parser.cpp" /* yacc.c:1646  */
    break;

  case 70:
#line 1791 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ForEachStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].node), (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 5966 "parser.cpp" /* yacc.c:1646  */
    break;

  case 71:
#line 1794 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[-1].statement); }
#line 5972 "parser.cpp" /* yacc.c:1646  */
    break;

  case 72:
#line 1795 "parser.ypp" /* yacc.c:1646  */
    {
	   // see if thread exit is allowed
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"thread_exit\" (conflicts with parse option NO_THREAD_CONTROL)");

	   (yyval.statement) = new ThreadExitStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line); 
	}
#line 5984 "parser.cpp" /* yacc.c:1646  */
    break;

  case 73:
#line 1802 "parser.ypp" /* yacc.c:1646  */
    {
	  (yyval.statement) = new BreakStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
	}
#line 5992 "parser.cpp" /* yacc.c:1646  */
    break;

  case 74:
#line 1805 "parser.ypp" /* yacc.c:1646  */
    {
	  (yyval.statement) = new ContinueStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
	}
#line 6000 "parser.cpp" /* yacc.c:1646  */
    break;

  case 75:
#line 1808 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 6006 "parser.cpp" /* yacc.c:1646  */
    break;

  case 76:
#line 1809 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = 0; }
#line 6012 "parser.cpp" /* yacc.c:1646  */
    break;

  case 77:
#line 1814 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmods) = 0; }
#line 6018 "parser.cpp" /* yacc.c:1646  */
    break;

  case 78:
#line 1815 "parser.ypp" /* yacc.c:1646  */
    { 
	   if (!(yyvsp[-1].cmods)) 
	      (yyval.cmods) = new ContextModList((yyvsp[0].cmod)); 
	   else { 
	      (yyvsp[-1].cmods)->addContextMod((yyvsp[0].cmod)); 
	      (yyval.cmods) = (yyvsp[-1].cmods); 
	   }
	}
#line 6031 "parser.cpp" /* yacc.c:1646  */
    break;

  case 79:
#line 1827 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[-1].node)); }
#line 6037 "parser.cpp" /* yacc.c:1646  */
    break;

  case 80:
#line 1829 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[-1].node)); }
#line 6043 "parser.cpp" /* yacc.c:1646  */
    break;

  case 81:
#line 1831 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[-1].node)); }
#line 6049 "parser.cpp" /* yacc.c:1646  */
    break;

  case 82:
#line 1835 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new ReturnStatement((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 6055 "parser.cpp" /* yacc.c:1646  */
    break;

  case 83:
#line 1837 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new ReturnStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].node)); }
#line 6061 "parser.cpp" /* yacc.c:1646  */
    break;

  case 84:
#line 1842 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].switchstmt)->setSwitch((yyvsp[-4].node));
	   (yyval.statement) = (yyvsp[-1].switchstmt);
	   (yyval.statement)->loc.start_line = (yylsp[-6]).first_line;
	   (yyval.statement)->loc.end_line = (yylsp[0]).last_line;
        }
#line 6072 "parser.cpp" /* yacc.c:1646  */
    break;

  case 85:
#line 1852 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.switchstmt) = new SwitchStatement((yyvsp[0].casenode));
	}
#line 6080 "parser.cpp" /* yacc.c:1646  */
    break;

  case 86:
#line 1856 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].switchstmt)->addCase((yyvsp[0].casenode));
	   (yyval.switchstmt) = (yyvsp[-1].switchstmt);
        }
#line 6089 "parser.cpp" /* yacc.c:1646  */
    break;

  case 87:
#line 1864 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">=", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_GE);
        }
#line 6098 "parser.cpp" /* yacc.c:1646  */
    break;

  case 88:
#line 1869 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">=", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_GE);
        }
#line 6107 "parser.cpp" /* yacc.c:1646  */
    break;

  case 89:
#line 1875 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<=", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_LE);
        }
#line 6116 "parser.cpp" /* yacc.c:1646  */
    break;

  case 90:
#line 1880 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<=", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_LE);
        }
#line 6125 "parser.cpp" /* yacc.c:1646  */
    break;

  case 91:
#line 1886 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("==", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_EQ);
        }
#line 6134 "parser.cpp" /* yacc.c:1646  */
    break;

  case 92:
#line 1891 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("==", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_EQ);
        }
#line 6143 "parser.cpp" /* yacc.c:1646  */
    break;

  case 93:
#line 1897 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_LT);
        }
#line 6152 "parser.cpp" /* yacc.c:1646  */
    break;

  case 94:
#line 1902 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_LT);
        }
#line 6161 "parser.cpp" /* yacc.c:1646  */
    break;

  case 95:
#line 1908 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_GT);
        }
#line 6170 "parser.cpp" /* yacc.c:1646  */
    break;

  case 96:
#line 1913 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_GT);
        }
#line 6179 "parser.cpp" /* yacc.c:1646  */
    break;

  case 97:
#line 1919 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-2].Regex), (yyvsp[0].sblock));
	}
#line 6187 "parser.cpp" /* yacc.c:1646  */
    break;

  case 98:
#line 1923 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-1].Regex), 0);
	}
#line 6195 "parser.cpp" /* yacc.c:1646  */
    break;

  case 99:
#line 1928 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[-2].Regex), (yyvsp[0].sblock));
	}
#line 6203 "parser.cpp" /* yacc.c:1646  */
    break;

  case 100:
#line 1932 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[-1].Regex), 0);
	}
#line 6211 "parser.cpp" /* yacc.c:1646  */
    break;

  case 101:
#line 1937 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-2].Regex), (yyvsp[0].sblock));
	}
#line 6219 "parser.cpp" /* yacc.c:1646  */
    break;

  case 102:
#line 1941 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-1].Regex), 0);
	}
#line 6227 "parser.cpp" /* yacc.c:1646  */
    break;

  case 103:
#line 1946 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(0, (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNode((yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 6236 "parser.cpp" /* yacc.c:1646  */
    break;

  case 104:
#line 1951 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(0, (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNode((yyvsp[-1].node), 0);
	}
#line 6245 "parser.cpp" /* yacc.c:1646  */
    break;

  case 105:
#line 1957 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNode(0, (yyvsp[0].sblock));
	}
#line 6253 "parser.cpp" /* yacc.c:1646  */
    break;

  case 106:
#line 1961 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNode(0, 0);
	}
#line 6261 "parser.cpp" /* yacc.c:1646  */
    break;

  case 107:
#line 1967 "parser.ypp" /* yacc.c:1646  */
    {
	   char* param = 0;
	   if ((yyvsp[-2].node)) {
	      if ((yyvsp[-2].node)->getType() == NT_VARREF) 
		 param = reinterpret_cast<VarRefNode*>((yyvsp[-2].node))->takeName();
	      else if ((yyvsp[-2].node)->getType() == NT_BAREWORD) {
		 param = reinterpret_cast<BarewordNode*>((yyvsp[-2].node))->takeString();
		 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
		    parse_error("local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
	      }
	      else
		 parse_error("only one parameter accepted in catch block for exception hash");
	      (yyvsp[-2].node)->deref(0);
	   }
	   (yyval.statement) = new TryStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].sblock), (yyvsp[0].sblock), param);
	}
#line 6282 "parser.cpp" /* yacc.c:1646  */
    break;

  case 108:
#line 1985 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 6288 "parser.cpp" /* yacc.c:1646  */
    break;

  case 109:
#line 1986 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 6294 "parser.cpp" /* yacc.c:1646  */
    break;

  case 110:
#line 1987 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 6300 "parser.cpp" /* yacc.c:1646  */
    break;

  case 111:
#line 1991 "parser.ypp" /* yacc.c:1646  */
    {
           check_classmod((yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
           qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-4].string), (yyvsp[-1].qoreclass));
	}
#line 6310 "parser.cpp" /* yacc.c:1646  */
    break;

  case 112:
#line 1996 "parser.ypp" /* yacc.c:1646  */
    {
           check_classmod((yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-4].nscope), (yyvsp[-1].qoreclass));
           qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
	}
#line 6320 "parser.cpp" /* yacc.c:1646  */
    break;

  case 113:
#line 2001 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[-3].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-2].string), qc);
	}
#line 6332 "parser.cpp" /* yacc.c:1646  */
    break;

  case 114:
#line 2008 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[-3].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[-2].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
	}
#line 6344 "parser.cpp" /* yacc.c:1646  */
    break;

  case 115:
#line 2015 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[-4].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-3].string), qc);
	}
#line 6356 "parser.cpp" /* yacc.c:1646  */
    break;

  case 116:
#line 2022 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[-4].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[-3].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
	}
#line 6368 "parser.cpp" /* yacc.c:1646  */
    break;

  case 117:
#line 2032 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclist) = (yyvsp[0].sclist);
        }
#line 6376 "parser.cpp" /* yacc.c:1646  */
    break;

  case 118:
#line 2035 "parser.ypp" /* yacc.c:1646  */
    { // NOTHING
           (yyval.sclist) = 0;
	}
#line 6384 "parser.cpp" /* yacc.c:1646  */
    break;

  case 119:
#line 2041 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclist) = new BCList((yyvsp[0].sclnode));
	}
#line 6392 "parser.cpp" /* yacc.c:1646  */
    break;

  case 120:
#line 2044 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-2].sclist)->push_back((yyvsp[0].sclnode));
	   (yyval.sclist) = (yyvsp[-2].sclist);
        }
#line 6401 "parser.cpp" /* yacc.c:1646  */
    break;

  case 121:
#line 2051 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode((yyvsp[0].string), false);
	}
#line 6409 "parser.cpp" /* yacc.c:1646  */
    break;

  case 122:
#line 2054 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[0].string)), false);
	}
#line 6417 "parser.cpp" /* yacc.c:1646  */
    break;

  case 123:
#line 2057 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode((yyvsp[0].string), false);
	}
#line 6425 "parser.cpp" /* yacc.c:1646  */
    break;

  case 124:
#line 2060 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[0].string)), false);
	}
#line 6433 "parser.cpp" /* yacc.c:1646  */
    break;

  case 125:
#line 2063 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode((yyvsp[0].string), true);
	}
#line 6441 "parser.cpp" /* yacc.c:1646  */
    break;

  case 126:
#line 2066 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[0].string)), true);
	}
#line 6449 "parser.cpp" /* yacc.c:1646  */
    break;

  case 127:
#line 2072 "parser.ypp" /* yacc.c:1646  */
    { 
           (yyval.qoreclass) = new QoreClass;
	   (yyvsp[0].methodnode)->addAndDelete((yyval.qoreclass));
	}
#line 6458 "parser.cpp" /* yacc.c:1646  */
    break;

  case 128:
#line 2076 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[0].memberlist)->mergePrivate((yyval.qoreclass));
	   delete (yyvsp[0].memberlist);
	}
#line 6468 "parser.cpp" /* yacc.c:1646  */
    break;

  case 129:
#line 2081 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[0].memberlist)->mergePublic((yyval.qoreclass));
	   delete (yyvsp[0].memberlist);
	}
#line 6478 "parser.cpp" /* yacc.c:1646  */
    break;

  case 130:
#line 2086 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue());
	   delete (yyvsp[0].constnode);
	}
#line 6488 "parser.cpp" /* yacc.c:1646  */
    break;

  case 131:
#line 2091 "parser.ypp" /* yacc.c:1646  */
    { 
	   (yyvsp[0].methodnode)->addAndDelete((yyvsp[-1].qoreclass));
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass); 
	}
#line 6497 "parser.cpp" /* yacc.c:1646  */
    break;

  case 132:
#line 2095 "parser.ypp" /* yacc.c:1646  */
    { 
	   (yyvsp[0].memberlist)->mergePrivate((yyvsp[-1].qoreclass));
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass);
	   delete (yyvsp[0].memberlist);
	}
#line 6507 "parser.cpp" /* yacc.c:1646  */
    break;

  case 133:
#line 2100 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[0].memberlist)->mergePublic((yyvsp[-1].qoreclass));
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass); 
	   delete (yyvsp[0].memberlist);
	}
#line 6517 "parser.cpp" /* yacc.c:1646  */
    break;

  case 134:
#line 2105 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue());
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass);
	   delete (yyvsp[0].constnode);
	}
#line 6527 "parser.cpp" /* yacc.c:1646  */
    break;

  case 135:
#line 2126 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string));
	}
#line 6535 "parser.cpp" /* yacc.c:1646  */
    break;

  case 136:
#line 2129 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserScopedTypeStruct((yyvsp[0].string));
        }
#line 6543 "parser.cpp" /* yacc.c:1646  */
    break;

  case 137:
#line 2132 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserOrNothingTypeStruct((yyvsp[0].string));
        }
#line 6551 "parser.cpp" /* yacc.c:1646  */
    break;

  case 138:
#line 2135 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserScopedOrNothingTypeStruct((yyvsp[0].string));
        }
#line 6559 "parser.cpp" /* yacc.c:1646  */
    break;

  case 139:
#line 2142 "parser.ypp" /* yacc.c:1646  */
    { (yyval.parsertype) = 0; }
#line 6565 "parser.cpp" /* yacc.c:1646  */
    break;

  case 140:
#line 2143 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = (yyvsp[0].parsertype);
        }
#line 6573 "parser.cpp" /* yacc.c:1646  */
    break;

  case 141:
#line 2149 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = (yyvsp[-1].memberlist);
	}
#line 6581 "parser.cpp" /* yacc.c:1646  */
    break;

  case 142:
#line 2152 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = (yyvsp[-1].memberlist);
	}
#line 6589 "parser.cpp" /* yacc.c:1646  */
    break;

  case 143:
#line 2158 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = (yyvsp[-1].memberlist);
	}
#line 6597 "parser.cpp" /* yacc.c:1646  */
    break;

  case 144:
#line 2161 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = (yyvsp[-1].memberlist);
	}
#line 6605 "parser.cpp" /* yacc.c:1646  */
    break;

  case 145:
#line 2164 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = new EmptyPublicMemberList;
	}
#line 6613 "parser.cpp" /* yacc.c:1646  */
    break;

  case 146:
#line 2170 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-2].parsertype)->getTypeInfo(), (yyvsp[-2].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[-2].parsertype);
	}
#line 6622 "parser.cpp" /* yacc.c:1646  */
    break;

  case 147:
#line 2174 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo((yylsp[-1]).first_line, (yylsp[-1]).last_line));
	}
#line 6630 "parser.cpp" /* yacc.c:1646  */
    break;

  case 148:
#line 2177 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo((yylsp[-4]).first_line, (yylsp[-1]).last_line, (yyvsp[-4].parsertype)->getTypeInfo(), (yyvsp[-4].parsertype)->getParseTypeInfo(), (yyvsp[-1].node)));
	   //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
	   delete (yyvsp[-4].parsertype);
        }
#line 6640 "parser.cpp" /* yacc.c:1646  */
    break;

  case 149:
#line 2182 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo((yylsp[-3]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node)));
	}
#line 6648 "parser.cpp" /* yacc.c:1646  */
    break;

  case 150:
#line 2185 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-5].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[-5].parsertype)->getClassName())), makeArgs((yyvsp[-2].node)));

	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-4].string), new QoreVarInfo((yylsp[-5]).first_line, (yylsp[-2]).last_line, (yyvsp[-5].parsertype)->getTypeInfo(), (yyvsp[-5].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[-5].parsertype);
	}
#line 6666 "parser.cpp" /* yacc.c:1646  */
    break;

  case 151:
#line 2200 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yyvsp[-2].parsertype) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-2].parsertype)->getTypeInfo(), (yyvsp[-2].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[-2].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
	}
#line 6678 "parser.cpp" /* yacc.c:1646  */
    break;

  case 152:
#line 2207 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yyvsp[-4].parsertype) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-4].parsertype)->getTypeInfo(), (yyvsp[-4].parsertype)->getParseTypeInfo(), (yyvsp[-1].node)));
	   delete (yyvsp[-4].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-3].string));
	}
#line 6690 "parser.cpp" /* yacc.c:1646  */
    break;

  case 153:
#line 2214 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line;
	   const QoreTypeInfo* t = (yyvsp[-5].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[-5].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[-5].parsertype)->getClassName())), makeArgs((yyvsp[-2].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(fl, (yylsp[-2]).last_line, (yyvsp[-5].parsertype)->getTypeInfo(), (yyvsp[-5].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[-5].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-4].string));
	}
#line 6713 "parser.cpp" /* yacc.c:1646  */
    break;

  case 154:
#line 2232 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-2]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-2].parsertype)->getTypeInfo(), (yyvsp[-2].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[-2].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
	}
#line 6725 "parser.cpp" /* yacc.c:1646  */
    break;

  case 155:
#line 2239 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-4]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-4].parsertype)->getTypeInfo(), (yyvsp[-4].parsertype)->getParseTypeInfo(), (yyvsp[-1].node)));
	   delete (yyvsp[-4].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
	}
#line 6737 "parser.cpp" /* yacc.c:1646  */
    break;

  case 156:
#line 2246 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-5]).first_line;
	   const QoreTypeInfo* t = (yyvsp[-5].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[-5].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[-5].parsertype)->getClassName())), makeArgs((yyvsp[-2].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(fl, (yylsp[-2]).last_line, (yyvsp[-5].parsertype)->getTypeInfo(), (yyvsp[-5].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[-5].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-4].string));
	}
#line 6760 "parser.cpp" /* yacc.c:1646  */
    break;

  case 157:
#line 2264 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-1]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
	}
#line 6771 "parser.cpp" /* yacc.c:1646  */
    break;

  case 158:
#line 2270 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-3]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-1].node)));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
	}
#line 6782 "parser.cpp" /* yacc.c:1646  */
    break;

  case 159:
#line 2276 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberinfo) = (yyvsp[0].classvarinfo);
	}
#line 6790 "parser.cpp" /* yacc.c:1646  */
    break;

  case 160:
#line 2279 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[0].constnode)->pub)
              parse_error("cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[0].constnode)->name.ostr);
	   (yyval.memberinfo) = new MemberInfo((yyvsp[0].constnode)->name.takeName(), (yyvsp[0].constnode)->value);
	   delete (yyvsp[0].constnode);
        }
#line 6801 "parser.cpp" /* yacc.c:1646  */
    break;

  case 161:
#line 2288 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[0].string));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 6811 "parser.cpp" /* yacc.c:1646  */
    break;

  case 162:
#line 2293 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string)));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
	}
#line 6821 "parser.cpp" /* yacc.c:1646  */
    break;

  case 163:
#line 2301 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 6829 "parser.cpp" /* yacc.c:1646  */
    break;

  case 164:
#line 2304 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
	   (yyval.memberlist) = (yyvsp[-2].memberlist);
	}
#line 6838 "parser.cpp" /* yacc.c:1646  */
    break;

  case 165:
#line 2311 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 6846 "parser.cpp" /* yacc.c:1646  */
    break;

  case 166:
#line 2314 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
	   (yyval.memberlist) = (yyvsp[-1].memberlist);
	}
#line 6855 "parser.cpp" /* yacc.c:1646  */
    break;

  case 167:
#line 2321 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.string) = (yyvsp[-1].string);
        }
#line 6863 "parser.cpp" /* yacc.c:1646  */
    break;

  case 168:
#line 2324 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.string) = strdup("keys");
        }
#line 6871 "parser.cpp" /* yacc.c:1646  */
    break;

  case 169:
#line 2327 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.string) = (yyvsp[0].string);
        }
#line 6879 "parser.cpp" /* yacc.c:1646  */
    break;

  case 170:
#line 2333 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   checkMethod((yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
	   (yyval.methodnode) = new MethodNode((yyvsp[-5].string), newMethodVariant((yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock), (yyvsp[-6].i4) & OFM_DEPRECATED), (yyvsp[-6].i4) & OFM_STATIC);
	}
#line 6894 "parser.cpp" /* yacc.c:1646  */
    break;

  case 171:
#line 2343 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);
	   
	   checkMethod((yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

	   (yyval.methodnode) = new MethodNode((yyvsp[-4].string), newMethodVariant((yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock), (yyvsp[-6].i4) & OFM_DEPRECATED), (yyvsp[-6].i4) & OFM_STATIC);
	}
#line 6913 "parser.cpp" /* yacc.c:1646  */
    break;

  case 172:
#line 2357 "parser.ypp" /* yacc.c:1646  */
    {
           if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           checkMethod((yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[-5].string), newMethodVariant((yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0, (yyvsp[-6].i4) & OFM_DEPRECATED), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 6924 "parser.cpp" /* yacc.c:1646  */
    break;

  case 173:
#line 2363 "parser.ypp" /* yacc.c:1646  */
    {
           if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
           delete (yyvsp[-5].parsertype);

           checkMethod((yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[-4].string), newMethodVariant((yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, 0, (yyvsp[-6].i4) & OFM_DEPRECATED), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 6939 "parser.cpp" /* yacc.c:1646  */
    break;

  case 174:
#line 2376 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }

           (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
	}
#line 6954 "parser.cpp" /* yacc.c:1646  */
    break;

  case 175:
#line 2386 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
	}
#line 6971 "parser.cpp" /* yacc.c:1646  */
    break;

  case 176:
#line 2398 "parser.ypp" /* yacc.c:1646  */
    {
           if (!(yyvsp[-7].i4) & OFM_ABSTRACT)
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0);
        }
#line 6981 "parser.cpp" /* yacc.c:1646  */
    break;

  case 177:
#line 2403 "parser.ypp" /* yacc.c:1646  */
    {
           if (!(yyvsp[-7].i4) & OFM_ABSTRACT)
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
           delete (yyvsp[-6].parsertype);

           (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, 0);
        }
#line 6994 "parser.cpp" /* yacc.c:1646  */
    break;

  case 178:
#line 2411 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.methoddef) = new MethodDef(0, (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
	}
#line 7002 "parser.cpp" /* yacc.c:1646  */
    break;

  case 179:
#line 2414 "parser.ypp" /* yacc.c:1646  */
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.methoddef) = new MethodDef(0, (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
	}
#line 7013 "parser.cpp" /* yacc.c:1646  */
    break;

  case 180:
#line 2423 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcalist) = (yyvsp[0].bcalist);
	}
#line 7021 "parser.cpp" /* yacc.c:1646  */
    break;

  case 181:
#line 2426 "parser.ypp" /* yacc.c:1646  */
    { // nothing
	   (yyval.bcalist) = 0;
	}
#line 7029 "parser.cpp" /* yacc.c:1646  */
    break;

  case 182:
#line 2432 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcalist) = new BCAList((yyvsp[0].bcanode));
	}
#line 7037 "parser.cpp" /* yacc.c:1646  */
    break;

  case 183:
#line 2435 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-2].bcalist)->push_back((yyvsp[0].bcanode));
	   (yyval.bcalist) = (yyvsp[-2].bcalist);
	}
#line 7046 "parser.cpp" /* yacc.c:1646  */
    break;

  case 184:
#line 2442 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcanode) = new BCANode((yyvsp[-3].string), makeArgs((yyvsp[-1].node)));
	}
#line 7054 "parser.cpp" /* yacc.c:1646  */
    break;

  case 185:
#line 2445 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[-3].string)), makeArgs((yyvsp[-1].node)));
	}
#line 7062 "parser.cpp" /* yacc.c:1646  */
    break;

  case 186:
#line 2452 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = 0; }
#line 7068 "parser.cpp" /* yacc.c:1646  */
    break;

  case 187:
#line 2453 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.i4) = (yyvsp[0].i4);
        }
#line 7076 "parser.cpp" /* yacc.c:1646  */
    break;

  case 188:
#line 2458 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = (yyvsp[0].i4); }
#line 7082 "parser.cpp" /* yacc.c:1646  */
    break;

  case 189:
#line 2459 "parser.ypp" /* yacc.c:1646  */
    {
	   if (((yyvsp[-1].i4) | (yyvsp[0].i4)) == (yyvsp[-1].i4))
	      parse_error("modifier given twice");
	   (yyval.i4) = (yyvsp[-1].i4) | (yyvsp[0].i4); 
	}
#line 7092 "parser.cpp" /* yacc.c:1646  */
    break;

  case 190:
#line 2467 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_PRIVATE; }
#line 7098 "parser.cpp" /* yacc.c:1646  */
    break;

  case 191:
#line 2468 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_STATIC; }
#line 7104 "parser.cpp" /* yacc.c:1646  */
    break;

  case 192:
#line 2469 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_SYNCED; }
#line 7110 "parser.cpp" /* yacc.c:1646  */
    break;

  case 193:
#line 2470 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_DEPRECATED; }
#line 7116 "parser.cpp" /* yacc.c:1646  */
    break;

  case 194:
#line 2471 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_PUBLIC; }
#line 7122 "parser.cpp" /* yacc.c:1646  */
    break;

  case 195:
#line 2472 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_FINAL; }
#line 7128 "parser.cpp" /* yacc.c:1646  */
    break;

  case 196:
#line 2473 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_ABSTRACT; }
#line 7134 "parser.cpp" /* yacc.c:1646  */
    break;

  case 197:
#line 2477 "parser.ypp" /* yacc.c:1646  */
    {
	   if (!(yyvsp[0].parsertype)) {
	      parse_error("missing type declaration after 'returns'");
	      (yyval.returnTypeInfo) = 0;
	   }
	   else {
	      (yyval.returnTypeInfo) = new RetTypeInfo((yyvsp[0].parsertype)->getParseTypeInfo(), (yyvsp[0].parsertype)->getTypeInfo());
	      delete (yyvsp[0].parsertype);
	   }
	}
#line 7149 "parser.cpp" /* yacc.c:1646  */
    break;

  case 198:
#line 2488 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.returnTypeInfo) = 0;
	}
#line 7157 "parser.cpp" /* yacc.c:1646  */
    break;

  case 199:
#line 2493 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.parsefunc) = new ParseUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, flags));
	}
#line 7167 "parser.cpp" /* yacc.c:1646  */
    break;

  case 200:
#line 2498 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, flags));
	}
#line 7181 "parser.cpp" /* yacc.c:1646  */
    break;

  case 201:
#line 2507 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
           
	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[-6].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
#line 7197 "parser.cpp" /* yacc.c:1646  */
    break;

  case 202:
#line 2518 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-6].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[-6].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
#line 7216 "parser.cpp" /* yacc.c:1646  */
    break;

  case 203:
#line 2534 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, flags));
	}
#line 7226 "parser.cpp" /* yacc.c:1646  */
    break;

  case 204:
#line 2539 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, flags));
	}
#line 7240 "parser.cpp" /* yacc.c:1646  */
    break;

  case 205:
#line 2548 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-7].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-7].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
           
	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-7].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[-7].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
#line 7256 "parser.cpp" /* yacc.c:1646  */
    break;

  case 206:
#line 2559 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-7].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-7].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-7].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[-7].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
#line 7275 "parser.cpp" /* yacc.c:1646  */
    break;

  case 207:
#line 2577 "parser.ypp" /* yacc.c:1646  */
    { (yyval.list) = splice_expressions((yyvsp[-2].node), (yyvsp[0].node)); }
#line 7281 "parser.cpp" /* yacc.c:1646  */
    break;

  case 208:
#line 2578 "parser.ypp" /* yacc.c:1646  */
    {
	   QoreListNode* l;
	   if ((yyvsp[-1].node) && (yyvsp[-1].node)->getType() == NT_LIST) 
	      l = reinterpret_cast<QoreListNode*>((yyvsp[-1].node));
	   else {
	      l = new QoreListNode;
	      l->push((yyvsp[-1].node));
	      // parse_error("problem in parsing ',' in list: left side of comma is not a list (type: '%s')", $1 ? $1->getTypeName() : "NOTHING");
	      // so we don't insert null values in the parse tree
	   }
	   (yyval.list) = l;
        }
#line 7298 "parser.cpp" /* yacc.c:1646  */
    break;

  case 209:
#line 2593 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.hash) = new QoreHashNode;
	   (yyval.hash)->setKeyValue((yyvsp[0].hashelement)->key, (yyvsp[0].hashelement)->value, 0);
	   delete (yyvsp[0].hashelement);
	}
#line 7308 "parser.cpp" /* yacc.c:1646  */
    break;

  case 210:
#line 2598 "parser.ypp" /* yacc.c:1646  */
    {
	   if ((yyvsp[-2].hash)->existsKey((yyvsp[0].hashelement)->key))
	      QoreHashNode::doDuplicateKeyWarning((yyvsp[0].hashelement)->key);
	   (yyvsp[-2].hash)->setKeyValue((yyvsp[0].hashelement)->key, (yyvsp[0].hashelement)->value, 0);
	   delete (yyvsp[0].hashelement);
	   (yyval.hash) = (yyvsp[-2].hash);
	}
#line 7320 "parser.cpp" /* yacc.c:1646  */
    break;

  case 211:
#line 2606 "parser.ypp" /* yacc.c:1646  */
    { /* empty ',' on end of hash */ (yyval.hash)=(yyvsp[-1].hash); }
#line 7326 "parser.cpp" /* yacc.c:1646  */
    break;

  case 212:
#line 2611 "parser.ypp" /* yacc.c:1646  */
    { (yyval.hashelement) = new HashElement((yyvsp[-2].node), (yyvsp[0].node)); }
#line 7332 "parser.cpp" /* yacc.c:1646  */
    break;

  case 213:
#line 2613 "parser.ypp" /* yacc.c:1646  */
    { (yyval.hashelement) = new HashElement(HE_TAG_CONST, (yyvsp[-2].string), (yyvsp[0].node)); }
#line 7338 "parser.cpp" /* yacc.c:1646  */
    break;

  case 214:
#line 2615 "parser.ypp" /* yacc.c:1646  */
    { (yyval.hashelement) = new HashElement(HE_TAG_SCOPED_CONST, (yyvsp[-2].string), (yyvsp[0].node)); }
#line 7344 "parser.cpp" /* yacc.c:1646  */
    break;

  case 215:
#line 2619 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7350 "parser.cpp" /* yacc.c:1646  */
    break;

  case 216:
#line 2621 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].binary); }
#line 7356 "parser.cpp" /* yacc.c:1646  */
    break;

  case 217:
#line 2623 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].list); }
#line 7362 "parser.cpp" /* yacc.c:1646  */
    break;

  case 218:
#line 2625 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[-1].hash); }
#line 7368 "parser.cpp" /* yacc.c:1646  */
    break;

  case 219:
#line 2627 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ScopedRefNode((yyvsp[0].string)); }
#line 7374 "parser.cpp" /* yacc.c:1646  */
    break;

  case 220:
#line 2628 "parser.ypp" /* yacc.c:1646  */
    {
	   if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[-1].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), get_var_type(), (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[0].string), get_var_type());

	   delete (yyvsp[-1].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 7392 "parser.cpp" /* yacc.c:1646  */
    break;

  case 221:
#line 2641 "parser.ypp" /* yacc.c:1646  */
    {
	   if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[-1].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), get_var_type(), (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[0].string), get_var_type());

	   delete (yyvsp[-1].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 7410 "parser.cpp" /* yacc.c:1646  */
    break;

  case 222:
#line 2654 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), get_var_type(), (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   delete (yyvsp[-1].parsertype);
	}
#line 7419 "parser.cpp" /* yacc.c:1646  */
    break;

  case 223:
#line 2658 "parser.ypp" /* yacc.c:1646  */
    {
	   VarRefDeclNode* v = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), VT_LOCAL, (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   v->setExplicitScope();
	   (yyval.node) = v;
	   delete (yyvsp[-1].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
	}
#line 7432 "parser.cpp" /* yacc.c:1646  */
    break;

  case 224:
#line 2666 "parser.ypp" /* yacc.c:1646  */
    {
	   // see if types are required
	   if (parse_check_parse_option(PO_REQUIRE_TYPES))
	      parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
	   VarRefNode* v = new VarRefNode((yyvsp[0].string), VT_LOCAL);
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
	}
#line 7447 "parser.cpp" /* yacc.c:1646  */
    break;

  case 225:
#line 2676 "parser.ypp" /* yacc.c:1646  */
    {
	   VarRefNode* v;
	   if ((yyvsp[-1].parsertype)) {
	      v = new VarRefDeclNode((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), VT_LOCAL, (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	      delete (yyvsp[-1].parsertype);
	   }
	   else {
	      // see if types are required
	      if (parse_check_parse_option(PO_REQUIRE_TYPES))
		 parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
	      v = new VarRefNode((yyvsp[0].string), VT_LOCAL);
	   }
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 7469 "parser.cpp" /* yacc.c:1646  */
    break;

  case 226:
#line 2693 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].list)->setVariableList();
	   ListIterator li((yyvsp[-1].list));
	   while (li.next()) {
	      AbstractQoreNode* n = li.getValue();
	      qore_type_t t = get_node_type(n);
	      if (t == NT_BAREWORD) {
		 BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
		 if (parse_check_parse_option(PO_REQUIRE_TYPES))
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
		 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
		    parse_error("local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
		 VarRefNode* v = new VarRefNode(b->takeString(), VT_LOCAL);
		 v->setExplicitScope();
		 b->deref();
		 AbstractQoreNode** p = li.getValuePtr();
		 *p = v;
	      }
	      else if (t == NT_VARREF) {
		 VarRefNode* v = reinterpret_cast<VarRefNode*>(n);
		 // see if types are required
		 if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
		 if (v->explicitScope()) {
		    if (v->getType() == VT_LOCAL)
		       parse_error("illegal use of 'my %s' in local variable declaration list", v->getName());
		    else if (v->getType() == VT_GLOBAL)
		       parse_error("illegal use of 'our %s' in local variable declaration list", v->getName());
		 }
		 else
		    v->makeLocal();
		 v->setExplicitScope();
	      }
	      else
		 parse_error("element %d in list following 'my' is not a variable reference (%s)", li.index(), get_type_name(n));
	   }
	   (yyval.node) = (yyvsp[-1].list);
        }
#line 7512 "parser.cpp" /* yacc.c:1646  */
    break;

  case 227:
#line 2731 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = (yyvsp[0].gv)->makeVar();
        }
#line 7520 "parser.cpp" /* yacc.c:1646  */
    break;

  case 228:
#line 2735 "parser.ypp" /* yacc.c:1646  */
    {
	   if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[0].string), "argv"))
	      inc_argv_ref();

	   (yyval.node) = new BarewordNode((yyvsp[0].string), (yylsp[0]).first_line, (yylsp[0]).last_line);
	}
#line 7531 "parser.cpp" /* yacc.c:1646  */
    break;

  case 229:
#line 2742 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ContextrefNode((yyvsp[0].string)); }
#line 7537 "parser.cpp" /* yacc.c:1646  */
    break;

  case 230:
#line 2744 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ContextRowNode; }
#line 7543 "parser.cpp" /* yacc.c:1646  */
    break;

  case 231:
#line 2746 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ComplexContextrefNode((yyvsp[0].string)); }
#line 7549 "parser.cpp" /* yacc.c:1646  */
    break;

  case 232:
#line 2748 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new FindNode((yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-1].node)); }
#line 7555 "parser.cpp" /* yacc.c:1646  */
    break;

  case 233:
#line 2749 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QorePlusEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7563 "parser.cpp" /* yacc.c:1646  */
    break;

  case 234:
#line 2752 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreMinusEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7571 "parser.cpp" /* yacc.c:1646  */
    break;

  case 235:
#line 2755 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreAndEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7579 "parser.cpp" /* yacc.c:1646  */
    break;

  case 236:
#line 2758 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7587 "parser.cpp" /* yacc.c:1646  */
    break;

  case 237:
#line 2761 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreModulaEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7595 "parser.cpp" /* yacc.c:1646  */
    break;

  case 238:
#line 2764 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreMultiplyEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7603 "parser.cpp" /* yacc.c:1646  */
    break;

  case 239:
#line 2767 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreDivideEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7611 "parser.cpp" /* yacc.c:1646  */
    break;

  case 240:
#line 2770 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreXorEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7619 "parser.cpp" /* yacc.c:1646  */
    break;

  case 241:
#line 2773 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreShiftLeftEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7627 "parser.cpp" /* yacc.c:1646  */
    break;

  case 242:
#line 2776 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreShiftRightEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 7635 "parser.cpp" /* yacc.c:1646  */
    break;

  case 243:
#line 2779 "parser.ypp" /* yacc.c:1646  */
    {
	   if ((yyvsp[-2].node) && (yyvsp[-2].node)->getType() == NT_LIST) {
	      (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LIST_ASSIGNMENT, (yyvsp[0].node));
	   }
	   else {
	      (yyval.node) = new QoreAssignmentOperatorNode((yyvsp[-2].node), (yyvsp[0].node));
	   }
	   //print_tree($1, 0);
	}
#line 7649 "parser.cpp" /* yacc.c:1646  */
    break;

  case 244:
#line 2789 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_EXISTS, 0); }
#line 7655 "parser.cpp" /* yacc.c:1646  */
    break;

  case 245:
#line 2791 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_ELEMENTS, 0); }
#line 7661 "parser.cpp" /* yacc.c:1646  */
    break;

  case 246:
#line 2792 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[0].string)));
	}
#line 7669 "parser.cpp" /* yacc.c:1646  */
    break;

  case 247:
#line 2795 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[0].string)));
	}
#line 7677 "parser.cpp" /* yacc.c:1646  */
    break;

  case 248:
#line 2799 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_KEYS, 0); }
#line 7683 "parser.cpp" /* yacc.c:1646  */
    break;

  case 249:
#line 2800 "parser.ypp" /* yacc.c:1646  */
    {  // unshift list, element
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[0].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_UNSHIFT, l->shift());
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 7700 "parser.cpp" /* yacc.c:1646  */
    break;

  case 250:
#line 2812 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_SHIFT, 0); 
	}
#line 7708 "parser.cpp" /* yacc.c:1646  */
    break;

  case 251:
#line 2815 "parser.ypp" /* yacc.c:1646  */
    {  // push lvalue-list, element
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[0].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_PUSH, l->shift());
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 7725 "parser.cpp" /* yacc.c:1646  */
    break;

  case 252:
#line 2827 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_POP, 0); 
	}
#line 7733 "parser.cpp" /* yacc.c:1646  */
    break;

  case 253:
#line 2830 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_CHOMP, 0); 
	}
#line 7741 "parser.cpp" /* yacc.c:1646  */
    break;

  case 254:
#line 2833 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_TRIM, 0); 
	}
#line 7749 "parser.cpp" /* yacc.c:1646  */
    break;

  case 255:
#line 2836 "parser.ypp" /* yacc.c:1646  */
    {  // splice lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreSpliceOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
#line 7774 "parser.cpp" /* yacc.c:1646  */
    break;

  case 256:
#line 2856 "parser.ypp" /* yacc.c:1646  */
    {  // extract lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreExtractOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
#line 7799 "parser.cpp" /* yacc.c:1646  */
    break;

  case 257:
#line 2876 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   int len = l ? (int)l->size() : 0;
	   if (!l || len < 2 || len > 3) {
	      parse_error("invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (len == 2) {
	      AbstractQoreNode* map_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(map_exp, OP_MAP, arg);
	      (yyvsp[0].node)->deref(0);
	   }
	   else {
	      AbstractQoreNode* map_exp = l->shift();
	      (yyval.node) = new QoreTreeNode(map_exp, OP_MAP_SELECT, l);
	   }
	}
#line 7823 "parser.cpp" /* yacc.c:1646  */
    break;

  case 258:
#line 2895 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDR, arg);
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 7842 "parser.cpp" /* yacc.c:1646  */
    break;

  case 259:
#line 2909 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDL, arg);
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 7861 "parser.cpp" /* yacc.c:1646  */
    break;

  case 260:
#line 2923 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* arg = l->shift();
	      AbstractQoreNode* select_exp = l->shift();
	      (yyval.node) = new QoreTreeNode(arg, OP_SELECT, select_exp);
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 7880 "parser.cpp" /* yacc.c:1646  */
    break;

  case 261:
#line 2938 "parser.ypp" /* yacc.c:1646  */
    { //$$ = new QoreTreeNode($1, OP_QUESTION_MARK, make_list($3, $5));
           (yyval.node) = new QoreQuestionMarkOperatorNode((yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node));
        }
#line 7888 "parser.cpp" /* yacc.c:1646  */
    break;

  case 262:
#line 2941 "parser.ypp" /* yacc.c:1646  */
    {  // pre-increment
           (yyval.node) = new QorePreIncrementOperatorNode((yyvsp[0].node));
        }
#line 7896 "parser.cpp" /* yacc.c:1646  */
    break;

  case 263:
#line 2944 "parser.ypp" /* yacc.c:1646  */
    {  // post-increment
           (yyval.node) = new QorePostIncrementOperatorNode((yyvsp[-1].node));
        }
#line 7904 "parser.cpp" /* yacc.c:1646  */
    break;

  case 264:
#line 2947 "parser.ypp" /* yacc.c:1646  */
    {  // pre-decrement
           (yyval.node) = new QorePreDecrementOperatorNode((yyvsp[0].node));
        }
#line 7912 "parser.cpp" /* yacc.c:1646  */
    break;

  case 265:
#line 2950 "parser.ypp" /* yacc.c:1646  */
    {   // post-decrement
           (yyval.node) = new QorePostDecrementOperatorNode((yyvsp[-1].node));
        }
#line 7920 "parser.cpp" /* yacc.c:1646  */
    break;

  case 266:
#line 2953 "parser.ypp" /* yacc.c:1646  */
    {
	   //printd(5, "1=%s (%p), 3=%s (%p)\n", $1->getTypeName(), $1, $3 ? $3->getTypeName() : "n/a", $3); 
	   qore_type_t t = get_node_type((yyvsp[-3].node));
	   if (t == NT_BAREWORD) {
	      BarewordNode* b = reinterpret_cast<BarewordNode*>((yyvsp[-3].node));
	      // take string from node and delete node
	      char* str = b->takeString();
	      b->deref();
	      printd(5, "parsing call %s() args=%p %s\n", str, (yyvsp[-1].node), (yyvsp[-1].node) ? (yyvsp[-1].node)->getTypeName() : "n/a");
	      (yyval.node) = new FunctionCallNode(str, makeArgs((yyvsp[-1].node)));
	   }
	   else if (t == NT_CONSTANT) {
	      ScopedRefNode* c = reinterpret_cast<ScopedRefNode*>((yyvsp[-3].node));
	      // take NamedScope from node and delete node
	      NamedScope *ns = c->takeName();
	      c->deref();
	      assert(ns->size() > 1);
	      printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
	      (yyval.node) = new StaticMethodCallNode(ns, makeArgs((yyvsp[-1].node)));
	   }
	   else if (t == NT_SELF_VARREF) {
	      SelfVarrefNode* v = reinterpret_cast<SelfVarrefNode*>((yyvsp[-3].node));
	      // take string from node and delete node
	      char* str = v->takeString();
	      v->deref();
	      printd(5, "parsing in-object method call %s()\n", str);
	      (yyval.node) = new SelfFunctionCallNode(str, makeArgs((yyvsp[-1].node)));
	   }
	   else {
	      QoreTreeNode* tree;
	      
	      if (t == NT_TREE) {
		 tree = reinterpret_cast<QoreTreeNode*>((yyvsp[-3].node));
		 if (!(tree->getOp() == OP_OBJECT_REF && tree->right && tree->right->getType() == NT_STRING))
		    tree = 0;
	      }
	      else
		 tree = 0;

	      if (tree) {
		 // create an object method call node
		 // take the string
		 QoreStringNode* str = reinterpret_cast<QoreStringNode*>(tree->right);
		 char* cstr = str->giveBuffer();
		 str->deref();
		 
		 //printd(5, "method call to %s: tree=%s, args=%p %s\n", cstr, tree->left->getTypeName(), $3, $3 ? $3->getTypeName() : "n/a");

		 MethodCallNode* mc = new MethodCallNode(cstr, makeArgs((yyvsp[-1].node)));
                 
                 // destroy the tree and create a new operator object
                 assert(tree->is_unique());
                 AbstractQoreNode* l = tree->left;
                 tree->right = 0;
                 tree->left = 0;
                 tree->deref(0);

		 (yyval.node) = new QoreDotEvalOperatorNode(l, mc);
	      }
	      else {
		 (yyval.node) = 0;
		 if ((yyvsp[-3].node) && (yyvsp[-3].node)->getType() == NT_VARREF) {
		    VarRefNode* r = reinterpret_cast<VarRefNode*>((yyvsp[-3].node));
		    qore_var_t vartype = r->getType();

		    if (vartype != VT_UNRESOLVED) {
		       (yyval.node) = r->makeNewCall((yyvsp[-1].node));
		       //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
		       if (!(yyval.node))
			  parseException("INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
		    }
		 }
		 if (!(yyval.node)) {
		    (yyval.node) = new CallReferenceCallNode((yyvsp[-3].node), makeArgs((yyvsp[-1].node)));
		    printd(5, "made new CallReferenceCallNode: %p exp=%p %s\n", (yyval.node), (yyvsp[-3].node), get_type_name((yyvsp[-3].node)));
		 }
	      }
	   }
	}
#line 8004 "parser.cpp" /* yacc.c:1646  */
    break;

  case 267:
#line 3032 "parser.ypp" /* yacc.c:1646  */
    {
	   printd(5, "parsing in-object base class method call %s()\n", (yyvsp[-3].nscope)->ostr);
	   if (!strcmp((yyvsp[-3].nscope)->getIdentifier(), "copy"))
	      parse_error("illegal call to base class copy method '%s'", (yyvsp[-3].nscope)->ostr);

	   (yyval.node) = new SelfFunctionCallNode((yyvsp[-3].nscope), makeArgs((yyvsp[-1].node)));
	}
#line 8016 "parser.cpp" /* yacc.c:1646  */
    break;

  case 268:
#line 3039 "parser.ypp" /* yacc.c:1646  */
    {
	   printd(5, "parsing call %s()\n", (yyvsp[-2].string));
	   (yyval.node) = new FunctionCallNode((yyvsp[-2].string), makeArgs((yyvsp[-1].node)));
        }
#line 8025 "parser.cpp" /* yacc.c:1646  */
    break;

  case 269:
#line 3044 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new SelfVarrefNode((yyvsp[0].string), (yylsp[0]).first_line, (yylsp[0]).last_line); 
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 8035 "parser.cpp" /* yacc.c:1646  */
    break;

  case 270:
#line 3049 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_AND, (yyvsp[0].node)); }
#line 8041 "parser.cpp" /* yacc.c:1646  */
    break;

  case 271:
#line 3050 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_OR, (yyvsp[0].node)); }
#line 8047 "parser.cpp" /* yacc.c:1646  */
    break;

  case 272:
#line 3051 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_OR, (yyvsp[0].node)); }
#line 8053 "parser.cpp" /* yacc.c:1646  */
    break;

  case 273:
#line 3052 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_AND, (yyvsp[0].node)); }
#line 8059 "parser.cpp" /* yacc.c:1646  */
    break;

  case 274:
#line 3053 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_XOR, (yyvsp[0].node)); }
#line 8065 "parser.cpp" /* yacc.c:1646  */
    break;

  case 275:
#line 3054 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_MATCH, (yyvsp[0].Regex));
	}
#line 8073 "parser.cpp" /* yacc.c:1646  */
    break;

  case 276:
#line 3057 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_NMATCH, (yyvsp[0].Regex));
	}
#line 8081 "parser.cpp" /* yacc.c:1646  */
    break;

  case 277:
#line 3060 "parser.ypp" /* yacc.c:1646  */
    {
	   //printf("REGEX_SUBST: '%s'\n", $3->getPattern()->getBuffer());
	   (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_SUBST, (yyvsp[0].RegexSubst));
	}
#line 8090 "parser.cpp" /* yacc.c:1646  */
    break;

  case 278:
#line 3064 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_TRANS, (yyvsp[0].RegexTrans));
	}
#line 8098 "parser.cpp" /* yacc.c:1646  */
    break;

  case 279:
#line 3068 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_EXTRACT, (yyvsp[0].Regex)); }
#line 8104 "parser.cpp" /* yacc.c:1646  */
    break;

  case 280:
#line 3069 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8110 "parser.cpp" /* yacc.c:1646  */
    break;

  case 281:
#line 3070 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8116 "parser.cpp" /* yacc.c:1646  */
    break;

  case 282:
#line 3071 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_CMP, (yyvsp[0].node)); }
#line 8122 "parser.cpp" /* yacc.c:1646  */
    break;

  case 283:
#line 3072 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8128 "parser.cpp" /* yacc.c:1646  */
    break;

  case 284:
#line 3073 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_ABSOLUTE_EQ, (yyvsp[0].node)); }
#line 8134 "parser.cpp" /* yacc.c:1646  */
    break;

  case 285:
#line 3074 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_ABSOLUTE_NE, (yyvsp[0].node)); }
#line 8140 "parser.cpp" /* yacc.c:1646  */
    break;

  case 286:
#line 3075 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8146 "parser.cpp" /* yacc.c:1646  */
    break;

  case 287:
#line 3076 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8152 "parser.cpp" /* yacc.c:1646  */
    break;

  case 288:
#line 3077 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8158 "parser.cpp" /* yacc.c:1646  */
    break;

  case 289:
#line 3078 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_SHIFT_LEFT, (yyvsp[0].node)); }
#line 8164 "parser.cpp" /* yacc.c:1646  */
    break;

  case 290:
#line 3079 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_SHIFT_RIGHT, (yyvsp[0].node)); }
#line 8170 "parser.cpp" /* yacc.c:1646  */
    break;

  case 291:
#line 3080 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_PLUS, (yyvsp[0].node)); }
#line 8176 "parser.cpp" /* yacc.c:1646  */
    break;

  case 292:
#line 3081 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_MINUS, (yyvsp[0].node)); }
#line 8182 "parser.cpp" /* yacc.c:1646  */
    break;

  case 293:
#line 3082 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_MODULA, (yyvsp[0].node)); }
#line 8188 "parser.cpp" /* yacc.c:1646  */
    break;

  case 294:
#line 3083 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_DIV, (yyvsp[0].node)); }
#line 8194 "parser.cpp" /* yacc.c:1646  */
    break;

  case 295:
#line 3084 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_MULT, (yyvsp[0].node)); }
#line 8200 "parser.cpp" /* yacc.c:1646  */
    break;

  case 296:
#line 3085 "parser.ypp" /* yacc.c:1646  */
    { 
	   // FIXME: need to expand constant expression checking to determine
	   //        if the expression can throw an exception at run-time
	   // first check for constant expressions
	   (yyval.node) = QoreUnaryMinusOperatorNode::makeNode((yyvsp[0].node));
	}
#line 8211 "parser.cpp" /* yacc.c:1646  */
    break;

  case 297:
#line 3091 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_BIN_NOT, 0); }
#line 8217 "parser.cpp" /* yacc.c:1646  */
    break;

  case 298:
#line 3092 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_NOT, 0); }
#line 8223 "parser.cpp" /* yacc.c:1646  */
    break;

  case 299:
#line 3093 "parser.ypp" /* yacc.c:1646  */
    {
	   qore_type_t t = (yyvsp[0].node) ? (yyvsp[0].node)->getType() : 0;
	   //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2->getTypeName());

	   if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
	      (yyval.node) = reinterpret_cast<FunctionCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_SELF_CALL) {
	      (yyval.node) = reinterpret_cast<SelfFunctionCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_STATIC_METHOD_CALL) {
	      (yyval.node) = reinterpret_cast<StaticMethodCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
	   }
	   else {
	      bool make_ref = true;

	      if (t == NT_OPERATOR) {
                 QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[0].node));
                 if (deon) {
                    (yyval.node) = deon->makeCallReference();
                    make_ref = false;
                 }
	      }

	      if (make_ref) {
		 //printd(5, "type=%s\n", $2->getTypeName());
		 (yyval.node) = new ParseReferenceNode((yyvsp[0].node));
	      }
	   }
	}
#line 8258 "parser.cpp" /* yacc.c:1646  */
    break;

  case 300:
#line 3123 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[-3].string)), makeArgs((yyvsp[-1].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
#line 8268 "parser.cpp" /* yacc.c:1646  */
    break;

  case 301:
#line 3128 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[-3].string)), makeArgs((yyvsp[-1].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
#line 8278 "parser.cpp" /* yacc.c:1646  */
    break;

  case 302:
#line 3133 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_BACKGROUND, 0);
	   // check to see if the expression is legal
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"background\" operator (conflicts with parse option NO_THREAD_CONTROL)");
	   else if (!node_has_effect((yyvsp[0].node)))
	      parse_error("argument to background operator (%s) has no effect", get_type_name((yyvsp[0].node)));
	}
#line 8291 "parser.cpp" /* yacc.c:1646  */
    break;

  case 303:
#line 3141 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new BackquoteNode((yyvsp[0].string));
	   if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
	      parse_error("illegal use of backquote operator (conflicts with parse option NO_EXTERNAL_PROCESS)");
	}
#line 8301 "parser.cpp" /* yacc.c:1646  */
    break;

  case 304:
#line 3146 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-3].node), OP_LIST_REF, (yyvsp[-1].node)); }
#line 8307 "parser.cpp" /* yacc.c:1646  */
    break;

  case 305:
#line 3147 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-3].node), OP_OBJECT_REF, (yyvsp[-1].node)); }
#line 8313 "parser.cpp" /* yacc.c:1646  */
    break;

  case 306:
#line 3148 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = process_dot((yyvsp[-2].node), (yyvsp[0].node));
	}
#line 8321 "parser.cpp" /* yacc.c:1646  */
    break;

  case 307:
#line 3151 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[-1].node), OP_OBJECT_REF, (yyvsp[0].String));
	}
#line 8329 "parser.cpp" /* yacc.c:1646  */
    break;

  case 308:
#line 3154 "parser.ypp" /* yacc.c:1646  */
    { 
	   (yyval.node) = (yyvsp[-1].node);
	   if ((yyvsp[-1].node)) {
              switch ((yyvsp[-1].node)->getType()) {
                 case NT_LIST:
                    reinterpret_cast<QoreListNode*>((yyvsp[-1].node))->setFinalized();
                    break;
                 case NT_FUNCTION_CALL:
                    reinterpret_cast<FunctionCallNode*>((yyvsp[-1].node))->setFinalized();
                    break;
              }
           }
	}
#line 8347 "parser.cpp" /* yacc.c:1646  */
    break;

  case 309:
#line 3167 "parser.ypp" /* yacc.c:1646  */
    { QoreListNode* l = new QoreListNode; l->setFinalized(); (yyval.node) = l; }
#line 8353 "parser.cpp" /* yacc.c:1646  */
    break;

  case 310:
#line 3168 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
#line 8362 "parser.cpp" /* yacc.c:1646  */
    break;

  case 311:
#line 3172 "parser.ypp" /* yacc.c:1646  */
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
#line 8374 "parser.cpp" /* yacc.c:1646  */
    break;

  case 312:
#line 3179 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) | OFM_SYNCED, flags));
	}
#line 8387 "parser.cpp" /* yacc.c:1646  */
    break;

  case 313:
#line 3187 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-6].i4) | OFM_SYNCED, flags));
	}
#line 8404 "parser.cpp" /* yacc.c:1646  */
    break;

  case 314:
#line 3199 "parser.ypp" /* yacc.c:1646  */
    { 
	   (yyval.node) = (yyvsp[0].implicit_arg);
	   inc_numeric_argv_ref();
	}
#line 8413 "parser.cpp" /* yacc.c:1646  */
    break;

  case 315:
#line 3203 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreImplicitElementNode;
	}
#line 8421 "parser.cpp" /* yacc.c:1646  */
    break;

  case 316:
#line 3206 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreDeleteOperatorNode((yyvsp[0].node));
	}
#line 8429 "parser.cpp" /* yacc.c:1646  */
    break;

  case 317:
#line 3209 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreRemoveOperatorNode((yyvsp[0].node));
	}
#line 8437 "parser.cpp" /* yacc.c:1646  */
    break;

  case 318:
#line 3212 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreCastOperatorNode((yyvsp[-3].string), (yyvsp[-1].node));
	}
#line 8445 "parser.cpp" /* yacc.c:1646  */
    break;

  case 319:
#line 3218 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.String) = (yyvsp[0].String);
	}
#line 8453 "parser.cpp" /* yacc.c:1646  */
    break;

  case 320:
#line 3221 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.String) = (yyvsp[-1].String);
	   (yyval.String)->concat((yyvsp[0].String));
	   (yyvsp[0].String)->deref();
	}
#line 8463 "parser.cpp" /* yacc.c:1646  */
    break;

  case 321:
#line 3228 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreFloatNode((yyvsp[0].decimal)); }
#line 8469 "parser.cpp" /* yacc.c:1646  */
    break;

  case 322:
#line 3229 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBigIntNode((yyvsp[0].integer)); }
#line 8475 "parser.cpp" /* yacc.c:1646  */
    break;

  case 323:
#line 3230 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].String); }
#line 8481 "parser.cpp" /* yacc.c:1646  */
    break;

  case 324:
#line 3231 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].datetime); }
#line 8487 "parser.cpp" /* yacc.c:1646  */
    break;

  case 325:
#line 3232 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].num); }
#line 8493 "parser.cpp" /* yacc.c:1646  */
    break;


#line 8497 "parser.cpp" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[1] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 3235 "parser.ypp" /* yacc.c:1906  */

