/* -*- mode: c++; indent-tabs-mode: nil -*- */
/*
  RegexSubstNode.h

  regular expression substitution node definition

  Qore Programming Language

  Copyright (C) 2003 - 2014 David Nichols

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.

  Note that the Qore library is released under a choice of three open-source
  licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
  information.
*/

#ifndef _QORE_REGEXSUBSTNODE_H

#define _QORE_REGEXSUBSTNODE_H

#include <qore/intern/QoreRegexBase.h>
#include <sys/types.h>

class RegexSubstNode : public ParseNoEvalNode, public QoreRegexBase {
protected:
   DLLLOCAL virtual AbstractQoreNode *parseInitImpl(LocalVar *oflag, int pflag, int &lvids, const QoreTypeInfo *&typeInfo) {
      // FIXME: implement a type for this
      typeInfo = 0;
      return this;
   }

   DLLLOCAL virtual const QoreTypeInfo *getTypeInfo() const {
      // FIXME: implement a type for this
      return 0;
   }

private:
   bool global;
   class QoreString *newstr;

   DLLLOCAL void init();
   DLLLOCAL static void concat(QoreString *str, int *ovector, int olen, const char *ptr, const char *target, int rc);

public:
   DLLLOCAL RegexSubstNode();
   // used at run-time
   DLLLOCAL RegexSubstNode(const QoreString *pstr, int opts, ExceptionSink *xsink);
   DLLLOCAL virtual ~RegexSubstNode();

   // get string representation (for %n and %N), foff is for multi-line formatting offset, -1 = no line breaks
   // the ExceptionSink is only needed for QoreObject where a method may be executed
   // use the QoreNodeAsStringHelper class (defined in QoreStringNode.h) instead of using these functions directly
   // returns -1 for exception raised, 0 = OK
   DLLLOCAL virtual int getAsString(QoreString &str, int foff, class ExceptionSink *xsink) const;
   // if del is true, then the returned QoreString * should be deleted, if false, then it must not be
   DLLLOCAL virtual QoreString *getAsString(bool &del, int foff, class ExceptionSink *xsink) const;

   // returns the data type
   DLLLOCAL virtual qore_type_t getType() const;
   // returns the type name as a c string
   DLLLOCAL virtual const char *getTypeName() const;

   DLLLOCAL void parseRT(const QoreString *pstr, ExceptionSink *xsink);
   DLLLOCAL void parse();
   DLLLOCAL QoreStringNode *exec(const QoreString *target, ExceptionSink *xsink) const;
   DLLLOCAL QoreStringNode *exec(const QoreString *target, const QoreString *newstr, ExceptionSink *xsink) const;
   DLLLOCAL void concatSource(char c);
   DLLLOCAL void concatTarget(char c);
   DLLLOCAL void setGlobal();
   DLLLOCAL QoreString *getPattern() const;
};

#endif // _QORE_REGEXSUBSTNODE_H
