/*
 ExpressionStatement.cpp
 
 Qore Programming Language
 
 Copyright 2003 - 2013 David Nichols
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <qore/Qore.h>
#include <qore/intern/ExpressionStatement.h>

ExpressionStatement::ExpressionStatement(int start_line, int end_line, AbstractQoreNode *v) : AbstractStatement(start_line, end_line), exp(v) {
   // if it is a global variable declaration, then do not register
   if (exp->getType() == NT_VARREF) {
      VarRefNode *vr = reinterpret_cast<VarRefNode *>(exp);
      // used by QoreProgram to detect invalid top-level statements
      is_declaration = !vr->has_effect();
      // used in parsing to eliminate noops from the parse tree
      is_parse_declaration = !vr->stayInTree();
      return;
   }

   QoreListNode *l = exp->getType() == NT_LIST ? reinterpret_cast<QoreListNode *>(exp) : 0;
   if (l && l->isVariableList()) {
      is_declaration = true;
      is_parse_declaration = reinterpret_cast<VarRefNode *>(l->retrieve_entry(0))->getType() == VT_GLOBAL ? true : false;
      return;
   }

   is_declaration = false;
   is_parse_declaration = false;
}

ExpressionStatement::~ExpressionStatement() {
   //printd(5, "ExpressionStatement::~ExpressionStatement() this=%p exp=%p (%s)\n", this, exp, exp ? exp->getTypeName() : "n/a");
   // this should never be 0, but in case the implementation changes...
   if (exp)
      exp->deref(0);
}

int ExpressionStatement::execImpl(AbstractQoreNode **return_value, ExceptionSink *xsink) {
   discard(exp->eval(xsink), xsink);
   return 0;
}

int ExpressionStatement::parseInitImpl(LocalVar *oflag, int pflag) {
   //printd(5, "ExpressionStatement::parseInitImpl() exp=%p (%s)\n", exp, exp->getTypeName());
   int lvids = 0;
   if (exp) {
      const QoreTypeInfo *argTypeInfo = 0;
      exp = exp->parseInit(oflag, pflag | PF_RETURN_VALUE_IGNORED, lvids, argTypeInfo);
   }
   //printd(5, "ExpressionStatement::parseInitImpl() this=%p exp=%p (%s) lvids=%d\n", this, exp, exp->getTypeName(), lvids);
   return lvids;
}


