/* -*- mode: c++; indent-tabs-mode: nil -*- */
/** @file SaxIterator.qpp defines the SaxIterator class */
/*
  QC_FileSaxIterator.qpp

  Qore Programming Language

  Copyright (C) 2003 - 2022 Qore Technologies, s.r.o.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "qore-xml-module.h"

#include "QC_SaxIterator.h"
/* Qore class Qore::Xml::FileSaxIterator */

qore_classid_t CID_FILESAXITERATOR;
QoreClass* QC_FILESAXITERATOR;

// FileSaxIterator::constructor(string path, string element_name, *string encoding) {}
static void FileSaxIterator_constructor_VsVsNs(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* path = HARD_QORE_VALUE_STRING(args, 0);
    const QoreStringNode* element_name = HARD_QORE_VALUE_STRING(args, 1);
    const QoreStringNode* encoding = get_param_value(args, 2).get<const QoreStringNode>();
# 48 "QC_FileSaxIterator.qpp"
ReferenceHolder<QoreSaxIterator> holder(new QoreSaxIterator(xsink, path->getBuffer(), element_name->getBuffer(), encoding ? encoding->getBuffer() : 0), xsink);
   if (*xsink)
      return;
   self->setPrivate(CID_FILESAXITERATOR, holder.release());
}

// FileSaxIterator::constructor(string path, string element_name, hash opts) {}
static void FileSaxIterator_constructor_VsVsVh(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* path = HARD_QORE_VALUE_STRING(args, 0);
    const QoreStringNode* element_name = HARD_QORE_VALUE_STRING(args, 1);
    const QoreHashNode* opts = HARD_QORE_VALUE_HASH(args, 2);
# 75 "QC_FileSaxIterator.qpp"
const char* encoding = QoreSaxIterator::processOptionsGetEncoding(opts, "FILESAXITERATOR-OPTION-ERROR", xsink);
    if (*xsink)
        return;
    ReferenceHolder<QoreSaxIterator> holder(new QoreSaxIterator(xsink, path->getBuffer(), element_name->getBuffer(), encoding, opts), xsink);
    if (*xsink)
        return;
    self->setPrivate(CID_FILESAXITERATOR, holder.release());
}

// FileSaxIterator::copy() {}
static void FileSaxIterator_copy(QoreObject* self, QoreObject* old, QoreSaxIterator* i, ExceptionSink* xsink) {
# 91 "QC_FileSaxIterator.qpp"
ReferenceHolder<QoreSaxIterator> holder(new QoreSaxIterator(*i, xsink), xsink);
   if (*xsink)
      return;

   self->setPrivate(CID_FILESAXITERATOR, holder.release());
}

DLLLOCAL void preinitFileSaxIteratorClass() {
    QC_FILESAXITERATOR = new QoreClass("FileSaxIterator", "::Qore::Xml::FileSaxIterator", QDOM_DEFAULT);
    CID_FILESAXITERATOR = QC_FILESAXITERATOR->getID();
    QC_FILESAXITERATOR->setSystem();
}

DLLLOCAL QoreClass* initFileSaxIteratorClass(QoreNamespace& ns) {
    if (!QC_FILESAXITERATOR)
        preinitFileSaxIteratorClass();

    // set parent class
    assert(QC_SAXITERATOR);
    QC_FILESAXITERATOR->addBuiltinVirtualBaseClass(QC_SAXITERATOR);

    // FileSaxIterator::constructor(string path, string element_name, *string encoding) {}
    QC_FILESAXITERATOR->addConstructor(FileSaxIterator_constructor_VsVsNs, Public, QCF_NO_FLAGS, QDOM_FILESYSTEM, 3, stringTypeInfo, QORE_PARAM_NO_ARG, "path", stringTypeInfo, QORE_PARAM_NO_ARG, "element_name", stringOrNothingTypeInfo, QORE_PARAM_NO_ARG, "encoding");

    // FileSaxIterator::constructor(string path, string element_name, hash opts) {}
    QC_FILESAXITERATOR->addConstructor(FileSaxIterator_constructor_VsVsVh, Public, QCF_NO_FLAGS, QDOM_FILESYSTEM, 3, stringTypeInfo, QORE_PARAM_NO_ARG, "path", stringTypeInfo, QORE_PARAM_NO_ARG, "element_name", hashTypeInfo, QORE_PARAM_NO_ARG, "opts");

    // FileSaxIterator::copy() {}
    QC_FILESAXITERATOR->setCopy((q_copy_t)FileSaxIterator_copy);

    return QC_FILESAXITERATOR;
}
