/* -*- mode: c++; indent-tabs-mode: nil -*- */
/*
*/

#include "AQMessagePriv.h"
#include "AQQueuePriv.h"

AQMessagePriv::AQMessagePriv(const QoreHashNode* obj, ExceptionSink *xsink) :
   m_obj(obj ? obj->hashRefSelf() : 0),
   m_attemptCount(0),
   m_enqueueDelay(0),
   m_expiration(-1),
   m_state(-1),
   m_priority(1),
   m_correlation(0) {
}

AQMessagePriv::~AQMessagePriv() {
   assert(!m_obj);
   assert(!m_correlation);
}

QoreHashNode* AQMessagePriv::getObject() {
   AutoLocker al(l);
   return m_obj ? m_obj->hashRefSelf() : 0;
}

void AQMessagePriv::setObject(const QoreHashNode* obj, ExceptionSink *xsink) {
   AutoLocker al(l);
   if (m_obj)
      m_obj->deref(xsink);

   m_obj = obj ? obj->hashRefSelf() : 0;
}

int64 AQMessagePriv::getAttemptCount() {
    return m_attemptCount;
}

int64 AQMessagePriv::getEnqueueDelay() {
    return m_enqueueDelay;
}

void AQMessagePriv::setEnqueueDelay(int64 delay) {
    m_enqueueDelay = delay;
}

//      OCI_Date* getEnqueueTime();

int64 AQMessagePriv::getExpiration() {
    return m_expiration;
}

void AQMessagePriv::setExpiration(int64 expiration ) {
    m_expiration = expiration;
}

int64 AQMessagePriv::getState() {
    return m_state;
}

int AQMessagePriv::getPriority() {
    return m_priority;
}

void AQMessagePriv::setPriority(int64 prio) {
    m_priority = prio;
}

//      void getID(void *id, unsigned int *len);

QoreStringNode* AQMessagePriv::getCorrelation() {
   AutoLocker al(l);
   return m_correlation ? m_correlation->stringRefSelf() : 0;
}

void AQMessagePriv::setCorrelation(const QoreStringNode* c, ExceptionSink *xsink) {
   AutoLocker al(l);
    if (m_correlation)
        m_correlation->deref(xsink);

    m_correlation = c->stringRefSelf();
}
/* Qore class Qore::Oracle::AQMessage */

qore_classid_t CID_AQMESSAGE;
QoreClass* QC_AQMESSAGE;

// AQMessage::constructor(*hash obj) {}
static void AQMessage_constructor_Nh(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreHashNode* obj = get_param_value(args, 0).get<const QoreHashNode>();
# 117 "QC_AQMessage.qpp"
self->setPrivate(CID_AQMESSAGE, new AQMessagePriv(obj, xsink));
}

// int AQMessage::getAttemptCount(){}
static QoreValue AQMessage_getAttemptCount(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 145 "QC_AQMessage.qpp"
    return msg->getAttemptCount();
}

// string AQMessage::getCorrelation(){}
static QoreValue AQMessage_getCorrelation(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 250 "QC_AQMessage.qpp"
    return msg->getCorrelation();
}

// int AQMessage::getEnqueueDelay(){}
static QoreValue AQMessage_getEnqueueDelay(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 152 "QC_AQMessage.qpp"
    return msg->getEnqueueDelay();
}

// int AQMessage::getExpiration(){}
static QoreValue AQMessage_getExpiration(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 184 "QC_AQMessage.qpp"
    return msg->getExpiration();
}

// *hash AQMessage::getObject(){}
static QoreValue AQMessage_getObject(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 131 "QC_AQMessage.qpp"
    return msg->getObject();
}

// int AQMessage::getPriority(){}
static QoreValue AQMessage_getPriority(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 222 "QC_AQMessage.qpp"
    return msg->getPriority();
}

// int AQMessage::getState(){}
static QoreValue AQMessage_getState(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 215 "QC_AQMessage.qpp"
    return msg->getState();
}

// nothing AQMessage::setCorrelation(string c){}
static QoreValue AQMessage_setCorrelation_Vs(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* c = HARD_QORE_VALUE_STRING(args, 0);
# 261 "QC_AQMessage.qpp"
    msg->setCorrelation(c, xsink);
    return QoreValue();
}

// nothing AQMessage::setEnqueueDelay(int delay){}
static QoreValue AQMessage_setEnqueueDelay_Vi(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    int64 delay = HARD_QORE_VALUE_INT(args, 0);
# 167 "QC_AQMessage.qpp"
    if (delay < 0) {
      xsink->raiseException("AQMESSAGE-ERROR", "Value of the 'delay' argument must be greater than 0");
      return 0;
   }

    msg->setEnqueueDelay(delay);
    return QoreValue();
}

// nothing AQMessage::setExpiration(int exp){}
static QoreValue AQMessage_setExpiration_Vi(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    int64 exp = HARD_QORE_VALUE_INT(args, 0);
# 197 "QC_AQMessage.qpp"
    if (exp < -1) {
      xsink->raiseException("AQMESSAGE-ERROR", "Expiration argument has to be -1 or greater.");
      return 0;
   }
   msg->setExpiration(exp);
    return QoreValue();
}

// nothing AQMessage::setObject(hash h){}
static QoreValue AQMessage_setObject_Vh(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreHashNode* h = HARD_QORE_VALUE_HASH(args, 0);
# 138 "QC_AQMessage.qpp"
    msg->setObject(h, xsink);
    return QoreValue();
}

// nothing AQMessage::setPriority(int prio){}
static QoreValue AQMessage_setPriority_Vi(QoreObject* self, AQMessagePriv* msg, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    int64 prio = HARD_QORE_VALUE_INT(args, 0);
# 233 "QC_AQMessage.qpp"
    msg->setPriority(prio);
    return QoreValue();
}

DLLLOCAL void preinitAQMessageClass() {
    QC_AQMESSAGE = new QoreClass("AQMessage", "::Qore::Oracle::AQMessage", QDOM_DATABASE);
    CID_AQMESSAGE = QC_AQMESSAGE->getID();
    QC_AQMESSAGE->setSystem();
}

DLLLOCAL QoreClass* initAQMessageClass(QoreNamespace& ns) {
    if (!QC_AQMESSAGE)
        preinitAQMessageClass();

    // AQMessage::constructor(*hash obj) {}
    QC_AQMESSAGE->addConstructor(AQMessage_constructor_Nh, Public, QCF_NO_FLAGS, QDOM_DEFAULT, 1, hashOrNothingTypeInfo, QORE_PARAM_NO_ARG, "obj");

    // int AQMessage::getAttemptCount(){}
    QC_AQMESSAGE->addMethod("getAttemptCount", (q_method_n_t)AQMessage_getAttemptCount, Public, QCF_NO_FLAGS, QDOM_DEFAULT, bigIntTypeInfo);

    // string AQMessage::getCorrelation(){}
    QC_AQMESSAGE->addMethod("getCorrelation", (q_method_n_t)AQMessage_getCorrelation, Public, QCF_NO_FLAGS, QDOM_DEFAULT, stringTypeInfo);

    // int AQMessage::getEnqueueDelay(){}
    QC_AQMESSAGE->addMethod("getEnqueueDelay", (q_method_n_t)AQMessage_getEnqueueDelay, Public, QCF_NO_FLAGS, QDOM_DEFAULT, bigIntTypeInfo);

    // int AQMessage::getExpiration(){}
    QC_AQMESSAGE->addMethod("getExpiration", (q_method_n_t)AQMessage_getExpiration, Public, QCF_NO_FLAGS, QDOM_DEFAULT, bigIntTypeInfo);

    // *hash AQMessage::getObject(){}
    QC_AQMESSAGE->addMethod("getObject", (q_method_n_t)AQMessage_getObject, Public, QCF_NO_FLAGS, QDOM_DEFAULT, hashOrNothingTypeInfo);

    // int AQMessage::getPriority(){}
    QC_AQMESSAGE->addMethod("getPriority", (q_method_n_t)AQMessage_getPriority, Public, QCF_NO_FLAGS, QDOM_DEFAULT, bigIntTypeInfo);

    // int AQMessage::getState(){}
    QC_AQMESSAGE->addMethod("getState", (q_method_n_t)AQMessage_getState, Public, QCF_NO_FLAGS, QDOM_DEFAULT, bigIntTypeInfo);

    // nothing AQMessage::setCorrelation(string c){}
    QC_AQMESSAGE->addMethod("setCorrelation", (q_method_n_t)AQMessage_setCorrelation_Vs, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "c");

    // nothing AQMessage::setEnqueueDelay(int delay){}
    QC_AQMESSAGE->addMethod("setEnqueueDelay", (q_method_n_t)AQMessage_setEnqueueDelay_Vi, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 1, bigIntTypeInfo, QORE_PARAM_NO_ARG, "delay");

    // nothing AQMessage::setExpiration(int exp){}
    QC_AQMESSAGE->addMethod("setExpiration", (q_method_n_t)AQMessage_setExpiration_Vi, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 1, bigIntTypeInfo, QORE_PARAM_NO_ARG, "exp");

    // nothing AQMessage::setObject(hash h){}
    QC_AQMESSAGE->addMethod("setObject", (q_method_n_t)AQMessage_setObject_Vh, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 1, hashTypeInfo, QORE_PARAM_NO_ARG, "h");

    // nothing AQMessage::setPriority(int prio){}
    QC_AQMESSAGE->addMethod("setPriority", (q_method_n_t)AQMessage_setPriority_Vi, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 1, bigIntTypeInfo, QORE_PARAM_NO_ARG, "prio");
# 86 "QC_AQMessage.qpp"
# 91 "QC_AQMessage.qpp"
# 94 "QC_AQMessage.qpp"
# 97 "QC_AQMessage.qpp"
# 100 "QC_AQMessage.qpp"
# 103 "QC_AQMessage.qpp"
    ns.addConstant("OCI_AMS_EXPIRED", ((int64)4));
    ns.addConstant("OCI_AMS_PROCESSED", ((int64)3));
    ns.addConstant("OCI_AMS_READY", ((int64)1));
    ns.addConstant("OCI_AMS_WAITING", ((int64)2));
    ns.addConstant("OCI_UNKNOWN", 0);

    return QC_AQMESSAGE;
}
// //! TODO/FIXME
// /** TODO/FIXME
//  */
//AQMessage::copy() {
//   xsink->raiseException("AQMESSAGE-COPY-ERROR", "copying AQMessage objects is not allowed");
//}

//date AQMessage::getEnqueueTime() {
//    OCI_Date* dt = msg->getEnqueueTime();
//    return msg->queue()->getDate(dt->handle);
//}

//binary AQMessage::getID() {
//    void *p = 0;
//    unsigned int len;
//    if (msg->getID(p, &len))
//        return new BinaryNode(p, len);
//    else {
//        xsink->raiseException("AQMESSAGE-ERROR", "cannot get message id");
//    }
//}
