/*
Qlipper - clipboard history manager
Copyright (C) 2012-2013 Petr Vanek <petr@yarpen.cz>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#ifndef QLIPPERPREFERENCES_H
#define QLIPPERPREFERENCES_H

#include <QtCore/QSettings>

#include "qlipperitem.h"


class QlipperPreferences : public QSettings
{
public:
    static QlipperPreferences *Instance();
    ~QlipperPreferences();

    QList<QlipperItem> getStickyItems();
    void saveStickyItems(QList<QlipperItem> list);
    QList<QlipperItem> getDynamicItems();
    void saveDynamicItems(QList<QlipperItem> list);

    bool trim();
    int displaySize();
    QString shortcut();
    int historyCount();
    bool platformExtensions();

    bool networkSend();
    bool networkReceive();
    int networkPort();

private:
    QlipperPreferences();

    static QlipperPreferences* m_instance;
};

#endif // QLIPPERPREFERENCES_H
