/*
Qlipper - clipboard history manager
Copyright (C) 2012-2013 Petr Vanek <petr@yarpen.cz>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#ifndef QLIPPERNETWORK_H
#define QLIPPERNETWORK_H

#include <QtCore/QObject>
#ifndef ENABLE_NETWORK_CLIPBOARD_SHARING
#include <QtNetwork/QUdpSocket>
#endif
#include "qlippertypes.h"


class QlipperNetwork : public QObject
{
    Q_OBJECT

public:
    QlipperNetwork(QObject *parent=0);

public slots:
    void sendData(const ClipboardContent &value);

private:
#ifndef ENABLE_NETWORK_CLIPBOARD_SHARING
    QUdpSocket *m_socket;
    QString m_id;
#endif

private slots:
    void readData();
};

#endif

