/***************************************************************************
    qgstexteditwrapper.h
     --------------------------------------
    Date                 : 5.1.2014
    Copyright            : (C) 2014 Matthias Kuhn
    Email                : matthias at opengis dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSTEXTEDITWRAPPER_H
#define QGSTEXTEDITWRAPPER_H

#include "qgseditorwidgetwrapper.h"

#include <QLineEdit>
#include <QPlainTextEdit>
#include <QTextBrowser>
#include "qgis_gui.h"

SIP_NO_FILE

/**
 * \ingroup gui
 * Wraps a text widget. Users will be able to modify text with this widget type.
 *
 * Options:
 * <ul>
 * <li><b>IsMultiline</b> <i>If set to TRUE, a multiline widget will be used.</i></li>
 * <li><b>UseHtml</b> <i>Will represent the content as HTML. Only available for multiline widgets.</i></li>
 * </ul>
 * \note not available in Python bindings
 */

class GUI_EXPORT QgsTextEditWrapper : public QgsEditorWidgetWrapper
{
    Q_OBJECT
  public:

    /**
     * Constructor for QgsTextEditWrapper.
     *
     * The \a layer and \a fieldIdx arguments specify the vector layer field associated with the wrapper.
     *
     * The \a editor argument indicates the editor widget to use with the wrapper. This can be NULLPTR if a
     * new widget should be autogenerated.
     *
     * A \a parent widget for this widget wrapper and the created widget can also be specified.
     */
    explicit QgsTextEditWrapper( QgsVectorLayer *layer, int fieldIdx, QWidget *editor = nullptr, QWidget *parent = nullptr );

    // QgsEditorWidgetWrapper interface
  public:
    QVariant value() const override;
    void showIndeterminateState() override;

    /**
     * Add a hint text on the widget
     * \param hintText The hint text to display
     * \since QGIS 3.0
     */
    void setHint( const QString &hintText ) override;

  protected:
    QWidget *createWidget( QWidget *parent ) override;
    void initWidget( QWidget *editor ) override;
    bool valid() const override;

  public slots:
    void setEnabled( bool enabled ) override;

  private slots:
    void textChanged( const QString &text );

  private:
    void updateValues( const QVariant &val, const QVariantList & = QVariantList() ) override;

    QTextBrowser *mTextBrowser = nullptr;
    QTextEdit *mTextEdit = nullptr;
    QPlainTextEdit *mPlainTextEdit = nullptr;
    QLineEdit *mLineEdit = nullptr;
    QPalette mReadOnlyPalette;
    QPalette mWritablePalette;
    QString mPlaceholderText;
    QString mPlaceholderTextBackup;

    void setWidgetValue( const QVariant &value );
};

#endif // QGSTEXTEDITWRAPPER_H
