# -*- coding: utf-8 -*-

"""
***************************************************************************
    CreateNewScriptAction.py
    ---------------------
    Date                 : August 2012
    Copyright            : (C) 2012 by Victor Olaya
    Email                : volayaf at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Victor Olaya'
__date__ = 'August 2012'
__copyright__ = '(C) 2012, Victor Olaya'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '297138f14f92e55d2aa85557b380f48097a88a63'

import os

from qgis.core import QgsApplication

from processing.gui.ToolboxAction import ToolboxAction
from processing.gui.ScriptEditorDialog import ScriptEditorDialog

pluginPath = os.path.split(os.path.dirname(__file__))[0]


class CreateNewScriptAction(ToolboxAction):

    SCRIPT_PYTHON = 0

    def __init__(self, actionName, scriptType):
        self.name, self.i18n_name = self.trAction(actionName)
        self.group, self.i18n_group = self.trAction('Tools')

        self.scriptType = scriptType

    def getIcon(self):
        if self.scriptType == self.SCRIPT_PYTHON:
            return QgsApplication.getThemeIcon("/processingScript.svg")

    def execute(self):
        dlg = None
        if self.scriptType == self.SCRIPT_PYTHON:
            dlg = ScriptEditorDialog(ScriptEditorDialog.SCRIPT_PYTHON, None)
        dlg.show()
