## Description
Include a few sentences describing the overall goals for this PR (pull request). If applicable also add screenshots.

## Checklist

> Reviewing is a process done by project maintainers, mostly on a volunteer basis. We try to keep the overhead as small as possible and appreciate if you help us to do so by completing the following items. Feel free to ask in a comment if you have troubles with any of them.

- [ ] Commit messages are descriptive and explain the rationale for changes
- [ ] Commits which fix bugs include `fixes #11111` in the commit message next to the description
- [ ] Commits which add new features are tagged with `[FEATURE]` in the commit message
- [ ] Commits which change the UI or existing user workflows are tagged with `[needs-docs]` in the commit message and containt sufficient information in the commit message to be documented
- [ ] I have read the [QGIS Coding Standards](https://docs.qgis.org/testing/en/docs/developers_guide/codingstandards.html) and this PR complies with them
- [ ] This PR passes all existing unit tests (test results will be reported by travis-ci after opening this PR)
- [ ] New unit tests have been added for core changes
- [ ] I have run [the `scripts/prepare-commit.sh` script](https://github.com/qgis/QGIS/blob/master/.github/CONTRIBUTE.md#contributing-to-qgis) before each commit
