/*
Copyright (C) 2000,2001 Stefan Duffner 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "Zoom.h"
#include "Const.h"

/// Constructor
Zoom::Zoom()
{
  scale=1.0;
}

/**
 * Zooms in/out the scrollview.
 * @param sview pointer to scrollview
 * @param p point which will be used as new center
 * @param zoomin if TRUE zooms in otherwise zooms out
 */
void Zoom::zoom(ScrollView* sview, QPoint p, bool zoomin)
{
  double factor = ZOOM_FACTOR;
  int vp_width = sview->visibleWidth();
  int vp_height = sview->visibleHeight();

  if (!zoomin)
    factor = 1/ZOOM_FACTOR;

  if (scale*factor<MAX_ZOOM && scale*factor>MIN_ZOOM)
  {
    scale*=factor;

    sview->viewport()->setUpdatesEnabled(FALSE);
    sview->resizeContents(int(sview->contentsWidth()*factor), int(sview->contentsHeight()*factor));
    sview->setContentsPos(int(p.x()*factor-vp_width/2), int(p.y()*factor-vp_height/2));
    sview->viewport()->setUpdatesEnabled(TRUE);
    sview->viewport()->repaint();
  }
}



/**
 * Resets the zoom. 
 * Sets all the zooming parameters to the standard value (100%).
 */
void Zoom::resetZoom(ScrollView* sview)
{

//  sview->resizeContents(CONT_WIDTH, CONT_HEIGHT);
  sview->resizeContents(int(sview->contentsWidth()/scale),
    int(sview->contentsHeight()/scale));
  scale = 1.0;
  sview->setContentsPos(0,0);
  sview->viewport()->repaint();
}
