/*
Copyright (C) Stefan Duffner 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qcheckbox.h>

#include "ExportVHDLDlgImpl.h"
#include "Options.h"
#include "Machine.h"

/* 
 *  Constructs a ExportVHDLDlgImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ExportVHDLDlgImpl::ExportVHDLDlgImpl( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
{
  symbolic_states=false;
  inout_names=true;
  sync_reset=false;
  neg_reset=true;
  stdlogic=true;
  io_header=true;
  alliance=false;
  state_code=false;

  //load ui design for the current object
  exportVHDLDlg.setupUi(this);

  //connects between ui elements and the current class must be done in the code
  connect(exportVHDLDlg.cb_symbolicstates, SIGNAL(clicked()), this, SLOT(symbolicNamesClicked()));
  connect(exportVHDLDlg.cb_inoutnames, SIGNAL(clicked()), this, SLOT(inOutNamesClicked()));
  connect(exportVHDLDlg.cb_synchreset, SIGNAL(clicked()), this, SLOT(synchronousResetClicked()));
  connect(exportVHDLDlg.cb_negreset, SIGNAL(clicked()), this, SLOT(negResetClicked()));
  connect(exportVHDLDlg.cb_stdlogic, SIGNAL(clicked()), this, SLOT(useStdLogicClicked()));
  connect(exportVHDLDlg.cb_iodesc, SIGNAL(clicked()), this, SLOT(ioHeaderClicked()));
  connect(exportVHDLDlg.cb_alliance, SIGNAL(clicked()), this, SLOT(allianceClicked()));
  connect(exportVHDLDlg.cb_state_code, SIGNAL(clicked()), this, SLOT(stateCodeClicked()));
  connect(exportVHDLDlg.bg_cond_notation, SIGNAL(clicked(int)), this, SLOT(condNotationClicked(int)));
  
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ExportVHDLDlgImpl::~ExportVHDLDlgImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void ExportVHDLDlgImpl::symbolicNamesClicked()
{
  symbolic_states = exportVHDLDlg.cb_symbolicstates->isChecked();
}

void ExportVHDLDlgImpl::inOutNamesClicked()
{
  inout_names = exportVHDLDlg.cb_inoutnames->isChecked();
}

/*
 * public slot
 */
void ExportVHDLDlgImpl::synchronousResetClicked()
{
  sync_reset = exportVHDLDlg.cb_synchreset->isChecked();
}


void ExportVHDLDlgImpl::negResetClicked()
{
  neg_reset = exportVHDLDlg.cb_negreset->isChecked();
}

/*
 * public slot
 */
void ExportVHDLDlgImpl::useStdLogicClicked()
{
  stdlogic = exportVHDLDlg.cb_stdlogic->isChecked();
}

void ExportVHDLDlgImpl::ioHeaderClicked()
{
  io_header = exportVHDLDlg.cb_iodesc->isChecked();
}

void ExportVHDLDlgImpl::stateCodeClicked()
{
  state_code = exportVHDLDlg.cb_state_code->isChecked();
}

void ExportVHDLDlgImpl::allianceClicked()
{
  alliance = exportVHDLDlg.cb_alliance->isChecked();
  if (alliance)
  {
    exportVHDLDlg.cb_symbolicstates->setEnabled(false);
    exportVHDLDlg.cb_inoutnames->setEnabled(false);
    exportVHDLDlg.cb_synchreset->setEnabled(false);
    exportVHDLDlg.bg_cond_notation->setEnabled(false);
  }
  else
  {
    exportVHDLDlg.cb_symbolicstates->setEnabled(true);
    exportVHDLDlg.cb_inoutnames->setEnabled(true);
    exportVHDLDlg.cb_synchreset->setEnabled(true);
    exportVHDLDlg.bg_cond_notation->setEnabled(true);
  }
}

/**
 * Initialises the dialog according to the current options @a opt.
 */
void ExportVHDLDlgImpl::init(Options* opt, Machine* m)
{
  symbolic_states = opt->getVHDLSymbolicStates();
  exportVHDLDlg.cb_symbolicstates->setChecked(symbolic_states);
  inout_names = opt->getVHDLInOutNames();
  exportVHDLDlg.cb_inoutnames->setChecked(inout_names);
  sync_reset = opt->getVHDLSyncReset();
  exportVHDLDlg.cb_synchreset->setChecked(sync_reset);
  neg_reset = opt->getVHDLNegReset();
  exportVHDLDlg.cb_negreset->setChecked(neg_reset);
  stdlogic = opt->getVHDLStdLogic();
  exportVHDLDlg.cb_stdlogic->setChecked(stdlogic);
  io_header = opt->getVHDLIOheader();
  exportVHDLDlg.cb_iodesc->setChecked(io_header);
  alliance = opt->getVHDLAlliance();
  exportVHDLDlg.cb_alliance->setChecked(alliance);
  cond_notation = opt->getVHDLCondNotation();
  state_code = opt->getVHDLStateCode();
  exportVHDLDlg.cb_state_code->setChecked(state_code);
  exportVHDLDlg.bg_cond_notation->setButton(cond_notation);

  if (m && m->getType()==0) // Binary machine
  {
    exportVHDLDlg.cb_alliance->setEnabled(true);
    exportVHDLDlg.cb_inoutnames->setEnabled(true);
  }
  else
  {
    exportVHDLDlg.cb_alliance->setEnabled(false);
    exportVHDLDlg.cb_inoutnames->setEnabled(false);
  }

  if (alliance && m && m->getType()==0)
  {
    exportVHDLDlg.cb_symbolicstates->setEnabled(false);
    exportVHDLDlg.cb_inoutnames->setEnabled(false);
    exportVHDLDlg.cb_synchreset->setEnabled(false);
    exportVHDLDlg.bg_cond_notation->setEnabled(false);
  }
  else 
  {
    exportVHDLDlg.cb_symbolicstates->setEnabled(true);
    //exportVHDLDlg.cb_inoutnames->setEnabled(true);
    exportVHDLDlg.cb_synchreset->setEnabled(true);
    exportVHDLDlg.bg_cond_notation->setEnabled(true);
  }
}

void ExportVHDLDlgImpl::condNotationClicked(int cn)
{
  cond_notation = cn;
}


