/*
 * Copyright (C) 2013 Michael Brown <mbrown@fensystems.co.uk>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * You can also choose to distribute this program under the terms of
 * the Unmodified Binary Distribution Licence (as given in the file
 * COPYING.UBDL), provided that you have satisfied its requirements.
 */

FILE_LICENCE ( GPL2_OR_LATER_OR_UBDL );

/** @file
 *
 * PNM self-tests
 *
 */

/* Forcibly enable assertions */
#undef NDEBUG

#include <string.h>
#include <assert.h>
#include <ipxe/pixbuf.h>
#include <ipxe/pnm.h>
#include <ipxe/test.h>
#include "pixbuf_test.h"

/** Define inline pixel data */
#define DATA(...) { __VA_ARGS__ }

/** PBM ASCII example (from Wikipedia) */
PIX ( pbm_ascii, &pnm_image_type,
      "P1\n"
      "# This is an example bitmap of the letter \"J\"\n"
      "6 10\n"
      "0 0 0 0 1 0\n"
      "0 0 0 0 1 0\n"
      "0 0 0 0 1 0\n"
      "0 0 0 0 1 0\n"
      "0 0 0 0 1 0\n"
      "0 0 0 0 1 0\n"
      "1 0 0 0 1 0\n"
      "0 1 1 1 0 0\n"
      "0 0 0 0 0 0\n"
      "0 0 0 0 0 0\n",
      6, 10,
      DATA ( 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0x000000, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0x000000, 0x000000, 0x000000, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff ) );

/** PGM ASCII example (from Wikipedia) */
PIX ( pgm_ascii, &pnm_image_type,
      "P2\n"
      "# Shows the word \"FEEP\" (example from Netpbm man page on PGM)\n"
      "24 7\n"
      "15\n"
      "0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n"
      "0  3  3  3  3  0  0  7  7  7  7  0  0 11 11 11 11  0  0 15 15 15 15  0\n"
      "0  3  0  0  0  0  0  7  0  0  0  0  0 11  0  0  0  0  0 15  0  0 15  0\n"
      "0  3  3  3  0  0  0  7  7  7  0  0  0 11 11 11  0  0  0 15 15 15 15  0\n"
      "0  3  0  0  0  0  0  7  0  0  0  0  0 11  0  0  0  0  0 15  0  0  0  0\n"
      "0  3  0  0  0  0  0  7  7  7  7  0  0 11 11 11 11  0  0 15  0  0  0  0\n"
      "0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n"
      , 24, 7,
      DATA ( 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x333333, 0x333333, 0x333333, 0x333333, 0x000000,
	     0x000000, 0x777777, 0x777777, 0x777777, 0x777777, 0x000000,
	     0x000000, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0x000000,
	     0x000000, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000,
	     0x000000, 0x333333, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xbbbbbb, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xffffff, 0x000000, 0x000000, 0xffffff, 0x000000,
	     0x000000, 0x333333, 0x333333, 0x333333, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x777777, 0x777777, 0x000000, 0x000000,
	     0x000000, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0x000000, 0x000000,
	     0x000000, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000,
	     0x000000, 0x333333, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xbbbbbb, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xffffff, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x333333, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x777777, 0x777777, 0x777777, 0x000000,
	     0x000000, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0x000000,
	     0x000000, 0xffffff, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000 ) );

/** PPM ASCII example (from Wikipedia) */
PIX ( ppm_ascii, &pnm_image_type,
      "P3\n"
      "# The P3 means colors are in ASCII, then 3 columns and 2 rows,\n"
      "# then 255 for max color, then RGB triplets\n"
      "3 2\n"
      "255\n"
      "255   0   0     0 255   0     0   0 255\n"
      "255 255   0   255 255 255     0   0   0\n",
      3, 2,
      DATA ( 0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 0xffffff, 0x000000 ) );

/** PBM ASCII with no space between pixel values */
PIX ( pbm_ascii_no_space, &pnm_image_type,
      "P1\n"
      "3 3\n"
      "001\n"
      "010\n"
      "111\n",
      3, 3,
      DATA ( 0xffffff, 0xffffff, 0x000000, 0xffffff, 0x000000, 0xffffff,
	     0x000000, 0x000000, 0x000000 ) );

/** PBM binary example (converted from Wikipedia) */
PIX ( pbm_binary, &pnm_image_type,
      DATA ( 0x50, 0x34, 0x0a, 0x23, 0x20, 0x43, 0x52, 0x45, 0x41, 0x54, 0x4f,
	     0x52, 0x3a, 0x20, 0x47, 0x49, 0x4d, 0x50, 0x20, 0x50, 0x4e, 0x4d,
	     0x20, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x20, 0x56, 0x65, 0x72,
	     0x73, 0x69, 0x6f, 0x6e, 0x20, 0x31, 0x2e, 0x31, 0x0a, 0x36, 0x20,
	     0x31, 0x30, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x88, 0x70,
	     0x00, 0x00 ),
      6, 10,
      DATA ( 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0x000000, 0xffffff, 0xffffff, 0xffffff, 0x000000, 0xffffff,
	     0xffffff, 0x000000, 0x000000, 0x000000, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff ) );

/** PGM binary example (converted from Wikipedia) */
PIX ( pgm_binary, &pnm_image_type,
      DATA ( 0x50, 0x35, 0x0a, 0x32, 0x34, 0x20, 0x37, 0x0a, 0x31, 0x35, 0x0a,
	     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	     0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x07, 0x07,
	     0x07, 0x07, 0x00, 0x00, 0x0b, 0x0b, 0x0b, 0x0b, 0x00, 0x00, 0x0f,
	     0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	     0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00,
	     0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x03, 0x03, 0x03, 0x00,
	     0x00, 0x00, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0b,
	     0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x03, 0x00,
	     0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b,
	     0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
	     0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x00,
	     0x00, 0x0b, 0x0b, 0x0b, 0x0b, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
	     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	     0x00, 0x00, 0x00 ),
      24, 7,
      DATA ( 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x333333, 0x333333, 0x333333, 0x333333, 0x000000,
	     0x000000, 0x777777, 0x777777, 0x777777, 0x777777, 0x000000,
	     0x000000, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0x000000,
	     0x000000, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000,
	     0x000000, 0x333333, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xbbbbbb, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xffffff, 0x000000, 0x000000, 0xffffff, 0x000000,
	     0x000000, 0x333333, 0x333333, 0x333333, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x777777, 0x777777, 0x000000, 0x000000,
	     0x000000, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0x000000, 0x000000,
	     0x000000, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0x000000,
	     0x000000, 0x333333, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xbbbbbb, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0xffffff, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x333333, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x777777, 0x777777, 0x777777, 0x777777, 0x000000,
	     0x000000, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0xbbbbbb, 0x000000,
	     0x000000, 0xffffff, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	     0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000 ) );

/** PPM binary example (converted from Wikipedia) */
PIX ( ppm_binary, &pnm_image_type,
      DATA ( 0x50, 0x36, 0x0a, 0x33, 0x20, 0x32, 0x0a, 0x32, 0x35, 0x35, 0x0a,
	     0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
	     0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00 ),
      3, 2,
      DATA ( 0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 0xffffff, 0x000000 ) );

/**
 * Perform PNM self-test
 *
 */
static void pnm_test_exec ( void ) {

	pixbuf_ok ( &pbm_ascii );
	pixbuf_ok ( &pgm_ascii );
	pixbuf_ok ( &ppm_ascii );
	pixbuf_ok ( &pbm_ascii_no_space );
	pixbuf_ok ( &pbm_binary );
	pixbuf_ok ( &pgm_binary );
	pixbuf_ok ( &ppm_binary );
}

/** PNM self-test */
struct self_test pnm_test __self_test = {
	.name = "pnm",
	.exec = pnm_test_exec,
};
