
#if defined (HAVE_CONFIG_H)
#  include "config.h"
#endif

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include <libq.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#ifndef HAVE_STRDUP
static char *strdup(char *s)
{
  char *t;
  return ((t=malloc(strlen(s)+1))?strcpy(t, s):NULL);
}
#endif

MODULE(swig)

/* Declarations from common.swg. */

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

/* SWIG pointer proxies. */

typedef struct {
  expr x;
  void *ptr;
  swig_type_info *type;
  int owner, up;
} swig_ptr_t;

/* We want all NULL pointers to be the same object. */

static expr nullptr = NULL;

INIT(swig)
{
  nullptr = newref(mkobj(type(SWIGPtr), NULL));
}

FINI(swig)
{
  freeref(nullptr);
}

FUNCTION(swig,swig_nullptr,argc,argv)
{
  if (argc == 0)
    return newref(nullptr);
  else
    return __FAIL;
}

FUNCTION(swig,swig_null,argc,argv)
{
  swig_ptr_t *p;
  if (argc == 1 && isobj(argv[0], type(SWIGPtr), (void**)&p))
    return mkbool(p == NULL || p->ptr == NULL);
  else
    return __FAIL;
}

/* Destroy a SWIG pointer. If a destructor has been registered, invoke it,
   otherwise free the pointer if we're the owner. */

DESTRUCTOR(swig,SWIGPtr,v)
{
  swig_ptr_t *p = (swig_ptr_t*)v;
  if (p && p->ptr && p->owner)
    if (p->x && p->type && p->type->clientdata) {
      expr res = ((expr(*)(int,expr*))p->type->clientdata)(1, &p->x);
      dispose(res);
    } else
      free(p->ptr);
  free(v);
}

FUNCTION(swig,swig_type,argc,argv)
{
  swig_ptr_t *p;
  if (argc == 1 && isobj(argv[0], type(SWIGPtr), (void**)&p))
    if (p && p->type && p->type->name)
      return mkstr(strdup(p->type->name));
    else
      return mkstr(strdup("_p_void"));
  else
    return __FAIL;
}

FUNCTION(swig,swig_ctype,argc,argv)
{
  swig_ptr_t *p;
  if (argc == 1 && isobj(argv[0], type(SWIGPtr), (void**)&p))
    if (p && p->type && p->type->str)
      return mkstr(strdup(p->type->str));
    else
      return mkstr(strdup("void *"));
  else
    return __FAIL;
}

FUNCTION(swig,swig_addr,argc,argv)
{
  swig_ptr_t *p;
  if (argc == 1 && isobj(argv[0], type(SWIGPtr), (void**)&p))
    if (p)
      return mkuint((unsigned long)p->ptr);
    else
      return mkuint(0);
  else
    return __FAIL;
}

typedef struct bstr {
  long size;
  unsigned char *v;
} bstr_t;

FUNCTION(swig,swig_get,argc,argv)
{
  swig_ptr_t *p;
  long offs, sz;
  if (argc == 3 && isobj(argv[0], type(SWIGPtr), (void**)&p) && 
      isint(argv[1], &offs) && isint(argv[2], &sz) &&
      (p && p->ptr || sz <= 0)) {
    bstr_t *m = malloc(sizeof(bstr_t));
    if (!m) return __ERROR;
    if (sz <= 0) {
      m->v = NULL;
      m->size = 0;
    } else {
      m->v = malloc(sz);
      if (!m->v) {
	free(m);
	return __ERROR;
      }
      memcpy(m->v, ((char*)p->ptr)+offs, sz);
      m->size = sz;
    }
    return mkobj(type(ByteStr), m);
  } else
    return __FAIL;
}

FUNCTION(swig,swig_put,argc,argv)
{
  swig_ptr_t *p;
  bstr_t *m;
  long offs;
  if (argc == 3 && isobj(argv[0], type(SWIGPtr), (void**)&p) && 
      isint(argv[1], &offs) && isobj(argv[2], type(ByteStr), (void**)&m) &&
      (p && p->ptr || m->size == 0)) {
    if (m->size == 0) return mkvoid;
    memcpy(((char*)p->ptr)+offs, m->v, m->size);
    return mkvoid;
  } else
    return __FAIL;
}

FUNCTION(swig,swig_up,argc,argv)
{
  swig_ptr_t *p;
  if (argc == 1 && isobj(argv[0], type(SWIGPtr), (void**)&p) && p) {
    p->up = 1;
    return argv[0];
  } else
    return __FAIL;
}
