
/* ggi_demo.q: little demo of the ggi module, featuring a variation of the
   flying_ggis demo in the libggi distribution.
   $Id: ggi_demo.q,v 1.8 2006/04/25 17:55:34 agraef Exp $ */

/* Have CPU cycles to burn? ;-) Say `demo' to run. */

import ggi;

/* Display parameters. These values control the image generation process. */

def BORDER = 100,		// border width
  MIN_VEL = 30, MAX_VEL = 60,	// velocity range (percent)
  PROB = 0.07,			// average birth rate per iteration (0..1)
  FPS = 10;			// frames to draw per second (best effort)

/* Set the default visual and mode. */

def VIS = ggi_open (),
  _ = ggi_set_mode VIS () || ggi_set_flags VIS GGI_FLAG_ASYNC ;

/* Determine mode settings. */

def (WIDTH,HEIGHT,VWIDTH,VHEIGHT,FRAMES,DWIDTH,DHEIGHT,COLSCHEME,DEPTH,SIZE) =
  sscanf (ggi_get_mode VIS) "%dx%d.V%dx%d.F%d.D%dx%d.[%c%d/%d]";

/* The GGI image. Pilfered from flying_ggis.c. */

def GGI =
  ["..................###########....................................###########...................................",
   "..............###################...##.......................###################...##.......###################",
   "............########.......###########.....................########.......###########...........###########....",
   "..........#######.............########...................#######.............########............#########.....",
   ".........######................#######..................######................#######.............#######......",
   "........######...................#####.................######...................#####.............#######......",
   ".......######.....................#####...............######.....................#####............#######......",
   "......######......................#####..............######......................#####............#######......",
   ".....#######.......................####.............#######.......................####............#######......",
   "....#######.........................###............#######.........................###............#######......",
   "....######..........................###............######..........................###............#######......",
   "...#######..........................###...........#######..........................###............#######......",
   "...#######...........................##...........#######...........................##............#######......",
   "..#######........................................#######..........................................#######......",
   "..#######........................................#######..........................................#######......",
   ".########.......................................########..........................................#######......",
   ".#######........................................#######...........................................#######......",
   ".#######........................................#######...........................................#######......",
   ".#######........................................#######...........................................#######......",
   "########.......................................########...........................................#######......",
   "########.......................................########...........................................#######......",
   "########..................###################..########..................###################......#######......",
   "########......................###########......########......................###########..........#######......",
   "########.......................#########.......########.......................#########...........#######......",
   "########........................########.......########........................########...........#######......",
   "########........................#######........########........................#######............#######......",
   "########........................#######........########........................#######............#######......",
   "#########.......................#######........#########.......................#######............#######......",
   ".########.......................#######.........########.......................#######............#######......",
   ".########.......................#######.........########.......................#######............#######......",
   ".########.......................#######.........########.......................#######............#######......",
   "..########......................#######..........########......................#######............#######......",
   "..########......................#######..........########......................#######............#######......",
   "..#########.....................#######..........#########.....................#######............#######......",
   "...########.....................#######...........########.....................#######............#######......",
   "....########....................#######............########....................#######............#######......",
   "....########....................#######............########....................#######............#######......",
   ".....########...................#######.............########...................#######............#######......",
   "......########..................#######..............########..................#######............#######......",
   ".......########.................#######...............########.................#######............#######......",
   "........########................#######................########................#######............#######......",
   "..........########............#########..................########............#########...........#########.....",
   "............#########......##########......................#########......##########............###########....",
   "..............####################...........................####################...........###################",
   "..................############...................................############.................................."];

/* Parse the image description and build a palette of color values; we cache
   these values here in order to speed up the drawing process. */

def IMG = map (map (="#").chars) GGI, W = #hd IMG, H = #IMG,
  COL = map color [0..255], BLACK = hd COL, WHITE = last COL;

color I		= ggi_pixel (shr I 5 and 7 * 0xffff div 7,
			     shr I 2 and 7 * 0xffff div 7,
			     I and 3 * 0xffff div 3);

/* Draw the image, at the given position, in the given color, stretched by the
   given factor. */

draw X Y C S	= foldl (draw_line X C S) Y IMG;

draw_line X C S Y LINE
		= foldl (draw_pixel C S Y) X LINE || Y+S;

draw_pixel C S Y X P
		= ggi_put_pixel VIS (round X,round Y) C || X+S if P;
		= X+S otherwise;

/* Render a collection of images, given as (X,Y,C,S,V), where (X,Y) is the
   center point, C is the color, S the current stretch factor, and V the
   stretch velocity. */

render_all IMGS	= do render IMGS;

render (X,Y,C,S,V)
		= draw (X-S*W/2) (Y-S*H/2) C S;

/* Update images for the next iteration. */

update_all IMGS	= new PROB (filter valid (map update IMGS));

update (X,Y,C,S,V)
		= (X,Y,C,S+V/100,V);

valid (X,Y,C,S,V)
		= (S*W<=WIDTH) and then (S*H<=HEIGHT);

rand MIN MAX	= MIN + random mod (MAX-MIN+1);

new P IMGS	= [(X,Y,C,1.0,V)|IMGS]
		    where X = rand BORDER (WIDTH-BORDER),
		      Y = rand BORDER (HEIGHT-BORDER),
		      C = COL!rand 1 255,
		      V = rand MIN_VEL MAX_VEL
		    if random/0xffffffff <= P;
		= IMGS otherwise;

/* Show a message while running. */

def MSG = "Running, hit a key to stop";

show_msg	= ggi_clear VIS ||
		  ggi_set_foreground VIS WHITE ||
		  ggi_puts VIS (0,HEIGHT-H) MSG
		    where (_,H) = ggi_get_string_size VIS MSG;

hide_msg	= ggi_set_foreground VIS BLACK ||
		  ggi_puts VIS (0,HEIGHT-H) MSG
		    where (_,H) = ggi_get_string_size VIS MSG;

/* Display loop. */

loop _		= hide_msg || ggi_flush VIS || ggi_getc VIS || ()
		    if ggi_kbhit VIS;
loop []		= sleep 0.5 || show_msg || loop (new 1.0 []);
loop IMGS	= render_all IMGS || ggi_flush VIS ||
		  sleep (TIME+1/FPS-time) || loop (update_all IMGS)
		    where TIME = time;

/* The main function. */

demo		= printf "%s\n" MSG || loop [];
