
/* sys.q: extended host system info 12-07-99 AG */

/* cpu/vendor/os part of the system info, as given by the built-in sysinfo
   function; "" for nonexisting parts. */

public var syscpu, sysvendor, sysos;

/* Check for a given os name prefix, e.g., "msdos" = MSDOS systems, "win" =
   any Windows system, "winnt" = Windows NT, "linux" = Linux, etc.; when
   given a list of such prefixes check whether any of them matches. */

public syscheck S;

syscheck OS:String		= (OS = substr sysos 0 (#OS));
syscheck []			= false;
syscheck [OS|OSs]		= syscheck OS or else syscheck OSs;

/* Variables indicating whether we're running on a DOS/Windows-based and
   Win32 system, respectively. */

public var msdos, win32;

private var sysinfolist;
private getcpu INFO, getvendor INFO, getos INFO;

def sysinfolist			= split "-" sysinfo;

def syscpu			= getcpu sysinfolist; 
def sysvendor			= getvendor sysinfolist; 
def sysos			= getos sysinfolist; 

undef sysinfolist;

def win32 = syscheck ["win32","mingw","cygwin"],
  msdos = win32 or syscheck ["msdos","win"];

getcpu [CPU|REST]		= CPU;
getcpu INFO:List		= "" otherwise;

getvendor [CPU,VENDOR|REST]	= VENDOR;
getvendor INFO:List		= "" otherwise;

getos [CPU,VENDOR|OS]		= join "-" OS;
getos INFO:List			= "" otherwise;
