import re
import unittest
from _typeshed import Incomplete, StrPath, Unused
from configparser import ConfigParser, _SectionName
from types import ModuleType
from typing import Final, Literal

__version__: Final[str]

def invariantSeed(n: float | str | bytes | bytearray | None) -> None: ...
def haveRenderPM() -> ModuleType | Literal[False]: ...

DEJAVUSANS: Final = ("DejaVuSans", "DejaVuSans-Bold", "DejaVuSans-Oblique", "DejaVuSans-BoldOblique")

def haveDejaVu() -> bool: ...
def isWritable(D: Unused) -> Literal[0, 1]: ...

RL_HOME: str | None
testsFolder: str | None

def setOutDir(name: str) -> str: ...
def mockUrlRead(name: str): ...
def outputfile(fn: StrPath | None) -> str: ...
def printLocation(depth: int = 1) -> None: ...
def makeSuiteForClasses(*classes: type[unittest.TestCase], testMethodPrefix: str | None = None) -> unittest.TestSuite: ...
def getCVSEntries(folder: StrPath, files: bool | Literal[1, 0] = 1, folders: bool | Literal[1, 0] = 0) -> list[str]: ...

class ExtConfigParser(ConfigParser):
    pat: re.Pattern[str]
    def getstringlist(self, section: _SectionName, option: str): ...

class GlobDirectoryWalker:
    index: int
    pattern: str
    stack: list[str]
    files: list[str]
    directory: str
    def __init__(self, directory: str, pattern: str = "*") -> None: ...
    def __getitem__(self, index) -> str | None: ...
    def filterFiles(self, folder, files): ...

class RestrictedGlobDirectoryWalker(GlobDirectoryWalker):
    ignorePatterns: Incomplete
    def __init__(self, directory, pattern: str = "*", ignore=None) -> None: ...
    def filterFiles(self, folder, files): ...

class CVSGlobDirectoryWalker(GlobDirectoryWalker):
    def filterFiles(self, folder, files): ...

class SecureTestCase(unittest.TestCase):
    def setUp(self) -> None: ...
    def tearDown(self) -> None: ...

class NearTestCase(unittest.TestCase):
    @staticmethod
    def assertNear(a, b, accuracy: float = 1e-05) -> None: ...

class ScriptThatMakesFileTest(unittest.TestCase):
    scriptDir: Incomplete
    scriptName: Incomplete
    outFileName: Incomplete
    verbose: Incomplete
    def __init__(self, scriptDir, scriptName, outFileName, verbose: int = 0) -> None: ...
    cwd: Incomplete
    def setUp(self) -> None: ...
    def tearDown(self) -> None: ...
    def runTest(self) -> None: ...

def equalStrings(a: str | bytes, b: str | bytes, enc: str = "utf8") -> bool: ...
def eqCheck(r, x) -> None: ...
def rlextraNeeded() -> bool: ...
def rlSkipIf(cond, reason, __module__=None): ...
def rlSkipUnless(cond, reason, __module__=None): ...
def rlSkip(reason, __module__=None): ...
