from _typeshed import SupportsGetItem, SupportsItems, SupportsWrite

# This module defines a function "str()", which is why "str" can't be used
# as a type annotation or type alias.
from builtins import str as _str
from collections.abc import Iterator
from typing import Any, Final, Literal
from typing_extensions import LiteralString, Self, TypeAlias

# Custom type helpers
_ColorModeType: TypeAlias = Literal[0, 8, 16, 256, 16777215]
_PaletteType: TypeAlias = dict[_str, _str] | dict[_str, tuple[int, int, int]] | dict[_str, _str | tuple[int, int, int]]
_StyleType: TypeAlias = tuple[_str, _str]

DEFAULT_RGB_TXT_PATH: Final[_str]
COLOR_PALETTE: Final[dict[_str, _str]]
COLORNAMES_COLORS_PATH: Final[_str]

class ColorfulError(Exception): ...
class ColorfulAttributeError(AttributeError, ColorfulError): ...

def translate_rgb_to_ansi_code(red: int, green: int, blue: int, offset: int, colormode: _ColorModeType) -> _str: ...
def translate_colorname_to_ansi_code(
    colorname: _str, offset: int, colormode: _ColorModeType, colorpalette: SupportsGetItem[_str, _str | tuple[int, int, int]]
) -> _str: ...
def resolve_modifier_to_ansi_code(modifiername: _str, colormode: _ColorModeType) -> _str: ...
def translate_style(
    style: _str, colormode: _ColorModeType, colorpalette: SupportsGetItem[_str, _str | tuple[int, int, int]]
) -> _str: ...
def style_string(string: _str, ansi_style: _StyleType, colormode: _ColorModeType, nested: bool = False) -> _str: ...

class ColorfulString:
    orig_string: _str
    styled_string: _str
    colorful_ctx: Colorful
    def __init__(self, orig_string: _str, styled_string: _str, colorful_ctx: Colorful) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[_str]: ...
    def __add__(self, other: _str | ColorfulString) -> Self: ...
    def __iadd__(self, other: _str | ColorfulString) -> Self: ...
    def __radd__(self, other: _str | ColorfulString) -> Self: ...
    def __mul__(self, other: _str) -> Self: ...
    def __format__(self, format_spec: _str) -> _str: ...
    # Forwards item access to styled_string (a str).
    def __getattr__(self, name: _str) -> Any: ...

class Colorful:
    NO_COLORS: Final[int]
    ANSI_8_COLORS: Final[int]
    ANSI_16_COLORS: Final[int]
    ANSI_256_COLORS: Final[int]
    TRUE_COLORS: Final[int]
    COLORNAMES_COLORS = COLORNAMES_COLORS_PATH
    close_fg_color: Final[_str]
    close_bg_color: Final[_str]
    no_bold: Final[_str]
    no_dimmed: Final[_str]
    no_italic: Final[_str]
    no_underlined: Final[_str]
    no_blinkslow: Final[_str]
    no_blinkrapid: Final[_str]
    no_inversed: Final[_str]
    no_concealed: Final[_str]
    no_struckthrough: Final[_str]
    colormode: _ColorModeType
    def __init__(self, colormode: _ColorModeType | None = None, colorpalette: _str | _PaletteType | None = None) -> None: ...
    @property
    def colorpalette(self) -> SupportsItems[str, str | tuple[int, int, int]] | None: ...
    @colorpalette.setter
    def colorpalette(self, colorpalette: _str | _PaletteType) -> None: ...
    def setup(
        self,
        colormode: _ColorModeType | None = None,
        colorpalette: _str | _PaletteType | None = None,
        extend_colors: bool = False,
    ) -> None: ...
    def disable(self) -> None: ...
    def use_8_ansi_colors(self) -> None: ...
    def use_16_ansi_colors(self) -> None: ...
    def use_256_ansi_colors(self) -> None: ...
    def use_true_colors(self) -> None: ...
    def use_palette(self, colorpalette: _str | _PaletteType) -> None: ...
    def update_palette(self, colorpalette: _str | _PaletteType) -> None: ...
    def use_style(self, style_name: _str) -> None: ...
    def format(self, string: _str, *args: LiteralString, **kwargs: LiteralString) -> _str: ...
    def str(self, string: _str) -> ColorfulString: ...
    def print(
        self, *objects: object, sep: _str = " ", end: _str = "\n", file: SupportsWrite[_str] | None = None, flush: bool = False
    ) -> None: ...

    class ColorfulStyle:
        colormode: _ColorModeType
        colorful_ctx: Colorful
        def __init__(self, style: _StyleType, colormode: _ColorModeType, colorful_ctx: Colorful) -> None: ...
        def evaluate(self, string: _str, nested: bool = False) -> ColorfulString: ...
        def __and__(self, other: Self) -> Self: ...
        def __call__(self, string: _str, nested: bool = False) -> ColorfulString: ...
        def __or__(self, other) -> ColorfulString: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...

    def __getattr__(self, name: _str) -> ColorfulStyle: ...
