from typing import Final

SIGNATURE_HMAC_SHA1: Final = "HMAC-SHA1"
SIGNATURE_RSA_SHA1: Final = "RSA-SHA1"
SIGNATURE_PLAINTEXT: Final = "PLAINTEXT"
SIGNATURE_TYPE_HEADER: Final = "HEADER"
SIGNATURE_TYPE_QUERY: Final = "QUERY"
SIGNATURE_TYPE_BODY: Final = "BODY"

def construct_base_string(method, uri, params, host=None) -> str: ...
def normalize_base_string_uri(uri, host=None): ...
def normalize_parameters(params) -> str: ...
def generate_signature_base_string(request) -> str: ...
def hmac_sha1_signature(base_string, client_secret, token_secret) -> str: ...
def rsa_sha1_signature(base_string, rsa_private_key) -> str: ...
def plaintext_signature(client_secret, token_secret) -> str: ...
def sign_hmac_sha1(client, request) -> str: ...
def sign_rsa_sha1(client, request) -> str: ...
def sign_plaintext(client, request) -> str: ...
def verify_hmac_sha1(request) -> bool: ...
def verify_rsa_sha1(request) -> bool: ...
def verify_plaintext(request) -> bool: ...
