from _typeshed import Incomplete

from networkx.utils.backends import _dispatch

__all__ = [
    "configuration_model",
    "directed_configuration_model",
    "expected_degree_graph",
    "havel_hakimi_graph",
    "directed_havel_hakimi_graph",
    "degree_sequence_tree",
    "random_degree_sequence_graph",
]

@_dispatch
def configuration_model(deg_sequence, create_using: Incomplete | None = None, seed: Incomplete | None = None): ...
@_dispatch
def directed_configuration_model(
    in_degree_sequence, out_degree_sequence, create_using: Incomplete | None = None, seed: Incomplete | None = None
): ...
@_dispatch
def expected_degree_graph(w, seed: Incomplete | None = None, selfloops: bool = True): ...
@_dispatch
def havel_hakimi_graph(deg_sequence, create_using: Incomplete | None = None): ...
@_dispatch
def directed_havel_hakimi_graph(in_deg_sequence, out_deg_sequence, create_using: Incomplete | None = None): ...
@_dispatch
def degree_sequence_tree(deg_sequence, create_using: Incomplete | None = None): ...
@_dispatch
def random_degree_sequence_graph(sequence, seed: Incomplete | None = None, tries: int = 10): ...

class DegreeSequenceRandomGraph:
    rng: Incomplete
    degree: Incomplete
    m: Incomplete
    dmax: Incomplete
    def __init__(self, degree, rng) -> None: ...
    remaining_degree: Incomplete
    graph: Incomplete
    def generate(self): ...
    def update_remaining(self, u, v, aux_graph: Incomplete | None = None) -> None: ...
    def p(self, u, v): ...
    def q(self, u, v): ...
    def suitable_edge(self): ...
    def phase1(self) -> None: ...
    def phase2(self) -> None: ...
    def phase3(self) -> None: ...
