import os
import sys
from _typeshed import FileDescriptor, Incomplete, ReadableBuffer
from collections.abc import Callable
from typing_extensions import Literal

def tp_read(fd: FileDescriptor, n: int) -> bytes: ...
def tp_write(fd: FileDescriptor, buf: ReadableBuffer) -> int: ...

if sys.platform != "win32":
    def make_nonblocking(fd: FileDescriptor) -> Literal[True] | None: ...
    def nb_read(fd: FileDescriptor, n: int) -> bytes: ...
    def nb_write(fd: FileDescriptor, buf: ReadableBuffer) -> int: ...
    fork = os.fork
    forkpty = os.forkpty
    def fork_gevent() -> int: ...
    def forkpty_gevent() -> tuple[int, int]: ...
    waitpid = os.waitpid
    def fork_and_watch(
        callback: Incomplete | None = None, loop: Incomplete | None = None, ref: bool = False, fork: Callable[[], int] = ...
    ) -> int: ...
    def forkpty_and_watch(
        callback: Incomplete | None = None,
        loop: Incomplete | None = None,
        ref: bool = False,
        forkpty: Callable[[], tuple[int, int]] = ...,
    ) -> tuple[int, int]: ...

    if sys.version_info >= (3, 8):
        posix_spawn = os.posix_spawn
        posix_spawnp = os.posix_spawnp
