from collections.abc import Callable
from typing import Any, Union
from typing_extensions import TypeAlias

from Xlib._typing import ErrorHandler, Unused
from Xlib.display import Display
from Xlib.protocol import rq
from Xlib.xobject import drawable, resource

_Update: TypeAlias = Callable[[Union[rq.DictWrapper, dict[str, Any]]], object]

extname: str
RedirectAutomatic: int
RedirectManual: int

class QueryVersion(rq.ReplyRequest): ...

def query_version(self: Display | resource.Resource) -> QueryVersion: ...

class RedirectWindow(rq.Request): ...

def redirect_window(self: drawable.Window, update: _Update, onerror: ErrorHandler[object] | None = ...) -> None: ...

class RedirectSubwindows(rq.Request): ...

def redirect_subwindows(self: drawable.Window, update: _Update, onerror: ErrorHandler[object] | None = ...) -> None: ...

class UnredirectWindow(rq.Request): ...

def unredirect_window(self: drawable.Window, update: _Update, onerror: ErrorHandler[object] | None = ...) -> None: ...

class UnredirectSubindows(rq.Request): ...

def unredirect_subwindows(self: drawable.Window, update: _Update, onerror: ErrorHandler[object] | None = ...) -> None: ...

class CreateRegionFromBorderClip(rq.Request): ...

def create_region_from_border_clip(self: drawable.Window, onerror: ErrorHandler[object] | None = ...) -> int: ...

class NameWindowPixmap(rq.Request): ...

def name_window_pixmap(self: Display | resource.Resource, onerror: ErrorHandler[object] | None = ...) -> drawable.Pixmap: ...

class GetOverlayWindow(rq.ReplyRequest): ...

def get_overlay_window(self: Display) -> GetOverlayWindow: ...
def init(disp: Display, info: Unused) -> None: ...
