from collections.abc import Callable
from typing import Any
from typing_extensions import TypeAlias

_MypyFile: TypeAlias = Any  # mypy.nodes.MypyFile
_AttributeContext: TypeAlias = Any  # mypy.plugin.AttributeContext
_ClassDefContext: TypeAlias = Any  # mypy.plugin.ClassDefContext
_DynamicClassDefContext: TypeAlias = Any  # mypy.plugin.DynamicClassDefContext
_Plugin: TypeAlias = Any  # mypy.plugin.Plugin
_Type: TypeAlias = Any  # mypy.types.Type

class SQLAlchemyPlugin(_Plugin):
    def get_dynamic_class_hook(self, fullname: str) -> Callable[[_DynamicClassDefContext], None] | None: ...
    def get_customize_class_mro_hook(self, fullname: str) -> Callable[[_ClassDefContext], None] | None: ...
    def get_class_decorator_hook(self, fullname: str) -> Callable[[_ClassDefContext], None] | None: ...
    def get_metaclass_hook(self, fullname: str) -> Callable[[_ClassDefContext], None] | None: ...
    def get_base_class_hook(self, fullname: str) -> Callable[[_ClassDefContext], None] | None: ...
    def get_attribute_hook(self, fullname: str) -> Callable[[_AttributeContext], _Type] | None: ...
    def get_additional_deps(self, file: _MypyFile) -> list[tuple[int, str, int]]: ...

def plugin(version: str) -> type[SQLAlchemyPlugin]: ...
