from collections.abc import Generator
from typing import Any

from .base import Alias, Descriptor

class Sequence(Descriptor):
    expected_type: Any
    seq_types: Any
    idx_base: int
    unique: bool
    def __set__(self, instance, seq) -> None: ...
    def to_tree(self, tagname, obj, namespace: Any | None = ...) -> Generator[Any, None, None]: ...

class ValueSequence(Sequence):
    attribute: str
    def to_tree(self, tagname, obj, namespace: Any | None = ...) -> Generator[Any, None, None]: ...
    def from_tree(self, node): ...

class NestedSequence(Sequence):
    count: bool
    def to_tree(self, tagname, obj, namespace: Any | None = ...): ...
    def from_tree(self, node): ...

class MultiSequence(Sequence):
    def __set__(self, instance, seq) -> None: ...
    def to_tree(self, tagname, obj, namespace: Any | None = ...) -> Generator[Any, None, None]: ...

class MultiSequencePart(Alias):
    expected_type: Any
    store: Any
    def __init__(self, expected_type, store) -> None: ...
    def __set__(self, instance, value) -> None: ...
    def __get__(self, instance, cls): ...
